#define KERNEL_FILE
#include                         "kernel.h"
//
PList Timers;
l_int TimerThreadId;
l_ubig ATime = 0;
PListItem LastDeleted = 0;
//
static void AClock ( void )
{
   ATime++;
} END_OF_STATIC_FUNCTION( AClock );
//
void TimersPoll ( void )
{
   PListItem a, n;
   //
   if ( !Timers->Last )
      return;
   //
   a = Timers->Last;
   //
   do
   {
      n = a->Next;
      //
      if ( TIMER( a->Data )->Enable && !TIMER( a->Data )->Running )
      {
         if ( ATime-TIMER( a->Data )->LastCall >= TIMER( a->Data )->Period )
         {
            TIMER( a->Data )->Running = TRUE;
			TIMER( a->Data )->LastCall = ATime;
            TIMER( a->Data )->Poll( TIMER( a->Data )->Args );
            TIMER( a->Data )->Running = FALSE;
         }
      }
      //
      a = n;
   } while ( a != Timers->Last );
}
//
void ThreadTimerWait( l_ubig Period )
{
   l_ubig LastCall = ATime;
   //
   while ( ATime-LastCall < Period )
   {
	  SysPoll();
   }
}
//
void TimerSetPeriod ( PTimer o, l_ubig Period )
{
   o->Period = Period;
}
//
PTimer NewTimer ( PApplication App, l_ubig Period, void ( *Poll )( void* ), void *Args )
{
   PTimer o = malloc( sizeof( TTimer ) );
   //
   if ( !o )
	  return NULL;
   //
   memset( o, 0, sizeof( TTimer ) );
   //
   o->App = App;
   o->Period = Period;
   o->LastCall= ATime;
   o->Poll = Poll;
   o->Args = Args;
   o->Enable = 1;
   ListAdd( Timers, NULL, o, &free );
   //
   return o;
}
//
void KillTimer ( PTimer o )
{
   PListItem i = ListFoundItem( Timers, o );
   //
   o->Enable = 0;
   //
   if ( i )
	  ListRemoveItem( Timers, i );
   LastDeleted = i;
}
//
void InitTimer ( void )
{
   MsgInit( "Inittimer" );
   //
   LOCK_VARIABLE( ATime );
   LOCK_FUNCTION( AClock );
   install_int( &AClock, 1 );
   Timers = NewList();
   //
   if ( !Timers )
   {
	  MsgInitErr();
	  DebugFatal( "ERROR_NOTENOUGHMEMORY" );
   }
   //
   SYSEXPORT( NewTimer );
   SYSEXPORT( KillTimer );
   SYSEXPORT( ThreadTimerWait );
   SYSEXPORT( ATime );
   MsgInitOk();
}
//
void ShutDownTimer ( void )
{
   MsgInit( "ShutDownTimer" );
   FreeList( Timers );
   MsgInitOk();
}
