#define KERNEL_FILE
#include                         "kernel.h"
//
PTask TaskList = NULL;
PTask LastTask = NULL;
//
void PollTasks( void )
{
   PTask p = TaskList;
   //
   while ( p )
   {
      if ( p->Enabled && !p->Running )
      {
         p->Running = TRUE;
         p->Task( p );
         p->Running = FALSE;
      }
      //
      p = p->Next;
   }
}
//
PTask InstallTask( void ( *Task )( PTask Task ) )
{
   PTask t 	= NEW( TTask );
   //
   t->Enabled	= TRUE;
   t->Task	= Task;
   t->Next	= NULL;
   t->Prev	= LastTask;
   //
   if ( !TaskList )
      TaskList = t;
   else
      LastTask->Next = t;
   //
   LastTask = t;
   //
   return t;
}
//
void RemoveTask( PTask Task )
{
   if ( !Task )
      return;
   //
   if ( Task->Prev )
      Task->Prev->Next = Task->Next;
   else
      TaskList = Task->Next;
   //
   if ( Task->Next )
	  Task->Next->Prev = Task->Prev;
   else
	  LastTask = Task->Prev;
   //
   free( Task );
}
