#include "kernel.h"
#include "registry.h"
#include "internal.h"

PRegKey MainKey = NULL;

void FreeKey( PRegKey o );

short RDSizes[12] = {
0, // RKT_NODATA
1, // RKT_CHAR
1, // RKT_BOOL
2, // RKT_SHORT
4, // RKT_INT
4, // RKT_LONG
8, // RKT_BIG
4, // RKT_FLOAT
8, // RKT_DOUBLE
16,// RKT_RECT
4, // RKT_POINT
0  // RKT_TEXT
};
////////////////////////////////////////////////////////////////////////////////
// Registry loader
////////////////////////////////////////////////////////////////////////////////

l_bool LoadRegistry ( void ) {
	l_ulong i = 0,Tmp;
	PRegKey Reg = NULL;
	PFile f = FileOpen("SYSTEM/REGS/xsystem.dat", "rb");
	TRegHead Head;

	if ( !f ) return false;

	if ( MainKey ) FreeKey(MainKey);


	FileRead(&Head,1,sizeof(Head),f);

	Reg = (PRegKey)malloc(Head.Keys*sizeof(TRegKey));

	memset(Reg,0,Head.Keys*sizeof(TRegKey));

	while ( i < Head.Keys ) {

		Reg[i].Name = FileReadBinString(f);
		FileRead(&(Reg[i].Type),1,1,f);

		if ( Reg[i].Type == RKT_TEXT )
		  Reg[i].Data = FileReadBinString(f);
	  else if ( Reg[i].Type == RKT_TEXT ) {
			FileRead(&Tmp,1,4,f);
			if ( Tmp ) Reg[i].Data = &(Reg[Tmp-1]);
		} else if ( Reg[i].Type ) {
			Reg[i].Data = malloc(RDSizes[Reg[i].Type]);
			FileRead(Reg[i].Data,1,RDSizes[Reg[i].Type],f);
		}

		FileRead(&Tmp,1,4,f);
		if ( Tmp ) Reg[i].Parent = &(Reg[Tmp-1]);
		FileRead(&Tmp,1,4,f);
		if ( Tmp ) Reg[i].Next = &(Reg[Tmp-1]);
		FileRead(&Tmp,1,4,f);
		if ( Tmp ) Reg[i].Prev = &(Reg[Tmp-1]);
		FileRead(&Tmp,1,4,f);
		if ( Tmp ) Reg[i].Last = &(Reg[Tmp-1]);
	  i++;
	}

	MainKey = Reg;
	MainKey->__e = 1;
	FileClose(f);
	return true;
}
////////////////////////////////////////////////////////////////////////////////
// Registry saving functions
////////////////////////////////////////////////////////////////////////////////
void GenerateTmpId ( PRegKey o, l_ulong *Id ) {
	o->TmpId = *Id;
	(*Id)++;
	if ( o->Last ) {
	  PRegKey a = o->Last;
	  PRegKey b = a;
	  do {
		  GenerateTmpId(a,Id);
		  a = a->Next;
	  } while ( a != b );
	}
}
////////////////////////////////////////////////////////////////////////////////
l_ulong Nothing = 0;
void WriteKey ( PFile f, PRegKey o ) {
	FileWriteBinString(f,o->Name);
	FileWrite(&(o->Type),1,1,f);
	if ( o->Type == RKT_TEXT )
		FileWriteBinString(f,o->Data);
	else if ( o->Type == RKT_LINK )
		FileWrite(&REGKEY(o->Data)->TmpId,1,4,f);
	else if ( o->Type )
		FileWrite(o->Data,1,RDSizes[o->Type],f);

	FileWrite(o->Parent?&o->Parent->TmpId:&Nothing,1,4,f);
	FileWrite(o->Next?&o->Next->TmpId:&Nothing,1,4,f);
	FileWrite(o->Prev?&o->Prev->TmpId:&Nothing,1,4,f);
	FileWrite(o->Last?&o->Last->TmpId:&Nothing,1,4,f);
	if ( o->Last ) {
	  PRegKey a = o->Last;
	  PRegKey b = a;
	  do {
		  WriteKey(f,a);
		  a = a->Next;
	  } while ( a != b );
	}
}
////////////////////////////////////////////////////////////////////////////////
void SaveRegistry ( void )
{
	TRegHead Head;
	PFile f = FileOpen("SYSTEM/REGS/xsystem.dat", "wb");
	if ( !f )
	   return;
	Head.Magic = NREGISTRY_MAGIC;
	Head.Keys = 1;
	GenerateTmpId(MainKey,&Head.Keys);
  Head.Keys--;
	FileWrite(&Head,1,sizeof(TRegHead),f);
	WriteKey(f,MainKey);
	FileClose(f);
}
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
PRegKey ResolveKeyEx ( l_text Name, PRegKey o ) {
	l_text S;
	PRegKey a = o->Last;
	PRegKey b = a;
	if ( o->Type == RKT_LINK ) o = (PRegKey)o->Data;
	if ( *Name=='\\' || *Name == '/' ) Name++;
	if ( !(*Name) ) return o;
	if ( !a ) return NULL;
	S = Name;
  while ( *S ) {
	  if ( *S=='\\' || *S == '/' ) {
		  do {
		    if ( !TextSqNCaseCompare(Name,a->Name,S-Name) ) return ResolveKeyEx( S+1,a);
		    a = a->Next;
	    } while ( a != b );
		//DebugMessage("Errrrr %s",Name);
	    return NULL;
	  }
	  S++;
  }

  do {
		if ( !TextCompare(Name,a->Name) ) return a;
		a = a->Next;
	} while ( a != b );
	return NULL;
}
////////////////////////////////////////////////////////////////////////////////
PRegKey ResolveKey ( l_text Name) {
	if ( DCkPt("ResolveKey.Name",Name) ) {
  	PRegKey o = ResolveKeyEx(Name,MainKey);
//	if ( !o )
//	   DebugWarning("REGISTRY : Unknow key %s", Name);
  	return o;
 	}
 	return NULL;
}
////////////////////////////////////////////////////////////////////////////////
l_bool KeyExists ( l_text Name ) {
  return 	ResolveKey(Name) ? true : false;
}
////////////////////////////////////////////////////////////////////////////////
void FreeKey( PRegKey o )
{
//	DebugMessage("Free Key [%s]",o->Name);
	if ( o->Data && o->Type != RKT_LINK && o->Type != RKT_NODATA )
	   free(o->Data);
	if ( o->Name )
	   free(o->Name);
	if ( o->Last )
	{
	  PRegKey a = o->Last;
	  PRegKey b = a, n;
	  //
	  do {
		  n = a->Next;
//	DebugMessage("\tFree Key [%s]",a->Name);
	if ( a->Data && a->Type != RKT_LINK && a->Type != RKT_NODATA )
	   free(a->Data);
	if ( a->Name )
	   free(a->Name);
//		  FreeKey(a);
		  a = n;
	  } while ( a != b );
	}
	if ( o->__e )
	   free(o);
}
////////////////////////////////////////////////////////////////////////////////
void DeleteKeyEx( PRegKey o ) {
	PRegKey p;
	if ( !o ) return;
	if ( !o->Parent ) return;
	p = o->Parent;
	if ( o->Next == o ) {
	  p->Last = NULL;
  } else {
	  o->Next->Prev = o->Prev;
	  o->Prev->Next = o->Next;
	  if ( p->Last == o ) p->Last = o->Prev;
  }
	FreeKey(o);
}
////////////////////////////////////////////////////////////////////////////////
void DeleteKey( l_text Name ) {
  DeleteKeyEx(ResolveKey(Name));
}
////////////////////////////////////////////////////////////////////////////////
PRegKey NewKeyEx ( PRegKey p, l_text Name ) {
	PRegKey o ;
	if ( !p ) return 0;
	if ( ResolveKeyEx(Name,p) ) {
		DebugWarning("REGISTRY : Key %s do already exists",Name);
		return 0;
	}
	o = malloc(sizeof(TRegKey));
	if ( !o ) {
		DebugError("REGISTRY : Not enough memory to create key %s",Name);
		return 0;
	}
	memset(o,0,sizeof(TRegKey));
	o->Type = RKT_NODATA;
	o->Name   = TextDup(Name);
	if ( !o->Name ) {
		free(o);
		DebugError("REGISTRY : Not enough memory to create key %s",Name);
		return 0;
	}
	o->Parent = p;
	if ( p->Last ) {
		o->Next = p->Last->Next;
		o->Prev = p->Last;
		p->Last->Next->Prev = o;
		p->Last->Next = o;
		p->Last = o;
  } else {
	  o->Next = o;
	  o->Prev = o;
	  p->Last = o;
  }
  o->__e = 1;

	return o;
}
////////////////////////////////////////////////////////////////////////////////
l_uchar NewKey ( l_text Parent, l_text Name ) {
	PRegKey p = GetOrCreateKey(Parent);
	if ( !p ) return 0;
	if ( NewKeyEx(p,Name) ) return 1;
	return 0;
}
////////////////////////////////////////////////////////////////////////////////
PRegKey GetOrCreateKeyEx ( PRegKey o, l_text Name )
{
	l_text S,t;
	PRegKey a = o->Last;
	PRegKey b = a;
	//
	if ( o->Type == RKT_LINK )
	   o = (PRegKey)o->Data;
	if ( *Name=='\\' || *Name == '/' )
	   Name++;
	if ( !(*Name) )
	   return o;

	S = Name;
  while ( *S ) {
	  if ( *S=='\\' || *S == '/' )
	  {
			if ( a ) do
			{
			if ( !TextSqNCaseCompare(Name,a->Name,S-Name) )
			   return GetOrCreateKeyEx(a,S+1);
		    a = a->Next;
	    } while ( a != b );
	    t = TextNDup(Name,S-Name);

	    a = NewKeyEx(o,t);
	    return GetOrCreateKeyEx(a,S+1);
	  }
	  S++;
  }

  if ( a ) do {
		if ( !TextCompare(Name,a->Name) ) return a;
		a = a->Next;
	} while ( a != b );

	return NewKeyEx(o,Name);
}
////////////////////////////////////////////////////////////////////////////////
PRegKey GetOrCreateKey ( l_text key ) {
	return GetOrCreateKeyEx(MainKey,key);
}
////////////////////////////////////////////////////////////////////////////////
void CreateKey ( l_text key )
{
	GetOrCreateKeyEx(MainKey,key);
}
////////////////////////////////////////////////////////////////////////////////
l_uchar RenameKey ( l_text Key, l_text NewName ) {
	PRegKey o = ResolveKey(Key);
	if ( !o ) return 0;
	if ( o->Name )  free(o->Name);
	o->Name   = TextDup(NewName);
	return 1;
}
////////////////////////////////////////////////////////////////////////////////
l_text _GetKeyName ( PRegKey o )
{
	if ( !o->Parent )
	{
		return TextDup("/");
	}
	else
	{
		l_text KName = TextDup("");
		l_text OName;
		while ( o->Parent )
		{
			OName = KName;
			KName = FileNameToPath(o->Name,OName);
			free(OName);
			o = o->Parent;
		}
		return KName;
	}
}
////////////////////////////////////////////////////////////////////////////////
l_text GetParentKeyName ( l_text Key ) {
	l_text n;
	PRegKey o = ResolveKey(Key);
	if ( !o ) return NULL;
	if ( !o->Parent ) return NULL;
	n = _GetKeyName(o->Parent);
	DebugMessage("REGISTRY : %s parent is %s",key,n);
	return n;
}
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
l_bool KeySetData ( l_text Name, l_uchar Type, void *Data ) {
	PRegKey o = GetOrCreateKey(Name);
	if ( !o ) return false;
	if ( o->Data && o->Type != RKT_LINK ) {
		free(o->Data);
	  o->Data = NULL;
	}
	o->Type = Type;
	if ( Type == RKT_LINK ) {
		o->Data = Data;
	} else if ( Type ) {
		if ( Type == RKT_TEXT ) {
			o->Data = TextDup((l_text)Data);
		} else {
			o->Data = malloc(RDSizes[Type]);
			memcpy(o->Data,Data,RDSizes[Type]);
		}
		if ( !o->Data ) {
			DebugError("REGISTRY : Not enough memory to set data into key %s",Name);
			return false;
		}
	}

	return true;
}
////////////////////////////////////////////////////////////////////////////////
void *KeyGetData( l_text Name, l_uchar Type, void *Def ) {
	PRegKey o = ResolveKey(Name);
	if ( !o ) return Def;
	if ( o->Type != Type ) return Def;
	return o->Data;
}
////////////////////////////////////////////////////////////////////////////////
l_bool KeySetText ( l_text Name, l_text Val ) {
	return KeySetData(Name,RKT_TEXT,Val);
}
////////////////////////////////////////////////////////////////////////////////
l_bool KeySetNothing ( l_text Name ) {
	return KeySetData(Name,0,0);
}
////////////////////////////////////////////////////////////////////////////////
l_text KeyGetText ( l_text Name, l_text Def ) {
	return KeyGetData(Name,RKT_TEXT,Def);
}
////////////////////////////////////////////////////////////////////////////////
l_bool KeySetLong ( l_text Name, l_long Val ) {
	return KeySetData(Name,RKT_LONG,&Val);
}
////////////////////////////////////////////////////////////////////////////////
l_long KeyGetLong ( l_text Name, l_long Def ) {
	return *((l_long*)KeyGetData(Name,RKT_LONG,&Def));
}
////////////////////////////////////////////////////////////////////////////////

l_bool KeySetChar ( l_text Name, l_char Val ) {
	return KeySetData(Name,RKT_CHAR,&Val);
}
////////////////////////////////////////////////////////////////////////////////
l_char KeyGetChar ( l_text Name, l_char Def ) {
	return *((l_char*)KeyGetData(Name,RKT_CHAR,&Def));
}
////////////////////////////////////////////////////////////////////////////////
l_bool KeySetBool ( l_text Name, l_bool Val ) {
	return KeySetData(Name,RKT_BOOL,&Val);
}
////////////////////////////////////////////////////////////////////////////////
l_bool KeyGetBool ( l_text Name, l_bool Def ) {
	return *((l_bool*)KeyGetData(Name,RKT_BOOL,&Def));
}
////////////////////////////////////////////////////////////////////////////////
l_bool KeySetShort ( l_text Name, l_short Val ) {
	return KeySetData(Name,RKT_SHORT,&Val);
}
////////////////////////////////////////////////////////////////////////////////
l_short KeyGetShort ( l_text Name, l_short Def ) {
	return *((l_short*)KeyGetData(Name,RKT_SHORT,&Def));
}
////////////////////////////////////////////////////////////////////////////////
l_bool KeySetInt ( l_text Name, l_int Val ) {
	return KeySetData(Name,RKT_INT,&Val);
}
////////////////////////////////////////////////////////////////////////////////
l_int KeyGetInt ( l_text Name, l_int Def ) {
	return *((l_int*)KeyGetData(Name,RKT_INT,&Def));
}
////////////////////////////////////////////////////////////////////////////////
l_bool KeySetBig ( l_text Name, l_ubig Val ) {
	return KeySetData(Name,RKT_BIG,&Val);
}
////////////////////////////////////////////////////////////////////////////////
l_ubig KeyGetBig ( l_text Name, l_ubig Def ) {
	return *((l_ubig*)KeyGetData(Name,RKT_BIG,&Def));
}
////////////////////////////////////////////////////////////////////////////////
l_int GetColorFromHex ( l_text Code ) {
	if ( TextLen(Code) == 6 ) {
		l_int c = strtol(Code, NULL, 16);
		return makecol((c >> 16) & 0xFF,(c >> 8) & 0xFF,c & 0xFF);
	}
	return 0;
}
////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

void RegistryRunEntries ( l_text Name ) {
  PRegKey o =	ResolveKey(Name);
	if ( !o ) return;
  DebugMessage("Run registry entries form %s",Name);
	if ( o->Last ) {
		PRegKey a = o->Last->Next;
	  PRegKey b = a;
	  do {
		  if ( a->Type == RKT_TEXT )
		  	DynLdRun((l_text)a->Data,NULL);
		  a = a->Next;
	  } while ( a != b );
  }
}

void RegistryReLoad ( void ) {
	DebugMessage("ReLoading registry...");
	LoadRegistry();
	DebugMessage("Done.");
}

void RegistrySave ( void ) {

	DebugMessage("Saving registry...");
	SaveRegistry();
	DebugMessage("Done.");
}

void NRegistryInit ( void )
{
	l_bool Generate = false;
	//
	MsgInit("NRegistryInit");
	//
	DebugMessage("Loading registry...");
	//
	if ( KernelMode != KERNEL_RESETUP )
	{
		if ( !LoadRegistry() )
			Generate = true;
	} else
		Generate = true;

	if ( Generate ) {

		DebugMessage("Registry file not found. Set default registry");
		MainKey = malloc(sizeof(TRegKey));
		if ( !MainKey )
			DebugFatal("REGISTRY: Not enough memory");
		memset(MainKey,0,sizeof(TRegKey));
		MainKey->Name = TextDup("WinDos");
		if ( !MainKey->Name ) {
			free(MainKey);
			DebugFatal("REGISTRY: Not enough memory");
		}
		KeySetText("/SYSTEM/LIBRARIES/pci","dlls/pci.wdl");
		KeySetText("/SYSTEM/LIBRARIES/bmp","dlls/bmp.wdl");
		KeySetText("/SYSTEM/LIBRARIES/png","dlls/png.wdl");
		KeySetText("/SYSTEM/LIBRARIES/grfx","dlls/grfx.wdl");
		KeySetText("/SYSTEM/LIBRARIES/clipbrd","dlls/clipbrd.wdl");
		KeySetText("/SYSTEM/LIBRARIES/skin","dlls/skin.wdl");
		KeySetText("/SYSTEM/LIBRARIES/widget","dlls/widget.wdl");
		KeySetText("/SYSTEM/LIBRARIES/button","dlls/button.wdl");
		KeySetText("/SYSTEM/LIBRARIES/label","dlls/label.wdl");
		KeySetText("/SYSTEM/LIBRARIES/progress","dlls/progress.wdl");
		KeySetText("/SYSTEM/LIBRARIES/checkbox","dlls/checkbox.wdl");
		KeySetText("/SYSTEM/LIBRARIES/menu","dlls/menu.wdl");
		KeySetText("/SYSTEM/LIBRARIES/canvas","dlls/canvas.wdl");
		KeySetText("/SYSTEM/LIBRARIES/scrllbar","dlls/scrllbar.wdl");
		KeySetText("/SYSTEM/LIBRARIES/textbox","dlls/textbox.wdl");
		KeySetText("/SYSTEM/LIBRARIES/window","dlls/window.wdl");
		KeySetText("/SYSTEM/LIBRARIES/listbox","dlls/listbox.wdl");
		KeySetText("/SYSTEM/LIBRARIES/treeview","dlls/treeview.wdl");
		KeySetText("/SYSTEM/LIBRARIES/groupbox","dlls/groupbox.wdl");
		KeySetText("/SYSTEM/LIBRARIES/slider","dlls/slider.wdl");
		KeySetText("/SYSTEM/LIBRARIES/listview","dlls/listview.wdl");
		KeySetText("/SYSTEM/LIBRARIES/combobox","dlls/combobox.wdl");
		KeySetText("/SYSTEM/LIBRARIES/toolbar","dlls/toolbar.wdl");
		KeySetText("/SYSTEM/LIBRARIES/fms2","dlls/fms2.wdl");
		KeySetText("/SYSTEM/LIBRARIES/iodlg","dlls/iodlg.wdl");
		KeySetText("/SYSTEM/LIBRARIES/tabbook","dlls/tabbook.wdl");
		KeySetText("/SYSTEM/LIBRARIES/cp","dlls/cp.wdl");
		KeySetText("/SYSTEM/LIBRARIES/sound","dlls/sound.wdl");
		KeySetText("/SYSTEM/LIBRARIES/mp3","dlls/mp3.wdl");
		KeySetText("/SYSTEM/LIBRARIES/memfile","dlls/memfile.wdl");

		CreateKey("/SYSTEM/MSDOS/CHECK");
		KeySetInt("/SYSTEM/MSDOS/CHECK",0);

		CreateKey("/SYSTEM/BASICDRIVERS/bmp");
		CreateKey("/SYSTEM/BASICDRIVERS/png");
		CreateKey("/SYSTEM/BASICDRIVERS/mp3");
		CreateKey("/SYSTEM/BASICDRIVERS/pci");
/*		CreateKey("/SYSTEM/BASICDRIVERS/gif");
		CreateKey("/SYSTEM/BASICDRIVERS/tif");
		CreateKey("/SYSTEM/BASICDRIVERS/vid");
		CreateKey("/SYSTEM/BASICDRIVERS/pgm");
		CreateKey("/SYSTEM/BASICDRIVERS/ppm");
		CreateKey("/SYSTEM/BASICDRIVERS/iax");
		CreateKey("/SYSTEM/BASICDRIVERS/xbm");
		CreateKey("/SYSTEM/BASICDRIVERS/pse"); */

		CreateKey("/SYSTEM/DRIVERS/grfx");
		CreateKey("/SYSTEM/DRIVERS/clipbrd");
		CreateKey("/SYSTEM/DRIVERS/sound");
		
		CreateKey("/SYSTEM/AUTOLIB/skin");
		CreateKey("/SYSTEM/AUTOLIB/widget");
		CreateKey("/SYSTEM/AUTOLIB/button");
		CreateKey("/SYSTEM/AUTOLIB/label");
		CreateKey("/SYSTEM/AUTOLIB/progress");
		CreateKey("/SYSTEM/AUTOLIB/checkbox");
		CreateKey("/SYSTEM/AUTOLIB/menu");
		CreateKey("/SYSTEM/AUTOLIB/canvas");
		CreateKey("/SYSTEM/AUTOLIB/scrllbar");
		CreateKey("/SYSTEM/AUTOLIB/textbox");
		CreateKey("/SYSTEM/AUTOLIB/window");
		CreateKey("/SYSTEM/AUTOLIB/listbox");
		CreateKey("/SYSTEM/AUTOLIB/treeview");
		CreateKey("/SYSTEM/AUTOLIB/groupbox");
		CreateKey("/SYSTEM/AUTOLIB/slider");
		CreateKey("/SYSTEM/AUTOLIB/listview");
		CreateKey("/SYSTEM/AUTOLIB/combobox");
		CreateKey("/SYSTEM/AUTOLIB/toolbar");
		CreateKey("/SYSTEM/AUTOLIB/fms2");
		CreateKey("/SYSTEM/AUTOLIB/iodlg");
		CreateKey("/SYSTEM/AUTOLIB/tabbook");
		CreateKey("/SYSTEM/AUTOLIB/cp");

		// Programas a ejecutar una ves iniciado WinDos.
		CreateKey("/SYSTEM/STARTUP/cron");
		KeySetText("/SYSTEM/STARTUP/cron","programs/cron.wde");
		//
		CreateKey("/SYSTEM/STARTUP/rwdss");
		KeySetText("/SYSTEM/STARTUP/rwdss","programs/rwdss.wde");
		//
		KeySetText("/SYSTEM/STARTUP/desktop","programs/desktop.wde");
		//
		KeySetInt("/SYSTEM/MOUSE/speed", 0);
		KeySetInt("/SYSTEM/MOUSE/dblclk", 4);
		KeySetText("/SYSTEM/MOUSE/CURSORS/arrow","SYSTEM/CURSORS/arrow.cur");
		KeySetText("/SYSTEM/MOUSE/CURSORS/beam","SYSTEM/CURSORS/beam.cur");
		KeySetText("/SYSTEM/MOUSE/CURSORS/busy","SYSTEM/CURSORS/busy.cur");
		KeySetText("/SYSTEM/MOUSE/CURSORS/cross","SYSTEM/CURSORS/cross.cur");
		KeySetText("/SYSTEM/MOUSE/CURSORS/help","SYSTEM/CURSORS/help.cur");
		KeySetText("/SYSTEM/MOUSE/CURSORS/move","SYSTEM/CURSORS/move.cur");
		KeySetText("/SYSTEM/MOUSE/CURSORS/no","SYSTEM/CURSORS/no.cur");
		KeySetText("/SYSTEM/MOUSE/CURSORS/pen","SYSTEM/CURSORS/pen.cur");
		KeySetText("/SYSTEM/MOUSE/CURSORS/size1","SYSTEM/CURSORS/size1.cur");
		KeySetText("/SYSTEM/MOUSE/CURSORS/size2","SYSTEM/CURSORS/size2.cur");
		KeySetText("/SYSTEM/MOUSE/CURSORS/size3","SYSTEM/CURSORS/size3.cur");
		KeySetText("/SYSTEM/MOUSE/CURSORS/size4","SYSTEM/CURSORS/size4.cur");
		KeySetText("/SYSTEM/MOUSE/CURSORS/up","SYSTEM/CURSORS/up.cur");
		KeySetText("/SYSTEM/MOUSE/CURSORS/wait","SYSTEM/CURSORS/wait.cur");

		KeySetInt("/SYSTEM/SCREEN/WIDTH",800);
		KeySetInt("/SYSTEM/SCREEN/HEIGHT",600);
		KeySetInt("/SYSTEM/SCREEN/DEPTH",16);
		KeySetInt("/SYSTEM/SCREEN/REFRESH",75);

		KeySetText("/SYSTEM/KEYBOARD/LAYOUTS","SYSTEM/KEYBOARD/es.wkl");

		KeySetText("/SYSTEM/FONTS","SYSTEM/FONTS/pc6x8.fnt");

		CreateKey("/USER/STARTUP");

		KeySetText("/USER/DESKTOP/color", "3D61AD");
		KeySetInt ("/USER/DESKTOP/alignment", 2);
		KeySetText("/USER/DESKTOP/wallpaper", "start.png");
		KeySetText("/USER/DESKTOP/theme", "./DESKTOP/plex.ini");

		KeySetText("/USER/COLOR/OSD", "FFFFFF");

		CreateKey("/SYSTEM/FMS");
		CreateKey("/SYSTEM/DMS");

		KeySetInt("/SYSTEM/DMS/Extentions/ln", 0x00000007);
		KeySetText("/SYSTEM/DMS/Codecs/Codecs/00000007","Links");
		KeySetInt("/SYSTEM/DMS/Codecs/Codecs/00000007/FavoriteType",0x00000007);
		KeySetText("/SYSTEM/DMS/Codecs/Codecs/00000007/text","GenericText");
		KeySetInt("/SYSTEM/DMS/Codecs/Codecs/00000007/link",0x00000007);


		KeySetInt("/SYSTEM/DMS/Extentions/wdl", 0x44796e4c);
		KeySetInt("/SYSTEM/DMS/Extentions/wde", 0x44796e4c);

		KeySetText("/SYSTEM/DMS/Codecs/Codecs/44796e4c","DynLd executales");
		KeySetInt("/SYSTEM/DMS/Codecs/Codecs/44796e4c/virtual",0x44796e4c);
		KeySetText("/SYSTEM/DMS/Codecs/Codecs/44796e4c/binary","GenericBinary");
		KeySetInt("/SYSTEM/DMS/Codecs/Codecs/44796e4c/FavoriteType",0x44796e4c);

		KeySetInt("/SYSTEM/DMS/Extentions/exe", 0x44457865);
		KeySetInt("/SYSTEM/DMS/Extentions/com", 0x44457865);
		KeySetText("/SYSTEM/DMS/Codecs/Codecs/44457865","Dos executable");
		KeySetInt("/SYSTEM/DMS/Codecs/Codecs/44457865/virtual",0x44457865);
		KeySetText("/SYSTEM/DMS/Codecs/Codecs/44457865/binary","GenericBinary");
		KeySetInt("/SYSTEM/DMS/Codecs/Codecs/44457865/FavoriteType",0x44457865);

		KeySetText("/SYSTEM/FMS/44457865", "Dos execultable");
		KeySetText("/SYSTEM/FMS/44457865/Icon16", "./system/ICONS/app16.bmp");
		KeySetText("/SYSTEM/FMS/44457865/Icon32", "./system/ICONS/app32.bmp");

		CreateKey ("/SYSTEM/FMS/44457865/Actions");
		KeySetText("/SYSTEM/FMS/44457865/Actions/Execute", "./programs/rundos.wde");
		KeySetInt ("/SYSTEM/FMS/44457865/Actions/Execute/FavoriteWeight", 0xFFFFFFF);

		KeySetInt("/SYSTEM/DMS/Extentions/&folder", 0x44697220);
		KeySetText("/SYSTEM/DMS/Codecs/Codecs/44697220","Directory (VFile)");
		KeySetText("/SYSTEM/DMS/Codecs/Codecs/44697220/Icon16", "./system/ICONS/folder16.bmp");
		KeySetText("/SYSTEM/DMS/Codecs/Codecs/44697220/Icon32", "./system/ICONS/folder32.bmp");
		KeySetInt("/SYSTEM/DMS/Codecs/Codecs/44697220/virtual",0x44697220);
		KeySetInt("/SYSTEM/DMS/Codecs/Codecs/44697220/FavoriteType",0x44697220);


		KeySetInt("/SYSTEM/DMS/Extentions/&hdd", 0x48444420);
		KeySetText("/SYSTEM/DMS/Codecs/Codecs/48444420","Hard Drive (VFile)");
		KeySetText("/SYSTEM/DMS/Codecs/Codecs/48444420/Icon16", "./system/ICONS/drive16.bmp");
		KeySetText("/SYSTEM/DMS/Codecs/Codecs/48444420/Icon32", "./system/ICONS/drive32.bmp");
		KeySetInt("/SYSTEM/DMS/Codecs/Codecs/48444420/virtual",0x44697220);
		KeySetInt("/SYSTEM/DMS/Codecs/Codecs/48444420/FavoriteType",0x44697220);

		KeySetText("/SYSTEM/FMS/44697220", "Directory");
		KeySetText("/SYSTEM/FMS/44697220/Icon16", "./system/ICONS/folder16.bmp");
		KeySetText("/SYSTEM/FMS/44697220/Icon32", "./system/ICONS/folder32.bmp");

		CreateKey ("/SYSTEM/FMS/44697220/Actions");
		KeySetText("/SYSTEM/FMS/44697220/Actions/Open", "./programs/nav.wde");
		KeySetInt ("/SYSTEM/FMS/44697220/Actions/Open/FavoriteWeight", 0xFFFFFFF);

		KeySetText("/SYSTEM/FMS/00000003", "Image");
		KeySetText("/SYSTEM/FMS/00000003/Icon16", "./system/ICONS/img16.bmp");
		KeySetText("/SYSTEM/FMS/00000003/Icon32", "./system/ICONS/img32.bmp");
		CreateKey ("/SYSTEM/FMS/00000003/Actions");
		KeySetText("/SYSTEM/FMS/00000003/Actions/Open", "./programs/immagine.wde");
		KeySetInt ("/SYSTEM/FMS/00000003/Actions/Open/FavoriteWeight", 0xFFFFFFF);

		KeySetText("/SYSTEM/FMS/00000009", "Audio");
		KeySetText("/SYSTEM/FMS/00000009/Icon16", "./system/ICONS/snd16.bmp");
		KeySetText("/SYSTEM/FMS/00000009/Icon32", "./system/ICONS/snd32.bmp");
		CreateKey ("/SYSTEM/FMS/00000009/Actions");
		KeySetText("/SYSTEM/FMS/00000009/Actions/Open", "./programs/ssplay.wde");
		KeySetInt ("/SYSTEM/FMS/00000009/Actions/Open/FavoriteWeight", 0xFFFFFFF);

		KeySetInt("/SYSTEM/DMS/Extentions/txt", 0x00000001);
		KeySetText("/SYSTEM/DMS/Codecs/Codecs/00000001","Text file");
		KeySetText("/SYSTEM/DMS/Codecs/Codecs/00000001/text","GenericText");
		KeySetText("/SYSTEM/DMS/Codecs/Codecs/00000001/binary","GenericBinary");
		KeySetInt("/SYSTEM/DMS/Codecs/Codecs/00000001/FavoriteType",0x00000001);

		KeySetText("/SYSTEM/FMS/00000001", "Text");
		KeySetText("/SYSTEM/FMS/00000001/Icon16", "./system/ICONS/txt16.bmp");
		KeySetText("/SYSTEM/FMS/00000001/Icon32", "./system/ICONS/txt32.bmp");
		CreateKey ("/SYSTEM/FMS/00000001/Actions");
		KeySetText("/SYSTEM/FMS/00000001/Actions/Open", "./programs/notepad.wde");
		KeySetInt ("/SYSTEM/FMS/00000001/Actions/Open/FavoriteWeight", 0xFFFFFFF);

		KeySetText("/SYSTEM/FMS/00000006", "Ressource");
		KeySetText("/SYSTEM/FMS/00000006/Icon16", "./system/ICONS/res16.bmp");
		KeySetText("/SYSTEM/FMS/00000006/Icon32", "./system/ICONS/res32.bmp");
		CreateKey ("/SYSTEM/FMS/00000006/Actions");
		KeySetText("/SYSTEM/FMS/00000006/Actions/Open", "./programs/resedit.wde");
		KeySetInt ("/SYSTEM/FMS/00000006/Actions/Open/FavoriteWeight", 0xFFFF);
	}

	SYSEXPORT(RegistryReLoad);
	SYSEXPORT(RegistrySave);
	SYSEXPORT(ResolveKey);
	SYSEXPORT(KeyExists);
	SYSEXPORT(NewKey);
	SYSEXPORT(DeleteKey);
	SYSEXPORT(DeleteKeyEx);
	SYSEXPORT(KeySetText);
	SYSEXPORT(KeyGetText);
	SYSEXPORT(KeySetLong);
	SYSEXPORT(KeyGetLong);
	SYSEXPORT(KeySetChar);
	SYSEXPORT(KeyGetChar);
	SYSEXPORT(KeySetBool);
	SYSEXPORT(KeyGetBool);
	SYSEXPORT(KeySetShort);
	SYSEXPORT(KeyGetShort);
	SYSEXPORT(KeySetInt);
	SYSEXPORT(KeyGetInt);
	SYSEXPORT(KeySetBig);
	SYSEXPORT(KeyGetBig);
	SYSEXPORT(KeySetNothing);
	SYSEXPORT(GetParentKeyName);
	SYSEXPORT(RenameKey);
	SYSEXPORT(CreateKey);
	SYSEXPORT(GetOrCreateKey);
	SYSEXPORT(GetColorFromHex);
	DebugMessage("Registry loaded");
	MsgInitOk();
}

void NRegistryUnInit ( void )
{
	MsgInit("NRegistryUnInit");
	DebugMessage("Saving registry...");
	SaveRegistry();
	DebugMessage("Registry saved");
	FreeKey(MainKey);
	DebugMessage("Registry freed");
	MsgInitOk();
}


