#include <WinDos.h>
//
l_ulong AppVersion	= ULONG_ID(0,0,0,1);
char AppName[]		= "Dialog Calc";
l_uid	nUID		= "dCalc";
l_uid NeededLibs[]	= { "allegui", "" };
//
#define SIN    1
#define COS    2
#define TAN    3
#define ASIN   4
#define ACOS   5
#define ATAN   6
#define SQRT   7
//
#define ADD    1
#define SUB    2
#define MUL    3
#define DIV    4
//
char calc_str[80];
//
fixed calc_value;
int calc_operation;
int calc_clear_flag;
//
extern DIALOG calculator[];
//
#define CALC_STR  3
//


void redraw(DIALOG *d)
{
   ObjectMessage(calculator+CALC_STR, MSG_DRAW, 0);

   if (d)
      ObjectMessage(d, MSG_DRAW, 0);
}

//

void reset_calc(void)
{
   calc_value = 0;
   calc_operation = 0;
   calc_clear_flag = FALSE;
}

//

fixed get_calc_value(void)
{
   double d = atof(calc_str);
   return ftofix(d);
}

//

void set_calc_value(fixed v)
{
   int c, l;
   int has_dot;
   char b[80];
   double d = fixtof(v);

   sprintf(b, "%.8f", d);

   l = 0;
   has_dot = FALSE;

   for (c=0; b[c]; c++) {
      if ((b[c] >= '0') && (b[c] <= '9')) {
	 l++;
	 if (l > 8) {
	    b[c] = 0;
	    break;
	 }
      }
      else
	 if (b[c] == '.')
	    has_dot = TRUE;
   }

   if (has_dot) {
      for (c=c-1; c>=0; c--) {
	 if (b[c] == '0')
	    b[c] = 0;
	 else {
	    if (b[c] == '.')
	       b[c] = 0;
	    break;
	 }
      }
   }

   if (errno)
      sprintf(calc_str, "-E- (%s)", b);
   else
      strcpy(calc_str, b);

   errno = 0;
}
//
int input_proc(int msg, DIALOG *d, int c)
{
   int c1, c2;
   char *s = d->dp;
   int ret = ButtonProcedure(msg, d, c);

   if (ret == D_CLOSE) {
      if ((calc_clear_flag) && (s[0] != '+'))
	 strcpy(calc_str, "0");
      else if (strncmp(calc_str, "-E-", 3) == 0) {
	 redraw(d);
	 return D_O_K;
      }

      calc_clear_flag = FALSE;

      if (s[0] == '.') {
	 for (c1=0; calc_str[c1]; c1++)
	    if (calc_str[c1] == '.')
	       break;

	 if (!calc_str[c1])
	    strcat(calc_str, ".");
      }
      else if (s[0] == '+') {
	 if (calc_str[0] == '-')
	    memmove(calc_str, calc_str+1, strlen(calc_str+1)+1);
	 else {
	    memmove(calc_str+1, calc_str, strlen(calc_str)+1);
	    calc_str[0] = '-';
	 }
      }
      else {
	 if (strcmp(calc_str, "0") == 0)
	    calc_str[0] = 0;
	 else if (strcmp(calc_str, "-0") == 0)
	    strcpy(calc_str, "-");

	 c2 = 0;
	 for (c1=0; calc_str[c1]; c1++)
	    if ((calc_str[c1] >= '0') && (calc_str[c1] <= '9'))
	       c2++;

	 if (c2 < 8)
	    strcat(calc_str, s);
      }

      redraw(d);
      return D_O_K;
   }

   return ret;
}

//

int unary_operator(int msg, DIALOG *d, int c)
{
   fixed x;
   int ret = ButtonProcedure(msg, d, c);

   if (ret == D_CLOSE) {
      x = get_calc_value();

      switch (d->d1) {

	 case SIN:
	    x = fixsin(x);
	    break;

	 case COS:
	    x = fixcos(x);
	    break;

	 case TAN:
	    x = fixtan(x);
	    break;

	 case ASIN:
	    x = fixasin(x);
	    break;

	 case ACOS:
	    x = fixacos(x);
	    break;

	 case ATAN:
	    x = fixatan(x);
	    break;

	 case SQRT:
	    x = fixsqrt(x);
	    break;
      }

      set_calc_value(x);
      calc_clear_flag = TRUE;

      redraw(d);
      return D_O_K;
   }

   return ret;
}

//

int work_out(void)
{
   fixed x;

   x = get_calc_value();

   switch (calc_operation) {

      case ADD:
	 x = fixadd(calc_value, x);
	 break;

      case SUB:
	 x = fixsub(calc_value, x);
	 break;

      case MUL:
	 x = fixmul(calc_value, x);
	 break;

      case DIV:
	 x = fixdiv(calc_value, x);
	 break;
   }

   set_calc_value(x);
   reset_calc();
   calc_clear_flag = TRUE;

   redraw(NULL);
   return D_O_K;
}

//

int equals_proc(int msg, DIALOG *d, int c)
{
   int ret = ButtonProcedure(msg, d, c);

   if (ret == D_CLOSE) {
      ret = work_out();
      redraw(d);
   }

   return ret;
}

//

int binary_operator(int msg, DIALOG *d, int c)
{
   int ret = ButtonProcedure(msg, d, c);

   if (ret == D_CLOSE) {
      work_out();

      calc_value = get_calc_value();
      calc_operation = d->d1;
      calc_clear_flag = TRUE;

      redraw(d);
      return D_O_K;
   }

   return ret;
}

//

int clearer(void)
{
   reset_calc();
   strcpy(calc_str, "0");
   redraw(NULL);
   return D_O_K;
}

int clear_proc(int msg, DIALOG *d, int c)
{
   int ret = ButtonProcedure(msg, d, c);

   if (ret == D_CLOSE) {
      ret = clearer();
      redraw(d);
   }

   return ret;
}

//

DIALOG calculator[] =
{
   /* (dialog proc)      (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)     (d2)           (dp)        (dp2) (dp3) */
   { WindowProcedure,     0,    0,   193,  193,  255,  8,    0,    0,       0,       0, "Calculadora", NULL,  NULL  },
   { GroupBoxProcedure,   8,   30,   177,  21,   16,   255,  0,    0,       0,       0,             NULL,       NULL, NULL  },
   { GroupBoxProcedure,  10,   32,   173,  17,   255,  16,   0,    0,       0,       0,             NULL,       NULL, NULL  },
   { RightTextProcedure, 24,   36,   144,  8,    255,  0,   0,    0,       0,       0,             calc_str,   NULL, NULL  },

   { unary_operator,     16,   68,    49,   13,   16,   255,  0,    D_EXIT,  SIN,     0,             "sin",      NULL, NULL  },
   { unary_operator,     72,   68,    49,   13,   16,   255,  0,    D_EXIT,  COS,     0,             "cos",      NULL, NULL  },
   { unary_operator,     128,  68,    49,   13,   16,   255,  0,    D_EXIT,  TAN,     0,             "tan",      NULL, NULL  },

   { unary_operator,     16,   84,    49,   13,   16,   255,  0,    D_EXIT,  ASIN,    0,             "asin",     NULL, NULL  },
   { unary_operator,     72,   84,    49,   13,   16,   255,  0,    D_EXIT,  ACOS,    0,             "acos",     NULL, NULL  },
   { unary_operator,     128,  84,    49,   13,   16,   255,  0,    D_EXIT,  ATAN,    0,             "atan",     NULL, NULL  },

   { input_proc,         8,    108,    33,   13,   16,   255,  '7',  D_EXIT,  0,       0,             "7",        NULL, NULL  },
   { input_proc,         44,   108,    33,   13,   16,   255,  '8',  D_EXIT,  0,       0,             "8",        NULL, NULL  },
   { input_proc,         80,   108,    33,   13,   16,   255,  '9',  D_EXIT,  0,       0,             "9",        NULL, NULL  },
   { binary_operator,    116,  108,    33,   13,   16,   255,  '/',  D_EXIT,  DIV,     0,             "/",        NULL, NULL  },
   { clear_proc,         152,  108,    33,   13,   16,   255,  'c',  D_EXIT,  0,       0,             "C",        NULL, NULL  },
   { KeyboardProcedure,    0,    0,     0,    0,    0,     0,    0,       0, KEY_DEL, KEY_BACKSPACE, clearer,    NULL, NULL  },

   { input_proc,         8,    128,  33,   13,   16,   255,  '4',  D_EXIT,  0,       0,             "4",        NULL, NULL  },
   { input_proc,         44,   128,  33,   13,   16,   255,  '5',  D_EXIT,  0,       0,             "5",        NULL, NULL  },
   { input_proc,         80,   128,  33,   13,   16,   255,  '6',  D_EXIT,  0,       0,             "6",        NULL, NULL  },
   { binary_operator,    116,  128,  33,   13,   16,   255,  '*',  D_EXIT,  MUL,     0,             "*",        NULL, NULL  },
   { ButtonProcedure,    152,  128,  33,   13,   16,   255,  27,   D_EXIT,  0,       0,             "Off",      NULL, NULL  },

   { input_proc,         8,    148,  33,   13,   16,   255,  '1',  D_EXIT,  0,       0,             "1",        NULL, NULL  },
   { input_proc,         44,   148,  33,   13,   16,   255,  '2',  D_EXIT,  0,       0,             "2",        NULL, NULL  },
   { input_proc,         80,   148,  33,   13,   16,   255,  '3',  D_EXIT,  0,       0,             "3",        NULL, NULL  },
   { binary_operator,    116,  148,  33,   13,   16,   255,  '-',  D_EXIT,  SUB,     0,             "-",        NULL, NULL  },
   { unary_operator,     152,  148,  33,   13,   16,   255,  0,    D_EXIT,  SQRT,    0,             "sqr",      NULL, NULL  },

   { input_proc,         8,    168,  33,   13,   16,   255,  '0',  D_EXIT,  0,       0,             "0",        NULL, NULL  },
   { input_proc,         44,   168,  33,   13,   16,   255,  '.',  D_EXIT,  0,       0,             ".",        NULL, NULL  },
   { input_proc,         80,   168,  33,   13,   16,   255,  0,    D_EXIT,  0,       0,             "+/-",      NULL, NULL  },
   { binary_operator,    116,  168,  33,   13,   16,   255,  '+',  D_EXIT,  ADD,     0,             "+",        NULL, NULL  },
   { equals_proc,        152,  168,  33,   13,   16,   255,  '=',  D_EXIT,  0,       0,             "=",        NULL, NULL  },
   { KeyboardProcedure,          0,    0,    0,    0,    0,    0,    13,   0,       0,       0,             work_out,   NULL, NULL  },

   { NULL,               0,    0,    0,    0,    0,    0,    0,    0,       0,       0,             NULL,       NULL, NULL  }
};
/****************************************************************************/
DIALOG_STATE Handler( int c )
{
   switch( c )
   {
	  case 20:						// "Off"
		 BreakApp( &Me );
		 break;
   }
   //
   return state_exit;
}
/****************************************************************************/
//
PDialog test_dialog;
//
l_int Main( l_int argc, l_text *argv )
{
	reset_calc();
	strcpy(calc_str, "0");
	errno = 0;
	calculator[3].fg = makecol( 0, 255, 0 );
	calculator[3].bg = makecol( 0, 0, 0 );
	test_dialog = ActivateDialog( &Me, calculator, 0, Handler );
	//
	return true;
}
//
void Close( void )
{
   CloseDialog( test_dialog );
}

