#include <kernel.h>
//
l_ulong AppVersion	= ULONG_ID(0,0,0,1);
char AppName[]		= "Dialog Test";
l_uid	nUID		= "dTest";
l_uid NeededLibs[]	= { "allegui", "" };
//
char the_string[32] = "Cambiame";
char lbl_string[256] = "VScroll Value: 0";

void msbox();
void fbshow();
void ss_saver();
void movemode_setter();
//
DIALOG the_dialog[];
//
RGB white = {63, 63, 63};
RGB black = {0, 0, 0};

#define MOVEMODE_LISTBOX 15

/* callback function to specify the contents of the listbox */
char *listbox_getter(int index, int *list_size)
{
   static char *strings[] =
   {
	  "Zero",  "One",   "Two",   "Three", "Four",  "Five",
	  "Six",   "Seven", "Eight", "Nine",  "Ten"
   };

   if (index < 0) {
	  *list_size = 11;
	  return NULL;
   }
   else
	  return strings[index];
}

char *windowmode_listbox_getter(int index, int *list_size)
{
 static char *strings[] =
 {
  "Updated Unbuffered Moving",
  "Updated Buffered Moving",
  "Buffered Moving"
 };
 if (index < 0)
 {
  *list_size = 3;
  return NULL;
 }
 else
  return strings[index];
}

void msbox()
{
/* Alert(&Me,"BGui Movable Alert Box",
		   "This is a BGui Alert Box.",
		   "Grab the title and move it.",
		   "Cool!", "Who cares?", 13, 0); */
}

void fbshow()
{
// char buf[200] = "\0";
// FileSelect("File Select", buf, "*.*");
}

/* JW: added void keyword because this is C, not C++, and quit() is
   different from quit(void) essentially, and this causes an annoying warning
   in the menu struct*/
int quit(void)
{
   BreakApp( &Me );
}

void vchangelbl(int i)
{
 sprintf (lbl_string, "VScroll Value: %d ", i);
 the_dialog[3].d2 = i;
 the_dialog[4].d2 = i;
}

void hchangelbl(int i)
{
 sprintf (lbl_string, "HScroll Value: %d ", i);
 the_dialog[2].d2 = i;
}

GUIMENU my_menu[] =
{
   { "&Load\t(ctrl+L)",             NULL,           NULL },
   { "&Save\t(ctrl+S)",             NULL,            NULL },
   { "",                            NULL,             NULL },
   { "&Quit\t(ctrl+Q)",             quit,          NULL },
   { NULL,                          NULL,             NULL }
};

GUIMENU menu[] =
{
   { "&File",                       NULL,             my_menu },
   { NULL,                          NULL,             NULL }
};

DIALOG the_dialog[] =
{
   /* (dialog proc)            (x)   (y)   (w)   (h)   (fg)  (bg)  (key)  (flags)      (d1)  (d2)     (dp) */
   /* Menu bar & Hline */
   { WindowProcedure,            0,    0,  400,  235,   255,   0,    0,          0,       0,    0,    "Win 1" },

   { TextProcedure,            212,   34,    0,    0,     0,   0,    0,          0,       0,    0,    lbl_string },
   { ProgressProcedure,         15,  215,  380,   10,     0,   0,    0,          0,       20,   0,    NULL},
   { ProgressProcedure,        385,   35,   10,  175,     0,   0,    0,          0,       20,   0,    NULL},
   { ProgressProcedure,        193,  105,   10,   10,     0,   0,    0,          0,       20,   0,    NULL},

   { dMenuProcedure,             12,   31,    0,    0,     0,   0,    0,          0,       0,    0,    menu },
   { RadioProcedure,            90,   32,   20,   12,     0,   0,    0, D_SELECTED,       0,    0,    "A" },
   { RadioProcedure,           120,   32,   20,   12,     0,   0,    0,          0,       0,    1,    "B" },
   { RadioProcedure,           150,   32,   20,   12,     0,   0,    0, D_DISABLED,       0,    0,    "C" },
   { ButtonProcedure,          383,   15,   12,   12,   255,   0,    0,     D_EXIT,       0,    0,    "X" },
   { hLineProcedure,            12,   46,  371,    0,     0,   0,    0,          0,       0,    0,    NULL},

   /* First Group */
   { GroupBoxProcedure,         20,   50,  170,  150,   255,   0,    0,          0,       0,    0,    "Group One" },
   { EditProcedure,             25,   60,  160,   14,   255,   0,    0,          0,      30,    0,    the_string },
   { ButtonProcedure,           25,   80,   80,   16,   255,   0,    0,          0,       0,    0,    "&Toggle Me" },
   { dExButtonProcedure,        115,   80,   70,   16,   255,   0,    0,          0,       0,    0,    "Click Me"},
   { ListProcedure,             25,  100,  160,   30,   255,   0,    0,          0,       0,    0,    windowmode_listbox_getter },
   { dCallbackButtonProcedure,   25,  135,  160,   16,   255,   0,    0,          0,       0,    0,    "Set Move Mode", movemode_setter},
   { DdlistProcedure,           25,  155,  160,   14,   255,   0,    0,          0,       0,    0,    listbox_getter },
   { dCallbackButtonProcedure,   25,  180,  152,   16,   255,   0,    0,          0,       0,    0,    "Screen Shot", ss_saver },

   /* Second Group */
   { GroupBoxProcedure,        205,   55,  175,  152,  255,    0,    0,          0,       0,    0,    NULL },
   { hScrollbarProcedure,      210,  190,  145,   12,  255,    0,    0,          0,      20,    0,    hchangelbl},
   { vScrollbarProcedure,      360,   55,   12,  142,  255,    0,    0,          0,      20,    0,    vchangelbl},
   { SliderProcedure,          210,  170,  145,   16,  255,    0,    0,          0,     200,    0,    NULL },
   { dCallbackButtonProcedure,  210,  149,   70,   16,  255,    0,    0,          0,       0,    0,    "Msg Box", msbox},
   { TextBoxProcedure,         210,   55,  120,   65,  255,    0,    0,          0,       0,    0,    "This is a BillTextbox. It is a non editable text box with word wrapping and scroll bars. You can put a string of any length in a BillTextbox." },
   { dCallbackButtonProcedure,  210,  130,   70,   16,  255,    0,    0,          0,       0,    0,    "File Box", fbshow},
   { CheckProcedure,           282,  133,   55,   10,    0,    0,    0,          0,       0,    0,    "Check"},
   { CheckProcedure,           282,  152,   55,   10,    0,    0,    0, D_DISABLED,       1,    0,    "Check"},
   { SliderProcedure,          340,   55,   16,   80,  255,    0,    0,          0,     200,    0,    NULL},
   { NULL,                       0,    0,    0,    0,    0,    0,    0,          0,       0,    0,    NULL }
};

void ss_saver()
{
 PALETTE pal;
 BITMAP *b = create_bitmap(SCREEN_W,SCREEN_H);
 //
 blit(screen,b,0,0,0,0,SCREEN_W,SCREEN_H);
 get_palette(pal);
 save_pcx("ss.pcx", b, pal);
 destroy_bitmap(b);
}

void movemode_setter()
{
 the_dialog[0].d1 = 0;
}
//
PDialog test_dialog;
//
l_int Main( l_int argc, l_text *argv )
{
	test_dialog = ActivateDialog( &Me, the_dialog, 0, 0 );
	//
	return true;
}
//
void Close( void )
{
   CloseDialog( test_dialog );
}
