#include <kernel.h>
//
extern int WinDosrunning;
//
void MsgInit( char* szFormat, ... )
{
   if ( !WinDosRunning )
   {
	  va_list argptr;
	  l_byte txt[ 0xFF ];
	  //
	  va_start( argptr, szFormat );
	  vsprintf( txt, szFormat, argptr );
	  //
	  va_end( argptr );
	  if ( !SCREEN_W )
		 printf( "%s\n", txt );
	  else
	  {
		 if ( StartLogo )
			draw_sprite( screen, StartLogo, 0, 0 );
		 //
		 rectfill( screen, 0, SCREEN_H - text_height( font ), SCREEN_W, SCREEN_H, makecol( 0, 0, 0 ) );
		 textprintf_ex( screen, font, 10, SCREEN_H - text_height( font ), makecol( 255, 255, 255 ), -1, "%s", txt );
	  }
   }
   _flush_disk_cache();
}
//
void MsgInitOk( void )
{
   if ( !WinDosRunning )
   {
      if ( !SCREEN_W )
      {
         gotoxy( 72, wherey()-1 );
         textcolor( WHITE );
         cprintf( "%s", "[ " );
         textcolor( LIGHTGREEN );
         cprintf( "%s", "O.k." );
         textcolor( WHITE );
         cprintf( "%s", " ]" );
		 textcolor( LIGHTGRAY );
		 printf( "\n" );
	  }
	  else
	  {
		 textprintf_ex( screen, font, SCREEN_W - ( text_length( font, "A" ) * 10 ), SCREEN_H - text_height( font ), makecol( 0, 255, 0 ), -1, "%s", "[ O.k. ]" );
		 rest( 100 );
	  }
   }
}
//
void MsgInitErr( void )
{
   if ( !WinDosRunning )
   {
	  if ( !SCREEN_W )
	  {
		 gotoxy( 72, wherey()-1 );
		 textcolor( WHITE );
		 cprintf( "%s", "[" );
		 textcolor( LIGHTRED );
		 cprintf( "%s", "Error" );
		 textcolor( WHITE );
		 cprintf( "%s", " ]" );
		 textcolor( LIGHTGRAY );
		 printf( "\n" );
	  }
	  else
	  {
		 textprintf_ex( screen, font, SCREEN_W - ( text_length( font, "A" ) * 10 ), SCREEN_H - text_height( font ), makecol( 255, 0, 0 ), -1, "%s", "[Error ]" );
		 rest( 5000 );
	  }
   }
}
