#include "kernel.h"
//
int Buttons = -1, MouseInstalled = FALSE;
//
PCursor cursor_arrow = 0;
PCursor cursor_beam = 0;
PCursor cursor_busy = 0;
PCursor cursor_cross = 0;
PCursor cursor_help = 0;
PCursor cursor_move = 0;
PCursor cursor_no = 0;
PCursor cursor_pen = 0;
PCursor cursor_size1 = 0;
PCursor cursor_size2 = 0;
PCursor cursor_size3 = 0;
PCursor cursor_size4 = 0;
PCursor cursor_up = 0;
PCursor cursor_wait = 0;
//
l_int old_button = 0;
l_int hides = 1;
//
PMouse Mouse = 0;
//
TPoint OldPos = { 0, 0 };
//
l_int OldZ = 0;
//
PList Cursors = NULL;
/****************************************************************************/
void MouseSetCursorSpeed ( l_int Speed )
{
   if ( MouseInstalled )
   {
      Mouse->Speed = Speed;
      set_mouse_speed( Speed, Speed );
   }
}
/****************************************************************************/
void MouseSetDblClkSpeed ( l_int Speed )
{
   if ( MouseInstalled )
   {
      Mouse->DblClkSpeed = Speed;
   }
}
/****************************************************************************/
void MouseDrawCursor ( l_bool Del, l_bool Add )
{
   if ( MouseInstalled )
   {
      l_int cf = screen->clip;
      l_int cl = screen->cl;
      l_int cr = screen->cr;
      l_int ct = screen->ct;
      l_int cb = screen->cb;
      //
      screen->clip = TRUE;
      screen->cl = screen->ct = 0;
      screen->cr = screen->w;
      screen->cb = screen->h;
      if ( Del )
      {
         blit( Mouse->PrevScr, screen, 0, 0, OldPos.x-Mouse->Cur->SpotX, OldPos.y-Mouse->Cur->SpotY, Mouse->Cur->Image->w, Mouse->Cur->Image->h );
      }
      if ( Add )
      {
         blit( screen, Mouse->PrevScr, Mouse->State.p.x-Mouse->Cur->SpotX, Mouse->State.p.y-Mouse->Cur->SpotY, 0, 0, Mouse->Cur->Image->w, Mouse->Cur->Image->h );
         draw_sprite( screen, Mouse->Cur->Image, Mouse->State.p.x-Mouse->Cur->SpotX, Mouse->State.p.y-Mouse->Cur->SpotY );
      }
      OldPos = Mouse->State.p;
      screen->clip = cf;
      screen->cl = cl; screen->cr = cr;
      screen->ct = ct; screen->cb = cb;
   }
}
//
void _MouseRecap ( p_bitmap from, TRect r )
{
   if ( MouseInstalled )
   {
      if ( Mouse->Visible )
      {
         TRect i;
         l_int cf = from->clip;
         l_int cl = from->cl;
         l_int cr = from->cr;
         l_int ct = from->ct;
         l_int cb = from->cb;
         //
         _RectIntersept( &i, r, Mouse->CursorPosition );
         from->clip = TRUE;
         from->cl = max( i.a.x, 0 );
         from->ct = max( i.a.y, 0 );
         from->cr = min( i.b.x+1, screen->w );
         from->cb = min( i.b.y+1, screen->h );
         blit( from, Mouse->PrevScr, i.a.x, i.a.y, i.a.x-Mouse->CursorPosition.a.x, i.a.y-Mouse->CursorPosition.a.y, i.b.x-i.a.x+1, i.b.y-i.a.y+1 );
         draw_sprite ( from, Mouse->Cur->Image, Mouse->State.p.x-Mouse->Cur->SpotX, Mouse->State.p.y-Mouse->Cur->SpotY );
         from->clip = cf;
         from->cl = cl;
         from->cr = cr;
         from->ct = ct;
         from->cb = cb;
      }
   }
}
/**
Changes the cursor to the specified one.
@param Cur Pointer to the cursor to use
*/
void MouseSetCursor ( PCursor Cur )
{
   if ( MouseInstalled )
   {
      if ( Mouse->Visible && Mouse->Cur && Mouse->PrevScr )
         MouseDrawCursor( true, false );
      if ( Mouse->PrevScr )
         destroy_bitmap( Mouse->PrevScr );
      Mouse->PrevScr = create_bitmap( Cur->Image->w+2, Cur->Image->h+2 );
      Mouse->Cur = Cur;
      if ( Mouse->Visible )
         MouseDrawCursor( false, true );
   }
}
/**
Changes the cursor to the specified one.
@param Name Name of the pointer to use
*/
void MouseSetCursorNamed ( l_text Name )
{
   if ( MouseInstalled )
   {
      PCursor c = ListKey( Cursors, Name );
      //
      if ( c )
         MouseSetCursor( c );
   }
}
/**
Makes the mouse cursor visible
*/
void MouseShow ( void )
{
   if ( MouseInstalled )
   {
      if ( !Mouse->Visible )
      {
         Mouse->Visible = true;
         if ( Mouse->Cur )
            MouseDrawCursor( false, true );
      }
   }
}
/**
Hides the mouse cursor
*/
void MouseHide ( void )
{
   if ( MouseInstalled )
   {
      if ( Mouse->Visible )
      {
         Mouse->Visible = false;
         if ( Mouse->Cur )
            MouseDrawCursor( true, false );
      }
   }
}
/**
Allocates a new cursor form a bitmap
@param Img Bitmap of the cursor
@param SpotX x coordinates in Img of spot point
@param SpotY y coordinates in Img of spot point
@see FreeCursor
@see MouseSetCursor
*/
PCursor NewCursor ( p_bitmap Img, l_int SpotX, l_int SpotY )
{
   PCursor c = malloc( sizeof( TCursor ) );
   //
   if ( !c )
      return NULL;
   //
   c->Image = Img;
   c->SpotX = SpotX;
   c->SpotY = SpotY;
   //
   return c;
}
/**
Free a cursor
@param c Cursor to free
@see NewCursor
*/
void FreeCursor ( PCursor c )
{
   if ( MouseInstalled )
   {
      if ( c->Image )
         destroy_bitmap( c->Image );
      free( c );
   }
}
//
void MouseEventGenerator ( PEvent Event )
{
   if ( MouseInstalled )
   {
      Event->Type = EV_NOTHING;
      Mouse->Moved = FALSE;
      Mouse->ButtonChanges = 0;
	  Mouse->State.z = mouse_z;
      //
	  if ( OldZ != Mouse->State.z )
      {
         Event->Type = EV_MOUSE;
		 if ( OldZ-Mouse->State.z < 0 )
            Event->Message = MSG_MOUSE_SCLLUP;
         else
            Event->Message = MSG_MOUSE_SCLLDWN;
		 OldZ = Mouse->State.z;
      }
      if ( mouse_x != Mouse->State.p.x || mouse_y != Mouse->State.p.y )
      {
         Event->Type = EV_MOUSE;
         Mouse->Moved = TRUE;
         Mouse->State.p.x = mouse_x;
		 Mouse->State.p.y = mouse_y;
		 //
		 #define CursorSize( r, x, y, w, h ) RectAssign( r, x, y, x+w, y+h )
		 //
		 if ( Mouse->Visible )
		 {
			CursorSize( &Mouse->CursorPosition, Mouse->State.p.x-Mouse->Cur->SpotX, Mouse->State.p.y-Mouse->Cur->SpotY, Mouse->Cur->Image->w-1, Mouse->Cur->Image->h-1 );
			MouseDrawCursor( true, true );
		 }
		 else
			RectAssign( &Mouse->CursorPosition, -1, -1, -1, -1 );
	  }
	  Mouse->State.b = mouse_b;
	  if ( Mouse->ButtonChanges = Mouse->State.b ^ old_button )
	  {
		 Event->Type = EV_MOUSE;
		 old_button = Mouse->State.b;
	  }
   }
}
//
_PUBLIC void GSSystemMouseInstall()
{
   Cursors = NewList();
   Buttons = MouseInstalled = install_mouse();
   //
   if ( Buttons > 0 )
   {
      PRegKey o;
      //
      o =	ResolveKey( "/SYSTEM/MOUSE/CURSORS" );
      if ( !o )
      {
         DebugMessage( "No cursor declared in registry. Mouse can't start");         return;      }
      if ( o->Last )
      {
         PRegKey a = o->Last->Next;
         PRegKey b = a, i;
         //
         do
         {
            if ( a->Type == RKT_TEXT )
            {
               PCursor c;
               PImage Img;
               l_ushort sx = 0, sy = 0;
               //
               if ( a->Last )
               {
                  i = a->Last;
                  do
                  {
                     if ( !TextCaseCompare( i->Name, "sy" ) && ( i->Type == RKT_INT ) )
                        sy = *( ( l_int* )i->Data );
                     else if ( !TextCaseCompare( i->Name, "sx" ) && ( i->Type == RKT_INT ) )
                        sx = *( ( l_int* )i->Data );
                     i = i->Next;
                  } while ( i != a->Last );
               }
               Img = LoadImage( ( l_text )a->Data );
               if ( !sx || !sy && !stricmp( get_extension( ( l_text )a->Data ), "cur" ) )
               {
                  void ( *__mouse_focus__ )( l_text file, l_ushort *sx, l_ushort *sy );
                  //
                  __mouse_focus__ = ( void* )ResolveSymbol( NULL, "LoadMouseFocusFromFile" );
                  if ( __mouse_focus__ )
                     __mouse_focus__( ( l_text )a->Data, &sx, &sy );
               }
               //
               if ( Img )
               {
                  c = NewCursor( Img, sx, sy );
                  if ( c )
                  {
                     ListAdd( Cursors, a->Name, c, ( void* )&FreeCursor );
                  }
                  else
                  {
                     destroy_bitmap( Img );
                  }
               }
            }
            a = a->Next;
         } while ( a != b );
      }
      Mouse = NEW( TMouse );
      CLEAR( Mouse );
      Mouse->State.p.x = mouse_x;
      Mouse->State.p.y = mouse_y;
      Mouse->State.z = mouse_z;
      Mouse->State.b = mouse_b;
      cursor_arrow = ListKey( Cursors, "arrow" );
      cursor_beam = ListKey( Cursors, "beam" );
      cursor_cross = ListKey( Cursors, "cross" );
      cursor_help = ListKey( Cursors, "help" );
      cursor_move = ListKey( Cursors, "move" );
      cursor_no = ListKey( Cursors, "no" );
      cursor_pen = ListKey( Cursors, "pen" );
      cursor_size1 = ListKey( Cursors, "size1" );
      cursor_size2 = ListKey( Cursors, "size2" );
      cursor_size3 = ListKey( Cursors, "size3" );
      cursor_size4 = ListKey( Cursors, "size4" );
      cursor_up = ListKey( Cursors, "up" );
      cursor_wait = ListKey( Cursors, "wait" );
      cursor_busy = ListKey( Cursors, "busy" );
      if ( !cursor_arrow )
      {
		 DebugMessage( "Arrow not set, mouse can't start");
		 return;
	  }
      MouseSetCursorSpeed( KeyGetInt( "/SYSTEM/MOUSE/speed", 0 ) );
      MouseSetDblClkSpeed( KeyGetInt( "/SYSTEM/MOUSE/dblclk", 4 ) );
      MouseSetCursor( CUR_ARROW );
      InstallEventGenerator( MouseEventGenerator );
   }
   else
   {
      DebugError( "Mouse not found" );
   }
}
//
_PUBLIC void GSSystemMouseUninstall()
{
   if ( MouseInstalled )
   {
      if ( Buttons > 0 )
      {
         MouseHide();
         Mouse->Cur = NULL;
         free( Mouse );
         Mouse = NULL;
         remove_mouse();
      }
      if ( Cursors )
         FreeList( Cursors );
   }
}
/**
Removes temporary mouse support by kernel, and allow extra software to uses it directly
Never uses it in multitask mode.
@see __MouseRestart
*/
l_bool __MouseStop ( void )
{
   if ( MouseInstalled )
   {
      if ( Buttons > 0 )
      {
         MouseHide();
         remove_mouse();
         MouseInstalled = FALSE;
      }
   }
   return true;
}
/**
Restores mouse after a __MouseStop call
Do not show mouse, use MouseShow(); after it.
@see MouseShow
@see __MouseStop
*/
l_bool __MouseRestart ( void )
{
   install_mouse();
   Buttons = install_mouse();
   MouseInstalled = TRUE;
   MouseSetCursor( Mouse->Cur );
   //
   return true;
}
