/*
 *    SPEED - by Shawn Hargreaves, 1999
 *
 *    Main player control functions.
 */

#include <allegro.h>

#include "speed.h"



/* how many lives do we have left? */
int lives;



/* counters for time delays while waking up or dying */
static int init_time;
static int die_time;



/* current position and velocity */
static float pos;
static float vel;



/* which segments of health we currently possess */
#define SEGMENTS 16

static int ganja[SEGMENTS];

/* Did you ever come across a DOS shareware game called "Ganja Farmer"?
 * It is really very cool: you have to protect your crop from "Da Man",
 * who is trying to bomb it, spray it with defoliants, etc. Superb
 * reggae soundtrack, and the gameplay here is kind of similar, hence
 * my variable names...
 */



/* initialises the player functions */
void init_player()
{
   int i;

   lives = 3;

   init_time = 128;
   die_time = 0;

   pos = 0.5;
   vel = 0;

   for (i=0; i<SEGMENTS; i++)
      ganja[i] = TRUE;
}



/* closes down the player module */
void shutdown_player()
{
}



/* advances the player to the next attack wave */
void advance_player()
{
   int i;

   for (i=0; i<SEGMENTS; i++) {
      if (ganja[i])
	 score++;
      else
	 ganja[i] = TRUE;
   }
}



/* updates the player position */
int update_player()
{
   poll_keyboard();
   poll_joystick();

   /* quit game? */ 
   if (key[KEY_ESC])
      return -1;

   /* safe period while initing */
   if (init_time)
      init_time--;

   /* blown up? */
   if (die_time) {
      die_time--;

      if (!die_time) {
	 lives--;
	 if (!lives)
	    return 1;

	 init_time = 128;
	 pos = 0.5;
	 vel = 0;
      }
   }

   /* handle user input */
   if (!die_time) {
      if ((joy_left) || (key[KEY_LEFT]))
	 vel -= 0.005;

      if ((joy_right) || (key[KEY_RIGHT]))
	 vel += 0.005;
   }

   /* move left and right */
   pos += vel;

   if (pos >= 1.0)
      pos -= 1.0;

   if (pos < 0.0)
      pos += 1.0;

   vel *= 0.75;

   return 0;
}



/* draws the player */
void draw_player(BITMAP *bmp, int r, int g, int b, void (*project)(float *f, int *i, int c))
{
   float shape[12];
   int ishape[12];
   int i;

   /* draw health segments */
   for (i=0; i<SEGMENTS; i++) {
      if (ganja[i]) {
	 shape[0] = (float)i / SEGMENTS;
	 shape[1] = 0.98;

	 shape[2] = (float)(i+1) / SEGMENTS;
	 shape[3] = 0.98;

	 shape[4] = (float)(i+1) / SEGMENTS;
	 shape[5] = 1.0;

	 shape[6] = (float)i / SEGMENTS;
	 shape[7] = 1.0;

	 project(shape, ishape, 8);

	 polygon(bmp, 4, ishape, makecol(r/3, g/3, b/3));
      }
   }

   /* flash on and off while initing */
   if (init_time & 4)
      return;

   /* draw the ship */
   shape[0] = pos - 0.04;
   shape[1] = 0.98;

   shape[2] = pos - 0.02;
   shape[3] = 0.97;

   shape[4] = pos;
   shape[5] = 0.95;

   shape[6] = pos + 0.02;
   shape[7] = 0.97;

   shape[8] = pos + 0.04;
   shape[9] = 0.98;

   shape[10] = pos;
   shape[11] = 0.98;

   project(shape, ishape, 12);

   polygon(bmp, 6, ishape, makecol(r, g, b));
}

