#define	 KERNEL_FILE
#include "kernel.h"

l_bool UnLoadLibraries ( l_uid * );

extern jmp_buf MainPoint;

/**
*	Global variables
*/
PList Symbols		= 0;
PList Applications	= 0;
PList AppExtenders  = 0;
/**
*	Kernel indetification
*/
TApplication Me =
{
	WinDosTxt,
	"",
	0,
	NULL,
	NULL,
	NULL,
	NULL,
	0,
	0,
	0,
	"kernel",
	0,
	1
};
//
l_long NODOSMSG_LEN = 0;
//
l_int FindDllIni( l_text filename )
{
   l_int ret = 0;
   l_text LFile = NULL;
   PDrive d = (PDrive)FoundDrive( filename, &LFile );
   l_text RF = FileNameToPath( d->Ex1, LFile );
   FILE *fp = fopen( RF, "rb" );
   //
   NODOSMSG_LEN = 0;
   DebugMessage("Open File %s", RF );
   if ( fp )
   {
	  int Marca[ 24 ] = { '_','_','W','i','n','D','o','s','E','x','e','c','u','t','a','b','l','e','F','i','l','e','_','_' };
	  int ptrm        = 0;
	  int cm = 0;
	  //
	  _while( !feof( fp ) )
	  {
		 cm = fgetc( fp );
		 //
		 if ( cm == Marca[ ptrm ] )
			ptrm++;
		 else
			ptrm = 0;
		 //
		 if ( ptrm == 24 )
			break;
	  }
	  //
	  if ( ptrm == 24 )
	  {
		 NODOSMSG_LEN = ftell( fp );
		 ret = 1;
		 DebugMessage( "Set Init WinDos Data in 0x%X",NODOSMSG_LEN);
	  }
	  else
	  {
		 DebugMessage("Error, Mark for Init not found");
	  }
   }
   else
   {
	  DebugMessage("Fopen Error");
   }
   //
   fclose( fp );
   free( LFile );
   free( RF );
   //
   return ret;
}

/**
*	NAME: AddSymbol
*	DESCRIPTION: Used by the macros to add or export a symbol
*	RETURN: The exported symbol
*/
PSymbol AddSymbol ( l_text Name, void *Address, PApplication App )
{
	PSymbol o;

	if ( o = (PSymbol)ListKeyItem(Symbols, Name) )
	{
		DebugWarning("Duplicate symbol: %s orignaly registered by %x", Name, o->App);
		return 0;
	}

	o = NEW(TSymbol);

	if ( !o || !Name ) return NULL;

	memset(o, 0, sizeof(TSymbol));
	o->Itm.Key		= (l_text)strdup(Name);
	o->Itm.Data		= Address;
	o->Itm.FreeData	= NULL;
	o->App			= App;

	ListAddItem(Symbols, (PListItem)o);

	return o;
}

/**
*	NAME: ResolveSymbol
*	DESCRIPTION: Resolves the symbol in a DynLD app
*	RETURN: The address of the symbol
*/
l_long ResolveSymbol ( PApplication App, l_text Name )
{
	l_long Address = 0;

	if ( !strcmp(Name, "Me") )
		Address = (l_long)App;
	else
		Address = (l_long)ListKey(Symbols, Name);

	if ( !Address )
	{
		DebugError ("0x%08x :: Unresolved external %s", App, Name);
	}

	return Address;
}

void FreeApplication ( void *o )
{
	PApplication App = (PApplication)o;
	//
//	SysPoll();
	//
	DebugMessage("Free Application :: %s",App->Name);
	//
	if ( App->Close )
	   App->Close();
	//
	MsgInit( "Liberando Memoria de '%s'", App->Name );
	//
	if ( App->Name )
	   free(App->Name);
	if ( App->FileName )
	   free(App->FileName);
	if ( App->Ressource )
	   FreeList(App->Ressource);
	if ( App->Icon )
	   FreeIcon(App->Icon);
	if ( App->argv)
	   FreeArgs(App->argc,App->argv);
	//
	free(App->Data);
	free(App);
	MsgInitOk();
}
////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
PAppExtender InstallAppExtender ( void (*Init)(PApplication), void (*DeInit)(PApplication) ) {
	PAppExtender o = malloc(sizeof(TAppExtender));
	if ( !o ) return NULL;
	o->Init = Init;
	o->DeInit = DeInit;
	ListAdd(AppExtenders,NULL,o,&free);
	return o;
}
////////////////////////////////////////////////////////////////////////////////
void RemoveAppExtender ( PAppExtender o) {
	PListItem a = ListFoundItem(AppExtenders,o);
	if ( a ) ListRemoveItem(AppExtenders,a);
}
////////////////////////////////////////////////////////////////////////////////
void AppExtendersInit ( PApplication App ) {
	if  ( AppExtenders->Last ) {
		PListItem a, b;
		PAppExtender o;
		a = b = AppExtenders->Last->Next;
		do {
			o = (PAppExtender)a->Data;
			if ( o->Init ) o->Init(App);
			a = a->Next;
		} while ( a != b );
	}
}
////////////////////////////////////////////////////////////////////////////////
void AppExtendersDeInit ( PApplication App ) {
	if  ( AppExtenders->Last ) {
		PListItem a, b;
		PAppExtender o;
		a = b = AppExtenders->Last;
		do {
			o = (PAppExtender)a->Data;
			if ( o->DeInit ) o->DeInit(App);
			a = a->Prev;
		} while ( a != b );
	}
}

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////
PApplication GetLibrary ( l_uid id ) {

	if ( Applications->Last )
	{
		PListItem a = Applications->Last;
		PListItem b = a;
		PApplication App;
		do
		{
			App = (PApplication)(a->Data);
			if ( !TextCompare(App->UID,id) )
				return App;
			a = a->Next;
		} while ( a != b );
	}
	return NULL;
}
////////////////////////////////////////////////////////////////////////////////
l_bool LoadLibrary ( l_uid id )
{
	PApplication app = GetLibrary(id);
	//
	if ( !app )
	{
		l_text key = TextArgs("/SYSTEM/LIBRARIES/%s",id);
		if ( key )
		{
			l_text file = KeyGetText(key,NULL);
			//
			free(key);
			if ( !file )
			{
				file = TextArgs("/system/dlls/%s.wdl",id);
				if ( !file )
				   return false;
			}
			app = DynLdRun(file,NULL);
			if ( !app )
			{
			   return false;
			}
		}
		else
			return false;
	}
	else
		app->Users++;
	//
	return true;
}
////////////////////////////////////////////////////////////////////////////////
l_bool UnLoadLibrary ( l_uid id ) {
	PApplication app = GetLibrary(id);

	if ( !app )
	   return false;
	app->Users--;

	if ( !app->Users )
	   CloseApp(app);

	return true;
}
////////////////////////////////////////////////////////////////////////////////
l_bool LoadLibraries ( l_uid *ids ) {
	while ( (*ids)[0] ) {
		if ( !LoadLibrary(*ids) ) return false;
		ids ++;
	}
	return true;
}
////////////////////////////////////////////////////////////////////////////////
l_bool UnLoadLibraries ( l_uid *ids ) {
	while ( (*ids)[0] ) {
		if ( !UnLoadLibrary(*ids) ) DebugWarning("Unable to unload '%s'",ids);
		ids ++;
	}
	return true;
}
////////////////////////////////////////////////////////////////////////////////
void FreeHostedApp ( PApplication App ) {
	if ( Applications->Last )
	{
		PListItem a = Applications->Last;
		PListItem n;
		PApplication A;
		do
		{
			n = a->Next;
			A = (PApplication)(a->Data);
			if ( A->Host == App )
			{
				FreeHostedApp(A);
				ListRemoveItem(Applications, a);
			}
			a = n;
		} while ( a != Applications->Last );

	}
}
////////////////////////////////////////////////////////////////////////////////
PApplication DynLdRunEx ( l_text Filename, l_int argc, l_text* argv, PApplication Host, PErrorHandler h )
{
	PApplication App		= 0;
	void *TempData			= 0;
	PDynLdExt Ext			= 0;
	l_ulong i 				= 0;
	l_ulong DynERROR		= 0;
	TDynLdReloc DynReloc;
	TDynLdHeader DynHead;
	PListItem itm;
	PFile f;
	//
	if ( !argv )
	{
		DebugError("DYNLD :: %s : argv is NULL !", Filename);
		return NULL;
	}
	
	
	/*
	*	Open application file
	*/

	i = FindDllIni( Filename );
	f = FileOpen( Filename, "rb" );

	if ( !f )
	{
		CreateError(h,ERROR_FILENOTFOUND,"File not found");
		DebugError("DYNLD(1) :: File not found - %s", Filename);
		return NULL;
	}
	//
	FileSeek( f, NODOSMSG_LEN, 0 );
	//
	FileRead(&DynHead, 1, sizeof(TDynLdHeader), f);

	if ( DynHead.Magic != ULONG_ID('D','n','L','d') )
	{
		FileClose(f);
		CreateError(h,ERROR_INVALIDFILE,"Application is not a valid DynLD");
		DebugError("DYNLD(1) :: Application is not a valid DynLD.");
		return NULL;
	}

	if ( DynHead.FileFormatVersion != DYNLDVERSION )
	{
		FileClose(f);
		CreateError(h,ERROR_INVALIDFILE,"Application has invalid version number of DynLD linker");
		DebugError("DYNLD :: Application has invalid version number of DynLD linker.");
		return NULL;
	}

	App = (PApplication)malloc(sizeof(TApplication));

	if ( !App )
	{
		FileClose(f);
		CreateError(h,ERROR_NOTENOUGHMEMORY,NULL);
		DebugError("DYNLD :: Not enough memory to load application.");
		return NULL;
	}

	memset(App, 0, sizeof(TApplication));

	App->Name           = FileReadBinString(f);
	App->FileName       = (l_text)strdup(Filename);
	memcpy(&App->UID,&DynHead.UID,sizeof(l_uid));
	App->Version        = DynHead.FileVersion;
	App->Type           = DynHead.Type;
	App->Host			= Host;
	//
	MsgInit( "Cargando '%s' Version 0x%08x", App->Name, App->Version );
	//
	DebugMessage ("Loading application '%s'(%x), FileName - '%s'",App->Name,App,App->FileName);
	DebugMessage ("         UID - '%s' Version 0x%08x",App->UID,App->Version);

	if ( DynHead.Compression != 0)
	{
		DebugMessage ("         UnCompress '%s'",App->FileName);
		TempData = (void*)malloc(DynHead.Size);
		FileRead(TempData, 1, DynHead.Size, f);
		App->Data = (void*)malloc(DynHead.OriginalSize);
		uncompress(App->Data, &DynHead.OriginalSize, TempData, DynHead.Size);
		DynHead.Size = DynHead.OriginalSize;
		free(TempData);
	}
	else
	{
		App->Data = (void*)malloc(DynHead.Size);
		FileRead(App->Data, 1, DynHead.Size, f);
	}

	if ( DynHead.MainOffset  != NoneOffset ) App->Main  = (void*)(((long)App->Data)+DynHead.MainOffset);
	if ( DynHead.CloseOffset != NoneOffset ) App->Close = (void*)(((long)App->Data)+DynHead.CloseOffset);
	if ( DynHead.LibsOffset  != NoneOffset ) App->Libs  = (void*)(((long)App->Data)+DynHead.LibsOffset);


	if ( App->Libs )
	{
		if ( !LoadLibraries(App->Libs) )
		{
			MsgInitErr();
			free(App->Data);
			free(App);
			FileClose(f);
			return NULL;
		}
	}
	Ext = (PDynLdExt)malloc(sizeof(TDynLdExt)*DynHead.Importations);
	for (i = 0; i <DynHead.Importations; i++)
	{
		Ext[i].Name = FileReadBinString(f);
		FileRead(&Ext[i].Symbol, 1, 4, f);
		if ( !ResolveSymbol(App,Ext[i].Name) )
		{
			CreateError(h,ERROR_INVALIDFILE,"Unresolved extrenal");
			ErrorLog(h,"'%s' not found\n",Ext[i].Name);
			DynERROR++;
		}
	}

	if ( DynERROR )
	{
		MsgInitErr();
		App->Close = NULL;
		DebugError ("0x%08x :: %d error(s) while loading. Application has not started", App, DynERROR);
		FreeApplication(App);
		return NULL;
	}

	for (i = 0; i < DynHead.Relocations; i++)
	{
		FileRead(&DynReloc, 1, sizeof(TDynLdReloc), f);
		if ( DynReloc.Type == REL32_ABSOLUTE || DynReloc.Type == REL32_RELATIVE ) {
			l_ulong j, addr = (l_ulong)App->Data;

			for (j = 0; j<DynHead.Importations; j++)
				if (Ext[j].Symbol == DynReloc.Symbol)
				{
					addr = (l_ulong)ResolveSymbol(App,Ext[j].Name);
					break;
				}

			if ( DynReloc.Type == REL32_ABSOLUTE )
				*(long*)(((((long)App->Data))+DynReloc.Address)) += (long)addr;
			else if ( DynReloc.Type == REL32_RELATIVE )
				*(long*)(((((long)App->Data))+DynReloc.Address)) += (long)addr-(long)App->Data-(long)DynReloc.Address;

		} else {
			CreateError(h,ERROR_INVALIDFILE,"Unknown relocation type");
			DebugError("DYNLD : Unknown relocation type");
			DynERROR++;

		}
	}

	if ( DynHead.RessourceEntries )
		App->Ressource = DMSLoadRessource(f,DynHead.RessourceEntries);


	if ( App->Ressource )
	{
		PImage i16,i32,i48;
		i16 = ListKeyCase(App->Ressource,"ICON16");
		i32 = ListKeyCase(App->Ressource,"ICON32");
		i48 = ListKeyCase(App->Ressource,"ICON48");
		if ( i16 || i32 || i48 )
			App->Icon = NewIcon2(i16,i32,i48);
	}
	FileClose(f);
	//
	for(i=0;i<DynHead.Importations;i++)
	   free(Ext[i].Name);

	free(Ext);

	App->argc = argc;
	App->argv = DuplicateArgs(argc,argv);

	if ( !App->argv )
	{
		MsgInitErr();
		DebugError("0x%08x :: argv is null",App);
		CreateError(h,ERROR_NOTENOUGHMEMORY,"argv is null");
		DynERROR++;
	}

	if ( DynERROR )
	{
		MsgInitErr();
		App->Close = NULL;
		DebugError ("0x%08x :: %d error(s) while loading. Application has not started", App, DynERROR);
		FreeApplication(App);
		return NULL;
	}

	DebugMessage("AppExtendersInit");

	AppExtendersInit(App);


	DebugMessage("Adding app to list");
	ListAdd(Applications,NULL,App,FreeApplication);

	DebugMessage("Calling @App->Main(Args)");
	App->State = DYNLD_STRATING;
	if ( App->Main )
		if ( !App->Main(App->argc,App->argv) )
		{
			MsgInitErr();
			App->Close = NULL;
			CloseApp(App);
			if ( App->Libs )
			   UnLoadLibraries(App->Libs);
			if ( itm = ListFoundItem(Applications,App) )
				ListRemoveItem(Applications, itm);
			else
			{
				DebugWarning("Application wasn't in list");
				FreeApplication(App);
			}
			return NULL;
		}
	//}
	App->State = DYNLD_RUNNING;
	App->Users = 1;
	//
	MsgInitOk();
	//
	return App;
}
////////////////////////////////////////////////////////////////////////////////
PApplication DynLdRun ( l_text Filename, l_text Args )
{
	PApplication App;
	l_int argc = Args ? 2 : 1;
	l_text *argv = malloc(sizeof(l_text)*(argc+1));
	//
	MouseSetCursor( CUR_BUSY );
	argv[0] = TextDup(Filename);
	if ( Args )
	   argv[1] = TextDup(Args);
	argv[argc] = 0;
	App = DynLdRunEx(Filename,argc,argv,NULL,NULL);
	FreeArgs(argc,argv);
	MouseSetCursor( CUR_ARROW );
	//
	return App;
}
////////////////////////////////////////////////////////////////////////////////
PApplication DynLdRun2 ( l_text Filename, l_text Args )
{
	PApplication App;
	l_int argc = 0;
	l_text *argv;
	//
	MouseSetCursor( CUR_BUSY );
	_ParseArgs(Args,Filename,&argc,&argv);
	App = DynLdRunEx(Filename,argc,argv,NULL,NULL);
	FreeArgs(argc,argv);
	MouseSetCursor( CUR_ARROW );
	//
	return App;
}
////////////////////////////////////////////////////////////////////////////////
PApplication DynLdCommand ( l_text Command )
{
	PApplication App = NULL;
	l_int argc = 0;
	l_text *argv = 0;
	//
	MouseSetCursor( CUR_BUSY );
	_ParseArgs(Command,NULL,&argc,&argv);
	if ( argv )
	{
		App = DynLdRunEx(argv[0],argc,argv,NULL,NULL);
		FreeArgs(argc,argv);
	}
	MouseSetCursor( CUR_ARROW );
	//
	return App;
}
////////////////////////////////////////////////////////////////////////////////
void BreakApp ( PApplication App )
{
	PListItem itm;
	DebugMessage ("Break :: %s (0x%08x)",App->Name,App);
	DebugMessage ("Try to call close function.");
	CloseApp(App);
	DebugWarning("Closed.");
	if ( App->Libs )
	   UnLoadLibraries(App->Libs);
	if ( itm = ListFoundItem(Applications,App) )
		ListRemoveItem(Applications, itm);
	else
	{
		DebugWarning("Application wasn't in list");
		FreeApplication(App);
	}
	longjmp(MainPoint, 1);
	DebugWarning("Should never came here, calling object may no more exists");
}
////////////////////////////////////////////////////////////////////////////////
void CloseApp ( PApplication App )
{
	DebugMessage ("Close :: %s",App->Name);
	FreeHostedApp(App);
	if ( App->Close )
	{

		App->Close();
		App->Close = NULL;
	}
	DebugMessage("AppExtendersDeInit");

	AppExtendersDeInit(App);


	if ( Symbols->Last )
	{
		PListItem a, b, n;

		a = b = Symbols->Last->Next;

		do
			{
				n = a->Next;

				if ( SYMBOL(a)->App == App )
				{
					ListRemoveItem(Symbols, a);
					if ( a == b ) b = Symbols->Last->Next;
				}

				a = n;
			} while ( a != b );
	}
	App->State = DynLdStateToFree; // App will be free by DYNLDTCP Thread
}
////////////////////////////////////////////////////////////////////////////////
PTask DynLdTCPId = 0;

extern l_bool GSExit;
////////////////////////////////////////////////////////////////////////////////
void DynLdTCP ( PTask o ) {

	if ( Applications->Last )
	{
		PListItem a = Applications->Last;
		PListItem n;
		PApplication App;
		
		do
		{
			n = a->Next;
			App = (PApplication)(a->Data);
			if ( App->State == DynLdStateToFree )
			{
				if ( App->Libs ) UnLoadLibraries(App->Libs);
				ListRemoveItem(Applications, a);

			}
			if ( (App->State == DYNLD_STRATING) && GSExit ) {
				BreakApp(App);
			}
			
			a = n;
		} while ( a != Applications->Last );
	}




}
////////////////////////////////////////////////////////////////////////////////
l_bool DynLdInstallLibrary ( l_text file ) {
	l_text key,n;
	TDynLdHeader DynHead;
	l_int i = FindDllIni( file );
	PFile f = FileOpen(file, "rb");
	//
	if ( !f )
	{
		DebugError("DYNLD(2) :: File not found - %s", file);
		return false;
	}
	//
	FileSeek( f, NODOSMSG_LEN, 0 );
	FileRead(&DynHead, 1, sizeof(TDynLdHeader), f);
	if ( DynHead.Magic != ULONG_ID('D','n','L','d') )
	{
		FileClose(f);
		DebugError("DYNLD(2) :: Library is not a valid DynLD. Library not installed.");
		return false;
	}

	if ( DynHead.FileFormatVersion > DYNLDVERSION )
	{
		FileClose(f);
		DebugError("DYNLD :: Library has invalid version number of DynLD linker. Library not installed.");
		return false;
	}

	FileClose(f);

	key = TextArgs("/SYSTEM/LIBRARIES/%s",DynHead.UID);
	if ( !key ) return false;
	n 	= TextArgs("%s",DynHead.UID);
	if ( !n ) return false;

	NewKey("/SYSTEM/LIBRARIES",n);

	KeySetText(key,file);

	free(key);
	free(n);


	return true;
}
////////////////////////////////////////////////////////////////////////////////
void _ParseArgs ( l_text Args, l_text Initial, int *argc, l_text **argv ) {
	l_text Buffer[256];
	l_text p = Args;
	l_int n = 0, g =0;
	
	if ( Initial )
		Buffer[n++] = TextDup(Initial);
		
	if ( Args ) {
		while ( *Args ) {
			if ( *Args == '"' ) {
				if ( g ) if ( Args-p ) Buffer[n++] = TextNDup(p,Args-p);
				p = Args+1;	
				g ^= 1;
			}
				 
			if ( ( *Args == ' ' ) && !g ) {
				if ( Args-p ) Buffer[n++] = TextNDup(p,Args-p);
				p = Args+1;	
			}
			Args++;
		}
		
		if ( Args-p ) Buffer[n++] = TextNDup(p,Args-p);
	}
	
	if ( argc && argv ) {
		Buffer[n] = 0;
		*argc = n;
		*argv = malloc((n+1)*sizeof(l_text));
		memcpy(*argv,Buffer,(n+1)*sizeof(l_text));
	}
	
}
////////////////////////////////////////////////////////////////////////////////
l_text *DuplicateArgs (  int argc, l_text *argv ) {
	l_int n = 0;
	l_text *nargv = malloc(sizeof(l_text)*(argc+1));
	if ( !nargv ) return NULL;
	while ( n < argc ) {
		nargv[n] = TextDup(argv[n]);
		n++;	
	}
	nargv[argc] = 0;
	return nargv;
	
}
////////////////////////////////////////////////////////////////////////////////
void FreeArgs (  int argc, l_text *argv ) {
	l_int n = 0;
	while ( n < argc ) {
		free(argv[n]);
		n++;	
	}
	free(argv);
}
////////////////////////////////////////////////////////////////////////////////
void RegistryLoadLibraries ( l_text Name )
{
	PRegKey o =	ResolveKey(Name);
	//
	if ( !o )
	   return;
	DebugMessage("Run registry entries form %s",Name);
	if ( o->Last ) {
		PRegKey a = o->Last->Next;
		PRegKey b = a;
		l_uid id;
		do {
			memset(&id,0,sizeof(l_uid));
			TextCopy((l_text)&id,a->Name);
			LoadLibrary(id);
			a = a->Next;
		} while ( a != b );
	}
}
////////////////////////////////////////////////////////////////////////////////
void InitDynLd ( void )
{
	MsgInit( "InitDynLd" );
	Symbols = NewList();

	if ( !Symbols )
	{
	   MsgInitErr();
	   DebugFatal("DynLd::ERROR_NOTENOUGHMEMORY");
	}

	Applications = NewList();

	if ( !Applications )
	{
	   MsgInitErr();
	   DebugFatal("DynLd::ERROR_NOTENOUGHMEMORY");
	}

	AppExtenders = NewList();

	if ( !AppExtenders )
	{
	   MsgInitErr();
	   DebugFatal("DynLd::ERROR_NOTENOUGHMEMORY");
	}

	SYSEXPORT(AddSymbol);
	SYSEXPORT(CloseApp);
	SYSEXPORT(ResolveSymbol);
	SYSEXPORT(DynLdInstallLibrary);

	SYSEXPORT(InstallAppExtender);
	SYSEXPORT(RemoveAppExtender);

	SYSEXPORT(_ParseArgs);
	SYSEXPORT(FreeArgs);
	SYSEXPORT(BreakApp);

	SYSEXPORTAS (Applications, "DynLdApplications");
	SYSEXPORT(DynLdRun);
	SYSEXPORT(DynLdRun2);
	SYSEXPORT(DynLdRunEx);
	SYSEXPORT(DynLdCommand);
	//
	DynLdTCPId = InstallTask(DynLdTCP);
	//
	MsgInitOk();
}

void ShutDownDynLd ( void )
{
	DebugMessage ("Shutting down DynLd...");

	RemoveTask(DynLdTCPId);


	if ( Applications->Last )
	{
		PListItem a = Applications->Last;
		PListItem b = a;
		PApplication App;

		do
		{
//			SysPoll();
			App = (PApplication)(a->Data);
			MsgInit("Cerrando '%s'", App->Name);
			if ( App->Close )
			{
				DebugMessage ("Close :: %s",App->Name);
				App->Close();
				App->Close = NULL;
			}
			DebugMessage("AppExtendersDeInit");
			AppExtendersDeInit(App);
			MsgInitOk();
			_flush_disk_cache();
			a = a->Prev;
		} while ( a != b );
	}

	FreeList(Symbols);
	FreeList(Applications);
	FreeList(AppExtenders);

	DebugMessage ("DynLd Stopped");
}
////////////////////////////////////////////////////////////////////////////////
