#include <kernel.h>
//
l_ulong AppVersion	= ULONG_ID(0,0,0,1);
char AppName[]		= "Allegro Dialog Gui Library";
l_uid nUID			= "AlleGui";
l_uid NeededLibs[] = { "window", "widget", "" };
//
void data2bmp(unsigned char d[], BITMAP *b, int w, int h);
void bill_init_radio_buttons();
typedef char *(*getfuncptr)(int, int *);
//
#define windos_desktop       makecol( 0, 96, 160 )
#define windos_light         makecol( 224, 224, 224 )
#define windos_hlight        makecol( 250, 250, 250 )
#define windos_face          makecol( 192, 192, 192 )
#define windos_shadow        makecol( 128, 128, 128 )
#define windos_dkshadow      makecol( 30, 30, 30 )
#define windos_text          makecol( 30, 30, 30 )
#define windos_disabledtext  makecol( 128, 128, 128 )
#define windos_activetitle   makecol( 0, 0, 192 )
#define windos_titletext     makecol( 255, 255, 255 )
#define windos_framebg       makecol( 255, 255, 255 )
#define windos_mouse_message makecol( 255, 255, 192 )
#define windos_transparent   makecol( 255, 0, 255 )
#define windos_background    makecol( 0, 0, 0 )
//
static l_int tempRGB[ 10 ] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
//
BITMAP *DialogGuiScreen;
//
void TdBox( BITMAP *b, l_int x, l_int y, l_int w, l_int h, l_int stl )
{
   BITMAP *pattern;
   //
   if ( !tempRGB[0] )
   {
	  tempRGB[0] = ( windos_hlight );
	  tempRGB[1] = ( windos_light );
	  tempRGB[2] = ( windos_dkshadow );
	  tempRGB[3] = ( windos_shadow );
	  tempRGB[4] = ( windos_face );
	  tempRGB[5] = ( windos_framebg );
	  tempRGB[6] = ( windos_activetitle );
   }
   //
   if ( w > 0 && b )
   {
	  if ( h > 0 )
	  {
         if( stl & STL_OUT )
         {
			hline( b, x, y, x+w-1, tempRGB[0] );
			vline( b, x, y, y+h-1, tempRGB[0] );
			hline( b, x+1, y+1, x+w-2, tempRGB[1]);
			vline( b, x+1, y+1, y+h-2, tempRGB[1] );
			hline( b, x, y+h, x+w, tempRGB[2] );
			vline( b, x+w, y, y+h, tempRGB[2] );
			hline( b, x+1, y+h-1, x+w-1, tempRGB[3] );
			vline( b, x+w-1, y+1, y+h-2, tempRGB[3]);
		 }
		 else if( stl & STL_IN )
		 {
			if ( !( stl & STL_BUTTONDOWN ) )
			{
			   hline( b, x, y+h, x+w, tempRGB[0] );
			   vline( b, x+w, y, y+h, tempRGB[0] );
			   hline( b, x+1, y+h-1, x+w-1, tempRGB[1] );
			   vline( b, x+w-1, y+1, y+h-2, tempRGB[1] );
			   if ( stl & STL_FRAME )
			   {
				  hline( b, x+1, y+1, x+w-1, tempRGB[2] );
				  vline( b, x+1, y+1, y+h-1, tempRGB[2] );
				  hline( b, x, y, x+w, tempRGB[3] );
				  vline( b, x, y, y+h, tempRGB[3] );
			   }
			   else
			   {
				  hline( b, x, y, x+w, tempRGB[2] );
				  vline( b, x, y, y+h, tempRGB[2] );
				  hline( b, x+1, y+1, x+w-1, tempRGB[3] );
				  vline( b, x+1, y+1, y+h-1, tempRGB[3] );
			   }
			}
			else
			{
			   rect( b, x, y, x+w, y+h, tempRGB[2]);
			   rect( b, x+1, y+1, x+w-1, y+h-1, tempRGB[3]);
			}
		 }
		 if ( ( stl & STL_DOWN ) || ( stl & STL_UP ) )
		 {
			x+=2;
			y+=2;
			if( w > 0 )
			   w-=4;
			else
			   w+=4;
			if( h>0 )
			   h-=4;
			else
			   h+=4;
		 }
		 //
		 if ( stl & STL_FLAT )
		 {
			rectfill( b, x, y, x+w, y+h, tempRGB[4]);
		 }
		 else if( stl & STL_FRAMEFILLED )
		 {
			rectfill( b, x, y, x+w, y+h, tempRGB[5]);
		 }
		 else if( stl & STL_DITHERED )
		 {
			pattern = create_bitmap( 2, 2 );
			putpixel( pattern, 0, 1, tempRGB[1] );
			putpixel( pattern, 1, 0, tempRGB[1] );
			putpixel( pattern, 0, 0, tempRGB[0] );
			putpixel( pattern, 1, 1, tempRGB[0] );
			drawing_mode( DRAW_MODE_COPY_PATTERN, pattern, 0, 0 );
			rectfill( b, x, y, x+w, y+h, 0 );
			solid_mode();
			destroy_bitmap( pattern );
			text_mode( -1 );
		 }
		 else if( stl & STL_TITLEBAR )
		 {
				  rectfill( b, x, y, x+w, y+h, tempRGB[6]);//( windos_activetitle ) );
		 }
		 else if( stl & STL_PROGRESSBAR )
		 {
				  rectfill( b, x, y, x+w, y+h, tempRGB[6]);//( windos_activetitle ) );
		 }
	  }
   }
}
/****************************************************************************/
static unsigned char radio_unsel_data[ 144 ] =
{
   0, 0, 0, 0, 4, 4, 4, 4, 0, 0, 0, 0,
   0, 0, 4, 4, 5, 5, 5, 5, 4, 4, 0, 0,
   0, 4, 5, 5, 2, 2, 2, 2, 5, 5, 1, 0,
   0, 4, 5, 2, 2, 2, 2, 2, 2, 3, 1, 0,
   4, 5, 2, 2, 2, 2, 2, 2, 2, 2, 3, 1,
   4, 5, 2, 2, 2, 2, 2, 2, 2, 2, 3, 1,
   4, 5, 2, 2, 2, 2, 2, 2, 2, 2, 3, 1, 
   4, 5, 2, 2, 2, 2, 2, 2, 2, 2, 3, 1,
   0, 4, 5, 2, 2, 2, 2, 2, 2, 3, 1, 0, 
   0, 4, 3, 3, 2, 2, 2, 2, 3, 3, 1, 0, 
   0, 0, 1, 1, 3, 3, 3, 3, 1, 1, 0, 0, 
   0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0
};
/****************************************************************************/
static unsigned char radio_sel_data[ 144 ] =
{
   0, 0, 0, 0, 4, 4, 4, 4, 0, 0, 0, 0, 
   0, 0, 4, 4, 5, 5, 5, 5, 4, 4, 0, 0,
   0, 4, 5, 5, 2, 2, 2, 2, 5, 5, 1, 0, 
   0, 4, 5, 2, 2, 2, 2, 2, 2, 3, 1, 0, 
   4, 5, 2, 2, 2, 6, 6, 2, 2, 2, 3, 1, 
   4, 5, 2, 2, 6, 6, 6, 6, 2, 2, 3, 1,
   4, 5, 2, 2, 6, 6, 6, 6, 2, 2, 3, 1,
   4, 5, 2, 2, 2, 6, 6, 2, 2, 2, 3, 1, 
   0, 4, 5, 2, 2, 2, 2, 2, 2, 3, 1, 0, 
   0, 4, 3, 3, 2, 2, 2, 2, 3, 3, 1, 0,
   0, 0, 1, 1, 3, 3, 3, 3, 1, 1, 0, 0, 
   0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0
};
/****************************************************************************/
static unsigned char radio_grey_data[ 144 ] =
{
   0, 0, 0, 0, 4, 4, 4, 4, 0, 0, 0, 0, 
   0, 0, 4, 4, 5, 5, 5, 5, 4, 4, 0, 0,
   0, 4, 5, 5, 7, 7, 7, 7, 5, 5, 1, 0, 
   0, 4, 5, 7, 7, 7, 7, 7, 7, 3, 1, 0, 
   4, 5, 7, 7, 7, 7, 7, 7, 7, 7, 3, 1, 
   4, 5, 7, 7, 7, 7, 7, 7, 7, 7, 3, 1,
   4, 5, 7, 7, 7, 7, 7, 7, 7, 7, 3, 1, 
   4, 5, 7, 7, 7, 7, 7, 7, 7, 7, 3, 1, 
   0, 4, 5, 7, 7, 7, 7, 7, 7, 3, 1, 0, 
   0, 4, 3, 3, 7, 7, 7, 7, 3, 3, 1, 0,
   0, 0, 1, 1, 3, 3, 3, 3, 1, 1, 0, 0,
   0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0
};
/****************************************************************************/
static void Data2Bmp( unsigned char d[], BITMAP *b, int w, int h )
{
   int pcolor;
   int x, y;
   //
   for ( y=0; y<h; y++ ) 
   {
	  for ( x=0; x<w; x++ )
      {
         if( d[ y*w+x ] == 1 )
			pcolor = ( windos_hlight );
		 else if( d[ y*w+x ] == 2 )
			pcolor = ( windos_framebg );
         else if( d[ y*w+x ] == 3 )
			pcolor = ( windos_light );
		 else if( d[ y*w+x ] == 4 )
			pcolor = ( windos_shadow );
         else if( d[ y*w+x ] == 5 )
			pcolor = ( windos_dkshadow );
		 else if( d[ y*w+x ] == 6 )
			pcolor = ( windos_dkshadow );
		 else if( d[ y*w+x ] == 7 )
			pcolor = ( windos_face );
         else
         {
            if ( bitmap_color_depth( b ) == 8 )
               pcolor = 0;
			else
               pcolor = makecol( 255, 0, 255 );
         }
         putpixel( b, x, y, pcolor );
	  }
   } 
}
/****************************************************************************/
void InitRadioButtons( void )
{
   if( !radio_unsel ) 
      destroy_bitmap( radio_unsel );
   if( !radio_sel )
      destroy_bitmap( radio_sel );
   if( !radio_grey )
	  destroy_bitmap( radio_grey );
   //
   radio_unsel = create_bitmap( 12, 12 );
   radio_sel = create_bitmap( 12, 12 );
   radio_grey = create_bitmap( 12, 12 );
   //
   Data2Bmp( radio_unsel_data, radio_unsel, 12, 12 );
   Data2Bmp( radio_sel_data, radio_sel, 12, 12 );
   Data2Bmp( radio_grey_data, radio_grey, 12, 12 );
}
/****************************************************************************/
static char *uconvert_static_string( char *str )
{
   int size;
   char *new_str;
   //
   if ( need_uconvert( str, U_ASCII, U_CURRENT ) )
   {
	  size = uconvert_size( str, U_ASCII, U_CURRENT );
      new_str = malloc( size );
      do_uconvert( str, U_ASCII, new_str, U_CURRENT, size );
      //
      return new_str;
   }
   //
   return str;
}
/****************************************************************************/
void uConvertStaticDialog( DIALOG *d )
{
   while ( d->proc )
   {
	  if ( ( d->proc == ButtonProcedure ) || ( d->proc == CentreTextProcedure ) )
	  {
		 if ( d->dp )
			d->dp = uconvert_static_string( ( char * )d->dp );
		 if ( d->dp3 )
			d->dp3 = uconvert_static_string( ( char * )d->dp3 );
	  }
	  else if ( d->proc == ListProcedure )
	  {
		 if ( d->dp3 )
			d->dp3 = uconvert_static_string( ( char * )d->dp3 );
	  }
	  d++;
   }
}
/****************************************************************************/
void PositionDialog( DIALOG *dialog, int x, int y )
{
   int min_x = INT_MAX;
   int min_y = INT_MAX;
   int xc, yc;
   int c;
   //
   ASSERT( dialog );
   //
   for ( c=0; dialog[ c ].proc; c++ ) 
   {
      if ( dialog[ c ].x < min_x )
         min_x = dialog[ c ].x;
      if ( dialog[ c ].y < min_y )
         min_y = dialog[ c ].y;
   }
   xc = min_x - x;
   yc = min_y - y;
   for ( c=0; dialog[ c ].proc; c++ ) 
   {
      dialog[ c ].x -= xc;
      dialog[ c ].y -= yc;
   }
}
/****************************************************************************/
void DrawDialog( PDialog d )
{
   int nowhere;
   //
   if ( !d || !d->player )
	  return;
   //
   d->player->res &= ~D_WANTFOCUS;
   DialogMessage( d->dialog, MSG_DRAW, 0, &nowhere );
}
/****************************************************************************/
void DialogConsoleDraw( PWidget o, p_bitmap buffer, PRect w )
{
	l_long sx = o->Absolute.a.x, sy = o->Absolute.a.y;
	PDialog d = DIAGWDG( o )->o;
	DIALOG *dlg = d->dialog;
	l_int nowhere;
	//
	DialogGuiScreen = buffer;
	PositionDialog( dlg, sx, sy );
	d->player->res |= DialogMessage( d->player->dialog, MSG_DRAW, 0, &nowhere );//&d->player->obj );
	UpdateDialog( d );
}
/****************************************************************************/
static l_int DialogGuiTecla = 0;
static l_int DialogGuiMouseX = 0;
static l_int DialogGuiMouseY = 0;
static l_int DialogGuiMouseZ = 0;
static l_int DialogGuiMouseB = 0;
//
l_bool DialogConsoleEventHandler ( PWidget o, PEvent Ev )
{
//	if ( WIDGET( o )->Flags & WFFocused )
	{
	   if ( Ev->Type == EV_KEYBOARD )
	   {
		  DialogGuiTecla = Ev->Keyb.Key;
		  //
		  return true;
	   }
	   else if ( Ev->Type == EV_MOUSE )
	   {
		  DialogGuiMouseX = Mouse->State.p.x;
		  DialogGuiMouseY = Mouse->State.p.y;
		  DialogGuiMouseZ = Mouse->State.z;
		  DialogGuiMouseB = Mouse->State.b;
		  //
		  return true;
	   }
	}
	//
	DialogGuiTecla  = 0;
	DialogGuiMouseX = 0;
	DialogGuiMouseY = 0;
	DialogGuiMouseZ = 0;
	DialogGuiMouseB = 0;
	//
	return false;
}
//
l_bool DialogAppEventHandler ( PWidget o, PEvent Ev )
{
	if ( Ev->Type == EV_MESSAGE )
	{
		if ( Ev->Message == WM_CLOSE )
		{
			BreakApp(o->AppOwner);
			return true;
		}
	}
	//
	return false;
}
/****************************************************************************/
void DialogTimerPoll( void *D )
{
	WidgetDraw( WIDGET( DIALOGUE( D )->Box ), NULL );
}
/****************************************************************************/
void CloseDialog( PDialog Dlg )
{
   KillTimer( Dlg->T );
   WidgetDispose( WIDGET( Dlg->Win ) );
   free( Dlg );
}
/****************************************************************************/
DIALOG_STATE DefaultDialogHandler( int c )
{
   return state_exit;
}
/****************************************************************************/
PDialog ActivateDialog( PApplication App, DIALOG *dlg, int chain, DIALOG_STATE ( *handler )( int c ) )
{
	PDialog Diag;
	TRect r;
	//
	Diag = malloc( sizeof( TDialog ) );
	memset( Diag, 0, sizeof( TDialog ) );
	//
	RectAssign( &r, dlg[ 0 ].x, dlg[ 0 ].y, dlg[ 0 ].w, dlg[ 0 ].h );
	Diag->Win = CreateWindow( App, r, (l_text)dlg[ 0 ].dp, WF_FRAME | WF_CAPTION | WF_MINIMIZE | WF_CENTERED );
	WIDGET( Diag->Win )->AppEvHdl = &DialogAppEventHandler;
	InsertWidget( WIDGET( DeskTop ), WIDGET( Diag->Win ) );
	//
	Diag->Box = malloc( sizeof( TDiagWdg ) );
	memset( Diag->Box, 0, sizeof( TDiagWdg ) );
	IntialiseWidget( App, StdWidgetClass, WIDGET( Diag->Box ), r );
	WIDGET( Diag->Box )->Draw = &DialogConsoleDraw;
	WIDGET( Diag->Box )->EventHandler = &DialogConsoleEventHandler;
	WIDGET( Diag->Box )->Flags |= WFForceBuffer | WFFocusable;
	//
	Diag->state   = state_start;
	Diag->dialog  = dlg;
	Diag->player  = InitDialog( dlg, chain );
	Diag->handler = ( !handler ? DefaultDialogHandler : handler );
	//
	uConvertStaticDialog( dlg );
	//
	Diag->Box->o = Diag;
	InsertWidget( WIDGET( Diag->Win ), WIDGET( Diag->Box ) );
	//
	Diag->T = NewTimer( App, 20, &DialogTimerPoll, Diag );
	//
	WidgetDrawAll( WIDGET( Diag->Win ) );
	//
	return Diag;
}
/****************************************************************************/
int UpdateDialog( PDialog d )
{
   DIALOG_STATE state;
   int ret = TRUE;
   //
   if ( !d || !d->player )
	  return FALSE;
   //
   if ( d->state == state_active )
   {
	  ret = UpdateWindow( d->player );
	  if ( !ret )
	  {
		 if ( d->handler )
		 {
			state = d->handler( d->player->obj );
		 }
		 else
		 {
			state = state_exit;
		 }
		 //
		 if ( state == state_exit )
		 {
			d->state   = state_exit;
		 }
		 else if ( state == state_redraw )
		 {
			d->player->res |= D_REDRAW;
		 }
	  }
	  else
	  {
		 ret = FindDialogFocus( d->dialog );
	  }
   }
   else
   {
	  d->state = state_active;
	  d->player->res |= D_REDRAW;
   }
   //
   return ret;
}
/****************************************************************************/
BITMAP *radio_unsel;
BITMAP *radio_sel;
BITMAP *radio_grey;
/****************************************************************************/
int GuiMouseFocus = TRUE;
int GuiFontBaseline = 0;
//
DIALOG_PLAYER *ActiveDialogPlayer = NULL;
GUIMENU_PLAYER *ActiveMenuPlayer = NULL;
static int ActiveMenuPlayerZombie = FALSE;
DIALOG *ActiveDialog = NULL;
GUIMENU *ActiveMenu = NULL;
//
struct AlActiveDialogPlayer
{
   DIALOG_PLAYER *player;
   struct AlActiveDialogPlayer *next;
};
//
static struct AlActiveDialogPlayer *FirstActiveDialogPlayer = 0;
static struct AlActiveDialogPlayer *CurrentActiveDialogPlayer = 0;
static int ShutdownSingleMenu( GUIMENU_PLAYER *, int * );
/****************************************************************************/
static int DefaultMouseX( void )
{
   return DialogGuiMouseX;
} END_OF_STATIC_FUNCTION( DefaultMouseX );
/****************************************************************************/
static int DefaultMouseY( void )
{
   return DialogGuiMouseY;
} END_OF_STATIC_FUNCTION( DefaultMouseY );
/****************************************************************************/
static int DefaultMouseZ( void )
{
   return DialogGuiMouseZ;
} END_OF_STATIC_FUNCTION( DefaultMouseZ );
/****************************************************************************/
static int DefaultMouseB( void )
{
   return DialogGuiMouseB;
} END_OF_STATIC_FUNCTION( DefaultMouseB );
/****************************************************************************/
int MouseX( void )
{
   return DefaultMouseX();
}
/****************************************************************************/
int MouseY( void )
{
   return DefaultMouseY();
}
/****************************************************************************/
int MouseZ( void )
{
   return DefaultMouseZ();
}
/****************************************************************************/
int MouseB( void )
{
   return DefaultMouseB();
}
/****************************************************************************/
int ( *GuiMouseX )( void ) = DefaultMouseX;
int ( *GuiMouseY )( void ) = DefaultMouseY;
int ( *GuiMouseZ )( void ) = DefaultMouseZ;
int ( *GuiMouseB )( void ) = DefaultMouseB;
/****************************************************************************/
static int GuiTimer;
static int GuiMenuOpeningDelay;
static volatile int DoubleClickStatus, DoubleClickTime;
static int GuiInstallCount = 0;
static int GuiInstallTime = 0;
/****************************************************************************/
#define DCLICK_START             0
#define DCLICK_RELEASE           1
#define DCLICK_AGAIN             2
#define DCLICK_NOT               3
/****************************************************************************/
static void DoubleClickCheck( void )
{
   GuiTimer++;
   if ( DoubleClickStatus==DCLICK_START )
   {
	  if ( !GuiMouseB() )
	  {
		 DoubleClickStatus = DCLICK_RELEASE;
		 DoubleClickTime = 0;
		 return;
	  }
   }
   else if ( DoubleClickStatus==DCLICK_RELEASE )
   {
	  if ( GuiMouseB() )
	  {
		 DoubleClickStatus = DCLICK_AGAIN;
		 DoubleClickTime = 0;
		 return;
	  }
   }
   else
	  return;
   //
   if ( DoubleClickTime++ > 10 )
	  DoubleClickStatus = DCLICK_NOT;
   //
} END_OF_STATIC_FUNCTION( DoubleClickCheck );
/****************************************************************************/
static void GuiSwitchCallback( void )
{
   if ( ActiveDialogPlayer )
      ActiveDialogPlayer->res |= D_REDRAW_ALL;
}
/****************************************************************************/
void CentreDialog( DIALOG *dialog )
{
/*   int min_x = INT_MAX;
   int min_y = INT_MAX;
   int max_x = INT_MIN;
   int max_y = INT_MIN;
   int xc, yc;
   int c;
   //
   ASSERT( dialog );
   //
   for ( c=0; dialog[ c ].proc; c++ ) 
   {
      if ( dialog[ c ].x < min_x )
		 min_x = dialog[ c ].x;
   }
   for ( c=0; dialog[ c ].proc; c++ ) 
   {
      if ( dialog[ c ].y < min_y )
         min_y = dialog[ c ].y;
   }
   for ( c=0; dialog[ c ].proc; c++ ) 
   {
      if ( dialog[ c ].x + dialog[ c ].w > max_x )
         max_x = dialog[ c ].x + dialog[ c ].w;
   }
   for ( c=0; dialog[ c ].proc; c++ ) 
   {
      if ( dialog[ c ].y + dialog[ c ].h > max_y )
         max_y = dialog[ c ].y + dialog[ c ].h;
   }
   xc = ( SCREEN_W - ( max_x - min_x ) ) / 2 - min_x;
   yc = ( SCREEN_H - ( max_y - min_y ) ) / 2 - min_y;
   for ( c=0; dialog[ c ].proc; c++ )
   {
	  dialog[ c ].x += xc;
	  dialog[ c ].y += yc;
   } */
}
/****************************************************************************/
void SetDialogColor( DIALOG *dialog, int fg, int bg )
{
   int c;
   //
   ASSERT( dialog );
   //
   for ( c=0; dialog[ c ].proc; c++ ) 
   {
      dialog[ c ].fg = fg;
      dialog[ c ].bg = bg;
   }
}
/****************************************************************************/
int FindDialogFocus( DIALOG *dialog )
{
   int c;
   //
   ASSERT( dialog );
   //
   for ( c=0; dialog[ c ].proc; c++ )
   {
      if ( dialog[ c ].flags & D_GOTFOCUS )
         return c;
   }
   //
   return -1;
}
/****************************************************************************/
int ObjectMessage( DIALOG *dialog, int msg, int c )
{
   int ret;
   //
   ASSERT( dialog );
   //
   if ( msg == MSG_DRAW )
   {
	  if ( dialog->flags & D_HIDDEN )
		 return D_O_K;
   }
   ret = dialog->proc( msg, dialog, c );
   if ( ret & D_REDRAWME )
   {
	  dialog->flags |= D_DIRTY;
	  ret &= ~D_REDRAWME;
   }
   //
   return ret;
}
/****************************************************************************/
int DialogMessage( DIALOG *dialog, int msg, int c, int *obj )
{
   int count, res, r, force, try = 1;
   DIALOG *menu_dialog = NULL;
   //
   ASSERT( dialog );
   //
   force = ( ( msg == MSG_START ) || ( msg == MSG_END ) || ( msg >= MSG_USER ) );
   res = D_O_K;
   if ( ActiveMenuPlayer ) 
   {
      try = 2;
      menu_dialog = ActiveMenuPlayer->dialog;
   }
   //
   for ( ; try > 0; try-- )
   {
      for ( count=0; dialog[ count ].proc; count++ )
      {
         if ( ( try == 2 ) && ( &dialog[ count ] != menu_dialog ) )
            continue;
         if ( ( force ) || ( !( dialog[ count ].flags & D_HIDDEN ) ) )
         {
            r = ObjectMessage( &dialog[ count ], msg, c );
            if ( r != D_O_K )
			{
               res |= r;
               if ( obj )
                  *obj = count;
            }
            if ( ( msg == MSG_IDLE ) && ( dialog[ count ].flags & ( D_DIRTY | D_HIDDEN ) ) == D_DIRTY )
            {
               dialog[ count ].flags &= ~D_DIRTY;
               ObjectMessage( dialog+count, MSG_DRAW, 0 );
            }
         }
      }
   }
   //
   return res;
}
/****************************************************************************/
int BroadcastDialogMessage( int msg, int c )
{
   int nowhere;
   if ( ActiveDialog )
      return DialogMessage( ActiveDialog, msg, c, &nowhere );
   else
      return D_O_K;
}
/****************************************************************************/
static int FindMouseObject( DIALOG *d )
{
   int mouse_object = -1;
   int c;
   //
   ASSERT( d );
   //
   for ( c=0; d[ c ].proc; c++ )
   {
      if ( ( GuiMouseX() >= d[ c ].x ) && ( GuiMouseY() >= d[ c ].y ) && ( GuiMouseX() < d[ c ].x + d[ c ].w ) && ( GuiMouseY() < d[ c ].y + d[ c ].h ) && ( !( d[ c ].flags & ( D_HIDDEN | D_DISABLED ) ) ) )
      {
            mouse_object = c;
      }
   }
   //
   return mouse_object;
}
/****************************************************************************/
int OfferFocus( DIALOG *dialog, int obj, int *focus_obj, int force )
{
   int res = D_O_K;
   //
   ASSERT( dialog );
   ASSERT( focus_obj );
   if ( ( obj == *focus_obj ) || ( ( obj >= 0 ) && ( dialog[ obj ].flags & ( D_HIDDEN | D_DISABLED ) ) ) )
      return D_O_K;
   if ( obj >= 0 ) 
   {
      res = ObjectMessage( dialog+obj, MSG_WANTFOCUS, 0 );
      if ( res & D_WANTFOCUS )
         res ^= D_WANTFOCUS;
      else
         obj = -1;
   }
   if ( ( obj >= 0 ) || ( force ) )
   {
      if ( *focus_obj >= 0 ) 
      {
         res |= ObjectMessage( dialog+*focus_obj, MSG_LOSTFOCUS, 0 );
         if ( res & D_WANTFOCUS ) 
         {
            if ( obj < 0 )
               return D_O_K;
            else
               res &= ~D_WANTFOCUS;
         }
         dialog[ *focus_obj ].flags &= ~D_GOTFOCUS;
         res |= ObjectMessage( dialog+*focus_obj, MSG_DRAW, 0 );
      }
      *focus_obj = obj;
      if ( obj >= 0 ) 
      {
         dialog[ obj ].flags |= D_GOTFOCUS;
         res |= ObjectMessage( dialog+obj, MSG_GOTFOCUS, 0 );
		 res |= ObjectMessage( dialog+obj, MSG_DRAW, 0 );
      }
   }
   return res;
}
/****************************************************************************/
#define MAX_OBJECTS              512
//
typedef struct OBJ_LIST
{
   int index;
   int diff;
} OBJ_LIST;
/****************************************************************************/
#define DISTANCE_RATIO           8
#define MAX_SIZE                 0x10000
//
enum axis { X_AXIS, Y_AXIS };
/****************************************************************************/
static int ObjListCmp( AL_CONST void *e1, AL_CONST void *e2 )
{
   return ( ( ( OBJ_LIST * )e1 )->diff - ( ( OBJ_LIST * )e2 )->diff );
}
/****************************************************************************/
static int CmpTab( AL_CONST DIALOG *d1, AL_CONST DIALOG *d2 )
{
   int ret = ( int )( ( AL_CONST unsigned long )d2 - ( AL_CONST unsigned long )d1 );
   //
   if ( ret < 0 )
      ret += MAX_SIZE;
   return ret;
}
/****************************************************************************/
static int CmpShiftTab( AL_CONST DIALOG *d1, AL_CONST DIALOG *d2 )
{
   int ret = ( int )( ( AL_CONST unsigned long )d1 - ( AL_CONST unsigned long )d2 );
   //
   if ( ret < 0 )
      ret += MAX_SIZE;
   return ret;
}
/****************************************************************************/
static int MinDist( AL_CONST DIALOG *d1, AL_CONST DIALOG *d2, enum axis main_axis, int bias )
{
   int x_left = d1->x - d2->x - d2->w + 1;
   int x_right = d2->x - d1->x - d1->w + 1;
   int y_top = d1->y - d2->y - d2->h + 1;
   int y_bottom = d2->y - d1->y - d1->h + 1;
   //
   if ( main_axis == X_AXIS ) 
   {
      x_left -= bias;
      x_right += bias;
      y_top *= DISTANCE_RATIO;
      y_bottom *= DISTANCE_RATIO;
   }
   else 
   {
      x_left *= DISTANCE_RATIO;
      x_right *= DISTANCE_RATIO;
	  y_top -= bias;
      y_bottom += bias;
   }
   if ( x_left > 0 )
   {
      if ( y_top > 0 ) 
         return x_left + y_top;
      else if ( y_bottom > 0 ) 
         return x_left + y_bottom;
      else 
         return x_left;
   }
   else if ( x_right > 0 )
   {
      if ( y_top > 0 ) 
         return x_right + y_top;
      else if ( y_bottom > 0 ) 
         return x_right + y_bottom;
      else 
         return x_right;
   }
   else if ( y_top > 0 ) 
      return y_top;
   else if ( y_bottom > 0 ) 
      return y_bottom;
   //
   return 0;
}
/****************************************************************************/
static int CmpRight( AL_CONST DIALOG *d1, AL_CONST DIALOG *d2 )
{
   int bias;
   //
   if ( d2->x < d1->x + d1->w )
      bias = +SCREEN_W;
   else
      bias = 0;
   //
   return MinDist( d1, d2, X_AXIS, bias );
}
/****************************************************************************/
static int CmpLeft( AL_CONST DIALOG *d1, AL_CONST DIALOG *d2 )
{
   int bias;
   //
   if ( d2->x + d2->w > d1->x )
      bias = -SCREEN_W;
   else
      bias = 0;
   //
   return MinDist( d1, d2, X_AXIS, bias );
}
/****************************************************************************/
static int CmpDown( AL_CONST DIALOG *d1, AL_CONST DIALOG *d2 )
{
   int bias;
   //
   if ( d2->y < d1->y + d1->h )
      bias = +SCREEN_H;
   else
	  bias = 0;
   //
   return MinDist( d1, d2, Y_AXIS, bias );
}
/****************************************************************************/
static int CmpUp( AL_CONST DIALOG *d1, AL_CONST DIALOG *d2 )
{
   int bias;
   //
   if ( d2->y + d2->h > d1->y )
      bias = -SCREEN_H;
   else
      bias = 0;
   //
   return MinDist( d1, d2, Y_AXIS, bias );
}
/****************************************************************************/
static int MoveFocus( DIALOG *d, int ascii, int scan, int *focus_obj )
{
   int ( *cmp )( AL_CONST DIALOG *d1, AL_CONST DIALOG *d2 );
   OBJ_LIST obj[ MAX_OBJECTS ];
   int obj_count = 0;
   int fobj, c;
   int res = D_O_K;
   //
   ASSERT( d );
   //
   switch ( scan ) 
   {
      case KEY_TAB:
         cmp = ( ascii == '\t' ) ? CmpTab : CmpShiftTab;
         break;
      case KEY_RIGHT:
         cmp = CmpRight;
         break;
      case KEY_LEFT:
         cmp = CmpLeft;
         break;
      case KEY_DOWN:
         cmp = CmpDown;
		 break;
      case KEY_UP:
         cmp = CmpUp;
         break;
      default:
         return D_O_K;
   }
   for ( c=0; d[ c ].proc; c++ ) 
   {
      if ( ( ( *focus_obj < 0 ) || ( c != *focus_obj ) ) && !( d[ c ].flags & ( D_DISABLED | D_HIDDEN ) ) ) 
      {
         obj[ obj_count ].index = c;
         if ( *focus_obj >= 0 )
            obj[ obj_count ].diff = cmp( d+*focus_obj, d+c );
         else
            obj[ obj_count ].diff = c;
         obj_count++;
         if ( obj_count >= MAX_OBJECTS )
            break;
      }
   }
   qsort( obj, obj_count, sizeof( OBJ_LIST ), ObjListCmp );
   fobj = *focus_obj;
   for ( c=0; c<obj_count; c++ ) 
   {
      res |= OfferFocus( d, obj[ c ].index, focus_obj, FALSE );
	  if ( fobj != *focus_obj )
         break;
   }
   //
   return res;
}
/****************************************************************************/
#define GUI_MESSAGE( i, msg, c ) { r = ObjectMessage( player->dialog+i, msg, c ); if ( r != D_O_K ) { player->res |= r; player->obj = i; } }
/****************************************************************************/
int DoDialog( DIALOG *dialog, int focus_obj )
{
   void *player;
   l_int nowhere;
   //
   ASSERT( dialog );
   //
   player = InitDialog( dialog, focus_obj );
   //
   while( UpdateWindow( player ) )
   {
//      RefreshScreen();
	  DialogMessage( dialog, MSG_DRAW, 0, &nowhere );
   }
   //
   return ShutdownDialog( player );
}
/****************************************************************************/
int PopupDialog( DIALOG *dialog, int focus_obj )
{
   int ret;
   //
   ASSERT( dialog );
   //
   ret = DoWindow( dialog, focus_obj );
   //
   return ret;
}
/****************************************************************************/
DIALOG_PLAYER *InitDialog( DIALOG *dialog, int focus_obj )
{
   DIALOG_PLAYER *player;
   struct AlActiveDialogPlayer *n;
   char tmp1[ 64 ], tmp2[ 64 ];
   int c;
   //
   ASSERT( dialog );
   //
   if ( ActiveMenuPlayer )
      ObjectMessage( ActiveMenuPlayer->dialog, MSG_LOSTMOUSE, 0 );
   //
   player = malloc( sizeof( DIALOG_PLAYER ) );
   if ( !player ) 
   {
      *allegro_errno = ENOMEM;
	  return NULL;
   }
   n = malloc( sizeof( struct AlActiveDialogPlayer ) );
   if ( !n ) 
   {
      *allegro_errno = ENOMEM;
	  free( player );
      return NULL;
   }
   n->next = NULL;
   n->player = player;
   if ( !CurrentActiveDialogPlayer ) 
   {
      CurrentActiveDialogPlayer = FirstActiveDialogPlayer = n;
   }
   else 
   {
      CurrentActiveDialogPlayer->next = n;
      CurrentActiveDialogPlayer = n;
   }
   player->res = D_REDRAW;
   player->joy_on = TRUE;
   player->click_wait = FALSE;
   player->dialog = dialog;
   player->obj = -1;
   player->mouse_obj = -1;
   player->mouse_oz = GuiMouseZ();
   player->mouse_b = GuiMouseB();
   ActiveDialogPlayer = player;
   ActiveDialog = dialog;
   if ( GuiInstallCount <= 0 ) 
   {
      LOCK_VARIABLE( GuiTimer );
      LOCK_VARIABLE( DoubleClickStatus );
      LOCK_VARIABLE( DoubleClickTime );
      LOCK_VARIABLE( GuiMouseX );
      LOCK_VARIABLE( GuiMouseY );
      LOCK_VARIABLE( GuiMouseZ );
      LOCK_VARIABLE( GuiMouseB );
      LOCK_FUNCTION( DefaultMouseX );
	  LOCK_FUNCTION( DefaultMouseY );
      LOCK_FUNCTION( DefaultMouseZ );
      LOCK_FUNCTION( DefaultMouseB );
      LOCK_FUNCTION( DoubleClickCheck );
	  install_int( DoubleClickCheck, 10 );
	  GuiMenuOpeningDelay = get_config_int( uconvert_ascii( "system", tmp1 ), uconvert_ascii( "menu_opening_delay", tmp2 ), 300 );
	  if ( GuiMenuOpeningDelay >= 0 )
	  {
		 GuiMenuOpeningDelay /= 20;
	  }
	  else
	  {
		 GuiMenuOpeningDelay = -1;
	  }
	  GuiInstallCount = 1;
	  GuiInstallTime = _allegro_count;
   }
   else
	  GuiInstallCount++;
   //
   player->res |= DialogMessage( dialog, MSG_START, 0, &player->obj );
   player->mouse_obj = FindMouseObject( dialog );
   if ( player->mouse_obj >= 0 )
      dialog[ player->mouse_obj ].flags |= D_GOTMOUSE;
   for ( c=0; dialog[ c ].proc; c++ )
      dialog[ c ].flags &= ~D_GOTFOCUS;
   if ( focus_obj >= 0 )
      c = focus_obj;
   else
      c = player->mouse_obj;
   if ( ( c >= 0 ) && ( ( ObjectMessage( dialog+c, MSG_WANTFOCUS, 0 ) ) & D_WANTFOCUS ) ) 
   {
      dialog[ c ].flags |= D_GOTFOCUS;
      player->focus_obj = c;
   }
   else
      player->focus_obj = -1;
   //
   return player;
}
/****************************************************************************/
static void CheckForRedraw( DIALOG_PLAYER *player )
{
   struct AlActiveDialogPlayer *iter;
   int c, r;
   //
   ASSERT( player );
   //
   if ( player->res & D_REDRAW_ALL )
   {
	  for ( iter = FirstActiveDialogPlayer; iter != CurrentActiveDialogPlayer; iter = iter->next )
		 DialogMessage( iter->player->dialog, MSG_DRAW, 0, NULL );
	  player->res &= ~D_REDRAW_ALL;
	  player->res |= D_REDRAW;
   }
   if ( player->res & D_REDRAW )
   {
	  player->res ^= D_REDRAW;
	  player->res |= DialogMessage( player->dialog, MSG_DRAW, 0, &player->obj );
   }
   for ( c=0; player->dialog[ c ].proc; c++ )
   {
	  if ( ( player->dialog[ c ].flags & ( D_DIRTY | D_HIDDEN ) ) == D_DIRTY )
	  {
		 player->dialog[ c ].flags &= ~D_DIRTY;
		 GUI_MESSAGE( c, MSG_DRAW, 0 );
	  }
   }
}
/****************************************************************************/
int UpdateWindow( DIALOG_PLAYER *player )
{
   int c, cascii = 0, cscan = 0, ccombo, r, ret, nowhere, z;
   int new_mouse_b;
   //
   ASSERT( player );
   //
   if ( ActiveMenuPlayer )
   {
      if ( !ActiveMenuPlayerZombie )
	  {
         if ( UpdateMenu( ActiveMenuPlayer ) )
            return TRUE;
      }
	  if ( GuiMouseB() )
      {
         ActiveMenuPlayerZombie = TRUE;
         return TRUE;
      }
      else
      {
         ActiveMenuPlayerZombie = FALSE;
         for ( c=0; player->dialog[ c ].proc; c++ )
         {
            if ( &player->dialog[ c ] == ActiveMenuPlayer->dialog )
               break;
         }
         ASSERT( player->dialog[ c ].proc );
         GUI_MESSAGE( c, MSG_LOSTMOUSE, 0 );
         goto getout;
	  }
   }
   if ( player->res & D_CLOSE )
      return FALSE;
   //
   new_mouse_b = GuiMouseB();
   if ( new_mouse_b != player->mouse_b )
   {
      player->res |= OfferFocus( player->dialog, player->mouse_obj, &player->focus_obj, FALSE );
      if ( player->mouse_obj >= 0 ) 
      {
         if ( ( new_mouse_b & 1 ) && !( player->mouse_b & 1 ) )
            GUI_MESSAGE( player->mouse_obj, MSG_LPRESS, new_mouse_b );
         if ( !( new_mouse_b & 1 ) && ( player->mouse_b & 1 ) )
            GUI_MESSAGE( player->mouse_obj, MSG_LRELEASE, new_mouse_b );
         if ( ( new_mouse_b & 4 ) && !( player->mouse_b & 4 ) )
            GUI_MESSAGE( player->mouse_obj, MSG_MPRESS, new_mouse_b );
         if ( !( new_mouse_b & 4 ) && ( player->mouse_b & 4 ) )
            GUI_MESSAGE( player->mouse_obj, MSG_MRELEASE, new_mouse_b );
         if ( ( new_mouse_b & 2 ) && !( player->mouse_b & 2 ) )
			GUI_MESSAGE( player->mouse_obj, MSG_RPRESS, new_mouse_b );
         if ( !( new_mouse_b & 2 ) && ( player->mouse_b & 2 ) )
            GUI_MESSAGE( player->mouse_obj, MSG_RRELEASE, new_mouse_b );
         player->mouse_b = new_mouse_b;
      }
      else
         player->res |= DialogMessage( player->dialog, MSG_IDLE, 0, &nowhere );
   }
   if ( GuiInstallTime != _allegro_count ) 
   {
	  install_int( DoubleClickCheck, 10 );
      GuiInstallTime = _allegro_count;
   }
   if ( player->click_wait ) 
   {
      if ( ( ABS( player->mouse_ox-GuiMouseX() ) > 8 ) || ( ABS( player->mouse_oy-GuiMouseY() ) > 8 ) )
         DoubleClickStatus = DCLICK_NOT;
      if ( ( DoubleClickStatus != DCLICK_AGAIN ) && ( DoubleClickStatus != DCLICK_NOT ) )
      {
		 player->res |= DialogMessage( player->dialog, MSG_IDLE, 0, &nowhere );
		 CheckForRedraw( player );
         //
         return TRUE;
      }
      player->click_wait = FALSE;
      if ( ( DoubleClickStatus==DCLICK_AGAIN ) && ( GuiMouseX() >= player->dialog[ player->mouse_obj ].x ) && ( GuiMouseY() >= player->dialog[ player->mouse_obj ].y ) && ( GuiMouseX() <= player->dialog[ player->mouse_obj ].x + player->dialog[ player->mouse_obj ].w ) && ( GuiMouseY() <= player->dialog[ player->mouse_obj ].y + player->dialog[ player->mouse_obj ].h ) )
      {
         GUI_MESSAGE( player->mouse_obj, MSG_DCLICK, 0 );
      }
      goto getout;
   }
   player->res &= ~D_USED_CHAR;
   if ( player->res & D_WANTFOCUS ) 
   {
      player->res ^= D_WANTFOCUS;
      player->res |= OfferFocus( player->dialog, player->obj, &player->focus_obj, FALSE );
   }
   c = FindMouseObject( player->dialog );
   if ( c != player->mouse_obj ) 
   {
      if ( player->mouse_obj >= 0 ) 
      {
         player->dialog[ player->mouse_obj ].flags &= ~D_GOTMOUSE;
         GUI_MESSAGE( player->mouse_obj, MSG_LOSTMOUSE, 0 );
      }
      if ( c >= 0 ) 
      {
         player->dialog[ c ].flags |= D_GOTMOUSE;
         GUI_MESSAGE( c, MSG_GOTMOUSE, 0 );
      }
      player->mouse_obj = c;
      if ( ( GuiMouseFocus ) && ( player->mouse_obj != player->focus_obj ) )
         player->res |= OfferFocus( player->dialog, player->mouse_obj, &player->focus_obj, TRUE );
   }
   if ( new_mouse_b ) 
   {
      player->res |= OfferFocus( player->dialog, player->mouse_obj, &player->focus_obj, FALSE );
      if ( player->mouse_obj >= 0 ) 
      {
         DoubleClickTime = 0;
         DoubleClickStatus = DCLICK_START;
         player->mouse_ox = GuiMouseX();
         player->mouse_oy = GuiMouseY();
         GUI_MESSAGE( player->mouse_obj, MSG_CLICK, new_mouse_b );
         if ( player->res == D_O_K )
            player->click_wait = TRUE;
      }
      else
         player->res |= DialogMessage( player->dialog, MSG_IDLE, 0, &nowhere );
   }
   z = GuiMouseZ();
   if ( z != player->mouse_oz ) 
   {
      player->res |= OfferFocus( player->dialog, player->mouse_obj, &player->focus_obj, FALSE );
      if ( player->mouse_obj >= 0 ) 
      {
         GUI_MESSAGE( player->mouse_obj, MSG_WHEEL, z-player->mouse_oz );
      }
      else
         player->res |= DialogMessage( player->dialog, MSG_IDLE, 0, &nowhere );
      player->mouse_oz = z;
   }
   //
/*   if ( player->joy_on )
      rest( 20 );
   //
   poll_joystick();
   //
   if ( player->joy_on ) 
   {
      if ( ( !joy[ 0 ].stick[ 0 ].axis[ 0 ].d1 ) && ( !joy[ 0 ].stick[ 0 ].axis[ 0 ].d2 ) && ( !joy[ 0 ].stick[ 0 ].axis[ 1 ].d1 ) && ( !joy[ 0 ].stick[ 0 ].axis[ 1 ].d2 ) && ( !joy[ 0 ].button[ 0 ].b ) && ( !joy[ 0 ].button[ 1 ].b ) ) 
      {
         player->joy_on = FALSE;
         rest( 20 );
      }
      cascii = cscan = 0;
   }
   else 
   {
      if ( joy[ 0 ].stick[ 0 ].axis[ 0 ].d1 ) 
      {
         cascii = 0;
         cscan = KEY_LEFT;
         player->joy_on = TRUE;
      }
      else if ( joy[ 0 ].stick[ 0 ].axis[ 0 ].d2 ) 
      {
         cascii = 0;
         cscan = KEY_RIGHT;
         player->joy_on = TRUE;
      }
      else if ( joy[ 0 ].stick[ 0 ].axis[ 1 ].d1 ) 
      {
         cascii = 0;
         cscan = KEY_UP;
         player->joy_on = TRUE;
      }
      else if ( joy[ 0 ].stick[ 0 ].axis[ 1 ].d2 ) 
      {
         cascii = 0;
         cscan = KEY_DOWN;
         player->joy_on = TRUE;
      }
      else if ( ( joy[ 0 ].button[ 0 ].b ) || ( joy[ 0 ].button[ 1 ].b ) ) 
      {
         cascii = ' ';
         cscan = KEY_SPACE;
         player->joy_on = TRUE;
      }
      else
         cascii = cscan = 0;
   } */
   if ( /*( cascii ) || ( cscan ) ||*/ DialogGuiTecla )
   {
	  if ( ( !cascii ) && ( !cscan ) )
	  {
		 simulate_keypress( DialogGuiTecla );
		 cascii =  ureadkey( &cscan );
		 DialogGuiTecla = 0;
	  }
      ccombo = ( cscan<<8 ) | ( ( cascii <= 255 ) ? cascii : '^' );
      if ( player->focus_obj >= 0 ) 
      {
         GUI_MESSAGE( player->focus_obj, MSG_CHAR, ccombo );
         if ( player->res & ( D_USED_CHAR | D_CLOSE ) )
            goto getout;
         GUI_MESSAGE( player->focus_obj, MSG_UCHAR, cascii );
         if ( player->res & ( D_USED_CHAR | D_CLOSE ) )
            goto getout;
      }
      for ( c=0; player->dialog[ c ].proc; c++ ) 
      {
         if ( ( ( ( cascii > 0 ) && ( cascii <= 255 ) && ( utolower( player->dialog[ c ].key ) == utolower( ( cascii ) ) ) ) || ( ( !cascii ) && ( player->dialog[ c ].key == ( cscan<<8 ) ) ) ) && ( !( player->dialog[ c ].flags & ( D_HIDDEN | D_DISABLED ) ) ) ) 
         {
            GUI_MESSAGE( c, MSG_KEY, ccombo );
            goto getout;
         }
      }
      for ( c=0; player->dialog[ c ].proc; c++ ) 
      {
         if ( !( player->dialog[ c ].flags & ( D_HIDDEN | D_DISABLED ) ) ) 
         {
            GUI_MESSAGE( c, MSG_XCHAR, ccombo );
            if ( player->res & D_USED_CHAR )
               goto getout;
         }
      }
      if ( ( ( cascii == '\r' ) || ( cascii == '\n' ) || ( cascii == ' ' ) ) && ( player->focus_obj >= 0 ) )
      {
         GUI_MESSAGE( player->focus_obj, MSG_KEY, ccombo );
         goto getout;
      }
      if ( cascii == 27 ) 
      {
         player->res |= D_CLOSE;
         player->obj = -1;
         goto getout;
      }
      player->res |= MoveFocus( player->dialog, cascii, cscan, &player->focus_obj );
   }
   //
   CheckForRedraw( player );
   player->res |= DialogMessage( player->dialog, MSG_IDLE, 0, &player->obj );
   //
   getout:
   //
   ret = ( !( player->res & D_CLOSE ) );
   player->res &= ~D_CLOSE;
   //
   return ret;
}
/****************************************************************************/
int ShutdownDialog( DIALOG_PLAYER *player )
{
   struct AlActiveDialogPlayer *iter, *prev;
   int obj;
   //
   ASSERT( player );
   //
   DialogMessage( player->dialog, MSG_END, 0, &player->obj );
   GuiInstallCount--;
   if ( GuiInstallCount <= 0 ) 
   {
	  remove_int( DoubleClickCheck );
      remove_display_switch_callback( GuiSwitchCallback );
   }
   if ( player->mouse_obj >= 0 )
      player->dialog[ player->mouse_obj ].flags &= ~D_GOTMOUSE;
   for ( iter = FirstActiveDialogPlayer, prev = 0; iter != 0; prev = iter, iter = iter->next )
   {
      if ( iter->player == player ) 
      {
         if ( prev )
            prev->next = iter->next;
         else
            FirstActiveDialogPlayer = iter->next;
         if ( iter == CurrentActiveDialogPlayer )
            CurrentActiveDialogPlayer = prev;
		 free( iter );
         break;
      }
   }
   if ( CurrentActiveDialogPlayer )
      ActiveDialogPlayer = CurrentActiveDialogPlayer->player;
   else
      ActiveDialogPlayer = NULL;
   if ( ActiveDialogPlayer )
      ActiveDialog = ActiveDialogPlayer->dialog;
   else
      ActiveDialog = NULL;
   //
   obj = player->obj;
   free( player );
   //
   return obj;
}
/****************************************************************************/
static void TdhLine( BITMAP *b, int x, int y, int x2 )
{
   ASSERT( b );
   hline( b, x, y+1, x2, ( windos_hlight ) );
   hline( b, x, y, x2, ( windos_shadow ) );
}
/****************************************************************************/
static void TdvLine( BITMAP *b, int x, int y, int y2 )
{
   ASSERT( b );
   vline( b, x+1, y, y2, ( windos_hlight ) );
   vline( b, x, y, y2, ( windos_shadow ) );
}
/****************************************************************************/
static char* SplitAroundTab( const char *s, char **tok1, char **tok2 )
{
   char *buf, *last;
   char tmp[ 40 ];
   //
   buf = ustrdup( s );
   *tok1 = ustrtok_r( buf, uconvert_ascii( "\t", tmp ), &last );
   *tok2 = ustrtok_r( NULL, empty_string, &last );
   //
   return buf;
}
/****************************************************************************/
static int BarEntryLength( const char *text )
{
   char *buf, *tok1, *tok2;
   int len;
   //
   buf = SplitAroundTab( text, &tok1, &tok2 );
   len = GuiStrLen( tok1 ) + 16;
   if ( tok2 )
	  len += GuiStrLen( tok2 ) + 16;
   free( buf );
   //
   return len;
}
/****************************************************************************/
static void GetMenuPos( GUIMENU_PLAYER *m, int c, int *x, int *y, int *w )
{
   int c2;
   //
   if ( m->bar ) 
   {
      *x = m->x+1;
      for ( c2=0; c2<c; c2++ )
         *x += BarEntryLength( m->menu[ c2 ].text );
      *y = m->y-1;
      *w = BarEntryLength( m->menu[ c ].text );
   }
   else 
   {
      *x = m->x+1;
	  *y = m->y+c*( text_height( default_font )*2 )+1;
      *w = m->w+16;
   }
}
/****************************************************************************/
static void DrawMenuItem( GUIMENU_PLAYER *m, int c )
{
   int fg, bg;
   int i, x, y, w;
   char buf[ 80 ], *tok;
   int stl;
   //
   if ( m->menu[ c ].flags & D_DISABLED ) 
   {
	  fg = ( windos_disabledtext );
	  bg = ( windos_face );
      stl = STL_FACE;
   }
   else 
   {
      if ( c == m->sel ) 
      {
		 fg = ( windos_titletext );;
		 bg = ( windos_activetitle );
         stl = STL_TITLEBAR;
      }
      else 
      {
		 fg = ( windos_text );
		 bg = ( windos_face );
         stl = STL_FACE;
      }
   }
   GetMenuPos( m, c, &x, &y, &w );
   TdBox( DialogGuiScreen, x+1, y, w, text_height( default_font )*2, STL_FACE );
   TdBox( DialogGuiScreen, x+1, y, w, text_height( default_font )*2, stl );
   // Show Icon ?
/*   if ( m->menu[ c ].si == TRUE && m->menu[ c ].ico )
   {
	  BITMAP *b = m->menu[ c ].ico;
	  //
	  if ( b )
		 stretch_sprite( DialogGuiScreen, b, x + 4, y, 16, 16 );
   } */
   //
   if ( m->menu[ c ].text[ 0 ] ) 
   {
      for ( i=0; ( m->menu[ c ].text[ i ] ) && ( m->menu[ c ].text[ i ] != '\t' ); i++ )
         buf[ i ] = m->menu[ c ].text[ i ];
      buf[ i ] = 0;
      if ( m->bar )
		 GuiTextoutEx( DialogGuiScreen, buf, x+8, y+4, fg, -1, FALSE );
      else
		 GuiTextoutEx( DialogGuiScreen, buf, x+28, y+4, fg, -1, FALSE );
      if ( m->menu[ c ].text[ i ] == '\t' ) 
      {
         tok = m->menu[ c ].text+i+1;
		 GuiTextoutEx( DialogGuiScreen, tok, x+w-GuiStrLen( tok )-8, y+4, fg, -1, FALSE );
      }
   }
   else
   {
	  TdhLine( DialogGuiScreen, x, y+text_height( default_font )/2+2, x+w );
   }
}
/****************************************************************************/
void DrawMenu( GUIMENU_PLAYER *m )
{
   int c;
   //
   for ( c=0; m->menu[ c ].text; c++ )
      DrawMenuItem( m, c );
   //
   if ( !m->bar )
   {
	  TdBox( DialogGuiScreen, m->x, m->y, m->w+20, m->h, STL_OUT );
   }
}
/****************************************************************************/
static int MenuMouseObject( GUIMENU_PLAYER *m )
{
   int c;
   int x, y, w;
   //
   for ( c=0; c<m->size; c++ )
   {
      GetMenuPos( m, c, &x, &y, &w );
	  if ( ( GuiMouseX() >= x ) && ( GuiMouseX() < x+w ) && ( GuiMouseY() >= y ) && ( GuiMouseY() < y+( text_height( default_font )*2 ) ) )
         return ( ugetc( m->menu[ c ].text ) ) ? c : -1;
   }
   //
   return -1;
}
/****************************************************************************/
static INLINE int MouseInSingleMenu( GUIMENU_PLAYER *m )
{
   if ( ( GuiMouseX() >= m->x ) && ( GuiMouseX() < m->x+m->w ) && ( GuiMouseY() >= m->y ) && ( GuiMouseY() < m->y+m->h ) )
      return TRUE;
   else
      return FALSE;
}
/****************************************************************************/
static int MouseInParentMenu( GUIMENU_PLAYER *m )
{
   int c;
   //
   if ( !m )
      return FALSE;
   c = MenuMouseObject( m );
   if ( ( c >= 0 ) && ( c != m->sel ) )
      return TRUE;
   //
   return MouseInParentMenu( m->parent );
}
/****************************************************************************/
static void LayoutMenu( GUIMENU_PLAYER *m, GUIMENU *menu, int bar, int x, int y, int minw, int minh )
{
   char *buf, *tok1, *tok2;
   int extra = 0;
   int c;
   int child = FALSE;
   //
   m->menu = menu;
   m->bar = bar;
   m->x = x;
   m->y = y;
   m->w = 3;
   m->h = ( m->bar ) ? ( text_height( default_font )*2 ) : 3;
   m->proc = NULL;
   m->sel = -1;
   for ( m->size=0; m->menu[ m->size ].text; m->size++ ) 
   {
      if ( m->bar ) 
      {
         m->w += BarEntryLength( m->menu[ m->size ].text );
      }
      else 
      {
         if ( m->menu[ m->size ].child )
            child = TRUE;
         if ( ugetc( m->menu[ m->size ].text ) ) 
         {
            buf = SplitAroundTab( m->menu[ m->size ].text, &tok1, &tok2 );
			c = GuiStrLen( tok1 );
         }
         else 
         {
            buf = NULL;
            c = 0;
         }
		 m->h += text_height( default_font )*2;
         m->w = MAX( m->w, c+16 );
         if ( buf ) 
         {
            if ( tok2 ) 
            {
			   c = GuiStrLen( tok2 );
               extra = MAX( extra, c );
            }
			free( buf );
         }
      }
   }
   if ( extra )
      m->w += extra+16;
   if ( child )
      m->w += 22;
   //
   m->w = MAX( m->w, minw );
   m->h = MAX( m->h, minh );
}
/****************************************************************************/
static int MenuKeyShortCut( int c, AL_CONST char *s )
{
   int d;
   //
   while ( ( d = ugetxc( &s ) ) != 0 )
   {
      if ( d == '&' )
      {
         d = ugetc( s );
         if ( ( d != '&' ) && ( utolower( d ) == utolower( c & 0xFF ) ) )
            return TRUE;
      }
   }
   //
   return FALSE;
}
/****************************************************************************/
int MenuAltKey( int k, GUIMENU *m )
{
   static unsigned char alt_table[] =
   {
      KEY_A, KEY_B, KEY_C, KEY_D, KEY_E, KEY_F, KEY_G, KEY_H, KEY_I, 
      KEY_J, KEY_K, KEY_L, KEY_M, KEY_N, KEY_O, KEY_P, KEY_Q, KEY_R, 
      KEY_S, KEY_T, KEY_U, KEY_V, KEY_W, KEY_X, KEY_Y, KEY_Z
   };
   AL_CONST char *s;
   int c, d;
   //
   if ( k & 0xFF )
      return 0;
   k >>= 8;
   c = scancode_to_ascii( k );
   if ( c ) 
   {
      k = c;
   }
   else 
   {
      for ( c=0; c<( int )sizeof( alt_table ); c++ ) 
      {
         if ( k == alt_table[ c ] ) 
         {
            k = c + 'a';
            break;
         }
      }
      if ( c >= ( int )sizeof( alt_table ) )
         return 0;
   }
   for ( c=0; m[ c ].text; c++ )
   {
      s = m[ c ].text;
      while ( ( d = ugetxc( &s ) ) != 0 )
      {
         if ( d == '&' )
         {
            d = ugetc( s );
            if ( ( d != '&' ) && ( utolower( d ) == utolower( k ) ) )
               return k;
         }
      }
   }
   //
   return 0;
}
/****************************************************************************/
int DoMenu( GUIMENU *menu, int x, int y )
{
   GUIMENU_PLAYER *player;
   int ret;
   //
   ASSERT( menu );
   //
   player = InitMenu( menu, x , y );
   while( UpdateMenu( player ) )
	  ;
   //
   ret = ShutdownMenu( player );
   //
   return ret;
}
/****************************************************************************/
static GUIMENU_PLAYER *InitSingleMenu( GUIMENU *menu, GUIMENU_PLAYER *parent, DIALOG *dialog, int bar, int x, int y, int repos, int minw, int minh )
{
   GUIMENU_PLAYER *player;
   //
   ASSERT( menu );
   //
   player = malloc( sizeof( GUIMENU_PLAYER ) );
   if ( !player ) 
   {
      *allegro_errno = ENOMEM;
      return NULL;
   }
   LayoutMenu( player, menu, bar, x, y, minw, minh );
   if ( repos ) 
   {
      player->x = MID( 0, player->x, SCREEN_W-player->w-1 );
      player->y = MID( 0, player->y, SCREEN_H-player->h-1 );
   }
   player->sel = MenuMouseObject( player );
   player->mouse_button_was_pressed = GuiMouseB();
   player->back_from_child = FALSE;
   player->timestamp = GuiTimer;
   player->mouse_sel = player->sel;
   player->redraw = TRUE;
   player->auto_open = TRUE;
   player->ret = -1;
   player->dialog = dialog;
   player->parent = parent;
   player->child = NULL;
   //
   return player;
}
/****************************************************************************/
GUIMENU_PLAYER *InitMenu( GUIMENU *menu, int x, int y )
{
   return InitSingleMenu( menu, NULL, NULL, FALSE, x, y, FALSE, 0, 0 );
}
/****************************************************************************/
int UpdateMenu( GUIMENU_PLAYER *player )
{
   GUIMENU_PLAYER *i;
   int c, c2;
   int old_sel, child_ret;
   int child_x, child_y;
   //
   ASSERT( player );
   //
   while( player->child )
   {
      DrawMenu( player );
      player = player->child;
   }
   //
   old_sel = player->sel;
   c = MenuMouseObject( player );
   if ( ( GuiMouseB() ) || ( c != player->mouse_sel ) )
   {
      player->sel = player->mouse_sel = c;
      player->auto_open = TRUE;
   }
   if ( GuiMouseB() )
   {
      if ( !MouseInSingleMenu( player ) )
      {
         if ( MouseInParentMenu( player->parent ) || ( !player->mouse_button_was_pressed ) )
         {
            player->ret = -2;
            goto End;
         }
      }
      if ( ( player->sel >= 0 ) && ( player->menu[ player->sel ].child ) )
         player->ret = player->sel;
      player->mouse_button_was_pressed = TRUE;
//      clear_keybuf();
   }
   else
   {
      if ( player->mouse_button_was_pressed )
      {
         player->ret = player->sel;
         player->mouse_button_was_pressed = FALSE;
      }
	  if ( DialogGuiTecla ) //keypressed() )
	  {
		 player->timestamp = GuiTimer;
		 player->auto_open = FALSE;
		 c = DialogGuiTecla;
		 DialogGuiTecla = 0;
		 if ( ( c & 0xFF ) == 27 )
		 {
            player->ret = -2;
            goto End;
         }
         switch ( c >> 8 ) 
         {
			case KEY_LEFT:
               if ( player->parent ) 
               {
                  if ( player->parent->bar ) 
                  {
                     simulate_keypress( KEY_LEFT<<8 );
                     simulate_keypress( KEY_DOWN<<8 );
                  }
                  player->ret = -2;
                  goto End;
               }
            case KEY_UP:
               if ( ( ( ( c >> 8 ) == KEY_LEFT ) && ( player->bar ) ) || ( ( ( c >> 8 ) == KEY_UP ) && ( !player->bar ) ) ) 
               {
                  c = player->sel;
                  do 
                  {
                     c--;
                     if ( c < 0 )
                        c = player->size - 1;
				  } while ( ( !ugetc( player->menu[ c ].text ) ) && ( c != player->sel ) );
                  player->sel = c;
               }
               break;
            case KEY_RIGHT:
               if ( ( ( player->sel < 0 ) || ( !player->menu[ player->sel ].child ) ) && ( player->parent ) && ( player->parent->bar ) ) 
               {
                  simulate_keypress( KEY_RIGHT<<8 );
                  simulate_keypress( KEY_DOWN<<8 );
                  player->ret = -2;
                  goto End;
               }
            case KEY_DOWN:
               if ( ( player->sel >= 0 ) && ( player->menu[ player->sel ].child ) && ( ( ( ( c >> 8 ) == KEY_RIGHT ) && ( !player->bar ) ) || ( ( ( c >> 8 ) == KEY_DOWN ) && ( player->bar ) ) ) ) 
               {
                  player->ret = player->sel;
               }
               else if ( ( ( ( c >> 8 ) == KEY_RIGHT ) && ( player->bar ) ) || ( ( ( c >> 8 ) == KEY_DOWN ) && ( !player->bar ) ) ) 
               {
                  c = player->sel;
				  do
                  {
                     c++;
                     if ( c >= player->size )
                        c = 0;
				  } while ( ( !ugetc( player->menu[ c ].text ) ) && ( c != player->sel ) );
                  player->sel = c;
               }
               break;
            case KEY_SPACE:
            case KEY_ENTER:
               if ( player->sel >= 0 )
                  player->ret = player->sel;
               break;
               default:
            if ( ( !player->parent ) && ( ( c & 0xFF ) == 0 ) )
               c = MenuAltKey( c, player->menu );
            for ( c2=0; player->menu[ c2 ].text; c2++ ) 
            {
               if ( MenuKeyShortCut( c, player->menu[ c2 ].text ) ) 
			   {
                  player->ret = player->sel = c2;
                  break;
               }
            }
            if ( player->parent ) 
            {
               i = player->parent;
               for ( c2=0; i->parent; c2++ )
                  i = i->parent;
               c = MenuAltKey( c, i->menu );
               if ( c )
               {
				  while ( c2-- > 0 )
                     simulate_keypress( 27 );
                  simulate_keypress( c );
                  player->ret = -2;
                  goto End;
               }
            }
			break;
         }
      }
   }
   //
   if ( ( player->redraw ) || ( player->sel != old_sel ) )
   {
      player->timestamp = GuiTimer;
      if ( player->redraw )
      {
         DrawMenu( player );
         player->redraw = FALSE;
      }
      else 
      {
         if ( old_sel >= 0 )
            DrawMenuItem( player, old_sel );
         if ( player->sel >= 0 )
            DrawMenuItem( player, player->sel );
      }
   }
   if ( player->auto_open && ( GuiMenuOpeningDelay >= 0 ) )
   {
      if ( !MouseInSingleMenu( player ) ) 
      {
         if ( MouseInParentMenu( player->parent ) ) 
         {
            player->ret = -3;
            goto End;
         }
      }
      if ( ( player->mouse_sel >= 0 ) && ( player->menu[ player->mouse_sel ].child ) ) 
      {
         if ( player->bar ) 
         {
            if ( player->back_from_child ) 
            {
               player->timestamp = GuiTimer;
               player->ret = player->mouse_sel;
            }
		 }
         else 
         {
            if ( ( GuiTimer - player->timestamp ) > GuiMenuOpeningDelay )
               player->ret = player->mouse_sel;
         }
      }
      player->back_from_child = FALSE;
   }
   //
   End:
   //
   if ( !player->redraw )
      DrawMenu( player );
   //
   if ( player->ret >= 0 )
   {
      if ( player->menu[ player->ret ].flags & D_DISABLED ) 
      {
         return TRUE; 
	  }
      else if ( player->menu[ player->ret ].child )
      {
         if ( player->bar )
         {
            GetMenuPos( player, player->ret, &child_x, &child_y, &c );
            child_x += 6;
			child_y += text_height( default_font ) * 2;
         }
         else
         {
            child_x = player->x+player->w + 16;
			child_y = player->y + ( text_height( default_font )*2 )*player->ret + text_height( default_font )/4 + 1;
         }
         player->child = InitSingleMenu( player->menu[ player->ret ].child, player, NULL, FALSE, child_x, child_y, TRUE, 0, 0 );
         //
         return TRUE;
      }
	  //
	  while ( player->parent )
      {
         player = player->parent;
         ShutdownSingleMenu( player->child, NULL );
         player->child = NULL;
      }
      //
      return FALSE;
   }
   if ( player->ret < -1 )
   {
      if ( player->parent )
      {
         child_ret = player->ret;
         player = player->parent;
         ShutdownSingleMenu( player->child, NULL );
         player->child = NULL;
         player->ret = -1;
         player->mouse_button_was_pressed = FALSE;
         player->mouse_sel = MenuMouseObject( player );
         if ( child_ret == -3 )
         {
            player->sel = player->mouse_sel;
            player->redraw = TRUE;
            player->timestamp = GuiTimer;
            player->back_from_child = TRUE;
         }
         //
         return TRUE;
      }
      //
      return FALSE;
   }
   if ( ( player->bar ) && ( !GuiMouseB() ) && ( /*!keypressed()*/!DialogGuiTecla ) && ( !MouseInSingleMenu( player ) ) )
      return FALSE;
   //
   return TRUE;
}
/****************************************************************************/
static int ShutdownSingleMenu( GUIMENU_PLAYER *player, int *dret )
{
   int ret;
   //
   ASSERT( player );
   //
   if ( dret )
      *dret = 0;
   if ( ( !player->proc ) && ( player->ret >= 0 ) )
   {
      ActiveMenu = &player->menu[ player->ret ];
      player->proc = ActiveMenu->proc;
   }
   if ( player->ret >= 0 ) 
   {
      if ( player->parent )
         player->parent->proc = player->proc;
      else 
      {
         if ( player->proc ) 
         {
            ret = player->proc();
            if ( dret )
               *dret = ret;
         }
      }
   }
   ret = player->ret;
   free( player );
   //
   return ret;
}
/****************************************************************************/
static int ShutdownTreeMenu( GUIMENU_PLAYER *player, int *dret )
{
   ASSERT( player );
   //
   if ( player->child ) 
   {
      ShutdownTreeMenu( player->child, dret );
      player->child = NULL;
   }
   //
   return ShutdownSingleMenu( player, dret );
}
/****************************************************************************/
int ShutdownMenu( GUIMENU_PLAYER *player )
{
   return ShutdownTreeMenu( player, NULL );
}
/****************************************************************************/
int dMenuProcedure( int msg, DIALOG *d, int c )
{
   GUIMENU_PLAYER m, *mp;
   int ret = D_O_K;
   int x, i;
   //
   ASSERT( d );
   //
   switch ( msg ) 
   {
      case MSG_START:
         LayoutMenu( &m, d->dp, TRUE, d->x, d->y, d->w, d->h );
         d->w = m.w;
         d->h = m.h;
         break;
      case MSG_DRAW:
         LayoutMenu( &m, d->dp, TRUE, d->x, d->y, d->w, d->h );
         DrawMenu( &m );
         break;
      case MSG_XCHAR:
         x = MenuAltKey( c, d->dp );
         if ( !x )
            break;
         ret |= D_USED_CHAR;
		 simulate_keypress( x );
      case MSG_GOTMOUSE:
      case MSG_CLICK:
         ActiveMenuPlayer = InitSingleMenu( d->dp, NULL, d, TRUE, d->x, d->y, FALSE, d->w, d->h );
         break;
      case MSG_LOSTMOUSE:
      case MSG_END:
         if ( ActiveMenuPlayer ) 
         {
            mp = ActiveMenuPlayer;
            ActiveMenuPlayer = NULL;
            ShutdownTreeMenu( mp, &x );
            ret |= x;
            i = FindMouseObject( ActiveDialog );
            if ( ( i >= 0 ) && ( &ActiveDialog[ i ] != d ) ) 
            {
               ActiveDialog[ i ].flags |= D_GOTMOUSE;
			   ObjectMessage( ActiveDialog+i, MSG_GOTMOUSE, 0 );
            }
         }
         break;
   }
   //
   return ret;
}
/****************************************************************************/
int GuiTextoutEx( BITMAP *bmp, AL_CONST char *s, int x, int y, int color, int bg, int centre )
{
   char tmp[ 1024 ];
   int hline_pos = -1;
   int len = 0;
   int in_pos = 0;
   int out_pos = 0;
   int pix_len, c;
   //
   ASSERT( s );
   //
   while ( ( ( c = ugetc( s+in_pos ) ) != 0 ) && ( out_pos<( int )( sizeof( tmp )-ucwidth( 0 ) ) ) )
   {
      if ( c == '&' ) 
      {
         in_pos += uwidth( s+in_pos );
         c = ugetc( s+in_pos );
         if ( c == '&' ) 
         {
            out_pos += usetc( tmp+out_pos, '&' );
            in_pos += uwidth( s+in_pos );
            len++;
         }
         else
            hline_pos = len;
      }
      else 
      {
         out_pos += usetc( tmp+out_pos, c );
         in_pos += uwidth( s+in_pos );
         len++;
	  }
   }
   usetc( tmp+out_pos, 0 );
   pix_len = text_length( default_font, tmp );
   if ( centre )
      x -= pix_len / 2;
   if ( bmp ) 
   {
	  textout_ex( bmp, default_font, tmp, x, y, color, bg );
      if ( hline_pos >= 0 ) 
      {
         c = ugetat( tmp, hline_pos );
         usetat( tmp, hline_pos, 0 );
		 hline_pos = text_length( default_font, tmp );
         c = usetc( tmp, c );
         usetc( tmp+c, 0 );
		 c = text_length( default_font, tmp );
		 hline( bmp, x+hline_pos, y+text_height( default_font )-GuiFontBaseline, x+hline_pos+c-1, color );
      }
   }
   //
   //
   return pix_len;
}
/****************************************************************************/
int GuiStrLen( AL_CONST char *s )
{
   ASSERT( s );
   //
   return GuiTextoutEx( NULL, s, 0, 0, 0, 0, 0 );
}
/****************************************************************************/
static void DottedRect( int x1, int y1, int x2, int y2, int fg, int bg )
{
   int x = ( ( x1+y1 ) & 1 ) ? 1 : 0;
   int c;
   //
   for ( c=x1; c<=x2; c++ )
	  putpixel( DialogGuiScreen, c, y1, ( ( ( c+y1 ) & 1 ) == x ) ? fg : bg );
   for ( c=x1; c<=x2; c++ )
	  putpixel( DialogGuiScreen, c, y2, ( ( ( c+y2 ) & 1 ) == x ) ? fg : bg );
   for ( c=y1+1; c<y2; c++ ) 
   {
	  putpixel( DialogGuiScreen, x1, c, ( ( ( c+x1 ) & 1 ) == x ) ? fg : bg );
	  putpixel( DialogGuiScreen, x2, c, ( ( ( c+x2 ) & 1 ) == x ) ? fg : bg );
   }
}
/****************************************************************************/
int YieldProcedure( int msg, DIALOG *d, int c )
{
   return D_O_K;
}
/****************************************************************************/
int ClearProcedure( int msg, DIALOG *d, int c )
{
   ASSERT( d );
   //
   return D_O_K;
}
/****************************************************************************/
int BoxProcedure( int msg, DIALOG *d, int c )
{
   ASSERT( d );
   //
   if ( msg==MSG_DRAW )
   {
	  int fg = ( d->flags & D_DISABLED ) ? ( windos_hlight ) : d->fg;
      //
	  rectfill( DialogGuiScreen, d->x+1, d->y+1, d->x+d->w-2, d->y+d->h-2, d->bg );
	  rect( DialogGuiScreen, d->x, d->y, d->x+d->w-1, d->y+d->h-1, fg );
   }
   //
   return D_O_K;
}
/****************************************************************************/
int ShadowBoxProcedure( int msg, DIALOG *d, int c )
{
   ASSERT( d );
   //
   if ( msg==MSG_DRAW )
   {
	  int fg = ( d->flags & D_DISABLED ) ? ( windos_disabledtext ) : ( windos_text );
      int black = makecol( 0, 0, 0 );
      //
	  rectfill( DialogGuiScreen, d->x+1, d->y+1, d->x+d->w-3, d->y+d->h-3, d->bg );
	  rect( DialogGuiScreen, d->x, d->y, d->x+d->w-2, d->y+d->h-2, fg );
	  vline( DialogGuiScreen, d->x+d->w-1, d->y+1, d->y+d->h-1, black );
	  hline( DialogGuiScreen, d->x+1, d->y+d->h-1, d->x+d->w-1, black );
   }
   //
   return D_O_K;
}
/****************************************************************************/
int BitmapProcedure( int msg, DIALOG *d, int c )
{
   BITMAP *b;
   //
   ASSERT( d );
   //
   b = ( BITMAP * )d->dp;
   if ( b )
   {
      if ( msg==MSG_DRAW )
		 blit( b, DialogGuiScreen, 0, 0, d->x, d->y, d->w, d->h );
   }
   //
   return D_O_K;
}
/****************************************************************************/
int CentreTextProcedure( int msg, DIALOG *d, int c )
{
   ASSERT( d );
   //
   if ( msg==MSG_DRAW ) 
   {
	  int fg = ( d->flags & D_DISABLED ) ? ( windos_disabledtext ) : ( windos_text );
	  FONT *oldfont = default_font;
      //
      if ( d->dp2 )
		 default_font = d->dp2;
	  GuiTextoutEx( DialogGuiScreen, d->dp, d->x + d->w/2, d->y, fg, -1, TRUE );
	  default_font = oldfont;
   }
   //
   return D_O_K;
}
/****************************************************************************/
int RightProcedure( int msg, DIALOG *d, int c )
{
   ASSERT( d );
   if ( msg==MSG_DRAW ) 
   {
	  int fg = ( d->flags & D_DISABLED ) ? ( windos_disabledtext ) : ( windos_text );
	  FONT *oldfont = default_font;
      //
      if ( d->dp2 )
		 default_font = d->dp2;
	  GuiTextoutEx( DialogGuiScreen, d->dp, d->x + d->w - GuiStrLen( d->dp ), d->y, fg, -1, FALSE );
	  default_font = oldfont;
   }
   //
   return D_O_K;
}
/****************************************************************************/
int dEditProcedure( int msg, DIALOG *d, int c )
{
   static int ignore_next_uchar = FALSE;
   int last_was_space, new_pos, i, k;
   int f, l, p, w, x, fg, b, scroll;
   char buf[ 16 ];
   char *s, *t;
   //
   ASSERT( d );
   //
   s = d->dp;
   l = ustrlen( s );
   if ( d->d2 > l ) 
      d->d2 = l;
   if ( d->d2 == l ) 
   {
      usetc( buf+usetc( buf, ' ' ), 0 );
	  x = text_length( default_font, buf );
   }
   else
      x = 0;
   b = 0;
   for ( p=d->d2; p>=0; p-- ) 
   {
      usetc( buf+usetc( buf, ugetat( s, p ) ), 0 );
	  x += text_length( default_font, buf );
      b++;
      if ( x > d->w ) 
         break;
   }
   if ( x <= d->w ) 
   {
      b = l; 
      scroll = FALSE;
   }
   else 
   {
      b--; 
      scroll = TRUE;
   }
   switch ( msg ) 
   {
      case MSG_START:
         d->d2 = l;
         break;
      case MSG_DRAW:
		 fg = ( d->flags & D_DISABLED ) ? ( windos_disabledtext ) : d->fg;
         x = 0;
         if ( scroll ) 
         {
            p = d->d2-b+1; 
            b = d->d2; 
      }
      else 
         p = 0; 
      for ( ; p<=b; p++ ) 
      {
         f = ugetat( s, p );
         usetc( buf+usetc( buf, ( f ) ? f : ' ' ), 0 );
		 w = text_length( default_font, buf );
         if ( x+w > d->w )
            break;
         f = ( ( p == d->d2 ) && ( d->flags & D_GOTFOCUS ) );
		 textout_ex( DialogGuiScreen, default_font, buf, d->x+x, d->y, ( f ) ? d->bg : fg, ( f ) ? fg : d->bg );
         x += w;
      }
      if ( x < d->w )
      {
		 rectfill( DialogGuiScreen, d->x+x, d->y, d->x+d->w-1, d->y+text_height( default_font )-1, d->bg );
      }
      break;
      case MSG_CLICK:
         x = d->x;
         if ( scroll ) 
         {
            p = d->d2-b+1; 
            b = d->d2; 
      }
      else
         p = 0; 
      for ( ; p<b; p++ ) 
      {
         usetc( buf+usetc( buf, ugetat( s, p ) ), 0 );
		 x += text_length( default_font, buf );
         if ( x > GuiMouseX() ) 
            break;
      }
      d->d2 = MID( 0, p, l );
      ObjectMessage( d, MSG_DRAW, 0 );
      break;
      case MSG_WANTFOCUS:
      case MSG_LOSTFOCUS:
      case MSG_KEY:
         return D_WANTFOCUS;
      case MSG_CHAR:
         ignore_next_uchar = FALSE;
         if ( ( c >> 8 ) == KEY_LEFT ) 
         {
            if ( d->d2 > 0 ) 
            {
			   if ( key_shifts & KB_CTRL_FLAG )
               {
                  last_was_space = TRUE;
                  new_pos = 0;
                  t = s;
                  for ( i = 0; i < d->d2; i++ ) 
                  {
                     k = ugetx( &t );
                     if ( uisspace( k ) )
                        last_was_space = TRUE;
                     else if ( last_was_space ) 
                     {
                        last_was_space = FALSE;
                        new_pos = i;
                     }
                  }
                  d->d2 = new_pos;
               }
               else
                  d->d2--;
            }
      }
      else if ( ( c >> 8 ) == KEY_RIGHT ) 
      {
         if ( d->d2 < l ) 
         {
			if ( key_shifts & KB_CTRL_FLAG )
            {
               t = s + uoffset( s, d->d2 );
               for ( k = ugetx( &t ); uisspace( k ); k = ugetx( &t ) )
                  d->d2++;
               for ( ; k && !uisspace( k ); k = ugetx( &t ) )
                  d->d2++;
            }
            else
               d->d2++;
         }
      }
      else if ( ( c >> 8 ) == KEY_HOME ) 
      {
         d->d2 = 0;
      }
      else if ( ( c >> 8 ) == KEY_END ) 
      {
         d->d2 = l;
      }
      else if ( ( c >> 8 ) == KEY_DEL ) 
      {
         if ( d->d2 < l )
            uremove( s, d->d2 );
      }
      else if ( ( c >> 8 ) == KEY_BACKSPACE ) 
      {
         if ( d->d2 > 0 ) 
         {
            d->d2--;
            uremove( s, d->d2 );
         }
      }
      else if ( ( c >> 8 ) == KEY_ENTER ) 
      {
         if ( d->flags & D_EXIT ) 
         {
            ObjectMessage( d, MSG_DRAW, 0 );
            return D_CLOSE;
         }
         else
            return D_O_K;
      }
      else if ( ( c >> 8 ) == KEY_TAB ) 
      {
         ignore_next_uchar = TRUE;
         return D_O_K;
      }
      else 
      {
         break;
      }
      ObjectMessage( d, MSG_DRAW, 0 );
      return D_USED_CHAR;
      case MSG_UCHAR:
         if ( ( c >= ' ' ) && ( uisok( c ) ) && ( !ignore_next_uchar ) ) 
         {
            if ( l < d->d1 ) 
            {
               uinsert( s, d->d2, c );
               d->d2++;
               ObjectMessage( d, MSG_DRAW, 0 );
            }
            return D_USED_CHAR;
      }
      break;
   }
   //
   return D_O_K;
}
/****************************************************************************/
int EditProcedure(int msg, DIALOG *d, int c)
{
  int f, l, p, w, x, fg;
  int b; 
  int scroll; 
  char *s;
  char buf[2];
  //
  if(msg == MSG_DRAW)
  {
    s = d->dp;
    l = strlen(s);
    if (d->d2 > l) 
      d->d2 = l;
    //
    b = x = 0;
    if (d->d2 == l)
    {
      buf[0] = ' ';
      buf[1] = 0;
	  x = text_length(default_font, buf);
    }
    //
    buf[1] = 0;
    for (p=d->d2; p>=0; p--)
    {
      buf[0] = s[p];
      b++;
	  x += text_length(default_font, buf);
      if (x > d->w) 
        break;
    }
    
    if (x <= d->w)
	{
      b = l; 
      scroll = FALSE;
    }
    else
    {
      b--; 
      scroll = TRUE;
    }
	fg = (windos_text);
    x = 0;
    //
    if (scroll)
	{
      p = d->d2-b+1; 
      b = d->d2; 
    }
    else 
      p = 0; 

	if (d->flags & D_DISABLED)
	  TdBox(DialogGuiScreen, d->x+2, d->y+2, d->w-4, d->h-4, STL_FLAT);
    else
	  TdBox(DialogGuiScreen, d->x+2, d->y+2, d->w-4, d->h-4, STL_FRAMEFILLED);
    for (; p<=b; p++)
    {
      buf[0] = s[p] ? s[p] : ' ';
	  w = text_length(default_font, buf);
      if (x+w > d->w-4) 
        break;

      f = ((p == d->d2) && (d->flags & D_GOTFOCUS));
      if (d->flags & D_DISABLED)
		text_mode((windos_face));
	  else
		text_mode(f ? fg : (windos_framebg));
	  textout(DialogGuiScreen, default_font, buf, d->x+x+3, d->y+3, f ? (windos_framebg) : fg);
	  x += w;
	}
	text_mode( -1 );
	TdBox(DialogGuiScreen, d->x, d->y, d->w, d->h, STL_IN+STL_FRAME);
    return D_O_K;
  }
  //
  return dEditProcedure(msg, d, c);
}
/****************************************************************************/
void _HandleScrollableScroll( DIALOG *d, int listsize, int *index, int *offset )
{
   int height = ( d->h-4 ) / text_height( default_font );
   //
   if ( listsize <= 0 ) 
   {
      *index = *offset = 0;
      return;
   }
   if ( *index < 0 ) 
      *index = 0;
   else if ( *index >= listsize )
      *index = listsize - 1;
   while ( ( *offset > 0 ) && ( *offset + height > listsize ) )
      ( *offset )--;
   if ( *offset >= *index ) 
   {
      if ( *index < 0 ) 
         *offset = 0;
      else
         *offset = *index;
   }
   else
   {
	  while ( ( *offset + height - 1 ) < *index )
         ( *offset )++;
   }
}
/****************************************************************************/
static void IdleCb( void )
{
   BroadcastDialogMessage( MSG_IDLE, 0 );
}
/****************************************************************************/
void _HandleListBoxClick( DIALOG *d )
{
   char *sel = d->dp2;
   int listsize, height;
   int i, j;
   //
   ( *( getfuncptr )d->dp )( -1, &listsize );
   if ( !listsize )
      return;
   height = ( d->h-4 ) / text_height( default_font );
   i = MID( 0, ( ( GuiMouseY() - d->y - 2 ) / text_height( default_font ) ),
   ( ( d->h-4 ) / text_height( default_font ) - 1 ) );
   i += d->d2;
   if ( i < d->d2 )
      i = d->d2;
   else 
   {
      if ( i > d->d2 + height-1 )
         i = d->d2 + height-1;
	  if ( i >= listsize )
         i = listsize-1;
   }
   if ( GuiMouseY() <= d->y )
      i = MAX( i-1, 0 );
   else if ( GuiMouseY() >= d->y+d->h-1 )
      i = MIN( i+1, listsize-1 );
   if ( i != d->d1 ) 
   {
      if ( sel ) 
      {
		 if ( key_shifts & ( KB_SHIFT_FLAG | KB_CTRL_FLAG ) )
         {
			if ( ( key_shifts & KB_SHIFT_FLAG ) || ( d->flags & D_INTERNAL ) )
            {
               for ( j=MIN( i, d->d1 ); j<=MAX( i, d->d1 ); j++ )
                  sel[ j ] = TRUE;
            }
            else
               sel[ i ] = !sel[ i ];
		 }
         else
            sel[ i ] = TRUE;
      }
      d->d1 = i;
      i = d->d2;
      _HandleScrollableScroll( d, listsize, &d->d1, &d->d2 );
      d->flags |= D_DIRTY;
      if ( i != d->d2 )
		 rest_callback( MID( 10, text_height( default_font )*16-d->h-1, 100 ), IdleCb );
   }
   else 
   {
      if ( !( d->flags & D_INTERNAL ) ) 
      {
         if ( sel ) 
         {
			if( ( key_shifts & KB_CTRL_FLAG ) )
               sel[ i ] = !sel[ i ];
            else
			   sel[ i ] = TRUE;
            d->flags |= D_DIRTY;
         }
      }
   }
}
/****************************************************************************/
static int is_in( int xa, int ya, int xb, int yb, int w, int h )
{
   if ( ( xa < xb ) || ( ya < yb ) || ( xa > xb+w ) || ( ya > yb + h ) )
	  return FALSE;
   //
   return TRUE;
}
/****************************************************************************/
int DoWindow( DIALOG *dlg, int focus_obj )
{
   return DoDialog( dlg, focus_obj );
/*	DIALOG_PLAYER *player = InitDialog( dlg, focus_obj );
	//
	while( UpdateWindow( player ) )
	   ; */
/*   int ret, nowhere;
   PDialog Diag;
   TRect r;
   //
   Diag = malloc( sizeof( TDialog ) );
   memset( Diag, 0, sizeof( TDialog ) );
   //
   uConvertStaticDialog( dlg );
   //
	RectAssign( &r, dlg[ 0 ].x, dlg[ 0 ].y, dlg[ 0 ].w, dlg[ 0 ].h );
	Diag->Box = malloc( sizeof( TDiagWdg ) );
	memset( Diag->Box, 0, sizeof( TDiagWdg ) );
	IntialiseWidget( &Me, StdWidgetClass, WIDGET( Diag->Box ), r );
	WIDGET( Diag->Box )->Draw = &DialogConsoleDraw;
	WIDGET( Diag->Box )->EventHandler = &DialogConsoleEventHandler;
	WIDGET( Diag->Box )->Flags |= WFForceBuffer | WFFocusable;
   //
   Diag->state   = state_start;
   Diag->dialog  = dlg;
   Diag->player  = InitDialog( dlg, focus_obj );
   Diag->handler = DefaultDialogHandler;
   //
   Diag->T = NewTimer( &Me, 20, &DialogTimerPoll, Diag );
   //
   while( UpdateDialog( Diag ) )
	  ;
   //
   KillTimer( Diag->T );
   free( Diag );
   // */
   return 0;
}
/****************************************************************************/
void _DrawArrow( int x, int y, int basew, int colr, int stl )
{
   int xp;
   int yp; 
   int w, h;
   //
   if( basew % 2 > 0 )
      basew--;
   if ( stl == SCL_LEFTARROW )
   {
      h=0; 
      for( xp = x, yp = y+basew/2; h<=basew; xp++, yp--, h+=2 ) 
      {
		 vline( DialogGuiScreen, xp, yp, yp+h, colr );
      }
   }
   else if ( stl == SCL_RIGHTARROW ) 
   {
      h=basew;
      for( xp = x, yp = y; h>=0; xp++, yp++, h-=2 ) 
      {
		 vline( DialogGuiScreen, xp, yp, yp+h, colr );
      }
   }
   else if ( stl == SCL_UPARROW ) 
   {
      w=0;
      for( yp = y, xp = x+basew/2; w<=basew; yp++, xp--, w+=2 ) 
      {
		 hline( DialogGuiScreen, xp, yp, xp+w, colr );
      }
   }
   else if ( stl == SCL_DOWNARROW ) 
   {
      w=basew;
      for( yp = y, xp = x; w>=0; yp++, xp++, w-=2 ) 
      {
		 hline( DialogGuiScreen, xp, yp, xp+w, colr );
      }
   }
}
/****************************************************************************/
void FadeBmp( BITMAP *bmp, int clr ) 
{
   int yoff;
   int ysub;
   int xoff;
   int xadd;
   //
   for( yoff=0; yoff<=SCREEN_H; yoff +=2 ) 
   {
      for( ysub=0; ( ( yoff-ysub )>=0 );ysub++ )
         putpixel( bmp, ysub, yoff-ysub, clr );
   }
   for( xoff=0; xoff<=SCREEN_W; xoff +=2 ) 
   {
      for( xadd=0; ( ( xoff+xadd )<=SCREEN_W ); xadd++ )
         putpixel( bmp, xoff+xadd, SCREEN_H-xadd, clr );
   }
}
/****************************************************************************/
void ReplaceColor( BITMAP *b, int oc, int nc )
{
   int x;
   int y;
   //
   for ( y=0; y<=b->h; y++ ) 
   {
      for ( x=0; x<=b->w; x++ ) 
      {
         if ( getpixel( b, x, y ) == oc )
            putpixel( b, x, y, nc );
      }
   }
}
/****************************************************************************/
void MakeSolidPalette( PALETTE pal, int start, int stop, int r, int g, int b )
{
   int counter;
   RGB color = {r, g, b};
   //
   for ( counter=start; counter<=stop; counter++ ) 
   {
      pal[ counter ] = color;
   }
}
/****************************************************************************/
/*int PrepareWindow( DIALOG *dialog )
{
   BILLWIN_INFO_STRUCTURE *infostruct = malloc( sizeof( BILLWIN_INFO_STRUCTURE ) );
   //
   dialog->dp3 = infostruct;
   //
   return 0;
} */
/****************************************************************************/
/*int ShutdownWindow( DIALOG *dialog )
{
   BILLWIN_INFO_STRUCTURE *infostruct = dialog->dp3;
   //
   if ( infostruct )
   {
	  free( infostruct );
	  dialog->dp3 = NULL;
   }
   //
   return 0;
} */
/****************************************************************************/
void _DrawScrollableFrame( DIALOG *d, int listsize, int offset, int height, int fg_color, int bg )
{
   int i, len;
   int xx, yy;
   //
   TdBox( DialogGuiScreen, d->x, d->y, d->w, d->h, STL_IN + STL_FRAME );
   if ( listsize > height ) 
   {
      i = ( ( d->h-4 ) * height + listsize/2 ) / listsize;
      xx = d->x+d->w-12;
      yy = d->y+2;
      if ( offset > 0 ) 
      {
         len = ( ( ( d->h-4 ) * offset ) + listsize/2 ) / listsize;
		 TdBox( DialogGuiScreen, xx, yy, ( d->x+d->w )-xx-2, len-1, STL_DITHERED );
         yy += len;
      }
      if ( yy+i<d->y+d->h-2 ) 
      {
		 TdBox( DialogGuiScreen, xx, yy+i, ( d->x+d->w )-xx-2, ( d->y+d->h )-2-( i+yy ), STL_DITHERED );
      }
      if ( yy+i < d->y+d->h-2 ) 
      {
		 TdBox( DialogGuiScreen, xx, yy, 10, i, STL_OUT + STL_FLAT );
      }
      else 
      {
		 TdBox( DialogGuiScreen, xx, yy, 10, ( d->y+d->h )-yy-2, STL_OUT + STL_FLAT );
      }
	  rect( DialogGuiScreen, d->x+2, d->y+2, xx-1, d->y+d->h-2, ( windos_framebg ) );
   }
   else 
   {
	  rect( DialogGuiScreen, d->x+2, d->y+2, d->x+d->w-2, d->y+d->h-2, ( windos_framebg ) );
   }
}
/****************************************************************************/
void _DrawListBox( DIALOG *d )
{
   int height, listsize, i, len, bar, x, y, w;
   int fg_color, fg, bg;
   l_text sel = d->dp2;
   char s[ 1024 ];
   ( *( getfuncptr )d->dp )( -1, &listsize );
   //
   height = ( d->h-3 ) / text_height( default_font );
   bar = ( listsize > height );
   w = ( bar ? d->w-14 : d->w-2 );
   fg_color = ( d->flags & D_DISABLED ) ? ( windos_disabledtext ) : ( windos_text );
   for ( i=0; i<height; i++ ) 
   {
      if ( d->d2+i < listsize ) 
      {
         if ( d->flags & D_DISABLED ) 
         {
			fg = ( windos_text );
			bg = ( windos_face );
         }
         else if ( d->d2+i == d->d1 ) 
         {
			fg = ( windos_framebg );
			bg = ( windos_desktop );
         } 
         else if ( ( sel ) && ( sel[ d->d2+i ] ) )
         {
			fg = ( windos_framebg );
			bg = ( windos_text );
         }
         else 
         {
			bg = ( windos_framebg );
			fg = ( windos_text );
         }
         usetc( s, 0 );
         ustrncat( s, ( *( getfuncptr )d->dp )( i+d->d2, NULL ), sizeof( s )-ucwidth( 0 ) );
         x = d->x + 2;
		 y = d->y + 3 + i*text_height( default_font );
		 rectfill( DialogGuiScreen, x, y, x+7, y+text_height( default_font )-1, bg );
         x += 8;
         len = ustrlen( s );
		 while( text_length( default_font, s ) >= MAX( d->w - ( bar ? 22 : 10 ), 1 ) )
         {
            len--;
            usetat( s, len, 0 );
         }
		 textout_ex( DialogGuiScreen, default_font, s, x, y, fg, bg );
		 x += text_length( default_font, s );
         if ( x <= d->x+w )
         {
			rectfill( DialogGuiScreen, x, y, d->x+w, y+text_height( default_font )-1, bg );
         }
      }
      else 
      {
         if ( d->flags & D_DISABLED )
			rectfill( DialogGuiScreen, d->x+2, d->y+2+i*text_height( default_font ), d->x+w, d->y+1+( i+1 )*text_height( default_font ), ( windos_face ) );
         else
			rectfill( DialogGuiScreen, d->x+2, d->y+2+i*text_height( default_font ), d->x+w, d->y+1+( i+1 )*text_height( default_font ), ( windos_framebg ) );
   }
   }
   if ( d->y+2+i*text_height( default_font ) <= d->y+d->h-2 )
   {
      if ( d->flags & D_DISABLED )
		 rectfill( DialogGuiScreen, d->x+2, d->y+2+i*text_height( default_font ), d->x+w, d->y+d->h-2, ( windos_face ) );
      else
		 rectfill( DialogGuiScreen, d->x+2, d->y+2+i*text_height( default_font ), d->x+w, d->y+d->h-2, ( windos_framebg ) );
   }
   if ( d->flags & D_DISABLED )
	  TdBox( DialogGuiScreen, d->x, d->y, d->w, d->h, STL_IN + STL_FRAME );
   else
	  _DrawScrollableFrame( d, listsize, d->d2, height, fg_color, ( windos_framebg ) );
}
/****************************************************************************/
int ProgressProcedure( int msg, DIALOG *d, int c )
{
   int vert = FALSE;
   float percent;
   float barlength;
   //
   if( msg==MSG_DRAW )
   {
      if ( d->d1 <= 0 )
         d->d1 = 1;
      if ( d->d2 > d->d1 )
         d->d2 = d->d1;
      percent = ( float )d->d2/( float )d->d1;
      if ( d->h > d->w )
         vert = TRUE;
      percent *= 100;
      if ( percent > 100 )
         percent = 100;
      if ( percent < 0 )
         percent = 0;
      if ( !vert )
         barlength = ( ( float )( d->w - 4 )/100.0 ) * percent;
      else
         barlength = ( ( float )( d->h - 4 )/100.0 ) * percent;
      //
	  TdBox( DialogGuiScreen, d->x, d->y, d->w, d->h, STL_DOWN );
      if( !vert )
      {
		 TdBox( DialogGuiScreen, d->x+2, d->y+2, barlength, d->h-4, STL_PROGRESSBAR );
		 TdBox( DialogGuiScreen, d->x+2+barlength, d->y+2, d->w-barlength-4, d->h-4, STL_FACE );
      }
      else
      {
		 TdBox( DialogGuiScreen, d->x+2, d->y+( ( d->h-4 )-barlength )+2, d->w-4, barlength, STL_PROGRESSBAR );
		 TdBox( DialogGuiScreen, d->x+2, d->y+2, d->w-4, ( ( d->h-4 )-barlength ), STL_FACE );
      }
   }
   //
   return D_O_K;
}
/****************************************************************************/
int ScrollableBitmapProcedure( int msg, DIALOG *d, int c )
{
   int ret = 0;
   BITMAP *b;
   int ( *proc )( int *d1value, int *d2value );
   //
   if ( d->dp2 )
   {
      proc = d->dp2;
      ret = ( *proc )( &d->d1, &d->d2 );
   }
   if ( ret == D_REDRAW )
      msg = MSG_DRAW;
   if ( msg==MSG_DRAW )
   {
      if( d->dp )
      {
         b = ( BITMAP * )d->dp;
         if (b )
			blit( b, DialogGuiScreen, d->d1, d->d2, d->x, d->y, d->w, d->h );
      }
   }
   //
   return D_O_K;
}
/****************************************************************************/
int hScrollbarProcedure( int msg, DIALOG *d, int c )
{
   int retval = D_O_K;
   float rngl;
   float rngr;
   float rngw;
   int newval;
   int msx, msy;
   int objd1 = d->d1;
   int lastclock = 0;
   int hpos;
   int tmp = 0;
   void ( *proc )( int d2value );
   //
   rngl = d->x+d->h+1;
   rngr = d->x+d->w-( d->h*2 )-1;
   rngw = rngr - rngl;
   if ( msg==MSG_DRAW )
   {
      if ( d->d1 )
      {
         if ( d->flags & SCL_DOWNBUTTON_DOWN )
			TdBox( DialogGuiScreen, d->x, d->y, d->h, d->h, STL_DOWN + STL_FACE );
         else
			TdBox( DialogGuiScreen, d->x, d->y, d->h, d->h, STL_UP + STL_FACE );
         //
		 _DrawArrow( d->x+4, d->y+3, d->h-6, ( windos_text ), SCL_LEFTARROW );
         hpos = rngl + ( ( d->d2*rngw )/objd1 );
		 TdBox( DialogGuiScreen, hpos, d->y, d->h, d->h, STL_UP + STL_FACE );
		 TdBox( DialogGuiScreen, rngl, d->y, hpos-( rngl+1 ), d->h, STL_DITHERED );
		 TdBox( DialogGuiScreen, hpos+d->h+1, d->y, rngr+d->h-( hpos+d->h ), d->h, STL_DITHERED );
         if ( d->flags & SCL_UPBUTTON_DOWN )
			TdBox( DialogGuiScreen, d->x+d->w-d->h, d->y, d->h, d->h, STL_DOWN + STL_FACE );
         else
			TdBox( DialogGuiScreen, d->x+d->w-d->h, d->y, d->h, d->h, STL_UP + STL_FACE );
		 _DrawArrow( d->x+d->w-2-d->h/2, d->y+3, d->h-6, ( windos_text ), SCL_RIGHTARROW );
      }
   }
   else if( msg == MSG_CLICK )
   {
      if ( d->d1 )
      {
         msx = GuiMouseX();
         msy = GuiMouseY();
		 if ( GuiMouseB() )
         {
            if ( is_in( msx, msy, d->x, d->y, d->h, d->h ) )
            {
               d->flags += SCL_DOWNBUTTON_DOWN;
/*while*/	   if ( GuiMouseB() )
               {
                  BroadcastDialogMessage( MSG_IDLE, 0 );
                  msx = GuiMouseX();
                  msy = GuiMouseY();
                  if ( is_in( msx, msy, d->x, d->y, d->h, d->h ) )
                  {
                     if( !( d->flags & SCL_DOWNBUTTON_DOWN ) )
                        d->flags += SCL_DOWNBUTTON_DOWN;
                     if( ( ( clock() - lastclock ) > 5 ) || ( ( clock() - lastclock ) < 0 ) )
                     {
                        d->d2--;
                        if ( d->d2 < 0 ) d->d2 = 0;
                           ObjectMessage( d, MSG_DRAW, 0 );
                        lastclock = clock();
                        if ( d->dp ) 
                        {
                           proc = d->dp;
                           ( *proc )( d->d2 );
                        }
                     }
                  }
                  else
                  {
                     if( d->flags & SCL_DOWNBUTTON_DOWN )
                     {
                        d->flags -= SCL_DOWNBUTTON_DOWN;
                        ObjectMessage( d, MSG_DRAW, 0 );
                     }
                  }
               }
               if( d->flags & SCL_DOWNBUTTON_DOWN )
               {
                  d->flags -= SCL_DOWNBUTTON_DOWN;
                  ObjectMessage( d, MSG_DRAW, 0 );
               }
            }
            else if ( is_in( msx, msy, d->x+d->w-d->h, d->y, d->h, d->h ) )
            {
               d->flags += SCL_UPBUTTON_DOWN;
/*while*/      if ( GuiMouseB() )
               {
                  BroadcastDialogMessage( MSG_IDLE, 0 );
                  msx = GuiMouseX();
                  msy = GuiMouseY();
                  if ( is_in( msx, msy, d->x+d->w-d->h, d->y, d->h, d->h ) )
                  {
                     if( !( d->flags & SCL_UPBUTTON_DOWN ) )
                        d->flags += SCL_UPBUTTON_DOWN;
                     if( ( ( clock() - lastclock ) > 5 ) || ( ( clock() - lastclock ) < 0 ) )
                     {
                        d->d2++;
                        if ( d->d2 > d->d1 ) d->d2 = d->d1;
                           ObjectMessage( d, MSG_DRAW, 0 );
                        lastclock = clock();
                        if ( d->dp ) 
                        {
                           proc = d->dp;
                           ( *proc )( d->d2 );
                        }
                     }
                  }
                  else
                  {
                     if( d->flags & SCL_UPBUTTON_DOWN )
                     {
                        d->flags -= SCL_UPBUTTON_DOWN;
                        ObjectMessage( d, MSG_DRAW, 0 );
                     }
                  }
               }
               if( d->flags & SCL_UPBUTTON_DOWN )
               {
                  d->flags -= SCL_UPBUTTON_DOWN;
                  ObjectMessage( d, MSG_DRAW, 0 );
               }
            }
            else if ( is_in( msx, msy, d->x+d->h, d->y, d->w-d->h*2, d->h ) )
            {
/*while*/      if ( GuiMouseB() )
               {
                  msx = GuiMouseX();
                  msy = GuiMouseY();
                  hpos = msx;
                  newval = ( objd1*( hpos-rngl ) )/rngw;
                  if ( newval < 0 )
                     newval = 0;
                  if ( newval > objd1 )
                     newval = objd1;
                  d->d2 = newval;
                  if ( newval != tmp )
                  {
                     ObjectMessage( d, MSG_DRAW, 0 );
                     tmp = newval;
                     if ( d->dp ) 
                     {
                        proc = d->dp;
                        ( *proc )( d->d2 );
                     }
                  }
               }
            }
         }
         else 
         {
            if ( d->flags & SCL_UPBUTTON_DOWN ) 
            {
               d->flags -= SCL_UPBUTTON_DOWN;
               ObjectMessage( d, MSG_DRAW, 0 );
            }
            if ( d->flags & SCL_DOWNBUTTON_DOWN ) 
            {
               d->flags -= SCL_DOWNBUTTON_DOWN;
               ObjectMessage( d, MSG_DRAW, 0 );
            }
         }
         if ( d->d2 < 0 )
            d->d2 = 0;
         if ( d->d2 > d->d1 )
            d->d2 = d->d1;
         ObjectMessage( d, MSG_DRAW, 0 );
      }
   }
   else if( msg == MSG_IDLE )
   {
	  if ( !( GuiMouseB() ) )
      {
         if ( d->flags & SCL_UPBUTTON_DOWN ) 
         {
            d->flags -= SCL_UPBUTTON_DOWN;
            ObjectMessage( d, MSG_DRAW, 0 );
         }
         if ( d->flags & SCL_DOWNBUTTON_DOWN ) 
         {
            d->flags -= SCL_DOWNBUTTON_DOWN;
            ObjectMessage( d, MSG_DRAW, 0 );
         }
      }
   }
   //
   return retval;
}
/****************************************************************************/
int vScrollbarProcedure( int msg, DIALOG *d, int c )
{
   int retval = D_O_K;
   float rngt;
   float rngb;
   float rngh;
   int newval;
   int msx, msy;
   int objd1 = d->d1;
   int lastclock = 0;
   int hpos;
   int tmp = 0;
   void ( *proc )( int d2value );
   //
   rngt = d->y+d->w+1;
   rngb = d->y+d->h-( d->w*2 )-1;
   rngh = rngb - rngt;
   if ( msg==MSG_DRAW )
   {
      if ( d->d1 )
      {
         if ( d->flags & SCL_DOWNBUTTON_DOWN )
			TdBox( DialogGuiScreen, d->x, d->y, d->w, d->w, STL_DOWN + STL_FACE );
         else
			TdBox( DialogGuiScreen, d->x, d->y, d->w, d->w, STL_UP + STL_FACE );
         //
		 _DrawArrow( d->x+3, d->y+4, d->w-6, ( windos_text ), SCL_UPARROW );
         hpos = rngt + ( ( d->d2*rngh )/objd1 );
		 TdBox( DialogGuiScreen, d->x, hpos, d->w, d->w, STL_UP + STL_FACE );
		 TdBox( DialogGuiScreen, d->x, rngt, d->w, hpos-( rngt+1 ), STL_DITHERED );
		 TdBox( DialogGuiScreen, d->x, hpos+d->w+1, d->w, rngb-hpos, STL_DITHERED );
         if ( d->flags & SCL_UPBUTTON_DOWN )
			TdBox( DialogGuiScreen, d->x, d->y+d->h-d->w, d->w, d->w, STL_DOWN + STL_FACE );
         else
			TdBox( DialogGuiScreen, d->x, d->y+d->h-d->w, d->w, d->w, STL_UP + STL_FACE );
		 _DrawArrow ( d->x+3, d->y+d->h-2-d->w/2, d->w-6, ( windos_text ), SCL_DOWNARROW );
      }
   }
   else if( msg == MSG_CLICK )
   {
      if ( d->d1 )
      {
         msx = GuiMouseX();
         msy = GuiMouseY();
		 if ( GuiMouseB() )
         {
            if ( is_in( msx, msy, d->x, d->y, d->w, d->w ) )
            {
               d->flags += SCL_DOWNBUTTON_DOWN;
/*while*/      if ( GuiMouseB() )
               {
                  BroadcastDialogMessage( MSG_IDLE, 0 );
                  msx = GuiMouseX();
                  msy = GuiMouseY();
                  if ( is_in( msx, msy, d->x, d->y, d->w, d->w ) )
                  {
                     if( !( d->flags & SCL_DOWNBUTTON_DOWN ) )
                        d->flags += SCL_DOWNBUTTON_DOWN;
                     if( ( ( clock() - lastclock ) > 5 ) || ( ( clock() - lastclock ) < 0 ) )
                     {
                        d->d2--;
                        if ( d->d2 < 0 ) d->d2 = 0;
                           ObjectMessage( d, MSG_DRAW, 0 );
                        lastclock = clock();
                        if ( d->dp ) 
                        {
                           proc = d->dp;
                           ( *proc )( d->d2 );
                        }
                     }
                  }
                  else
                  {
                     if( d->flags & SCL_DOWNBUTTON_DOWN )
                     {
                        d->flags -= SCL_DOWNBUTTON_DOWN;
                        ObjectMessage( d, MSG_DRAW, 0 );
                     }
                  }
               }
               if( d->flags & SCL_DOWNBUTTON_DOWN )
               {
                  d->flags -= SCL_DOWNBUTTON_DOWN;
                  ObjectMessage( d, MSG_DRAW, 0 );
               }
            }
            else if ( is_in( msx, msy, d->x, d->y+d->h-d->w, d->w, d->w ) )
            {
               d->flags += SCL_UPBUTTON_DOWN;
/*while*/      if ( GuiMouseB() )
               {
                  BroadcastDialogMessage( MSG_IDLE, 0 );
                  msx = GuiMouseX();
                  msy = GuiMouseY();
                  if ( is_in( msx, msy, d->x, d->y+d->h-d->w, d->w, d->w ) )
                  {
                     if( !( d->flags & SCL_UPBUTTON_DOWN ) )
                        d->flags += SCL_UPBUTTON_DOWN;
                     if( ( ( clock() - lastclock ) > 5 ) || ( ( clock() - lastclock ) < 0 ) )
                     {
                        d->d2++;
                        if ( d->d2 > d->d1 )
                           d->d2 = d->d1;
                        ObjectMessage( d, MSG_DRAW, 0 );
                        lastclock = clock();
                        if ( d->dp ) 
                        {
                           proc = d->dp;
                           ( *proc )( d->d2 );
                        }
                     }
                  }
                  else
                  {
                     if( d->flags & SCL_UPBUTTON_DOWN )
                     {
                        d->flags -= SCL_UPBUTTON_DOWN;
                        ObjectMessage( d, MSG_DRAW, 0 );
                     }
                  }
               }
               if( d->flags & SCL_UPBUTTON_DOWN )
               {
                  d->flags -= SCL_UPBUTTON_DOWN;
                  ObjectMessage( d, MSG_DRAW, 0 );
               }
            }
            else if ( is_in( msx, msy, d->x, d->y+d->w, d->w, d->h-d->w*2 ) )
            {
/*while*/      if ( GuiMouseB() )
               {
                  msx = GuiMouseX();
                  msy = GuiMouseY();
                  hpos = msy;
                  newval = ( objd1*( hpos-rngt ) )/rngh;
                  if ( newval < 0 )
                     newval = 0;
                  if ( newval > objd1 )
                     newval = objd1;
                  d->d2 = newval;
                  if ( newval != tmp )
                  {
                     ObjectMessage( d, MSG_DRAW, 0 );
                     tmp = newval;
                     if ( d->dp ) 
                     {
                        proc = d->dp;
                        ( *proc )( d->d2 );
                     }
                  }
               }
            }
         }
         else 
         {
            if ( d->flags & SCL_UPBUTTON_DOWN ) 
            {
               d->flags -= SCL_UPBUTTON_DOWN;
               ObjectMessage( d, MSG_DRAW, 0 );
            }
            if ( d->flags & SCL_DOWNBUTTON_DOWN ) 
            {
               d->flags -= SCL_DOWNBUTTON_DOWN;
               ObjectMessage( d, MSG_DRAW, 0 );
            }
         }
         if ( d->d2 < 0 )
            d->d2 = 0;
         if ( d->d2 > d->d1 )
            d->d2 = d->d1;
         ObjectMessage( d, MSG_DRAW, 0 );
      }
   }
   else if( msg == MSG_IDLE )
   {
	  if ( !( GuiMouseB() ) )
      {
         if ( d->flags & SCL_UPBUTTON_DOWN ) 
         {
            d->flags -= SCL_UPBUTTON_DOWN;
            ObjectMessage( d, MSG_DRAW, 0 );
         }
         if ( d->flags & SCL_DOWNBUTTON_DOWN ) 
         {
            d->flags -= SCL_DOWNBUTTON_DOWN;
            ObjectMessage( d, MSG_DRAW, 0 );
         }
	  }
   }
   //
   return retval;
}
/****************************************************************************/
void _DrawTextBox( l_text thetext, int *listsize, int draw, int offset, int wword, int tabsize, int x, int y, int w, int h, int disabled, int fore, int deselect, int disable )
{
   int fg = fore;
   int y1 = y+4;
   int x1;
   int len;
   int ww = w-6;
   char s[ 16 ];
   char text[ 16 ];
   char space[ 16 ];
   l_text printed = text;
   l_text scanned = text;
   l_text oldscan = text;
   l_text ignore = NULL;
   l_text tmp, *ptmp;
   int width;
   int line = 0;
   int i = 0;
   int noignore;
   //
   usetc( s+usetc( s, '.' ), 0 );
   usetc( text+usetc( text, ' ' ), 0 );
   usetc( space+usetc( space, ' ' ), 0 );
   if ( thetext != NULL ) 
   {
      printed = thetext;
      scanned = thetext;
   }
   if ( draw ) 
   {
	  rectfill( DialogGuiScreen, x+2, y+2, x+w-3, y1-1, deselect );
   }
   if ( disabled )
      fg = disable;
   while( 1 )
   {
      width = 0;
	  while( ugetc( scanned ) )
      {
         if ( ugetc( scanned ) == '\n' ) 
         {
            scanned += uwidth( scanned );
            break;
         }
         usetc( s+usetc( s, ugetc( scanned ) ), 0 );
		 len = text_length( default_font, s );
         if ( ugetc( s ) == '\t' ) 
			len = tabsize * text_length( default_font, space );
         if ( width+len >= ww ) 
         {
            if ( wword ) 
            {
               oldscan = scanned;
               noignore = FALSE;
			   while( !uisspace( ugetc( scanned ) ) )
               {
                  if ( scanned == printed ) 
                  {
                     tmp = ptmp = scanned;
					 while( ptmp != oldscan )
                     {
                        ptmp = tmp;
                        tmp += uwidth( tmp );
                     }
                     scanned = ptmp;
                     noignore = TRUE;
                     break;
                  }
                  tmp = ptmp = printed;
				  while( tmp < scanned )
                  {
                     ptmp = tmp;
                     tmp += uwidth( tmp );
                  }
                  scanned = ptmp;
               }
               if ( !noignore ) 
               {
                  ignore = scanned;
                  scanned += uwidth( scanned );
               }
               else
                  ignore = NULL;
               if ( ugetc( scanned ) == '\n' ) 
                  scanned += uwidth( scanned );
            }
            break;
         }
         scanned += uwidth( scanned );
         width += len;
      }
	  if ( ( draw ) && ( line >= offset ) && ( y1+text_height( default_font ) < ( y+h-3 ) ) )
      {
         x1 = x+4;
		 rectfill( DialogGuiScreen, x+2, y1, x1-1, y1+text_height( default_font ), deselect );
		 while( printed != scanned )
         {
            switch ( ugetc( printed ) ) 
            {
               case '\r':
               case '\n':
                  break;
               case '\t':
                  for ( i=0; i<tabsize; i++ ) 
                  {
                     usetc( s+usetc( s, ' ' ), 0 );
					 textout_ex( DialogGuiScreen, default_font, s, x1, y1, fg, deselect );
					 x1 += text_length( default_font, s );
                  }
                  break;
                  default:
               if ( printed != ignore ) 
               {
                  usetc( s+usetc( s, ugetc( printed ) ), 0 );
				  textout_ex( DialogGuiScreen, default_font, s, x1, y1, fg, deselect );
				  x1 += text_length( default_font, s );
               }
            }
            printed += uwidth( printed );
         }
         if ( x1 <= x+w-3 )
         {
			rectfill( DialogGuiScreen, x1, y1, x+w-3, y1+text_height( default_font )-1, deselect );
         }
		 y1 += text_height( default_font );
      }
      printed = scanned;
      line++;
      if ( !ugetc( printed ) ) 
      {
         if ( draw )
         {
			rectfill( DialogGuiScreen, x+1, y1, x+w-3, y+h-1, deselect );
         }
         *listsize = line;
         return;
   }
}
}
/****************************************************************************/
void _HandleScrollableScrollClick( DIALOG *d, int listsize, int *offset, int height )
{
   int xx, yy;
   int hh = d->h - 5;
   //
/*while*/      if ( GuiMouseB() )
   {
      int i = ( hh * height + listsize/2 ) / listsize;
      int len = ( hh * ( *offset ) + listsize/2 ) / listsize + 2;
      //
      if ( ( GuiMouseY() >= d->y+len ) && ( GuiMouseY() <= d->y+len+i ) ) 
      {
         xx = GuiMouseY() - len + 2;
/*while*/      if ( GuiMouseB() )
         {
            yy = ( listsize * ( GuiMouseY() - xx ) + hh/2 ) / hh;
            if ( yy > listsize-height ) 
               yy = listsize-height;
            if ( yy < 0 ) 
               yy = 0;
            if ( yy != *offset ) 
            {
               *offset = yy;
               ObjectMessage( d, MSG_DRAW, 0 );
            }
            BroadcastDialogMessage( MSG_IDLE, 0 );
         }
      }
      else 
      {
         if ( GuiMouseY() <= d->y+len ) 
            yy = *offset - height;
         else 
            yy = *offset + height;
         if ( yy > listsize-height ) 
            yy = listsize-height;
         if ( yy < 0 ) 
            yy = 0;
         if ( yy != *offset ) 
         {
            *offset = yy;
            ObjectMessage( d, MSG_DRAW, 0 );
         }
      }
      BroadcastDialogMessage( MSG_IDLE, 0 );
   }
}
/****************************************************************************/
int dTextBoxProcedure( int msg, DIALOG *d, int c )
{
   int height, bar, ret = D_O_K;
   int start, top, bottom, l;
   int used, delta;
   int fg_color;
   //
   ASSERT( d );
   //
   fg_color = ( d->flags & D_DISABLED ) ? ( windos_disabledtext ) : d->fg;
   height = ( d->h-8 ) / text_height( default_font );
   switch ( msg ) 
   {
      case MSG_START:
         _DrawTextBox( d->dp, &d->d1, 0, d->d2, !( d->flags & D_SELECTED ), 8, d->x, d->y, d->w, d->h, ( d->flags & D_DISABLED ), 0, 0, 0 );
         break;
      case MSG_DRAW:
         _DrawTextBox( d->dp, &d->d1, 0, d->d2, !( d->flags & D_SELECTED ), 8, d->x, d->y, d->w, d->h, ( d->flags & D_DISABLED ), 0, 0, 0 );
         if ( d->d1 > height )
         {
            bar = 12;
         }
         else 
         {
            bar = 0;
            d->d2 = 0;
         }
		 _DrawTextBox( d->dp, &d->d1, 1, d->d2, !( d->flags & D_SELECTED ), 8, d->x, d->y, d->w-bar, d->h, ( d->flags & D_DISABLED ), fg_color, d->bg, ( windos_disabledtext ) );
         _DrawScrollableFrame( d, d->d1, d->d2, height, fg_color, d->bg );
         break;
      case MSG_CLICK:
         bar = ( d->d1 > height );
         if ( ( !bar ) || ( GuiMouseX() < d->x+d->w-13 ) ) 
         {
            ret = D_O_K;
         }
         else 
         {
            _HandleScrollableScrollClick( d, d->d1, &d->d2, height );
         }
         break;
      case MSG_CHAR:
         start = d->d2;
         used = D_USED_CHAR;
         if ( d->d1 > 0 ) 
         {
            if ( d->d2 > 0 ) 
               top = d->d2+1;
            else 
               top = 0;
			l = ( d->h-8 )/text_height( default_font );
            bottom = d->d2 + l - 1;
            if ( bottom >= d->d1-1 ) 
               bottom = d->d1-1;
            else 
               bottom--;
            if ( ( c>>8 ) == KEY_UP ) 
               d->d2--;
            else if ( ( c>>8 ) == KEY_DOWN ) 
               d->d2++;
            else if ( ( c>>8 ) == KEY_HOME ) 
               d->d2 = 0;
            else if ( ( c>>8 ) == KEY_END ) 
               d->d2 = d->d1-l;
            else if ( ( c>>8 ) == KEY_PGUP ) 
               d->d2 -= ( bottom-top ) ? bottom-top : 1;
            else if ( ( c>>8 ) == KEY_PGDN ) 
               d->d2 += ( bottom-top ) ? bottom-top : 1;
            else 
               used = D_O_K;
            if ( d->d2 > d->d1-l ) 
               d->d2 = d->d1-l;
            if ( d->d2 < 0 ) 
               d->d2 = 0;
         }
         else 
            used = D_O_K;
         if ( d->d2 != start )
            d->flags |= D_DIRTY;
         ret = used;
         break;
      case MSG_WHEEL:
		 l = ( d->h-8 )/text_height( default_font );
         delta = ( l > 3 ) ? 3 : 1;
         start = d->d2;
         d->d2 = ( c > 0 ) ? MAX( 0, d->d2-delta ) : MIN( d->d1-l, d->d2+delta );
         if ( d->d2 != start )
            d->flags |= D_DIRTY;
         ret = D_O_K;
         break;
      case MSG_WANTFOCUS:
         if ( d->d1 > height ) 
            ret = D_WANTFOCUS;
         break;
         default:
      ret = D_O_K;
      break;
   }
   //
   return ret;
}
/****************************************************************************/
int TextBoxProcedure( int msg, DIALOG *d, int c )
{
   int height, bar;
   int fg_color = ( windos_text );
   //
   height = ( d->h-4 ) / text_height( default_font );
   if( d->d2 > d->d1 ) 
      d->d2 = d->d1;
   if( msg == MSG_DRAW ) 
   {
      _DrawTextBox( d->dp, &d->d1, 0, d->d2, !( d->flags & D_SELECTED ), 8, d->x, d->y, d->w, d->h, ( d->flags & D_DISABLED ), 0, 0, 0 );
      if ( d->d1 > height ) 
      {
         bar = 12;
      }
      else 
      {
         bar = 0;
         d->d2 = 0;
      }
	  _DrawTextBox( d->dp, &d->d1, 1, d->d2, !( d->flags & D_SELECTED ), 8, d->x, d->y, d->w-bar-1, d->h, ( d->flags & D_DISABLED ), fg_color, ( windos_framebg ), ( windos_framebg ) );
      _DrawScrollableFrame( d, d->d1, d->d2, height, fg_color, d->bg );
      return D_O_K;
   }
   //
   return dTextBoxProcedure( msg, d, c );
}
/****************************************************************************/
	  int TextProcedure( int msg, DIALOG *d, int c )
      {
		 int fg = ( windos_text );
         //
         if ( msg==MSG_DRAW ) 
         {
            if ( d->fg == BILL_TITLE )
			   fg = ( windos_titletext );
            else
			   fg = ( windos_text );
            if ( d->bg == BILL_CLEAR )
			   text_mode( -1 );
			else if ( d->bg == BILL_TITLE )
			   text_mode( ( windos_activetitle ) );
			else
			   text_mode( ( windos_face ) );
			//
			GuiTextoutEx( DialogGuiScreen, d->dp, d->x, d->y, fg, -1, FALSE );
		 }
		 text_mode( -1 );
		 //
         return D_O_K;
      }
/****************************************************************************/
	  int RightTextProcedure( int msg, DIALOG *d, int c )
      {
         int len;
         //
         if ( msg == MSG_DRAW )
         {
            len = strlen( d->dp );
			rectfill( DialogGuiScreen, d->x, d->y, d->x+d->w, d->y+d->h, d->bg );
			textout_ex( DialogGuiScreen, default_font, d->dp, d->x+d->w-len*text_length( default_font, "A" ), d->y+1, d->fg, d->bg );
         }
         //
         return D_O_K;
      }
/****************************************************************************/
	  int dButtonProcedure( int msg, DIALOG *d, int c )
	  {
		 int state1, state2;
		 int black;
		 int swap;
		 int g;
		 //
		 ASSERT( d );
		 //
		 switch ( msg )
		 {
		 case MSG_DRAW:
			if ( d->flags & D_SELECTED )
			{
			   g = 1;
			   state1 = d->bg;
			   state2 = ( d->flags & D_DISABLED ) ? ( windos_disabledtext ) : ( windos_text );
			}
			else
			{
			   g = 0;
			   state1 = ( d->flags & D_DISABLED ) ? ( windos_disabledtext ) : ( windos_text );
			   state2 = d->bg;
		 }
		 rectfill( DialogGuiScreen, d->x+1+g, d->y+1+g, d->x+d->w-3+g, d->y+d->h-3+g, state2 );
		 rect( DialogGuiScreen, d->x+g, d->y+g, d->x+d->w-2+g, d->y+d->h-2+g, state1 );
		 if ( d->dp && strlen( d->dp ) )
			GuiTextoutEx( DialogGuiScreen, d->dp, d->x+d->w/2+g, d->y+d->h/2-text_height( default_font )/2+g, state1, -1, TRUE );
		 //
		 if ( d->flags & D_SELECTED )
		 {
			vline( DialogGuiScreen, d->x, d->y, d->y+d->h-2, d->bg );
			hline( DialogGuiScreen, d->x, d->y, d->x+d->w-2, d->bg );
		 }
		 else
		 {
			black = makecol( 0, 0, 0 );
			vline( DialogGuiScreen, d->x+d->w-1, d->y+1, d->y+d->h-2, black );
			hline( DialogGuiScreen, d->x+1, d->y+d->h-1, d->x+d->w-1, black );
		 }
		 if ( ( d->flags & D_GOTFOCUS ) && ( !( d->flags & D_SELECTED ) || !( d->flags & D_EXIT ) ) )
			DottedRect( d->x+1+g, d->y+1+g, d->x+d->w-3+g, d->y+d->h-3+g, state1, 0 );
		 break;
		 case MSG_WANTFOCUS:
			return D_WANTFOCUS;
			break;
		 case MSG_KEY:
			if ( d->flags & D_EXIT )
			{
			   return D_CLOSE;
		 }
		 d->flags ^= D_SELECTED;
		 ObjectMessage( d, MSG_DRAW, 0 );
		 break;
		 case MSG_CLICK:
			state1 = d->flags & D_SELECTED;
			if ( d->flags & D_EXIT )
			   swap = FALSE;
			else
			   swap = state1;
			//
			if ( GuiMouseB() )
			{
			   state2 = ( ( GuiMouseX() >= d->x ) && ( GuiMouseY() >= d->y ) && ( GuiMouseX() < d->x + d->w ) && ( GuiMouseY() < d->y + d->h ) );
			   if ( swap )
				  state2 = !state2;
			   if ( ( ( state1 ) && ( !state2 ) ) || ( ( state2 ) && ( !state1 ) ) )
			   {
				  d->flags ^= D_SELECTED;
				  state1 = d->flags & D_SELECTED;
				  ObjectMessage( d, MSG_DRAW, 0 );
			   }
			   BroadcastDialogMessage( MSG_IDLE, 0 );
			}
			if ( ( d->flags & D_SELECTED ) && ( d->flags & D_EXIT ) )
			{
			   d->flags ^= D_SELECTED;
			   return D_CLOSE;
			}
			break;
	  }
	  //
	  return D_O_K;
   }
/****************************************************************************/
   int CheckProcedure( int msg, DIALOG *d, int c )
   {
	  int x;
	  int fg;
	  //
      if ( msg==MSG_DRAW )
      {
         if( d->flags & D_DISABLED )
			fg = ( windos_disabledtext );
         else
			fg = ( windos_text );
		 text_mode( ( windos_face ) );
		 if ( d->d1 )
		 {
			x = d->x +
			GuiTextoutEx( DialogGuiScreen, d->dp, d->x, d->y+( d->h-( text_height( default_font )-GuiFontBaseline ) )/2, fg, -1, FALSE ) +
			text_height( default_font )/2;
		 }
		 else
		 {
			x = d->x;
			GuiTextoutEx( DialogGuiScreen, d->dp, d->x + d->h + text_height( default_font )/2, d->y+( d->h-( text_height( default_font )-GuiFontBaseline ) )/2, fg, -1, FALSE );
		 }
		 text_mode( -1 );
		 TdBox( DialogGuiScreen, x, d->y, d->h, d->h, STL_IN + STL_FRAME + ( fg == ( windos_disabledtext ) ? STL_FACE : STL_FRAMEFILLED ) );
		 if ( d->flags & D_SELECTED )
		 {
			line( DialogGuiScreen, x+2, d->y+2, x+d->h-2, d->y+d->h-2, fg );
			line( DialogGuiScreen, x+2, d->y+d->h-2, x+d->h-2, d->y+2, fg );
         }
         return D_O_K;
      }
      else
		 return dButtonProcedure( msg, d, c );
   }
/****************************************************************************/
   int dSliderProcedure( int msg, DIALOG *d, int c )
   {
      BITMAP *slhan = NULL;
      int oldpos, newpos;
      int sfg; 
      int vert = TRUE; 
      int hh = 7; 
      int hmar; 
      int slp; 
      int mp; 
      int irange;
      int slx, sly, slh, slw;
      int msx, msy;
      int retval = D_O_K;
	  int upkey, downkey;
	  int pgupkey, pgdnkey;
	  int homekey, endkey;
      int delta;
      fixed slratio, slmax, slpos;
      int ( *proc )( void *cbpointer, int d2value );
      int oldval;
      //
      ASSERT( d );
      if ( d->h < d->w )
         vert = FALSE;
      if ( d->dp != NULL ) 
      {
         slhan = ( BITMAP * )d->dp;
         if ( vert )
            hh = slhan->h;
         else
            hh = slhan->w;
      }
      hmar = hh/2;
      irange = ( vert ) ? d->h : d->w;
      slmax = itofix( irange-hh );
      slratio = slmax / ( d->d1 );
      slpos = slratio * d->d2;
      slp = fixtoi( slpos );
      switch ( msg ) 
      {
         case MSG_DRAW:
			sfg = ( d->flags & D_DISABLED ) ? ( windos_disabledtext ) : d->fg;
            if ( vert ) 
            {
			   rectfill( DialogGuiScreen, d->x, d->y, d->x+d->w/2-2, d->y+d->h-1, d->bg );
			   rectfill( DialogGuiScreen, d->x+d->w/2-1, d->y, d->x+d->w/2+1, d->y+d->h-1, sfg );
			   rectfill( DialogGuiScreen, d->x+d->w/2+2, d->y, d->x+d->w-1, d->y+d->h-1, d->bg );
            }
            else 
            {
			   rectfill( DialogGuiScreen, d->x, d->y, d->x+d->w-1, d->y+d->h/2-2, d->bg );
			   rectfill( DialogGuiScreen, d->x, d->y+d->h/2-1, d->x+d->w-1, d->y+d->h/2+1, sfg );
			   rectfill( DialogGuiScreen, d->x, d->y+d->h/2+2, d->x+d->w-1, d->y+d->h-1, d->bg );
            }
            if ( slhan ) 
            {
               if ( vert ) 
               {
                  slx = d->x+( d->w/2 )-( slhan->w/2 );
                  sly = d->y+( d->h-1 )-( hh+slp );
               } 
               else 
               {
                  slx = d->x+slp;
                  sly = d->y+( d->h/2 )-( slhan->h/2 );
               }
			   draw_sprite( DialogGuiScreen, slhan, slx, sly );
         } 
         else 
         {
            if ( vert ) 
            {
               slx = d->x;
               sly = d->y+( d->h )-( hh+slp );
               slw = d->w-1;
               slh = hh-1;
            }
            else
            {
               slx = d->x+slp;
               sly = d->y;
               slw = hh-1;
               slh = d->h-1;
            }
			rectfill( DialogGuiScreen, slx+2, sly, slx+( slw-2 ), sly+slh, sfg );
			vline( DialogGuiScreen, slx+1, sly+1, sly+slh-1, sfg );
			vline( DialogGuiScreen, slx+slw-1, sly+1, sly+slh-1, sfg );
			vline( DialogGuiScreen, slx, sly+2, sly+slh-2, sfg );
			vline( DialogGuiScreen, slx+slw, sly+2, sly+slh-2, sfg );
			vline( DialogGuiScreen, slx+1, sly+2, sly+slh-2, d->bg );
			hline( DialogGuiScreen, slx+2, sly+1, slx+slw-2, d->bg );
			putpixel( DialogGuiScreen, slx+2, sly+2, d->bg );
         }
         if ( d->flags & D_GOTFOCUS )
            DottedRect( d->x, d->y, d->x+d->w-1, d->y+d->h-1, sfg, d->bg );
         break;
         case MSG_WANTFOCUS:
         case MSG_LOSTFOCUS:
            return D_WANTFOCUS;
         case MSG_KEY:
            if ( !( d->flags & D_GOTFOCUS ) )
               return D_WANTFOCUS;
            else
               return D_O_K;
         case MSG_CHAR:
            c >>= 8;
            if ( vert ) 
            {
			   upkey = KEY_UP;
			   downkey = KEY_DOWN;
			   pgupkey = KEY_PGUP;
			   pgdnkey = KEY_PGDN;
			   homekey = KEY_END;
			   endkey = KEY_HOME;
            } 
            else
            {
			   upkey = KEY_RIGHT;
			   downkey = KEY_LEFT;
			   pgupkey = KEY_PGDN;
			   pgdnkey = KEY_PGUP;
			   homekey = KEY_HOME;
			   endkey = KEY_END;
         }
		 if ( c == upkey )
            delta = 1;
		 else if ( c == downkey )
            delta = -1;
		 else if ( c == pgdnkey )
            delta = -d->d1 / 16;
		 else if ( c == pgupkey )
            delta = d->d1 / 16;
		 else if ( c == homekey )
            delta = -d->d2;
		 else if ( c == endkey )
            delta = d->d1 - d->d2;
         else
            delta = 0;
         if ( delta ) 
         {
            oldpos = slp;
            oldval = d->d2;
			while ( 1 )
            {
               d->d2 = d->d2+delta;
               slpos = slratio*d->d2;
               slp = fixtoi( slpos );
               if ( ( slp != oldpos ) || ( d->d2 <= 0 ) || ( d->d2 >= d->d1 ) )
               {
                  break;
               }
            }
            if ( d->d2 < 0 )
               d->d2 = 0;
            if ( d->d2 > d->d1 )
               d->d2 = d->d1;
            retval = D_USED_CHAR;
            if ( d->d2 != oldval )
            {
               if ( d->dp2 )
               {
                  proc = d->dp2;
                  retval |= ( *proc )( d->dp3, d->d2 );
               }
               ObjectMessage( d, MSG_DRAW, 0 );
            }
         }
         break;
         case MSG_WHEEL: 
            oldval = d->d2;
            d->d2 = MID( 0, d->d2+c, d->d1 );
            if ( d->d2 != oldval ) 
            {
               if ( d->dp2 ) 
               {
                  proc = d->dp2;
                  retval |= ( *proc )( d->dp3, d->d2 );
               }
               ObjectMessage( d, MSG_DRAW, 0 );
            }
            break;
         case MSG_CLICK:
            mp = slp;
/*while*/      if ( GuiMouseB() )
            {
               msx = GuiMouseX();
               msy = GuiMouseY();
               oldval = d->d2;
               if ( vert )
                  mp = ( d->y+d->h-hmar )-msy;
               else
                  mp = msx-( d->x+hmar );
               if ( mp < 0 )
                  mp = 0;
               if ( mp > irange-hh )
                  mp = irange-hh;
               slpos = itofix( mp );
               slmax = fixdiv( slpos, slratio );
               newpos = fixtoi( slmax );
               if ( newpos != oldval )
               {
                  d->d2 = newpos;
                  if ( d->dp2 != NULL )
                  {
                     proc = d->dp2;
                     retval |= ( *proc )( d->dp3, d->d2 );
                  }
                  ObjectMessage( d, MSG_DRAW, 0 );
               }
               BroadcastDialogMessage( MSG_IDLE, 0 );
            }
            break;
         }
         //
         return retval;
   }
/****************************************************************************/
   int SliderProcedure( int msg, DIALOG *d, int c )
   {
      BITMAP *slhan = NULL;
      int sfg; 
      int vert = TRUE; 
      int hh = 10; 
      int hmar; 
      int slp; 
      int irange;
      int slx, sly, slh, slw;
      int ret;
      fixed slratio, slmax, slpos;
      //
      if ( msg == MSG_DRAW ) 
      {
		 if ( d->h < d->w )
            vert = FALSE;
         if ( d->dp != NULL ) 
         {
            slhan = ( BITMAP * )d->dp;
            if ( vert )
               hh = slhan->h;
            else
               hh = slhan->w;
         }
         hmar = hh/2;
         irange = ( vert ) ? d->h : d->w;
         slmax = itofix( irange-hh );
         slratio = slmax / ( d->d1 );
         slpos = slratio * d->d2;
         slp = fixtoi( slpos );
		 sfg = ( d->flags & D_DISABLED ) ? ( windos_disabledtext ) : d->fg;
         if ( vert ) 
         {
			rectfill( DialogGuiScreen, d->x, d->y, d->x+d->w, d->y+d->h, ( windos_face ) );
			TdBox( DialogGuiScreen, d->x+d->w/2-2, d->y, 3, d->h, STL_IN + STL_FRAME + STL_FLAT );
         }
         else 
         {
			rectfill( DialogGuiScreen, d->x, d->y, d->x+d->w, d->y+d->h, ( windos_face ) );
			TdBox( DialogGuiScreen, d->x, d->y+d->h/2-2, d->w, 3, STL_IN + STL_FRAME + STL_FLAT );
         }
         if ( slhan ) 
         {
            if ( vert ) 
            {
               slx = d->x+( d->w/2 )-( slhan->w/2 );
               sly = d->y+d->h-( hh+slp );
            } 
            else 
            {
               slx = d->x+slp;
               sly = d->y+( d->h/2 )-( slhan->h/2 );
            }
			draw_sprite( DialogGuiScreen, slhan, slx, sly );
		 }
         else 
         {
            if ( vert ) 
            {
               slx = d->x;
               sly = d->y+d->h-( hh+slp );
               slw = d->w;
               slh = hh;
			   TdBox( DialogGuiScreen, slx, sly+2, ( slw ), slh-2, STL_OUT + STL_FACE );
            }
            else
            {
               slx = d->x+slp;
               sly = d->y;
               slw = hh;
               slh = d->h;
			   TdBox( DialogGuiScreen, slx+2, sly, ( slw-2 ), slh, STL_OUT + STL_FACE );
            }
         }
		 ret=D_O_K;
      }
      else
      {
         ret = dSliderProcedure( msg, d, c );
      }
      //
      return ret;
   }
/****************************************************************************/
   int WindowProcedure( int msg, DIALOG *d, int c )
   {
	  if ( msg==MSG_DRAW )
	  {
		 TdBox( DialogGuiScreen, d->x, d->y, d->w, d->h, STL_OUT + STL_FLAT );
	  }
	  //
	  return D_O_K;
   }
/****************************************************************************/
   int BarProcedure( int msg, DIALOG *d, int c )
   {
	  int tbx, tby, tbw, tbh, texty;
	  //
      tbx = d->x+3; 
      tby = d->y+3;
      tbw = d->w-6;
      tbh = 16;
      texty = 7;
	  if ( msg==MSG_DRAW )
	  {
		 TdBox( DialogGuiScreen, d->x, d->y, d->w, d->h, STL_OUT + STL_FLAT );
		 rectfill( DialogGuiScreen, d->x + 1, d->y + 1, d->x + ( d->w - 2 ), d->y + ( d->h - 2 ), (l_int)d->dp );
	  }
      //
      return D_O_K;
   }
/****************************************************************************/
   int dListProcedure( int msg, DIALOG *d, int c )
   {
      int listsize, i, bottom, height, bar, orig;
      l_text sel = d->dp2;
      int redraw = FALSE;
      //
      ASSERT( d );
      //
      switch ( msg )
      {
         case MSG_START:
            ( *( getfuncptr )d->dp )( -1, &listsize );
            _HandleScrollableScroll( d, listsize, &d->d1, &d->d2 );
            break;
         case MSG_DRAW:
            _DrawListBox( d );
            break;
         case MSG_CLICK:
            ( *( getfuncptr )d->dp )( -1, &listsize );
			height = ( d->h-4 ) / text_height( default_font );
            bar = ( listsize > height );
            if ( ( !bar ) || ( GuiMouseX() < d->x+d->w-13 ) ) 
            {
			   if ( ( sel ) && ( !( key_shifts & KB_CTRL_FLAG ) ) )
               {
                  for ( i=0; i<listsize; i++ ) 
                  {
                     if ( sel[ i ] ) 
                     {
                        redraw = TRUE;
                        sel[ i ] = FALSE;
                     }
                  }
                  if ( redraw )
                     ObjectMessage( d, MSG_DRAW, 0 );
               }
               _HandleListBoxClick( d );
/*while*/      if ( GuiMouseB() )
			   {
                  BroadcastDialogMessage( MSG_IDLE, 0 );
                  d->flags |= D_INTERNAL;
                  _HandleListBoxClick( d );
                  d->flags &= ~D_INTERNAL;
               }
            }
            else 
            {
               _HandleScrollableScrollClick( d, listsize, &d->d2, height );
         }
         break;
         case MSG_DCLICK:
            ( *( getfuncptr )d->dp )( -1, &listsize );
			height = ( d->h-4 ) / text_height( default_font );
            bar = ( listsize > height );
            if ( ( !bar ) || ( GuiMouseX() < d->x+d->w-13 ) ) 
            {
               if ( d->flags & D_EXIT ) 
               {
                  if ( listsize ) 
                  {
                     i = d->d1;
                     ObjectMessage( d, MSG_CLICK, 0 );
                     if ( i == d->d1 ) 
                        return D_CLOSE;
                  }
               }
            }
            break;
         case MSG_WHEEL:
            ( *( getfuncptr )d->dp )( -1, &listsize );
			height = ( d->h-4 ) / text_height( default_font );
            if ( height < listsize ) 
            {
               int delta = ( height > 3 ) ? 3 : 1;
               if ( c > 0 ) 
                  i = MAX( 0, d->d2-delta );
               else
                  i = MIN( listsize-height, d->d2+delta );
               if ( i != d->d2 ) 
               {
                  d->d2 = i;
                  ObjectMessage( d, MSG_DRAW, 0 );
               }
            }
            break;
         case MSG_KEY:
            ( *( getfuncptr )d->dp )( -1, &listsize );
            if ( ( listsize ) && ( d->flags & D_EXIT ) )
               return D_CLOSE;
            break;
         case MSG_WANTFOCUS:
            return D_WANTFOCUS;
         case MSG_CHAR:
            ( *( getfuncptr )d->dp )( -1, &listsize );
            if ( listsize ) 
            {
               c >>= 8;
			   bottom = d->d2 + ( d->h-4 )/text_height( default_font ) - 1;
               if ( bottom >= listsize-1 )
                  bottom = listsize-1;
               orig = d->d1;
               if ( c == KEY_UP )
                  d->d1--;
               else if ( c == KEY_DOWN )
                  d->d1++;
               else if ( c == KEY_HOME )
                  d->d1 = 0;
               else if ( c == KEY_END )
                  d->d1 = listsize-1;
               else if ( c == KEY_PGUP ) 
               {
                  if ( d->d1 > d->d2 )
                     d->d1 = d->d2;
                  else
                     d->d1 -= ( bottom - d->d2 ) ? bottom - d->d2 : 1;
               }
               else if ( c == KEY_PGDN ) 
               {
                  if ( d->d1 < bottom )
                     d->d1 = bottom;
                  else
                     d->d1 += ( bottom - d->d2 ) ? bottom - d->d2 : 1;
               } 
               else 
                  return D_O_K;
               if ( sel ) 
               {
				  if ( !( key_shifts & ( KB_SHIFT_FLAG | KB_CTRL_FLAG ) ) )
                  {
                     for ( i=0; i<listsize; i++ )
                        sel[ i ] = FALSE;
                  }
				  else if ( key_shifts & KB_SHIFT_FLAG )
                  {
                     for ( i=MIN( orig, d->d1 ); i<=MAX( orig, d->d1 ); i++ ) 
                     {
						if ( key_shifts & KB_CTRL_FLAG )
                           sel[ i ] = ( i != d->d1 );
                        else
                           sel[ i ] = TRUE;
                     }
                  }
               }
               _HandleScrollableScroll( d, listsize, &d->d1, &d->d2 );
               d->flags |= D_DIRTY;
               //
               return D_USED_CHAR;
            }
            break;
            default:
         break;
      }
      //
      return D_O_K;
}
/****************************************************************************/
int ListProcedure( int msg, DIALOG *d, int c )
{
   int ret;
   //
   if ( msg == MSG_DRAW ) 
   {
      _DrawListBox( d );
      ret = D_O_K;
   }
   else 
   {
      ret = dListProcedure( msg, d, c );
   }
   //
   return ret;
}
/****************************************************************************/
int dRadioProcedure( int msg, DIALOG *d, int c )
{
   int ret;
   //
   ASSERT( d );
   //
   ret = ButtonProcedure( msg, d, 0 );
   if ( ( ( msg == MSG_KEY ) || ( msg == MSG_CLICK ) ) && ( d->flags & D_SELECTED ) && ( !( d->flags & D_EXIT ) ) )
   {
	  d->flags &= ~D_SELECTED;
	  BroadcastDialogMessage( MSG_RADIO, d->d1 );
	  d->flags |= D_SELECTED;
   }
   //
   return ret;
}
/****************************************************************************/
int RadioProcedure( int msg, DIALOG *d, int c )
{
   int ret = D_O_K;
   int fg;
   int x;
   //
   if (msg == MSG_DRAW)
   {
      if ( d->d2 == 1 )
      {
		 ret = ButtonProcedure( MSG_DRAW, d, c );
      }
      else
      {
		 fg = ( windos_text );
		 text_mode( ( windos_face ) );
		 GuiTextoutEx( DialogGuiScreen, d->dp, d->x + 15, d->y + ( d->h - ( text_height( default_font ) - GuiFontBaseline ) ) / 2, fg, -1, FALSE );
		 //
		 x = d->x;
		 if (d->flags & D_DISABLED)
			masked_blit( radio_grey, DialogGuiScreen, 0, 0, x, d->y, 12, 12 );
		 else if (d->flags & D_SELECTED)
			masked_blit( radio_sel, DialogGuiScreen, 0, 0, x, d->y, 12, 12 );
		 else
			masked_blit( radio_unsel, DialogGuiScreen, 0, 0, x, d->y, 12, 12 );
		 text_mode( -1 );
	  }
   }
   else
   {
      ret = dRadioProcedure( msg, d, c );
   }
   //
   return ret;
}
/****************************************************************************/
int IconProcedure( int msg, DIALOG *d, int c )
{
   BITMAP *butimage;
   int butx;
   int buty;
   int index;
   int indent;
   int depth;
   //
   ASSERT( d );
   //
   butimage = ( BITMAP * )d->dp;
   if ( ( msg == MSG_DRAW ) && ( !( d->flags & D_HIDDEN ) ) ) 
   {
      depth = 0;
      if ( ( d->dp2 == NULL ) && ( d->flags & D_SELECTED ) ) 
      {
         depth = d->d1;
         if ( depth<1 )
            depth = 2;
      }
      if ( ( d->dp2 != NULL ) && ( d->flags & D_SELECTED ) ) 
      {
         butimage = ( BITMAP * )d->dp2;
      }
      if ( ( d->dp3 != NULL ) && ( d->flags & D_DISABLED ) ) 
      {
         butimage = ( BITMAP * )d->dp3;
      }
      indent = d->d2;
      if ( indent==0 )
         indent = 2;
      butx = butimage->w;
      buty = butimage->h;
	  stretch_blit( butimage, DialogGuiScreen, 0, 0, butx-depth, buty-depth, d->x+depth, d->y+depth, d->w-depth, d->h-depth );
      if ( ( d->flags & D_GOTFOCUS ) && ( !( d->flags & D_SELECTED ) || !( d->flags & D_EXIT ) ) ) 
      {
         for ( index=indent; index<d->w-( indent+1 ); index+=2 ) 
         {
			putpixel( DialogGuiScreen, d->x+index+depth, d->y+indent+depth, d->fg );
			putpixel( DialogGuiScreen, d->x+index+depth, d->y+d->h-( indent+1 )+depth, d->fg );
         }
         for ( index=indent; index<d->h-( indent+1 ); index+=2 ) 
         {
			putpixel( DialogGuiScreen, d->x+indent+depth, d->y+index+depth, d->fg );
			putpixel( DialogGuiScreen, d->x+d->w-( indent+1 )+depth, d->y+index+depth, d->fg );
         }
      }
      for ( index=0; index<depth; index++ ) 
      {
		 hline( DialogGuiScreen, d->x, d->y+index, d->x+d->w-1, d->bg );
		 vline( DialogGuiScreen, d->x+index, d->y, d->y+d->h-1, d->bg );
      }
      //
      return D_O_K;
   }
   //
   return ButtonProcedure( msg, d, c );
}
/****************************************************************************/
int CallbackIconProcedure( int msg, DIALOG *d, int c )
{
   int ret;
   int ( *proc )();
   //
   if ( !( d->flags & D_EXIT ) )
      d->flags += D_EXIT;
   ret = IconProcedure( msg, d, c );
   if ( ret == D_CLOSE ) 
   {
      ret = D_O_K;
      ObjectMessage( d, MSG_DRAW, 0 );
      if ( d->dp2 ) 
      {
         proc = d->dp2;
         ( *proc )();
         return D_O_K;
      }
   }
   //
   return ret;
}
/****************************************************************************/
int ButtonProcedure( int msg, DIALOG *d, int c )
{
   int state;
   int ret;
   int txoff = 0;
   int txcol;
   //
   if ( msg == MSG_DRAW )
   {
	  if ( d->flags & D_SELECTED )
	  {
		 state = STL_IN;
		 txoff = 1;
		 state += STL_BUTTONDOWN;
	  }
	  else
	  {
		 state = STL_OUT;
	  }
	  //
	  if ( ( d->flags & D_GOTFOCUS ) && ( !( d->flags & D_SELECTED ) ) )
	  {
		 TdBox( DialogGuiScreen, d->x+1, d->y+1, d->w-2, d->h-2, state + STL_FLAT );
		 rect( DialogGuiScreen, d->x, d->y, d->x+d->w, d->y+d->h, ( windos_dkshadow ) );
	  }
	  else
		 TdBox( DialogGuiScreen, d->x, d->y, d->w, d->h, state + STL_FLAT );
	  //
	  text_mode( -1 );
	  if ( d->flags & D_DISABLED )
		 txcol = windos_disabledtext;
	  else
		 txcol = windos_text;
	  //
	  if ( d->dp && strlen( d->dp ) )
		 GuiTextoutEx( DialogGuiScreen, d->dp, d->x+d->w/2+txoff, d->y+d->h/2-text_height( default_font )/2+1+txoff, txcol, -1, TRUE );
	  //
	  if ( ( d->flags & D_GOTFOCUS ) && ( !( d->flags & D_SELECTED ) || !( d->flags & D_EXIT ) ) )
		 DottedRect( d->x+3, d->y+3, d->x+d->w - 3, d->y+d->h - 3, ( windos_shadow ), 0 );
	  //
	  ret = D_O_K;
   }
   else
   {
	  ret = dButtonProcedure( msg, d, c );
   }
   //
   return ret;
}
/****************************************************************************/
int dExButtonProcedure( int msg, DIALOG *d, int c )
{
   int ret;
   int ( *proc )( void *cbpointer, int d2value );
   //
   if ( !( d->flags & D_EXIT ) )
	  d->flags += D_EXIT;
   ret = ButtonProcedure( msg, d, c );
   if ( ret == D_CLOSE )
   {
	  ret = D_O_K;
	  ObjectMessage( d, MSG_DRAW, 0 );
	  if ( d->dp2 )
	  {
		 proc = d->dp2;
		 ( *proc )( d->dp3, d->d2 );
		 return D_O_K;
	  }
   }
   //
   return ret;
}
/****************************************************************************/
int dCallbackButtonProcedure( int msg, DIALOG *d, int c )
{
   int ret;
   int ( *proc )();
   //
   if ( !( d->flags & D_EXIT ) )
	  d->flags += D_EXIT;
   ret = ButtonProcedure( msg, d, c );
   if ( ret == D_CLOSE )
   {
	  ret = D_O_K;
	  ObjectMessage( d, MSG_DRAW, 0 );
	  if ( d->dp2 )
	  {
		 proc = d->dp2;
		 ( *proc )();
		 return D_O_K;
	  }
   }
   //
   return ret;
}
/****************************************************************************/
int hLineProcedure( int msg, DIALOG *d, int c )
{
   if ( msg == MSG_DRAW )
   {
	  TdhLine( DialogGuiScreen, d->x, d->y, d->x+d->w );
   }
   //
   return D_O_K;
}
/****************************************************************************/
int vLineProcedure( int msg, DIALOG *d, int c )
{
   if ( msg == MSG_DRAW ) 
   {
	  TdvLine( DialogGuiScreen, d->x, d->y, d->y+d->h );
   }
   //
   return D_O_K;
}
/****************************************************************************/
int GroupBoxProcedure( int msg, DIALOG *d, int c )
{
   int w = 0;
   int y = 0;
   //
   if( d->dp )
	  y = d->y + text_height( default_font )/2;
   else
      y = d->y;
   if( msg == MSG_DRAW )
   {
	  rect( DialogGuiScreen, d->x+1, y+1, d->x+d->w-1, y+d->h-1, ( windos_hlight ) );
	  rect( DialogGuiScreen, d->x, y, d->x+d->w-2, y+d->h-2, ( windos_shadow ) );
      if( d->dp )
      {
		 w = text_length( default_font, d->dp );
		 rectfill( DialogGuiScreen, d->x+5, y, d->x+15+w, y+1, ( windos_face ) );
		 textout_ex( DialogGuiScreen, default_font, d->dp, d->x+10, d->y, ( windos_text ), ( windos_face ) );
      }
   }
   //
   return( D_O_K );
}
/****************************************************************************/
int _dd_pos[ 3 ];
//
int DdlistCloserProcedure( int msg, DIALOG *d, int c )
{
   if( msg == MSG_CLICK )
   {
	  if ( GuiMouseB() )
         ;
      if ( !( is_in( GuiMouseX(), GuiMouseY(), _dd_pos[ 0 ], _dd_pos[ 1 ], _dd_pos[ 2 ], _dd_pos[ 3 ] ) ) )
         ;
      return( D_CLOSE );
   }
   //
   return( D_O_K );
}
/****************************************************************************/
int DdlistListProcedure( int msg, DIALOG *d, int c )
{
   int d2 = d->d2;
   int ret = ListProcedure( msg, d, c );
   //
   if( msg == MSG_CLICK )
   {
      if( d->d2 == d2 ) 
         return( D_CLOSE );
   }
   //
   return( ret );
}
/****************************************************************************/
int _OpenListComboBox( DIALOG *d )
{
   DIALOG dlg[ 3 ] = {{NULL}};
   //
   memset( dlg, 0, sizeof( dlg ) );
   dlg[ 0 ].proc = DdlistCloserProcedure;
   dlg[ 0 ].w = SCREEN_W;
   dlg[ 0 ].h = SCREEN_H;
   dlg[ 1 ].proc = DdlistListProcedure; 
   dlg[ 1 ].x = d->x;
   dlg[ 1 ].y = d->y+d->h+2;
   dlg[ 1 ].w = d->w-1;
   dlg[ 1 ].h = text_height( default_font )*4+4;
   dlg[ 1 ].dp = d->dp;
   dlg[ 1 ].d1 = d->d1;
   dlg[ 1 ].dp2 = d->dp2;
   dlg[ 1 ].flags = D_EXIT;
   _dd_pos[ 0 ] = dlg[ 1 ].x; 
   _dd_pos[ 1 ] = dlg[ 1 ].y;
   _dd_pos[ 2 ] = dlg[ 1 ].w;
   _dd_pos[ 3 ] = dlg[ 1 ].h;
   //
   DoWindow( dlg, 1 );
   //
   BroadcastDialogMessage( MSG_DRAW, 0 );
   InitRadioButtons();
   d->d1 = dlg[ 1 ].d1;
   ObjectMessage( d, MSG_DRAW, 0 );
   //
   return D_O_K;
}
/****************************************************************************/
int DdlistProcedure( int msg, DIALOG *d, int c )
{
   int ret = D_O_K;
   DIALOG dlg[ 3 ] = {{NULL}};
   l_text text;
   //
   dlg[ 0 ].proc = ButtonProcedure;
   dlg[ 0 ].w = d->h-4;
   dlg[ 0 ].h = d->h-4;
   dlg[ 0 ].y = d->y+2;
   dlg[ 0 ].x = d->x+d->w-2-dlg[ 0 ].w;
   dlg[ 0 ].dp = "+";
   dlg[ 0 ].flags = D_EXIT;
   switch( msg )
   {
      case MSG_WANTFOCUS :
         {
            return( D_GOTFOCUS );
		 break;
      }
      case MSG_CLICK:
         {
            if( is_in( GuiMouseX(), GuiMouseY(), dlg[ 0 ].x, dlg[ 0 ].y, dlg[ 0 ].w, dlg[ 0 ].h ) )
            {
               ret = ObjectMessage( &dlg[ 0 ], msg, 0 );
               if( ret == D_CLOSE )
               {
                  ret = D_O_K;
                  ObjectMessage( &dlg[ 0 ], MSG_DRAW, 0 );
                  _OpenListComboBox( d );
               }
         }
         else
         {
			if ( GuiMouseB() )
               ;
            _OpenListComboBox( d );
         }
		 if ( GuiMouseB() )
            ;
      }
      break;
      case MSG_DRAW :
         {
            if( d->flags & D_DISABLED )
			   TdBox( DialogGuiScreen, d->x, d->y, d->w, d->h, STL_IN + STL_FACE );
            else if( d->flags & D_GOTFOCUS )
            {
			   TdBox( DialogGuiScreen, d->x, d->y, d->w, d->h, STL_IN + STL_FRAME + STL_TITLEBAR );
			   rect( DialogGuiScreen, d->x+2, d->y+2, dlg[ 0 ].x-1, d->h-2+d->y, ( windos_framebg ) );
         }
         else
			TdBox( DialogGuiScreen, d->x, d->y, d->w, d->h, STL_IN + STL_FRAME + STL_FRAMEFILLED );
         ObjectMessage( &dlg[ 0 ], msg, 0 );
         text = ( *( getfuncptr )d->dp )( d->d1, NULL );
         if( d->flags & D_GOTFOCUS )
			textout( DialogGuiScreen, default_font, text, d->x+8, d->y+( d->h-text_height( default_font ) )/2, ( windos_titletext ) );
         else if( d->flags & D_DISABLED )
			textout( DialogGuiScreen, default_font, text, d->x+8, d->y+( d->h-text_height( default_font ) )/2, ( windos_disabledtext ) );
         else
			textout( DialogGuiScreen, default_font, text, d->x+8, d->y+( d->h-text_height( default_font ) )/2, ( windos_text ) );
      }
      break;
      default:
         break;
   }
   //
   return( ret );
}
/****************************************************************************/
int TextListProcedure( int msg, DIALOG *d, int c )
{
   int listsize, i, a, failure;
   l_text selected, *thisitem;
   l_text sel = d->dp2;
   //
   ASSERT( d );
   //
   switch ( msg )
   {
      case MSG_START:
      case MSG_CLICK:
      case MSG_DCLICK:
      case MSG_WANTFOCUS:
      case MSG_LOSTFOCUS:
         d->dp3 = 0;
         break;
      case MSG_CHAR:
         if ( ( c & 0xFF ) < ' ' )
            d->dp3 = 0;
         break;
      case MSG_UCHAR:
         ( *( getfuncptr )d->dp )( -1, &listsize );
         if ( listsize ) 
         {
            if ( c >= ' ' ) 
            {
               selected = ( *( getfuncptr )d->dp )( d->d1, NULL );
               i = d->d1;
               do 
               {
                  thisitem = ( *( getfuncptr )d->dp )( i, NULL );
                  failure = FALSE;
                  if ( ( int )d->dp3 < ustrlen( (l_text)thisitem ) )
                  {
                     for ( a=0; a<( int )d->dp3; a++ ) 
                     {
						if ( utolower( ugetat( (l_text)thisitem, (int)a ) ) != utolower( ugetat( (l_text)selected, (int)a ) ) )
                        {
                           failure = TRUE;
                           break;
                        }
                     }
					 if ( ( !failure ) && ( utolower( ugetat( (l_text)thisitem, ( int )d->dp3 ) ) == utolower( c ) ) )
                     {
                        d->d1 = i;
                        d->dp3 = ( void * )( ( int )d->dp3 + 1 );
                        if ( sel ) 
                        {
                           for ( i=0; i<listsize; i++ )
                              sel[ i ] = FALSE;
                        }
                        _HandleScrollableScroll( d, listsize, &d->d1, &d->d2 );
                        ObjectMessage( d, MSG_DRAW, 0 );
                        return D_USED_CHAR;
                     }
                  }
                  i++;
                  if ( i >= listsize )
                     i = 0;
			   } while ( i != d->d1 );
               if ( d->dp3 ) 
               {
                  d->dp3 = 0;
                  return TextListProcedure( msg, d, c );
               }
            }
         }
         break;
   }
   //
   return ListProcedure( msg, d, c );
}
/****************************************************************************/
int KeyboardProcedure( int msg, DIALOG *d, int c )
{
   int ( *proc )();
   int ret = D_O_K;
   //
   ASSERT( d );
   //
   switch ( msg )
   {
      case MSG_START:
         d->w = d->h = 0;
         break;
      case MSG_XCHAR:
         if ( ( ( c>>8 ) != d->d1 ) && ( ( c>>8 ) != d->d2 ) )
            break;
      ret |= D_USED_CHAR;
      case MSG_KEY:
         proc = d->dp;
         ret |= ( *proc )();
		 break;
   }
   //
   return ret;
}
/****************************************************************************/
l_int LibMain( int argc, l_text *argv )
{
   InitRadioButtons();
   //
   SYSEXPORT( InitMenu );
   SYSEXPORT( UpdateMenu );
   SYSEXPORT( ShutdownMenu );
   SYSEXPORT( ActiveMenu );
   SYSEXPORT( ActiveDialog );
   SYSEXPORT( ActivateDialog );
   SYSEXPORT( CloseDialog );
   SYSEXPORT( DefaultDialogHandler );
   SYSEXPORT( PopupDialog );
   SYSEXPORT( DoWindow );
   SYSEXPORT( DoMenu );
   SYSEXPORT( DoDialog );
   SYSEXPORT( FadeBmp );
   SYSEXPORT( ReplaceColor );
   SYSEXPORT( MakeSolidPalette );
   SYSEXPORT( ProgressProcedure );
   SYSEXPORT( BitmapProcedure );
   SYSEXPORT( ScrollableBitmapProcedure );
   SYSEXPORT( hScrollbarProcedure );
   SYSEXPORT( vScrollbarProcedure );
   SYSEXPORT( TextBoxProcedure );
   SYSEXPORT( ShadowBoxProcedure );
   SYSEXPORT( BoxProcedure );
   SYSEXPORT( EditProcedure );
   SYSEXPORT( TextProcedure );
   SYSEXPORT( CentreTextProcedure );
   SYSEXPORT( RightTextProcedure );
   SYSEXPORT( CentreDialog );
   SYSEXPORT( CheckProcedure );
   SYSEXPORT( SliderProcedure );
   SYSEXPORT( WindowProcedure );
   SYSEXPORT( BarProcedure );
   SYSEXPORT( ClearProcedure );
   SYSEXPORT( ListProcedure );
   SYSEXPORT( RadioProcedure );
   SYSEXPORT( dRadioProcedure );
   SYSEXPORT( ButtonProcedure );
   SYSEXPORT( IconProcedure );
   SYSEXPORT( CallbackIconProcedure );
   SYSEXPORT( KeyboardProcedure );
   SYSEXPORT( hLineProcedure );
   SYSEXPORT( vLineProcedure );
   SYSEXPORT( GroupBoxProcedure );
   SYSEXPORT( DdlistProcedure );
   SYSEXPORT( dMenuProcedure );
   SYSEXPORT( dExButtonProcedure );
   SYSEXPORT( dCallbackButtonProcedure );
   SYSEXPORT( dExButtonProcedure );
   SYSEXPORT( dCallbackButtonProcedure );
   SYSEXPORT( _HandleListBoxClick );
   SYSEXPORT( ObjectMessage );
   SYSEXPORT( DialogMessage );
   SYSEXPORT( SetDialogColor );
   SYSEXPORT( TextListProcedure );
   SYSEXPORT( MouseX );
   SYSEXPORT( MouseY );
   SYSEXPORT( MouseZ );
   SYSEXPORT( MouseB );
   SYSEXPORT( GuiStrLen );
   SYSEXPORT( DialogGuiScreen );
   //
   return true;
}
//
void Close(void)
{
}
