#ifndef _TASK_H_INCLUDED_
   #define _TASK_H_INCLUDED_
   typedef                          struct TTask *PTask;
   typedef struct TTask
   {
      l_bool Enabled;
      l_bool	Running;
      void ( *Task )( PTask Task );
      PTask Prev;
      PTask Next;
   } TTask;
   #define ENABLE_TASK(             t ) t->Enabled = TRUE
   #define DISABLE_TASK(            t ) t->Enabled = FALSE
   #define KEEP_MULTITASK           	Yield();
   PTask InstallTask( void ( *Task )( PTask Task ) );
   void RemoveTask( PTask Task );
   void RunTasks( void *arg );
   void PollTasks( void );
   void __Internal_Poll_Tasks( void * );
   extern PTask TaskList;
#endif
