#ifndef _MOUSE_H_INCLUDED_
   #define _MOUSE_H_INCLUDED_
   typedef                          struct TCursor *PCursor;
   typedef struct TCursor
   {
      p_bitmap	Image;
      l_ulong	SpotX;
      l_ulong	SpotY;
   } TCursor;
   typedef struct TMouse *PMouse;
   typedef struct TMouse
   {
      TMouseState State;
      l_bool	Moved;
      l_bool	Visible;
      TRect	CursorPosition;
      l_int	ButtonChanges;
      PCursor Cur;
      p_bitmap PrevScr; 
      l_int Speed;	
      l_int DblClkSpeed;	
   } TMouse;
   #define MSG_MOUSE_SCLLUP         	0xFFFF1901
   #define MSG_MOUSE_SCLLDWN        0xFFFF1902
   #define BUTTON_LEFT              0x00000001
   #define BUTTON_RIGHT             0x00000002
   #define BUTTON_MIDDLE            0x00000004
   #define CUR_ARROW                cursor_arrow
   #define CUR_BEAM                 cursor_beam
   #define CUR_BUSY                 cursor_busy
   #define CUR_CROSS                cursor_cross
   #define CUR_HELP                 cursor_help
   #define CUR_MOVE                 cursor_move
   #define CUR_NO                   cursor_no
   #define CUR_PEN                  cursor_pen
   #define CUR_SIZE1                cursor_size1
   #define CUR_SIZE2                cursor_size2
   #define CUR_SIZE3                cursor_size3
   #define CUR_SIZE4                cursor_size4
   #define CUR_UP                   cursor_up
   #define CUR_WAIT                 cursor_wait
   extern PCursor cursor_arrow;
   extern PCursor cursor_beam;
   extern PCursor cursor_busy;
   extern PCursor cursor_cross;
   extern PCursor cursor_help;
   extern PCursor cursor_move;
   extern PCursor cursor_no;
   extern PCursor cursor_pen;
   extern PCursor cursor_size1;
   extern PCursor cursor_size2;
   extern PCursor cursor_size3;
   extern PCursor cursor_size4;
   extern PCursor cursor_up;
   extern PCursor cursor_wait;
   #define CURSOR_OVER_RECT(        r ) _PointInRect( Mouse->State.p, ( r ) )
   #define CURSOR_IN_RECT(          r ) _PointInRect( Mouse->State.p, ( r ) )
   _PUBLIC void GSSystemMouseInstall();
   _PUBLIC void GSSystemMouseUninstall();
   void MouseShow();
   void MouseHide();
   void MouseSetCursor ( PCursor Cur );
   void MouseSetCursorNamed ( l_text Name );
   void MouseSetCursorSpeed ( l_int Speed );
   void MouseSetDblClkSpeed ( l_int Speed );
   extern PList Cursors;
   void _MouseRecap ( p_bitmap from, TRect r );
   #define MouseRecap(              from, r ) if ( _RectOverlay( Mouse->CursorPosition, r ) ) _MouseRecap( from, r )
   extern PMouse Mouse;
   l_bool __MouseStop ( void );
   l_bool __MouseRestart ( void );
   PCursor NewCursor ( p_bitmap Img, l_int SpotX, l_int SpotY );
#endif
