#include "allegro.h"
#include "window.h"
//
#ifndef __WINDOS_ALLEG_GUI_DIALOG__
   #define __WINDOS_ALLEG_GUI_DIALOG__
   //
   typedef struct MENU_INFO            /* information about a popup menu */
   {
	  MENU *menu;                      /* the menu itself */
	  struct MENU_INFO *parent;        /* the parent menu, or NULL for root */
	  int bar;                         /* set if it is a top level menu bar */
	  int size;                        /* number of items in the menu */
	  int sel;                         /* selected item */
	  int x, y, w, h;                  /* screen position of the menu */
	  int (*proc)();                   /* callback function */
	  BITMAP *saved;                   /* saved what was underneath it */
   } MENU_INFO;
   // Allegro Gui Dialog
   typedef struct GUIMENU
   {
	  char *text;                       /* menu item text */
	  AL_METHOD( int, proc, ( void ) ); /* callback function */
	  struct GUIMENU *child;            /* to allow nested menus */
	  int flags;                        /* flags about the menu state */
	  void *dp;                         /* any data the menu might require */
	  BITMAP *ico;                      // Ico.
   } GUIMENU;
   /* stored information about the state of an active GUI menu */
   typedef struct GUIMENU_PLAYER
   {
	  GUIMENU *menu;                    /* the menu itself */
	  int bar;                          /* set if it is a top level menu bar */
	  int size;                         /* number of items in the menu */
	  int sel; /* selected item */
	  int x, y, w, h; /* screen position of the menu */
	  int ( *proc )(); /* callback function */
	  int mouse_button_was_pressed; /* set if mouse button pressed on last iteration */
	  int back_from_child; /* set if a child was activated on last iteration */
	  int timestamp; /* timestamp for gui_timer events */
	  int mouse_sel; /* item the mouse is currently over */
	  int redraw; /* set if redrawing is required */
	  int auto_open; /* set if menu auto-opening is activated */
	  int ret; /* return value */
	  DIALOG *dialog; /* d_menu_proc() parent dialog ( if any ) */
	  struct GUIMENU_PLAYER *parent; /* the parent menu, or NULL for root */
	  struct GUIMENU_PLAYER *child; /* the child menu, or NULL for none */
   } GUIMENU_PLAYER;
   /* dialogs do fancy stuff as they slide on and off the screen */
   typedef enum DIALOG_STATE
   {
	  state_start,
	  state_active,
	  state_exit,
	  state_redraw
   } DIALOG_STATE;
   //
   typedef struct TDiagWdg
   {
	  struct TWidget W;
	  PDialog o;
   } TDiagWdg, *PDiagWdg;
   //
   #define DIAGWDG( o ) ( ( PDiagWdg )( o ) )
   /* info about an active dialog */
   typedef struct TDialog
   {
	  DIALOG_STATE state;
	  DIALOG *dialog;
	  DIALOG_PLAYER *player;
	  DIALOG_STATE ( *handler )( int c );
	  PTimer T;
	  PWindow Win;
	  PDiagWdg Box;
   } TDialog, ACTIVE_DIALOG;
   //
   #define DIALOGUE( o ) ( ( PDialog )( o ) )
   //
   extern BITMAP *radio_unsel;
   extern BITMAP *radio_sel;
   extern BITMAP *radio_grey;
   //
   extern unsigned char radio_unsel_data[144];
   extern unsigned char radio_sel_data[144];
   extern unsigned char radio_grey_data[144];
#endif
