#include <stdio.h>

int main(int argc, char **argv)
{
  FILE *in, *out;
  int col;
  int c;
  long len = 0;

  if (argc < 4)
  {
    fprintf(stderr,
            "Usage: bin2c <output bin file> <output h file> <array name>\n");
    return 1;
  }

  if ((in = fopen(argv[1], "rb")) == NULL)
  {
    fprintf(stderr, "Cannot open input file (%s).\n", argv[1]);
    return 1;
  }

  if ((out = fopen(argv[2], "wt")) == NULL)
  {
    fprintf(stderr, "Cannot open output file (%s).\n", argv[2]);
    return 1;
  }

  col = 0;

  fprintf(out, "%80s\n", " " );
  fprintf(out, "unsigned char %s[ LEN_%s ] = {\n  ", argv[ 3 ], strupr( argv[ 3 ] ) );

  while ((c = fgetc(in)) != EOF)
  {
    if (col)
    {
      fprintf(out, ", ");
    }
    if (col >= 8)
    {
      fprintf(out, "\n  ");
      col = 0;
    }
    fprintf(out, "0x%02X", c);
    col++;
    len++;
  }

  fprintf(out, "\n};\n\n");
  //
  fclose(in);
  fclose(out);

  if ((out = fopen(argv[2], "r+t")) == NULL)
  {
    fprintf(stderr, "Cannot open output file (%s).\n", argv[2]);
    return 1;
  }
  fprintf(out,"#define LEN_%s\t\t%lu", strupr( argv[ 3 ] ), len );
  fclose(out);

  return 0;
}
