// Associated include file : Mecanism/Point.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/atom.h"
#include "mecanism/point.h"

static TPoint TempPoint;

// Constructors

TPoint::TPoint()
{ _X=_Y=0;
}

TPoint::TPoint(int X, int Y)
{ _X=X;
  _Y=Y;
}

TPoint::TPoint(const TPoint& P)
{ _X=P._X;
  _Y=P._Y;
}

// Operators

TPoint TPoint::operator+(TPoint P)
{ TempPoint._X=_X+P._X;
  TempPoint._Y=_Y+P._Y;
  return TempPoint;
}

TPoint TPoint::operator-(TPoint P)
{ TempPoint._X=_X-P._X;
  TempPoint._Y=_Y-P._Y;
  return TempPoint;
}

TPoint TPoint::operator+=(TPoint P)
{ _X+=P._X;
  _Y+=P._Y;
  return (*this);
}

TPoint TPoint::operator-=(TPoint P)
{ _X-=P._X;
  _Y-=P._Y;
  return (*this);
}

// Objects stream

void TPoint::Read(TDisk *file)
{ ReadInt(file,&_X);
  ReadInt(file,&_Y);
}

void TPoint::Write(TDisk *file)
{ WriteInt(file,_X);
  WriteInt(file,_Y);
}
