// Associated include file : Graphics/Lift.H

#include "common/common.h"
#include "drivers/drivers.h"
#include "mecanism/mecanism.h"
#include "graphics/graphics.h"
#include "gadgets/gadgets.h"

// --- Object TLiftButotn

DEFINE(TLiftButton);

short RegTLiftButton;
char *IdentTLiftButton = "TLiftButton";

TLiftButton::TLiftButton()
{ Defaults();
}

TLiftButton::TLiftButton(int X, int Y, int Command, int ScanCode, char *IconeDescr)
{ Defaults();
  Init(X,Y,Command,ScanCode,IconeDescr);
}

void TLiftButton::Defaults(void)
{ // Object identification
  Register=RegTLiftButton;
  Ident=IdentTLiftButton;
  // Other default values
}

void TLiftButton::Init(int X, int Y, int Command, int ScanCode, char *IconeDescr)
{ // Herited constructions
  TStdButton::Init(X,Y,13,13,Command,ScanCode,
                   boImmediate | boRepetition | boShiftedScanCode,NULL,
                   new TSysIcone(8,8,IconeDescr));
  // New constructions
}

//

void TLiftButton::Action()
{ SetCommand(Command, Father());
}

// --- Object TLift

DEFINE(TLift);

DEFINE_EVENTS_TABLE(TLift,TZone)
  COMMAND(cmLiftDec,doLiftDec)
  COMMAND(cmLiftInc,doLiftInc)
  MOUSELDOWN()
  KEYDOWN()
END_EVENTS_TABLE

short RegTLift;
char *IdentTLift = "TLift";

TLift::TLift()
{ Defaults();
}

TLift::TLift(int X, int Y, int L, int H, boolean _Horizontal)
{ Defaults();
  Init(X,Y,L,H,_Horizontal);
}

TLift::TLift(TRect R, boolean _Horizontal)
{ Defaults();
  Init(R.X1(),R.Y1(),R.Width(),R.Height(),_Horizontal);
}

void TLift::Defaults()
{ // Object identification
  Register=RegTLift;
  Ident=IdentTLift;
  // Other default values
  SetOptions(opGetAllEvents);
  Connected=NULL;
  Horizontal=TRUE;
}

void TLift::Init(int X, int Y, int L, int H, boolean _Horizontal)
{ Horizontal=_Horizontal;
  // Herited creations
  TZone::Init(X,Y,L,H);
  // New Creations
  if (Horizontal)
  { // Fixe la taille et la manire de grandir avec le parent
    Options|=opCSHiX | opCSLoY | opCSHiY;
    Where.Y1()=Where.Y2()-13;
    // Cre les boutons
    Inc=new TLiftButton(Where.Width()-13,1,cmLiftInc,ScanRightArrow,ICO_RightArrow);
    Dec=new TLiftButton(Where.Width()-27,1,cmLiftDec,ScanLeftArrow,ICO_LeftArrow);
    Inc->SetOptions(opCSLoX | opCSHiX);
    Dec->SetOptions(opCSLoX | opCSHiX);
    // Racourcis claviers
    ScanPageInc=ScanEnd;
    ScanPageDec=ScanHome;
  }
  else
  { // Fixe la taille et la manire de grandir avec le parent
    Options|=opCSHiY | opCSLoX | opCSHiX;
         Where.X1()=Where.X2()-13;
    // Cre les boutons
    Dec=new TLiftButton(1,Where.Height()-27,cmLiftDec,ScanUpArrow,ICO_UpArrow);
         Inc=new TLiftButton(1,Where.Height()-13,cmLiftInc,ScanDownArrow,ICO_DownArrow);
    Inc->SetOptions(opCSLoY | opCSHiY);
    Dec->SetOptions(opCSLoY | opCSHiY);
    // Racourcis claviers
    ScanPageInc=ScanPageDown;
    ScanPageDec=ScanPageUp;
  }
  Insert(Inc);
  Insert(Dec);
  RealP1=51;
  RealP2=150;
  ViewP1=50+30;
  ViewP2=50+70;
  Step=5;
  SizeChanged();
}

void TLift::ShrinkInside(TRect& InsideFather)
{ if (Horizontal) InsideFather.Y2()-=Where.Height();
                                 else InsideFather.X2()-=Where.Width();
}

void TLift::Draw(TRect )
{ if (Horizontal)
  { SetSysColor(FaceGray);
    LineX(0,0,Where.Width()-1);
    if (Lctr==-1)
    { Bar(2,3,Where.Width()-3,Where.Height()-3);
      Frame3D(1,0,1,Where.Width()-1,Where.Height()-1);
    }
    else
    { LineY(Where.Width()-28,1,Where.Height()-1);
      LineY(Where.Width()-14,1,Where.Height()-1);
      Bar(2,3,Where.Width()-30,Where.Height()-2);
      Frame3D(1,0,1,Where.Width()-29,Where.Height()-1);
      Frame3D(0,2+Xctr,3,2+Xctr+Lctr-1,Where.Height()-2);
    }
  }
  else
  { SetSysColor(FaceGray);
    LineY(0,0,Where.Height()-1);
    if (Lctr==-1)
    { Bar(3,2,Where.Width()-3,Where.Height()-3);
      Frame3D(1,1,0,Where.Width()-1,Where.Height()-1);
    }
    else
    { LineX(1,Where.Height()-28,Where.Width()-1);
      LineX(1,Where.Height()-14,Where.Width()-1);
      Bar(3,2,Where.Width()-2,Where.Height()-30);
      Frame3D(1,1,0,Where.Width()-1,Where.Height()-29);
      Frame3D(0,3,2+Xctr,Where.Width()-2,2+Xctr+Lctr-1);
    }
  }
}

void TLift::SizeChanged(void)
{ int L;
  float LView=ViewP2-ViewP1+1;
  float LReal=RealP2-RealP1+1;
  if (LView>=LReal)
  { // Les boutons sont invisibles et inactifs
         Inc->ClearStatus(sfVisible);
         Inc->SetStatus(sfDisabled);
         Dec->ClearStatus(sfVisible);
         Dec->SetStatus(sfDisabled);
    // On est forcment cal  gauche
    ViewP2+=RealP1-ViewP1;
    ViewP1+=RealP1-ViewP1;
         // Positionne Lctr
         Lctr=-1;
         // Demande le raffichage total
    CalculateClip();
         Invalidate();
  }
  else
  { // Les boutons sont visibles
    if (!Inc->GetStatus(sfVisible))
    { Inc->SetStatus(sfVisible);
      Inc->ClearStatus(sfDisabled);
      Dec->SetStatus(sfVisible);
      Dec->ClearStatus(sfDisabled);
      CalculateClip();
      Invalidate();
    }
    // Vrifie qu'on reste dans le cadre
    if (ViewP2>RealP2)
    { ViewP1+=RealP2-ViewP2;
      ViewP2+=RealP2-ViewP2;
    }
         // Calcule la taille/position du curseur
         if (Horizontal) L=Where.Width()-31; else L=Where.Height()-31;
         Lctr=(int)(LView/LReal*L);
         if (Lctr<30) Lctr=30;
         Xctr=(int)(1.*(L-Lctr)*(ViewP1-RealP1)/((RealP2-RealP1)-(ViewP2-ViewP1)));
         // Demande le raffichage du curseur
         if (Horizontal) Invalidate(2,3,Where.Width()-30,Where.Height()-2);
                                        else Invalidate(3,2,Where.Width()-2,Where.Height()-30);
  }
  // Envoie le message appropri  l'objet associ
  if (Horizontal) SetCommand(cmLiftHorizMoved,(void*)Connected);
             else SetCommand(cmLiftVertMoved,(void*)Connected);
}

boolean TLift::doLiftInc(void)
{ int NewP1, NewP2;
  if (CurrentEvent.InfoPtr==this)
  { NewP1=ViewP1+Step;
    NewP2=ViewP2+Step;
    if (NewP2>RealP2)
    { NewP1-=(NewP2-RealP2);
           NewP2-=(NewP2-RealP2);
    }
    if ((NewP1!=ViewP1)||(NewP2!=ViewP2))
    { ViewP1=NewP1;
      ViewP2=NewP2;
      SizeChanged();
    }
    return TRUE;
  }
  return FALSE;
}

boolean TLift::doLiftDec(void)
{ int NewP1, NewP2;
  if (CurrentEvent.InfoPtr==this)
  { NewP1=ViewP1-Step;
    NewP2=ViewP2-Step;
    if (NewP1<RealP1)
    { NewP2+=(RealP1-NewP1);
      NewP1+=(RealP1-NewP1);
    }
    if ((NewP1!=ViewP1)||(NewP2!=ViewP2))
    { ViewP1=NewP1;
      ViewP2=NewP2;
      SizeChanged();
    }
    return TRUE;
  }
  return FALSE;
}

boolean TLift::MouseLDown(TPoint W, int )
{ if (GetStatus(sfMouseIn))
    if (Lctr!=-1)
    { TPoint Pt;
      int P,L,Z;
      // Calcul des positions en fonction du sens Horz/Vert
      MakeLocal(W,Pt);
      Pt-=Where.P1();
      if (Horizontal)
      { P=Pt.X();
        L=Where.Width()-28;
      }
      else
      { P=Pt.Y();
        L=Where.Height()-28;
      }
      // Calcul de la zone de clic
      if (P<2+Xctr) Z=0;
      else
        if (P<=2+Xctr+Lctr-1) Z=1;
        else
          if (P<=L) Z=2;
          else Z=3;
      // Action
      switch(Z)
      { case 0: PageDec();   break;
        case 1: PageMove(W); break;
        case 2: PageInc();   break;
      }
      return TRUE;
    }
  return FALSE;
}

boolean TLift::KeyDown(int ScanCode, int Toggle)
{ if (TZone::KeyDown(ScanCode,Toggle)) return TRUE;
  if (GetToggleStatus() & tgShift)
  { if (ScanCode==ScanPageInc)
    { PageInc();
      return TRUE;
    }
    if (ScanCode==ScanPageDec)
    { PageDec();
      return TRUE;
    }
  }
  return FALSE;
}

void TLift::PageInc(void)
{ int PageStep=ViewP2-ViewP1+1;
  int NewP1=ViewP1+PageStep;
  int NewP2=ViewP2+PageStep;
  if (NewP2>RealP2)
  { NewP1-=(NewP2-RealP2);
    NewP2-=(NewP2-RealP2);
  }
  if ((NewP1!=ViewP1)||(NewP2!=ViewP2))
  { ViewP1=NewP1;
    ViewP2=NewP2;
    SizeChanged();
  }
}

void TLift::PageDec(void)
{ int PageStep=ViewP2-ViewP1+1;
  int NewP1=ViewP1-PageStep;
  int NewP2=ViewP2-PageStep;
  if (NewP1<RealP1)
  { NewP2+=(RealP1-NewP1);
    NewP1+=(RealP1-NewP1);
  }
  if ((NewP1!=ViewP1)||(NewP2!=ViewP2))
  { ViewP1=NewP1;
    ViewP2=NewP2;
    SizeChanged();
  }
}

void TLift::PageMove(TPoint dW)
{ TEvent Event;
  // Calcule la position de dpart du rectangle
  int X1,Y1,X2,Y2,L;
  if (Horizontal)
  { X1=2+Xctr;
    Y1=3;
    X2=2+Xctr+Lctr-1;
    Y2=Where.Height()-2;
    L=Where.Width()-31;
  }
  else
  { X1=3;
    Y1=2+Xctr;
    X2=Where.Width()-2;
    Y2=2+Xctr+Lctr-1;
    L=Where.Height()-31;
  }
  // Enfonce le bouton
  Frame3D(1,X1,Y1,X2,Y2);
  // Dplacement de l'ombre
  ChangeMouseAspect(MouseCursorHand);
  GrMouseSetCursorMode(GR_M_CUR_BOX, X1-dW.X()+Corner.X(),  Y1-dW.Y()+Corner.Y(),
                                     X2-dW.X()+Corner.X(),  Y2-dW.Y()+Corner.Y(),
                                                                                                 NoSysColor[White]);
  if (Horizontal) GrMouseSetLimits(dW.X()-(2+Xctr)+2,dW.Y(),dW.X()-(2+Xctr)+L-Lctr+2,dW.Y());
             else GrMouseSetLimits(dW.X(),dW.Y()-(2+Xctr)+2,dW.X(),dW.Y()-(2+Xctr)+L-Lctr+2);
  do
  { GetEvent(&Event);
  } while(Event.What!=evMouseLUp);
  GrMouseSetLimits(0,0,GrMaxX(),GrMaxY());
  GrMouseSetCursorMode(GR_M_CUR_NORMAL);
  RestoreMouseAspect();
  // Calcule la nouvelle Position
  int NewXctr;
  if (Horizontal) NewXctr=Xctr+Event.Where.X()-dW.X();
             else NewXctr=Xctr+Event.Where.Y()-dW.Y();
  int NewViewP1=(int)(1.*((RealP2-RealP1)-(ViewP2-ViewP1))*NewXctr/(L-Lctr)+RealP1);
  if (NewViewP1!=ViewP1)
  { ViewP2+=NewViewP1-ViewP1;
    ViewP1+=NewViewP1-ViewP1;
    SizeChanged();
  }
  else
  { // Relve le bouton
    Frame3D(0,X1,Y1,X2,Y2);
  }
}
