/* --------------------------------------------------------------------------
	Project S.W.O.R.D
	V2.10

	SubSystem : Image manipulation ToolBox
	File      : Include/ToolBox/Image/ImgView.H
	Author    : Eric NICOLAS
	Overview  : TImageScroller, TImageViewer Object : Voir des images
	UpDate    : Mar 20, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _TOOLBOX_IMAGE_IMGVIEW_H_
#define _TOOLBOX_IMAGE_IMGVIEW_H_

class TImageScroller;
class TImageViewer;

// --- TImageScroller Object

extern short RegTImageScroller;
extern char *IdentTImageScroller;

class TImageScroller : public TScroller
{ DECLARE(TImageScroller);
  // --- Datas
  protected:
    TScreenBitmap *Image;
  // --- Functions
  public:
  // Public constructors
          TImageScroller(void);
          TImageScroller(int X, int Y, int L, int H, TScreenBitmap *_Image,
                         TLift *HLift, TLift *VLift);
          TImageScroller(TRect R, TScreenBitmap *_Image, TLift *HLift, TLift *VLift);
  // Construction / Destruction
          void     Defaults(void);
          void     Init(int X, int Y, int L, int H, TScreenBitmap *_Image,
                        TLift *HLift, TLift *VLift);
  // Drawing Funcs
  virtual void     Draw(TRect Clip);
};

// --- TImageViewer Object

extern short RegTImageViewer;
extern char *IdentTImageViewer;

class TImageViewer : public TStdWindow
{ DECLARE(TImageViewer);
  // --- Datas
  protected:
    TScreenBitmap *Image;
  // --- Functions
  public:
  // Public constructors
          TImageViewer(void);
          TImageViewer(int X, int Y, int L, int H, char *Title, TScreenBitmap *_Image);
          TImageViewer(TRect R, char *Title, TScreenBitmap *_Image);
  // Construction / Destruction
          void     Defaults(void);
          void     Init(int X, int Y, int L, int H, char *Title, TScreenBitmap *_Image);
          void     Done(void);
  // Image scroller creation Hook
  virtual TImageScroller *CreateImageScroller(TRect R, TScreenBitmap *_Image, TLift *HLift, TLift *VLift);
};

#endif // _TOOLBOX_IMAGE_IMGVIEW_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.10:
**   21/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   02/03/96 :EN: Moving from struct to class. Adding Defaults() method
**   20/03/96 :EN: Adding hook for image scroller creation
** ------------------------------------------------------------------------*/
