/* --------------------------------------------------------------------------
        Project S.W.O.R.D
        V2.10

        SubSystem : Screen graphics management
        File      : Include/Graphics/Colors.H
        Author    : Eric NICOLAS
        Overview  : Managing of colors, dithering
        UpDate    : Apr 03, 1996

** Copyright (C) 1993-1996 The SWORD Group
**
** This file is distributed under the terms listed in the document
** "copying.en". A copy of "copying.en" should accompany this file.
** if not, a copy should be available from where this file was obtained.
** This file may not be distributed without a verbatim copy of "copying.en".
**
** This file is distributed WITHOUT ANY WARRANTY; without even the implied
** warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** ------------------------------------------------------------------------*/

#ifndef _GRAPHICS_COLORS_H_
#define _GRAPHICS_COLORS_H_

// ----- Defines

#define colMODE_16        0
#define colMODE_256       1
#define colMODE_TrueColor 2

#define Black             0
#define DarkGray          1
#define FaceGray          2
#define LightGray         3
#define White             4
#define NoColor           GrNOCOLOR

// ----- Color type

/*#ifdef _GRX20_
  typedef long TColor;
#else
  typedef int  TColor;
#endif*/

typedef unsigned int TColor;


// ----- Object for dithering

class TDither
{ public:
    // Constructor / Destructor
            TDither();
    virtual ~TDither();
    // Usefull method
    virtual TColor GetRGBColor(int X, int Y, int R, int G, int B);
};

// ----- Variables

extern int      ColorMode;
extern TColor   NoSysColor[5];
extern TDither *Dither;

// ----- Functions

void InitColors(void);
void DoneColors(void);

boolean SetSystemColors(void);
void    SetDitherColors(void);

// ChangeSystemColor : Change one of the 3 user-modifiables colors
//   n=0 : Change "dark gray" color
//   n=1 : Change "medium gray" color
//   n=2 : Change "light gray" color
//   r,g,b : color definitions, each value between 0 and 255
// return TRUE if the screen has to be redrawn
boolean ChangeSystemColor(int n, int r, int g, int b);

// RGB2HSV & HSV2RGB : Color space conversion between RGB (red, green, blue)
// and HSV (hue, saturation, value). All values are between 0 and 255
void RGB2HSV(byte r, byte g, byte b, byte& h, byte& s, byte& v);
void HSV2RGB(byte h, byte s, byte v, byte& r, byte& g, byte& b);

// RGB2CYM & CYM2RGB : Color space conversion between RGB (red, green, blue)
// and CYM (cyan, yellow, magenta). All values are between 0 and 255
void RGB2CYM(byte r, byte g, byte b, byte& c, byte& y, byte& m);
void CYM2RGB(byte c, byte y, byte m, byte& r, byte& g, byte& b);

// RGB2CYMK & CYMK2RGB : Color space conversion between RGB (red, green, blue)
// and CYMK (cyan, yellow, magenta, black). All values are between 0 and 255
void RGB2CYMK(byte r, byte g, byte b, byte& c, byte& y, byte& m, byte& k);
void CYMK2RGB(byte c, byte y, byte m, byte k, byte& r, byte& g, byte& b);

#endif // _GRAPHICS_COLORS_H_

/* --------------------------------------------------------------------------
** HISTORY
** --------------------------------------------------------------------------
** 2.11:
**   20/02/96 :EN: First History remark. Copying code V2.00->V2.10
**   22/02/96 :EN: Declaring Palette as global var (was local to color.cc)
**   29/02/96 :EN: Moving from struct to class
**   03/03/96 :EN: Changing color scheme so that it can be user-modified
**   02/04/96 :EN: Adding functions to change system colors at run-time
**   03/04/96 :EN: Adding functions for color space conversions
**   09/08/05 :EN: Fix for compiling with latest DJGPP/g++
** ------------------------------------------------------------------------*/
