@ECHO OFF
CLS

REM  This is the OpenGEM main startup file.  It's not as difficult to use
REM  as it may appear, so take some time to read through it.  There are 
REM  options to enable/disable sound in OpenGEM, and to start/remove a 
REM  mouse driver for OpenGEM.  This is the key file for doing all those
REM  things that we cannot automate yet.
REM
REM  Comments or suggestions about this file to gem@shaneland.co.uk please.
REM  Help us make OpenGEM (and FreeGEM) better!
CLS

:DOSTYPE
@ECHO off
@IF "CDOS"=="%OS%" SUSPEND=ON
@IF "CDOS386"=="%OS%" SUSPEND=ON
@IF "CPCDOS"=="%OS%" SUSPEND=ON
@IF "DRMDOS"=="%OS%" SUSPEND=ON
@IF "MDOS"=="%OS%" SUSPEND=ON
@IF "SMDOS"=="%OS%" SUSPEND=ON
@IF "REAL32"=="%OS%" SUSPEND=ON
REM I'm not sure which ID strings were used by Datapac Multiuser DOS
REM and IMS Multiuser DOS, so a few more ID strings are possible here.

:CHANGE-DIRECTORY
CD\GEMAPPS\GEMSYS
BANNER

:LOAD-SOUND
REM Load sound driver
REM To start the sound driver remove the REM command on the two lines below
REM SOUND 
REM SET SOUND=ON

:LOAD-MIDI
REM Load MIDI driver 
REM To start the midi driver remove the REM command on the line below
REM OPL2 

:SET-MOUSE
REM To start the mouse driver remove the REM command on all the lines in this block apart from this one
MEM /M WIN | FIND "K"
IF ERRORLEVEL 1 GOTO NEVER
MEM /M VMM32 | FIND "K"
IF ERRORLEVEL 1 GOTO DOSMODE
GOTO DOSWIN
:NEVER
CTMOUSE
GOTO DONE
:DOSWIN
GOTO DONE
:DOSMODE
CTMOUSE
GOTO DONE
:DONE

:LOAD-GEM
CD\GEMAPPS\GEMSYS
ECHO OFF
REM Load GEM
GEMVDI %1 %2 %3 -LHGEM.EXE
CLS

:CLOSE-MIDI
ECHO OFF
REM Remove MIDI driver
REM To stop the midi driver when OpenGEM shuts down remove the REM command on the line below
REM OPL2 /U 
CLS

:SHUTDOWN
CLS
ECHO OFF
ECHO               **************************************************
ECHO               *                                                *
ECHO               * What would you like to do now?                 *
ECHO               *                                                *
ECHO               * 1 - Restart OpenGEM                            *
ECHO               *                                                *
ECHO               * 2 - Return to DOS                              *
ECHO               *                                                *
ECHO               * 3 - Reboot the computer                        *
ECHO               *                                                *
ECHO               * 4 - Shutdown the computer                      *
ECHO               *     (This only works on ATX computers)         *
ECHO               *                                                *
ECHO               *                                                *
ECHO               *                                                *
ECHO               * 5 - Help                                       *
ECHO               *                                                *
ECHO               **************************************************
ECHO.
ECHO                           Please select an option...
CD\GEMAPPS\GEMSYS\CHOICE
choice /c:12345
if errorlevel 5 goto HELP
if errorlevel 4 goto 4
if errorlevel 3 goto 3
if errorlevel 2 goto 2
if errorlevel 1 goto 1
:1
CLS
ECHO OFF
GOTO DOSTYPE
:2
CLS
ECHO OFF
GOTO END
:3
CLS
ECHO OFF
CD\GEMAPPS\GEMSYS
SHUTDOWN R
GOTO END
:4
CLS
ECHO OFF
CD\GEMAPPS\GEMSYS
SHUTDOWN S
GOTO END

:HELP
CLS
ECHO OFF
ECHO               **************************************************
ECHO               *                                                *
ECHO               * OpenGEM has several options when you exit the  *
ECHO               * graphical user interface.                      *
ECHO               *                                                *
ECHO               * You can restart OpenGEM.  This is something    *
ECHO               * that you may want to do if the computer is     *
ECHO               * slow or you have changed the configuration.    *
ECHO               *                                                *
ECHO               * You can return to the DOS command prompt, and  *
ECHO               * leave OpenGEM altogether.                      *
ECHO               *                                                *
ECHO               * You can reboot the computer.  This can resolve *
ECHO               * many issues with program slowness and crashes. *
ECHO               *                                                *
ECHO               * You can shutdown your computer entirely.  This *
ECHO               * option only works with ATX computers, as it    *
ECHO               * requires their power management tools.         *
ECHO               *                                                *
ECHO               **************************************************
ECHO.
PAUSE
GOTO SHUTDOWN

:END
CLS
ECHO OFF
CD\
ECHO               **************************************************
ECHO               *          Thank you for using OpenGEM           *
ECHO               *                                                *
ECHO               *       Copyright (c) 2001-2004 Shane Land       *
ECHO               *           http://gem.shaneland.co.uk           *
ECHO               **************************************************
ECHO.
