#ifdef USE_LFN
/* $RCSfile: WIN95API.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int invokeWin95(int fct, struct REGPACK *rp)

	Invoke Win95/DOS function fct. It assumes that both APIs are the
	same except for the function number itself.

	*rp will hold the values of the successful call (either Win95
	or DOS).

	Return:
		0: success
		else: failure

   $Log: WIN95API.C $
   Revision 1.2  2000/01/11 09:34:42  ska
   add: support Turbo C v2.01

   Revision 1.1  2000/01/11 09:10:09  ska
   Auto Check-in

*/

#include <assert.h>
#include <dos.h>
#include <string.h>
#include <errno.h>
#include "io95.h"
#include "io95_loc.h"

#if defined(__WATCOMC__)
#define DOSREGPACK union REGPACK
#define r_ds w.ds
#define r_dx w.dx
#define r_ax w.ax
#define r_es w.es
#define r_bx w.bx
#define r_cx w.cx
#define r_si w.si
#define r_di w.di
#define r_flags w.flags
#elif defined(__PACIFIC__)
#define DOSREGPACK union REGPACK
#define r_ds x.ds
#define r_dx x.dx
#define r_ax x.ax
#define r_es x.es
#define r_bx x.bx
#define r_cx x.cx
#define r_si x.si
#define r_di x.di
#define r_flags x.flags
#else
#define DOSREGPACK struct REGPACK
#endif

/*#ifndef lint
static char const rcsid[] = 
	"$Id: WIN95API.C 1.2 2000/01/11 09:34:42 ska Exp ska $";
#endif*/

int callDosandWin95(int winfct, int dosfct, union REGS *rp, struct SREGS *sp)
{
	union REGS r;
	assert(rp);
	assert(sp);
	memcpy(&r, rp, sizeof(r));
	rp->x.ax = winfct;
	intdosx(rp, rp, sp);
	if((rp->x.cflag & 1) && (rp->x.ax == 1 || rp->x.ax == 0x7100)) {
		/* try DOS API */
		r.x.ax = dosfct;
		memcpy(rp, &r, sizeof(r));
		intdosx(rp, rp, sp);
	}
	return (rp->x.cflag & 1) ? (errno = rp->x.ax) : 0;
}

int callWin95(int fct, DOSREGPACK * const rp)
{	DOSREGPACK r;			/* temporary stack for the registers */

	assert(rp);
	rp->r_flags = 1;				/* asure that the carry is set */
	memcpy(&r, rp, sizeof(r));
	rp->r_ax = 0x7100 | fct;
	intr(0x21, rp);				/* call Win95 API */
	if((rp->r_flags & 1) && (rp->r_ax == 1 || rp->r_ax == 0x7100)) {
		/* try DOS API */
		r.r_ax = fct << 8;
		memcpy(rp, &r, sizeof(r));
		intr(0x21, rp);		/* call DOS API */
	}
	return (rp->r_flags & 1) ? (errno = rp->r_ax) : 0;/* keep eror code */
}
#endif
