{**********************************************************************
Copyright (C) 2009 by Salvatore Licciardi

Web http://www.webalice.it/turylicciardi    eMail turylicciardi@tiscali.it

 This program is free software: you can redistribute it and/or modify it under
 the terms of the GNU General Public License as published by the Free Software
 Foundation, version 3 of the License.
 This program is distributed in the hope  that it will be useful , but WITHOUT
 ANY WARRANTY without even the implied warranty  of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details. You should have received
 a copy of the GNU General Public License along with this program. If not, see
 http://www.gnu.org/licenses/

 **********************************************************************}

{ this unit is for FreePascal 1.0.x / BP7
  this unit is for Go32v2 (DOS) target

  written by: Salvatore Licciardi
  WWW page  : web.tiscali.it/licciardi
  E-Mail    : turylicciardi@tiscali.it
  this file : www.webalice.it/turylicciardi/prog/mclick.zip
              (MClick.pas, Click_.pas, Example.pas)
  version   : 1.0.4  2004/11/04
}

unit MClick;
{$ifdef FPC}
 {$MODE ObjFpc}
{$endif}
{$ifdef BP7}
 {$define Go32v2}
{$endif}

interface
uses  {$ifdef FPC}
       {$ifdef Go32v2}
       MsMouse,
       {$else}
       Mouse,
       {$endif}
      {$endif}
      Dos,Click_;

{ Key:  0: None, 1:Left,  2: Right,  bx=3: Center }
type More_Click=Object
               public
                constructor  Init;
                function  DoubleClick:boolean;
                function  Get_First_X:word;
                function  Get_First_Y:word;
                function  Get_Last_X:word;
                function  Get_Last_Y:word;
                function  Get_First_Button:char;
                function  Get_Last_Button:char;
                function  Get_Delay_Click:word;
                function  Mouse_Down_Central(var mox,moy,key:byte):boolean;
                function  Mouse_Down_R(var mox,moy,key:byte):boolean;
                function  Mouse_Down_L(var mox,moy,key:byte):boolean;
                function  Mouse_Up_R(var mox,moy,key:byte):boolean;
                function  Mouse_Up_L(var mox,moy,key:byte):boolean;
                function  Get_Last_Double_Button:char;
                procedure Set_Delay_Click(delay:word);
                procedure Empty_Mouse;

               private
                Last_Double_Button:char;
                time_mouse: array [1..3] of time_click;  { Down,Up,Down }
                capture_x,capture_y: byte;
                delay_click:word;
                procedure Capture_Time(button,direction:char);
               end;

function Time100:longint;

implementation

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function Time100:longint;
var h,m,s,cs:word;
begin
GetTime(h,m,s,cs);
Time100:=(h*60*60+m*60+s)*100+cs;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function   More_Click.Get_Delay_Click:word;
begin
Get_Delay_Click:=delay_click;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure  More_Click.Set_Delay_Click(delay:word);
begin
delay_click:=delay;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

constructor  More_Click.init;
begin
delay_click:=20;
Empty_Mouse;
{$ifdef FPC}
 {$ifdef Go32v2}
 if not mousefound then       { MouseFound solo per Go32v2 }
                   InitMouse; { fa parte dell' IFDEF }
 {$endif}
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure More_Click.Empty_Mouse;
var i:byte;
begin
for i:=1 to 3 do
    begin
    time_mouse[i].x:=255;
    time_mouse[i].y:=255;
    time_mouse[i].direction:=char(i);
    time_mouse[i].button:=char(i);
    time_mouse[i].t:=-10000+i*1000;
    end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function More_Click.Get_Last_Double_Button:char;
begin
Get_Last_Double_Button:=Last_Double_Button;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function More_Click.DoubleClick:boolean;
begin
DoubleClick:=false;
Last_Double_Button:=' ';
if time_mouse[1].x<>time_mouse[3].x then Exit;
if time_mouse[1].y<>time_mouse[3].y then Exit;
if time_mouse[1].button<>time_mouse[2].button then Exit;
if (time_mouse[1].direction='D')and(time_mouse[2].direction='U')and
   (time_mouse[3].direction='D')and
   (time_mouse[1].button=time_mouse[2].button)and
   (time_mouse[2].button=time_mouse[3].button)and
   (abs(time_mouse[3].t-time_mouse[1].t)<delay_click) then
         begin
         Last_Double_Button:=time_mouse[1].button;
         DoubleClick:=true;
         end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  More_Click.Get_First_X:word;
begin
Get_First_X:=time_mouse[1].x;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  More_Click.Get_First_Y:word;
begin
Get_First_Y:=time_mouse[1].Y;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  More_Click.Get_Last_X:word;
begin
Get_Last_X:=time_mouse[3].x;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  More_Click.Get_Last_Y:word;
begin
Get_Last_Y:=time_mouse[3].y;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  More_Click.Get_Last_Button:char;
begin
Get_Last_Button:=time_mouse[3].button;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  More_Click.Get_First_Button:char;
begin
Get_First_Button:=time_mouse[1].button;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

procedure More_Click.Capture_Time(button,direction:char);
begin
if (direction<>time_mouse[3].direction)or(button<>time_mouse[3].button) then
       begin
       time_mouse[1]:=time_mouse[2];
       time_mouse[2]:=time_mouse[3];
       time_mouse[3].button:=button;
       time_mouse[3].direction:=direction;
       time_mouse[3].x:=capture_x;
       time_mouse[3].y:=capture_y;
       time_mouse[3].t:=time100;
       end
      else
       begin
       time_mouse[3].button:=button;
       time_mouse[3].x:=capture_x;
       time_mouse[3].y:=capture_y;
       time_mouse[3].t:=time100;
       end;
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  More_Click.Mouse_Down_R(var mox,moy,key:byte):boolean;
{$ifdef go32v2}
var reg:registers;
begin
reg.ax:=3;
intr($33,reg);
mox:=(reg.cx div 8) +1;
moy:=(reg.dx div 8) +1;
key:=reg.bx;      { bx=0: None, bx=1: L,  bx=2: R,  bx=3: C }
if key=2 then
           begin
           capture_x:=mox;
           capture_y:=moy;
           end
          else
           begin
           Mouse_Down_R:=false;
           Exit;
           end;
Mouse_Down_R:=(key=2);
if key=2 then Capture_Time('R','D');
{$else}
begin
mox:=0;
moy:=0;
key:=0;
exit(false);
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  More_Click.Mouse_Down_L(var mox,moy,key:byte):boolean;
{$ifdef go32v2}
var reg:registers;
begin
reg.ax:=3;
intr($33,reg);
mox:=(reg.cx div 8) +1;
moy:=(reg.dx div 8) +1;
key:=reg.bx;      { bx=0: None, bx=1: L,  bx=2: R,  bx=3: C }
if key=1 then
           begin
           capture_x:=mox;
           capture_y:=moy;
           end
          else
           begin
           Mouse_Down_L:=false;
           Exit;
           end;
Mouse_Down_L:=(key=1);
if key=1 then Capture_Time('L','D');
{$else}
begin
mox:=0;
moy:=0;
key:=0;
exit(false);
{$endif}
end;


{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  More_Click.Mouse_Down_Central(var mox,moy,key:byte):boolean;
{$ifdef go32v2}
var reg:registers;
begin
reg.ax:=3;
intr($33,reg);
mox:=(reg.cx div 8) +1;
moy:=(reg.dx div 8) +1;
key:=reg.bx;      { bx=0: None, bx=1: L,  bx=2: R,  bx=3: C }
if key=3 then
           begin
           capture_x:=mox;
           capture_y:=moy;
           end
          else
           begin
           Mouse_Down_Central:=false;
           Exit;
           end;
Mouse_Down_Central:=(key=3);
if key=3 then Capture_Time('C','D');
{$else}
begin
mox:=0;
moy:=0;
key:=0;
exit(false);
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  More_Click.Mouse_Up_L(var mox,moy,key:byte):boolean;
{$ifdef go32v2}
var reg:registers;
begin
reg.bx:=0;     { bx=0: L,  bx=1: R }
reg.ax:=6;
intr($33,reg);
mox:=reg.cx div 8 +1;
moy:=reg.dx div 8 +1;
key:=reg.bx;
if key=1 then Capture_Time('L','U');
Mouse_Up_L:=(key=1);
{$else}
begin
mox:=0;
moy:=0;
key:=0;
exit(false);
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

function  More_Click.Mouse_Up_R(var mox,moy,key:byte):boolean;
{$ifdef go32v2}
var reg:registers;
begin
reg.bx:=1;     { bx=0: L,  bx=1: R }
reg.ax:=6;
intr($33,reg);
moy:=reg.dx div 8 +1;
mox:=reg.cx div 8 +1;
key:=reg.bx;
if key=1 then Capture_Time('R','U');
Mouse_Up_R:=(key=1);
{$else}
begin
mox:=0;
moy:=0;
key:=0;
exit(false);
{$endif}
end;

{+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++}

begin
end.
