;
;   Copyright (C) 1999  James B Tabor
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;
TITLE           API28.ASM
;
;
;   Purpose:    This program enables other tasks to run before a DOS
;               function. This program uses an unused Interrupt 2CH as a
;               Interrupt API. This API can be used with pop-up's TSR
;               type program. It is also intended for fast loop tasks
;               ie.( quick monitor status programs, Network background
;               read/write functions.), allowing those tasks to run. Looks
;               like some kind of hack ware, but it works.
;
;   Created:    03-OCT-1992             James B. Tabor
;
;   Modified:   10-JUN-1999             James B. Tabor
;
;               Give FreeDos a Int 28h API. Was Int 2Ch now 28h. Changed
;               the Int 2F return code. Linux quiz, where is the Deadbeef?
;               Added support code for keyboard functions. Tring to stay
;               away from rewriting the CON device driver.
;
;   Comments:
;               At this point, FreeDOS is very BUGGY! If you want to test
;               this program with FreeDOS, be very careful.
;
; API:
;               AX = 0          Keyboard mode.
;               AX = 8000H      Dos mode.
;
;               INT 28H
;
;
; Stack size can be as large as you want.
;
STACK_SIZE      EQU     1024
FILDES          EQU     128         ; change this too.
;
HANDLE          EQU     0
COUNT           EQU     2
HTYPE           EQU     3

CODE            SEGMENT
                ASSUME  CS:CODE,DS:CODE
                ORG     100H
START:          JMP     FIRST
;
INT08IP         DW      0
INT08CP         DW      0
INT10IP         DW      0
INT10CP         DW      0
INT13IP         DW      0
INT13CP         DW      0
INT21IP         DW      0
INT21CP         DW      0
INT25IP         DW      0
INT25CP         DW      0
INT26IP         DW      0
INT26CP         DW      0
INT2FIP         DW      0
INT2FCP         DW      0
;
;
IN_DOSIP        DW      0
IN_DOSCP        DW      0
;
;
IN_FLAG         DB      0
IN_API          DB      0FFH
;
;
;  FLAGS USED IN IN_INTCO ARE:
;                               INT10 = 1
;                               INT13 = 2H
;                               INT14 = 4H
;                               INT16 = 8H
;                               INT17 = 10H
;                               INT25 = 20H
;                               INT26 = 40H
;                               INT29 = 80H
;
IN_INTCO        DB      0
;
; 0 = CON, STDIN
; 1 = CON, STDOUT
; 2 = CON, STDERR
; 3 = AUX, STDAUX COM1
; 4 = PRN, STDPRN LPT1
; 5 = starting file handle
;
;   [ HANDLE ] 16 HANDLE NUM
;   [ COUNT  ]  8 NUMBER OF FILES OPENED ON IT <NOT USED>
;   [ HTYPE  ]  8 AUX 1, COM 2, CON 3
;
                db      'lovehate'
FILE_HANDLE     DD      FILDES DUP(0)
;
; Can be used to redirect PRN and LPTx too.
;
DEVICE_NAME     DB      'AUX','COM','CON'
                DB      'aux','com','con'
;
;
NEW_S_SEG       DW      0
SAVE_SS         DW      0
SAVE_SP         DW      0
SAVE_PTR        DW      0
SAVE_CX         DW      0
SAVE_DX         DW      0
SAVE_AX         DW      0
SAVE_R_AX       DW      0
DOS_AX          DW      0
;
;   Remember the DS segment came from somewhere else.
;
;
INT_21:
                PUSHF                           ; MS_Dos 5.00 bug
                CALL    BEGIN_CRIT              ; START CRIT SECTION.
                CMP     CS: BYTE PTR IN_API,0
                JNZ     EXIT_21

                MOV     CS: WORD PTR DOS_AX,AX

                CMP     AH,4BH                  ; SKIP EXEC FUNCTION.
                JZ      EXIT_21

                CMP     AH,0CH
                JBE     DOS_CHAR

                CMP     AH,3EH
                JNE     INT_21_A
                CALL    CLOSE_DEVICE
                JMP     INT_21_E
INT_21_A:
                CMP     AH,3FH
                JNE     INT_21_1
                JMP     DO_READ
INT_21_1:
                CMP     AH,40H
                JNE     INT_21_2
                CMP     CX,512
                JBE     INT_21_E        ; DONT BOTHER
                JMP     DO_WRITE
INT_21_2:
                CMP     AH,3DH
                JNE     INT_21_3
                JMP     DO_OPEN
INT_21_3:
                CMP     AH,6CH
                JNE     INT_21_E
                JMP     DO_EXOPEN
INT_21_E:
                CALL    API_H
EXIT_21:
                CALL    END_CRIT                ; END API CRIT SEC, START DOS
                CLI                             ; CRIT SECTION ...
                POPF
                JMP     CS:DWORD PTR [INT21IP]  ; HOOK TO DOS.


DOS_FUNC_WAIT_CON:
                CALL    WAIT_CON_LOOP_SAFE
                JMP     EXIT_21
;
;
DOS_0B:
                CALL    API         ; CON SAFE
                JMP     EXIT_21
;
;
DOS_0C:
                CMP     AL,0
                JE      INT_21_E
                CMP     AL,6
                JE      INT_21_E
                PUSH    AX
                MOV     AX,0C00H
                CALL    DO_DOS      ; FLUSH BUFFER AND RETURN
                POP     AX
                MOV     AH,AL       ; CHANGE AL TO AH AND DO FUNCTION
;
DOS_CHAR:
                CMP     AH,0BH
                JE      DOS_0B
                CMP     AH,0CH
                JE      DOS_0C
                CMP     AH,01H
                JE      DOS_FUNC_WAIT_CON
                CMP     AH,03H
                JE      DOS_FUNC_3
                CMP     AH,07H
                JE      DOS_FUNC_WAIT_CON
                CMP     AH,08H
                JE      DOS_FUNC_WAIT_CON
                CMP     AH,0AH
                JNE     INT_21_E
DOS_0A:
                POPF
                CALL    DOS_0A_READ
DOS_EXIT:
                CALL    END_CRIT
                RETF    2
;
;   THIS IS A HACK AND NOT VERY GOOD.
;   I DONT KNOW IF ANYONE USES IT ANYWAY.
;
DOS_FUNC_3:
                PUSH    AX
                PUSH    DX
D_F_3_L:
                MOV     AH,6
                MOV     DL,0FFH
                CALL    DO_DOS
                JZ      D_F_3_1
                CMP     AL,03       ; DO Ctrl-C OUTSIDE.
                JE      D_F_3_E
D_F_3_1:
                CALL    API_H
                MOV     AH,3
                MOV     DX,0
                INT     14H
                MOV     DL,AH
                AND     AH,0EH      ; ERRORS
                JNZ     D_F_3_E
                MOV     AH,DL
                TEST    AH,1        ; RECEIVE DATA BIT SET
                JZ      D_F_3_L
D_F_3_E:
                POP     DX
                POP     AX
                JMP     EXIT_21
;
;
;
;
DOS_0A_READ:
                PUSH    BX
                PUSH    CX
                PUSH    DI
                PUSH    DX
                MOV     DI,DX
                MOV     BL,DS: BYTE PTR [DI]
                ADD     DI,2
                CALL    DO_0A_R_F
                MOV     DI,DX
                MOV     DS: BYTE PTR [DI]+1,CL
                POP     DX
                POP     DI
                POP     CX
                POP     BX
                CLC
                RET

DO_0A_R_F:      PUSH    DX
                MOV     CX,1
                CMP     BL,0
                JE      DOS_0A_EXIT
NEW_DOS_0A:
                CALL    WAIT_CON_LOOP_SAFE
                CALL    DOS_KEY_NOE

                CMP     CL,BL
                JB      DOS_0A_1
                CMP     AL,8
                JE      DOS_0A_BS
                CMP     AL,0DH
                JE      DOS_0A_EXIT_CR
                CMP     AL,27
                JE      DOS_0A_1
                CALL    DOS_BELL            ; BUFFER FULL RING BELL
                JMP     NEW_DOS_0A
DOS_0A_1:
                CMP     AL,8
                JE      DOS_0A_BS
                CMP     AL,6
                JE      NEW_DOS_0A
                CALL    DOS_ECHO
                CMP     AL,10
                JE      NEW_DOS_0A
                CMP     AL,27
                JE      NEW_DOS_0A
                MOV     DS: BYTE PTR [DI],AL
                CMP     AL,0DH
                JE      DOS_0A_EXIT
                INC     DI
                INC     CL
                JMP     NEW_DOS_0A
DOS_0A_BS:
                CMP     CL,1
                JZ      NEW_DOS_0A

                CALL    RUB_OUT_1

                MOV     AL,DS: BYTE PTR [DI]-1
                CMP     AL,9
                JE      DOS_0A_TAB
                CALL    GET_AN_SW
                CMP     AH,1
                JNE     DOS_0A_BS_1

                CALL    RUB_OUT
DOS_0A_BS_1:
                DEC     DI
                DEC     CL
                JMP     NEW_DOS_0A
DOS_0A_TAB:
                PUSH    CX
                MOV     CX,7
DOS_0A_T_L:
                MOV     AL,8
                CALL    DOS_PUTC
                LOOP    DOS_0A_T_L
                POP     CX
                JMP     DOS_0A_BS_1
DOS_0A_EXIT_CR:
                CALL    DOS_ECHO
DOS_0A_EXIT:
                DEC     CL
                POP     DX
                MOV     AX,0A0DH
                RET

;
;
;   BREAK UP LONG WRITES TO DISK, TTY, AND LPTX OR PRN.
;
;
DO_WRITE:
                POPF
                MOV     CS: SAVE_AX,AX
                MOV     CS: SAVE_R_AX,0
                MOV     CS: SAVE_CX,CX
                MOV     CS: SAVE_PTR,CX
                MOV     CS: SAVE_DX,DX
LOOP_40:
                CALL    API_H
                MOV     CX,CS: WORD PTR SAVE_PTR
                CMP     CX,512
                JBE     SKIPIT
                MOV     CX,512
SKIPIT:
                SUB     CS: WORD PTR SAVE_PTR,CX   ; NEW BLOCK SIZE.
                CLC
                CLI
                MOV     AX,CS: SAVE_AX
                CALL    DO_DOS
                JC      D_4_ERROR

                ADD     CS: WORD PTR SAVE_R_AX,AX
                ADD     DX,CX
                CMP     CS: WORD PTR SAVE_PTR,0
                JNZ     LOOP_40
D_4_GOOD_E:
                MOV     AX,CS: WORD PTR SAVE_R_AX
                CLC
D_4_ERROR:      PUSHF
                MOV     CX,CS: WORD PTR SAVE_CX     ; FOR ERRORS..
                MOV     DX,CS: WORD PTR SAVE_DX     ; RESTORE STUFF BACK.
DO_40_EXIT:
                CALL    END_CRIT                    ; END CRIT SECTION.
                POPF
                RETF    2
;
;
;   DOS READ FILE HANDLE
;
;
DO_READ:
                MOV     CS: SAVE_AX,AX
                CMP     BX,0
                JE      DO_READ_I
                CALL    GET_DEVICE
                CMP     AL,3
                JE      DO_READ_I
                MOV     AX,CS: SAVE_AX
                JMP     INT_21_E
DO_READ_I:      POPF
                MOV     CS: SAVE_R_AX,0
                MOV     CS: SAVE_CX,CX
                MOV     CS: SAVE_DX,DX
                PUSH    BX
                PUSH    DI
                PUSH    SI

                MOV     BL,80H
                MOV     DI,DX
                CALL    DO_0A_R_F

                MOV     DS: BYTE PTR [DI]+1,10
                MOV     CH,0
                ADD     CX,2
                ADD     CS: WORD PTR SAVE_R_AX,CX

                CALL    DOS_PUTC
                MOV     AL,10
                CALL    DOS_PUTC
                POP     SI
                POP     DI
                POP     BX
                JMP     D_4_GOOD_E
;
;   STD OPEN FILE
;
;
DO_OPEN:
                POPF
                CALL    DO_DOS
                JC      DO_EO_ER
                PUSHF
                PUSH    BX
                PUSH    DX
                PUSH    SI
                MOV     SI,DX
                CALL    SCAN
                CMP     BX,0
                JE      DO_OP_E
                CALL    SET_DEVICE
DO_OP_E:
                POP     SI
                POP     DX
                POP     BX
                POPF
                JMP     DO_EO_ER
;
;   EXTENDED OPEN/CREATE
;       RO & R/W
;
DO_EXOPEN:
                POPF
                CALL    DO_DOS
                JC      DO_EO_ER
                PUSHF
                PUSH    BX
                CALL    SCAN
                CMP     BX,0
                JE      DO_EO_E
                CALL    SET_DEVICE
DO_EO_E:
                POP     BX
                POPF
DO_EO_ER:       PUSHF
                JMP     DO_40_EXIT
;
;
;
SCAN:
                PUSH    CX
                PUSH    DX
                PUSH    DI
                PUSH    ES

                PUSH    CS
                POP     ES
                MOV     DI,OFFSET DEVICE_NAME
                MOV     CX,2
SCAN_L:
                MOV     BX,1
                CALL    SCAN_S
                JZ      SCAN_E
                ADD     DI,3
                MOV     BX,2
                CALL    SCAN_S
                JZ      SCAN_E
                ADD     DI,3
                MOV     BX,3
                CALL    SCAN_S
                JZ      SCAN_E
                ADD     DI,3
                LOOP    SCAN_L
                MOV     BX,0
SCAN_E:
                POP     ES
                POP     DI
                POP     DX
                POP     CX
                RET
SCAN_S:
                PUSH    DI
                PUSH    SI
                PUSH    CX
                MOV     CX,3
                REPZ    CMPSB
                POP     CX
                POP     SI
                POP     DI
                RET
;
; FIND THE SAME OR A HOLE
;
SET_DEVICE:
                PUSH    CX
                PUSH    DI
                MOV     CX,FILDES
                MOV     DI, OFFSET FILE_HANDLE
SET_D_L:
                CMP     CS: WORD PTR [DI],AX
                JE      SET_D_1
                CMP     CS: WORD PTR [DI],0
                JE      SET_D_1
                ADD     DI,4
                LOOP    SET_D_L
                JMP     SET_D_E
SET_D_1:
                MOV     CS: WORD PTR [DI],AX
                INC     CS: BYTE PTR [DI+COUNT]
                MOV     CS: BYTE PTR [DI+HTYPE],BL
SET_D_E:
                POP     DI
                POP     CX
                RET
;
GET_DEVICE:
                PUSH    CX
                PUSH    DI
                MOV     CX,FILDES
                MOV     DI, OFFSET FILE_HANDLE
                MOV     AX,0
GET_D_L:
                CMP     CS: WORD PTR [DI],BX
                JE      GET_D_1
                ADD     DI,4
                LOOP    GET_D_L
                JMP     GET_D_E
GET_D_1:
                MOV     AL,CS: BYTE PTR [DI+HTYPE]
GET_D_E:
                POP     DI
                POP     CX
                RET
;
CLOSE_DEVICE:
                PUSH    CX
                PUSH    DI
                MOV     CX,FILDES
                MOV     DI, OFFSET FILE_HANDLE
CLO_D_L:
                CMP     CS: WORD PTR [DI],BX
                JE      CLO_D_1
                ADD     DI,4
                LOOP    CLO_D_L
                JMP     CLO_D_E
CLO_D_1:
                DEC     CS: BYTE PTR [DI+COUNT]
                JNZ     CLO_D_E
                MOV     CS: WORD PTR [DI],0
CLO_D_E:
                POP     DI
                POP     CX
                RET
;
;
;   Keyboard stuff
;
;
WAIT_CON_LOOP_SAFE:
                PUSH    AX
WAIT_CON_L:
                CALL    API
                CALL    DOS_TEST_KEY
                CMP     AL,0FFH
                JNE     WAIT_CON_L
                POP     AX
                RET

DOS_TEST_KEY:
;                MOV     AH,0BH
;                CALL    DO_DOS
;                RET
;
                MOV     AX,0100H        ; TESTING FREEDOS
                INT     16H
                JZ      D_T_K_1
                MOV     AL,0FFH
                JMP     D_T_K_2
D_T_K_1:
                MOV     AL,0
D_T_K_2:
                RET

DOS_BELL:
                PUSH    AX
                PUSH    DX
                MOV     AH,02H
                MOV     DL,07H
                CALL    DO_DOS
                POP     DX
                POP     AX
                RET
DOS_KEY:
                MOV     AH,01H
                CALL    DO_DOS
                RET
DOS_KEY_NOE:
                MOV     AH,8H
                CALL    DO_DOS
                RET

RUB_OUT:
                MOV     AL,8
RUB_OUT_1:
                CALL    DOS_PUTC
                MOV     AL,20H      ; ERASE
                CALL    DOS_PUTC
                MOV     AL,8
                CALL    DOS_PUTC
                RET

DOS_PUTC:
                PUSH    AX
                PUSH    DX
                MOV     AH,02H
                MOV     DL,AL
                CALL    DO_DOS
                POP     DX
                POP     AX
                RET
DOS_ECHO:
                PUSH    AX
                PUSH    BX
                CALL    GET_AN
                CMP     BX,0
                JE      DOS_E_2
                MOV     AH, CS: BYTE PTR [BX]+2
                CMP     AH,2
                JE      DOS_E_E
                CMP     AH,0
                JE      DOS_E_2
                CMP     AH,4
                JE      DOS_E_1
                CMP     AH,1
                JNE     DOS_E_2
DOS_E_1:
                MOV     AL,CS: BYTE PTR [BX]
                CALL    DOS_PUTC

                MOV     AL,CS: BYTE PTR [BX]+1
                CMP     AH,4
                JNE     DOS_E_2
                CALL    DOS_PUTC
                MOV     CH,0
                CMP     CX,1
                JBE     DOS_E_L
                DEC     CX
                SUB     DI,CX
                INC     CX
DOS_E_L:
                MOV     AL,8
                CALL    DOS_PUTC
                LOOP    DOS_E_L
                MOV     CX,1
                JMP     DOS_E_E
DOS_E_2:
                CALL    DOS_PUTC
DOS_E_E:
                POP     BX
                POP     AX
                RET
GET_AN_SW:
                PUSH    BX
                MOV     AH,0
                CALL    GET_AN
                CMP     BX,0
                JE      GET_A_S_1
                MOV     AH,CS: BYTE PTR [BX]+2
GET_A_S_1:      POP     BX
                RET
GET_AN:
                PUSH    AX
                PUSH    CX
                MOV     BX,0
                CMP     AL,32
                JAE     GET_AN_1
                MOV     BX, OFFSET AN_LIST
                MOV     AH,0
                MOV     CX,3
                MUL     CX
                ADD     BX,AX
GET_AN_1:
                POP     CX
                POP     AX
                RET
;
;   If there is a reason to turn things on/off put it here,
;   after the 2Ah interrupt.
;
;
BEGIN_CRIT:
                PUSH    AX
                MOV     AX,8000H            ; BEGINNING OF UNINTERRUPTIBLE
                INT     2AH                 ; CODE.
                POP     AX
                RET
;
END_CRIT:
                PUSH    AX
                MOV     AX,8100H            ; END OF API CRITICAL SECTION.
                INT     2AH                 ; START OF DOS...
                POP     AX
                RET
;
; This is optional. I would keep it.
;
;
INT_08:
                CLI
                PUSHF
                CALL    CS:DWORD PTR [INT08IP] ; CHAIN TO ANOTHER PROG.
                CMP     CS: BYTE PTR IN_API,0
                JZ      NORM_INT8
                IRET
NORM_INT8:
                STI
                PUSH    DS
                PUSH    ES
                PUSH    BX
                CMP     CS: BYTE PTR IN_INTCO,0     ;COMBATION CHECK
                JNZ     NO_RUN
                LES     BX,CS:DWORD PTR [IN_DOSIP]
                CMP     ES: BYTE PTR [BX-1],0       ;ErrorMode Flag ,
                JNZ     NO_RUN                      ;check for processing
                                                    ;critical disk error..
                CMP     ES: BYTE PTR [BX],0         ;InDOS FLAG ...
                JNZ     NO_RUN

                CALL    API
NO_RUN:
                POP     BX
                POP     ES
                POP     DS
Return_2C:      IRET
;
;
;
API:
                MOV     CS: BYTE PTR IN_API,0FFH
                PUSH    AX
                MOV     AX,0
                CALL    API_PRO
                POP     AX
                MOV     CS: BYTE PTR IN_API,0
                RET
API_H:
                MOV     CS: BYTE PTR IN_API,0FFH
                MOV     CS: BYTE PTR IN_FLAG,0FFH   ; INTERRUPTING DOS
                PUSH    AX
                MOV     AX,8000H
                CALL    API_PRO
                POP     AX
                MOV     CS: BYTE PTR IN_FLAG,0
                MOV     CS: BYTE PTR IN_API,0
                RET
;
;
API_PRO:
                CLI
                MOV     CS: WORD PTR SAVE_SS,SS
                MOV     CS: WORD PTR SAVE_SP,SP
                MOV     SS, CS: WORD PTR NEW_S_SEG
                MOV     SP,OFFSET FIRST+STACK_SIZE
                STI
;
;   Okay, Assume we are not in dos and not using the dos stack.
;   I think it is safe to do some work now.
;
;                INT     2CH                 ; testing

                INT     28H

                CLI
                MOV     SS,CS: WORD PTR SAVE_SS
                MOV     SP,CS: WORD PTR SAVE_SP
                STI
                RET
;
;       ROM INTERRUPT MONITORS ....
;
MON_I10:
                PUSHF
                OR      CS: BYTE PTR IN_INTCO,1H
                CALL    CS:DWORD PTR [INT10IP]
                PUSHF
                XOR     CS: BYTE PTR IN_INTCO,1H
                POPF
                RETF    2
MON_I13:
                push    bp                      ; I can not remember why
                mov     bp,sp                   ; this was needed.
                push    [bp+6]
                mov     bp,[bp]
                OR      CS: BYTE PTR IN_INTCO,2H
                CALL    CS:DWORD PTR [INT13IP]
                PUSHF
                XOR     CS: BYTE PTR IN_INTCO,2H
                POPF
                pop     bp
                RETF    2
;
;
;   DOS INTERRUPT 25H & 26H MONITORS.
;
;
MON_I25:
                PUSHF                               ; SAVE FLAGS FOR DOS
                OR      CS: BYTE PTR IN_INTCO,20H   ; 5.00 ...
                POPF
                CLI
                CALL    CS:DWORD PTR [INT25IP]
                PUSHF
                XOR     CS: BYTE PTR IN_INTCO,20H
                POPF
                RETF
;
MON_I26:
                PUSHF
                OR      CS: BYTE PTR IN_INTCO,40H
                POPF
                CLI
                CALL    CS:DWORD PTR [INT26IP]
                pushf
                XOR     CS: BYTE PTR IN_INTCO,40H
                popf
                RETF
;
;       DO THE OLD DOS CALL TO KEEP THE PROGRAM FROM REENTERING .
;
DO_DOS:
                PUSHF
                CALL    CS:DWORD PTR [INT21IP]
                RET
;
;
;
;
INT_2F:
                CMP     AX,0DEADH
                JNE     EXIT_2F
                PUSH    DS
                PUSH    CS
                POP     DS
                MOV     AX,0BEEFH
                MOV     DX,OFFSET IN_FLAG           ; API POINTER FOR TSR.
                POP     DS
                PUSH    CS
                POP     ES                          ; API SEGMENT....
                IRET
EXIT_2F:
                JMP     CS:DWORD PTR [INT2FIP]      ; HOOK TO OTHER PROG ...
;
;
;
;
AN_LIST         DB      0,0,2       ; nop, dont store in buf, pass
                DB      '^A',1
                DB      '^B',1
                DB      '^C',2
                DB      '^D',1
                DB      '^E',1
                DB      0,0,2
                DB      '^G',1
                DB      0,0,0       ; BS
                DB      0,0,0       ; TAB
                DB      10,13,1     ; LF THAN CR
                DB      '^K',1
                DB      '^L',1
                DB      0,0,0       ; RETURN
                DB      '^N',1
                DB      '^O',1
                DB      0,0,0
                DB      '^Q',1
                DB      '^R',1
                DB      0,0,0       ; TTY STOP
                DB      0,0,0       ; DO RAW
                DB      0,0,0       ; DO RAW
                DB      '^V',1
                DB      '^W',1
                DB      '^X',1
                DB      '^Y',1
                DB      '^Z',1
                DB      '\',10,4    ; ESC KEY
                DB      '^\',1
                DB      '^]',1
                DB      '^^',1
                DB      '^_',1
;
;
;
FIRST:
                PUSH    CS
                POP     DS

                PUSH    CS
                POP     CS: WORD PTR NEW_S_SEG
;
                MOV     DX,OFFSET INSTALLER
                CALL    PRINT

                MOV     AX,0DEADH               ; UNQUE SIGN.
                INT     2FH
                CMP     AX,0BEEFH               ; YES WE ARE INSTALLED.
                JNE     SKIP_BAD_E
                MOV     DX,OFFSET PROG_IN
                CALL    PRINT
                INT     20H

                JMP     SKIP_BAD_E
PRINT:
                MOV     AH,09
                INT     21H
                RET
SKIP_BAD_E:
;
;
;       OBTAIN ADDRESS OF DOS SAFE FLAG, THE InDOS FLAG.....
;
                PUSH    ES
                MOV     AH,034H
                INT     21H
                MOV     AX,ES
                MOV     WORD PTR IN_DOSCP,AX
                MOV     WORD PTR IN_DOSIP,BX
                POP     ES
;
                MOV     AX,3508H
                INT     21H
                MOV     WORD PTR INT08IP,BX
                MOV     WORD PTR INT08CP,ES
                MOV     AX,2508H
                MOV     DX,OFFSET INT_08
                INT     21H
;
                MOV     AX,3510H
                INT     21H
                MOV     WORD PTR INT10IP,BX
                MOV     WORD PTR INT10CP,ES
                MOV     AX,2510H
                MOV     DX,OFFSET MON_I10
                INT     21H

                MOV     AX,3513H
                INT     21H
                MOV     WORD PTR INT13IP,BX
                MOV     WORD PTR INT13CP,ES
                MOV     AX,2513H
                MOV     DX,OFFSET MON_I13
                INT     21H

                MOV     AX,3525H
                INT     21H
                MOV     WORD PTR INT25IP,BX
                MOV     WORD PTR INT25CP,ES
                MOV     AX,2525H
                MOV     DX,OFFSET MON_I25
                INT     21H

                MOV     AX,3526H
                INT     21H
                MOV     WORD PTR INT26IP,BX
                MOV     WORD PTR INT26CP,ES
                MOV     AX,2526H
                MOV     DX,OFFSET MON_I26
                INT     21H

                MOV     AX,352FH
                INT     21H
                MOV     WORD PTR INT2FIP,BX
                MOV     WORD PTR INT2FCP,ES
                MOV     AX,252FH
                MOV     DX,OFFSET INT_2F
                INT     21H
;
                MOV     AX,CS:[2CH]
                MOV     ES,AX
                MOV     AH,49H
                INT     21H
;
                MOV     AX,3521H
                INT     21H
                MOV     WORD PTR INT21IP,BX
                MOV     WORD PTR INT21CP,ES
                MOV     AX,2521H
                MOV     DX,OFFSET INT_21
                INT     21H

                MOV     DX,OFFSET OKAY
                CALL    PRINT

                MOV     CS: WORD PTR IN_API,0   ; TURN ON THE TOY
;
                MOV     DX,OFFSET FIRST+STACK_SIZE
                INT     27H
;
;
INSTALLER       DB      13,10,'     API-28 Version 0.01, 1999. By James B. Tabor.$'
PROG_IN         DB      13,10,'     API CALLER IN MEMORY. ',13,10,'$'
OKAY            DB      13,10,'     API INTERFACE INSTALLED. ',13,10,'$'
;
;
CODE            ENDS
                END     START
