LOCAL MCBINFO*	STACK_	MCB_add			(seg_t, count sz, seg_t owner);
LOCAL void	STACK_	MCB_make_SYSDATA_list	(seg_t, seg_t);
LOCAL byte	FAST_	MCB_make_list		(seg_t);
LOCAL void	FAST_	MEM_get			(void);
LOCAL const MCBINFO*
		FAST_	MCB_find		(seg_t, off_t);
LOCAL PCStr	FAST_	MCB_name		(const MCBINFO*);
LOCAL void	FAST_	ENV_say_path		(seg_t env);
LOCAL void	FAST_	memory_list		(void);

#define FP_SDMCB(seg) FS (SYSDATA_MCB, seg)

/*----------------------------------------------------------------------*/

LOCAL MCBINFO *STACK_ MCB_add (seg_t seg, count sz, seg_t owner) {
	MCBINFO *p = MEM_ADD ("MCB list", MCBINFO);
	p->seg = seg, seg += sz, p->next_seg = seg,
	p->owner = owner, p->next = NULL;
	return MEM.last = MEM.last->next = p;
}

LOCAL void STACK_ MCB_make_SYSDATA_list (seg_t sd, seg_t next_seg) {
    sd++;
    while (sd < next_seg && FP_SDMCB (sd)->start == sd + 1) {
	MCBINFO *p = MCB_add (sd, FP_SDMCB (sd)->size + 1, sd);
	p->type = MT_SUBSEG, sd = p->next_seg;
}   }

LOCAL MCBINFO	/* type       seg next_seg owner next */
	MCB70 = {MT_SYSCODE, 0x70,   0x70,   0,	 NULL},
	MCB50 = {MT_DATA,    0x50,   0x70,   0,  &MCB70},
	MCB40 = {MT_DATA,    0x40,   0x50,   0,  &MCB50},
	MCB00 = {MT_DATA,    0x00,   0x40,   0,  &MCB40};

LOCAL byte FAST_ MCB_make_list (seg_t seg) {
    byte ID; MCBINFO *p = &MCB70;
    p->next_seg = seg, MEM.root = &MCB00, MEM.last = p;
    do {
	seg = p->next_seg;
	ID = FS (MCB, seg)->ID;
	if (ID != 'M' && ID != 'Z') return ID;

	seg_t owner = FS (MCB, seg)->owner;
	count  size = FS (MCB, seg)->size + 1;
	if (owner == _psp) owner = 0;	/*--- mark MEM's MCBs as free	*/
	if (owner == 0 && p->type == MT_FREE) {
		p->next_seg += size,	/*--- merge free adjacent MCBs	*/
/*!*/		ID = FS (MCB, seg)->ID;
		continue;
	}

	p = MCB_add (seg, size, owner);
/*!*/	owner = p->owner; p->type = MT_UNKNOWN;
	if (owner == 0)   p->type = MT_FREE;
	owner--;
	if (owner == seg) p->type = MT_CODE;	/* MCB owns itself	*/
	if (owner <= 8-1) {
		word SYSID = *(word far*)FS (MCB, seg)->name;
		p->type = MT_SYSCODE;
		if (SYSID != 0x4353) {		/* 'SC' - system code	*/
		    p->type = MT_SYSDATA;
		    if (SYSID == 0x4453) {	/* 'SD' - system data	*/
			MCB_make_SYSDATA_list (seg, p->next_seg);
	}	}   }

/*!*/	ID = FS (MCB, seg)->ID;
    } while (ID == 'M');
    return ID;
}

LOCAL void FAST_ MEM_get (void) {
	/*--- get size of conventional memory in kb */
	MEM.BASE.last_seg =
		(MEM.BASE.total_kb = callint (0x12)) * (1024u/16u) - 1;

	/*--- check UMB presence */

	register word oldlink = DOS_getUMBlink (),
		      errcode = DOS_setUMBlink (1);
	if (errcode > 1) { /* unknown error */
		say_error ("UMB", MSG_chain_bad);
		abort (); return;
	}
	MEM.UMB.state = errcode ? NONE : DONE;

	/*--- make internal list of MCBs */

	if (MCB_make_list (SYS.OS.LoL->first_MCB) != 'Z') {
		say_error ("MCB", MSG_chain_bad);
		abort (); return;
	}
	DOS_setUMBlink (oldlink);

	/*--- process internal list of MCBs */

/*	MEM.BASE.free = MEM.BASE.largest =
 *	MEM.UMB. free = MEM.UMB. largest = MEM.UMB.total = 0;
 */
	MCBINFO *p = MEM.root;
	do {
	    /*--- compute used/free space and largest free block	*/

	    count size = p->next_seg - p->seg;
	    if (p->seg < MEM.BASE.last_seg) {		/* conventional	*/
		if (p->type == MT_FREE) {
		    MEM.BASE.free += size;
		    if (MEM.BASE.largest < size)
			MEM.BASE.largest = size;
		}
	    } else {					/* UMB		*/
		if (p->type == MT_FREE) {
		    MEM.UMB.free += size;
		    if (MEM.UMB.largest < size)
			MEM.UMB.largest = size;
		}
		if ((p->type & (MT_SYSCODE | MT_SUBSEG)) == 0)
		    MEM.UMB.total += size;
	    }

	    /*--- for slave MCB and environment find parent MCB		*/

	    if (p->type == MT_UNKNOWN) {
		MCBINFO *q = MEM.root;
		seg_t owner = p->owner - 1;
		do {
		    if (q->seg == owner) {
			if (q->type == MT_CODE) {
			    p->type = MT_DATA; owner++;
			    seg_t data = p->seg + 1;
			    if (FS (PSP, owner)->DOS_exit == 0x20CD &&
				FS (PSP, owner)->env_seg == data) {
				/* q contains PSP and p is env for q	*/
					p->type = MT_ENV,
					q->owner = data;
			}   }
			break;
		    }
		    q = q->next;
		} while (q);
	    }

	    p = p->next;
	} while (p);
}

LOCAL const MCBINFO *FAST_ MCB_find (seg_t seg, off_t off) {
	off >>= 4, seg += off;
	const MCBINFO *p = MEM.root, *found = NULL;
	do {	if (p->seg <= seg && seg < p->next_seg)
			found = p;
		p = p->next;
	} while (p);
	return found;
}

LOCAL PCStr FAST_ MCB_name (const MCBINFO *p) {
	if (p->type & (MT_SYSCODE
		    |  MT_SYSDATA))	return "<system>";
	if (p->type &  MT_FREE)		return "--free--";

	static char name_buf [7 + sizeof FP_SDMCB (0)->name + 1];
	if (p->type &  MT_SUBSEG) {
	    static MAP SEG_type [] = {
		{'C', "EMS BUFFERS="},	/* /X EMS workspace area	*/
		{'B', "BUFFERS="},	/* storage area			*/
		{'D', "*DEVICE="},	/* device driver		*/
		{'E', "DEVICE="},	/* device driver appendage	*/
		{'F', "FILES="},	/* storage area (for FILES>5)	*/
		{'I', "*IFS="},		/* IFS driver			*/
		{'L', "LASTDRIVE="},	/* CDS array storage		*/
		{'S', "STACKS="},	/* code and data area		*/
		{'T', "INSTALL="},	/* transient code		*/
		{'X', "FCBS="},		/* storage area			*/
		{  0, ""}
	    };

	    register seg_t sd = p->owner;
	    PCStr pn = MAP_GET (SEG_type, FP_SDMCB (sd)->ID);
	    if (*pn != '*') return pn;
	    pn++; copy_name (name_buf, pn, sizeof name_buf - 1);
	    PStr      ppn = name_buf + 4;		/* IFS=		*/
	    if (*ppn) ppn = name_buf + 7;		/* DEVICE=	*/
	    canonize_name (ppn, FP_SDMCB (sd)->name,
			 sizeof FP_SDMCB (sd)->name);
	    return name_buf;
	}

	seg_t seg = p->seg;
	if (seg == 0x00) return "<IVT>";
	if (seg == 0x40) return "<BIOS>";
	if (seg == 0x50) return "<DOS>";

	name_buf [0] = '\0';
	if (p->type & (MT_CODE | MT_ENV | MT_DATA)) {
		if (p->type & (MT_ENV | MT_DATA))
			seg = p->owner - 1;
		canonize_name (name_buf, FS (MCB, seg)->name,
				  sizeof FS (MCB, seg)->name);
	}
	return name_buf;
}

#define MAX_ENV_SIZE 32768u

LOCAL void FAST_ ENV_say_path (seg_t env_seg) {
	off_t env_off = 0;
	/*--- find empty ASCIZ string					*/
	while (*FP (char, env_seg, env_off)) {
		/*--- skip current environment variable			*/
		do {	env_off++;
			if (env_off >= MAX_ENV_SIZE-1) return;
		} while (*FP (char, env_seg, env_off));
		env_off++;
	}
	env_off++;
	if (*FP (word, env_seg, env_off) == 1) {
		env_off += sizeof (word) - 1;
		say ("=");
		for (;;) {
			env_off++;
			byte ch = *FP (char, env_seg, env_off);
			if (ch < ' ') break;
			printf ("%c", ch);
}	}	}

LOCAL void FAST_ memory_list (void) {
    const MCBINFO *p = MEM.root;
    header (2, 1, "Segment   Size   Owner       Type / source\n"
		  "-------   ----   ---------   -----------------\n");
    for (;;) {
	seg_t seg = p->seg;
	if (p->type != MT_SUBSEG)
		printf (" %04X  ", seg);
	else	printf ("  -%04X", p->next_seg);
	static char buf [6];
	printf ("   %s  ", scale_sz (p->next_seg - seg, 4, buf));

	  if (p->type & (MT_SYSDATA
		       | MT_CODE
		       | MT_ENV
		       | MT_DATA))	printf ("%-12s", MCB_name (p));
	elif (p->type &  MT_SUBSEG)	printf ("  %-10s", DEV_find_name (p));
	elif (p->type &  MT_FREE)	printf ("%-12s", "");
	elif (p->type &  MT_UNKNOWN)	printf ("<%04X>", p->owner);

	  if (seg == 0)				    say ("INT vectors table");
	elif (p->type & (MT_SYSCODE
		       | MT_SUBSEG
		       | MT_FREE))	say (MCB_name (p));
	elif (p->type & (MT_SYSDATA
		       | MT_DATA))		    say ("data area");
	elif (p->type &  MT_CODE) {
		if (p->owner - 1 != seg)	    ENV_say_path (p->owner);
	}
	elif (p->type &  MT_ENV)		    say ("environment");

	p = p->next; if (p == NULL) break;

	seg_t last_seg = MEM.BASE.last_seg;
	if (seg < last_seg && last_seg <= p->seg)
		/* split low and upper memory blocks */
		header (1, 1, "-------\n");
	else	new_line ();
    }
    new_line ();
    printf ("-%04X-", MEM.last->next_seg);
    new_line ();
}
