; 29.11.2001 - SYSEECHO.SYS - shows cmdline arg using int 10.9,
; plus translates $ to ESC

        org  0  ; SYS file

next    dw -1,-1
attrib  dw 1000000000000100b    ; very nully NUL device
stra    dw strat	; *offset* prepare, store ES:BX (far call)
inr     dw intr  	; *offset* do the real work (far call)
nam     db 'EECHO$$$'   ; driver name will become a special filename,
			; so better not use a too normal name...
pb      dd 12345678h

strat:  mov word [cs:pb+2],es
        mov word [cs:pb],bx	; we could copy the contents of the
        RETF			; referenced data structure here, too

intr:   pushf
	push ax
        push bx
        push es
        les bx,[cs:pb]
        mov byte [es:bx+17h],0		; no error
        and word [es:bx+3],7FFDh	; not busy / no error
        or word [es:bx+3],1		; ack state
        cmp byte [es:bx+2],0		; INIT ?
	jz inst
nix:    pop es
        pop bx
	pop ax
        popf
        RETF


inst:   mov word [es:bx+10h],cs	; eof tsr
        mov word [es:bx+0Eh],0	; eof tsr (thus no tsr)

	; we could check for a minimum DOS version here (4.0 ?)

	push bx
	mov ax,0e0dh
	mov bx,7	; TTY ignores color in text modes!
	int 10h		; CR (TTY)
	mov ax,0e0ah
	mov bx,7
	int 10h		; LF (TTY)
	pop bx

	les bx,[es:bx+12h]	; pointer to command line

skp:	mov al,[es:bx]
	cmp al,' '
	jb hlp		; command line ended with name, no args
	jz rpt		; the real args
	inc bx		; skip filename of sys
	jmp short skp

rpt:	mov al,[es:bx]
	cmp al,0
	jz enst
	cmp al,10
	jz enst
	cmp al,13
	jz enst
	cmp al,'$'
	jz xesc
	cmp al,'A'
	jb norm
	cmp al,'Z'
	ja norm
	or al,32	; downcase, because FreeDOS upcases. sigh...
	jmp short norm
xesc:	mov al,27	; $ -> ESC
norm:	mov ah,2
	push dx
	mov dl,al	; char
	int 21h		; CHAR (dossy output!)
	pop dx
	inc bx		; next char
	jmp short rpt

enst:	mov ax,0e0dh
	mov bx,7
	int 10h		; CR (TTY)
	mov ax,0e0ah
	mov bx,7
	int 10h		; LF (TTY)

	jmp short nix	; DONE
		
hlp:	mov bx,cs
	mov es,bx
	mov bx,hlpmsg	; *offset* help message
	jmp short rpt	; show string

hlpmsg	db 'syseecho.sys: shows command line, translating dollar signs to'
	db ' esc. By EA.',0

