; Wrapper to give Int 13 its own stack and to do some statistics,
; 29.11.2001 by EA.

        org  0  ; SYS file

next    dw -1,-1
attrib  dw 1000000000000100b    ; very nully NUL device
stra    dw strat	; *offset* prepare, store ES:BX (far call)
inr     dw intr  	; *offset* do the real work (far call)
nam     db 'I13STAK$'   ; driver name will become a special filename,
			; so better not use a too normal name...
pb      dd 12345678h
old13	dd 12345678h	; old int 13h vector
newstk	dd 12345678h	; new SSSP
sssp	dd 12345678h	; old SSSP
used    db 1		; bits: 2: init done  1: handler busy

strat:  mov word [cs:pb+2],es
        mov word [cs:pb],bx	; we could copy the contents of the
        RETF			; referenced data structure here, too

intr:   pushf
	push ax
        push bx
        push es
        les bx,[cs:pb]
        mov byte [es:bx+17h],0		; no error
        and word [es:bx+3],7FFDh	; not busy / no error
        or word [es:bx+3],1		; ack state
        cmp byte [es:bx+2],0		; INIT ?
	jnz nix
	test byte [cs:used],2		; already done?
	jnz nix
        jmp inst
nix:    pop es
        pop bx
	pop ax
        popf
        RETF

I13:	test byte [cs:used],1	; nested?
	jz usenew
	jmp useold

usenew:	or byte [cs:used],1	; busy
	mov [cs:sssp+2],ss
	mov [cs:sssp],sp	; remember stack
	lss sp,[cs:newstk]	; own stack

histah:	push bx
	mov bh,0
	mov bl,ah
	cmp bl,7fh
	jb noahclp
	mov bl,7fh		; max considered ah
noahclp:
	add bx,bx
	inc word [cs:ente+bx]	; AH histo
	jnz noahclp2
	dec word [cs:ente+bx]	; saturate
noahclp2:
	pop bx

	cmp ah,2		; count to count?
	jb nosz
	cmp ah,4
	jbe dosz
	cmp ah,42h
	jb nosz
	cmp ah,44h
	ja nosz

	push bx
	mov bx,[ds:si+2]	; count
histsz:	cmp bx,7fh
	jb nolbszclp
	mov bx,7fh		; max considered count
nolbszclp:
	add bx,bx
	inc word [cs:ente+256+bx]	; size histo
	jnz nolbszclp2
	dec word [cs:ente+256+bx]	; saturate
nolbszclp2:
	pop bx
	jmp short nosz

dosz:	push bx
	mov bh,0
	mov bl,al		; count
	jmp short histsz

nosz:	pushf
	call far [cs:old13]	; call real int 13

	lss sp,[cs:sssp]	; restore stack
	pushf		; STUPID: and clears CF (but inc/dec does not)
	and byte [cs:used],0feh	; no longer busy
	popf		; STUPID - see above - 01/2002
	RETF +2		; STUPID - iret instead of retf +2 has killed CY
;	IRET

useold:	jmp far [cs:old13]	; do nothing if nested!


clrtab:
	mov [es:bx],ax	; there: words: 128 AH histo, 128 size histo,
	inc bx		; 256 stack
	inc bx
	loop clrtab
	pop cx
	and byte [cs:used],0feh		; enable int 13
	jmp nix

align 4
ente    db 'Int 13 stack enhancer with statistics stuff'

inst:   cli				; because we hook ints
	mov word [cs:newstk+2],cs
	mov word [cs:newstk],ente+1020	; where the local stack is
        mov word [es:bx+10h],cs
        mov word [es:bx+0Eh],ente+1024	; *offset* first free byte
	mov byte [cs:used],3		; inst to be done only once
					; and disable int 13 first

        xor bx,bx
        mov es,bx
	mov bx,[es:4ch]		; make a backup of the int 13 vector
	mov [cs:old13],bx
	mov bx,[es:4eh]
	mov [cs:old13+2],bx
        mov word [es:4ch],I13	; *offset*	; hook INT 13
        mov word [es:4eh],cs
        sti

	mov bx,cs
	mov es,bx
	mov bx,ente		; where to put table
	xor ax,ax
	push cx
	mov cx,512
	jmp clrtab		; overwrite inst code to have table space


