/*
    copyright by tom ehlert (tom.ehlert@ginko.de)
    driveID.C
*/
#include <dos.h>

/**
***
*** !short: hexd ((char*)array)
***    dump 16 Bytes from array to stdout requieres 67 bytes on line
*** !seealso: hexdn hexsd
*** !short: hexdn ((char*)array,anzahl)
***    dump N * 16 bytes to stdout
*** !seealso: hexd hexsd
***
*** !short: hexsd ((char*)string,(char*)array,anz)
***     dump min(anz,16) bytes from array into string
*** !seealso: hexd hexdn
***
**/
#include <stdio.h>
#include <ctype.h>
#include <tomlib.h>

// #include <tomwin32.h>

void hexd(char *array)
    {
    hexdn(array, 16);
    }

void hexdn(char *array,register int anz)
    {
	char *arrays = array;
    char linebuff[80];

    for (;anz > 0;  anz -= 16,  array += 16)
        {
		printf("%03x",array-arrays);
        hexsd(linebuff, array, anz);
        printf("%s\n",linebuff);
        }
    }

char *hexsd(register unsigned char  *dest,char *src,int anz)
    {
    register int loop;
    register char c;
    static char hexchars[] = "0123456789ABCDEF";
	char *desto = dest;

    anz = min(anz,16);
    *dest++ = '|';

    for (loop = 0;  loop < anz;  loop++)
        {
        c = src[loop];
        *dest++ = hexchars[(c >> 4) & 0xF];
        *dest++ = hexchars[(c) & 0xF];
        *dest++ = ' ';
        }
    for (;loop < 16;  loop++)
        {
        *dest++ = ' ';
        *dest++ = ' ';
        *dest++ = ' ';
        }
    dest[-1] = '|';

    for (loop = anz ;  --loop >= 0;  )
        {
        c = *src++;
        *dest++ = (uchar)(c >= 0x20 && c < 0x7f  ? c : '.');
        }
    *dest++ = '|';
    *dest = '\0';
	return desto; 
    }


typedef unsigned char UCHAR;

UCHAR buffer[512];

main()
{
    unsigned IObase = 0x1f0;
    
    for (drive = 0; drive <= 1; drive++)
        {
        outportb(IObase + 6, 0x01 | (drive << 4));  /* select drive 01, 11 */
        outportb(IObase + 7, 0xec);                 /* request configuration */
        if (inportb(IObase+7) != 0x58)
            {
            printf("no drive available for port %x, drive %u\n", IObase,drive);
            break;
            }
        
        for (i = 0; i < 512; i += 2)
            {
            valw = inportw(IObase);
            
            *buffer++ = (UCHAR)(valw >> 8);
            *buffer++ = (UCHAR)valw;     
            }
        
        printf("information for port %x, drive %u\n", IObase,drive);

        hexd(buffer,512);
        
        printf("\n");
        
            
        }

    
    
}    