/*  FreeDOS HTML Help Viewer

    READFILE - opens and reads in a text file

    Copyright (c) Express Software 2002-3
    See doc\htmlhelp\copying for licensing terms
    Created by: Joe Cosentino/Rob Platt
*/

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "help_gui.h"
#include "readfile.h"

/* min macro isn't implemented by some compilers */
#ifndef min
#define min(a,b)    (((a) < (b)) ? (a) : (b))
#endif

char *
readFile (char *filename)
{
  FILE *f;
  long l;
  char *text_buf;

  f = fopen (filename, "rb");

  if (!f)
    {
      readFileError (filename);
      return 0;
    }

  /* determine the length of file using standard file i/o. -RP
   */
  fseek (f, 0L, SEEK_END);
  l = min (ftell (f), 65530L);
  fseek (f, 0L, SEEK_SET);

  /* Allocate memory for file text buffer */
  while ((text_buf = (char *) malloc (l + 1)) == NULL)
    if (pesListDeleteOldest ())
      {
	show_error ("Cannot allocate enough memory.");
	return 0;
      }
  /* Read file into text buffer */
  if (!fread (text_buf, 1, l, f))
    {
      readFileError (filename);
      free (text_buf);
      return 0;
    }

  /* Clean up and 0-terminate the text buffer */
  fclose (f);
  text_buf[l] = 0;

  return text_buf;
}

void
readFileError (char *filename)
{
  char *err_msg;
  int i;

  err_msg = (char *) malloc (strlen (filename) + 12);
  if (err_msg == 0)
    {
      show_error ("Cannot allocate memory\n");
      return;
    }

  sprintf (err_msg, "Can't open %s", filename);

  /* Beautify the err_msg by replacing / with \ */
  for (i = 15; i < strlen (err_msg); i++)
    if (err_msg[i] == '/')
      err_msg[i] = '\\';

  show_error (err_msg);
  free (err_msg);
  return;
}
