
;   DISPLAY.ASM v0.5b
;
;   FreeDOS driver for loading EGA/VGA/SVGA character generator
;   to bring national language support to different screen modes
;
;   Copyright (C) 9 Aug 2000 Ilya V. Vasilyev aka AtH//UgF@hMoscow
;   e-mail: hscool@netclub.ru
;   WWW:    http://www.freedos.org/
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
; To do:
;   + parameter line a-la M$-DOS DISPLAY.SYS CON=(ega,437,1)
;   + change codepages via IOCTL
;   + test code on MCGA
;   + test code on VESA
;   + Hercules+ support (anyone need this?)
;
;               .       .       .       .       .       line that rules

                %include "display.inc"

                ORG     100H

                jmp     NEAR Install
;                DB      -1
;                DW      8000H           ; Attributes
;                DW      Strategy-100H
;                DW      Init-100H
;                DB      "DISPLAY "      ; Device name
;dRequest:       DD      ?


;-------------------------------------------------------
; INTERRUPT ROUTINES
;
;               .       .       .       .       .       line that rules
New10:          or      ah,ah
                jnz     i10n0
                cmp     ah,[cs:flgOur]  ; VESA switching can call i10Fn0
                jnz     jnzOld10
;
; Here we fix Classic Video BIOS Fn 00: Set Screen Modee
;
                push    ax
                pushf
                call    FAR [cs:dOld10]
                pop     ax              ; Do not assume i10Fn0 saved AL
                push    ax
                and     al,7fH          ; High bit means save video memory
iSFpr:          call    SetFont
                pop     ax
                iret
i10n0:
                cmp     ax,4f02H        ; VESA SET MODE
                jnz     i10nVESA
;
; Here we fix VESA Video BIOS Extensions Fn 4f02: VESA SET MODE
;
                inc     BYTE [cs:flgOur]
                pushf
                call    FAR [cs:dOld10]
                dec     BYTE [cs:flgOur]
                push    ax
                mov     al,-1           ; Unknown video mode
                jmp     SHORT iSFpr
i10nVESA:
                cmp     ah,11H          ; All other bisiness is with
jnzOld10:       jnz     jOld10          ; character generator functions
;
; All other code fix EGA Video BIOS Fn 11: Character Generator Functions
;
                cmp     al,30H          ; Get Font Information?
                jnz     i10f11n30
;
; Here we support Video BIOS Subfunctions of
; Fn1130: Get Font Information
;
                cmp     bh,5            ; Font 9x14 not supported (now?)
                jz      jOld10
                cmp     bh,6
                ja      jOld10          ; Font 9x16 not supported (now?)
                jb      i10f1130n6
                cmp     BYTE [cs:bAdapter],VGA
                jb      jOld10          ; We support 8x16 only on VGA
i10f1130n6:
                sub     cx,cx           ; CH register must be zero on exit
                mov     es,cx
                mov     dl,[es:484H]    ; Number of lines - 1
                mov     cl,[es:485H]    ; Bytes per char
                cmp     bh,1
                ja      i10f1130a1
                jz      i10f1130s1
                les     bp,[es:7cH]     ; SubFn 00: Return vector 1FH
                iret
i10f1130s1:
                les     bp,[es:43H*4]   ; SubFn 01: Return vector 43H
                iret
i10f1130a1:
                push    cs              ; All other functions return fonts
                pop     es              ;   from DISPLAY.SYS segment
                cmp     bh,3
                ja      i10f1130a3
                jz      i10f1130f3
                mov     bp,bFont8x14    ; SubFn 02: Return ROM font 8x14
                iret
i10f1130f3:
                mov     bp,bFont8x8     ; SubFn 03: Return ROM font 8x8 (00..7f)
                iret
i10f1130a3:
                cmp     bh,6
                jz      i10f1130s6
                mov     bp,bFont8x8+1024; SubFn 04: Return ROM font 8x8 (80..ff)
                iret
i10f1130s6:
                mov     bp,bFont8x16    ; SubFn 06: Return ROM font 8x16
                iret
i10f11n30:
;
; Here we support SubFn 01/11, 02/12, and (on VGA+) 04/14
;
                cmp     al,01           ; SubFn 01: Set ROM font 8x14
                jz      i10f1101
                cmp     al,11H          ; SubFn 11: Set ROM font 8x14
                jnz     i10f11n11
i10f1101:
                push    bp
                push    bx
                mov     bp,bFont8x14
                mov     bh,14
i10set:         push    es
                push    ax
                push    cx
                push    dx
                push    cs
                pop     es
                mov     cx,100H
                cwd                     ; DX=0
                and     al,10H
                pushf
                call    FAR [cs:dOld10]
                pop     dx
                pop     cx
                pop     ax
                pop     es
                pop     bx
                pop     bp
                iret
jOld10:         DB      0eaH
dOld10:         DD      -16
i10f11n11:
                cmp     al,02           ; SubFn 02: Set ROM font 8x8
                jz      i10f1102
                cmp     al,12H          ; SubFn 12: Set ROM font 8x8
                jnz     i10f11n12
i10f1102:
                push    bp
                push    bx
                mov     bp,bFont8x8
                mov     bh,8
                jmp     i10set
i10f11n12:
                cmp     al,04           ; SubFn 04: Set ROM font 8x16
                jz      i10f1104
                cmp     al,14H          ; SubFn 14: Set ROM font 8x16
                jnz     i10f11n14
i10f1104:
                cmp     BYTE [cs:bAdapter],VGA
                jb      jOld10          ; We support 8x16 only on VGA
                push    bp
                push    bx
                mov     bp,bFont8x16
                mov     bh,16
                jmp     i10set
i10f11n14:
;
; Here we support SubFn 22, 23 and (on VGA+) 24
;
                cmp     al,22H          ; SubFn 22: Set ROM font 8x14 (INT 43)
                jnz     i10f11n22
                push    bp
                push    cx
                mov     bp,bFont8x14
                mov     cx,14
i10setg:        push    es
                push    ax
                push    cs
                pop     es
                mov     ax,1121H
                pushf
                call    FAR [cs:dOld10]
                pop     ax
                pop     es
                pop     cx
                pop     bp
                iret

i10f11n22:
                cmp     al,23H          ; SubFn 23: Set ROM font 8x8 (INT 43)
                jnz     i10f11n23
                push    bp
                push    cx
                mov     bp,bFont8x8
                mov     cx,8
                jmp     i10setg
i10f11n23:
                cmp     al,24H          ; SubFn 24: Set ROM font 8x16 (INT 43)
                jnz     jOld10
                cmp     BYTE [cs:bAdapter],VGA
                jb      jOld10          ; We support 8x16 only on VGA
                push    bp
                push    cx
                mov     bp,bFont8x16
                mov     cx,16
                jmp     i10setg

jOld2f:         DB      0eaH
dOld2f:         DD      -16
New2f:
                cmp     ax,0ad00H       ; INSTALLATION CHECK
                jnz     jOld2f
                mov     al,-1
                iret


;-------------------------------------------------------
; DRIVER INTERFACE
;
;               .       .       .       .       .       line that rules
;Strategy:
;                mov     [cs:dRequest-100H],bx
;                mov     [cs:dRequest+2-100H],es
;                ret
;
;Init:           push    ds
;                push    bx
;                lds     bx,[cs:dRequest-100H]
;                test    BYTE [cs:flgInstalled-100H],-1
;                jz      iExit
;                cmp     BYTE [bx+2],0
;                jz      InitFn0
;iExit:
;                mov     WORD [bx+3],8003H
;                pop     bx
;                pop     ds
;                retf
;
; .SYS initilization code goes here
;
;InitFn0:
;                push    ds                      ; Save Request
;                push    bx
;
;                mov     ax,cs
;                push    ax
;                call    _Install
;
;                pop     bx
;                pop     ds                      ; Restore Request
;                mov     ax,[cs:pMemTop-100H]
;                mov     WORD [bx+14],ax
;                mov     WORD [bx+16],cs
;                mov     WORD [bx+3],0100H       ; Status "Operation Complete"
;                pop     bx
;                pop     ds
;                retf
;_Install
;                sub     ax,10H
;                push    ax
;                mov     ax,DoInstall
;                push    ax
;                retf


;-------------------------------------------------------
; RESIDENT SUBROUTINES
;
;       .       .       .       .       .       .       line that rules

; Fn:   SetFont
; Does: Set a proper localized font for a given video mode
; In:   AL Screen mode (-1 if unknown)
; Mod:  (none)
;
SetFont:
                push    ds
                push    es
                push    ax
                push    cx
                push    dx
                push    bx
                push    si
                push    di
                push    bp

                sub     bx,bx                   ; BL: Zero!
                mov     ds,bx
                mov     dx,[484H]
                mov     bh,dh                   ; BH: bytes per character
                inc     dx                      ; DL: number of lines
                mov     WORD [7cH],bFont8x8+1024; Kinda tradition to restore
                mov     [7eH],cs                ; vector 1f every time

                push    cs
                pop     es

                cmp     BYTE [cs:bAdapter],VGA
                jb      sfNo8x16
                cmp     bh,16
                jb      sfNo8x16
                mov     bh,16
                mov     bp,bFont8x16
                jmp     SHORT sfSetIt
sfNo8x16:
                cmp     bh,14
                jb      sfNo8x14
                mov     bh,14
                mov     bp,bFont8x14
                jmp     SHORT sfSetIt
sfNo8x14:
                cmp     bh,8
                jb      sfpr
                mov     bh,8
                mov     bp,bFont8x8
sfSetIt:
                cmp     al,13H
                ja      sfTest          ; Screen modes above 13H are unknown
                cmp     al,0dH
                jae     sfGraph         ; Screen modes 0d..13H   are graphics
                cmp     al,4
                jb      sfText          ; Screen modes  0..3     are text
                cmp     al,7
                jz      sfText          ; Screen mode    7       is  text
                jb      sfGraph         ; Screen modes  4..6     are graphics
sfTest:         mov     al,6
                push    dx
                mov     dx,3ceH
                out     dx,al
                call    sfr             ; Small delay
                inc     dx
                in      al,dx           ; Graph Controller Misc Register
                pop     dx
                shr     al,1
                jc      sfGraph
sfText:
                mov     cx,100H
                mov     ax,1100H        ; Load user font and reprogram controller
                cwd                     ; DX=0, BL is already zero, BH=bpc
                jmp     SHORT sfi10
sfGraph:
                mov     cl,bh           ; bytes per character
                sub     ch,ch           ; BL is already zero, DL=# of lines
                mov     ax,1121H        ; Set vector 43H for user font
sfi10:          pushf
                call    FAR [cs:dOld10]
sfpr:
                pop     bp
                pop     di
                pop     si
                pop     bx
                pop     dx
                pop     cx
                pop     ax
                pop     es
                pop     ds
sfr:            ret

;               .       .       .       .       .       line that rules
;
; The following is vital for interface with FreeDOS MODE.COM
;
flgOur          DB      0               ; Our INT 10 Fn 00?
;flgInstalled    DB      0               ; Already called drive Req 00 Init?
;flgActive       DB      0               ; Are we active?
bAdapter        DB      0
;bCPhard        DW      0               ; Dont know hardware codepage
;bCPsoft        DW      866             ; This is Russian version
bFont8x8:       incbin  "cp866x8.fnt"
bFont8x14:      incbin  "cp866x14.fnt"
bFont8x16:      incbin  "cp866x16.fnt"

bLastByte:
;-----------------------------
; End of Resident part
;

pMemTop:        DW      bLastByte


;-------------------------------------------------------
; COM VERSION
;
;               .       .       .       .       .       line that rules
Install:
                push    cs
                call    DoInstall
                jc      Done
                mov     dx,[pMemTop]
                int     27H             ; TSR  for .COM files
Done:           int     20H             ; Exit for .COM files


; Fn:   DoInstall
; Does: Install DISPLAY.SYS, if possible
; Out:  CY if already installed
;
Already:
                mov     dx,errAlready
rQc:            mov     ah,9
                int     21H
                stc
                retf
Acient:
                mov     dx,errAcient
                jmp     rQc

DoInstall:
                mov     ax,0ad00H
                int     2fH
                cmp     al,-1
                jz      Already
                call    TestAdapter
                cmp     al,CGA
                jbe     Acient
                cmp     al,VGA
                jae     InstallAllFonts
                mov     WORD [pMemTop],bFont8x16        ; Save 4K on EGA
InstallAllFonts:
;
; Some BIOS routines read characters (00..7f) from screen,
; useing ROM BIOS table. So we must use the same 8x8 font
; for characters 00..7f, as stored in ROM BIOS.
;
; If people complain, this can be done optionally
; in future releases.
;
                push    ds
                mov     ax,1130H
                mov     bh,3
                int     10H             ; Get BIOS ROM character generator

                push    es
                pop     ds
                mov     si,bp
                push    cs
                pop     es
                mov     di,bFont8x8
                mov     cx,128*4
        rep     movsw
                pop     ds
;
; Now we must intercept all our interrupt vectors.
;
                mov     ax,352fH        ; Get vector 2f
                int     21H
                mov     [dOld2f],bx
                mov     [dOld2f+2],es

                mov     dx,New2f
                mov     ax,252fH        ; Set vector 2f
                int     21H

                mov     ax,3510H        ; Get vector 10
                int     21H
                mov     [dOld10],bx
                mov     [dOld10+2],es

                mov     dx,New10
                mov     ax,2510H        ; Set vector 10
                int     21H

                mov     al,-1
                call    SetFont

                clc
                retf

; Fn:   TestAdapter
; In:   (none)
; Out:  AL Video adapter type
; Note: No VESA check yet.
;       .       .       .       .       .       .       line that rules
TestAdapter:
                 mov    ax,1a00H        ; Call DCC
                 int    10H
                 cmp    al,1aH
                 jnz    taNoDCC

; Now we know, that have PS/2 Video BIOS.
; Active adapter code is now in BL register

                 cmp    bl,0cH
                 ja     taNoDCC
                 sub    bh,bh
                 mov    al,[tblDCC+bx]
                 cmp    al,bh
                 jnz    taKnowAdapter
taNoDCC:
                 mov    bl,10H          ; Get Configuration Information
                 mov    ah,12H          ; Alternate Select
                 int    10H
                 mov    al,EGA
                 cmp    bl,10H
                 jnz    taKnowAdapter   ; if bh<>0, EGA_MONO

                 int    11H             ; EquipList
                 and    al,30H
                 cmp    al,30H
                 mov    al,MDA
                 jz     taKnowAdapter
                 mov    al,CGA
taKnowAdapter:
                 mov    [bAdapter],al
                 ret

tblDCC           DB     NO,MDA,CGA,NO,EGA,EGA,NO,VGA,VGA,NO,MCGA,MCGA,MCGA
errAlready       DB     "DIPSLAY.SYS is already loaded", 0dH, 0aH, "$"
errAcient        DB     "DISPLAY.SYS needs at least EGA adapter", 0dH, 0aH, "$"

                 END
