/*
   DISKCOPY.EXE, floppy diskette duplicator similar to MSDOS Diskcopy.
   Copyright (C) 1998, Matthew Stanford.
   Copyright (C) 1999, 2000, Imre Leber.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have recieved a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


   If you have any questions, comments, suggestions, or fixes please
   email me at:  ilebr@vub.ac.be

*/

#include <stdio.h>
#include <io.h>           /* for access */

int CopyFile (char* source, char* destination)
{
    FILE *sfptr, *tfptr;
    int  c;

    /* Look if the destination does not already exists. */
    if (access(destination, 0) == 0)
       return 0;

    sfptr = fopen(source, "rb");
    if (sfptr == NULL)
       return 0;

    tfptr = fopen(destination, "wb");
    if (tfptr == NULL)
    {
       fclose(sfptr);
       return 0;
    }

    while ((c = fgetc(sfptr)) != EOF)
    {
      if (fputc(c, tfptr) == EOF)
      {
         fclose(sfptr);
         fclose(tfptr);
         if (access(destination, 0) == 0) remove (destination);
         return 0;
      }
    }

    fclose (sfptr);
    fclose (tfptr);
    return 1;
}

