/*
   DISKCOPY.EXE, floppy diskette duplicator similar to MSDOS Diskcopy.
   Copyright (C) 1998, Matthew Stanford.
   Copyright (C) 1999, 2000, Imre Leber.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have recieved a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


   If you have any questions, comments, suggestions, or fixes please
   email me at:  ilebr@vub.ac.be

*/

#include "diskcopy.h"
#include "tdrvcpy.h"
#include "memtypes.h"
#include "waitfinp.h"
#include "drive.h"

#include <bios.h>
#include <dos.h>
#include <ctype.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>

void TwoDriveCopy (int sourcedrv, int destdrv, int bel, int fallthrough,
		   int askdisk)
{
     int      answer;
     char     buffer[BYTESPERSECTOR*20];
     struct   dfree free;
     int      sector;
     unsigned long disksize, endsector, total;

     answer = 'Y';

     while (answer == 'Y')
     {
	   if (askdisk)
	   {
	      printf("\nPut source diskette in drive %c:\n", sourcedrv + 'A');
	      printf("Put destination diskette in drive %c:\n", destdrv + 'A');
	      printf("\nPress any key to continue...");
	      WaitForInput();
	   }
	   askdisk = TRUE;

	   for (;;)
	   {
	       getdfree (sourcedrv+1, &free);
	       free.df_total = GetFullClusterCount(sourcedrv+1);
	       if (free.df_total == 0)
	       {
		  printf("\nInvalid drive specification or non removable media.\n");
		  exit(INITERROR);
	       }
	       total    = free.df_total * free.df_sclus;
	       disksize = total * free.df_bsec;

	       if (free.df_total == GetFullClusterCount(destdrv+1)) break;

	       puts ("\n\nDiskette does not have the same capacity as the original.");
	       printf("Put a diskette with the right capacity in drive %c: or %c:, \n",
		      sourcedrv + 'A', destdrv + 'A');
	       puts("or press CTRL-C to cancel.");
	       WaitForInput();
	   }

	   printf("\nCopying %d clusters, %d sectors per cluster, %d bytes per sector\n"
		  "Drive size is %ld bytes.",
		  free.df_total, free.df_sclus, free.df_bsec, disksize);

	   endsector = free.df_total * free.df_sclus;

	   for (sector = 0; sector < endsector; sector+=20)
	   {
		 if (absread(sourcedrv, 20, sector, buffer) != 0)
		 {
		    puts("\nError reading from drive.");
		    exit(CRITICAL);
		 }

		 if (abswrite(destdrv, 1, sector, buffer) != 0)
		 {
		    puts("\nError writing to drive.");
		    exit(CRITICAL);
		 }
	   }

	   if (bel) Beep();

	   answer = (fallthrough) ? 'N' : 'X';
	   while ((answer != 'Y') && (answer != 'N')) 
	   {
		printf("\nDo you want to copy two other diskettes (y/n)?\n");

		answer = toupper(getch());
	   } 
     }
}

int BiosReportsTwoDrives ()
{
     int configuration = biosequip();

     if (configuration & 1)                  /* At least one floppy drive. */
	if (((configuration >> 6) & 3) >= 1)
	   return 1;
	else
	   return 0;
     else
	return 0;
}
