/*
   DISKCOPY.EXE, floppy diskette duplicator similar to MSDOS Diskcopy.
   Copyright (C) 1998, Matthew Stanford.
   Copyright (C) 1999, Imre Leber.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have recieved a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


   If you have any questions, comments, suggestions, or fixes please
   email me at:  ilebr@vub.ac.be

   [Doesn't work if you don't have a C: hard disk - Changed by Imre Leber]

*/

#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>

#include "drive.h"
#include "diskcopy.h"

int main(int argc, char *argv[])
{
   int    i;
   int    audible;
   struct fatinfo sfat;
   char   buf[32768];
   char   tempfile[128];
   char   loop1, loop2;
   char   sdrive, tdrive;
   char*  tempvar;
   int    handle;
   unsigned long sector, total;

   audible = 0;

   /* Check arguments */
   if ((argc == 2) && (strcmp(argv[1], "/?") == 0))
   {
      ShowHelp ();
      return COPYSUCCESS;
   }
   else if ((argc < 3) || !HasFloppyForm(argv[1]) || !HasFloppyForm(argv[2]))
   {
      /* The way (DR and MS) DOS does it. */
      printf("Invalid drive specification or non removable media.\n");
      return INITERROR;
   }
   else
   {
      for (i = 3; i < argc; i++)
	  if ((strcmp(argv[i], "/a") == 0) || /* DOS is case insensitive. */
	      (strcmp(argv[i], "/A") == 0))
	     audible = 1;
	  else
	  {
	     if (argv[i][0] == '/')
		printf ("Invalid switch: %s\n", argv[i]);
	     else
		printf("Too many parameters: %s\n", argv[i]);
	     return INITERROR;
	  }
    }

   loop1 = 'Y';   /* initialize loop1         */
   loop2 = 'Y';   /* initialize loop2         */
   setcbrk(1);    /* set control-break to ON  */

   sdrive = (char) toupper(argv[1][0]) - 65;
   tdrive = (char) toupper(argv[2][0]) - 65;

   while (loop1 != 'N') //loop1
   {
      tempvar = getenv("temp");
      if (!tempvar) tempvar = getenv("TEMP");
      if (tempvar)
	 strcpy(tempfile, tempvar);
      else
	 strcpy(tempfile, "C:\\");
      handle = creattemp(tempfile, 0);

      if (audible) Beep();

      printf("\nInsert SOURCE diskette into drive %s \n", argv[1]);
      printf("\nPress any key to continue . . .\n");
      getch();
      getfat(sdrive+1, &sfat);
      total = (sfat.fi_nclus * sfat.fi_sclus);

      printf("\nCopying %d clusters, %d sectors per cluster, %d bytes per sector\n"
	     "Drive size is %ld bytes.  Disk ID is %d.\n",
	      sfat.fi_nclus, sfat.fi_sclus, sfat.fi_bysec,
	      (total * sfat.fi_bysec), sfat.fi_fatid);

      printf("\nReading SOURCE diskette . . .\n");

      handle = open(tempfile, O_WRONLY | O_BINARY);
      for(sector = 0; sector < total; sector = sector + 64)
      {
	 absread(sdrive, 64, sector, buf);
	 write(handle, buf, 32768);
      }
      close(handle);

      while (loop2 != 'N') //loop2
      {
	 if (audible) Beep();
	 printf("\nInsert TARGET diskette into drive %s \n", argv[2]);
	 printf("\nPress any key to continue . . .\a\n");
	 getch();
	 printf("\nWriting to TARGET diskette in drive . . .\n");

	 handle = open(tempfile, O_RDONLY | O_BINARY);
	 for(sector = 0; sector < total; sector = sector + 64)
	 {
	    read(handle, buf, 32768);
	    abswrite(tdrive, 64, sector, buf);
	 }
	 close(handle);

	 loop2 = 'X';
	 while ((loop2 != 'N') && (loop2 != 'Y')) //Changed by Imre Leber
	 {
	    if (audible) Beep();
	    printf("\nDo you want another copy of this disk (Y/N)?\n");
	    loop2 = toupper(getch());
	 }

      }//end loop2
      loop2 = 'X';
      remove(tempfile);

      loop1 = 'X';
      while ((loop1 != 'N') && (loop1 != 'Y')) //Changed by Imre Leber
      {
	 if (audible) Beep();
	 printf("\nCopy another disk (Y/N)?\n");
	 loop1 = toupper(getch());
      }
   }//end loop1

   return COPYSUCCESS;
}

void ShowHelp ()
{
   puts("Diskcopy <source> <destination> [/a]\n"
	"\n"
	"source:      drive to be copied from.\n"
	"destination: drive to be copied to.\n"
	"\n"
	"/a : give an audible warning for disk change.");
}

void Beep()
{
  sound(600);
  delay(100);
  nosound();
}