/* $Id: MCB.H 2.5 2001/10/13 18:45:37 ska Exp ska $
 * $Locker: ska $	$Name:  $	$State: Exp $
 *
 * header file for the MCB handling functions

 * $Log: MCB.H $
 * Revision 2.5  2001/10/13 18:45:37  ska
 * bugfix: psp.h: lastStack is far pointer
 * bugfix: suppl.h: dpeekc/b(): wrong (idx)
 * bugfix: to*Upper(): accept negative characters
 * add: env_clear()
 * chg: suppl_testMemChain() to use mcb_walk() and internal check of MCB
 * add: mcb_first()
 * bugfix: (void far*)_fnormalize() ignores the macro'ed (void huge*) cast
 * bugfix: _fstrcpy(): uses length of destination
 * fix: env_forall(): if the callback function removes the current
 * 	variable and the environment becomes shortened, the loop stops instead
 * 	of to advance to the strings area
 * add: StrFUpr(), MemFUpr()
 * fix: _getdcwd(): warning about getdisk() for non-Micro-C
 *
 * Revision 2.4  2001/02/27 01:29:34  ska
 * add: SUPPLDBG.H: SUPPL_ALWAYS_DEBUG_(MEMORY|HEAP) to bypass NDEBUG
 * bugfix: env_freeCount() wrong fct_name in DBG_ENTER()
 * bugfix: env_appVar() unbuffered return macro
 * bugfix: appNameEx() unbuffered return macro
 * add: DBG_TERMINATE() && DBG_EXIT_CODE
 * add: various chkMem macros to appropritate places in env_*.c
 * add: testMemChain() within chkHeap macro to test the DOS Memory Chain
 * bugfix: _fstrchr(x, 0) does not find the '\0'
 * add: _fmemchr
 * chg: solved several unsigned vs. word types; "word" used for all DOS-
 * 	releated 16bit values
 * ren: mcb.h: renamed OFF_MCB_* --> MCB_OFF_* for cleanessness
 * bugfix: dfnsearch(): empty paths are root dir e.g. 2nd of "A:\;;A:\DOS"
 * fix: dfnmerge(): root directory is stripped on "\q" paths
 * bugfix: getopt*.*: replaced to avoid licensing problems
 * fix: fcopy.c: while() condition wrong [Ron Cemer]
 * add: dfnfull?.c: dfnfullpath() := return fully-qualified path, remove any
 * 	embedded dot-only components, such as "." and ".."; includes a
 * 	Win9x-style variant supporting multiple dots, e.g. "....."
 *
 * Revision 2.3  2000/03/31 09:09:33  ska
 * add: DBG_CLOSELOG, suppl_l_openmode
 * add: SYSLOG_ALWAYS_FLUSHLOG
 * add: fcommit(), Fcommit(), Fflush(), commit()
 * add: suppl_log_flush(), DBG_FLUSHLOG, DBG_ALWAYS_FLUSHLOG
 * fix: dfnsearch(): DBG_ARGUMENT()
 * chg: F[gs]etpos() -> true replacements of f[gs]etpos(); removed
 * 	Fp[gs]etpos(); added FF[gs]etpos() using a non-pointer argument
 * bugfix: secure string functions: memory functions don't accept length == 0
 * add: MKSTRFCT.PL: generate DOC\SSTR.FCT
 * fix: dfnsplit(): a pathname without path components returns the root
 * 	directory as path portion
 * add: dfnsplit(): debug output of return values of found drive/path/name/ext
 * fix: dfnsqueeze(): DBG_ENTER() contains wrong names
 * fix: dfnsplit(): chkHeap in drive spec detection routine breaks if/else
 * chg: moved NLS-depended stuff from DFN.H into NLS_F.H
 * add: integer SUPPL error codes -- all functions returning (int) error codes
 * 	return unique codes used throughout all SUPPL, see ERRCODES.H
 *
 * Revision 2.2  1999/12/13 02:23:43  ska
 * add: debug subsystem
 * bugfix: Fposcmp(): If abs(pos1 - pos2) > 32767, the return value is random
 * add: strend() --> returns the address of the NUL byte of a string
 * chg: StrAppend() --> StrAppQStr()
 * add: StrQuote(), StrUnquote()
 * bugfix: Strspn(): if any parameter is NULL, returns NULL now
 * bugfix: MemiCmp(): returned wrong sign
 * bugfix: dfnstat(): Win95 LFN's entry never or invalidly detected
 * add: dfndelim() & dfndelim2()
 * chg: environ.h: mcb_toenv() --> macro mcb_env()
 * fix: cfg_osen.c: cfg_ostkEnum(): If output stack empty --> random return value
 * fix: strnum(): '0x' prefix detection fails
 * chg: long*(): Except longcmp() all functions are void; for portable subsys
 * bugfix: Erealloc(): if len == 0, the program is terminated erroreously
 * add: Fcopyi() & Fcopyl() & Fcopybuf()
 * chg: Fcopyto(): 'topos' must contain a valid position returned by Fgetpos()
 * add: supplio.h: Fpos2dword() & Fppos2dword(): Extract (dword) pos from(fpos_t)
 * chg: env_newsize() renamed into env_setsize()
 * bugfix: env_check(): accepts no segm==0, as it is standard
 * sub: dynstr.h: STR_SAVE_MODES, not used anymore (StrSaveTokens() removed)
 * chg: dynstr.h: STR_SAVED_TOKENS is its own type now
 * bugfix: StrTok*(): if(st) effects first assignment only
 * bugfix: StrTail(): string is strdup()'ed two times
 * bugfix: _fStriCmp(): temporary storage into (char) is unportable
 * bugfix: StriCmp(): sign is inverted
 * bugfix: StriCmp(): accepts no NULL parameters
 * add: DFN_LFN to dfn.h and dfnstat()
 * bugfix: UNC-aware dfnmatch2(): function name wrong
 * sub: removed "Target compilers" note everywhere
 * fix: dfnstat(): returns DFN_DIRECTORY on "X:" and "X:\"
 * chg: No SUPPL function will invoke openlog() automatically
 *
 * Revision 2.1  1996/11/08 03:18:16  ska
 * chg: Makefile: automatically detect, when switching compiler or mem model etc.
 * fix: mcb_walk: evaluating _FLAGS after destroying them by a compare
 * add: env_noSpace: check if environment can hold another variable
 * fix: env_change: don't delete the variable if environment too small
 * fix: env_strput: check env size, f a new string is appended
 * chg: environ.h: prototype: putenv(char *var) to conform to DOS quasi-standard
 *
 * Revision 2.0  1996/08/01 08:22:35  ska
 * Release Version 2
 *
 * Target compilers: Micro-C, Borland C v2.0, v3.1, v4.52
 *
 * Revision 1.1  1996/05/19 03:43:03  ska
 * Initial revision
 *
*/

#ifndef __MCB_H
#define __MCB_H

#include <portable.h>

#define SEG2MCB(segm) ((segm) - 1)
#define MCB2SEG(mcb) ((mcb) + 1)

	/* Don't use this constant; use SEG2MCB() or MCB2SEG() instead */
#define SEG_OFFSET 0x10

word mcb_env(const word segm);
#ifdef NDEBUG
#define mcb_env(mcb) peekw((mcb), SEG_OFFSET + 0x2c)
#endif

#include <algnbyte.h>
struct MCB {
	byte mcb_type;		/* type of MCB, 'Z': no following MCB, 'M': following */
	word mcb_ownerPSP;	/* PSP number of owner of this block */
	word mcb_size;		/* size of this MCB */
	byte mcb_rsrvd[3];	/* unused */
	byte mcb_name[8];	/* name of program file name if PSP created in exec() */
};
#include <algndflt.h>
struct SUPPL_verify_alignment_MCB {
	char x[sizeof(struct MCB) == 16 ? 1 : -1];
};
	/* Don't use these constant; use offsetof(struct MCB, xxx) instead */
#define MCB_OFF_TYPE 0
#define MCB_OFF_OWNER 1
#define MCB_OFF_SIZE 3
#define MCB_OFF_NAME 8

#ifdef _MICROC_
#define MCB_WALKFUNC int *
#else
typedef int (*MCB_WALKFUNC)(void *, word);
#endif

unsigned mcb_length(const word segm);
int mcb_walk(word mcb, const MCB_WALKFUNC fct, void * const arg);
int isShell(const word mcb);
int isPSP(const word mcb);
int isMCB(const word mcb);
int isEnv(const word mcb);
word nxtMCB(word mcb);
int mcb_allParents(word mcb, MCB_WALKFUNC fct, void *arg);
word mcb_primaryShell(void);
word mcb_owner(word mcb);
word mcb_shell(word mcb);
word mcb_first(void);

#endif
