/* $Id: FMEMORY.H 2.8 2001/10/13 18:45:36 ska Exp ska $
   $Locker: ska $	$Name:  $	$State: Exp $

	Far memory handling function.

   $Log: FMEMORY.H $
   Revision 2.8  2001/10/13 18:45:36  ska
   bugfix: psp.h: lastStack is far pointer
   bugfix: suppl.h: dpeekc/b(): wrong (idx)
   bugfix: to*Upper(): accept negative characters
   add: env_clear()
   chg: suppl_testMemChain() to use mcb_walk() and internal check of MCB
   add: mcb_first()
   bugfix: (void far*)_fnormalize() ignores the macro'ed (void huge*) cast
   bugfix: _fstrcpy(): uses length of destination
   fix: env_forall(): if the callback function removes the current
   	variable and the environment becomes shortened, the loop stops instead
   	of to advance to the strings area
   add: StrFUpr(), MemFUpr()
   fix: _getdcwd(): warning about getdisk() for non-Micro-C

   Revision 2.7  2001/02/27 01:29:33  ska
   add: SUPPLDBG.H: SUPPL_ALWAYS_DEBUG_(MEMORY|HEAP) to bypass NDEBUG
   bugfix: env_freeCount() wrong fct_name in DBG_ENTER()
   bugfix: env_appVar() unbuffered return macro
   bugfix: appNameEx() unbuffered return macro
   add: DBG_TERMINATE() && DBG_EXIT_CODE
   add: various chkMem macros to appropritate places in env_*.c
   add: testMemChain() within chkHeap macro to test the DOS Memory Chain
   bugfix: _fstrchr(x, 0) does not find the '\0'
   add: _fmemchr
   chg: solved several unsigned vs. word types; "word" used for all DOS-
   	releated 16bit values
   ren: mcb.h: renamed OFF_MCB_* --> MCB_OFF_* for cleanessness
   bugfix: dfnsearch(): empty paths are root dir e.g. 2nd of "A:\;;A:\DOS"
   fix: dfnmerge(): root directory is stripped on "\q" paths
   bugfix: getopt*.*: replaced to avoid licensing problems
   fix: fcopy.c: while() condition wrong [Ron Cemer]
   add: dfnfull?.c: dfnfullpath() := return fully-qualified path, remove any
   	embedded dot-only components, such as "." and ".."; includes a
   	Win9x-style variant supporting multiple dots, e.g. "....."

   Revision 2.6  2000/07/13 07:43:05  ska
   bugfix: COMPILER\*\COMPILE.BAT: Dyn_src ignored, but dynamic sources
   	removed even ??fc_*.c

   Revision 2.5  2000/07/10 14:13:58  ska
   fix: missing prototype of env_setsize()
   chg: in all argument declarations "var[]" --> "* const var" (TC++1 support)
   chg: far memory subsystem (TC++1 support -- doesn't include any _f*() )
   add: TCP101 support (Ron Cemer)
   add: INITSUPL.LOC: _TC_LATER_ and _TC_EARLY_ for pre-TC3 versions of Turbo C
   	and Turbo C++ v1.01

   Revision 2.4  2000/03/31 09:09:33  ska
   add: DBG_CLOSELOG, suppl_l_openmode
   add: SYSLOG_ALWAYS_FLUSHLOG
   add: fcommit(), Fcommit(), Fflush(), commit()
   add: suppl_log_flush(), DBG_FLUSHLOG, DBG_ALWAYS_FLUSHLOG
   fix: dfnsearch(): DBG_ARGUMENT()
   chg: F[gs]etpos() -> true replacements of f[gs]etpos(); removed
   	Fp[gs]etpos(); added FF[gs]etpos() using a non-pointer argument
   bugfix: secure string functions: memory functions don't accept length == 0
   add: MKSTRFCT.PL: generate DOC\SSTR.FCT
   fix: dfnsplit(): a pathname without path components returns the root
   	directory as path portion
   add: dfnsplit(): debug output of return values of found drive/path/name/ext
   fix: dfnsqueeze(): DBG_ENTER() contains wrong names
   fix: dfnsplit(): chkHeap in drive spec detection routine breaks if/else
   chg: moved NLS-depended stuff from DFN.H into NLS_F.H
   add: integer SUPPL error codes -- all functions returning (int) error codes
   	return unique codes used throughout all SUPPL, see ERRCODES.H

   Revision 2.3  1998/12/04 06:00:44  ska
   add: fpos_t/fsetpos()/fgetpos() to PAC
   bugfix: DOSalloc(): If called with length == 0, the allocation
   	strategy is not resetted
   bugfix: env_newsize(): Grow block, if fails completely, the old environment
   	was destroyed unneceesaryly
   add: getbootdisk()
   add: Ftmpfile(), Ftmpnam(), Etmpfile()
   add: dfnstat(), dfnmktmp()
   add: dfnwrdir(), dfnstat(), dfnmkfile()
   fix/chg: StrTrim(): returns "s" if realloc() fails
   fix: _getdcwd(): removed Carry()
   bugfix: dfnsqueeze(): In non-UNC mode, there was nothing actually
   	sequeezed, except the slashes were flipped
   add: env_fetch(): DOS-ish getenv()
   add: _fdupstr(): Duplicates far string into local heap

   Revision 2.2  1998/08/05 09:42:22  ska
   Release Version 2.5:

   chg: getopt() to not depend on msglib
   add: portable.h: getvect(), setvect(), isr
   chg: moving _f*() memory/string function declarations into fmemory.h
   bugfix: env_size.c: env_newsize(): shrinking causes unpredictable results
   add: _fmemcmp(), _fnormalize(), _fmemmove() for PAC
   add: dta.c/suppl.h: setdta()/getdta()
   add: suppl.h/filefind.c: findfirst()/findnext()/ffblk for PAC
   add: _getdcwd.c: Pacific C version
   add: suppl.h: settings for Pacific C, incl. (struct REGPACK)
   chg: all *.c files include INITSUPL.INC as the very first
   	line after the welcome header. This will setup various
   	compiler depend macros (e.g. _PAC_NOCLIB_)
   add: setdisk.c, getdisk.c, osvers.c: for Pacific C
   add: portable.h: various settings: Support for Pacific C v7.51

   Revision 2.1  1996/11/08 03:18:16  ska
   chg: Makefile: automatically detect, when switching compiler or mem model etc.
   fix: mcb_walk: evaluating _FLAGS after destroying them by a compare
   add: env_noSpace: check if environment can hold another variable
   fix: env_change: don't delete the variable if environment too small
   fix: env_strput: check env size, f a new string is appended
   chg: environ.h: prototype: putenv(char *var) to conform to DOS quasi-standard

   Revision 2.0  1996/08/01 08:22:35  ska
   Release Version 2

   Target compilers: Micro-C, Borland C v2.0, v3.1, v4.52

   Revision 1.3  1996/07/29 06:53:45  ska
   add: DOSalloc(), addu()
   chg: newenv(), sizenv()

   Revision 1.2  1996/07/25 06:34:48  ska
   fix: (signed) cast bug in suppl.h

   Revision 1.1  1996/05/19 03:43:03  ska
   Initial revision

*/

#ifndef __FMEMORY_H
#define __FMEMORY_H

#include <SUPL_DEF.H>

#ifdef _MICROC_				/* for use for Micro-C only */

#define MK_FP(seg,ofs) (seg), (ofs)
#define TO_FP(var) get_ds(), (var)
#define _fnormalize(seg,ofs) _fnormalize_(&(seg), &(ofs))

#else	/* !_MICROC_ */

#ifdef _TC_LATER_
#include <string.h>

#else
#if defined(_PAC_NOCLIB_) || defined(_TC_EARLY_)

#ifdef _PAC_NOCLIB_
#include <stdlib.h>
#define _fmemcpy farmemcpy
#define _fmemset farmemset

#else
void _fmemcpy(void far * const dst, const void far * const src, unsigned length);
void _fmemset(void far * const dst, int ch, unsigned length);
#endif

unsigned _fstrlen(const char far * const s);
char far *_fstrchr(const char far * const s, int ch);
char far *_fmemchr(const char far * const s, int ch, unsigned length);
void _fmemmove(void far * const dst, const void far * const src, unsigned length);
int _fmemcmp(const void far * const dst, const void far * const src, unsigned length);
int _fmemicmp(const void far * const dst, const void far * const src, unsigned length);
int _fstrcmp(const char far * const dst, const char far * const src);
int _fstricmp(const char far * const dst, const char far * const src);
void _fstrcpy(char far * const dst, const char far * const src);

#endif
#endif		/* _TC_LATER_ */

#if defined(HI_TECH_C) || defined(_TC_EARLY_)
#endif
	/* HiTech C has no huge pointers
	 & early Turbo C does ignore the cast */
	/* In some circumstances any Borland C compiler do ignore the
		cast, so the macro is not suitable */
void far *_fnormalize(void far *poi);
/* #define _fnormalize(poi) ((void huge *)(poi)) */

char *_fdupstr(const char far * const s);
#endif

#ifdef _MICROC_
unsigned _fstpcpy(unsigned const dseg, unsigned dofs
 , unsigned const sseg, unsigned sofs, unsigned length)
#else
char far* _fstpcpy(char far* const dst, const char far* const src);
#endif

#endif
