/*
 * REN.C - rename command
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 */

#include "config.h"

#ifdef INCLUDE_CMD_RENAME

#include <assert.h>
#include <stdio.h>
#include "command.h"

/*
 *  simple file rename internal command.
 *
 */
#pragma argsused
int cmd_rename(char *rest)
{
  char *arg[2];

	assert(rest);

  /* set the first argument */
  arg[0] = rest;

  /* split off the first argument and get the second argument start */
  arg[1] = parse_firstarg(rest);

  /* check if there are the wrong number of arguments */
  if (!arg[0][0] || !arg[1] || parse_firstarg(arg[1]) != NULL)
  {
    error_too_many_parameters(rest);
    return 1;
  }
  else if (rename(arg[0], arg[1]) != 0)
  {
    perror("rename");
    return 1;
  }

  return 0;
}

#endif
