/*
 *  ECHO.C - echo command.
 *
 *  Comments:
 *
 * 16 Jul 1998 (Hans B Pufal)
 *   started.
 *
 * 16 Jul 1998 (John P Price)
 *   Seperated commands into individual files.
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 *
 */

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "command.h"
#include "batch.h"
#include "strings.h"

#pragma argsused
int cmd_echo(char *param)
{
  /*
   * Perform ECHO command.
   *
   */

  if (stricmp(param, D_OFF) == 0)
    echo = 0;
  else if (stricmp(param, D_ON) == 0)
    echo = 1;
  else if (*param)
    puts(param);
  else
    display_string(TEXT_MSG_ECHO_STATE, echo ? D_ON : D_OFF);

  return 0;
}
