/*
 * ERROR.C -- Error reporting functions
 *
 * 07/12/98 (Rob Lake)
 *      started
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 */

#include "config.h"

#include <stdio.h>
#include "command.h"

#define INVALID_SWITCH      "Invalid switch - /%c\n"
#define TOO_MANY_PARAMETERS "Too many parameters - %s\n"
#define PATH_NOT_FOUND      "Path not found\n"
#define FILE_NOT_FOUND      "File not found"
#define REQ_PARAM_MISSING   "Required parameter missing\n"
#define INVALID_DRIVE       "Invalid drive specification\n"
#define BADCOMMAND          "Bad command or filename\n"
#define OUT_OF_MEMORY       "Out of memory error.\n"
#define CANNOTPIPE      "Error!  Cannot pipe!  Cannot open temporary file!\n"

#define D_PAUSEMSG   "Press any key to continue . . ."


void error_invalid_switch(char c)
{
  fprintf(stderr, INVALID_SWITCH, c);
}

void error_too_many_parameters(char *s)
{
  fprintf(stderr, TOO_MANY_PARAMETERS, s);
}

void error_path_not_found(void)
{
  fprintf(stderr, PATH_NOT_FOUND);
}

void error_file_not_found(void)
{
  fprintf(stderr, FILE_NOT_FOUND);
}

void error_sfile_not_found(char *f)
{
  fprintf(stderr, FILE_NOT_FOUND " - %s\n", f);
}

void error_req_param_missing(void)
{
  fprintf(stderr, REQ_PARAM_MISSING);
}

void error_invalid_drive(void)
{
  fprintf(stderr, INVALID_DRIVE);
}

void error_bad_command(void)
{
  fprintf(stderr, BADCOMMAND);
}

void error_no_pipe(void)
{
  fprintf(stderr, CANNOTPIPE);
}

void error_out_of_memory(void)
{
  fprintf(stderr, OUT_OF_MEMORY);
}

void error_syntax(char *s)
{
  if (s)
    fprintf(stderr, "Syntax error - %s\n", s);
  else
    fprintf(stderr, "Syntax error.\n");
}

void msg_pause(void)
{
  puts(D_PAUSEMSG);
}

