/*
 *  CALL.C - batch file call command.
 *
 *  Comments:
 *
 * 16 Jul 1998 (Hans B Pufal)
 *   started.
 *
 * 16 Jul 1998 (John P Price)
 *   Seperated commands into individual files.
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 * 04-Aug-1998 (Hans B Pufal)
 * - added lines to initialize for pointers (HBP004)  This fixed the
 *   lock-up that happened sometimes when calling a batch file from
 *   another batch file.
 *
 */

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "command.h"
#include "batch.h"

int cmd_call(char *cmd, char *param)
{
/*
 * Perform CALL command.
 *
 * Allocate a new batch context and add it to the current chain.
 * Call parsecommandline passing in our param string
 * If No batch file was opened then remove our newly allocted
 * context block.
 */

  dprintf(("CMD '%s' : '%s'\n", cmd, param));

  if (strcmp(param, "/?") == 0)
  {
    printf("%s :\n", cmd);
    return 0;
  }

  {
    struct bcontext
     *n = (struct bcontext *)malloc(sizeof(struct bcontext));

    if (n == NULL)
    {
      error_out_of_memory();
      return 1;
    }

    n->prev = bc;
    bc = n;

    bc->bfile = NULL;
    bc->params = NULL;
    bc->shiftlevel = 0;
    bc->forvar = 0;        /* HBP004 */
    bc->forproto = NULL;   /* HBP004 */

    parsecommandline(param);

    if (bc->bfile == NULL)      /* Wasn't a batch file so remove conext */
    {
      bc = bc->prev;
      free(n);
    }
  }

  return 0;
}
