/* COMMAND.H
 * header file for the modules in COMMAND.COM
 * Tim Norman
 * 7-15-95
 *
 * 06/29/98 (Rob Lake)
 *      - Moved error messages in here
 */

#define EnvSeg (*(unsigned far*)MK_FP(_psp, 0x2c))
#define OwnerPSP (*(unsigned far *)MK_FP(_psp, 0x16))

#define BREAK_BATCHFILE 1
#define BREAK_OUTOFBATCH 2
#define BREAK_INPUT 3
#define BREAK_IGNORE 4

/* error messages */
#define TOO_MANY_PARAMETERS "Too many parameters - %s\n"
#define INVALID_SWITCH "Invalid switch - /%c\n"
#define PATH_NOT_FOUND "Path not found\n"
#define FILE_NOT_FOUND "File not found\n"
#define REQ_PARAM_MISSING "Required parameter missing\n"

/* prototypes for COMMAND.C */
extern int ctrlBreak;
extern int exitflag;
extern int errorlevel;
extern unsigned far *maxx;
extern unsigned char far *maxy;

void fatal_error(char *);
char is_delim(char);
void execute(char *, char *);
void command(char *);
void parsecommandline(char *);
int process_input(void);
int c_brk(void);
void initialize(int, char *[]);

/* prototypes for INTERNAL.C */
int dir(char *, char *);
int cd(char *, char *);
int md(char *, char *);
int rd(char *, char *);
int set(char *, char *);
int ver(char *, char *);
int del(char *, char *);
int ren(char *, char *);
int internal_exit(char *, char *);
int rem(char *, char *);
int doskey(char *, char *);
int prompt(char *, char *);
int path(char *, char *);
int cmd_date(char *, char *);   /*JPP 07/08/1998 */
int cmd_time(char *, char *);   /*JPP 07/08/1998 */
int cmd_type(char *, char *);   /*JPP 07/08/1998 */

int chkCBreak(int);
int cgetchar(void);

/* prototypes for ENVIRON.C */
void show_environment(void);

/* prototypes from PROMPT.C */
void printprompt(void);

/* prototypes for CMDINPUT.C */
void readcommand(char *, int);

/* prototypes for BATCH.C */
int batch(char *, char *);
int _getch(void);

/* prototypes for WHERE.C */
void get_paths(char *[129]);
int find_which(char *[129], char *, char *);

/* prototypes for EXEC.C */
int exec(const char *, char *, const unsigned);

/* prototypes for REDIR.C */
void get_redirection(char *, char *, char *, char *[128], int *);

/* prototypes for LOADHIGH.C */
int loadhigh(char *, char *);
int loadfix(char *, char *);

/* prototypes for ALIAS.C */
void aliasexpand(char *, int);
int aliasswapout(void);
int aliasswapin(void);
int alias(char *, char *);
