/*
 *  GOTO.C - goto command.
 *
 *  Comments:
 *
 * 16 Jul 1998 (Hans B Pufal)
 *   started.
 *
 * 16 Jul 1998 (John P Price)
 *   Seperated commands into individual files.
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 * 28 Jul 1998 (Hans B Pufal) [HBP_003]
 *   Terminate label on first space character, use only first 8 chars of
 *   label string
 *
 */

#include "config.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "command.h"
#include "batch.h"

int cmd_goto(char *cmd, char *param)
{
/*
 * Perform GOTO command.
 *
 * Only valid if batch file current.
 *
 */

  char *tmp;

  dprintf(("CMD '%s' : '%s'\n", cmd, param));

  if (strcmp(param, "/?") == 0)
  {
    printf("%s :\n", cmd);
    return 0;
  }

  if (bc == NULL)
  {
    /*!! not in batch error */

    return 1;
  }

  if (*param == '\0')
  {
    exit_batch("No label specified for GOTO\n");
    return 1;
  }

/* { HBP_003 : terminate label at first space char */

  tmp = param;
  while (*tmp && !isspace (*tmp))
    tmp++;
  *tmp = '\0';

/* HBP_003 ) */

  rewind(bc->bfile);

  while (fgets(textline, sizeof(textline), bc->bfile) != NULL)
  {
    /* Strip out any trailing spaces or control chars */

    tmp = textline + strlen(textline) - 1;
    while (iscntrl(*tmp) || isspace(*tmp))
      tmp--;
    *(tmp + 1) = '\0';

    /* Then leading spaces... */

    tmp = textline;
    while (isspace(*tmp))
      tmp++;

/* { HBP_003 : use only 1st 8 chars of label */

    if ((*tmp == ':') && (strncmp(++tmp, param, 8) == 0))
      return 0;

/* HBP_003 }  */
  }

  printf("Label '%s' not found\n", param);
  exit_batch(NULL);
  return 1;
}
