/*
 *  DATE.C - date internal command
 *
 *  Comments:
 *
 *  07/08/1998 (John P. Price)
 *    started.
 *
 *
 */

#include <stdio.h>
#include <dos.h>
#include <ctype.h>
#include <string.h>

#include "command.h"

static unsigned char months[2][13] =
{
  {0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 30},
  {0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 30}
};

static unsigned char *dowstring[7] =
{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

int
parsedate(char *s)
{
  struct date d;
  unsigned char leap;

  if (!*s)
    return 1;

  d.da_year = 0;
  d.da_day = 0;
  d.da_mon = 0;

  // first get mon
  if (isdigit(*s))
  {
    while (isdigit(*s))
      d.da_mon = d.da_mon * 10 + (*s++) - '0';
  }
  else
    return 0;

  // get divider
  if (*s == '/' || *s == '-')
    s++;
  else
    return 0;

  // now get day
  if (isdigit(*s))
  {
    while (isdigit(*s))
      d.da_day = d.da_day * 10 + (*s++) - '0';
  }
  else
    return 0;

  // get divider
  if (*s == '/' || *s == '-')
    s++;
  else
    return 0;

  // now get year
  if (isdigit(*s))
  {
    while (isdigit(*s))
      d.da_year = d.da_year * 10 + (*s++) - '0';
  }
  else
    return 0;

  //if only entered two digits, assume 1900's
  if (d.da_year >= 0 && d.da_year <= 99)
    d.da_year = 1900 + d.da_year;

  leap = (!(d.da_year % 4) && (d.da_year % 100)) || !(d.da_year % 400);

  if ((d.da_mon >= 1 && d.da_mon <= 12) &&
      (d.da_day >= 1 && d.da_day <= months[leap][d.da_mon]) &&
      (d.da_year >= 1980 && d.da_year <= 2099))
  {
    setdate(&d);
    return 1;
  }

  return 0;
}

int
cmd_date(char *first, char *rest)
{
  char s[40];

  if (strcmp(rest, "/?") == 0)
  {
    puts(
          "Displays or sets the date.\n\n"
          "DATE [date]\n\n"
    "Type DATE without parameters to display the current date setting and\n"
          "a prompt for a new one.  Press ENTER to keep the same date."
        );
    return 0;
  }

  if (!*rest)
  {
    struct dosdate_t d;

    _dos_getdate(&d);

    printf("Current date is %s %02d-%02d-%d\n",
           dowstring[d.dayofweek], d.month, d.day, d.year);
  }

  while (1)                     //forever loop

  {
    if (!*rest)
    {
      printf("Enter new date (mm-dd-yy): ");
      fgets(s, sizeof(s), stdin);
      while (*s && s[strlen(s) - 1] < ' ')
        s[strlen(s) - 1] = '\0';
      if (parsedate(s))
        return 0;
    }
    else
    {
      if (parsedate(rest))
        return 0;
      // force input the next time around.
      *rest = '\0';
    }
    printf("Invalid date.\n");
  }
}
