; A tool for APM power management in FreeDOS.
; Copyright Eric Auer 2003. Please do not spread - just send
; me (NASM) CODE to complete the project! When done, you will
; be credited and the project will be released under GPL 2.
; Please read apmnotes.txt for an outline of the workings.

; This file: flushCaches (destroys registers)
; Call to flush all known caches. Writes status to stdout.

cdbflushmsg	db "Flushing CD Blitz cache...$"
pccflushmsg	db "Flushing PC-Cache...$"
qcflushmsg	db "Flushing QuickCache...$"
spckflushmsg	db "Flushing Super PC Kwik / PC-Tools / QCache...$"
sdrv1flushmsg	db "Flushing SMARTDRV.EXE...$"
sdrv2flushmsg	db "Flushing SMARTDRV.SYS...$"
twobyte		db 2
smartname	db "SMARTAAR",0
genflushmsg	db "Resetting DOS filesystem and "
		db "BIOS disk handler.$"

flusherrmsg	db " Flushing command returned an error.",13,10,"$"
flushokmsg	db " done.",13,10,"$"


flushErrorMsg:	; print error or done message depending on carry
	push ax
	push dx
	mov dx,flusherrmsg
	jc yFEM
	mov dx,flushokmsg
yFEM:	mov ah,9
	int 21h
	pop dx
	pop ax
	ret

flushCaches:	; flush all known caches
	; inspired by Aitors APMLIB
	mov ax,1500h
	mov bx,1234h
	mov ch,90h
	int 2fh	; CDBLITZ install check
	cmp cx,1234h
	jnz nCDblitz
	mov dx,cdbflushmsg
	mov ah,9
	int 21h
	mov ax,1500h
	mov bx,1234h
	mov ch,96h
	int 2fh	; CDBLITZ flush
	call flushErrorMsg
nCDblitz:
	mov ax,0ffa5h
	mov cx,1111h
	int 16h	; PC Cache install check
	or cx,cx
	jnz nPCcache
	mov dx,pccflushmsg
	mov ah,9
	int 21h
	mov ax,0ffa5h
	mov cx,0ffffh
	int 16h	; PC Cache flush
	clc	; always works
	call flushErrorMsg
nPCcache:
	mov ah,27h
	xor bx,bx
	int 13h	; Quick Cache install check
	or ax,ax
	jnz nQuickCache
	or bx,bx
	jnz nQuickCache
	mov ah,9
	mov dx,qcflushmsg
	int 21h
	mov ax,0021h
	xor dx,dx
	int 13h	; Quick Cache flush
	; should CY / NC or AX be used for status?
	call flushErrorMsg
nQuickCache:
	mov cx,4358h
	mov ah,2bh
	int 21h	; Super PC Kwik / PC Tools / QCache install check
	or al,al
	jnz nSPCKwik
	mov dx,spckflushmsg
	mov ah,9
	int 21h
	mov ax,00a1h
	xor dx,dx
	mov si,4358h
	int 13h	; Super PC Kwik flush
	call flushErrorMsg
nSPCKwik:
	mov ax,4a10h
	xor bx,bx
	mov cx,0ebabh
	int 2fh	; SMARTDRV.exe install check
	cmp ax,0babeh
	jnz nSdrv1
	mov dx,sdrv1flushmsg
	mov ah,9
	int 21h
	mov ax,4a01h
	mov bx,1
	int 2fh	; SMARTDRV.exe flush
	clc	; always succeeds!?
	call flushErrorMsg
nSdrv1:
	mov ax,3d00h	; open for read: SMARTAAR (device)
	mov dx,smartname
	int 21h		; open handle to device of smartdrv.sys
	jc nSdrv2	; could not open -> no smartdrv.sys
	mov bx,ax	; handle
	push bx
	mov dx,sdrv2flushmsg
	mov ah,9
	int 21h
	pop bx
	mov ax,4403h
	mov cx,0
	mov dx,twobyte
	int 21h	; SMARTDRV.sys flush
	call flushErrorMsg
	; bx still is handle
	mov ah,3eh
	int 21h		; close handle again
nSdrv2:
	mov dx,genflushmsg
	mov ah,9
	int 21h
	mov ah,0dh	; DOS filesystem reset (never fails)
	int 21h
	xor dx,dx	; floppies
	xor ax,ax	; reset disks
	int 13h
	jnc nGen	; do not display "done" twice
	call flushErrorMsg
nGen:	mov dl,80h	; harddisks
	xor ax,ax	; reset disks
	int 13h
	call flushErrorMsg
	;
	ret

