/*
 * sock_init - easy way to guarentee:
 *      - card is ready
 *      - shutdown is handled
 *      - cbreaks are handled
 *      - config file is read
 *      - bootp is run
 *
 * 0.1 : May 2, 1991  Erick - reorganized operations
 */

//#include <copyright.h>
// #include <wattcp.h>
#include <stdlib.h>

word _survivebootp = 0;

void sock_exit()
	{
    tcp_shutdown();
	}

int _sock_init()
{
    if (!tcp_init())            /* must precede tcp_config because we need eth addr */
      return 0;

    atexit(sock_exit);  /* must not precede tcp_init() incase no PD */

    if (tcp_config( NULL )) {   /* if no config file use BOOTP w/broadcast */
        _bootpon = 1;
        outs("Configuring through BOOTP\r\n");
    }

    if (_bootpon)       /* non-zero if we use bootp */
        if (_dobootp()) {
            outs("BOOTP failed\r\n");
            if ( !_survivebootp )
                return 0;
        }
   return 1;
}

int _sock_init_with_parameter(int boot, char *my_ip, char *netmask, 
			      char *ns0, char *ns1, char *gateway, 
			      char *hostname)
{
    if (!tcp_init())            /* must precede tcp_config because we need eth addr */
      return 0;

    atexit(sock_exit);  /* must not precede tcp_init() incase no PD */

    if (boot) {
        if (_dobootp()) {
            if ( !_survivebootp )
                return 0;
        }
    } else {
	if (my_ip && *my_ip) wattcp_set_values("MY_IP", my_ip);
	if (netmask && *netmask) wattcp_set_values("NETMASK", netmask);
	if (ns0 && *ns0) wattcp_set_values("NAMESERVER", ns0);
	if (ns1 && *ns1) wattcp_set_values("NAMESERVER", ns1);
	if (gateway && *gateway) wattcp_set_values("GATEWAY", gateway);
    }
    if (hostname && *hostname) wattcp_set_values("HOSTNAME", hostname);
    return 1;
}
