/*
 * Ethernet Driver Routines
 *
 *  The TCP code uses Ethernet constants for protocol numbers and 48 bits
 *  for address.  Also, 0xffffffffffff is assumed to be a broadcast.
 *
 *  If you need to write a new driver, implement it at this level and use
 *  the above mentioned constants as this program's constants, not device
 *  dependant constants.
 *
 *  The packet driver code lies below this and really ought to be rewritten
 *  in assembly language.
 *
 *  _eth_addr 	 - Ethernet address of this host.
 *  _eth_brdcast - Ethernet broadcast address.
 */

//#include "tcp/include/copyright.h"

/*
*  Ethernet
*/

word inchksum (void *buf, word cnt)
{
register long sum = 0;
register const word *wrd = (const word *) buf;
register long slen = (long)cnt;

while (slen > 1)
{
sum += *wrd++;
slen -= 2;
}

if (slen > 0) sum += *(const byte*)wrd;
while (sum >> 16) sum = (sum & 0xFFFF) + (sum >> 16);
return sum;
}


unsigned long intel(unsigned long tniref)
/**************************************************************************
		swap a 4 byte integer
***************************************************************************/
{
unsigned long tni, tno ;

tni = tniref ;	

// soit abcd la situation initiale
tno=(((tni>>24)&0xff) | ((tni&0xff)<<24) | ((tni&0xff00)<<8)) | ((tni>>8)&0xff00) ;
//        000a        |      d000        |       0c00         |        00b0           
return tno ;	     
}
	
unsigned short intel16(unsigned short tniref)
/**************************************************************************
		swap a 2 byte integer (swap two halves of one 16 bits)
***************************************************************************/
{
unsigned short tni, tno ;

tni = tniref ;	
tno = (((tni & 0x00FF) << 8) | ((tni & 0XFF00) >> 8)) ;
return tno ;	     
}

