/*
Copyright (C) 2001 by Mohan Embar

http://www.thisiscool.com/

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later version. 

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details. 

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA. 
*/

// IMPORTANT NOTE! This source is not used! Catalog.java contains the
// full catalog implementation.

/////////////////////////////////////////////////////////////////////////
// Basic Types

typedef int Boolean;
typedef uint16 UInt16;
typedef uint32 ULong;
typedef uint32 UInt32;
typedef uint16 UInt;
typedef void** VoidHand;

#define StrCompare strcmp

/////////////////////////////////////////////////////////////////////////
// Memory

typedef void* VoidPtr;
typedef void* MemPtr;
typedef void** MemHandle;

MemPtr MemHandleLock(MemHandle h)
{
    return 0;
}

UInt32 MemHandleSize(MemHandle h)
{
    return 0;
}

static void MemHandleUnlock(VoidHand hv)
{
}

/////////////////////////////////////////////////////////////////////////
// Database

typedef void *DmOpenRef;
typedef int DmSearchStateType;
typedef DmSearchStateType *DmSearchStatePtr;
typedef int LocalID;
typedef int Err;

#define	dmErrorClass				0x0200	// Data Manager
#define	dmErrMemError					(dmErrorClass | 1)
#define	dmErrIndexOutOfRange			(dmErrorClass | 2)
#define	dmErrInvalidParam				(dmErrorClass | 3)
#define	dmErrReadOnly					(dmErrorClass | 4)
#define	dmErrDatabaseOpen				(dmErrorClass | 5)
#define	dmErrCantOpen					(dmErrorClass | 6)
#define	dmErrCantFind					(dmErrorClass | 7)
#define	dmErrRecordInWrongCard		(dmErrorClass | 8)
#define	dmErrCorruptDatabase			(dmErrorClass | 9)
#define	dmErrRecordDeleted			(dmErrorClass | 10)
#define	dmErrRecordArchived			(dmErrorClass | 11)
#define	dmErrNotRecordDB				(dmErrorClass | 12)
#define	dmErrNotResourceDB			(dmErrorClass | 13)
#define	dmErrROMBased					(dmErrorClass | 14)
#define	dmErrRecordBusy				(dmErrorClass | 15)
#define	dmErrResourceNotFound		(dmErrorClass | 16)
#define	dmErrNoOpenDatabase			(dmErrorClass | 17)
#define	dmErrInvalidCategory			(dmErrorClass | 18)
#define	dmErrNotValidRecord			(dmErrorClass | 19)
#define	dmErrWriteOutOfBounds		(dmErrorClass | 20)
#define	dmErrSeekFailed				(dmErrorClass | 21)
#define	dmErrAlreadyOpenForWrites	(dmErrorClass | 22)
#define	dmErrOpenedByAnotherTask	(dmErrorClass | 23)
#define  dmErrUniqueIDNotFound		(dmErrorClass | 24)
#define  dmErrAlreadyExists			(dmErrorClass | 25)
#define	dmErrInvalidDatabaseName	(dmErrorClass | 26)

/************************************************************
 * Mode flags passed to DmOpenDatabase
 *************************************************************/
#define	dmModeReadOnly				0x0001		// read  access
#define	dmModeWrite					0x0002		// write access
#define	dmModeReadWrite			0x0003		// read & write access
#define	dmModeLeaveOpen			0x0004		// leave open when app quits
#define	dmModeExclusive			0x0008		// don't let anyone else open it
#define	dmModeShowSecret			0x0010		// force show of secret records

static ULong appCreatorId;

Err DmGetNextDatabaseByTypeCreator
(
    Boolean newSearch,
    DmSearchStatePtr stateInfoP,
    UInt32 type,
    UInt32 creator,
    Boolean onlyLatestVers,
    UInt16* cardNoP,
    LocalID* dbIDP
) 
{
    return 0;
}

Err DmDatabaseInfo
(
    UInt16 cardNo,
    LocalID dbID,
    Char* nameP,
    UInt16* attributesP,
    UInt16* versionP,
    UInt32* crDateP,
    UInt32* modDateP,
    UInt32* bckUpDateP,
    UInt32* modNumP,
    LocalID* appInfoIDP,
    LocalID* sortInfoIDP,
    UInt32* typeP,
    UInt32* creatorP
)
{
    return 0;
}

Err DmOpenDatabaseInfo
(
    DmOpenRef dbP,
    LocalID* dbIDP,
    UInt16* openCountP,
    UInt16* modeP,
    UInt16* cardNoP,
    Boolean* resDBP
) 
{
    return 0;
}

Err DmCreateDatabase
(
    UInt16 cardNo,
    const Char * nameP,
    UInt32 creator,
    UInt32 type,
    Boolean resDB
)
{
    return 0;
}

DmOpenRef DmOpenDatabase
(
    UInt16 cardNo,
    LocalID dbID,
    UInt16 mode
)
{
    return 0;
}

static void DmCloseDatabase(DmOpenRef dmRef)
{
}

Err DmDeleteDatabase(UInt16 cardNo, LocalID dbID)
{
    return 0;
}

UInt16 DmNumRecords(DmOpenRef dbP)
{
    return 0;
}

MemHandle DmResizeRecord
(
    DmOpenRef dbP,
    UInt16 index,
    UInt32 newSize
) 
{
    return 0;
}

MemHandle DmNewRecord(DmOpenRef dbP, UInt16* atP, UInt32 size)
{
    return 0;
}

MemHandle DmGetRecord(DmOpenRef dbP, UInt16 index)
{
    return 0;
}

static void DmReleaseRecord(DmOpenRef dmRef, UInt16 pos, Boolean dirty)
{
}

Err DmWrite(void* recordP, UInt32 offset, const void * srcP, UInt32 bytes)
{
    return 0;
}

Err DmDeleteRecord(DmOpenRef dbP, UInt16 index)
{
    return 0;
}

Err DmRemoveRecord(DmOpenRef dbP, UInt16 index)
{
    return 0;
}
