/*
Copyright (C) 1998, 1999, 2000 Wabasoft

Modifications for DOS by Mohan Embar
http://www.thisiscool.com/

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later version. 

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details. 

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA. 
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef _WIN32
    #define WIN32_LEAN_AND_MEAN
    #include <windows.h>
#else
    static AllocConsole()
    {}
#endif

#define FREE_ON_EXIT 1
#undef SECURE_CLASS_HEAP
#define LOCK_CLASS_HEAP
#define UNLOCK_CLASS_HEAP

#define uchar unsigned char
#define int32 long
#define uint32 unsigned long
#define float32 float
#define int16 short
#define uint16 unsigned short


#define cprintf printf

//
// type converters
//

#define getUInt32(b) (uint32)( (uint32)((b)[0])<<24 | (uint32)((b)[1])<<16 | (uint32)((b)[2])<<8 | (uint32)((b)[3]) )
#define getUInt16(b) (uint16)(((b)[0]<<8)|(b)[1])
#define getInt32(b) (int32)( (uint32)((b)[0])<<24 | (uint32)((b)[1])<<16 | (uint32)((b)[2])<<8 | (uint32)((b)[3]) )
#define getInt16(b) (int16)(((b)[0]<<8)|(b)[1])

static float32 getFloat32(uchar *buf)
	{
	uint32 i;
	float32 f;

	// we need to make sure we're aligned before casting
	i = ((uint32)buf[0] << 24) | ((uint32)buf[1] << 16) | ((uint32)buf[2] << 8) | (uint32)buf[3];
	f = *((float32 *)&i);
	return f;
	}

//
// x portability functions
//

#define xstrncmp(s1, s2, n) strncmp(s1, s2, n)

#define xstrncpy(dst, src, n) strncpy(dst, src, n)

#define xstrlen(s) strlen(s)

#define xstrcat(dst, src) strcat(dst, src)

#define xmemmove(dst, src, size) memmove(dst, src, size)

#define xmemzero(mem, len) memset(mem, 0, len)

#define xfree(ptr) free(ptr)

#ifdef DEBUGVERBOSE

static FILE* pfilLog;

static void print(const char* pcsz)
{
    fprintf(pfilLog,"%s\n", pcsz);
    fflush(pfilLog);
}

static void* xmalloc(size_t t)
{
    void* p;
    p = malloc(t);
    if (!p)
    {
        fprintf(pfilLog, "out of memory\n");
        fflush(pfilLog);
    }
    return p;
}

#else

#define xmalloc(size) malloc(size);

#endif
