{

  Adaption of the delphi3d.net OpenGL units to FreePascal
  Sebastian Guenther (sg@freepascal.org) in 2002
  These units are free to use
}

{$MACRO ON}
{$MODE Delphi}
{$IFDEF Win32}
  {$DEFINE extdecl:=stdcall }
{$ELSE}
  {$DEFINE extdecl:=cdecl }
{$ENDIF}

unit GLext;

(**************************************************
 *        OpenGL extension loading library        *
 * Generated by MetaGLext, written by Tom Nuydens *
 *  (tom@delphi3d.net -- http://www.delphi3d.net  *
 **************************************************)

//*** Generated on 10/11/2002

interface

uses
  SysUtils,
  {$IFDEF Win32}
  Windows,
  {$ELSE}
  dynlibs,
  {$ENDIF}
  GL;

{$IFDEF Win32}
{ Declared in Windows unit as well in FPC; but declared here as well, to be
  fully compatible to upstream version  - sg }
function wglGetProcAddress(proc: PChar): Pointer; extdecl; external 'OpenGL32.dll';
{$ELSE}
function wglGetProcAddress(proc: PChar): Pointer;
{$ENDIF}

// Test if the given extension name is present in the given extension string.
function glext_ExtensionSupported(const extension: String; const searchIn: String): Boolean;

// Load the extension with the given name.
function glext_LoadExtension(ext: String): Boolean;

//***** GL_version_1_2 *****//
const
  GL_UNSIGNED_BYTE_3_3_2 = $8032;
  GL_UNSIGNED_SHORT_4_4_4_4 = $8033;
  GL_UNSIGNED_SHORT_5_5_5_1 = $8034;
  GL_UNSIGNED_INT_8_8_8_8 = $8035;
  GL_UNSIGNED_INT_10_10_10_2 = $8036;
  GL_RESCALE_NORMAL = $803A;
  GL_UNSIGNED_BYTE_2_3_3_REV = $8362;
  GL_UNSIGNED_SHORT_5_6_5 = $8363;
  GL_UNSIGNED_SHORT_5_6_5_REV = $8364;
  GL_UNSIGNED_SHORT_4_4_4_4_REV = $8365;
  GL_UNSIGNED_SHORT_1_5_5_5_REV = $8366;
  GL_UNSIGNED_INT_8_8_8_8_REV = $8367;
  GL_UNSIGNED_INT_2_10_10_10_REV = $8368;
  GL_BGR = $80E0;
  GL_BGRA = $80E1;
  GL_MAX_ELEMENTS_VERTICES = $80E8;
  GL_MAX_ELEMENTS_INDICES = $80E9;
  GL_CLAMP_TO_EDGE = $812F;
  GL_TEXTURE_MIN_LOD = $813A;
  GL_TEXTURE_MAX_LOD = $813B;
  GL_TEXTURE_BASE_LEVEL = $813C;
  GL_TEXTURE_MAX_LEVEL = $813D;
  GL_LIGHT_MODEL_COLOR_CONTROL = $81F8;
  GL_SINGLE_COLOR = $81F9;
  GL_SEPARATE_SPECULAR_COLOR = $81FA;
  GL_SMOOTH_POINT_SIZE_RANGE = $0B12;
  GL_SMOOTH_POINT_SIZE_GRANULARITY = $0B13;
  GL_SMOOTH_LINE_WIDTH_RANGE = $0B22;
  GL_SMOOTH_LINE_WIDTH_GRANULARITY = $0B23;
  GL_ALIASED_POINT_SIZE_RANGE = $846D;
  GL_ALIASED_LINE_WIDTH_RANGE = $846E;
  GL_PACK_SKIP_IMAGES = $806B;
  GL_PACK_IMAGE_HEIGHT = $806C;
  GL_UNPACK_SKIP_IMAGES = $806D;
  GL_UNPACK_IMAGE_HEIGHT = $806E;
  GL_TEXTURE_3D = $806F;
  GL_PROXY_TEXTURE_3D = $8070;
  GL_TEXTURE_DEPTH = $8071;
  GL_TEXTURE_WRAP_R = $8072;
  GL_MAX_3D_TEXTURE_SIZE = $8073;
var
  glBlendColor: procedure(red: GLclampf; green: GLclampf; blue: GLclampf; alpha: GLclampf); extdecl;
  glBlendEquation: procedure(mode: GLenum); extdecl;
  glDrawRangeElements: procedure(mode: GLenum; start: GLuint; _end: GLuint; count: GLsizei; _type: GLenum; const indices: PGLvoid); extdecl;
  glColorTable: procedure(target: GLenum; internalformat: GLenum; width: GLsizei; format: GLenum; _type: GLenum; const table: PGLvoid); extdecl;
  glColorTableParameterfv: procedure(target: GLenum; pname: GLenum; const params: PGLfloat); extdecl;
  glColorTableParameteriv: procedure(target: GLenum; pname: GLenum; const params: PGLint); extdecl;
  glCopyColorTable: procedure(target: GLenum; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei); extdecl;
  glGetColorTable: procedure(target: GLenum; format: GLenum; _type: GLenum; table: PGLvoid); extdecl;
  glGetColorTableParameterfv: procedure(target: GLenum; pname: GLenum; params: PGLfloat); extdecl;
  glGetColorTableParameteriv: procedure(target: GLenum; pname: GLenum; params: PGLint); extdecl;
  glColorSubTable: procedure(target: GLenum; start: GLsizei; count: GLsizei; format: GLenum; _type: GLenum; const data: PGLvoid); extdecl;
  glCopyColorSubTable: procedure(target: GLenum; start: GLsizei; x: GLint; y: GLint; width: GLsizei); extdecl;
  glConvolutionFilter1D: procedure(target: GLenum; internalformat: GLenum; width: GLsizei; format: GLenum; _type: GLenum; const image: PGLvoid); extdecl;
  glConvolutionFilter2D: procedure(target: GLenum; internalformat: GLenum; width: GLsizei; height: GLsizei; format: GLenum; _type: GLenum; const image: PGLvoid); extdecl;
  glConvolutionParameterf: procedure(target: GLenum; pname: GLenum; params: GLfloat); extdecl;
  glConvolutionParameterfv: procedure(target: GLenum; pname: GLenum; const params: PGLfloat); extdecl;
  glConvolutionParameteri: procedure(target: GLenum; pname: GLenum; params: GLint); extdecl;
  glConvolutionParameteriv: procedure(target: GLenum; pname: GLenum; const params: PGLint); extdecl;
  glCopyConvolutionFilter1D: procedure(target: GLenum; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei); extdecl;
  glCopyConvolutionFilter2D: procedure(target: GLenum; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei; height: GLsizei); extdecl;
  glGetConvolutionFilter: procedure(target: GLenum; format: GLenum; _type: GLenum; image: PGLvoid); extdecl;
  glGetConvolutionParameterfv: procedure(target: GLenum; pname: GLenum; params: PGLfloat); extdecl;
  glGetConvolutionParameteriv: procedure(target: GLenum; pname: GLenum; params: PGLint); extdecl;
  glGetSeparableFilter: procedure(target: GLenum; format: GLenum; _type: GLenum; row: PGLvoid; column: PGLvoid; span: PGLvoid); extdecl;
  glSeparableFilter2D: procedure(target: GLenum; internalformat: GLenum; width: GLsizei; height: GLsizei; format: GLenum; _type: GLenum; const row: PGLvoid; const column: PGLvoid); extdecl;
  glGetHistogram: procedure(target: GLenum; reset: GLboolean; format: GLenum; _type: GLenum; values: PGLvoid); extdecl;
  glGetHistogramParameterfv: procedure(target: GLenum; pname: GLenum; params: PGLfloat); extdecl;
  glGetHistogramParameteriv: procedure(target: GLenum; pname: GLenum; params: PGLint); extdecl;
  glGetMinmax: procedure(target: GLenum; reset: GLboolean; format: GLenum; _type: GLenum; values: PGLvoid); extdecl;
  glGetMinmaxParameterfv: procedure(target: GLenum; pname: GLenum; params: PGLfloat); extdecl;
  glGetMinmaxParameteriv: procedure(target: GLenum; pname: GLenum; params: PGLint); extdecl;
  glHistogram: procedure(target: GLenum; width: GLsizei; internalformat: GLenum; sink: GLboolean); extdecl;
  glMinmax: procedure(target: GLenum; internalformat: GLenum; sink: GLboolean); extdecl;
  glResetHistogram: procedure(target: GLenum); extdecl;
  glResetMinmax: procedure(target: GLenum); extdecl;
  glTexImage3D: procedure(target: GLenum; level: GLint; internalformat: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; border: GLint; format: GLenum; _type: GLenum; const pixels: PGLvoid); extdecl;
  glTexSubImage3D: procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; _type: GLenum; const pixels: PGLvoid); extdecl;
  glCopyTexSubImage3D: procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; x: GLint; y: GLint; width: GLsizei; height: GLsizei); extdecl;

function Load_GL_version_1_2: Boolean;

//***** GL_ARB_imaging *****//
const
  GL_CONSTANT_COLOR = $8001;
  GL_ONE_MINUS_CONSTANT_COLOR = $8002;
  GL_CONSTANT_ALPHA = $8003;
  GL_ONE_MINUS_CONSTANT_ALPHA = $8004;
  GL_BLEND_COLOR = $8005;
  GL_FUNC_ADD = $8006;
  GL_MIN = $8007;
  GL_MAX = $8008;
  GL_BLEND_EQUATION = $8009;
  GL_FUNC_SUBTRACT = $800A;
  GL_FUNC_REVERSE_SUBTRACT = $800B;
  GL_CONVOLUTION_1D = $8010;
  GL_CONVOLUTION_2D = $8011;
  GL_SEPARABLE_2D = $8012;
  GL_CONVOLUTION_BORDER_MODE = $8013;
  GL_CONVOLUTION_FILTER_SCALE = $8014;
  GL_CONVOLUTION_FILTER_BIAS = $8015;
  GL_REDUCE = $8016;
  GL_CONVOLUTION_FORMAT = $8017;
  GL_CONVOLUTION_WIDTH = $8018;
  GL_CONVOLUTION_HEIGHT = $8019;
  GL_MAX_CONVOLUTION_WIDTH = $801A;
  GL_MAX_CONVOLUTION_HEIGHT = $801B;
  GL_POST_CONVOLUTION_RED_SCALE = $801C;
  GL_POST_CONVOLUTION_GREEN_SCALE = $801D;
  GL_POST_CONVOLUTION_BLUE_SCALE = $801E;
  GL_POST_CONVOLUTION_ALPHA_SCALE = $801F;
  GL_POST_CONVOLUTION_RED_BIAS = $8020;
  GL_POST_CONVOLUTION_GREEN_BIAS = $8021;
  GL_POST_CONVOLUTION_BLUE_BIAS = $8022;
  GL_POST_CONVOLUTION_ALPHA_BIAS = $8023;
  GL_HISTOGRAM = $8024;
  GL_PROXY_HISTOGRAM = $8025;
  GL_HISTOGRAM_WIDTH = $8026;
  GL_HISTOGRAM_FORMAT = $8027;
  GL_HISTOGRAM_RED_SIZE = $8028;
  GL_HISTOGRAM_GREEN_SIZE = $8029;
  GL_HISTOGRAM_BLUE_SIZE = $802A;
  GL_HISTOGRAM_ALPHA_SIZE = $802B;
  GL_HISTOGRAM_LUMINANCE_SIZE = $802C;
  GL_HISTOGRAM_SINK = $802D;
  GL_MINMAX = $802E;
  GL_MINMAX_FORMAT = $802F;
  GL_MINMAX_SINK = $8030;
  GL_TABLE_TOO_LARGE = $8031;
  GL_COLOR_MATRIX = $80B1;
  GL_COLOR_MATRIX_STACK_DEPTH = $80B2;
  GL_MAX_COLOR_MATRIX_STACK_DEPTH = $80B3;
  GL_POST_COLOR_MATRIX_RED_SCALE = $80B4;
  GL_POST_COLOR_MATRIX_GREEN_SCALE = $80B5;
  GL_POST_COLOR_MATRIX_BLUE_SCALE = $80B6;
  GL_POST_COLOR_MATRIX_ALPHA_SCALE = $80B7;
  GL_POST_COLOR_MATRIX_RED_BIAS = $80B8;
  GL_POST_COLOR_MATRIX_GREEN_BIAS = $80B9;
  GL_POST_COLOR_MATRIX_BLUE_BIAS = $80BA;
  GL_POST_COLOR_MATIX_ALPHA_BIAS = $80BB;
  GL_COLOR_TABLE = $80D0;
  GL_POST_CONVOLUTION_COLOR_TABLE = $80D1;
  GL_POST_COLOR_MATRIX_COLOR_TABLE = $80D2;
  GL_PROXY_COLOR_TABLE = $80D3;
  GL_PROXY_POST_CONVOLUTION_COLOR_TABLE = $80D4;
  GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = $80D5;
  GL_COLOR_TABLE_SCALE = $80D6;
  GL_COLOR_TABLE_BIAS = $80D7;
  GL_COLOR_TABLE_FORMAT = $80D8;
  GL_COLOR_TABLE_WIDTH = $80D9;
  GL_COLOR_TABLE_RED_SIZE = $80DA;
  GL_COLOR_TABLE_GREEN_SIZE = $80DB;
  GL_COLOR_TABLE_BLUE_SIZE = $80DC;
  GL_COLOR_TABLE_ALPHA_SIZE = $80DD;
  GL_COLOR_TABLE_LUMINANCE_SIZE = $80DE;
  GL_COLOR_TABLE_INTENSITY_SIZE = $80DF;
  GL_IGNORE_BORDER = $8150;
  GL_CONSTANT_BORDER = $8151;
  GL_WRAP_BORDER = $8152;
  GL_REPLICATE_BORDER = $8153;
  GL_CONVOLUTION_BORDER_COLOR = $8154;

function Load_GL_ARB_imaging: Boolean;

//***** GL_version_1_3 *****//
const
  GL_TEXTURE0 = $84C0;
  GL_TEXTURE1 = $84C1;
  GL_TEXTURE2 = $84C2;
  GL_TEXTURE3 = $84C3;
  GL_TEXTURE4 = $84C4;
  GL_TEXTURE5 = $84C5;
  GL_TEXTURE6 = $84C6;
  GL_TEXTURE7 = $84C7;
  GL_TEXTURE8 = $84C8;
  GL_TEXTURE9 = $84C9;
  GL_TEXTURE10 = $84CA;
  GL_TEXTURE11 = $84CB;
  GL_TEXTURE12 = $84CC;
  GL_TEXTURE13 = $84CD;
  GL_TEXTURE14 = $84CE;
  GL_TEXTURE15 = $84CF;
  GL_TEXTURE16 = $84D0;
  GL_TEXTURE17 = $84D1;
  GL_TEXTURE18 = $84D2;
  GL_TEXTURE19 = $84D3;
  GL_TEXTURE20 = $84D4;
  GL_TEXTURE21 = $84D5;
  GL_TEXTURE22 = $84D6;
  GL_TEXTURE23 = $84D7;
  GL_TEXTURE24 = $84D8;
  GL_TEXTURE25 = $84D9;
  GL_TEXTURE26 = $84DA;
  GL_TEXTURE27 = $84DB;
  GL_TEXTURE28 = $84DC;
  GL_TEXTURE29 = $84DD;
  GL_TEXTURE30 = $84DE;
  GL_TEXTURE31 = $84DF;
  GL_ACTIVE_TEXTURE = $84E0;
  GL_CLIENT_ACTIVE_TEXTURE = $84E1;
  GL_MAX_TEXTURE_UNITS = $84E2;
  GL_TRANSPOSE_MODELVIEW_MATRIX = $84E3;
  GL_TRANSPOSE_PROJECTION_MATRIX = $84E4;
  GL_TRANSPOSE_TEXTURE_MATRIX = $84E5;
  GL_TRANSPOSE_COLOR_MATRIX = $84E6;
  GL_MULTISAMPLE = $809D;
  GL_SAMPLE_ALPHA_TO_COVERAGE = $809E;
  GL_SAMPLE_ALPHA_TO_ONE = $809F;
  GL_SAMPLE_COVERAGE = $80A0;
  GL_SAMPLE_BUFFERS = $80A8;
  GL_SAMPLES = $80A9;
  GL_SAMPLE_COVERAGE_VALUE = $80AA;
  GL_SAMPLE_COVERAGE_INVERT = $80AB;
  GL_MULTISAMPLE_BIT = $20000000;
  GL_NORMAL_MAP = $8511;
  GL_REFLECTION_MAP = $8512;
  GL_TEXTURE_CUBE_MAP = $8513;
  GL_TEXTURE_BINDING_CUBE_MAP = $8514;
  GL_TEXTURE_CUBE_MAP_POSITIVE_X = $8515;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_X = $8516;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Y = $8517;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = $8518;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Z = $8519;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = $851A;
  GL_PROXY_TEXTURE_CUBE_MAP = $851B;
  GL_MAX_CUBE_MAP_TEXTURE_SIZE = $851C;
  GL_COMPRESSED_ALPHA = $84E9;
  GL_COMPRESSED_LUMINANCE = $84EA;
  GL_COMPRESSED_LUMINANCE_ALPHA = $84EB;
  GL_COMPRESSED_INTENSITY = $84EC;
  GL_COMPRESSED_RGB = $84ED;
  GL_COMPRESSED_RGBA = $84EE;
  GL_TEXTURE_COMPRESSION_HINT = $84EF;
  GL_TEXTURE_COMPRESSED_IMAGE_SIZE = $86A0;
  GL_TEXTURE_COMPRESSED = $86A1;
  GL_NUM_COMPRESSED_TEXTURE_FORMATS = $86A2;
  GL_COMPRESSED_TEXTURE_FORMATS = $86A3;
  GL_CLAMP_TO_BORDER = $812D;
  GL_CLAMP_TO_BORDER_SGIS = $812D;
  GL_COMBINE = $8570;
  GL_COMBINE_RGB = $8571;
  GL_COMBINE_ALPHA = $8572;
  GL_SOURCE0_RGB = $8580;
  GL_SOURCE1_RGB = $8581;
  GL_SOURCE2_RGB = $8582;
  GL_SOURCE0_ALPHA = $8588;
  GL_SOURCE1_ALPHA = $8589;
  GL_SOURCE2_ALPHA = $858A;
  GL_OPERAND0_RGB = $8590;
  GL_OPERAND1_RGB = $8591;
  GL_OPERAND2_RGB = $8592;
  GL_OPERAND0_ALPHA = $8598;
  GL_OPERAND1_ALPHA = $8599;
  GL_OPERAND2_ALPHA = $859A;
  GL_RGB_SCALE = $8573;
  GL_ADD_SIGNED = $8574;
  GL_INTERPOLATE = $8575;
  GL_SUBTRACT = $84E7;
  GL_CONSTANT = $8576;
  GL_PRIMARY_COLOR = $8577;
  GL_PREVIOUS = $8578;
  GL_DOT3_RGB = $86AE;
  GL_DOT3_RGBA = $86AF;
var
  glActiveTexture: procedure(texture: GLenum); extdecl;
  glClientActiveTexture: procedure(texture: GLenum); extdecl;
  glMultiTexCoord1d: procedure(target: GLenum; s: GLdouble); extdecl;
  glMultiTexCoord1dv: procedure(target: GLenum; const v: PGLdouble); extdecl;
  glMultiTexCoord1f: procedure(target: GLenum; s: GLfloat); extdecl;
  glMultiTexCoord1fv: procedure(target: GLenum; const v: PGLfloat); extdecl;
  glMultiTexCoord1i: procedure(target: GLenum; s: GLint); extdecl;
  glMultiTexCoord1iv: procedure(target: GLenum; const v: PGLint); extdecl;
  glMultiTexCoord1s: procedure(target: GLenum; s: GLshort); extdecl;
  glMultiTexCoord1sv: procedure(target: GLenum; const v: PGLshort); extdecl;
  glMultiTexCoord2d: procedure(target: GLenum; s: GLdouble; t: GLdouble); extdecl;
  glMultiTexCoord2dv: procedure(target: GLenum; const v: PGLdouble); extdecl;
  glMultiTexCoord2f: procedure(target: GLenum; s: GLfloat; t: GLfloat); extdecl;
  glMultiTexCoord2fv: procedure(target: GLenum; const v: PGLfloat); extdecl;
  glMultiTexCoord2i: procedure(target: GLenum; s: GLint; t: GLint); extdecl;
  glMultiTexCoord2iv: procedure(target: GLenum; const v: PGLint); extdecl;
  glMultiTexCoord2s: procedure(target: GLenum; s: GLshort; t: GLshort); extdecl;
  glMultiTexCoord2sv: procedure(target: GLenum; const v: PGLshort); extdecl;
  glMultiTexCoord3d: procedure(target: GLenum; s: GLdouble; t: GLdouble; r: GLdouble); extdecl;
  glMultiTexCoord3dv: procedure(target: GLenum; const v: PGLdouble); extdecl;
  glMultiTexCoord3f: procedure(target: GLenum; s: GLfloat; t: GLfloat; r: GLfloat); extdecl;
  glMultiTexCoord3fv: procedure(target: GLenum; const v: PGLfloat); extdecl;
  glMultiTexCoord3i: procedure(target: GLenum; s: GLint; t: GLint; r: GLint); extdecl;
  glMultiTexCoord3iv: procedure(target: GLenum; const v: PGLint); extdecl;
  glMultiTexCoord3s: procedure(target: GLenum; s: GLshort; t: GLshort; r: GLshort); extdecl;
  glMultiTexCoord3sv: procedure(target: GLenum; const v: PGLshort); extdecl;
  glMultiTexCoord4d: procedure(target: GLenum; s: GLdouble; t: GLdouble; r: GLdouble; q: GLdouble); extdecl;
  glMultiTexCoord4dv: procedure(target: GLenum; const v: PGLdouble); extdecl;
  glMultiTexCoord4f: procedure(target: GLenum; s: GLfloat; t: GLfloat; r: GLfloat; q: GLfloat); extdecl;
  glMultiTexCoord4fv: procedure(target: GLenum; const v: PGLfloat); extdecl;
  glMultiTexCoord4i: procedure(target: GLenum; s: GLint; t: GLint; r: GLint; q: GLint); extdecl;
  glMultiTexCoord4iv: procedure(target: GLenum; const v: PGLint); extdecl;
  glMultiTexCoord4s: procedure(target: GLenum; s: GLshort; t: GLshort; r: GLshort; q: GLshort); extdecl;
  glMultiTexCoord4sv: procedure(target: GLenum; const v: PGLshort); extdecl;
  glLoadTransposeMatrixf: procedure(const m: PGLfloat); extdecl;
  glLoadTransposeMatrixd: procedure(const m: PGLdouble); extdecl;
  glMultTransposeMatrixf: procedure(const m: PGLfloat); extdecl;
  glMultTransposeMatrixd: procedure(const m: PGLdouble); extdecl;
  glSampleCoverage: procedure(value: GLclampf; invert: GLboolean); extdecl;
  glCompressedTexImage3D: procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; border: GLint; imageSize: GLsizei; const data: PGLvoid); extdecl;
  glCompressedTexImage2D: procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; border: GLint; imageSize: GLsizei; const data: PGLvoid); extdecl;
  glCompressedTexImage1D: procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; border: GLint; imageSize: GLsizei; const data: PGLvoid); extdecl;
  glCompressedTexSubImage3D: procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; imageSize: GLsizei; const data: PGLvoid); extdecl;
  glCompressedTexSubImage2D: procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; width: GLsizei; height: GLsizei; format: GLenum; imageSize: GLsizei; const data: PGLvoid); extdecl;
  glCompressedTexSubImage1D: procedure(target: GLenum; level: GLint; xoffset: GLint; width: GLsizei; format: GLenum; imageSize: GLsizei; const data: PGLvoid); extdecl;
  glGetCompressedTexImage: procedure(target: GLenum; level: GLint; img: PGLvoid); extdecl;

function Load_GL_version_1_3: Boolean;

//***** GL_ARB_multitexture *****//
const
  GL_TEXTURE0_ARB = $84C0;
  GL_TEXTURE1_ARB = $84C1;
  GL_TEXTURE2_ARB = $84C2;
  GL_TEXTURE3_ARB = $84C3;
  GL_TEXTURE4_ARB = $84C4;
  GL_TEXTURE5_ARB = $84C5;
  GL_TEXTURE6_ARB = $84C6;
  GL_TEXTURE7_ARB = $84C7;
  GL_TEXTURE8_ARB = $84C8;
  GL_TEXTURE9_ARB = $84C9;
  GL_TEXTURE10_ARB = $84CA;
  GL_TEXTURE11_ARB = $84CB;
  GL_TEXTURE12_ARB = $84CC;
  GL_TEXTURE13_ARB = $84CD;
  GL_TEXTURE14_ARB = $84CE;
  GL_TEXTURE15_ARB = $84CF;
  GL_TEXTURE16_ARB = $84D0;
  GL_TEXTURE17_ARB = $84D1;
  GL_TEXTURE18_ARB = $84D2;
  GL_TEXTURE19_ARB = $84D3;
  GL_TEXTURE20_ARB = $84D4;
  GL_TEXTURE21_ARB = $84D5;
  GL_TEXTURE22_ARB = $84D6;
  GL_TEXTURE23_ARB = $84D7;
  GL_TEXTURE24_ARB = $84D8;
  GL_TEXTURE25_ARB = $84D9;
  GL_TEXTURE26_ARB = $84DA;
  GL_TEXTURE27_ARB = $84DB;
  GL_TEXTURE28_ARB = $84DC;
  GL_TEXTURE29_ARB = $84DD;
  GL_TEXTURE30_ARB = $84DE;
  GL_TEXTURE31_ARB = $84DF;
  GL_ACTIVE_TEXTURE_ARB = $84E0;
  GL_CLIENT_ACTIVE_TEXTURE_ARB = $84E1;
  GL_MAX_TEXTURE_UNITS_ARB = $84E2;
var
  glActiveTextureARB: procedure(texture: GLenum); extdecl;
  glClientActiveTextureARB: procedure(texture: GLenum); extdecl;
  glMultiTexCoord1dARB: procedure(target: GLenum; s: GLdouble); extdecl;
  glMultiTexCoord1dvARB: procedure(target: GLenum; const v: PGLdouble); extdecl;
  glMultiTexCoord1fARB: procedure(target: GLenum; s: GLfloat); extdecl;
  glMultiTexCoord1fvARB: procedure(target: GLenum; const v: PGLfloat); extdecl;
  glMultiTexCoord1iARB: procedure(target: GLenum; s: GLint); extdecl;
  glMultiTexCoord1ivARB: procedure(target: GLenum; const v: PGLint); extdecl;
  glMultiTexCoord1sARB: procedure(target: GLenum; s: GLshort); extdecl;
  glMultiTexCoord1svARB: procedure(target: GLenum; const v: PGLshort); extdecl;
  glMultiTexCoord2dARB: procedure(target: GLenum; s: GLdouble; t: GLdouble); extdecl;
  glMultiTexCoord2dvARB: procedure(target: GLenum; const v: PGLdouble); extdecl;
  glMultiTexCoord2fARB: procedure(target: GLenum; s: GLfloat; t: GLfloat); extdecl;
  glMultiTexCoord2fvARB: procedure(target: GLenum; const v: PGLfloat); extdecl;
  glMultiTexCoord2iARB: procedure(target: GLenum; s: GLint; t: GLint); extdecl;
  glMultiTexCoord2ivARB: procedure(target: GLenum; const v: PGLint); extdecl;
  glMultiTexCoord2sARB: procedure(target: GLenum; s: GLshort; t: GLshort); extdecl;
  glMultiTexCoord2svARB: procedure(target: GLenum; const v: PGLshort); extdecl;
  glMultiTexCoord3dARB: procedure(target: GLenum; s: GLdouble; t: GLdouble; r: GLdouble); extdecl;
  glMultiTexCoord3dvARB: procedure(target: GLenum; const v: PGLdouble); extdecl;
  glMultiTexCoord3fARB: procedure(target: GLenum; s: GLfloat; t: GLfloat; r: GLfloat); extdecl;
  glMultiTexCoord3fvARB: procedure(target: GLenum; const v: PGLfloat); extdecl;
  glMultiTexCoord3iARB: procedure(target: GLenum; s: GLint; t: GLint; r: GLint); extdecl;
  glMultiTexCoord3ivARB: procedure(target: GLenum; const v: PGLint); extdecl;
  glMultiTexCoord3sARB: procedure(target: GLenum; s: GLshort; t: GLshort; r: GLshort); extdecl;
  glMultiTexCoord3svARB: procedure(target: GLenum; const v: PGLshort); extdecl;
  glMultiTexCoord4dARB: procedure(target: GLenum; s: GLdouble; t: GLdouble; r: GLdouble; q: GLdouble); extdecl;
  glMultiTexCoord4dvARB: procedure(target: GLenum; const v: PGLdouble); extdecl;
  glMultiTexCoord4fARB: procedure(target: GLenum; s: GLfloat; t: GLfloat; r: GLfloat; q: GLfloat); extdecl;
  glMultiTexCoord4fvARB: procedure(target: GLenum; const v: PGLfloat); extdecl;
  glMultiTexCoord4iARB: procedure(target: GLenum; s: GLint; t: GLint; r: GLint; q: GLint); extdecl;
  glMultiTexCoord4ivARB: procedure(target: GLenum; const v: PGLint); extdecl;
  glMultiTexCoord4sARB: procedure(target: GLenum; s: GLshort; t: GLshort; r: GLshort; q: GLshort); extdecl;
  glMultiTexCoord4svARB: procedure(target: GLenum; const v: PGLshort); extdecl;

function Load_GL_ARB_multitexture: Boolean;

//***** GL_ARB_transpose_matrix *****//
const
  GL_TRANSPOSE_MODELVIEW_MATRIX_ARB = $84E3;
  GL_TRANSPOSE_PROJECTION_MATRIX_ARB = $84E4;
  GL_TRANSPOSE_TEXTURE_MATRIX_ARB = $84E5;
  GL_TRANSPOSE_COLOR_MATRIX_ARB = $84E6;
var
  glLoadTransposeMatrixfARB: procedure(m: PGLfloat); extdecl;
  glLoadTransposeMatrixdARB: procedure(m: PGLdouble); extdecl;
  glMultTransposeMatrixfARB: procedure(m: PGLfloat); extdecl;
  glMultTransposeMatrixdARB: procedure(m: PGLdouble); extdecl;

function Load_GL_ARB_transpose_matrix: Boolean;

//***** GL_ARB_multisample *****//
const
  WGL_SAMPLE_BUFFERS_ARB = $2041;
  WGL_SAMPLES_ARB = $2042;
  GL_MULTISAMPLE_ARB = $809D;
  GL_SAMPLE_ALPHA_TO_COVERAGE_ARB = $809E;
  GL_SAMPLE_ALPHA_TO_ONE_ARB = $809F;
  GL_SAMPLE_COVERAGE_ARB = $80A0;
  GL_MULTISAMPLE_BIT_ARB = $20000000;
  GL_SAMPLE_BUFFERS_ARB = $80A8;
  GL_SAMPLES_ARB = $80A9;
  GL_SAMPLE_COVERAGE_VALUE_ARB = $80AA;
  GL_SAMPLE_COVERAGE_INVERT_ARB = $80AB;
var
  glSampleCoverageARB: procedure(value: GLclampf; invert: GLboolean); extdecl;

function Load_GL_ARB_multisample: Boolean;

//***** GL_ARB_texture_env_add *****//

function Load_GL_ARB_texture_env_add: Boolean;

{$IFDEF Win32}
//***** WGL_ARB_extensions_string *****//
var
  wglGetExtensionsStringARB: function(hdc: HDC): Pchar; extdecl;

function Load_WGL_ARB_extensions_string: Boolean;

//***** WGL_ARB_buffer_region *****//
const
  WGL_FRONT_COLOR_BUFFER_BIT_ARB = $0001;
  WGL_BACK_COLOR_BUFFER_BIT_ARB = $0002;
  WGL_DEPTH_BUFFER_BIT_ARB = $0004;
  WGL_STENCIL_BUFFER_BIT_ARB = $0008;
var
  wglCreateBufferRegionARB: function(hDC: HDC; iLayerPlane: GLint; uType: GLuint): THandle; extdecl;
  wglDeleteBufferRegionARB: procedure(hRegion: THandle); extdecl;
  wglSaveBufferRegionARB: function(hRegion: THandle; x: GLint; y: GLint; width: GLint; height: GLint): BOOL; extdecl;
  wglRestoreBufferRegionARB: function(hRegion: THandle; x: GLint; y: GLint; width: GLint; height: GLint; xSrc: GLint; ySrc: GLint): BOOL; extdecl;

function Load_WGL_ARB_buffer_region: Boolean;
{$ENDIF}

//***** GL_ARB_texture_cube_map *****//
const
  GL_NORMAL_MAP_ARB = $8511;
  GL_REFLECTION_MAP_ARB = $8512;
  GL_TEXTURE_CUBE_MAP_ARB = $8513;
  GL_TEXTURE_BINDING_CUBE_MAP_ARB = $8514;
  GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB = $8515;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB = $8516;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB = $8517;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB = $8518;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB = $8519;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB = $851A;
  GL_PROXY_TEXTURE_CUBE_MAP_ARB = $851B;
  GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB = $851C;

function Load_GL_ARB_texture_cube_map: Boolean;

//***** GL_ARB_depth_texture *****//
const
  GL_DEPTH_COMPONENT16_ARB = $81A5;
  GL_DEPTH_COMPONENT24_ARB = $81A6;
  GL_DEPTH_COMPONENT32_ARB = $81A7;
  GL_TEXTURE_DEPTH_SIZE_ARB = $884A;
  GL_DEPTH_TEXTURE_MODE_ARB = $884B;

function Load_GL_ARB_depth_texture: Boolean;

//***** GL_ARB_point_parameters *****//
const
  GL_POINT_SIZE_MIN_ARB = $8126;
  GL_POINT_SIZE_MAX_ARB = $8127;
  GL_POINT_FADE_THRESHOLD_SIZE_ARB = $8128;
  GL_POINT_DISTANCE_ATTENUATION_ARB = $8129;
var
  glPointParameterfARB: procedure(pname: GLenum; param: GLfloat); extdecl;
  glPointParameterfvARB: procedure(pname: GLenum; params: PGLfloat); extdecl;

function Load_GL_ARB_point_parameters: Boolean;

//***** GL_ARB_shadow *****//
const
  GL_TEXTURE_COMPARE_MODE_ARB = $884C;
  GL_TEXTURE_COMPARE_FUNC_ARB = $884D;
  GL_COMPARE_R_TO_TEXTURE_ARB = $884E;

function Load_GL_ARB_shadow: Boolean;

//***** GL_ARB_shadow_ambient *****//
const
  GL_TEXTURE_COMPARE_FAIL_VALUE_ARB = $80BF;

function Load_GL_ARB_shadow_ambient: Boolean;

//***** GL_ARB_texture_border_clamp *****//
const
  GL_CLAMP_TO_BORDER_ARB = $812D;

function Load_GL_ARB_texture_border_clamp: Boolean;

//***** GL_ARB_texture_compression *****//
const
  GL_COMPRESSED_ALPHA_ARB = $84E9;
  GL_COMPRESSED_LUMINANCE_ARB = $84EA;
  GL_COMPRESSED_LUMINANCE_ALPHA_ARB = $84EB;
  GL_COMPRESSED_INTENSITY_ARB = $84EC;
  GL_COMPRESSED_RGB_ARB = $84ED;
  GL_COMPRESSED_RGBA_ARB = $84EE;
  GL_TEXTURE_COMPRESSION_HINT_ARB = $84EF;
  GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB = $86A0;
  GL_TEXTURE_COMPRESSED_ARB = $86A1;
  GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB = $86A2;
  GL_COMPRESSED_TEXTURE_FORMATS_ARB = $86A3;
var
  glCompressedTexImage3DARB: procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; border: GLint; imageSize: GLsizei; const data: PGLvoid); extdecl;
  glCompressedTexImage2DARB: procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; border: GLint; imageSize: GLsizei; const data: PGLvoid); extdecl;
  glCompressedTexImage1DARB: procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; border: GLint; imageSize: GLsizei; const data: PGLvoid); extdecl;
  glCompressedTexSubImage3DARB: procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; imageSize: GLsizei; const data: PGLvoid); extdecl;
  glCompressedTexSubImage2DARB: procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; width: GLsizei; height: GLsizei; format: GLenum; imageSize: GLsizei; const data: PGLvoid); extdecl;
  glCompressedTexSubImage1DARB: procedure(target: GLenum; level: GLint; xoffset: GLint; width: GLsizei; format: GLenum; imageSize: GLsizei; const data: PGLvoid); extdecl;
  glGetCompressedTexImageARB: procedure(target: GLenum; lod: GLint; img: PGLvoid); extdecl;

function Load_GL_ARB_texture_compression: Boolean;

//***** GL_ARB_texture_env_combine *****//
const
  GL_COMBINE_ARB = $8570;
  GL_COMBINE_RGB_ARB = $8571;
  GL_COMBINE_ALPHA_ARB = $8572;
  GL_SOURCE0_RGB_ARB = $8580;
  GL_SOURCE1_RGB_ARB = $8581;
  GL_SOURCE2_RGB_ARB = $8582;
  GL_SOURCE0_ALPHA_ARB = $8588;
  GL_SOURCE1_ALPHA_ARB = $8589;
  GL_SOURCE2_ALPHA_ARB = $858A;
  GL_OPERAND0_RGB_ARB = $8590;
  GL_OPERAND1_RGB_ARB = $8591;
  GL_OPERAND2_RGB_ARB = $8592;
  GL_OPERAND0_ALPHA_ARB = $8598;
  GL_OPERAND1_ALPHA_ARB = $8599;
  GL_OPERAND2_ALPHA_ARB = $859A;
  GL_RGB_SCALE_ARB = $8573;
  GL_ADD_SIGNED_ARB = $8574;
  GL_INTERPOLATE_ARB = $8575;
  GL_SUBTRACT_ARB = $84E7;
  GL_CONSTANT_ARB = $8576;
  GL_PRIMARY_COLOR_ARB = $8577;
  GL_PREVIOUS_ARB = $8578;

function Load_GL_ARB_texture_env_combine: Boolean;

//***** GL_ARB_texture_env_crossbar *****//

function Load_GL_ARB_texture_env_crossbar: Boolean;

//***** GL_ARB_texture_env_dot3 *****//
const
  GL_DOT3_RGB_ARB = $86AE;
  GL_DOT3_RGBA_ARB = $86AF;

function Load_GL_ARB_texture_env_dot3: Boolean;

//***** GL_ARB_texture_mirrored_repeat *****//
const
  GL_MIRRORED_REPEAT_ARB = $8370;

function Load_GL_ARB_texture_mirrored_repeat: Boolean;

//***** GL_ARB_vertex_blend *****//
const
  GL_MAX_VERTEX_UNITS_ARB = $86A4;
  GL_ACTIVE_VERTEX_UNITS_ARB = $86A5;
  GL_WEIGHT_SUM_UNITY_ARB = $86A6;
  GL_VERTEX_BLEND_ARB = $86A7;
  GL_MODELVIEW0_ARB = $1700;
  GL_MODELVIEW1_ARB = $850A;
  GL_MODELVIEW2_ARB = $8722;
  GL_MODELVIEW3_ARB = $8723;
  GL_MODELVIEW4_ARB = $8724;
  GL_MODELVIEW5_ARB = $8725;
  GL_MODELVIEW6_ARB = $8726;
  GL_MODELVIEW7_ARB = $8727;
  GL_MODELVIEW8_ARB = $8728;
  GL_MODELVIEW9_ARB = $8729;
  GL_MODELVIEW10_ARB = $872A;
  GL_MODELVIEW11_ARB = $872B;
  GL_MODELVIEW12_ARB = $872C;
  GL_MODELVIEW13_ARB = $872D;
  GL_MODELVIEW14_ARB = $872E;
  GL_MODELVIEW15_ARB = $872F;
  GL_MODELVIEW16_ARB = $8730;
  GL_MODELVIEW17_ARB = $8731;
  GL_MODELVIEW18_ARB = $8732;
  GL_MODELVIEW19_ARB = $8733;
  GL_MODELVIEW20_ARB = $8734;
  GL_MODELVIEW21_ARB = $8735;
  GL_MODELVIEW22_ARB = $8736;
  GL_MODELVIEW23_ARB = $8737;
  GL_MODELVIEW24_ARB = $8738;
  GL_MODELVIEW25_ARB = $8739;
  GL_MODELVIEW26_ARB = $873A;
  GL_MODELVIEW27_ARB = $873B;
  GL_MODELVIEW28_ARB = $873C;
  GL_MODELVIEW29_ARB = $873D;
  GL_MODELVIEW30_ARB = $873E;
  GL_MODELVIEW31_ARB = $873F;
  GL_CURRENT_WEIGHT_ARB = $86A8;
  GL_WEIGHT_ARRAY_TYPE_ARB = $86A9;
  GL_WEIGHT_ARRAY_STRIDE_ARB = $86AA;
  GL_WEIGHT_ARRAY_SIZE_ARB = $86AB;
  GL_WEIGHT_ARRAY_POINTER_ARB = $86AC;
  GL_WEIGHT_ARRAY_ARB = $86AD;
var
  glWeightbvARB: procedure(size: GLint; weights: PGLbyte); extdecl;
  glWeightsvARB: procedure(size: GLint; weights: PGLshort); extdecl;
  glWeightivARB: procedure(size: GLint; weights: PGLint); extdecl;
  glWeightfvARB: procedure(size: GLint; weights: PGLfloat); extdecl;
  glWeightdvARB: procedure(size: GLint; weights: PGLdouble); extdecl;
  glWeightvARB: procedure(size: GLint; weights: PGLdouble); extdecl;
  glWeightubvARB: procedure(size: GLint; weights: PGLubyte); extdecl;
  glWeightusvARB: procedure(size: GLint; weights: PGLushort); extdecl;
  glWeightuivARB: procedure(size: GLint; weights: PGLuint); extdecl;
  glWeightPointerARB: procedure(size: GLint; _type: GLenum; stride: GLsizei; pointer: PGLvoid); extdecl;
  glVertexBlendARB: procedure(count: GLint); extdecl;

function Load_GL_ARB_vertex_blend: Boolean;

//***** GL_ARB_vertex_program *****//
const
  GL_VERTEX_PROGRAM_ARB = $8620;
  GL_VERTEX_PROGRAM_POINT_SIZE_ARB = $8642;
  GL_VERTEX_PROGRAM_TWO_SIDE_ARB = $8643;
  GL_COLOR_SUM_ARB = $8458;
  GL_PROGRAM_FORMAT_ASCII_ARB = $8875;
  GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB = $8622;
  GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB = $8623;
  GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB = $8624;
  GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB = $8625;
  GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB = $886A;
  GL_CURRENT_VERTEX_ATTRIB_ARB = $8626;
  GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB = $8645;
  GL_PROGRAM_LENGTH_ARB = $8627;
  GL_PROGRAM_FORMAT_ARB = $8876;
  GL_PROGRAM_BINDING_ARB = $8677;
  GL_PROGRAM_INSTRUCTIONS_ARB = $88A0;
  GL_MAX_PROGRAM_INSTRUCTIONS_ARB = $88A1;
  GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB = $88A2;
  GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB = $88A3;
  GL_PROGRAM_TEMPORARIES_ARB = $88A4;
  GL_MAX_PROGRAM_TEMPORARIES_ARB = $88A5;
  GL_PROGRAM_NATIVE_TEMPORARIES_ARB = $88A6;
  GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB = $88A7;
  GL_PROGRAM_PARAMETERS_ARB = $88A8;
  GL_MAX_PROGRAM_PARAMETERS_ARB = $88A9;
  GL_PROGRAM_NATIVE_PARAMETERS_ARB = $88AA;
  GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB = $88AB;
  GL_PROGRAM_ATTRIBS_ARB = $88AC;
  GL_MAX_PROGRAM_ATTRIBS_ARB = $88AD;
  GL_PROGRAM_NATIVE_ATTRIBS_ARB = $88AE;
  GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB = $88AF;
  GL_PROGRAM_ADDRESS_REGISTERS_ARB = $88B0;
  GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB = $88B1;
  GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = $88B2;
  GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = $88B3;
  GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB = $88B4;
  GL_MAX_PROGRAM_ENV_PARAMETERS_ARB = $88B5;
  GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB = $88B6;
  GL_PROGRAM_STRING_ARB = $8628;
  GL_PROGRAM_ERROR_POSITION_ARB = $864B;
  GL_CURRENT_MATRIX_ARB = $8641;
  GL_TRANSPOSE_CURRENT_MATRIX_ARB = $88B7;
  GL_CURRENT_MATRIX_STACK_DEPTH_ARB = $8640;
  GL_MAX_VERTEX_ATTRIBS_ARB = $8869;
  GL_MAX_PROGRAM_MATRICES_ARB = $862F;
  GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB = $862E;
  GL_PROGRAM_ERROR_STRING_ARB = $8874;
  GL_MATRIX0_ARB = $88C0;
  GL_MATRIX1_ARB = $88C1;
  GL_MATRIX2_ARB = $88C2;
  GL_MATRIX3_ARB = $88C3;
  GL_MATRIX4_ARB = $88C4;
  GL_MATRIX5_ARB = $88C5;
  GL_MATRIX6_ARB = $88C6;
  GL_MATRIX7_ARB = $88C7;
  GL_MATRIX8_ARB = $88C8;
  GL_MATRIX9_ARB = $88C9;
  GL_MATRIX10_ARB = $88CA;
  GL_MATRIX11_ARB = $88CB;
  GL_MATRIX12_ARB = $88CC;
  GL_MATRIX13_ARB = $88CD;
  GL_MATRIX14_ARB = $88CE;
  GL_MATRIX15_ARB = $88CF;
  GL_MATRIX16_ARB = $88D0;
  GL_MATRIX17_ARB = $88D1;
  GL_MATRIX18_ARB = $88D2;
  GL_MATRIX19_ARB = $88D3;
  GL_MATRIX20_ARB = $88D4;
  GL_MATRIX21_ARB = $88D5;
  GL_MATRIX22_ARB = $88D6;
  GL_MATRIX23_ARB = $88D7;
  GL_MATRIX24_ARB = $88D8;
  GL_MATRIX25_ARB = $88D9;
  GL_MATRIX26_ARB = $88DA;
  GL_MATRIX27_ARB = $88DB;
  GL_MATRIX28_ARB = $88DC;
  GL_MATRIX29_ARB = $88DD;
  GL_MATRIX30_ARB = $88DE;
  GL_MATRIX31_ARB = $88DF;
var
  glVertexAttrib1sARB: procedure(index: GLuint; x: GLshort); extdecl;
  glVertexAttrib1fARB: procedure(index: GLuint; x: GLfloat); extdecl;
  glVertexAttrib1dARB: procedure(index: GLuint; x: GLdouble); extdecl;
  glVertexAttrib2sARB: procedure(index: GLuint; x: GLshort; y: GLshort); extdecl;
  glVertexAttrib2fARB: procedure(index: GLuint; x: GLfloat; y: GLfloat); extdecl;
  glVertexAttrib2dARB: procedure(index: GLuint; x: GLdouble; y: GLdouble); extdecl;
  glVertexAttrib3sARB: procedure(index: GLuint; x: GLshort; y: GLshort; z: GLshort); extdecl;
  glVertexAttrib3fARB: procedure(index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glVertexAttrib3dARB: procedure(index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble); extdecl;
  glVertexAttrib4sARB: procedure(index: GLuint; x: GLshort; y: GLshort; z: GLshort; w: GLshort); extdecl;
  glVertexAttrib4fARB: procedure(index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); extdecl;
  glVertexAttrib4dARB: procedure(index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); extdecl;
  glVertexAttrib4NubARB: procedure(index: GLuint; x: GLubyte; y: GLubyte; z: GLubyte; w: GLubyte); extdecl;
  glVertexAttrib1svARB: procedure(index: GLuint; const v: PGLshort); extdecl;
  glVertexAttrib1fvARB: procedure(index: GLuint; const v: PGLfloat); extdecl;
  glVertexAttrib1dvARB: procedure(index: GLuint; const v: PGLdouble); extdecl;
  glVertexAttrib2svARB: procedure(index: GLuint; const v: PGLshort); extdecl;
  glVertexAttrib2fvARB: procedure(index: GLuint; const v: PGLfloat); extdecl;
  glVertexAttrib2dvARB: procedure(index: GLuint; const v: PGLdouble); extdecl;
  glVertexAttrib3svARB: procedure(index: GLuint; const v: PGLshort); extdecl;
  glVertexAttrib3fvARB: procedure(index: GLuint; const v: PGLfloat); extdecl;
  glVertexAttrib3dvARB: procedure(index: GLuint; const v: PGLdouble); extdecl;
  glVertexAttrib4bvARB: procedure(index: GLuint; const v: PGLbyte); extdecl;
  glVertexAttrib4svARB: procedure(index: GLuint; const v: PGLshort); extdecl;
  glVertexAttrib4ivARB: procedure(index: GLuint; const v: PGLint); extdecl;
  glVertexAttrib4ubvARB: procedure(index: GLuint; const v: PGLubyte); extdecl;
  glVertexAttrib4usvARB: procedure(index: GLuint; const v: PGLushort); extdecl;
  glVertexAttrib4uivARB: procedure(index: GLuint; const v: PGLuint); extdecl;
  glVertexAttrib4fvARB: procedure(index: GLuint; const v: PGLfloat); extdecl;
  glVertexAttrib4dvARB: procedure(index: GLuint; const v: PGLdouble); extdecl;
  glVertexAttrib4NbvARB: procedure(index: GLuint; const v: PGLbyte); extdecl;
  glVertexAttrib4NsvARB: procedure(index: GLuint; const v: PGLshort); extdecl;
  glVertexAttrib4NivARB: procedure(index: GLuint; const v: PGLint); extdecl;
  glVertexAttrib4NubvARB: procedure(index: GLuint; const v: PGLubyte); extdecl;
  glVertexAttrib4NusvARB: procedure(index: GLuint; const v: PGLushort); extdecl;
  glVertexAttrib4NuivARB: procedure(index: GLuint; const v: PGLuint); extdecl;
  glVertexAttribPointerARB: procedure(index: GLuint; size: GLint; _type: GLenum; normalized: GLboolean; stride: GLsizei; const pointer: PGLvoid); extdecl;
  glEnableVertexAttribArrayARB: procedure(index: GLuint); extdecl;
  glDisableVertexAttribArrayARB: procedure(index: GLuint); extdecl;
  glProgramStringARB: procedure(target: GLenum; format: GLenum; len: GLsizei; const _string: PGLvoid); extdecl;
  glBindProgramARB: procedure(target: GLenum; _program: GLuint); extdecl;
  glDeleteProgramsARB: procedure(n: GLsizei; const programs: PGLuint); extdecl;
  glGenProgramsARB: procedure(n: GLsizei; programs: PGLuint); extdecl;
  glProgramEnvParameter4dARB: procedure(target: GLenum; index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); extdecl;
  glProgramEnvParameter4dvARB: procedure(target: GLenum; index: GLuint; const params: PGLdouble); extdecl;
  glProgramEnvParameter4fARB: procedure(target: GLenum; index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); extdecl;
  glProgramEnvParameter4fvARB: procedure(target: GLenum; index: GLuint; const params: PGLfloat); extdecl;
  glProgramLocalParameter4dARB: procedure(target: GLenum; index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); extdecl;
  glProgramLocalParameter4dvARB: procedure(target: GLenum; index: GLuint; const params: PGLdouble); extdecl;
  glProgramLocalParameter4fARB: procedure(target: GLenum; index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); extdecl;
  glProgramLocalParameter4fvARB: procedure(target: GLenum; index: GLuint; const params: PGLfloat); extdecl;
  glGetProgramEnvParameterdvARB: procedure(target: GLenum; index: GLuint; params: PGLdouble); extdecl;
  glGetProgramEnvParameterfvARB: procedure(target: GLenum; index: GLuint; params: PGLfloat); extdecl;
  glGetProgramLocalParameterdvARB: procedure(target: GLenum; index: GLuint; params: PGLdouble); extdecl;
  glGetProgramLocalParameterfvARB: procedure(target: GLenum; index: GLuint; params: PGLfloat); extdecl;
  glGetProgramivARB: procedure(target: GLenum; pname: GLenum; params: PGLint); extdecl;
  glGetProgramStringARB: procedure(target: GLenum; pname: GLenum; _string: PGLvoid); extdecl;
  glGetVertexAttribdvARB: procedure(index: GLuint; pname: GLenum; params: PGLdouble); extdecl;
  glGetVertexAttribfvARB: procedure(index: GLuint; pname: GLenum; params: PGLfloat); extdecl;
  glGetVertexAttribivARB: procedure(index: GLuint; pname: GLenum; params: PGLint); extdecl;
  glGetVertexAttribPointervARB: procedure(index: GLuint; pname: GLenum; pointer: PGLvoid); extdecl;
  glIsProgramARB: function(_program: GLuint): GLboolean; extdecl;

function Load_GL_ARB_vertex_program: Boolean;

//***** GL_ARB_window_pos *****//
var
  glWindowPos2dARB: procedure(x: GLdouble; y: GLdouble); extdecl;
  glWindowPos2fARB: procedure(x: GLfloat; y: GLfloat); extdecl;
  glWindowPos2iARB: procedure(x: GLint; y: GLint); extdecl;
  glWindowPos2sARB: procedure(x: GLshort; y: GLshort); extdecl;
  glWindowPos2dvARB: procedure(const p: PGLdouble); extdecl;
  glWindowPos2fvARB: procedure(const p: PGLfloat); extdecl;
  glWindowPos2ivARB: procedure(const p: PGLint); extdecl;
  glWindowPos2svARB: procedure(const p: PGLshort); extdecl;
  glWindowPos3dARB: procedure(x: GLdouble; y: GLdouble; z: GLdouble); extdecl;
  glWindowPos3fARB: procedure(x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glWindowPos3iARB: procedure(x: GLint; y: GLint; z: GLint); extdecl;
  glWindowPos3sARB: procedure(x: GLshort; y: GLshort; z: GLshort); extdecl;
  glWindowPos3dvARB: procedure(const p: PGLdouble); extdecl;
  glWindowPos3fvARB: procedure(const p: PGLfloat); extdecl;
  glWindowPos3ivARB: procedure(const p: PGLint); extdecl;
  glWindowPos3svARB: procedure(const p: PGLshort); extdecl;

function Load_GL_ARB_window_pos: Boolean;

//***** GL_EXT_422_pixels *****//
const
  GL_422_EXT = $80CC;
  GL_422_REV_EXT = $80CD;
  GL_422_AVERAGE_EXT = $80CE;
  GL_422_REV_AVERAGE_EXT = $80CF;

function Load_GL_EXT_422_pixels: Boolean;

//***** GL_EXT_abgr *****//
const
  GL_ABGR_EXT = $8000;

function Load_GL_EXT_abgr: Boolean;

//***** GL_EXT_bgra *****//
const
  GL_BGR_EXT = $80E0;
  GL_BGRA_EXT = $80E1;

function Load_GL_EXT_bgra: Boolean;

//***** GL_EXT_blend_color *****//
const
  GL_CONSTANT_COLOR_EXT = $8001;
  GL_ONE_MINUS_CONSTANT_COLOR_EXT = $8002;
  GL_CONSTANT_ALPHA_EXT = $8003;
  GL_ONE_MINUS_CONSTANT_ALPHA_EXT = $8004;
  GL_BLEND_COLOR_EXT = $8005;
var
  glBlendColorEXT: procedure(red: GLclampf; green: GLclampf; blue: GLclampf; alpha: GLclampf); extdecl;

function Load_GL_EXT_blend_color: Boolean;

//***** GL_EXT_blend_func_separate *****//
const
  GL_BLEND_DST_RGB_EXT = $80C8;
  GL_BLEND_SRC_RGB_EXT = $80C9;
  GL_BLEND_DST_ALPHA_EXT = $80CA;
  GL_BLEND_SRC_ALPHA_EXT = $80CB;
var
  glBlendFuncSeparateEXT: procedure(sfactorRGB: GLenum; dfactorRGB: GLenum; sfactorAlpha: GLenum; dfactorAlpha: GLenum); extdecl;

function Load_GL_EXT_blend_func_separate: Boolean;

//***** GL_EXT_blend_logic_op *****//

function Load_GL_EXT_blend_logic_op: Boolean;

//***** GL_EXT_blend_minmax *****//
const
  GL_FUNC_ADD_EXT = $8006;
  GL_MIN_EXT = $8007;
  GL_MAX_EXT = $8008;
  GL_BLEND_EQUATION_EXT = $8009;
var
  glBlendEquationEXT: procedure(mode: GLenum); extdecl;

function Load_GL_EXT_blend_minmax: Boolean;

//***** GL_EXT_blend_subtract *****//
const
  GL_FUNC_SUBTRACT_EXT = $800A;
  GL_FUNC_REVERSE_SUBTRACT_EXT = $800B;

function Load_GL_EXT_blend_subtract: Boolean;

//***** GL_EXT_clip_volume_hint *****//
const
  GL_CLIP_VOLUME_CLIPPING_HINT_EXT = $80F0;

function Load_GL_EXT_clip_volume_hint: Boolean;

//***** GL_EXT_color_subtable *****//
var
  glColorSubTableEXT: procedure(target: GLenum; start: GLsizei; count: GLsizei; format: GLenum; _type: GLenum; const data: PGLvoid); extdecl;
  glCopyColorSubTableEXT: procedure(target: GLenum; start: GLsizei; x: GLint; y: GLint; width: GLsizei); extdecl;

function Load_GL_EXT_color_subtable: Boolean;

//***** GL_EXT_compiled_vertex_array *****//
const
  GL_ARRAY_ELEMENT_LOCK_FIRST_EXT = $81A8;
  GL_ARRAY_ELEMENT_LOCK_COUNT_EXT = $81A9;
var
  glLockArraysEXT: procedure(first: GLint; count: GLsizei); extdecl;
  glUnlockArraysEXT: procedure(); extdecl;

function Load_GL_EXT_compiled_vertex_array: Boolean;

//***** GL_EXT_convolution *****//
const
  GL_CONVOLUTION_1D_EXT = $8010;
  GL_CONVOLUTION_2D_EXT = $8011;
  GL_SEPARABLE_2D_EXT = $8012;
  GL_CONVOLUTION_BORDER_MODE_EXT = $8013;
  GL_CONVOLUTION_FILTER_SCALE_EXT = $8014;
  GL_CONVOLUTION_FILTER_BIAS_EXT = $8015;
  GL_REDUCE_EXT = $8016;
  GL_CONVOLUTION_FORMAT_EXT = $8017;
  GL_CONVOLUTION_WIDTH_EXT = $8018;
  GL_CONVOLUTION_HEIGHT_EXT = $8019;
  GL_MAX_CONVOLUTION_WIDTH_EXT = $801A;
  GL_MAX_CONVOLUTION_HEIGHT_EXT = $801B;
  GL_POST_CONVOLUTION_RED_SCALE_EXT = $801C;
  GL_POST_CONVOLUTION_GREEN_SCALE_EXT = $801D;
  GL_POST_CONVOLUTION_BLUE_SCALE_EXT = $801E;
  GL_POST_CONVOLUTION_ALPHA_SCALE_EXT = $801F;
  GL_POST_CONVOLUTION_RED_BIAS_EXT = $8020;
  GL_POST_CONVOLUTION_GREEN_BIAS_EXT = $8021;
  GL_POST_CONVOLUTION_BLUE_BIAS_EXT = $8022;
  GL_POST_CONVOLUTION_ALPHA_BIAS_EXT = $8023;
var
  glConvolutionFilter1DEXT: procedure(target: GLenum; internalformat: GLenum; width: GLsizei; format: GLenum; _type: GLenum; const image: PGLvoid); extdecl;
  glConvolutionFilter2DEXT: procedure(target: GLenum; internalformat: GLenum; width: GLsizei; height: GLsizei; format: GLenum; _type: GLenum; const image: PGLvoid); extdecl;
  glCopyConvolutionFilter1DEXT: procedure(target: GLenum; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei); extdecl;
  glCopyConvolutionFilter2DEXT: procedure(target: GLenum; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei; height: GLsizei); extdecl;
  glGetConvolutionFilterEXT: procedure(target: GLenum; format: GLenum; _type: GLenum; image: PGLvoid); extdecl;
  glSeparableFilter2DEXT: procedure(target: GLenum; internalformat: GLenum; width: GLsizei; height: GLsizei; format: GLenum; _type: GLenum; const row: PGLvoid; const column: PGLvoid); extdecl;
  glGetSeparableFilterEXT: procedure(target: GLenum; format: GLenum; _type: GLenum; row: PGLvoid; column: PGLvoid; span: PGLvoid); extdecl;
  glConvolutionParameteriEXT: procedure(target: GLenum; pname: GLenum; param: GLint); extdecl;
  glConvolutionParameterivEXT: procedure(target: GLenum; pname: GLenum; const params: PGLint); extdecl;
  glConvolutionParameterfEXT: procedure(target: GLenum; pname: GLenum; param: GLfloat); extdecl;
  glConvolutionParameterfvEXT: procedure(target: GLenum; pname: GLenum; const params: PGLfloat); extdecl;
  glGetConvolutionParameterivEXT: procedure(target: GLenum; pname: GLenum; params: PGLint); extdecl;
  glGetConvolutionParameterfvEXT: procedure(target: GLenum; pname: GLenum; params: PGLfloat); extdecl;

function Load_GL_EXT_convolution: Boolean;

//***** GL_EXT_fog_coord *****//
const
  GL_FOG_COORDINATE_SOURCE_EXT = $8450;
  GL_FOG_COORDINATE_EXT = $8451;
  GL_FRAGMENT_DEPTH_EXT = $8452;
  GL_CURRENT_FOG_COORDINATE_EXT = $8453;
  GL_FOG_COORDINATE_ARRAY_TYPE_EXT = $8454;
  GL_FOG_COORDINATE_ARRAY_STRIDE_EXT = $8455;
  GL_FOG_COORDINATE_ARRAY_POINTER_EXT = $8456;
  GL_FOG_COORDINATE_ARRAY_EXT = $8457;
var
  glFogCoordfEXfloat: procedure(coord: GLfloat); extdecl;
  glFogCoorddEXdouble: procedure(coord: GLdouble); extdecl;
  glFogCoordfvEXfloat: procedure(coord: GLfloat); extdecl;
  glFogCoorddvEXdouble: procedure(coord: GLdouble); extdecl;
  glFogCoordPointerEXT: procedure(_type: GLenum; stride: GLsizei; pointer: PGLvoid); extdecl;

function Load_GL_EXT_fog_coord: Boolean;

//***** GL_EXT_histogram *****//
const
  GL_HISTOGRAM_EXT = $8024;
  GL_PROXY_HISTOGRAM_EXT = $8025;
  GL_HISTOGRAM_WIDTH_EXT = $8026;
  GL_HISTOGRAM_FORMAT_EXT = $8027;
  GL_HISTOGRAM_RED_SIZE_EXT = $8028;
  GL_HISTOGRAM_GREEN_SIZE_EXT = $8029;
  GL_HISTOGRAM_BLUE_SIZE_EXT = $802A;
  GL_HISTOGRAM_ALPHA_SIZE_EXT = $802B;
  GL_HISTOGRAM_LUMINANCE_SIZE_EXT = $802C;
  GL_HISTOGRAM_SINK_EXT = $802D;
  GL_MINMAX_EXT = $802E;
  GL_MINMAX_FORMAT_EXT = $802F;
  GL_MINMAX_SINK_EXT = $8030;
var
  glHistogramEXT: procedure(target: GLenum; width: GLsizei; internalformat: GLenum; sink: GLboolean); extdecl;
  glResetHistogramEXT: procedure(target: GLenum); extdecl;
  glGetHistogramEXT: procedure(target: GLenum; reset: GLboolean; format: GLenum; _type: GLenum; values: PGLvoid); extdecl;
  glGetHistogramParameterivEXT: procedure(target: GLenum; pname: GLenum; params: PGLint); extdecl;
  glGetHistogramParameterfvEXT: procedure(target: GLenum; pname: GLenum; params: PGLfloat); extdecl;
  glMinmaxEXT: procedure(target: GLenum; internalformat: GLenum; sink: GLboolean); extdecl;
  glResetMinmaxEXT: procedure(target: GLenum); extdecl;
  glGetMinmaxEXT: procedure(target: GLenum; reset: GLboolean; format: GLenum; _type: GLenum; values: PGLvoid); extdecl;
  glGetMinmaxParameterivEXT: procedure(target: GLenum; pname: GLenum; params: PGLint); extdecl;
  glGetMinmaxParameterfvEXT: procedure(target: GLenum; pname: GLenum; params: PGLfloat); extdecl;

function Load_GL_EXT_histogram: Boolean;

//***** GL_EXT_multi_draw_arrays *****//
var
  glMultiDrawArraysEXT: procedure(mode: GLenum; first: PGLint; count: PGLsizei; primcount: GLsizei); extdecl;
  glMultiDrawElementsEXT: procedure(mode: GLenum; count: PGLsizei; _type: GLenum; const indices: PGLvoid; primcount: GLsizei); extdecl;

function Load_GL_EXT_multi_draw_arrays: Boolean;

//***** GL_EXT_packed_pixels *****//
const
  GL_UNSIGNED_BYTE_3_3_2_EXT = $8032;
  GL_UNSIGNED_SHORT_4_4_4_4_EXT = $8033;
  GL_UNSIGNED_SHORT_5_5_5_1_EXT = $8034;
  GL_UNSIGNED_INT_8_8_8_8_EXT = $8035;
  GL_UNSIGNED_INT_10_10_10_2_EXT = $8036;

function Load_GL_EXT_packed_pixels: Boolean;

//***** GL_EXT_paletted_texture *****//
const
  GL_COLOR_INDEX1_EXT = $80E2;
  GL_COLOR_INDEX2_EXT = $80E3;
  GL_COLOR_INDEX4_EXT = $80E4;
  GL_COLOR_INDEX8_EXT = $80E5;
  GL_COLOR_INDEX12_EXT = $80E6;
  GL_COLOR_INDEX16_EXT = $80E7;
  GL_COLOR_TABLE_FORMAT_EXT = $80D8;
  GL_COLOR_TABLE_WIDTH_EXT = $80D9;
  GL_COLOR_TABLE_RED_SIZE_EXT = $80DA;
  GL_COLOR_TABLE_GREEN_SIZE_EXT = $80DB;
  GL_COLOR_TABLE_BLUE_SIZE_EXT = $80DC;
  GL_COLOR_TABLE_ALPHA_SIZE_EXT = $80DD;
  GL_COLOR_TABLE_LUMINANCE_SIZE_EXT = $80DE;
  GL_COLOR_TABLE_INTENSITY_SIZE_EXT = $80DF;
  GL_TEXTURE_INDEX_SIZE_EXT = $80ED;
  GL_TEXTURE_1D = $0DE0;
  GL_TEXTURE_2D = $0DE1;
  GL_TEXTURE_3D_EXT = $806F;
  // GL_TEXTURE_CUBE_MAP_ARB  { already defined }
  GL_PROXY_TEXTURE_1D = $8063;
  GL_PROXY_TEXTURE_2D = $8064;
  GL_PROXY_TEXTURE_3D_EXT = $8070;
  // GL_PROXY_TEXTURE_CUBE_MAP_ARB  { already defined }
  // GL_TEXTURE_1D  { already defined }
  // GL_TEXTURE_2D  { already defined }
  // GL_TEXTURE_3D_EXT  { already defined }
  // GL_TEXTURE_CUBE_MAP_ARB  { already defined }
var
  glColorTableEXT: procedure(target: GLenum; internalFormat: GLenum; width: GLsizei; format: GLenum; _type: GLenum; const data: PGLvoid); extdecl;
  // glColorSubTableEXT  { already defined }
  glGetColorTableEXT: procedure(target: GLenum; format: GLenum; _type: GLenum; data: PGLvoid); extdecl;
  glGetColorTableParameterivEXT: procedure(target: GLenum; pname: GLenum; params: PGLint); extdecl;
  glGetColorTableParameterfvEXT: procedure(target: GLenum; pname: GLenum; params: PGLfloat); extdecl;

function Load_GL_EXT_paletted_texture: Boolean;

//***** GL_EXT_point_parameters *****//
const
  GL_POINT_SIZE_MIN_EXT = $8126;
  GL_POINT_SIZE_MAX_EXT = $8127;
  GL_POINT_FADE_THRESHOLD_SIZE_EXT = $8128;
  GL_DISTANCE_ATTENUATION_EXT = $8129;
var
  glPointParameterfEXT: procedure(pname: GLenum; param: GLfloat); extdecl;
  glPointParameterfvEXT: procedure(pname: GLenum; params: PGLfloat); extdecl;

function Load_GL_EXT_point_parameters: Boolean;

//***** GL_EXT_polygon_offset *****//
const
  GL_POLYGON_OFFSET_EXT = $8037;
  GL_POLYGON_OFFSET_FACTOR_EXT = $8038;
  GL_POLYGON_OFFSET_BIAS_EXT = $8039;
var
  glPolygonOffsetEXT: procedure(factor: GLfloat; bias: GLfloat); extdecl;

function Load_GL_EXT_polygon_offset: Boolean;

//***** GL_EXT_secondary_color *****//
const
  GL_COLOR_SUM_EXT = $8458;
  GL_CURRENT_SECONDARY_COLOR_EXT = $8459;
  GL_SECONDARY_COLOR_ARRAY_SIZE_EXT = $845A;
  GL_SECONDARY_COLOR_ARRAY_TYPE_EXT = $845B;
  GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT = $845C;
  GL_SECONDARY_COLOR_ARRAY_POINTER_EXT = $845D;
  GL_SECONDARY_COLOR_ARRAY_EXT = $845E;
var
  glSecondaryColor3bEXT: procedure(components: GLbyte); extdecl;
  glSecondaryColor3sEXT: procedure(components: GLshort); extdecl;
  glSecondaryColor3iEXT: procedure(components: GLint); extdecl;
  glSecondaryColor3fEXT: procedure(components: GLfloat); extdecl;
  glSecondaryColor3dEXT: procedure(components: GLdouble); extdecl;
  glSecondaryColor3ubEXT: procedure(components: GLubyte); extdecl;
  glSecondaryColor3usEXT: procedure(components: GLushort); extdecl;
  glSecondaryColor3uiEXT: procedure(components: GLuint); extdecl;
  glSecondaryColor3bvEXT: procedure(components: GLbyte); extdecl;
  glSecondaryColor3svEXT: procedure(components: GLshort); extdecl;
  glSecondaryColor3ivEXT: procedure(components: GLint); extdecl;
  glSecondaryColor3fvEXT: procedure(components: GLfloat); extdecl;
  glSecondaryColor3dvEXT: procedure(components: GLdouble); extdecl;
  glSecondaryColor3ubvEXT: procedure(components: GLubyte); extdecl;
  glSecondaryColor3usvEXT: procedure(components: GLushort); extdecl;
  glSecondaryColor3uivEXT: procedure(components: GLuint); extdecl;
  glSecondaryColorPointerEXT: procedure(size: GLint; _type: GLenum; stride: GLsizei; pointer: PGLvoid); extdecl;

function Load_GL_EXT_secondary_color: Boolean;

//***** GL_EXT_separate_specular_color *****//
const
  GL_LIGHT_MODEL_COLOR_CONTROL_EXT = $81F8;
  GL_SINGLE_COLOR_EXT = $81F9;
  GL_SEPARATE_SPECULAR_COLOR_EXT = $81FA;

function Load_GL_EXT_separate_specular_color: Boolean;

//***** GL_EXT_shadow_funcs *****//

function Load_GL_EXT_shadow_funcs: Boolean;

//***** GL_EXT_shared_texture_palette *****//
const
  GL_SHARED_TEXTURE_PALETTE_EXT = $81FB;

function Load_GL_EXT_shared_texture_palette: Boolean;

//***** GL_EXT_stencil_two_side *****//
const
  GL_STENCIL_TEST_TWO_SIDE_EXT = $8910;
  GL_ACTIVE_STENCIL_FACE_EXT = $8911;
var
  glActiveStencilFaceEXT: procedure(face: GLenum); extdecl;

function Load_GL_EXT_stencil_two_side: Boolean;

//***** GL_EXT_stencil_wrap *****//
const
  GL_INCR_WRAP_EXT = $8507;
  GL_DECR_WRAP_EXT = $8508;

function Load_GL_EXT_stencil_wrap: Boolean;

//***** GL_EXT_subtexture *****//
var
  glTexSubImage1DEXT: procedure(target: GLenum; level: GLint; xoffset: GLint; width: GLsizei; format: GLenum; _type: GLenum; const pixels: PGLvoid); extdecl;
  glTexSubImage2DEXT: procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; width: GLsizei; height: GLsizei; format: GLenum; _type: GLenum; const pixels: PGLvoid); extdecl;
  glTexSubImage3DEXT: procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; _type: GLenum; const pixels: PGLvoid); extdecl;

function Load_GL_EXT_subtexture: Boolean;

//***** GL_EXT_texture3D *****//
const
  GL_PACK_SKIP_IMAGES_EXT = $806B;
  GL_PACK_IMAGE_HEIGHT_EXT = $806C;
  GL_UNPACK_SKIP_IMAGES_EXT = $806D;
  GL_UNPACK_IMAGE_HEIGHT_EXT = $806E;
  // GL_TEXTURE_3D_EXT  { already defined }
  // GL_PROXY_TEXTURE_3D_EXT  { already defined }
  GL_TEXTURE_DEPTH_EXT = $8071;
  GL_TEXTURE_WRAP_R_EXT = $8072;
  GL_MAX_3D_TEXTURE_SIZE_EXT = $8073;
var
  glTexImage3DEXT: procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; border: GLint; format: GLenum; _type: GLenum; const pixels: PGLvoid); extdecl;

function Load_GL_EXT_texture3D: Boolean;

//***** GL_EXT_texture_compression_s3tc *****//
const
  GL_COMPRESSED_RGB_S3TC_DXT1_EXT = $83F0;
  GL_COMPRESSED_RGBA_S3TC_DXT1_EXT = $83F1;
  GL_COMPRESSED_RGBA_S3TC_DXT3_EXT = $83F2;
  GL_COMPRESSED_RGBA_S3TC_DXT5_EXT = $83F3;

function Load_GL_EXT_texture_compression_s3tc: Boolean;

//***** GL_EXT_texture_env_add *****//

function Load_GL_EXT_texture_env_add: Boolean;

//***** GL_EXT_texture_env_combine *****//
const
  GL_COMBINE_EXT = $8570;
  GL_COMBINE_RGB_EXT = $8571;
  GL_COMBINE_ALPHA_EXT = $8572;
  GL_SOURCE0_RGB_EXT = $8580;
  GL_SOURCE1_RGB_EXT = $8581;
  GL_SOURCE2_RGB_EXT = $8582;
  GL_SOURCE0_ALPHA_EXT = $8588;
  GL_SOURCE1_ALPHA_EXT = $8589;
  GL_SOURCE2_ALPHA_EXT = $858A;
  GL_OPERAND0_RGB_EXT = $8590;
  GL_OPERAND1_RGB_EXT = $8591;
  GL_OPERAND2_RGB_EXT = $8592;
  GL_OPERAND0_ALPHA_EXT = $8598;
  GL_OPERAND1_ALPHA_EXT = $8599;
  GL_OPERAND2_ALPHA_EXT = $859A;
  GL_RGB_SCALE_EXT = $8573;
  GL_ADD_SIGNED_EXT = $8574;
  GL_INTERPOLATE_EXT = $8575;
  GL_CONSTANT_EXT = $8576;
  GL_PRIMARY_COLOR_EXT = $8577;
  GL_PREVIOUS_EXT = $8578;

function Load_GL_EXT_texture_env_combine: Boolean;

//***** GL_EXT_texture_env_dot3 *****//
const
  GL_DOT3_RGB_EXT = $8740;
  GL_DOT3_RGBA_EXT = $8741;

function Load_GL_EXT_texture_env_dot3: Boolean;

//***** GL_EXT_texture_filter_anisotropic *****//
const
  GL_TEXTURE_MAX_ANISOTROPY_EXT = $84FE;
  GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT = $84FF;

function Load_GL_EXT_texture_filter_anisotropic: Boolean;

//***** GL_EXT_texture_lod_bias *****//
const
  GL_TEXTURE_FILTER_CONTROL_EXT = $8500;
  GL_TEXTURE_LOD_BIAS_EXT = $8501;
  GL_MAX_TEXTURE_LOD_BIAS_EXT = $84FD;

function Load_GL_EXT_texture_lod_bias: Boolean;

//***** GL_EXT_texture_object *****//
const
  GL_TEXTURE_PRIORITY_EXT = $8066;
  GL_TEXTURE_RESIDENT_EXT = $8067;
  GL_TEXTURE_1D_BINDING_EXT = $8068;
  GL_TEXTURE_2D_BINDING_EXT = $8069;
  GL_TEXTURE_3D_BINDING_EXT = $806A;
var
  glGenTexturesEXT: procedure(n: GLsizei; textures: PGLuint); extdecl;
  glDeleteTexturesEXT: procedure(n: GLsizei; const textures: PGLuint); extdecl;
  glBindTextureEXT: procedure(target: GLenum; texture: GLuint); extdecl;
  glPrioritizeTexturesEXT: procedure(n: GLsizei; const textures: PGLuint; const priorities: PGLclampf); extdecl;
  glAreTexturesResidentEXT: function(n: GLsizei; const textures: PGLuint; residences: PGLboolean): GLboolean; extdecl;
  glIsTextureEXT: function(texture: GLuint): GLboolean; extdecl;

function Load_GL_EXT_texture_object: Boolean;

//***** GL_EXT_vertex_array *****//
const
  GL_VERTEX_ARRAY_EXT = $8074;
  GL_NORMAL_ARRAY_EXT = $8075;
  GL_COLOR_ARRAY_EXT = $8076;
  GL_INDEX_ARRAY_EXT = $8077;
  GL_TEXTURE_COORD_ARRAY_EXT = $8078;
  GL_EDGE_FLAG_ARRAY_EXT = $8079;
  GL_DOUBLE_EXT = $140A;
  GL_VERTEX_ARRAY_SIZE_EXT = $807A;
  GL_VERTEX_ARRAY_TYPE_EXT = $807B;
  GL_VERTEX_ARRAY_STRIDE_EXT = $807C;
  GL_VERTEX_ARRAY_COUNT_EXT = $807D;
  GL_NORMAL_ARRAY_TYPE_EXT = $807E;
  GL_NORMAL_ARRAY_STRIDE_EXT = $807F;
  GL_NORMAL_ARRAY_COUNT_EXT = $8080;
  GL_COLOR_ARRAY_SIZE_EXT = $8081;
  GL_COLOR_ARRAY_TYPE_EXT = $8082;
  GL_COLOR_ARRAY_STRIDE_EXT = $8083;
  GL_COLOR_ARRAY_COUNT_EXT = $8084;
  GL_INDEX_ARRAY_TYPE_EXT = $8085;
  GL_INDEX_ARRAY_STRIDE_EXT = $8086;
  GL_INDEX_ARRAY_COUNT_EXT = $8087;
  GL_TEXTURE_COORD_ARRAY_SIZE_EXT = $8088;
  GL_TEXTURE_COORD_ARRAY_TYPE_EXT = $8089;
  GL_TEXTURE_COORD_ARRAY_STRIDE_EXT = $808A;
  GL_TEXTURE_COORD_ARRAY_COUNT_EXT = $808B;
  GL_EDGE_FLAG_ARRAY_STRIDE_EXT = $808C;
  GL_EDGE_FLAG_ARRAY_COUNT_EXT = $808D;
  GL_VERTEX_ARRAY_POINTER_EXT = $808E;
  GL_NORMAL_ARRAY_POINTER_EXT = $808F;
  GL_COLOR_ARRAY_POINTER_EXT = $8090;
  GL_INDEX_ARRAY_POINTER_EXT = $8091;
  GL_TEXTURE_COORD_ARRAY_POINTER_EXT = $8092;
  GL_EDGE_FLAG_ARRAY_POINTER_EXT = $8093;
var
  glArrayElementEXT: procedure(i: GLint); extdecl;
  glDrawArraysEXT: procedure(mode: GLenum; first: GLint; count: GLsizei); extdecl;
  glVertexPointerEXT: procedure(size: GLint; _type: GLenum; stride: GLsizei; count: GLsizei; const pointer: PGLvoid); extdecl;
  glNormalPointerEXT: procedure(_type: GLenum; stride: GLsizei; count: GLsizei; const pointer: PGLvoid); extdecl;
  glColorPointerEXT: procedure(size: GLint; _type: GLenum; stride: GLsizei; count: GLsizei; const pointer: PGLvoid); extdecl;
  glIndexPointerEXT: procedure(_type: GLenum; stride: GLsizei; count: GLsizei; const pointer: PGLvoid); extdecl;
  glTexCoordPointerEXT: procedure(size: GLint; _type: GLenum; stride: GLsizei; count: GLsizei; const pointer: PGLvoid); extdecl;
  glEdgeFlagPointerEXT: procedure(stride: GLsizei; count: GLsizei; const pointer: PGLboolean); extdecl;
  glGetPointervEXT: procedure(pname: GLenum; params: PGLvoid); extdecl;

function Load_GL_EXT_vertex_array: Boolean;

//***** GL_EXT_vertex_shader *****//
const
  GL_VERTEX_SHADER_EXT = $8780;
  GL_VARIANT_VALUE_EXT = $87E4;
  GL_VARIANT_DATATYPE_EXT = $87E5;
  GL_VARIANT_ARRAY_STRIDE_EXT = $87E6;
  GL_VARIANT_ARRAY_TYPE_EXT = $87E7;
  GL_VARIANT_ARRAY_EXT = $87E8;
  GL_VARIANT_ARRAY_POINTER_EXT = $87E9;
  GL_INVARIANT_VALUE_EXT = $87EA;
  GL_INVARIANT_DATATYPE_EXT = $87EB;
  GL_LOCAL_CONSTANT_VALUE_EXT = $87EC;
  GL_LOCAL_CONSTANT_DATATYPE_EXT = $87ED;
  GL_OP_INDEX_EXT = $8782;
  GL_OP_NEGATE_EXT = $8783;
  GL_OP_DOT3_EXT = $8784;
  GL_OP_DOT4_EXT = $8785;
  GL_OP_MUL_EXT = $8786;
  GL_OP_ADD_EXT = $8787;
  GL_OP_MADD_EXT = $8788;
  GL_OP_FRAC_EXT = $8789;
  GL_OP_MAX_EXT = $878A;
  GL_OP_MIN_EXT = $878B;
  GL_OP_SET_GE_EXT = $878C;
  GL_OP_SET_LT_EXT = $878D;
  GL_OP_CLAMP_EXT = $878E;
  GL_OP_FLOOR_EXT = $878F;
  GL_OP_ROUND_EXT = $8790;
  GL_OP_EXP_BASE_2_EXT = $8791;
  GL_OP_LOG_BASE_2_EXT = $8792;
  GL_OP_POWER_EXT = $8793;
  GL_OP_RECIP_EXT = $8794;
  GL_OP_RECIP_SQRT_EXT = $8795;
  GL_OP_SUB_EXT = $8796;
  GL_OP_CROSS_PRODUCT_EXT = $8797;
  GL_OP_MULTIPLY_MATRIX_EXT = $8798;
  GL_OP_MOV_EXT = $8799;
  GL_OUTPUT_VERTEX_EXT = $879A;
  GL_OUTPUT_COLOR0_EXT = $879B;
  GL_OUTPUT_COLOR1_EXT = $879C;
  GL_OUTPUT_TEXTURE_COORD0_EXT = $879D;
  GL_OUTPUT_TEXTURE_COORD1_EXT = $879E;
  GL_OUTPUT_TEXTURE_COORD2_EXT = $879F;
  GL_OUTPUT_TEXTURE_COORD3_EXT = $87A0;
  GL_OUTPUT_TEXTURE_COORD4_EXT = $87A1;
  GL_OUTPUT_TEXTURE_COORD5_EXT = $87A2;
  GL_OUTPUT_TEXTURE_COORD6_EXT = $87A3;
  GL_OUTPUT_TEXTURE_COORD7_EXT = $87A4;
  GL_OUTPUT_TEXTURE_COORD8_EXT = $87A5;
  GL_OUTPUT_TEXTURE_COORD9_EXT = $87A6;
  GL_OUTPUT_TEXTURE_COORD10_EXT = $87A7;
  GL_OUTPUT_TEXTURE_COORD11_EXT = $87A8;
  GL_OUTPUT_TEXTURE_COORD12_EXT = $87A9;
  GL_OUTPUT_TEXTURE_COORD13_EXT = $87AA;
  GL_OUTPUT_TEXTURE_COORD14_EXT = $87AB;
  GL_OUTPUT_TEXTURE_COORD15_EXT = $87AC;
  GL_OUTPUT_TEXTURE_COORD16_EXT = $87AD;
  GL_OUTPUT_TEXTURE_COORD17_EXT = $87AE;
  GL_OUTPUT_TEXTURE_COORD18_EXT = $87AF;
  GL_OUTPUT_TEXTURE_COORD19_EXT = $87B0;
  GL_OUTPUT_TEXTURE_COORD20_EXT = $87B1;
  GL_OUTPUT_TEXTURE_COORD21_EXT = $87B2;
  GL_OUTPUT_TEXTURE_COORD22_EXT = $87B3;
  GL_OUTPUT_TEXTURE_COORD23_EXT = $87B4;
  GL_OUTPUT_TEXTURE_COORD24_EXT = $87B5;
  GL_OUTPUT_TEXTURE_COORD25_EXT = $87B6;
  GL_OUTPUT_TEXTURE_COORD26_EXT = $87B7;
  GL_OUTPUT_TEXTURE_COORD27_EXT = $87B8;
  GL_OUTPUT_TEXTURE_COORD28_EXT = $87B9;
  GL_OUTPUT_TEXTURE_COORD29_EXT = $87BA;
  GL_OUTPUT_TEXTURE_COORD30_EXT = $87BB;
  GL_OUTPUT_TEXTURE_COORD31_EXT = $87BC;
  GL_OUTPUT_FOG_EXT = $87BD;
  GL_SCALAR_EXT = $87BE;
  GL_VECTOR_EXT = $87BF;
  GL_MATRIX_EXT = $87C0;
  GL_VARIANT_EXT = $87C1;
  GL_INVARIANT_EXT = $87C2;
  GL_LOCAL_CONSTANT_EXT = $87C3;
  GL_LOCAL_EXT = $87C4;
  GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT = $87C5;
  GL_MAX_VERTEX_SHADER_VARIANTS_EXT = $87C6;
  GL_MAX_VERTEX_SHADER_INVARIANTS_EXT = $87C7;
  GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = $87C8;
  GL_MAX_VERTEX_SHADER_LOCALS_EXT = $87C9;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT = $87CA;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT = $87CB;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = $87CC;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT = $87CD;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT = $87CE;
  GL_VERTEX_SHADER_INSTRUCTIONS_EXT = $87CF;
  GL_VERTEX_SHADER_VARIANTS_EXT = $87D0;
  GL_VERTEX_SHADER_INVARIANTS_EXT = $87D1;
  GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = $87D2;
  GL_VERTEX_SHADER_LOCALS_EXT = $87D3;
  GL_VERTEX_SHADER_BINDING_EXT = $8781;
  GL_VERTEX_SHADER_OPTIMIZED_EXT = $87D4;
  GL_X_EXT = $87D5;
  GL_Y_EXT = $87D6;
  GL_Z_EXT = $87D7;
  GL_W_EXT = $87D8;
  GL_NEGATIVE_X_EXT = $87D9;
  GL_NEGATIVE_Y_EXT = $87DA;
  GL_NEGATIVE_Z_EXT = $87DB;
  GL_NEGATIVE_W_EXT = $87DC;
  GL_ZERO_EXT = $87DD;
  GL_ONE_EXT = $87DE;
  GL_NEGATIVE_ONE_EXT = $87DF;
  GL_NORMALIZED_RANGE_EXT = $87E0;
  GL_FULL_RANGE_EXT = $87E1;
  GL_CURRENT_VERTEX_EXT = $87E2;
  GL_MVP_MATRIX_EXT = $87E3;
var
  glBeginVertexShaderEXT: procedure(); extdecl;
  glEndVertexShaderEXT: procedure(); extdecl;
  glBindVertexShaderEXT: procedure(id: GLuint); extdecl;
  glGenVertexShadersEXT: function(range: GLuint): GLuint; extdecl;
  glDeleteVertexShaderEXT: procedure(id: GLuint); extdecl;
  glShaderOp1EXT: procedure(op: GLenum; res: GLuint; arg1: GLuint); extdecl;
  glShaderOp2EXT: procedure(op: GLenum; res: GLuint; arg1: GLuint; arg2: GLuint); extdecl;
  glShaderOp3EXT: procedure(op: GLenum; res: GLuint; arg1: GLuint; arg2: GLuint; arg3: GLuint); extdecl;
  glSwizzleEXT: procedure(res: GLuint; _in: GLuint; outX: GLenum; outY: GLenum; outZ: GLenum; outW: GLenum); extdecl;
  glWriteMaskEXT: procedure(res: GLuint; _in: GLuint; outX: GLenum; outY: GLenum; outZ: GLenum; outW: GLenum); extdecl;
  glInsertComponentEXT: procedure(res: GLuint; src: GLuint; num: GLuint); extdecl;
  glExtractComponentEXT: procedure(res: GLuint; src: GLuint; num: GLuint); extdecl;
  glGenSymbolsEXT: function(datatype: GLenum; storagetype: GLenum; range: GLenum; components: GLuint): GLuint; extdecl;
  glSetInvariantEXT: procedure(id: GLuint; _type: GLenum; addr: PGLvoid); extdecl;
  glSetLocalConstantEXT: procedure(id: GLuint; _type: GLenum; addr: PGLvoid); extdecl;
  glVariantbvEXT: procedure(id: GLuint; addr: PGLbyte); extdecl;
  glVariantsvEXT: procedure(id: GLuint; addr: PGLshort); extdecl;
  glVariantivEXT: procedure(id: GLuint; addr: PGLint); extdecl;
  glVariantfvEXT: procedure(id: GLuint; addr: PGLfloat); extdecl;
  glVariantdvEXT: procedure(id: GLuint; addr: PGLdouble); extdecl;
  glVariantubvEXT: procedure(id: GLuint; addr: PGLubyte); extdecl;
  glVariantusvEXT: procedure(id: GLuint; addr: PGLushort); extdecl;
  glVariantuivEXT: procedure(id: GLuint; addr: PGLuint); extdecl;
  glVariantPointerEXT: procedure(id: GLuint; _type: GLenum; stride: GLuint; addr: PGLvoid); extdecl;
  glEnableVariantClientStateEXT: procedure(id: GLuint); extdecl;
  glDisableVariantClientStateEXT: procedure(id: GLuint); extdecl;
  glBindLightParameterEXT: function(light: GLenum; value: GLenum): GLuint; extdecl;
  glBindMaterialParameterEXT: function(face: GLenum; value: GLenum): GLuint; extdecl;
  glBindTexGenParameterEXT: function(_unit: GLenum; coord: GLenum; value: GLenum): GLuint; extdecl;
  glBindTextureUnitParameterEXT: function(_unit: GLenum; value: GLenum): GLuint; extdecl;
  glBindParameterEXT: function(value: GLenum): GLuint; extdecl;
  glIsVariantEnabledEXT: function(id: GLuint; cap: GLenum): GLboolean; extdecl;
  glGetVariantBooleanvEXT: procedure(id: GLuint; value: GLenum; data: PGLboolean); extdecl;
  glGetVariantIntegervEXT: procedure(id: GLuint; value: GLenum; data: PGLint); extdecl;
  glGetVariantFloatvEXT: procedure(id: GLuint; value: GLenum; data: PGLfloat); extdecl;
  glGetVariantPointervEXT: procedure(id: GLuint; value: GLenum; data: PGLvoid); extdecl;
  glGetInvariantBooleanvEXT: procedure(id: GLuint; value: GLenum; data: PGLboolean); extdecl;
  glGetInvariantIntegervEXT: procedure(id: GLuint; value: GLenum; data: PGLint); extdecl;
  glGetInvariantFloatvEXT: procedure(id: GLuint; value: GLenum; data: PGLfloat); extdecl;
  glGetLocalConstantBooleanvEXT: procedure(id: GLuint; value: GLenum; data: PGLboolean); extdecl;
  glGetLocalConstantIntegervEXT: procedure(id: GLuint; value: GLenum; data: PGLint); extdecl;
  glGetLocalConstantFloatvEXT: procedure(id: GLuint; value: GLenum; data: PGLfloat); extdecl;

function Load_GL_EXT_vertex_shader: Boolean;

//***** GL_EXT_vertex_weighting *****//
const
  GL_VERTEX_WEIGHTING_EXT = $8509;
  GL_MODELVIEW0_EXT = $1700;
  GL_MODELVIEW1_EXT = $850A;
  GL_MODELVIEW0_MATRIX_EXT = $0BA6;
  GL_MODELVIEW1_MATRIX_EXT = $8506;
  GL_CURRENT_VERTEX_WEIGHT_EXT = $850B;
  GL_VERTEX_WEIGHT_ARRAY_EXT = $850C;
  GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT = $850D;
  GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT = $850E;
  GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT = $850F;
  GL_MODELVIEW0_STACK_DEPTH_EXT = $0BA3;
  GL_MODELVIEW1_STACK_DEPTH_EXT = $8502;
  GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT = $8510;
var
  glVertexWeightfEXT: procedure(weight: GLfloat); extdecl;
  glVertexWeightfvEXT: procedure(weight: PGLfloat); extdecl;
  glVertexWeightPointerEXT: procedure(size: GLint; _type: GLenum; stride: GLsizei; pointer: PGLvoid); extdecl;

function Load_GL_EXT_vertex_weighting: Boolean;

//***** GL_HP_occlusion_test *****//
const
  GL_OCCLUSION_TEST_HP = $8165;
  GL_OCCLUSION_TEST_RESULT_HP = $8166;

function Load_GL_HP_occlusion_test: Boolean;

//***** GL_NV_blend_square *****//

function Load_GL_NV_blend_square: Boolean;

//***** GL_NV_copy_depth_to_color *****//
const
  GL_DEPTH_STENCIL_TO_RGBA_NV = $886E;
  GL_DEPTH_STENCIL_TO_BGRA_NV = $886F;

function Load_GL_NV_copy_depth_to_color: Boolean;

//***** GL_NV_depth_clamp *****//
const
  GL_DEPTH_CLAMP_NV = $864F;

function Load_GL_NV_depth_clamp: Boolean;

//***** GL_NV_evaluators *****//
const
  GL_EVAL_2D_NV = $86C0;
  GL_EVAL_TRIANGULAR_2D_NV = $86C1;
  GL_MAP_TESSELLATION_NV = $86C2;
  GL_MAP_ATTRIB_U_ORDER_NV = $86C3;
  GL_MAP_ATTRIB_V_ORDER_NV = $86C4;
  GL_EVAL_FRACTIONAL_TESSELLATION_NV = $86C5;
  GL_EVAL_VERTEX_ATTRIB0_NV = $86C6;
  GL_EVAL_VERTEX_ATTRIB1_NV = $86C7;
  GL_EVAL_VERTEX_ATTRIB2_NV = $86C8;
  GL_EVAL_VERTEX_ATTRIB3_NV = $86C9;
  GL_EVAL_VERTEX_ATTRIB4_NV = $86CA;
  GL_EVAL_VERTEX_ATTRIB5_NV = $86CB;
  GL_EVAL_VERTEX_ATTRIB6_NV = $86CC;
  GL_EVAL_VERTEX_ATTRIB7_NV = $86CD;
  GL_EVAL_VERTEX_ATTRIB8_NV = $86CE;
  GL_EVAL_VERTEX_ATTRIB9_NV = $86CF;
  GL_EVAL_VERTEX_ATTRIB10_NV = $86D0;
  GL_EVAL_VERTEX_ATTRIB11_NV = $86D1;
  GL_EVAL_VERTEX_ATTRIB12_NV = $86D2;
  GL_EVAL_VERTEX_ATTRIB13_NV = $86D3;
  GL_EVAL_VERTEX_ATTRIB14_NV = $86D4;
  GL_EVAL_VERTEX_ATTRIB15_NV = $86D5;
  GL_MAX_MAP_TESSELLATION_NV = $86D6;
  GL_MAX_RATIONAL_EVAL_ORDER_NV = $86D7;
var
  glMapControlPointsNV: procedure(target: GLenum; index: GLuint; _type: GLenum; ustride: GLsizei; vstride: GLsizei; uorder: GLint; vorder: GLint; _packed: GLboolean; const points: PGLvoid); extdecl;
  glMapParameterivNV: procedure(target: GLenum; pname: GLenum; const params: PGLint); extdecl;
  glMapParameterfvNV: procedure(target: GLenum; pname: GLenum; const params: PGLfloat); extdecl;
  glGetMapControlPointsNV: procedure(target: GLenum; index: GLuint; _type: GLenum; ustride: GLsizei; vstride: GLsizei; _packed: GLboolean; points: PGLvoid); extdecl;
  glGetMapParameterivNV: procedure(target: GLenum; pname: GLenum; params: PGLint); extdecl;
  glGetMapParameterfvNV: procedure(target: GLenum; pname: GLenum; params: PGLfloat); extdecl;
  glGetMapAttribParameterivNV: procedure(target: GLenum; index: GLuint; pname: GLenum; params: PGLint); extdecl;
  glGetMapAttribParameterfvNV: procedure(target: GLenum; index: GLuint; pname: GLenum; params: PGLfloat); extdecl;
  glEvalMapsNV: procedure(target: GLenum; mode: GLenum); extdecl;

function Load_GL_NV_evaluators: Boolean;

//***** GL_NV_fence *****//
const
  GL_ALL_COMPLETED_NV = $84F2;
  GL_FENCE_STATUS_NV = $84F3;
  GL_FENCE_CONDITION_NV = $84F4;
var
  glGenFencesNV: procedure(n: GLsizei; fences: PGLuint); extdecl;
  glDeleteFencesNV: procedure(n: GLsizei; const fences: PGLuint); extdecl;
  glSetFenceNV: procedure(fence: GLuint; condition: GLenum); extdecl;
  glTestFenceNV: function(fence: GLuint): GLboolean; extdecl;
  glFinishFenceNV: procedure(fence: GLuint); extdecl;
  glIsFenceNV: function(fence: GLuint): GLboolean; extdecl;
  glGetFenceivNV: procedure(fence: GLuint; pname: GLenum; params: PGLint); extdecl;

function Load_GL_NV_fence: Boolean;

//***** GL_NV_fog_distance *****//
const
  GL_FOG_DISTANCE_MODE_NV = $855A;
  GL_EYE_RADIAL_NV = $855B;
  GL_EYE_PLANE_ABSOLUTE_NV = $855C;

function Load_GL_NV_fog_distance: Boolean;

//***** GL_NV_light_max_exponent *****//
const
  GL_MAX_SHININESS_NV = $8504;
  GL_MAX_SPOT_EXPONENT_NV = $8505;

function Load_GL_NV_light_max_exponent: Boolean;

//***** GL_NV_multisample_filter_hint *****//
const
  GL_MULTISAMPLE_FILTER_HINT_NV = $8534;

function Load_GL_NV_multisample_filter_hint: Boolean;

//***** GL_NV_occlusion_query *****//
  // GL_OCCLUSION_TEST_HP  { already defined }
  // GL_OCCLUSION_TEST_RESULT_HP  { already defined }
const
  GL_PIXEL_COUNTER_BITS_NV = $8864;
  GL_CURRENT_OCCLUSION_QUERY_ID_NV = $8865;
  GL_PIXEL_COUNT_NV = $8866;
  GL_PIXEL_COUNT_AVAILABLE_NV = $8867;
var
  glGenOcclusionQueriesNV: procedure(n: GLsizei; ids: PGLuint); extdecl;
  glDeleteOcclusionQueriesNV: procedure(n: GLsizei; const ids: PGLuint); extdecl;
  glIsOcclusionQueryNV: function(id: GLuint): GLboolean; extdecl;
  glBeginOcclusionQueryNV: procedure(id: GLuint); extdecl;
  glEndOcclusionQueryNV: procedure(); extdecl;
  glGetOcclusionQueryivNV: procedure(id: GLuint; pname: GLenum; params: PGLint); extdecl;
  glGetOcclusionQueryuivNV: procedure(id: GLuint; pname: GLenum; params: PGLuint); extdecl;

function Load_GL_NV_occlusion_query: Boolean;

//***** GL_NV_packed_depth_stencil *****//
const
  GL_DEPTH_STENCIL_NV = $84F9;
  GL_UNSIGNED_INT_24_8_NV = $84FA;

function Load_GL_NV_packed_depth_stencil: Boolean;

//***** GL_NV_point_sprite *****//
const
  GL_POINT_SPRITE_NV = $8861;
  GL_COORD_REPLACE_NV = $8862;
  GL_POINT_SPRITE_R_MODE_NV = $8863;
var
  glPointParameteriNV: procedure(pname: GLenum; param: GLint); extdecl;
  glPointParameterivNV: procedure(pname: GLenum; const params: PGLint); extdecl;

function Load_GL_NV_point_sprite: Boolean;

//***** GL_NV_register_combiners *****//
const
  GL_REGISTER_COMBINERS_NV = $8522;
  GL_COMBINER0_NV = $8550;
  GL_COMBINER1_NV = $8551;
  GL_COMBINER2_NV = $8552;
  GL_COMBINER3_NV = $8553;
  GL_COMBINER4_NV = $8554;
  GL_COMBINER5_NV = $8555;
  GL_COMBINER6_NV = $8556;
  GL_COMBINER7_NV = $8557;
  GL_VARIABLE_A_NV = $8523;
  GL_VARIABLE_B_NV = $8524;
  GL_VARIABLE_C_NV = $8525;
  GL_VARIABLE_D_NV = $8526;
  GL_VARIABLE_E_NV = $8527;
  GL_VARIABLE_F_NV = $8528;
  GL_VARIABLE_G_NV = $8529;
  GL_CONSTANT_COLOR0_NV = $852A;
  GL_CONSTANT_COLOR1_NV = $852B;
  GL_PRIMARY_COLOR_NV = $852C;
  GL_SECONDARY_COLOR_NV = $852D;
  GL_SPARE0_NV = $852E;
  GL_SPARE1_NV = $852F;
  GL_UNSIGNED_IDENTITY_NV = $8536;
  GL_UNSIGNED_INVERT_NV = $8537;
  GL_EXPAND_NORMAL_NV = $8538;
  GL_EXPAND_NEGATE_NV = $8539;
  GL_HALF_BIAS_NORMAL_NV = $853A;
  GL_HALF_BIAS_NEGATE_NV = $853B;
  GL_SIGNED_IDENTITY_NV = $853C;
  GL_SIGNED_NEGATE_NV = $853D;
  GL_E_TIMES_F_NV = $8531;
  GL_SPARE0_PLUS_SECONDARY_COLOR_NV = $8532;
  GL_SCALE_BY_TWO_NV = $853E;
  GL_SCALE_BY_FOUR_NV = $853F;
  GL_SCALE_BY_ONE_HALF_NV = $8540;
  GL_BIAS_BY_NEGATIVE_ONE_HALF_NV = $8541;
  GL_DISCARD_NV = $8530;
  GL_COMBINER_INPUT_NV = $8542;
  GL_COMBINER_MAPPING_NV = $8543;
  GL_COMBINER_COMPONENT_USAGE_NV = $8544;
  GL_COMBINER_AB_DOT_PRODUCT_NV = $8545;
  GL_COMBINER_CD_DOT_PRODUCT_NV = $8546;
  GL_COMBINER_MUX_SUM_NV = $8547;
  GL_COMBINER_SCALE_NV = $8548;
  GL_COMBINER_BIAS_NV = $8549;
  GL_COMBINER_AB_OUTPUT_NV = $854A;
  GL_COMBINER_CD_OUTPUT_NV = $854B;
  GL_COMBINER_SUM_OUTPUT_NV = $854C;
  GL_NUM_GENERAL_COMBINERS_NV = $854E;
  GL_COLOR_SUM_CLAMP_NV = $854F;
  GL_MAX_GENERAL_COMBINERS_NV = $854D;
var
  glCombinerParameterfvNV: procedure(pname: GLenum; const params: PGLfloat); extdecl;
  glCombinerParameterivNV: procedure(pname: GLenum; const params: PGLint); extdecl;
  glCombinerParameterfNV: procedure(pname: GLenum; param: GLfloat); extdecl;
  glCombinerParameteriNV: procedure(pname: GLenum; param: GLint); extdecl;
  glCombinerInputNV: procedure(stage: GLenum; portion: GLenum; variable: GLenum; input: GLenum; mapping: GLenum; componentUsage: GLenum); extdecl;
  glCombinerOutputNV: procedure(stage: GLenum; portion: GLenum; abOutput: GLenum; cdOutput: GLenum; sumOutput: GLenum; scale: GLenum; bias: GLenum; abDotProduct: GLboolean; cdDotProduct: GLboolean; muxSum: GLboolean); extdecl;
  glFinalCombinerInputNV: procedure(variable: GLenum; input: GLenum; mapping: GLenum; componentUsage: GLenum); extdecl;
  glGetCombinerInputParameterfvNV: procedure(stage: GLenum; portion: GLenum; variable: GLenum; pname: GLenum; params: PGLfloat); extdecl;
  glGetCombinerInputParameterivNV: procedure(stage: GLenum; portion: GLenum; variable: GLenum; pname: GLenum; params: PGLint); extdecl;
  glGetCombinerOutputParameterfvNV: procedure(stage: GLenum; portion: GLenum; pname: GLenum; params: PGLfloat); extdecl;
  glGetCombinerOutputParameterivNV: procedure(stage: GLenum; portion: GLenum; pname: GLenum; params: PGLint); extdecl;
  glGetFinalCombinerInputParameterfvNV: procedure(variable: GLenum; pname: GLenum; params: PGLfloat); extdecl;
  glGetFinalCombinerInputParameterivNV: procedure(variable: GLenum; pname: GLenum; params: PGLint); extdecl;

function Load_GL_NV_register_combiners: Boolean;

//***** GL_NV_register_combiners2 *****//
const
  GL_PER_STAGE_CONSTANTS_NV = $8535;
var
  glCombinerStageParameterfvNV: procedure(stage: GLenum; pname: GLenum; const params: PGLfloat); extdecl;
  glGetCombinerStageParameterfvNV: procedure(stage: GLenum; pname: GLenum; params: PGLfloat); extdecl;

function Load_GL_NV_register_combiners2: Boolean;

//***** GL_NV_texgen_emboss *****//
const
  GL_EMBOSS_MAP_NV = $855F;
  GL_EMBOSS_LIGHT_NV = $855D;
  GL_EMBOSS_CONSTANT_NV = $855E;

function Load_GL_NV_texgen_emboss: Boolean;

//***** GL_NV_texgen_reflection *****//
const
  GL_NORMAL_MAP_NV = $8511;
  GL_REFLECTION_MAP_NV = $8512;

function Load_GL_NV_texgen_reflection: Boolean;

//***** GL_NV_texture_compression_vtc *****//
  // GL_COMPRESSED_RGB_S3TC_DXT1_EXT  { already defined }
  // GL_COMPRESSED_RGBA_S3TC_DXT1_EXT  { already defined }
  // GL_COMPRESSED_RGBA_S3TC_DXT3_EXT  { already defined }
  // GL_COMPRESSED_RGBA_S3TC_DXT5_EXT  { already defined }

function Load_GL_NV_texture_compression_vtc: Boolean;

//***** GL_NV_texture_env_combine4 *****//
const
  GL_COMBINE4_NV = $8503;
  GL_SOURCE3_RGB_NV = $8583;
  GL_SOURCE3_ALPHA_NV = $858B;
  GL_OPERAND3_RGB_NV = $8593;
  GL_OPERAND3_ALPHA_NV = $859B;

function Load_GL_NV_texture_env_combine4: Boolean;

//***** GL_NV_texture_rectangle *****//
const
  GL_TEXTURE_RECTANGLE_NV = $84F5;
  GL_TEXTURE_BINDING_RECTANGLE_NV = $84F6;
  GL_PROXY_TEXTURE_RECTANGLE_NV = $84F7;
  GL_MAX_RECTANGLE_TEXTURE_SIZE_NV = $84F8;

function Load_GL_NV_texture_rectangle: Boolean;

//***** GL_NV_texture_shader *****//
const
  GL_TEXTURE_SHADER_NV = $86DE;
  GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV = $86D9;
  GL_SHADER_OPERATION_NV = $86DF;
  GL_CULL_MODES_NV = $86E0;
  GL_OFFSET_TEXTURE_MATRIX_NV = $86E1;
  GL_OFFSET_TEXTURE_SCALE_NV = $86E2;
  GL_OFFSET_TEXTURE_BIAS_NV = $86E3;
  GL_PREVIOUS_TEXTURE_INPUT_NV = $86E4;
  GL_CONST_EYE_NV = $86E5;
  GL_SHADER_CONSISTENT_NV = $86DD;
  GL_PASS_THROUGH_NV = $86E6;
  GL_CULL_FRAGMENT_NV = $86E7;
  GL_OFFSET_TEXTURE_2D_NV = $86E8;
  GL_OFFSET_TEXTURE_RECTANGLE_NV = $864C;
  GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV = $864D;
  GL_DEPENDENT_AR_TEXTURE_2D_NV = $86E9;
  GL_DEPENDENT_GB_TEXTURE_2D_NV = $86EA;
  GL_DOT_PRODUCT_NV = $86EC;
  GL_DOT_PRODUCT_DEPTH_REPLACE_NV = $86ED;
  GL_DOT_PRODUCT_TEXTURE_2D_NV = $86EE;
  GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV = $864E;
  GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV = $86F0;
  GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV = $86F1;
  GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV = $86F2;
  GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV = $86F3;
  GL_HILO_NV = $86F4;
  GL_DSDT_NV = $86F5;
  GL_DSDT_MAG_NV = $86F6;
  GL_DSDT_MAG_VIB_NV = $86F7;
  GL_UNSIGNED_INT_S8_S8_8_8_NV = $86DA;
  GL_UNSIGNED_INT_8_8_S8_S8_REV_NV = $86DB;
  GL_SIGNED_RGBA_NV = $86FB;
  GL_SIGNED_RGBA8_NV = $86FC;
  GL_SIGNED_RGB_NV = $86FE;
  GL_SIGNED_RGB8_NV = $86FF;
  GL_SIGNED_LUMINANCE_NV = $8701;
  GL_SIGNED_LUMINANCE8_NV = $8702;
  GL_SIGNED_LUMINANCE_ALPHA_NV = $8703;
  GL_SIGNED_LUMINANCE8_ALPHA8_NV = $8704;
  GL_SIGNED_ALPHA_NV = $8705;
  GL_SIGNED_ALPHA8_NV = $8706;
  GL_SIGNED_INTENSITY_NV = $8707;
  GL_SIGNED_INTENSITY8_NV = $8708;
  GL_SIGNED_RGB_UNSIGNED_ALPHA_NV = $870C;
  GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV = $870D;
  GL_HILO16_NV = $86F8;
  GL_SIGNED_HILO_NV = $86F9;
  GL_SIGNED_HILO16_NV = $86FA;
  GL_DSDT8_NV = $8709;
  GL_DSDT8_MAG8_NV = $870A;
  GL_DSDT_MAG_INTENSITY_NV = $86DC;
  GL_DSDT8_MAG8_INTENSITY8_NV = $870B;
  GL_HI_SCALE_NV = $870E;
  GL_LO_SCALE_NV = $870F;
  GL_DS_SCALE_NV = $8710;
  GL_DT_SCALE_NV = $8711;
  GL_MAGNITUDE_SCALE_NV = $8712;
  GL_VIBRANCE_SCALE_NV = $8713;
  GL_HI_BIAS_NV = $8714;
  GL_LO_BIAS_NV = $8715;
  GL_DS_BIAS_NV = $8716;
  GL_DT_BIAS_NV = $8717;
  GL_MAGNITUDE_BIAS_NV = $8718;
  GL_VIBRANCE_BIAS_NV = $8719;
  GL_TEXTURE_BORDER_VALUES_NV = $871A;
  GL_TEXTURE_HI_SIZE_NV = $871B;
  GL_TEXTURE_LO_SIZE_NV = $871C;
  GL_TEXTURE_DS_SIZE_NV = $871D;
  GL_TEXTURE_DT_SIZE_NV = $871E;
  GL_TEXTURE_MAG_SIZE_NV = $871F;

function Load_GL_NV_texture_shader: Boolean;

//***** GL_NV_texture_shader2 *****//
const
  GL_DOT_PRODUCT_TEXTURE_3D_NV = $86EF;
  // GL_HILO_NV  { already defined }
  // GL_DSDT_NV  { already defined }
  // GL_DSDT_MAG_NV  { already defined }
  // GL_DSDT_MAG_VIB_NV  { already defined }
  // GL_UNSIGNED_INT_S8_S8_8_8_NV  { already defined }
  // GL_UNSIGNED_INT_8_8_S8_S8_REV_NV  { already defined }
  // GL_SIGNED_RGBA_NV  { already defined }
  // GL_SIGNED_RGBA8_NV  { already defined }
  // GL_SIGNED_RGB_NV  { already defined }
  // GL_SIGNED_RGB8_NV  { already defined }
  // GL_SIGNED_LUMINANCE_NV  { already defined }
  // GL_SIGNED_LUMINANCE8_NV  { already defined }
  // GL_SIGNED_LUMINANCE_ALPHA_NV  { already defined }
  // GL_SIGNED_LUMINANCE8_ALPHA8_NV  { already defined }
  // GL_SIGNED_ALPHA_NV  { already defined }
  // GL_SIGNED_ALPHA8_NV  { already defined }
  // GL_SIGNED_INTENSITY_NV  { already defined }
  // GL_SIGNED_INTENSITY8_NV  { already defined }
  // GL_SIGNED_RGB_UNSIGNED_ALPHA_NV  { already defined }
  // GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV  { already defined }
  // GL_HILO16_NV  { already defined }
  // GL_SIGNED_HILO_NV  { already defined }
  // GL_SIGNED_HILO16_NV  { already defined }
  // GL_DSDT8_NV  { already defined }
  // GL_DSDT8_MAG8_NV  { already defined }
  // GL_DSDT_MAG_INTENSITY_NV  { already defined }
  // GL_DSDT8_MAG8_INTENSITY8_NV  { already defined }

function Load_GL_NV_texture_shader2: Boolean;

//***** GL_NV_texture_shader3 *****//
const
  GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV = $8850;
  GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV = $8851;
  GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV = $8852;
  GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV = $8853;
  GL_OFFSET_HILO_TEXTURE_2D_NV = $8854;
  GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV = $8855;
  GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV = $8856;
  GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV = $8857;
  GL_DEPENDENT_HILO_TEXTURE_2D_NV = $8858;
  GL_DEPENDENT_RGB_TEXTURE_3D_NV = $8859;
  GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV = $885A;
  GL_DOT_PRODUCT_PASS_THROUGH_NV = $885B;
  GL_DOT_PRODUCT_TEXTURE_1D_NV = $885C;
  GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV = $885D;
  GL_HILO8_NV = $885E;
  GL_SIGNED_HILO8_NV = $885F;
  GL_FORCE_BLUE_TO_ONE_NV = $8860;

function Load_GL_NV_texture_shader3: Boolean;

//***** GL_NV_vertex_array_range *****//
const
  GL_VERTEX_ARRAY_RANGE_NV = $851D;
  GL_VERTEX_ARRAY_RANGE_LENGTH_NV = $851E;
  GL_VERTEX_ARRAY_RANGE_VALID_NV = $851F;
  GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV = $8520;
  GL_VERTEX_ARRAY_RANGE_POINTER_NV = $8521;
var
  glVertexArrayRangeNV: procedure(length: GLsizei; pointer: PGLvoid); extdecl;
  glFlushVertexArrayRangeNV: procedure(); extdecl;
{$IFDEF Win32}
  wglAllocateMemoryNV: function(size: GLsizei; readFrequency: GLfloat; writeFrequency: GLfloat; priority: GLfloat): PGLvoid; extdecl;
  wglFreeMemoryNV: procedure(pointer: PGLvoid); extdecl;
{$ENDIF}

function Load_GL_NV_vertex_array_range: Boolean;

//***** GL_NV_vertex_array_range2 *****//
const
  GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV = $8533;

function Load_GL_NV_vertex_array_range2: Boolean;

//***** GL_NV_vertex_program *****//
const
  GL_VERTEX_PROGRAM_NV = $8620;
  GL_VERTEX_PROGRAM_POINT_SIZE_NV = $8642;
  GL_VERTEX_PROGRAM_TWO_SIDE_NV = $8643;
  GL_VERTEX_STATE_PROGRAM_NV = $8621;
  GL_ATTRIB_ARRAY_SIZE_NV = $8623;
  GL_ATTRIB_ARRAY_STRIDE_NV = $8624;
  GL_ATTRIB_ARRAY_TYPE_NV = $8625;
  GL_CURRENT_ATTRIB_NV = $8626;
  GL_PROGRAM_PARAMETER_NV = $8644;
  GL_ATTRIB_ARRAY_POINTER_NV = $8645;
  GL_PROGRAM_TARGET_NV = $8646;
  GL_PROGRAM_LENGTH_NV = $8627;
  GL_PROGRAM_RESIDENT_NV = $8647;
  GL_PROGRAM_STRING_NV = $8628;
  GL_TRACK_MATRIX_NV = $8648;
  GL_TRACK_MATRIX_TRANSFORM_NV = $8649;
  GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV = $862E;
  GL_MAX_TRACK_MATRICES_NV = $862F;
  GL_CURRENT_MATRIX_STACK_DEPTH_NV = $8640;
  GL_CURRENT_MATRIX_NV = $8641;
  GL_VERTEX_PROGRAM_BINDING_NV = $864A;
  GL_PROGRAM_ERROR_POSITION_NV = $864B;
  GL_MODELVIEW_PROJECTION_NV = $8629;
  GL_MATRIX0_NV = $8630;
  GL_MATRIX1_NV = $8631;
  GL_MATRIX2_NV = $8632;
  GL_MATRIX3_NV = $8633;
  GL_MATRIX4_NV = $8634;
  GL_MATRIX5_NV = $8635;
  GL_MATRIX6_NV = $8636;
  GL_MATRIX7_NV = $8637;
  GL_IDENTITY_NV = $862A;
  GL_INVERSE_NV = $862B;
  GL_TRANSPOSE_NV = $862C;
  GL_INVERSE_TRANSPOSE_NV = $862D;
  GL_VERTEX_ATTRIB_ARRAY0_NV = $8650;
  GL_VERTEX_ATTRIB_ARRAY1_NV = $8651;
  GL_VERTEX_ATTRIB_ARRAY2_NV = $8652;
  GL_VERTEX_ATTRIB_ARRAY3_NV = $8653;
  GL_VERTEX_ATTRIB_ARRAY4_NV = $8654;
  GL_VERTEX_ATTRIB_ARRAY5_NV = $8655;
  GL_VERTEX_ATTRIB_ARRAY6_NV = $8656;
  GL_VERTEX_ATTRIB_ARRAY7_NV = $8657;
  GL_VERTEX_ATTRIB_ARRAY8_NV = $8658;
  GL_VERTEX_ATTRIB_ARRAY9_NV = $8659;
  GL_VERTEX_ATTRIB_ARRAY10_NV = $865A;
  GL_VERTEX_ATTRIB_ARRAY11_NV = $865B;
  GL_VERTEX_ATTRIB_ARRAY12_NV = $865C;
  GL_VERTEX_ATTRIB_ARRAY13_NV = $865D;
  GL_VERTEX_ATTRIB_ARRAY14_NV = $865E;
  GL_VERTEX_ATTRIB_ARRAY15_NV = $865F;
  GL_MAP1_VERTEX_ATTRIB0_4_NV = $8660;
  GL_MAP1_VERTEX_ATTRIB1_4_NV = $8661;
  GL_MAP1_VERTEX_ATTRIB2_4_NV = $8662;
  GL_MAP1_VERTEX_ATTRIB3_4_NV = $8663;
  GL_MAP1_VERTEX_ATTRIB4_4_NV = $8664;
  GL_MAP1_VERTEX_ATTRIB5_4_NV = $8665;
  GL_MAP1_VERTEX_ATTRIB6_4_NV = $8666;
  GL_MAP1_VERTEX_ATTRIB7_4_NV = $8667;
  GL_MAP1_VERTEX_ATTRIB8_4_NV = $8668;
  GL_MAP1_VERTEX_ATTRIB9_4_NV = $8669;
  GL_MAP1_VERTEX_ATTRIB10_4_NV = $866A;
  GL_MAP1_VERTEX_ATTRIB11_4_NV = $866B;
  GL_MAP1_VERTEX_ATTRIB12_4_NV = $866C;
  GL_MAP1_VERTEX_ATTRIB13_4_NV = $866D;
  GL_MAP1_VERTEX_ATTRIB14_4_NV = $866E;
  GL_MAP1_VERTEX_ATTRIB15_4_NV = $866F;
  GL_MAP2_VERTEX_ATTRIB0_4_NV = $8670;
  GL_MAP2_VERTEX_ATTRIB1_4_NV = $8671;
  GL_MAP2_VERTEX_ATTRIB2_4_NV = $8672;
  GL_MAP2_VERTEX_ATTRIB3_4_NV = $8673;
  GL_MAP2_VERTEX_ATTRIB4_4_NV = $8674;
  GL_MAP2_VERTEX_ATTRIB5_4_NV = $8675;
  GL_MAP2_VERTEX_ATTRIB6_4_NV = $8676;
  GL_MAP2_VERTEX_ATTRIB7_4_NV = $8677;
  GL_MAP2_VERTEX_ATTRIB8_4_NV = $8678;
  GL_MAP2_VERTEX_ATTRIB9_4_NV = $8679;
  GL_MAP2_VERTEX_ATTRIB10_4_NV = $867A;
  GL_MAP2_VERTEX_ATTRIB11_4_NV = $867B;
  GL_MAP2_VERTEX_ATTRIB12_4_NV = $867C;
  GL_MAP2_VERTEX_ATTRIB13_4_NV = $867D;
  GL_MAP2_VERTEX_ATTRIB14_4_NV = $867E;
  GL_MAP2_VERTEX_ATTRIB15_4_NV = $867F;
var
  glBindProgramNV: procedure(target: GLenum; id: GLuint); extdecl;
  glDeleteProgramsNV: procedure(n: GLsizei; const ids: PGLuint); extdecl;
  glExecuteProgramNV: procedure(target: GLenum; id: GLuint; const params: PGLfloat); extdecl;
  glGenProgramsNV: procedure(n: GLsizei; ids: PGLuint); extdecl;
  glAreProgramsResidentNV: function(n: GLsizei; const ids: PGLuint; residences: PGLboolean): GLboolean; extdecl;
  glRequestResidentProgramsNV: procedure(n: GLsizei; ids: PGLuint); extdecl;
  glGetProgramParameterfvNV: procedure(target: GLenum; index: GLuint; pname: GLenum; params: PGLfloat); extdecl;
  glGetProgramParameterdvNV: procedure(target: GLenum; index: GLuint; pname: GLenum; params: PGLdouble); extdecl;
  glGetProgramivNV: procedure(id: GLuint; pname: GLenum; params: PGLint); extdecl;
  glGetProgramStringNV: procedure(id: GLuint; pname: GLenum; _program: PGLubyte); extdecl;
  glGetTrackMatrixivNV: procedure(target: GLenum; address: GLuint; pname: GLenum; params: PGLint); extdecl;
  glGetVertexAttribdvNV: procedure(index: GLuint; pname: GLenum; params: PGLdouble); extdecl;
  glGetVertexAttribfvNV: procedure(index: GLuint; pname: GLenum; params: PGLfloat); extdecl;
  glGetVertexAttribivNV: procedure(index: GLuint; pname: GLenum; params: PGLint); extdecl;
  glGetVertexAttribPointervNV: procedure(index: GLuint; pname: GLenum; pointer: PGLvoid); extdecl;
  glIsProgramNV: function(id: GLuint): GLboolean; extdecl;
  glLoadProgramNV: procedure(target: GLenum; id: GLuint; len: GLsizei; const _program: PGLubyte); extdecl;
  glProgramParameter4fNV: procedure(target: GLenum; index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); extdecl;
  glProgramParameter4fvNV: procedure(target: GLenum; index: GLuint; const params: PGLfloat); extdecl;
  glProgramParameters4dvNV: procedure(target: GLenum; index: GLuint; num: GLuint; const params: PGLdouble); extdecl;
  glProgramParameters4fvNV: procedure(target: GLenum; index: GLuint; num: GLuint; const params: PGLfloat); extdecl;
  glTrackMatrixNV: procedure(target: GLenum; address: GLuint; matrix: GLenum; transform: GLenum); extdecl;
  glVertexAttribPointerNV: procedure(index: GLuint; size: GLint; _type: GLenum; stride: GLsizei; const pointer: PGLvoid); extdecl;
  glVertexAttrib1sNV: procedure(index: GLuint; x: GLshort); extdecl;
  glVertexAttrib1fNV: procedure(index: GLuint; x: GLfloat); extdecl;
  glVertexAttrib1dNV: procedure(index: GLuint; x: GLdouble); extdecl;
  glVertexAttrib2sNV: procedure(index: GLuint; x: GLshort; y: GLshort); extdecl;
  glVertexAttrib2fNV: procedure(index: GLuint; x: GLfloat; y: GLfloat); extdecl;
  glVertexAttrib2dNV: procedure(index: GLuint; x: GLdouble; y: GLdouble); extdecl;
  glVertexAttrib3sNV: procedure(index: GLuint; x: GLshort; y: GLshort; z: GLshort); extdecl;
  glVertexAttrib3fNV: procedure(index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glVertexAttrib3dNV: procedure(index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble); extdecl;
  glVertexAttrib4sNV: procedure(index: GLuint; x: GLshort; y: GLshort; z: GLshort; w: GLshort); extdecl;
  glVertexAttrib4fNV: procedure(index: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); extdecl;
  glVertexAttrib4dNV: procedure(index: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); extdecl;
  glVertexAttrib4ubNV: procedure(index: GLuint; x: GLubyte; y: GLubyte; z: GLubyte; w: GLubyte); extdecl;
  glVertexAttrib1svNV: procedure(index: GLuint; const v: PGLshort); extdecl;
  glVertexAttrib1fvNV: procedure(index: GLuint; const v: PGLfloat); extdecl;
  glVertexAttrib1dvNV: procedure(index: GLuint; const v: PGLdouble); extdecl;
  glVertexAttrib2svNV: procedure(index: GLuint; const v: PGLshort); extdecl;
  glVertexAttrib2fvNV: procedure(index: GLuint; const v: PGLfloat); extdecl;
  glVertexAttrib2dvNV: procedure(index: GLuint; const v: PGLdouble); extdecl;
  glVertexAttrib3svNV: procedure(index: GLuint; const v: PGLshort); extdecl;
  glVertexAttrib3fvNV: procedure(index: GLuint; const v: PGLfloat); extdecl;
  glVertexAttrib3dvNV: procedure(index: GLuint; const v: PGLdouble); extdecl;
  glVertexAttrib4svNV: procedure(index: GLuint; const v: PGLshort); extdecl;
  glVertexAttrib4fvNV: procedure(index: GLuint; const v: PGLfloat); extdecl;
  glVertexAttrib4dvNV: procedure(index: GLuint; const v: PGLdouble); extdecl;
  glVertexAttrib4ubvNV: procedure(index: GLuint; const v: PGLubyte); extdecl;
  glVertexAttribs1svNV: procedure(index: GLuint; n: GLsizei; const v: PGLshort); extdecl;
  glVertexAttribs1fvNV: procedure(index: GLuint; n: GLsizei; const v: PGLfloat); extdecl;
  glVertexAttribs1dvNV: procedure(index: GLuint; n: GLsizei; const v: PGLdouble); extdecl;
  glVertexAttribs2svNV: procedure(index: GLuint; n: GLsizei; const v: PGLshort); extdecl;
  glVertexAttribs2fvNV: procedure(index: GLuint; n: GLsizei; const v: PGLfloat); extdecl;
  glVertexAttribs2dvNV: procedure(index: GLuint; n: GLsizei; const v: PGLdouble); extdecl;
  glVertexAttribs3svNV: procedure(index: GLuint; n: GLsizei; const v: PGLshort); extdecl;
  glVertexAttribs3fvNV: procedure(index: GLuint; n: GLsizei; const v: PGLfloat); extdecl;
  glVertexAttribs3dvNV: procedure(index: GLuint; n: GLsizei; const v: PGLdouble); extdecl;
  glVertexAttribs4svNV: procedure(index: GLuint; n: GLsizei; const v: PGLshort); extdecl;
  glVertexAttribs4fvNV: procedure(index: GLuint; n: GLsizei; const v: PGLfloat); extdecl;
  glVertexAttribs4dvNV: procedure(index: GLuint; n: GLsizei; const v: PGLdouble); extdecl;
  glVertexAttribs4ubvNV: procedure(index: GLuint; n: GLsizei; const v: PGLubyte); extdecl;

function Load_GL_NV_vertex_program: Boolean;

//***** GL_NV_vertex_program1_1 *****//

function Load_GL_NV_vertex_program1_1: Boolean;

//***** GL_ATI_element_array *****//
const
  GL_ELEMENT_ARRAY_ATI = $8768;
  GL_ELEMENT_ARRAY_TYPE_ATI = $8769;
  GL_ELEMENT_ARRAY_POINTER_ATI = $876A;
var
  glElementPointerATI: procedure(_type: GLenum; const pointer: PGLvoid); extdecl;
  glDrawElementArrayATI: procedure(mode: GLenum; count: GLsizei); extdecl;
  glDrawRangeElementArrayATI: procedure(mode: GLenum; start: GLuint; _end: GLuint; count: GLsizei); extdecl;

function Load_GL_ATI_element_array: Boolean;

//***** GL_ATI_envmap_bumpmap *****//
const
  GL_BUMP_ROT_MATRIX_ATI = $8775;
  GL_BUMP_ROT_MATRIX_SIZE_ATI = $8776;
  GL_BUMP_NUM_TEX_UNITS_ATI = $8777;
  GL_BUMP_TEX_UNITS_ATI = $8778;
  GL_DUDV_ATI = $8779;
  GL_DU8DV8_ATI = $877A;
  GL_BUMP_ENVMAP_ATI = $877B;
  GL_BUMP_TARGET_ATI = $877C;
var
  glTexBumpParameterivATI: procedure(pname: GLenum; param: PGLint); extdecl;
  glTexBumpParameterfvATI: procedure(pname: GLenum; param: PGLfloat); extdecl;
  glGetTexBumpParameterivATI: procedure(pname: GLenum; param: PGLint); extdecl;
  glGetTexBumpParameterfvATI: procedure(pname: GLenum; param: PGLfloat); extdecl;

function Load_GL_ATI_envmap_bumpmap: Boolean;

//***** GL_ATI_fragment_shader *****//
const
  GL_FRAGMENT_SHADER_ATI = $8920;
  GL_REG_0_ATI = $8921;
  GL_REG_1_ATI = $8922;
  GL_REG_2_ATI = $8923;
  GL_REG_3_ATI = $8924;
  GL_REG_4_ATI = $8925;
  GL_REG_5_ATI = $8926;
  GL_CON_0_ATI = $8941;
  GL_CON_1_ATI = $8942;
  GL_CON_2_ATI = $8943;
  GL_CON_3_ATI = $8944;
  GL_CON_4_ATI = $8945;
  GL_CON_5_ATI = $8946;
  GL_CON_6_ATI = $8947;
  GL_CON_7_ATI = $8948;
  GL_MOV_ATI = $8961;
  GL_ADD_ATI = $8963;
  GL_MUL_ATI = $8964;
  GL_SUB_ATI = $8965;
  GL_DOT3_ATI = $8966;
  GL_DOT4_ATI = $8967;
  GL_MAD_ATI = $8968;
  GL_LERP_ATI = $8969;
  GL_CND_ATI = $896A;
  GL_CND0_ATI = $896B;
  GL_DOT2_ADD_ATI = $896C;
  GL_SECONDARY_INTERPOLATOR_ATI = $896D;
  GL_SWIZZLE_STR_ATI = $8976;
  GL_SWIZZLE_STQ_ATI = $8977;
  GL_SWIZZLE_STR_DR_ATI = $8978;
  GL_SWIZZLE_STQ_DQ_ATI = $8979;
  GL_RED_BIT_ATI = $0001;
  GL_GREEN_BIT_ATI = $0002;
  GL_BLUE_BIT_ATI = $0004;
  GL_2X_BIT_ATI = $0001;
  GL_4X_BIT_ATI = $0002;
  GL_8X_BIT_ATI = $0004;
  GL_HALF_BIT_ATI = $0008;
  GL_QUARTER_BIT_ATI = $0010;
  GL_EIGHTH_BIT_ATI = $0020;
  GL_SATURATE_BIT_ATI = $0040;
  // GL_2X_BIT_ATI  { already defined }
  GL_COMP_BIT_ATI = $0002;
  GL_NEGATE_BIT_ATI = $0004;
  GL_BIAS_BIT_ATI = $0008;
var
  glGenFragmentShadersATI: function(range: GLuint): GLuint; extdecl;
  glBindFragmentShaderATI: procedure(id: GLuint); extdecl;
  glDeleteFragmentShaderATI: procedure(id: GLuint); extdecl;
  glBeginFragmentShaderATI: procedure(); extdecl;
  glEndFragmentShaderATI: procedure(); extdecl;
  glPassTexCoordATI: procedure(dst: GLuint; coord: GLuint; swizzle: GLenum); extdecl;
  glSampleMapATI: procedure(dst: GLuint; interp: GLuint; swizzle: GLenum); extdecl;
  glColorFragmentOp1ATI: procedure(op: GLenum; dst: GLuint; dstMask: GLuint; dstMod: GLuint; arg1: GLuint; arg1Rep: GLuint; arg1Mod: GLuint); extdecl;
  glColorFragmentOp2ATI: procedure(op: GLenum; dst: GLuint; dstMask: GLuint; dstMod: GLuint; arg1: GLuint; arg1Rep: GLuint; arg1Mod: GLuint; arg2: GLuint; arg2Rep: GLuint; arg2Mod: GLuint); extdecl;
  glColorFragmentOp3ATI: procedure(op: GLenum; dst: GLuint; dstMask: GLuint; dstMod: GLuint; arg1: GLuint; arg1Rep: GLuint; arg1Mod: GLuint; arg2: GLuint; arg2Rep: GLuint; arg2Mod: GLuint; arg3: GLuint; arg3Rep: GLuint; arg3Mod: GLuint); extdecl;
  glAlphaFragmentOp1ATI: procedure(op: GLenum; dst: GLuint; dstMod: GLuint; arg1: GLuint; arg1Rep: GLuint; arg1Mod: GLuint); extdecl;
  glAlphaFragmentOp2ATI: procedure(op: GLenum; dst: GLuint; dstMod: GLuint; arg1: GLuint; arg1Rep: GLuint; arg1Mod: GLuint; arg2: GLuint; arg2Rep: GLuint; arg2Mod: GLuint); extdecl;
  glAlphaFragmentOp3ATI: procedure(op: GLenum; dst: GLuint; dstMod: GLuint; arg1: GLuint; arg1Rep: GLuint; arg1Mod: GLuint; arg2: GLuint; arg2Rep: GLuint; arg2Mod: GLuint; arg3: GLuint; arg3Rep: GLuint; arg3Mod: GLuint); extdecl;
  glSetFragmentShaderConstantATI: procedure(dst: GLuint; const value: PGLfloat); extdecl;

function Load_GL_ATI_fragment_shader: Boolean;

//***** GL_ATI_pn_triangles *****//
const
  GL_PN_TRIANGLES_ATI = $87F0;
  GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI = $87F1;
  GL_PN_TRIANGLES_POINT_MODE_ATI = $87F2;
  GL_PN_TRIANGLES_NORMAL_MODE_ATI = $87F3;
  GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI = $87F4;
  GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI = $87F5;
  GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI = $87F6;
  GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI = $87F7;
  GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI = $87F8;
var
  glPNTrianglesiATI: procedure(pname: GLenum; param: GLint); extdecl;
  glPNTrianglesfATI: procedure(pname: GLenum; param: GLfloat); extdecl;

function Load_GL_ATI_pn_triangles: Boolean;

//***** GL_ATI_texture_mirror_once *****//
const
  GL_MIRROR_CLAMP_ATI = $8742;
  GL_MIRROR_CLAMP_TO_EDGE_ATI = $8743;

function Load_GL_ATI_texture_mirror_once: Boolean;

//***** GL_ATI_vertex_array_object *****//
const
  GL_STATIC_ATI = $8760;
  GL_DYNAMIC_ATI = $8761;
  GL_PRESERVE_ATI = $8762;
  GL_DISCARD_ATI = $8763;
  GL_OBJECT_BUFFER_SIZE_ATI = $8764;
  GL_OBJECT_BUFFER_USAGE_ATI = $8765;
  GL_ARRAY_OBJECT_BUFFER_ATI = $8766;
  GL_ARRAY_OBJECT_OFFSET_ATI = $8767;
var
  glNewObjectBufferATI: function(size: GLsizei; const pointer: PGLvoid; usage: GLenum): GLuint; extdecl;
  glIsObjectBufferATI: function(buffer: GLuint): GLboolean; extdecl;
  glUpdateObjectBufferATI: procedure(buffer: GLuint; offset: GLuint; size: GLsizei; const pointer: PGLvoid; preserve: GLenum); extdecl;
  glGetObjectBufferfvATI: procedure(buffer: GLuint; pname: GLenum; params: PGLfloat); extdecl;
  glGetObjectBufferivATI: procedure(buffer: GLuint; pname: GLenum; params: PGLint); extdecl;
  glDeleteObjectBufferATI: procedure(buffer: GLuint); extdecl;
  glArrayObjectATI: procedure(_array: GLenum; size: GLint; _type: GLenum; stride: GLsizei; buffer: GLuint; offset: GLuint); extdecl;
  glGetArrayObjectfvATI: procedure(_array: GLenum; pname: GLenum; params: PGLfloat); extdecl;
  glGetArrayObjectivATI: procedure(_array: GLenum; pname: GLenum; params: PGLint); extdecl;
  glVariantArrayObjectATI: procedure(id: GLuint; _type: GLenum; stride: GLsizei; buffer: GLuint; offset: GLuint); extdecl;
  glGetVariantArrayObjectfvATI: procedure(id: GLuint; pname: GLenum; params: PGLfloat); extdecl;
  glGetVariantArrayObjectivATI: procedure(id: GLuint; pname: GLenum; params: PGLint); extdecl;

function Load_GL_ATI_vertex_array_object: Boolean;

//***** GL_ATI_vertex_streams *****//
const
  GL_MAX_VERTEX_STREAMS_ATI = $876B;
  GL_VERTEX_STREAM0_ATI = $876C;
  GL_VERTEX_STREAM1_ATI = $876D;
  GL_VERTEX_STREAM2_ATI = $876E;
  GL_VERTEX_STREAM3_ATI = $876F;
  GL_VERTEX_STREAM4_ATI = $8770;
  GL_VERTEX_STREAM5_ATI = $8771;
  GL_VERTEX_STREAM6_ATI = $8772;
  GL_VERTEX_STREAM7_ATI = $8773;
  GL_VERTEX_SOURCE_ATI = $8774;
var
  glVertexStream1s: procedure(stream: GLenum; coords: GLshort); extdecl;
  glVertexStream1i: procedure(stream: GLenum; coords: GLint); extdecl;
  glVertexStream1f: procedure(stream: GLenum; coords: GLfloat); extdecl;
  glVertexStream1d: procedure(stream: GLenum; coords: GLdouble); extdecl;
  glVertexStream1sv: procedure(stream: GLenum; coords: GLshort); extdecl;
  glVertexStream1iv: procedure(stream: GLenum; coords: GLint); extdecl;
  glVertexStream1fv: procedure(stream: GLenum; coords: GLfloat); extdecl;
  glVertexStream1dv: procedure(stream: GLenum; coords: GLdouble); extdecl;
  glVertexStream2s: procedure(stream: GLenum; coords: GLshort); extdecl;
  glVertexStream2i: procedure(stream: GLenum; coords: GLint); extdecl;
  glVertexStream2f: procedure(stream: GLenum; coords: GLfloat); extdecl;
  glVertexStream2d: procedure(stream: GLenum; coords: GLdouble); extdecl;
  glVertexStream2sv: procedure(stream: GLenum; coords: GLshort); extdecl;
  glVertexStream2iv: procedure(stream: GLenum; coords: GLint); extdecl;
  glVertexStream2fv: procedure(stream: GLenum; coords: GLfloat); extdecl;
  glVertexStream2dv: procedure(stream: GLenum; coords: GLdouble); extdecl;
  glVertexStream3s: procedure(stream: GLenum; coords: GLshort); extdecl;
  glVertexStream3i: procedure(stream: GLenum; coords: GLint); extdecl;
  glVertexStream3f: procedure(stream: GLenum; coords: GLfloat); extdecl;
  glVertexStream3d: procedure(stream: GLenum; coords: GLdouble); extdecl;
  glVertexStream3sv: procedure(stream: GLenum; coords: GLshort); extdecl;
  glVertexStream3iv: procedure(stream: GLenum; coords: GLint); extdecl;
  glVertexStream3fv: procedure(stream: GLenum; coords: GLfloat); extdecl;
  glVertexStream3dv: procedure(stream: GLenum; coords: GLdouble); extdecl;
  glVertexStream4s: procedure(stream: GLenum; coords: GLshort); extdecl;
  glVertexStream4i: procedure(stream: GLenum; coords: GLint); extdecl;
  glVertexStream4f: procedure(stream: GLenum; coords: GLfloat); extdecl;
  glVertexStream4d: procedure(stream: GLenum; coords: GLdouble); extdecl;
  glVertexStream4sv: procedure(stream: GLenum; coords: GLshort); extdecl;
  glVertexStream4iv: procedure(stream: GLenum; coords: GLint); extdecl;
  glVertexStream4fv: procedure(stream: GLenum; coords: GLfloat); extdecl;
  glVertexStream4dv: procedure(stream: GLenum; coords: GLdouble); extdecl;
  glNormalStream3b: procedure(stream: GLenum; coords: GLbyte); extdecl;
  glNormalStream3s: procedure(stream: GLenum; coords: GLshort); extdecl;
  glNormalStream3i: procedure(stream: GLenum; coords: GLint); extdecl;
  glNormalStream3f: procedure(stream: GLenum; coords: GLfloat); extdecl;
  glNormalStream3d: procedure(stream: GLenum; coords: GLdouble); extdecl;
  glNormalStream3bv: procedure(stream: GLenum; coords: GLbyte); extdecl;
  glNormalStream3sv: procedure(stream: GLenum; coords: GLshort); extdecl;
  glNormalStream3iv: procedure(stream: GLenum; coords: GLint); extdecl;
  glNormalStream3fv: procedure(stream: GLenum; coords: GLfloat); extdecl;
  glNormalStream3dv: procedure(stream: GLenum; coords: GLdouble); extdecl;
  glClientActiveVertexStream: procedure(stream: GLenum); extdecl;
  glVertexBlendEnvi: procedure(pname: GLenum; param: GLint); extdecl;
  glVertexBlendEnvf: procedure(pname: GLenum; param: GLfloat); extdecl;

function Load_GL_ATI_vertex_streams: Boolean;

{$IFDEF Win32}
//***** WGL_I3D_image_buffer *****//
const
  WGL_IMAGE_BUFFER_MIN_ACCESS_I3D = $0001;
  WGL_IMAGE_BUFFER_LOCK_I3D = $0002;
var
  wglCreateImageBufferI3D: function(hDC: HDC; dwSize: DWORD; uFlags: UINT): PGLvoid; extdecl;
  wglDestroyImageBufferI3D: function(hDC: HDC; pAddress: PGLvoid): BOOL; extdecl;
  wglAssociateImageBufferEventsI3D: function(hdc: HDC; pEvent: PHandle; pAddress: PGLvoid; pSize: PDWORD; count: UINT): BOOL; extdecl;
  wglReleaseImageBufferEventsI3D: function(hdc: HDC; pAddress: PGLvoid; count: UINT): BOOL; extdecl;

function Load_WGL_I3D_image_buffer: Boolean;

//***** WGL_I3D_swap_frame_lock *****//
var
  wglEnableFrameLockI3D: function(): BOOL; extdecl;
  wglDisableFrameLockI3D: function(): BOOL; extdecl;
  wglIsEnabledFrameLockI3D: function(pFlag: PBOOL): BOOL; extdecl;
  wglQueryFrameLockMasterI3D: function(pFlag: PBOOL): BOOL; extdecl;

function Load_WGL_I3D_swap_frame_lock: Boolean;

//***** WGL_I3D_swap_frame_usage *****//
var
  wglGetFrameUsageI3D: function(pUsage: PGLfloat): BOOL; extdecl;
  wglBeginFrameTrackingI3D: function(): BOOL; extdecl;
  wglEndFrameTrackingI3D: function(): BOOL; extdecl;
  wglQueryFrameTrackingI3D: function(pFrameCount: PDWORD; pMissedFrames: PDWORD; pLastMissedUsage: PGLfloat): BOOL; extdecl;

function Load_WGL_I3D_swap_frame_usage: Boolean;
{$ENDIF}

//***** GL_3DFX_texture_compression_FXT1 *****//
const
  GL_COMPRESSED_RGB_FXT1_3DFX = $86B0;
  GL_COMPRESSED_RGBA_FXT1_3DFX = $86B1;

function Load_GL_3DFX_texture_compression_FXT1: Boolean;

//***** GL_IBM_cull_vertex *****//
const
  GL_CULL_VERTEX_IBM = $1928A;

function Load_GL_IBM_cull_vertex: Boolean;

//***** GL_IBM_multimode_draw_arrays *****//
var
  glMultiModeDrawArraysIBM: procedure(mode: PGLenum; first: PGLint; count: PGLsizei; primcount: GLsizei; modestride: GLint); extdecl;
  glMultiModeDrawElementsIBM: procedure(mode: PGLenum; count: PGLsizei; _type: GLenum; const indices: PGLvoid; primcount: GLsizei; modestride: GLint); extdecl;

function Load_GL_IBM_multimode_draw_arrays: Boolean;

//***** GL_IBM_raster_pos_clip *****//
const
  GL_RASTER_POSITION_UNCLIPPED_IBM = $19262;

function Load_GL_IBM_raster_pos_clip: Boolean;

//***** GL_IBM_texture_mirrored_repeat *****//
const
  GL_MIRRORED_REPEAT_IBM = $8370;

function Load_GL_IBM_texture_mirrored_repeat: Boolean;

//***** GL_IBM_vertex_array_lists *****//
const
  GL_VERTEX_ARRAY_LIST_IBM = $1929E;
  GL_NORMAL_ARRAY_LIST_IBM = $1929F;
  GL_COLOR_ARRAY_LIST_IBM = $192A0;
  GL_INDEX_ARRAY_LIST_IBM = $192A1;
  GL_TEXTURE_COORD_ARRAY_LIST_IBM = $192A2;
  GL_EDGE_FLAG_ARRAY_LIST_IBM = $192A3;
  GL_FOG_COORDINATE_ARRAY_LIST_IBM = $192A4;
  GL_SECONDARY_COLOR_ARRAY_LIST_IBM = $192A5;
  GL_VERTEX_ARRAY_LIST_STRIDE_IBM = $192A8;
  GL_NORMAL_ARRAY_LIST_STRIDE_IBM = $192A9;
  GL_COLOR_ARRAY_LIST_STRIDE_IBM = $192AA;
  GL_INDEX_ARRAY_LIST_STRIDE_IBM = $192AB;
  GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM = $192AC;
  GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM = $192AD;
  GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM = $192AE;
  GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM = $192AF;
var
  glColorPointerListIBM: procedure(size: GLint; _type: GLenum; stride: GLint; const pointer: PGLvoid; ptrstride: GLint); extdecl;
  glSecondaryColorPointerListIBM: procedure(size: GLint; _type: GLenum; stride: GLint; const pointer: PGLvoid; ptrstride: GLint); extdecl;
  glEdgeFlagPointerListIBM: procedure(stride: GLint; const pointer: PGLboolean; ptrstride: GLint); extdecl;
  glFogCoordPointerListIBM: procedure(_type: GLenum; stride: GLint; const pointer: PGLvoid; ptrstride: GLint); extdecl;
  glNormalPointerListIBM: procedure(_type: GLenum; stride: GLint; const pointer: PGLvoid; ptrstride: GLint); extdecl;
  glTexCoordPointerListIBM: procedure(size: GLint; _type: GLenum; stride: GLint; const pointer: PGLvoid; ptrstride: GLint); extdecl;
  glVertexPointerListIBM: procedure(size: GLint; _type: GLenum; stride: GLint; const pointer: PGLvoid; ptrstride: GLint); extdecl;

function Load_GL_IBM_vertex_array_lists: Boolean;

//***** GL_MESA_resize_buffers *****//
var
  glResizeBuffersMESA: procedure(); extdecl;

function Load_GL_MESA_resize_buffers: Boolean;

//***** GL_MESA_window_pos *****//
var
  glWindowPos2dMESA: procedure(x: GLdouble; y: GLdouble); extdecl;
  glWindowPos2fMESA: procedure(x: GLfloat; y: GLfloat); extdecl;
  glWindowPos2iMESA: procedure(x: GLint; y: GLint); extdecl;
  glWindowPos2sMESA: procedure(x: GLshort; y: GLshort); extdecl;
  glWindowPos2ivMESA: procedure(const p: PGLint); extdecl;
  glWindowPos2svMESA: procedure(const p: PGLshort); extdecl;
  glWindowPos2fvMESA: procedure(const p: PGLfloat); extdecl;
  glWindowPos2dvMESA: procedure(const p: PGLdouble); extdecl;
  glWindowPos3iMESA: procedure(x: GLint; y: GLint; z: GLint); extdecl;
  glWindowPos3sMESA: procedure(x: GLshort; y: GLshort; z: GLshort); extdecl;
  glWindowPos3fMESA: procedure(x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glWindowPos3dMESA: procedure(x: GLdouble; y: GLdouble; z: GLdouble); extdecl;
  glWindowPos3ivMESA: procedure(const p: PGLint); extdecl;
  glWindowPos3svMESA: procedure(const p: PGLshort); extdecl;
  glWindowPos3fvMESA: procedure(const p: PGLfloat); extdecl;
  glWindowPos3dvMESA: procedure(const p: PGLdouble); extdecl;
  glWindowPos4iMESA: procedure(x: GLint; y: GLint; z: GLint; w: GLint); extdecl;
  glWindowPos4sMESA: procedure(x: GLshort; y: GLshort; z: GLshort; w: GLshort); extdecl;
  glWindowPos4fMESA: procedure(x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); extdecl;
  glWindowPos4dMESA: procedure(x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); extdecl;
  glWindowPos4ivMESA: procedure(const p: PGLint); extdecl;
  glWindowPos4svMESA: procedure(const p: PGLshort); extdecl;
  glWindowPos4fvMESA: procedure(const p: PGLfloat); extdecl;
  glWindowPos4dvMESA: procedure(const p: PGLdouble); extdecl;

function Load_GL_MESA_window_pos: Boolean;

//***** GL_OML_interlace *****//
const
  GL_INTERLACE_OML = $8980;
  GL_INTERLACE_READ_OML = $8981;

function Load_GL_OML_interlace: Boolean;

//***** GL_OML_resample *****//
const
  GL_PACK_RESAMPLE_OML = $8984;
  GL_UNPACK_RESAMPLE_OML = $8985;
  GL_RESAMPLE_REPLICATE_OML = $8986;
  GL_RESAMPLE_ZERO_FILL_OML = $8987;
  GL_RESAMPLE_AVERAGE_OML = $8988;
  GL_RESAMPLE_DECIMATE_OML = $8989;
  // GL_RESAMPLE_AVERAGE_OML  { already defined }

function Load_GL_OML_resample: Boolean;

//***** GL_OML_subsample *****//
const
  GL_FORMAT_SUBSAMPLE_24_24_OML = $8982;
  GL_FORMAT_SUBSAMPLE_244_244_OML = $8983;

function Load_GL_OML_subsample: Boolean;

//***** GL_SGIS_generate_mipmap *****//
const
  GL_GENERATE_MIPMAP_SGIS = $8191;
  GL_GENERATE_MIPMAP_HINT_SGIS = $8192;

function Load_GL_SGIS_generate_mipmap: Boolean;

//***** GL_SGIS_multisample *****//
const
  GLX_SAMPLE_BUFFERS_SGIS = $186A0;
  GLX_SAMPLES_SGIS = $186A1;
  GL_MULTISAMPLE_SGIS = $809D;
  GL_SAMPLE_ALPHA_TO_MASK_SGIS = $809E;
  GL_SAMPLE_ALPHA_TO_ONE_SGIS = $809F;
  GL_SAMPLE_MASK_SGIS = $80A0;
  GL_MULTISAMPLE_BIT_EXT = $20000000;
  GL_1PASS_SGIS = $80A1;
  GL_2PASS_0_SGIS = $80A2;
  GL_2PASS_1_SGIS = $80A3;
  GL_4PASS_0_SGIS = $80A4;
  GL_4PASS_1_SGIS = $80A5;
  GL_4PASS_2_SGIS = $80A6;
  GL_4PASS_3_SGIS = $80A7;
  GL_SAMPLE_BUFFERS_SGIS = $80A8;
  GL_SAMPLES_SGIS = $80A9;
  GL_SAMPLE_MASK_VALUE_SGIS = $80AA;
  GL_SAMPLE_MASK_INVERT_SGIS = $80AB;
  GL_SAMPLE_PATTERN_SGIS = $80AC;
var
  glSampleMaskSGIS: procedure(value: GLclampf; invert: GLboolean); extdecl;
  glSamplePatternSGIS: procedure(pattern: GLenum); extdecl;

function Load_GL_SGIS_multisample: Boolean;

//***** GL_SGIS_pixel_texture *****//
const
  GL_PIXEL_TEXTURE_SGIS = $8353;
  GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS = $8354;
  GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS = $8355;
  GL_PIXEL_GROUP_COLOR_SGIS = $8356;
var
  glPixelTexGenParameteriSGIS: procedure(pname: GLenum; param: GLint); extdecl;
  glPixelTexGenParameterfSGIS: procedure(pname: GLenum; param: GLfloat); extdecl;
  glGetPixelTexGenParameterivSGIS: procedure(pname: GLenum; params: GLint); extdecl;
  glGetPixelTexGenParameterfvSGIS: procedure(pname: GLenum; params: GLfloat); extdecl;

function Load_GL_SGIS_pixel_texture: Boolean;

//***** GL_SGIS_texture_border_clamp *****//
  // GL_CLAMP_TO_BORDER_SGIS  { already defined }

function Load_GL_SGIS_texture_border_clamp: Boolean;

//***** GL_SGIS_texture_color_mask *****//
const
  GL_TEXTURE_COLOR_WRITEMASK_SGIS = $81EF;
var
  glTextureColorMaskSGIS: procedure(r: GLboolean; g: GLboolean; b: GLboolean; a: GLboolean); extdecl;

function Load_GL_SGIS_texture_color_mask: Boolean;

//***** GL_SGIS_texture_edge_clamp *****//
const
  GL_CLAMP_TO_EDGE_SGIS = $812F;

function Load_GL_SGIS_texture_edge_clamp: Boolean;

//***** GL_SGIS_texture_lod *****//
const
  GL_TEXTURE_MIN_LOD_SGIS = $813A;
  GL_TEXTURE_MAX_LOD_SGIS = $813B;
  GL_TEXTURE_BASE_LEVEL_SGIS = $813C;
  GL_TEXTURE_MAX_LEVEL_SGIS = $813D;

function Load_GL_SGIS_texture_lod: Boolean;

//***** GL_SGIS_depth_texture *****//
const
  GL_DEPTH_COMPONENT16_SGIX = $81A5;
  GL_DEPTH_COMPONENT24_SGIX = $81A6;
  GL_DEPTH_COMPONENT32_SGIX = $81A7;

function Load_GL_SGIS_depth_texture: Boolean;

//***** GL_SGIX_fog_offset *****//
const
  GL_FOG_OFFSET_SGIX = $8198;
  GL_FOG_OFFSET_VALUE_SGIX = $8199;

function Load_GL_SGIX_fog_offset: Boolean;

//***** GL_SGIX_interlace *****//
const
  GL_INTERLACE_SGIX = $8094;

function Load_GL_SGIX_interlace: Boolean;

//***** GL_SGIX_shadow_ambient *****//
const
  GL_SHADOW_AMBIENT_SGIX = $80BF;

function Load_GL_SGIX_shadow_ambient: Boolean;

//***** GL_SGI_color_matrix *****//
const
  GL_COLOR_MATRIX_SGI = $80B1;
  GL_COLOR_MATRIX_STACK_DEPTH_SGI = $80B2;
  GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI = $80B3;
  GL_POST_COLOR_MATRIX_RED_SCALE_SGI = $80B4;
  GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI = $80B5;
  GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI = $80B6;
  GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI = $80B7;
  GL_POST_COLOR_MATRIX_RED_BIAS_SGI = $80B8;
  GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI = $80B9;
  GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI = $80BA;
  GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI = $80BB;

function Load_GL_SGI_color_matrix: Boolean;

//***** GL_SGI_color_table *****//
const
  GL_COLOR_TABLE_SGI = $80D0;
  GL_POST_CONVOLUTION_COLOR_TABLE_SGI = $80D1;
  GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI = $80D2;
  GL_PROXY_COLOR_TABLE_SGI = $80D3;
  GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI = $80D4;
  GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI = $80D5;
  GL_COLOR_TABLE_SCALE_SGI = $80D6;
  GL_COLOR_TABLE_BIAS_SGI = $80D7;
  GL_COLOR_TABLE_FORMAT_SGI = $80D8;
  GL_COLOR_TABLE_WIDTH_SGI = $80D9;
  GL_COLOR_TABLE_RED_SIZE_SGI = $80DA;
  GL_COLOR_TABLE_GREEN_SIZE_SGI = $80DB;
  GL_COLOR_TABLE_BLUE_SIZE_SGI = $80DC;
  GL_COLOR_TABLE_ALPHA_SIZE_SGI = $80DD;
  GL_COLOR_TABLE_LUMINANCE_SIZE_SGI = $80DE;
  GL_COLOR_TABLE_INTENSITY_SIZE_SGI = $80DF;
var
  glColorTableSGI: procedure(target: GLenum; internalformat: GLenum; width: GLsizei; format: GLenum; _type: GLenum; const table: PGLvoid); extdecl;
  glCopyColorTableSGI: procedure(target: GLenum; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei); extdecl;
  glColorTableParameterivSGI: procedure(target: GLenum; pname: GLenum; const params: PGLint); extdecl;
  glColorTableParameterfvSGI: procedure(target: GLenum; pname: GLenum; const params: PGLfloat); extdecl;
  glGetColorTableSGI: procedure(target: GLenum; format: GLenum; _type: GLenum; table: PGLvoid); extdecl;
  glGetColorTableParameterivSGI: procedure(target: GLenum; pname: GLenum; params: PGLint); extdecl;
  glGetColorTableParameterfvSGI: procedure(target: GLenum; pname: GLenum; params: PGLfloat); extdecl;

function Load_GL_SGI_color_table: Boolean;

//***** GL_SGI_texture_color_table *****//
const
  GL_TEXTURE_COLOR_TABLE_SGI = $80BC;
  GL_PROXY_TEXTURE_COLOR_TABLE_SGI = $80BD;

function Load_GL_SGI_texture_color_table: Boolean;

//***** GL_SUN_vertex *****//
var
  glColor4ubVertex2fSUN: procedure(r: GLubyte; g: GLubyte; b: GLubyte; a: GLubyte; x: GLfloat; y: GLfloat); extdecl;
  glColor4ubVertex2fvSUN: procedure(const c: PGLubyte; const v: PGLfloat); extdecl;
  glColor4ubVertex3fSUN: procedure(r: GLubyte; g: GLubyte; b: GLubyte; a: GLubyte; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glColor4ubVertex3fvSUN: procedure(const c: PGLubyte; const v: PGLfloat); extdecl;
  glColor3fVertex3fSUN: procedure(r: GLfloat; g: GLfloat; b: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glColor3fVertex3fvSUN: procedure(const c: PGLfloat; const v: PGLfloat); extdecl;
  glNormal3fVertex3fSUN: procedure(nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glNormal3fVertex3fvSUN: procedure(const n: PGLfloat; const v: PGLfloat); extdecl;
  glColor4fNormal3fVertex3fSUN: procedure(r: GLfloat; g: GLfloat; b: GLfloat; a: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glColor4fNormal3fVertex3fvSUN: procedure(const c: PGLfloat; const n: PGLfloat; const v: PGLfloat); extdecl;
  glTexCoord2fVertex3fSUN: procedure(s: GLfloat; t: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glTexCoord2fVertex3fvSUN: procedure(const tc: PGLfloat; const v: PGLfloat); extdecl;
  glTexCoord4fVertex4fSUN: procedure(s: GLfloat; t: GLfloat; p: GLfloat; q: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); extdecl;
  glTexCoord4fVertex4fvSUN: procedure(const tc: PGLfloat; const v: PGLfloat); extdecl;
  glTexCoord2fColor4ubVertex3fSUN: procedure(s: GLfloat; t: GLfloat; r: GLubyte; g: GLubyte; b: GLubyte; a: GLubyte; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glTexCoord2fColor4ubVertex3fvSUN: procedure(const tc: PGLfloat; const c: PGLubyte; const v: PGLfloat); extdecl;
  glTexCoord2fColor3fVertex3fSUN: procedure(s: GLfloat; t: GLfloat; r: GLfloat; g: GLfloat; b: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glTexCoord2fColor3fVertex3fvSUN: procedure(const tc: PGLfloat; const c: PGLfloat; const v: PGLfloat); extdecl;
  glTexCoord2fNormal3fVertex3fSUN: procedure(s: GLfloat; t: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glTexCoord2fNormal3fVertex3fvSUN: procedure(const tc: PGLfloat; const n: PGLfloat; const v: PGLfloat); extdecl;
  glTexCoord2fColor4fNormal3fVertex3fSUN: procedure(s: GLfloat; t: GLfloat; r: GLfloat; g: GLfloat; b: GLfloat; a: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glTexCoord2fColor4fNormal3fVertex3fvSUN: procedure(const tc: PGLfloat; const c: PGLfloat; const n: PGLfloat; const v: PGLfloat); extdecl;
  glTexCoord4fColor4fNormal3fVertex4fSUN: procedure(s: GLfloat; t: GLfloat; p: GLfloat; q: GLfloat; r: GLfloat; g: GLfloat; b: GLfloat; a: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); extdecl;
  glTexCoord4fColor4fNormal3fVertex4fvSUN: procedure(const tc: PGLfloat; const c: PGLfloat; const n: PGLfloat; const v: PGLfloat); extdecl;
  glReplacementCodeuiVertex3fSUN: procedure(rc: GLuint; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glReplacementCodeuiVertex3fvSUN: procedure(const rc: PGLuint; const v: PGLfloat); extdecl;
  glReplacementCodeuiColor4ubVertex3fSUN: procedure(rc: GLuint; r: GLubyte; g: GLubyte; b: GLubyte; a: GLubyte; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glReplacementCodeuiColor4ubVertex3fvSUN: procedure(const rc: PGLuint; const c: PGLubyte; const v: PGLfloat); extdecl;
  glReplacementCodeuiColor3fVertex3fSUN: procedure(rc: GLuint; r: GLfloat; g: GLfloat; b: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glReplacementCodeuiColor3fVertex3fvSUN: procedure(const rc: PGLuint; const c: PGLfloat; const v: PGLfloat); extdecl;
  glReplacementCodeuiNormal3fVertex3fSUN: procedure(rc: GLuint; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glReplacementCodeuiNormal3fVertex3fvSUN: procedure(const rc: PGLuint; const n: PGLfloat; const v: PGLfloat); extdecl;
  glReplacementCodeuiColor4fNormal3fVertex3fSUN: procedure(rc: GLuint; r: GLfloat; g: GLfloat; b: GLfloat; a: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glReplacementCodeuiColor4fNormal3fVertex3fvSUN: procedure(const rc: PGLuint; const c: PGLfloat; const n: PGLfloat; const v: PGLfloat); extdecl;
  glReplacementCodeuiTexCoord2fVertex3fSUN: procedure(rc: GLuint; s: GLfloat; t: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glReplacementCodeuiTexCoord2fVertex3fvSUN: procedure(const rc: PGLuint; const tc: PGLfloat; const v: PGLfloat); extdecl;
  glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN: procedure(rc: GLuint; s: GLfloat; t: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN: procedure(const rc: PGLuint; const tc: PGLfloat; const n: PGLfloat; const v: PGLfloat); extdecl;
  glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN: procedure(rc: GLuint; s: GLfloat; t: GLfloat; r: GLfloat; g: GLfloat; b: GLfloat; a: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat); extdecl;
  glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN: procedure(const rc: PGLuint; const tc: PGLfloat; const c: PGLfloat; const n: PGLfloat; const v: PGLfloat); extdecl;

function Load_GL_SUN_vertex: Boolean;

//***** GL_ARB_fragment_program *****//
const
  GL_FRAGMENT_PROGRAM_ARB = $8804;
  // GL_PROGRAM_FORMAT_ASCII_ARB  { already defined }
  // GL_PROGRAM_LENGTH_ARB  { already defined }
  // GL_PROGRAM_FORMAT_ARB  { already defined }
  // GL_PROGRAM_BINDING_ARB  { already defined }
  // GL_PROGRAM_INSTRUCTIONS_ARB  { already defined }
  // GL_MAX_PROGRAM_INSTRUCTIONS_ARB  { already defined }
  // GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB  { already defined }
  // GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB  { already defined }
  // GL_PROGRAM_TEMPORARIES_ARB  { already defined }
  // GL_MAX_PROGRAM_TEMPORARIES_ARB  { already defined }
  // GL_PROGRAM_NATIVE_TEMPORARIES_ARB  { already defined }
  // GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB  { already defined }
  // GL_PROGRAM_PARAMETERS_ARB  { already defined }
  // GL_MAX_PROGRAM_PARAMETERS_ARB  { already defined }
  // GL_PROGRAM_NATIVE_PARAMETERS_ARB  { already defined }
  // GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB  { already defined }
  // GL_PROGRAM_ATTRIBS_ARB  { already defined }
  // GL_MAX_PROGRAM_ATTRIBS_ARB  { already defined }
  // GL_PROGRAM_NATIVE_ATTRIBS_ARB  { already defined }
  // GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB  { already defined }
  // GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB  { already defined }
  // GL_MAX_PROGRAM_ENV_PARAMETERS_ARB  { already defined }
  // GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB  { already defined }
  GL_PROGRAM_ALU_INSTRUCTIONS_ARB = $8805;
  GL_PROGRAM_TEX_INSTRUCTIONS_ARB = $8806;
  GL_PROGRAM_TEX_INDIRECTIONS_ARB = $8807;
  GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = $8808;
  GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = $8809;
  GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = $880A;
  GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB = $880B;
  GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB = $880C;
  GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB = $880D;
  GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = $880E;
  GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = $880F;
  GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = $8810;
  // GL_PROGRAM_STRING_ARB  { already defined }
  // GL_PROGRAM_ERROR_POSITION_ARB  { already defined }
  // GL_CURRENT_MATRIX_ARB  { already defined }
  // GL_TRANSPOSE_CURRENT_MATRIX_ARB  { already defined }
  // GL_CURRENT_MATRIX_STACK_DEPTH_ARB  { already defined }
  // GL_MAX_PROGRAM_MATRICES_ARB  { already defined }
  // GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB  { already defined }
  GL_MAX_TEXTURE_COORDS_ARB = $8871;
  GL_MAX_TEXTURE_IMAGE_UNITS_ARB = $8872;
  // GL_PROGRAM_ERROR_STRING_ARB  { already defined }
  // GL_MATRIX0_ARB  { already defined }
  // GL_MATRIX1_ARB  { already defined }
  // GL_MATRIX2_ARB  { already defined }
  // GL_MATRIX3_ARB  { already defined }
  // GL_MATRIX4_ARB  { already defined }
  // GL_MATRIX5_ARB  { already defined }
  // GL_MATRIX6_ARB  { already defined }
  // GL_MATRIX7_ARB  { already defined }
  // GL_MATRIX8_ARB  { already defined }
  // GL_MATRIX9_ARB  { already defined }
  // GL_MATRIX10_ARB  { already defined }
  // GL_MATRIX11_ARB  { already defined }
  // GL_MATRIX12_ARB  { already defined }
  // GL_MATRIX13_ARB  { already defined }
  // GL_MATRIX14_ARB  { already defined }
  // GL_MATRIX15_ARB  { already defined }
  // GL_MATRIX16_ARB  { already defined }
  // GL_MATRIX17_ARB  { already defined }
  // GL_MATRIX18_ARB  { already defined }
  // GL_MATRIX19_ARB  { already defined }
  // GL_MATRIX20_ARB  { already defined }
  // GL_MATRIX21_ARB  { already defined }
  // GL_MATRIX22_ARB  { already defined }
  // GL_MATRIX23_ARB  { already defined }
  // GL_MATRIX24_ARB  { already defined }
  // GL_MATRIX25_ARB  { already defined }
  // GL_MATRIX26_ARB  { already defined }
  // GL_MATRIX27_ARB  { already defined }
  // GL_MATRIX28_ARB  { already defined }
  // GL_MATRIX29_ARB  { already defined }
  // GL_MATRIX30_ARB  { already defined }
  // GL_MATRIX31_ARB  { already defined }
  // glProgramStringARB  { already defined }
  // glBindProgramARB  { already defined }
  // glDeleteProgramsARB  { already defined }
  // glGenProgramsARB  { already defined }
  // glProgramEnvParameter4dARB  { already defined }
  // glProgramEnvParameter4dvARB  { already defined }
  // glProgramEnvParameter4fARB  { already defined }
  // glProgramEnvParameter4fvARB  { already defined }
  // glProgramLocalParameter4dARB  { already defined }
  // glProgramLocalParameter4dvARB  { already defined }
  // glProgramLocalParameter4fARB  { already defined }
  // glProgramLocalParameter4fvARB  { already defined }
  // glGetProgramEnvParameterdvARB  { already defined }
  // glGetProgramEnvParameterfvARB  { already defined }
  // glGetProgramLocalParameterdvARB  { already defined }
  // glGetProgramLocalParameterfvARB  { already defined }
  // glGetProgramivARB  { already defined }
  // glGetProgramStringARB  { already defined }
  // glIsProgramARB  { already defined }

function Load_GL_ARB_fragment_program: Boolean;

{***** GL_ATI_text_fragment_shader *****}
const
     GL_TEXT_FRAGMENT_SHADER_ATI = $8200;

{***** GL_ARB_vertex_buffer_object *****}
const
     GL_BUFFER_SIZE_ARB = $8764;
     GL_BUFFER_USAGE_ARB = $8765;
     GL_ARRAY_BUFFER_ARB = $8892;
     GL_ELEMENT_ARRAY_BUFFER_ARB = $8893;
     GL_ARRAY_BUFFER_BINDING_ARB = $8894;
     GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB = $8895;
     GL_VERTEX_ARRAY_BUFFER_BINDING_ARB = $8896;
     GL_NORMAL_ARRAY_BUFFER_BINDING_ARB = $8897;
     GL_COLOR_ARRAY_BUFFER_BINDING_ARB = $8898;
     GL_INDEX_ARRAY_BUFFER_BINDING_ARB = $8899;
     GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB = $889A;
     GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB = $889B;
     GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB = $889C;
     GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB = $889D;
     GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB = $889E;
     GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB = $889F;
     GL_READ_ONLY_ARB = $88B8;
     GL_WRITE_ONLY_ARB = $88B9;
     GL_READ_WRITE_ARB = $88BA;
     GL_BUFFER_ACCESS_ARB = $88BB;
     GL_BUFFER_MAPPED_ARB = $88BC;
     GL_BUFFER_MAP_POINTER_ARB = $88BD;
     GL_STREAM_DRAW_ARB = $88E0;
     GL_STREAM_READ_ARB = $88E1;
     GL_STREAM_COPY_ARB = $88E2;
     GL_STATIC_DRAW_ARB = $88E4;
     GL_STATIC_READ_ARB = $88E5;
     GL_STATIC_COPY_ARB = $88E6;
     GL_DYNAMIC_DRAW_ARB = $88E8;
     GL_DYNAMIC_READ_ARB = $88E9;
     GL_DYNAMIC_COPY_ARB = $88EA;

var
     glBindBufferARB : procedure(target : GLenum; buffer: GLuint); extdecl;
     glDeleteBuffersARB : procedure(n : GLsizei; buffers : PGLuint); extdecl;
     glGenBuffersARB : procedure(n : GLsizei; buffers : PGLuint); extdecl;
     glIsBufferARB : function (buffer : GLuint) :GLboolean; extdecl;
     glBufferDataARB : procedure(target : GLenum; size:GLsizei; data:PGLvoid;usage: GLenum); extdecl;
     glBufferSubDataARB : procedure(target : GLenum; offset :GLint; size : GLsizei; data: PGLvoid); extdecl;
     glGetBufferSubDataARB : procedure(target : GLenum; offset :GLint; size : GLsizei; data: PGLvoid); extdecl;
     glMapBufferARB : function (target :GLenum; access: GLenum) : PGLvoid; extdecl;
     glUnmapBufferARB : function (target :GLenum) :GLboolean; extdecl;
     glGetBufferParameterivARB:procedure(target:GLenum; pname:GLenum; params:PGLint); extdecl;
     glGetBufferPointervARB : procedure(target: GLenum; pname:GLenum; params: PPGLvoid); extdecl;
     function Load_GL_ARB_vertex_buffer_object : boolean;

function Load_GL_ATI_text_fragment_shader: Boolean;

//***** GL_APPLE_client_storage *****//
const
  GL_UNPACK_CLIENT_STORAGE_APPLE = $85B2;

function Load_GL_APPLE_client_storage: Boolean;

//***** GL_APPLE_element_array *****//
const
  GL_ELEMENT_ARRAY_APPLE = $8768;
  GL_ELEMENT_ARRAY_TYPE_APPLE = $8769;
  GL_ELEMENT_ARRAY_POINTER_APPLE = $876A;
var
  glElementPointerAPPLE: procedure(_type: GLenum; const pointer: PGLvoid); extdecl;
  glDrawElementArrayAPPLE: procedure(mode: GLenum; first: GLint; count: GLsizei); extdecl;
  glDrawRangeElementArrayAPPLE: procedure(mode: GLenum; start: GLuint; _end: GLuint; first: GLint; count: GLsizei); extdecl;
  glMultiDrawElementArrayAPPLE: procedure(mode: GLenum; const first: PGLint; const count: PGLsizei; primcount: GLsizei); extdecl;
  glMultiDrawRangeElementArrayAPPLE: procedure(mode: GLenum; start: GLuint; _end: GLuint; const first: PGLint; const count: PGLsizei; primcount: GLsizei); extdecl;

function Load_GL_APPLE_element_array: Boolean;

//***** GL_APPLE_fence *****//
const
  GL_DRAW_PIXELS_APPLE = $8A0A;
  GL_FENCE_APPLE = $8A0B;
var
  glGenFencesAPPLE: procedure(n: GLsizei; fences: PGLuint); extdecl;
  glDeleteFencesAPPLE: procedure(n: GLsizei; const fences: PGLuint); extdecl;
  glSetFenceAPPLE: procedure(fence: GLuint); extdecl;
  glIsFenceAPPLE: function(fence: GLuint): GLboolean; extdecl;
  glTestFenceAPPLE: function(fence: GLuint): GLboolean; extdecl;
  glFinishFenceAPPLE: procedure(fence: GLuint); extdecl;
  glTestObjectAPPLE: function(_object: GLenum; name: GLuint): GLboolean; extdecl;
  glFinishObjectAPPLE: procedure(_object: GLenum; name: GLint); extdecl;

function Load_GL_APPLE_fence: Boolean;

//***** GL_APPLE_vertex_array_object *****//
const
  GL_VERTEX_ARRAY_BINDING_APPLE = $85B5;
var
  glBindVertexArrayAPPLE: procedure(_array: GLuint); extdecl;
  glDeleteVertexArraysAPPLE: procedure(n: GLsizei; const arrays: PGLuint); extdecl;
  glGenVertexArraysAPPLE: procedure(n: GLsizei; const arrays: PGLuint); extdecl;
  glIsVertexArrayAPPLE: function(_array: GLuint): GLboolean; extdecl;

function Load_GL_APPLE_vertex_array_object: Boolean;

//***** GL_APPLE_vertex_array_range *****//
const
  GL_VERTEX_ARRAY_RANGE_APPLE = $851D;
  GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE = $851E;
  GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_APPLE = $8520;
  GL_VERTEX_ARRAY_RANGE_POINTER_APPLE = $8521;
  GL_VERTEX_ARRAY_STORAGE_HINT_APPLE = $851F;
  GL_STORAGE_CACHED_APPLE = $85BE;
  GL_STORAGE_SHARED_APPLE = $85BF;
var
  glVertexArrayRangeAPPLE: procedure(length: GLsizei; pointer: PGLvoid); extdecl;
  glFlushVertexArrayRangeAPPLE: procedure(length: GLsizei; pointer: PGLvoid); extdecl;
  glVertexArrayParameteriAPPLE: procedure(pname: GLenum; param: GLint); extdecl;

function Load_GL_APPLE_vertex_array_range: Boolean;

{$IFDEF Win32}
//***** WGL_ARB_pixel_format *****//
const
  WGL_NUMBER_PIXEL_FORMATS_ARB = $2000;
  WGL_DRAW_TO_WINDOW_ARB = $2001;
  WGL_DRAW_TO_BITMAP_ARB = $2002;
  WGL_ACCELERATION_ARB = $2003;
  WGL_NEED_PALETTE_ARB = $2004;
  WGL_NEED_SYSTEM_PALETTE_ARB = $2005;
  WGL_SWAP_LAYER_BUFFERS_ARB = $2006;
  WGL_SWAP_METHOD_ARB = $2007;
  WGL_NUMBER_OVERLAYS_ARB = $2008;
  WGL_NUMBER_UNDERLAYS_ARB = $2009;
  WGL_TRANSPARENT_ARB = $200A;
  WGL_TRANSPARENT_RED_VALUE_ARB = $2037;
  WGL_TRANSPARENT_GREEN_VALUE_ARB = $2038;
  WGL_TRANSPARENT_BLUE_VALUE_ARB = $2039;
  WGL_TRANSPARENT_ALPHA_VALUE_ARB = $203A;
  WGL_TRANSPARENT_INDEX_VALUE_ARB = $203B;
  WGL_SHARE_DEPTH_ARB = $200C;
  WGL_SHARE_STENCIL_ARB = $200D;
  WGL_SHARE_ACCUM_ARB = $200E;
  WGL_SUPPORT_GDI_ARB = $200F;
  WGL_SUPPORT_OPENGL_ARB = $2010;
  WGL_DOUBLE_BUFFER_ARB = $2011;
  WGL_STEREO_ARB = $2012;
  WGL_PIXEL_TYPE_ARB = $2013;
  WGL_COLOR_BITS_ARB = $2014;
  WGL_RED_BITS_ARB = $2015;
  WGL_RED_SHIFT_ARB = $2016;
  WGL_GREEN_BITS_ARB = $2017;
  WGL_GREEN_SHIFT_ARB = $2018;
  WGL_BLUE_BITS_ARB = $2019;
  WGL_BLUE_SHIFT_ARB = $201A;
  WGL_ALPHA_BITS_ARB = $201B;
  WGL_ALPHA_SHIFT_ARB = $201C;
  WGL_ACCUM_BITS_ARB = $201D;
  WGL_ACCUM_RED_BITS_ARB = $201E;
  WGL_ACCUM_GREEN_BITS_ARB = $201F;
  WGL_ACCUM_BLUE_BITS_ARB = $2020;
  WGL_ACCUM_ALPHA_BITS_ARB = $2021;
  WGL_DEPTH_BITS_ARB = $2022;
  WGL_STENCIL_BITS_ARB = $2023;
  WGL_AUX_BUFFERS_ARB = $2024;
  WGL_NO_ACCELERATION_ARB = $2025;
  WGL_GENERIC_ACCELERATION_ARB = $2026;
  WGL_FULL_ACCELERATION_ARB = $2027;
  WGL_SWAP_EXCHANGE_ARB = $2028;
  WGL_SWAP_COPY_ARB = $2029;
  WGL_SWAP_UNDEFINED_ARB = $202A;
  WGL_TYPE_RGBA_ARB = $202B;
  WGL_TYPE_COLORINDEX_ARB = $202C;
var
  wglGetPixelFormatAttribivARB: function(hdc: HDC; iPixelFormat: GLint; iLayerPlane: GLint; nAttributes: GLuint; const piAttributes: PGLint; piValues: PGLint): BOOL; extdecl;
  wglGetPixelFormatAttribfvARB: function(hdc: HDC; iPixelFormat: GLint; iLayerPlane: GLint; nAttributes: GLuint; const piAttributes: PGLint; pfValues: PGLfloat): BOOL; extdecl;
  wglChoosePixelFormatARB: function(hdc: HDC; const piAttribIList: PGLint; const pfAttribFList: PGLfloat; nMaxFormats: GLuint; piFormats: PGLint; nNumFormats: PGLuint): BOOL; extdecl;

function Load_WGL_ARB_pixel_format: Boolean;

//***** WGL_ARB_make_current_read *****//
const
  WGL_ERROR_INVALID_PIXEL_TYPE_ARB = $2043;
  WGL_ERROR_INCOMPATIBLE_DEVICE_CONTEXTS_ARB = $2054;
var
  wglMakeContextCurrentARB: function(hDrawDC: HDC; hReadDC: HDC; hglrc: HGLRC): BOOL; extdecl;
  wglGetCurrentReadDCARB: function(): HDC; extdecl;

function Load_WGL_ARB_make_current_read: Boolean;

//***** WGL_ARB_pbuffer *****//
const
  WGL_DRAW_TO_PBUFFER_ARB = $202D;
  // WGL_DRAW_TO_PBUFFER_ARB  { already defined }
  WGL_MAX_PBUFFER_PIXELS_ARB = $202E;
  WGL_MAX_PBUFFER_WIDTH_ARB = $202F;
  WGL_MAX_PBUFFER_HEIGHT_ARB = $2030;
  WGL_PBUFFER_LARGEST_ARB = $2033;
  WGL_PBUFFER_WIDTH_ARB = $2034;
  WGL_PBUFFER_HEIGHT_ARB = $2035;
  WGL_PBUFFER_LOST_ARB = $2036;
var
  wglCreatePbufferARB: function(hDC: HDC; iPixelFormat: GLint; iWidth: GLint; iHeight: GLint; const piAttribList: PGLint): THandle; extdecl;
  wglGetPbufferDCARB: function(hPbuffer: THandle): HDC; extdecl;
  wglReleasePbufferDCARB: function(hPbuffer: THandle; hDC: HDC): GLint; extdecl;
  wglDestroyPbufferARB: function(hPbuffer: THandle): BOOL; extdecl;
  wglQueryPbufferARB: function(hPbuffer: THandle; iAttribute: GLint; piValue: PGLint): BOOL; extdecl;

function Load_WGL_ARB_pbuffer: Boolean;

//***** WGL_EXT_swap_control *****//
var
  wglSwapIntervalEXT: function(interval: GLint): BOOL; extdecl;
  wglGetSwapIntervalEXT: function(): GLint; extdecl;

function Load_WGL_EXT_swap_control: Boolean;

//***** WGL_ARB_render_texture *****//
const
  WGL_BIND_TO_TEXTURE_RGB_ARB = $2070;
  WGL_BIND_TO_TEXTURE_RGBA_ARB = $2071;
  WGL_TEXTURE_FORMAT_ARB = $2072;
  WGL_TEXTURE_TARGET_ARB = $2073;
  WGL_MIPMAP_TEXTURE_ARB = $2074;
  WGL_TEXTURE_RGB_ARB = $2075;
  WGL_TEXTURE_RGBA_ARB = $2076;
  WGL_NO_TEXTURE_ARB = $2077;
  WGL_TEXTURE_CUBE_MAP_ARB = $2078;
  WGL_TEXTURE_1D_ARB = $2079;
  WGL_TEXTURE_2D_ARB = $207A;
  // WGL_NO_TEXTURE_ARB  { already defined }
  WGL_MIPMAP_LEVEL_ARB = $207B;
  WGL_CUBE_MAP_FACE_ARB = $207C;
  WGL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB = $207D;
  WGL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB = $207E;
  WGL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB = $207F;
  WGL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB = $2080;
  WGL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB = $2081;
  WGL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB = $2082;
  WGL_FRONT_LEFT_ARB = $2083;
  WGL_FRONT_RIGHT_ARB = $2084;
  WGL_BACK_LEFT_ARB = $2085;
  WGL_BACK_RIGHT_ARB = $2086;
  WGL_AUX0_ARB = $2087;
  WGL_AUX1_ARB = $2088;
  WGL_AUX2_ARB = $2089;
  WGL_AUX3_ARB = $208A;
  WGL_AUX4_ARB = $208B;
  WGL_AUX5_ARB = $208C;
  WGL_AUX6_ARB = $208D;
  WGL_AUX7_ARB = $208E;
  WGL_AUX8_ARB = $208F;
  WGL_AUX9_ARB = $2090;
var
  wglBindTexImageARB: function(hPbuffer: THandle; iBuffer: GLint): BOOL; extdecl;
  wglReleaseTexImageARB: function(hPbuffer: THandle; iBuffer: GLint): BOOL; extdecl;
  wglSetPbufferAttribARB: function(hPbuffer: THandle; const piAttribList: PGLint): BOOL; extdecl;

function Load_WGL_ARB_render_texture: Boolean;

//***** WGL_EXT_extensions_string *****//
var
  wglGetExtensionsStringEXT: function(): Pchar; extdecl;

function Load_WGL_EXT_extensions_string: Boolean;

//***** WGL_EXT_make_current_read *****//
var
  wglMakeContextCurrentEXT: function(hDrawDC: HDC; hReadDC: HDC; hglrc: HGLRC): BOOL; extdecl;
  wglGetCurrentReadDCEXT: function(): HDC; extdecl;

function Load_WGL_EXT_make_current_read: Boolean;

//***** WGL_EXT_pbuffer *****//
const
  WGL_DRAW_TO_PBUFFER_EXT = $202D;
  WGL_MAX_PBUFFER_PIXELS_EXT = $202E;
  WGL_MAX_PBUFFER_WIDTH_EXT = $202F;
  WGL_MAX_PBUFFER_HEIGHT_EXT = $2030;
  WGL_OPTIMAL_PBUFFER_WIDTH_EXT = $2031;
  WGL_OPTIMAL_PBUFFER_HEIGHT_EXT = $2032;
  WGL_PBUFFER_LARGEST_EXT = $2033;
  WGL_PBUFFER_WIDTH_EXT = $2034;
  WGL_PBUFFER_HEIGHT_EXT = $2035;
var
  wglCreatePbufferEXT: function(hDC: HDC; iPixelFormat: GLint; iWidth: GLint; iHeight: GLint; const piAttribList: PGLint): THandle; extdecl;
  wglGetPbufferDCEXT: function(hPbuffer: THandle): HDC; extdecl;
  wglReleasePbufferDCEXT: function(hPbuffer: THandle; hDC: HDC): GLint; extdecl;
  wglDestroyPbufferEXT: function(hPbuffer: THandle): BOOL; extdecl;
  wglQueryPbufferEXT: function(hPbuffer: THandle; iAttribute: GLint; piValue: PGLint): BOOL; extdecl;

function Load_WGL_EXT_pbuffer: Boolean;

//***** WGL_EXT_pixel_format *****//
const
  WGL_NUMBER_PIXEL_FORMATS_EXT = $2000;
  WGL_DRAW_TO_WINDOW_EXT = $2001;
  WGL_DRAW_TO_BITMAP_EXT = $2002;
  WGL_ACCELERATION_EXT = $2003;
  WGL_NEED_PALETTE_EXT = $2004;
  WGL_NEED_SYSTEM_PALETTE_EXT = $2005;
  WGL_SWAP_LAYER_BUFFERS_EXT = $2006;
  WGL_SWAP_METHOD_EXT = $2007;
  WGL_NUMBER_OVERLAYS_EXT = $2008;
  WGL_NUMBER_UNDERLAYS_EXT = $2009;
  WGL_TRANSPARENT_EXT = $200A;
  WGL_TRANSPARENT_VALUE_EXT = $200B;
  WGL_SHARE_DEPTH_EXT = $200C;
  WGL_SHARE_STENCIL_EXT = $200D;
  WGL_SHARE_ACCUM_EXT = $200E;
  WGL_SUPPORT_GDI_EXT = $200F;
  WGL_SUPPORT_OPENGL_EXT = $2010;
  WGL_DOUBLE_BUFFER_EXT = $2011;
  WGL_STEREO_EXT = $2012;
  WGL_PIXEL_TYPE_EXT = $2013;
  WGL_COLOR_BITS_EXT = $2014;
  WGL_RED_BITS_EXT = $2015;
  WGL_RED_SHIFT_EXT = $2016;
  WGL_GREEN_BITS_EXT = $2017;
  WGL_GREEN_SHIFT_EXT = $2018;
  WGL_BLUE_BITS_EXT = $2019;
  WGL_BLUE_SHIFT_EXT = $201A;
  WGL_ALPHA_BITS_EXT = $201B;
  WGL_ALPHA_SHIFT_EXT = $201C;
  WGL_ACCUM_BITS_EXT = $201D;
  WGL_ACCUM_RED_BITS_EXT = $201E;
  WGL_ACCUM_GREEN_BITS_EXT = $201F;
  WGL_ACCUM_BLUE_BITS_EXT = $2020;
  WGL_ACCUM_ALPHA_BITS_EXT = $2021;
  WGL_DEPTH_BITS_EXT = $2022;
  WGL_STENCIL_BITS_EXT = $2023;
  WGL_AUX_BUFFERS_EXT = $2024;
  WGL_NO_ACCELERATION_EXT = $2025;
  WGL_GENERIC_ACCELERATION_EXT = $2026;
  WGL_FULL_ACCELERATION_EXT = $2027;
  WGL_SWAP_EXCHANGE_EXT = $2028;
  WGL_SWAP_COPY_EXT = $2029;
  WGL_SWAP_UNDEFINED_EXT = $202A;
  WGL_TYPE_RGBA_EXT = $202B;
  WGL_TYPE_COLORINDEX_EXT = $202C;
var
  wglGetPixelFormatAttribivEXT: function(hdc: HDC; iPixelFormat: GLint; iLayerPlane: GLint; nAttributes: GLuint; piAttributes: PGLint; piValues: PGLint): BOOL; extdecl;
  wglGetPixelFormatAttribfvEXT: function(hdc: HDC; iPixelFormat: GLint; iLayerPlane: GLint; nAttributes: GLuint; piAttributes: PGLint; pfValues: PGLfloat): BOOL; extdecl;
  wglChoosePixelFormatEXT: function(hdc: HDC; const piAttribIList: PGLint; const pfAttribFList: PGLfloat; nMaxFormats: GLuint; piFormats: PGLint; nNumFormats: PGLuint): BOOL; extdecl;

function Load_WGL_EXT_pixel_format: Boolean;

//***** WGL_I3D_digital_video_control *****//
const
  WGL_DIGITAL_VIDEO_CURSOR_ALPHA_FRAMEBUFFER_I3D = $2050;
  WGL_DIGITAL_VIDEO_CURSOR_ALPHA_VALUE_I3D = $2051;
  WGL_DIGITAL_VIDEO_CURSOR_INCLUDED_I3D = $2052;
  WGL_DIGITAL_VIDEO_GAMMA_CORRECTED_I3D = $2053;
var
  wglGetDigitalVideoParametersI3D: function(hDC: HDC; iAttribute: GLint; piValue: PGLint): BOOL; extdecl;
  wglSetDigitalVideoParametersI3D: function(hDC: HDC; iAttribute: GLint; const piValue: PGLint): BOOL; extdecl;

function Load_WGL_I3D_digital_video_control: Boolean;

//***** WGL_I3D_gamma *****//
const
  WGL_GAMMA_TABLE_SIZE_I3D = $204E;
  WGL_GAMMA_EXCLUDE_DESKTOP_I3D = $204F;
  // WGL_GAMMA_EXCLUDE_DESKTOP_I3D  { already defined }
var
  wglGetGammaTableParametersI3D: function(hDC: HDC; iAttribute: GLint; piValue: PGLint): BOOL; extdecl;
  wglSetGammaTableParametersI3D: function(hDC: HDC; iAttribute: GLint; const piValue: PGLint): BOOL; extdecl;
  wglGetGammaTableI3D: function(hDC: HDC; iEntries: GLint; puRed: PGLUSHORT; puGreen: PGLUSHORT; puBlue: PGLUSHORT): BOOL; extdecl;
  wglSetGammaTableI3D: function(hDC: HDC; iEntries: GLint; const puRed: PGLUSHORT; const puGreen: PGLUSHORT; const puBlue: PGLUSHORT): BOOL; extdecl;

function Load_WGL_I3D_gamma: Boolean;

//***** WGL_I3D_genlock *****//
const
  WGL_GENLOCK_SOURCE_MULTIVIEW_I3D = $2044;
  WGL_GENLOCK_SOURCE_EXTERNAL_SYNC_I3D = $2045;
  WGL_GENLOCK_SOURCE_EXTERNAL_FIELD_I3D = $2046;
  WGL_GENLOCK_SOURCE_EXTERNAL_TTL_I3D = $2047;
  WGL_GENLOCK_SOURCE_DIGITAL_SYNC_I3D = $2048;
  WGL_GENLOCK_SOURCE_DIGITAL_FIELD_I3D = $2049;
  WGL_GENLOCK_SOURCE_EDGE_FALLING_I3D = $204A;
  WGL_GENLOCK_SOURCE_EDGE_RISING_I3D = $204B;
  WGL_GENLOCK_SOURCE_EDGE_BOTH_I3D = $204C;
var
  wglEnableGenlockI3D: function(hDC: HDC): BOOL; extdecl;
  wglDisableGenlockI3D: function(hDC: HDC): BOOL; extdecl;
  wglIsEnabledGenlockI3D: function(hDC: HDC; pFlag: PBOOL): BOOL; extdecl;
  wglGenlockSourceI3D: function(hDC: HDC; uSource: GLUINT): BOOL; extdecl;
  wglGetGenlockSourceI3D: function(hDC: HDC; uSource: PGLUINT): BOOL; extdecl;
  wglGenlockSourceEdgeI3D: function(hDC: HDC; uEdge: GLUINT): BOOL; extdecl;
  wglGetGenlockSourceEdgeI3D: function(hDC: HDC; uEdge: PGLUINT): BOOL; extdecl;
  wglGenlockSampleRateI3D: function(hDC: HDC; uRate: GLUINT): BOOL; extdecl;
  wglGetGenlockSampleRateI3D: function(hDC: HDC; uRate: PGLUINT): BOOL; extdecl;
  wglGenlockSourceDelayI3D: function(hDC: HDC; uDelay: GLUINT): BOOL; extdecl;
  wglGetGenlockSourceDelayI3D: function(hDC: HDC; uDelay: PGLUINT): BOOL; extdecl;
  wglQueryGenlockMaxSourceDelayI3D: function(hDC: HDC; uMaxLineDelay: PGLUINT; uMaxPixelDelay: PGLUINT): BOOL; extdecl;

function Load_WGL_I3D_genlock: Boolean;
{$ENDIF}

//***** GL_ARB_matrix_palette *****//
const
  GL_MATRIX_PALETTE_ARB = $8840;
  GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB = $8841;
  GL_MAX_PALETTE_MATRICES_ARB = $8842;
  GL_CURRENT_PALETTE_MATRIX_ARB = $8843;
  GL_MATRIX_INDEX_ARRAY_ARB = $8844;
  GL_CURRENT_MATRIX_INDEX_ARB = $8845;
  GL_MATRIX_INDEX_ARRAY_SIZE_ARB = $8846;
  GL_MATRIX_INDEX_ARRAY_TYPE_ARB = $8847;
  GL_MATRIX_INDEX_ARRAY_STRIDE_ARB = $8848;
  GL_MATRIX_INDEX_ARRAY_POINTER_ARB = $8849;
var
  glCurrentPaletteMatrixARB: procedure(index: GLint); extdecl;
  glMatrixIndexubvARB: procedure(size: GLint; indices: PGLubyte); extdecl;
  glMatrixIndexusvARB: procedure(size: GLint; indices: PGLushort); extdecl;
  glMatrixIndexuivARB: procedure(size: GLint; indices: PGLuint); extdecl;
  glMatrixIndexPointerARB: procedure(size: GLint; _type: GLenum; stride: GLsizei; pointer: PGLvoid); extdecl;

function Load_GL_ARB_matrix_palette: Boolean;

//***** GL_NV_element_array *****//
const
  GL_ELEMENT_ARRAY_TYPE_NV = $8769;
  GL_ELEMENT_ARRAY_POINTER_NV = $876A;
var
  glElementPointerNV: procedure(_type: GLenum; const pointer: PGLvoid); extdecl;
  glDrawElementArrayNV: procedure(mode: GLenum; first: GLint; count: GLsizei); extdecl;
  glDrawRangeElementArrayNV: procedure(mode: GLenum; start: GLuint; _end: GLuint; first: GLint; count: GLsizei); extdecl;
  glMultiDrawElementArrayNV: procedure(mode: GLenum; const first: PGLint; const count: PGLsizei; primcount: GLsizei); extdecl;
  glMultiDrawRangeElementArrayNV: procedure(mode: GLenum; start: GLuint; _end: GLuint; const first: PGLint; const count: PGLsizei; primcount: GLsizei); extdecl;

function Load_GL_NV_element_array: Boolean;

//***** GL_NV_float_buffer *****//
const
  GL_FLOAT_R_NV = $8880;
  GL_FLOAT_RG_NV = $8881;
  GL_FLOAT_RGB_NV = $8882;
  GL_FLOAT_RGBA_NV = $8883;
  GL_FLOAT_R16_NV = $8884;
  GL_FLOAT_R32_NV = $8885;
  GL_FLOAT_RG16_NV = $8886;
  GL_FLOAT_RG32_NV = $8887;
  GL_FLOAT_RGB16_NV = $8888;
  GL_FLOAT_RGB32_NV = $8889;
  GL_FLOAT_RGBA16_NV = $888A;
  GL_FLOAT_RGBA32_NV = $888B;
  GL_TEXTURE_FLOAT_COMPONENTS_NV = $888C;
  GL_FLOAT_CLEAR_COLOR_VALUE_NV = $888D;
  GL_FLOAT_RGBA_MODE_NV = $888E;
{$IFDEF Win32}
  WGL_FLOAT_COMPONENTS_NV = $20B0;
  WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_R_NV = $20B1;
  WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RG_NV = $20B2;
  WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RGB_NV = $20B3;
  WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RGBA_NV = $20B4;
  WGL_TEXTURE_FLOAT_R_NV = $20B5;
  WGL_TEXTURE_FLOAT_RG_NV = $20B6;
  WGL_TEXTURE_FLOAT_RGB_NV = $20B7;
  WGL_TEXTURE_FLOAT_RGBA_NV = $20B8;
{$ENDIF}

function Load_GL_NV_float_buffer: Boolean;

//***** GL_NV_fragment_program *****//
const
  GL_FRAGMENT_PROGRAM_NV = $8870;
  GL_MAX_TEXTURE_COORDS_NV = $8871;
  GL_MAX_TEXTURE_IMAGE_UNITS_NV = $8872;
  GL_FRAGMENT_PROGRAM_BINDING_NV = $8873;
  GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV = $8868;
  GL_PROGRAM_ERROR_STRING_NV = $8874;
var
  glProgramNamedParameter4fNV: procedure(id: GLuint; len: GLsizei; const name: PGLubyte; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat); extdecl;
  glProgramNamedParameter4dNV: procedure(id: GLuint; len: GLsizei; const name: PGLubyte; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble); extdecl;
  glGetProgramNamedParameterfvNV: procedure(id: GLuint; len: GLsizei; const name: PGLubyte; params: PGLfloat); extdecl;
  glGetProgramNamedParameterdvNV: procedure(id: GLuint; len: GLsizei; const name: PGLubyte; params: PGLdouble); extdecl;
  // glProgramLocalParameter4dARB  { already defined }
  // glProgramLocalParameter4dvARB  { already defined }
  // glProgramLocalParameter4fARB  { already defined }
  // glProgramLocalParameter4fvARB  { already defined }
  // glGetProgramLocalParameterdvARB  { already defined }
  // glGetProgramLocalParameterfvARB  { already defined }

function Load_GL_NV_fragment_program: Boolean;

//***** GL_NV_primitive_restart *****//
const
  GL_PRIMITIVE_RESTART_NV = $8558;
  GL_PRIMITIVE_RESTART_INDEX_NV = $8559;
var
  glPrimitiveRestartNV: procedure(); extdecl;
  glPrimitiveRestartIndexNV: procedure(index: GLuint); extdecl;

function Load_GL_NV_primitive_restart: Boolean;

//***** GL_NV_vertex_program2 *****//

function Load_GL_NV_vertex_program2: Boolean;

implementation

{$IFNDEF Win32}
function wglGetProcAddress(proc: PChar): Pointer;
begin
  Result := GetProcAddress(LibGL, proc);
end;
{$ENDIF}

function glext_ExtensionSupported(const extension: String; const searchIn: String): Boolean;
var
  extensions: PChar;
  start: PChar;
  where, terminator: PChar;
begin

  if (Pos(' ', extension) <> 0) or (extension = '') then
  begin
    Result := FALSE;
    Exit;
  end;

  if searchIn = '' then extensions := PChar(glGetString(GL_EXTENSIONS))
  else extensions := PChar(searchIn);
  start := extensions;
  while TRUE do
  begin
    where := StrPos(start, PChar(extension));
    if where = nil then Break;
    terminator := Pointer(Integer(where) + Length(extension));
    if (where = start) or (PChar(Integer(where) - 1)^ = ' ') then
    begin
      if (terminator^ = ' ') or (terminator^ = #0) then
      begin
        Result := TRUE;
        Exit;
      end;
    end;
    start := terminator;
  end;
  Result := FALSE;

end;

function Load_GL_version_1_2: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

    glBlendColor := wglGetProcAddress('glBlendColor');
    if not Assigned(glBlendColor) then Exit;
    glBlendEquation := wglGetProcAddress('glBlendEquation');
    if not Assigned(glBlendEquation) then Exit;
    glDrawRangeElements := wglGetProcAddress('glDrawRangeElements');
    if not Assigned(glDrawRangeElements) then Exit;
    glColorTable := wglGetProcAddress('glColorTable');
    if not Assigned(glColorTable) then Exit;
    glColorTableParameterfv := wglGetProcAddress('glColorTableParameterfv');
    if not Assigned(glColorTableParameterfv) then Exit;
    glColorTableParameteriv := wglGetProcAddress('glColorTableParameteriv');
    if not Assigned(glColorTableParameteriv) then Exit;
    glCopyColorTable := wglGetProcAddress('glCopyColorTable');
    if not Assigned(glCopyColorTable) then Exit;
    glGetColorTable := wglGetProcAddress('glGetColorTable');
    if not Assigned(glGetColorTable) then Exit;
    glGetColorTableParameterfv := wglGetProcAddress('glGetColorTableParameterfv');
    if not Assigned(glGetColorTableParameterfv) then Exit;
    glGetColorTableParameteriv := wglGetProcAddress('glGetColorTableParameteriv');
    if not Assigned(glGetColorTableParameteriv) then Exit;
    glColorSubTable := wglGetProcAddress('glColorSubTable');
    if not Assigned(glColorSubTable) then Exit;
    glCopyColorSubTable := wglGetProcAddress('glCopyColorSubTable');
    if not Assigned(glCopyColorSubTable) then Exit;
    glConvolutionFilter1D := wglGetProcAddress('glConvolutionFilter1D');
    if not Assigned(glConvolutionFilter1D) then Exit;
    glConvolutionFilter2D := wglGetProcAddress('glConvolutionFilter2D');
    if not Assigned(glConvolutionFilter2D) then Exit;
    glConvolutionParameterf := wglGetProcAddress('glConvolutionParameterf');
    if not Assigned(glConvolutionParameterf) then Exit;
    glConvolutionParameterfv := wglGetProcAddress('glConvolutionParameterfv');
    if not Assigned(glConvolutionParameterfv) then Exit;
    glConvolutionParameteri := wglGetProcAddress('glConvolutionParameteri');
    if not Assigned(glConvolutionParameteri) then Exit;
    glConvolutionParameteriv := wglGetProcAddress('glConvolutionParameteriv');
    if not Assigned(glConvolutionParameteriv) then Exit;
    glCopyConvolutionFilter1D := wglGetProcAddress('glCopyConvolutionFilter1D');
    if not Assigned(glCopyConvolutionFilter1D) then Exit;
    glCopyConvolutionFilter2D := wglGetProcAddress('glCopyConvolutionFilter2D');
    if not Assigned(glCopyConvolutionFilter2D) then Exit;
    glGetConvolutionFilter := wglGetProcAddress('glGetConvolutionFilter');
    if not Assigned(glGetConvolutionFilter) then Exit;
    glGetConvolutionParameterfv := wglGetProcAddress('glGetConvolutionParameterfv');
    if not Assigned(glGetConvolutionParameterfv) then Exit;
    glGetConvolutionParameteriv := wglGetProcAddress('glGetConvolutionParameteriv');
    if not Assigned(glGetConvolutionParameteriv) then Exit;
    glGetSeparableFilter := wglGetProcAddress('glGetSeparableFilter');
    if not Assigned(glGetSeparableFilter) then Exit;
    glSeparableFilter2D := wglGetProcAddress('glSeparableFilter2D');
    if not Assigned(glSeparableFilter2D) then Exit;
    glGetHistogram := wglGetProcAddress('glGetHistogram');
    if not Assigned(glGetHistogram) then Exit;
    glGetHistogramParameterfv := wglGetProcAddress('glGetHistogramParameterfv');
    if not Assigned(glGetHistogramParameterfv) then Exit;
    glGetHistogramParameteriv := wglGetProcAddress('glGetHistogramParameteriv');
    if not Assigned(glGetHistogramParameteriv) then Exit;
    glGetMinmax := wglGetProcAddress('glGetMinmax');
    if not Assigned(glGetMinmax) then Exit;
    glGetMinmaxParameterfv := wglGetProcAddress('glGetMinmaxParameterfv');
    if not Assigned(glGetMinmaxParameterfv) then Exit;
    glGetMinmaxParameteriv := wglGetProcAddress('glGetMinmaxParameteriv');
    if not Assigned(glGetMinmaxParameteriv) then Exit;
    glHistogram := wglGetProcAddress('glHistogram');
    if not Assigned(glHistogram) then Exit;
    glMinmax := wglGetProcAddress('glMinmax');
    if not Assigned(glMinmax) then Exit;
    glResetHistogram := wglGetProcAddress('glResetHistogram');
    if not Assigned(glResetHistogram) then Exit;
    glResetMinmax := wglGetProcAddress('glResetMinmax');
    if not Assigned(glResetMinmax) then Exit;
    glTexImage3D := wglGetProcAddress('glTexImage3D');
    if not Assigned(glTexImage3D) then Exit;
    glTexSubImage3D := wglGetProcAddress('glTexSubImage3D');
    if not Assigned(glTexSubImage3D) then Exit;
    glCopyTexSubImage3D := wglGetProcAddress('glCopyTexSubImage3D');
    if not Assigned(glCopyTexSubImage3D) then Exit;
    Result := TRUE;

end;

function Load_GL_ARB_imaging: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_imaging', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_version_1_3: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

    glActiveTexture := wglGetProcAddress('glActiveTexture');
    if not Assigned(glActiveTexture) then Exit;
    glClientActiveTexture := wglGetProcAddress('glClientActiveTexture');
    if not Assigned(glClientActiveTexture) then Exit;
    glMultiTexCoord1d := wglGetProcAddress('glMultiTexCoord1d');
    if not Assigned(glMultiTexCoord1d) then Exit;
    glMultiTexCoord1dv := wglGetProcAddress('glMultiTexCoord1dv');
    if not Assigned(glMultiTexCoord1dv) then Exit;
    glMultiTexCoord1f := wglGetProcAddress('glMultiTexCoord1f');
    if not Assigned(glMultiTexCoord1f) then Exit;
    glMultiTexCoord1fv := wglGetProcAddress('glMultiTexCoord1fv');
    if not Assigned(glMultiTexCoord1fv) then Exit;
    glMultiTexCoord1i := wglGetProcAddress('glMultiTexCoord1i');
    if not Assigned(glMultiTexCoord1i) then Exit;
    glMultiTexCoord1iv := wglGetProcAddress('glMultiTexCoord1iv');
    if not Assigned(glMultiTexCoord1iv) then Exit;
    glMultiTexCoord1s := wglGetProcAddress('glMultiTexCoord1s');
    if not Assigned(glMultiTexCoord1s) then Exit;
    glMultiTexCoord1sv := wglGetProcAddress('glMultiTexCoord1sv');
    if not Assigned(glMultiTexCoord1sv) then Exit;
    glMultiTexCoord2d := wglGetProcAddress('glMultiTexCoord2d');
    if not Assigned(glMultiTexCoord2d) then Exit;
    glMultiTexCoord2dv := wglGetProcAddress('glMultiTexCoord2dv');
    if not Assigned(glMultiTexCoord2dv) then Exit;
    glMultiTexCoord2f := wglGetProcAddress('glMultiTexCoord2f');
    if not Assigned(glMultiTexCoord2f) then Exit;
    glMultiTexCoord2fv := wglGetProcAddress('glMultiTexCoord2fv');
    if not Assigned(glMultiTexCoord2fv) then Exit;
    glMultiTexCoord2i := wglGetProcAddress('glMultiTexCoord2i');
    if not Assigned(glMultiTexCoord2i) then Exit;
    glMultiTexCoord2iv := wglGetProcAddress('glMultiTexCoord2iv');
    if not Assigned(glMultiTexCoord2iv) then Exit;
    glMultiTexCoord2s := wglGetProcAddress('glMultiTexCoord2s');
    if not Assigned(glMultiTexCoord2s) then Exit;
    glMultiTexCoord2sv := wglGetProcAddress('glMultiTexCoord2sv');
    if not Assigned(glMultiTexCoord2sv) then Exit;
    glMultiTexCoord3d := wglGetProcAddress('glMultiTexCoord3d');
    if not Assigned(glMultiTexCoord3d) then Exit;
    glMultiTexCoord3dv := wglGetProcAddress('glMultiTexCoord3dv');
    if not Assigned(glMultiTexCoord3dv) then Exit;
    glMultiTexCoord3f := wglGetProcAddress('glMultiTexCoord3f');
    if not Assigned(glMultiTexCoord3f) then Exit;
    glMultiTexCoord3fv := wglGetProcAddress('glMultiTexCoord3fv');
    if not Assigned(glMultiTexCoord3fv) then Exit;
    glMultiTexCoord3i := wglGetProcAddress('glMultiTexCoord3i');
    if not Assigned(glMultiTexCoord3i) then Exit;
    glMultiTexCoord3iv := wglGetProcAddress('glMultiTexCoord3iv');
    if not Assigned(glMultiTexCoord3iv) then Exit;
    glMultiTexCoord3s := wglGetProcAddress('glMultiTexCoord3s');
    if not Assigned(glMultiTexCoord3s) then Exit;
    glMultiTexCoord3sv := wglGetProcAddress('glMultiTexCoord3sv');
    if not Assigned(glMultiTexCoord3sv) then Exit;
    glMultiTexCoord4d := wglGetProcAddress('glMultiTexCoord4d');
    if not Assigned(glMultiTexCoord4d) then Exit;
    glMultiTexCoord4dv := wglGetProcAddress('glMultiTexCoord4dv');
    if not Assigned(glMultiTexCoord4dv) then Exit;
    glMultiTexCoord4f := wglGetProcAddress('glMultiTexCoord4f');
    if not Assigned(glMultiTexCoord4f) then Exit;
    glMultiTexCoord4fv := wglGetProcAddress('glMultiTexCoord4fv');
    if not Assigned(glMultiTexCoord4fv) then Exit;
    glMultiTexCoord4i := wglGetProcAddress('glMultiTexCoord4i');
    if not Assigned(glMultiTexCoord4i) then Exit;
    glMultiTexCoord4iv := wglGetProcAddress('glMultiTexCoord4iv');
    if not Assigned(glMultiTexCoord4iv) then Exit;
    glMultiTexCoord4s := wglGetProcAddress('glMultiTexCoord4s');
    if not Assigned(glMultiTexCoord4s) then Exit;
    glMultiTexCoord4sv := wglGetProcAddress('glMultiTexCoord4sv');
    if not Assigned(glMultiTexCoord4sv) then Exit;
    glLoadTransposeMatrixf := wglGetProcAddress('glLoadTransposeMatrixf');
    if not Assigned(glLoadTransposeMatrixf) then Exit;
    glLoadTransposeMatrixd := wglGetProcAddress('glLoadTransposeMatrixd');
    if not Assigned(glLoadTransposeMatrixd) then Exit;
    glMultTransposeMatrixf := wglGetProcAddress('glMultTransposeMatrixf');
    if not Assigned(glMultTransposeMatrixf) then Exit;
    glMultTransposeMatrixd := wglGetProcAddress('glMultTransposeMatrixd');
    if not Assigned(glMultTransposeMatrixd) then Exit;
    glSampleCoverage := wglGetProcAddress('glSampleCoverage');
    if not Assigned(glSampleCoverage) then Exit;
    glCompressedTexImage3D := wglGetProcAddress('glCompressedTexImage3D');
    if not Assigned(glCompressedTexImage3D) then Exit;
    glCompressedTexImage2D := wglGetProcAddress('glCompressedTexImage2D');
    if not Assigned(glCompressedTexImage2D) then Exit;
    glCompressedTexImage1D := wglGetProcAddress('glCompressedTexImage1D');
    if not Assigned(glCompressedTexImage1D) then Exit;
    glCompressedTexSubImage3D := wglGetProcAddress('glCompressedTexSubImage3D');
    if not Assigned(glCompressedTexSubImage3D) then Exit;
    glCompressedTexSubImage2D := wglGetProcAddress('glCompressedTexSubImage2D');
    if not Assigned(glCompressedTexSubImage2D) then Exit;
    glCompressedTexSubImage1D := wglGetProcAddress('glCompressedTexSubImage1D');
    if not Assigned(glCompressedTexSubImage1D) then Exit;
    glGetCompressedTexImage := wglGetProcAddress('glGetCompressedTexImage');
    if not Assigned(glGetCompressedTexImage) then Exit;
    Result := TRUE;

end;

function Load_GL_ARB_multitexture: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_multitexture', extstring) then
  begin
    glActiveTextureARB := wglGetProcAddress('glActiveTextureARB');
    if not Assigned(glActiveTextureARB) then Exit;
    glClientActiveTextureARB := wglGetProcAddress('glClientActiveTextureARB');
    if not Assigned(glClientActiveTextureARB) then Exit;
    glMultiTexCoord1dARB := wglGetProcAddress('glMultiTexCoord1dARB');
    if not Assigned(glMultiTexCoord1dARB) then Exit;
    glMultiTexCoord1dvARB := wglGetProcAddress('glMultiTexCoord1dvARB');
    if not Assigned(glMultiTexCoord1dvARB) then Exit;
    glMultiTexCoord1fARB := wglGetProcAddress('glMultiTexCoord1fARB');
    if not Assigned(glMultiTexCoord1fARB) then Exit;
    glMultiTexCoord1fvARB := wglGetProcAddress('glMultiTexCoord1fvARB');
    if not Assigned(glMultiTexCoord1fvARB) then Exit;
    glMultiTexCoord1iARB := wglGetProcAddress('glMultiTexCoord1iARB');
    if not Assigned(glMultiTexCoord1iARB) then Exit;
    glMultiTexCoord1ivARB := wglGetProcAddress('glMultiTexCoord1ivARB');
    if not Assigned(glMultiTexCoord1ivARB) then Exit;
    glMultiTexCoord1sARB := wglGetProcAddress('glMultiTexCoord1sARB');
    if not Assigned(glMultiTexCoord1sARB) then Exit;
    glMultiTexCoord1svARB := wglGetProcAddress('glMultiTexCoord1svARB');
    if not Assigned(glMultiTexCoord1svARB) then Exit;
    glMultiTexCoord2dARB := wglGetProcAddress('glMultiTexCoord2dARB');
    if not Assigned(glMultiTexCoord2dARB) then Exit;
    glMultiTexCoord2dvARB := wglGetProcAddress('glMultiTexCoord2dvARB');
    if not Assigned(glMultiTexCoord2dvARB) then Exit;
    glMultiTexCoord2fARB := wglGetProcAddress('glMultiTexCoord2fARB');
    if not Assigned(glMultiTexCoord2fARB) then Exit;
    glMultiTexCoord2fvARB := wglGetProcAddress('glMultiTexCoord2fvARB');
    if not Assigned(glMultiTexCoord2fvARB) then Exit;
    glMultiTexCoord2iARB := wglGetProcAddress('glMultiTexCoord2iARB');
    if not Assigned(glMultiTexCoord2iARB) then Exit;
    glMultiTexCoord2ivARB := wglGetProcAddress('glMultiTexCoord2ivARB');
    if not Assigned(glMultiTexCoord2ivARB) then Exit;
    glMultiTexCoord2sARB := wglGetProcAddress('glMultiTexCoord2sARB');
    if not Assigned(glMultiTexCoord2sARB) then Exit;
    glMultiTexCoord2svARB := wglGetProcAddress('glMultiTexCoord2svARB');
    if not Assigned(glMultiTexCoord2svARB) then Exit;
    glMultiTexCoord3dARB := wglGetProcAddress('glMultiTexCoord3dARB');
    if not Assigned(glMultiTexCoord3dARB) then Exit;
    glMultiTexCoord3dvARB := wglGetProcAddress('glMultiTexCoord3dvARB');
    if not Assigned(glMultiTexCoord3dvARB) then Exit;
    glMultiTexCoord3fARB := wglGetProcAddress('glMultiTexCoord3fARB');
    if not Assigned(glMultiTexCoord3fARB) then Exit;
    glMultiTexCoord3fvARB := wglGetProcAddress('glMultiTexCoord3fvARB');
    if not Assigned(glMultiTexCoord3fvARB) then Exit;
    glMultiTexCoord3iARB := wglGetProcAddress('glMultiTexCoord3iARB');
    if not Assigned(glMultiTexCoord3iARB) then Exit;
    glMultiTexCoord3ivARB := wglGetProcAddress('glMultiTexCoord3ivARB');
    if not Assigned(glMultiTexCoord3ivARB) then Exit;
    glMultiTexCoord3sARB := wglGetProcAddress('glMultiTexCoord3sARB');
    if not Assigned(glMultiTexCoord3sARB) then Exit;
    glMultiTexCoord3svARB := wglGetProcAddress('glMultiTexCoord3svARB');
    if not Assigned(glMultiTexCoord3svARB) then Exit;
    glMultiTexCoord4dARB := wglGetProcAddress('glMultiTexCoord4dARB');
    if not Assigned(glMultiTexCoord4dARB) then Exit;
    glMultiTexCoord4dvARB := wglGetProcAddress('glMultiTexCoord4dvARB');
    if not Assigned(glMultiTexCoord4dvARB) then Exit;
    glMultiTexCoord4fARB := wglGetProcAddress('glMultiTexCoord4fARB');
    if not Assigned(glMultiTexCoord4fARB) then Exit;
    glMultiTexCoord4fvARB := wglGetProcAddress('glMultiTexCoord4fvARB');
    if not Assigned(glMultiTexCoord4fvARB) then Exit;
    glMultiTexCoord4iARB := wglGetProcAddress('glMultiTexCoord4iARB');
    if not Assigned(glMultiTexCoord4iARB) then Exit;
    glMultiTexCoord4ivARB := wglGetProcAddress('glMultiTexCoord4ivARB');
    if not Assigned(glMultiTexCoord4ivARB) then Exit;
    glMultiTexCoord4sARB := wglGetProcAddress('glMultiTexCoord4sARB');
    if not Assigned(glMultiTexCoord4sARB) then Exit;
    glMultiTexCoord4svARB := wglGetProcAddress('glMultiTexCoord4svARB');
    if not Assigned(glMultiTexCoord4svARB) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_ARB_transpose_matrix: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_transpose_matrix', extstring) then
  begin
    glLoadTransposeMatrixfARB := wglGetProcAddress('glLoadTransposeMatrixfARB');
    if not Assigned(glLoadTransposeMatrixfARB) then Exit;
    glLoadTransposeMatrixdARB := wglGetProcAddress('glLoadTransposeMatrixdARB');
    if not Assigned(glLoadTransposeMatrixdARB) then Exit;
    glMultTransposeMatrixfARB := wglGetProcAddress('glMultTransposeMatrixfARB');
    if not Assigned(glMultTransposeMatrixfARB) then Exit;
    glMultTransposeMatrixdARB := wglGetProcAddress('glMultTransposeMatrixdARB');
    if not Assigned(glMultTransposeMatrixdARB) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_ARB_multisample: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_multisample', extstring) then
  begin
    glSampleCoverageARB := wglGetProcAddress('glSampleCoverageARB');
    if not Assigned(glSampleCoverageARB) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_ARB_texture_env_add: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_texture_env_add', extstring) then
  begin
    Result := TRUE;
  end;

end;

{$IFDEF Win32}
function Load_WGL_ARB_extensions_string: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
  if not Assigned(wglGetExtensionsStringARB) then Exit;
  extstring := String(PChar(wglGetExtensionsStringARB(wglGetCurrentDC)));

  if glext_ExtensionSupported('WGL_ARB_extensions_string', extstring) then
  begin
    wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
    if not Assigned(wglGetExtensionsStringARB) then Exit;
    Result := TRUE;
  end;

end;

function Load_WGL_ARB_buffer_region: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
  if not Assigned(wglGetExtensionsStringARB) then Exit;
  extstring := String(PChar(wglGetExtensionsStringARB(wglGetCurrentDC)));

  if glext_ExtensionSupported('WGL_ARB_buffer_region', extstring) then
  begin
    wglCreateBufferRegionARB := wglGetProcAddress('wglCreateBufferRegionARB');
    if not Assigned(wglCreateBufferRegionARB) then Exit;
    wglDeleteBufferRegionARB := wglGetProcAddress('wglDeleteBufferRegionARB');
    if not Assigned(wglDeleteBufferRegionARB) then Exit;
    wglSaveBufferRegionARB := wglGetProcAddress('wglSaveBufferRegionARB');
    if not Assigned(wglSaveBufferRegionARB) then Exit;
    wglRestoreBufferRegionARB := wglGetProcAddress('wglRestoreBufferRegionARB');
    if not Assigned(wglRestoreBufferRegionARB) then Exit;
    Result := TRUE;
  end;

end;
{$ENDIF}

function Load_GL_ARB_texture_cube_map: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_texture_cube_map', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_ARB_depth_texture: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_depth_texture', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_ARB_point_parameters: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_point_parameters', extstring) then
  begin
    glPointParameterfARB := wglGetProcAddress('glPointParameterfARB');
    if not Assigned(glPointParameterfARB) then Exit;
    glPointParameterfvARB := wglGetProcAddress('glPointParameterfvARB');
    if not Assigned(glPointParameterfvARB) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_ARB_shadow: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_shadow', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_ARB_shadow_ambient: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_shadow_ambient', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_ARB_texture_border_clamp: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_texture_border_clamp', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_ARB_texture_compression: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_texture_compression', extstring) then
  begin
    glCompressedTexImage3DARB := wglGetProcAddress('glCompressedTexImage3DARB');
    if not Assigned(glCompressedTexImage3DARB) then Exit;
    glCompressedTexImage2DARB := wglGetProcAddress('glCompressedTexImage2DARB');
    if not Assigned(glCompressedTexImage2DARB) then Exit;
    glCompressedTexImage1DARB := wglGetProcAddress('glCompressedTexImage1DARB');
    if not Assigned(glCompressedTexImage1DARB) then Exit;
    glCompressedTexSubImage3DARB := wglGetProcAddress('glCompressedTexSubImage3DARB');
    if not Assigned(glCompressedTexSubImage3DARB) then Exit;
    glCompressedTexSubImage2DARB := wglGetProcAddress('glCompressedTexSubImage2DARB');
    if not Assigned(glCompressedTexSubImage2DARB) then Exit;
    glCompressedTexSubImage1DARB := wglGetProcAddress('glCompressedTexSubImage1DARB');
    if not Assigned(glCompressedTexSubImage1DARB) then Exit;
    glGetCompressedTexImageARB := wglGetProcAddress('glGetCompressedTexImageARB');
    if not Assigned(glGetCompressedTexImageARB) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_ARB_texture_env_combine: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_texture_env_combine', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_ARB_texture_env_crossbar: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_texture_env_crossbar', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_ARB_texture_env_dot3: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_texture_env_dot3', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_ARB_texture_mirrored_repeat: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_texture_mirrored_repeat', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_ARB_vertex_blend: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_vertex_blend', extstring) then
  begin
    glWeightbvARB := wglGetProcAddress('glWeightbvARB');
    if not Assigned(glWeightbvARB) then Exit;
    glWeightsvARB := wglGetProcAddress('glWeightsvARB');
    if not Assigned(glWeightsvARB) then Exit;
    glWeightivARB := wglGetProcAddress('glWeightivARB');
    if not Assigned(glWeightivARB) then Exit;
    glWeightfvARB := wglGetProcAddress('glWeightfvARB');
    if not Assigned(glWeightfvARB) then Exit;
    glWeightdvARB := wglGetProcAddress('glWeightdvARB');
    if not Assigned(glWeightdvARB) then Exit;
    glWeightvARB := wglGetProcAddress('glWeightvARB');
    if not Assigned(glWeightvARB) then Exit;
    glWeightubvARB := wglGetProcAddress('glWeightubvARB');
    if not Assigned(glWeightubvARB) then Exit;
    glWeightusvARB := wglGetProcAddress('glWeightusvARB');
    if not Assigned(glWeightusvARB) then Exit;
    glWeightuivARB := wglGetProcAddress('glWeightuivARB');
    if not Assigned(glWeightuivARB) then Exit;
    glWeightPointerARB := wglGetProcAddress('glWeightPointerARB');
    if not Assigned(glWeightPointerARB) then Exit;
    glVertexBlendARB := wglGetProcAddress('glVertexBlendARB');
    if not Assigned(glVertexBlendARB) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_ARB_vertex_program: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_vertex_program', extstring) then
  begin
    glVertexAttrib1sARB := wglGetProcAddress('glVertexAttrib1sARB');
    if not Assigned(glVertexAttrib1sARB) then Exit;
    glVertexAttrib1fARB := wglGetProcAddress('glVertexAttrib1fARB');
    if not Assigned(glVertexAttrib1fARB) then Exit;
    glVertexAttrib1dARB := wglGetProcAddress('glVertexAttrib1dARB');
    if not Assigned(glVertexAttrib1dARB) then Exit;
    glVertexAttrib2sARB := wglGetProcAddress('glVertexAttrib2sARB');
    if not Assigned(glVertexAttrib2sARB) then Exit;
    glVertexAttrib2fARB := wglGetProcAddress('glVertexAttrib2fARB');
    if not Assigned(glVertexAttrib2fARB) then Exit;
    glVertexAttrib2dARB := wglGetProcAddress('glVertexAttrib2dARB');
    if not Assigned(glVertexAttrib2dARB) then Exit;
    glVertexAttrib3sARB := wglGetProcAddress('glVertexAttrib3sARB');
    if not Assigned(glVertexAttrib3sARB) then Exit;
    glVertexAttrib3fARB := wglGetProcAddress('glVertexAttrib3fARB');
    if not Assigned(glVertexAttrib3fARB) then Exit;
    glVertexAttrib3dARB := wglGetProcAddress('glVertexAttrib3dARB');
    if not Assigned(glVertexAttrib3dARB) then Exit;
    glVertexAttrib4sARB := wglGetProcAddress('glVertexAttrib4sARB');
    if not Assigned(glVertexAttrib4sARB) then Exit;
    glVertexAttrib4fARB := wglGetProcAddress('glVertexAttrib4fARB');
    if not Assigned(glVertexAttrib4fARB) then Exit;
    glVertexAttrib4dARB := wglGetProcAddress('glVertexAttrib4dARB');
    if not Assigned(glVertexAttrib4dARB) then Exit;
    glVertexAttrib4NubARB := wglGetProcAddress('glVertexAttrib4NubARB');
    if not Assigned(glVertexAttrib4NubARB) then Exit;
    glVertexAttrib1svARB := wglGetProcAddress('glVertexAttrib1svARB');
    if not Assigned(glVertexAttrib1svARB) then Exit;
    glVertexAttrib1fvARB := wglGetProcAddress('glVertexAttrib1fvARB');
    if not Assigned(glVertexAttrib1fvARB) then Exit;
    glVertexAttrib1dvARB := wglGetProcAddress('glVertexAttrib1dvARB');
    if not Assigned(glVertexAttrib1dvARB) then Exit;
    glVertexAttrib2svARB := wglGetProcAddress('glVertexAttrib2svARB');
    if not Assigned(glVertexAttrib2svARB) then Exit;
    glVertexAttrib2fvARB := wglGetProcAddress('glVertexAttrib2fvARB');
    if not Assigned(glVertexAttrib2fvARB) then Exit;
    glVertexAttrib2dvARB := wglGetProcAddress('glVertexAttrib2dvARB');
    if not Assigned(glVertexAttrib2dvARB) then Exit;
    glVertexAttrib3svARB := wglGetProcAddress('glVertexAttrib3svARB');
    if not Assigned(glVertexAttrib3svARB) then Exit;
    glVertexAttrib3fvARB := wglGetProcAddress('glVertexAttrib3fvARB');
    if not Assigned(glVertexAttrib3fvARB) then Exit;
    glVertexAttrib3dvARB := wglGetProcAddress('glVertexAttrib3dvARB');
    if not Assigned(glVertexAttrib3dvARB) then Exit;
    glVertexAttrib4bvARB := wglGetProcAddress('glVertexAttrib4bvARB');
    if not Assigned(glVertexAttrib4bvARB) then Exit;
    glVertexAttrib4svARB := wglGetProcAddress('glVertexAttrib4svARB');
    if not Assigned(glVertexAttrib4svARB) then Exit;
    glVertexAttrib4ivARB := wglGetProcAddress('glVertexAttrib4ivARB');
    if not Assigned(glVertexAttrib4ivARB) then Exit;
    glVertexAttrib4ubvARB := wglGetProcAddress('glVertexAttrib4ubvARB');
    if not Assigned(glVertexAttrib4ubvARB) then Exit;
    glVertexAttrib4usvARB := wglGetProcAddress('glVertexAttrib4usvARB');
    if not Assigned(glVertexAttrib4usvARB) then Exit;
    glVertexAttrib4uivARB := wglGetProcAddress('glVertexAttrib4uivARB');
    if not Assigned(glVertexAttrib4uivARB) then Exit;
    glVertexAttrib4fvARB := wglGetProcAddress('glVertexAttrib4fvARB');
    if not Assigned(glVertexAttrib4fvARB) then Exit;
    glVertexAttrib4dvARB := wglGetProcAddress('glVertexAttrib4dvARB');
    if not Assigned(glVertexAttrib4dvARB) then Exit;
    glVertexAttrib4NbvARB := wglGetProcAddress('glVertexAttrib4NbvARB');
    if not Assigned(glVertexAttrib4NbvARB) then Exit;
    glVertexAttrib4NsvARB := wglGetProcAddress('glVertexAttrib4NsvARB');
    if not Assigned(glVertexAttrib4NsvARB) then Exit;
    glVertexAttrib4NivARB := wglGetProcAddress('glVertexAttrib4NivARB');
    if not Assigned(glVertexAttrib4NivARB) then Exit;
    glVertexAttrib4NubvARB := wglGetProcAddress('glVertexAttrib4NubvARB');
    if not Assigned(glVertexAttrib4NubvARB) then Exit;
    glVertexAttrib4NusvARB := wglGetProcAddress('glVertexAttrib4NusvARB');
    if not Assigned(glVertexAttrib4NusvARB) then Exit;
    glVertexAttrib4NuivARB := wglGetProcAddress('glVertexAttrib4NuivARB');
    if not Assigned(glVertexAttrib4NuivARB) then Exit;
    glVertexAttribPointerARB := wglGetProcAddress('glVertexAttribPointerARB');
    if not Assigned(glVertexAttribPointerARB) then Exit;
    glEnableVertexAttribArrayARB := wglGetProcAddress('glEnableVertexAttribArrayARB');
    if not Assigned(glEnableVertexAttribArrayARB) then Exit;
    glDisableVertexAttribArrayARB := wglGetProcAddress('glDisableVertexAttribArrayARB');
    if not Assigned(glDisableVertexAttribArrayARB) then Exit;
    glProgramStringARB := wglGetProcAddress('glProgramStringARB');
    if not Assigned(glProgramStringARB) then Exit;
    glBindProgramARB := wglGetProcAddress('glBindProgramARB');
    if not Assigned(glBindProgramARB) then Exit;
    glDeleteProgramsARB := wglGetProcAddress('glDeleteProgramsARB');
    if not Assigned(glDeleteProgramsARB) then Exit;
    glGenProgramsARB := wglGetProcAddress('glGenProgramsARB');
    if not Assigned(glGenProgramsARB) then Exit;
    glProgramEnvParameter4dARB := wglGetProcAddress('glProgramEnvParameter4dARB');
    if not Assigned(glProgramEnvParameter4dARB) then Exit;
    glProgramEnvParameter4dvARB := wglGetProcAddress('glProgramEnvParameter4dvARB');
    if not Assigned(glProgramEnvParameter4dvARB) then Exit;
    glProgramEnvParameter4fARB := wglGetProcAddress('glProgramEnvParameter4fARB');
    if not Assigned(glProgramEnvParameter4fARB) then Exit;
    glProgramEnvParameter4fvARB := wglGetProcAddress('glProgramEnvParameter4fvARB');
    if not Assigned(glProgramEnvParameter4fvARB) then Exit;
    glProgramLocalParameter4dARB := wglGetProcAddress('glProgramLocalParameter4dARB');
    if not Assigned(glProgramLocalParameter4dARB) then Exit;
    glProgramLocalParameter4dvARB := wglGetProcAddress('glProgramLocalParameter4dvARB');
    if not Assigned(glProgramLocalParameter4dvARB) then Exit;
    glProgramLocalParameter4fARB := wglGetProcAddress('glProgramLocalParameter4fARB');
    if not Assigned(glProgramLocalParameter4fARB) then Exit;
    glProgramLocalParameter4fvARB := wglGetProcAddress('glProgramLocalParameter4fvARB');
    if not Assigned(glProgramLocalParameter4fvARB) then Exit;
    glGetProgramEnvParameterdvARB := wglGetProcAddress('glGetProgramEnvParameterdvARB');
    if not Assigned(glGetProgramEnvParameterdvARB) then Exit;
    glGetProgramEnvParameterfvARB := wglGetProcAddress('glGetProgramEnvParameterfvARB');
    if not Assigned(glGetProgramEnvParameterfvARB) then Exit;
    glGetProgramLocalParameterdvARB := wglGetProcAddress('glGetProgramLocalParameterdvARB');
    if not Assigned(glGetProgramLocalParameterdvARB) then Exit;
    glGetProgramLocalParameterfvARB := wglGetProcAddress('glGetProgramLocalParameterfvARB');
    if not Assigned(glGetProgramLocalParameterfvARB) then Exit;
    glGetProgramivARB := wglGetProcAddress('glGetProgramivARB');
    if not Assigned(glGetProgramivARB) then Exit;
    glGetProgramStringARB := wglGetProcAddress('glGetProgramStringARB');
    if not Assigned(glGetProgramStringARB) then Exit;
    glGetVertexAttribdvARB := wglGetProcAddress('glGetVertexAttribdvARB');
    if not Assigned(glGetVertexAttribdvARB) then Exit;
    glGetVertexAttribfvARB := wglGetProcAddress('glGetVertexAttribfvARB');
    if not Assigned(glGetVertexAttribfvARB) then Exit;
    glGetVertexAttribivARB := wglGetProcAddress('glGetVertexAttribivARB');
    if not Assigned(glGetVertexAttribivARB) then Exit;
    glGetVertexAttribPointervARB := wglGetProcAddress('glGetVertexAttribPointervARB');
    if not Assigned(glGetVertexAttribPointervARB) then Exit;
    glIsProgramARB := wglGetProcAddress('glIsProgramARB');
    if not Assigned(glIsProgramARB) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_ARB_window_pos: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_window_pos', extstring) then
  begin
    glWindowPos2dARB := wglGetProcAddress('glWindowPos2dARB');
    if not Assigned(glWindowPos2dARB) then Exit;
    glWindowPos2fARB := wglGetProcAddress('glWindowPos2fARB');
    if not Assigned(glWindowPos2fARB) then Exit;
    glWindowPos2iARB := wglGetProcAddress('glWindowPos2iARB');
    if not Assigned(glWindowPos2iARB) then Exit;
    glWindowPos2sARB := wglGetProcAddress('glWindowPos2sARB');
    if not Assigned(glWindowPos2sARB) then Exit;
    glWindowPos2dvARB := wglGetProcAddress('glWindowPos2dvARB');
    if not Assigned(glWindowPos2dvARB) then Exit;
    glWindowPos2fvARB := wglGetProcAddress('glWindowPos2fvARB');
    if not Assigned(glWindowPos2fvARB) then Exit;
    glWindowPos2ivARB := wglGetProcAddress('glWindowPos2ivARB');
    if not Assigned(glWindowPos2ivARB) then Exit;
    glWindowPos2svARB := wglGetProcAddress('glWindowPos2svARB');
    if not Assigned(glWindowPos2svARB) then Exit;
    glWindowPos3dARB := wglGetProcAddress('glWindowPos3dARB');
    if not Assigned(glWindowPos3dARB) then Exit;
    glWindowPos3fARB := wglGetProcAddress('glWindowPos3fARB');
    if not Assigned(glWindowPos3fARB) then Exit;
    glWindowPos3iARB := wglGetProcAddress('glWindowPos3iARB');
    if not Assigned(glWindowPos3iARB) then Exit;
    glWindowPos3sARB := wglGetProcAddress('glWindowPos3sARB');
    if not Assigned(glWindowPos3sARB) then Exit;
    glWindowPos3dvARB := wglGetProcAddress('glWindowPos3dvARB');
    if not Assigned(glWindowPos3dvARB) then Exit;
    glWindowPos3fvARB := wglGetProcAddress('glWindowPos3fvARB');
    if not Assigned(glWindowPos3fvARB) then Exit;
    glWindowPos3ivARB := wglGetProcAddress('glWindowPos3ivARB');
    if not Assigned(glWindowPos3ivARB) then Exit;
    glWindowPos3svARB := wglGetProcAddress('glWindowPos3svARB');
    if not Assigned(glWindowPos3svARB) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_422_pixels: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_422_pixels', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_EXT_abgr: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_abgr', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_EXT_bgra: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_bgra', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_EXT_blend_color: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_blend_color', extstring) then
  begin
    glBlendColorEXT := wglGetProcAddress('glBlendColorEXT');
    if not Assigned(glBlendColorEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_blend_func_separate: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_blend_func_separate', extstring) then
  begin
    glBlendFuncSeparateEXT := wglGetProcAddress('glBlendFuncSeparateEXT');
    if not Assigned(glBlendFuncSeparateEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_blend_logic_op: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_blend_logic_op', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_EXT_blend_minmax: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_blend_minmax', extstring) then
  begin
    glBlendEquationEXT := wglGetProcAddress('glBlendEquationEXT');
    if not Assigned(glBlendEquationEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_blend_subtract: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_blend_subtract', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_EXT_clip_volume_hint: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_clip_volume_hint', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_EXT_color_subtable: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_color_subtable', extstring) then
  begin
    glColorSubTableEXT := wglGetProcAddress('glColorSubTableEXT');
    if not Assigned(glColorSubTableEXT) then Exit;
    glCopyColorSubTableEXT := wglGetProcAddress('glCopyColorSubTableEXT');
    if not Assigned(glCopyColorSubTableEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_compiled_vertex_array: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_compiled_vertex_array', extstring) then
  begin
    glLockArraysEXT := wglGetProcAddress('glLockArraysEXT');
    if not Assigned(glLockArraysEXT) then Exit;
    glUnlockArraysEXT := wglGetProcAddress('glUnlockArraysEXT');
    if not Assigned(glUnlockArraysEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_convolution: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_convolution', extstring) then
  begin
    glConvolutionFilter1DEXT := wglGetProcAddress('glConvolutionFilter1DEXT');
    if not Assigned(glConvolutionFilter1DEXT) then Exit;
    glConvolutionFilter2DEXT := wglGetProcAddress('glConvolutionFilter2DEXT');
    if not Assigned(glConvolutionFilter2DEXT) then Exit;
    glCopyConvolutionFilter1DEXT := wglGetProcAddress('glCopyConvolutionFilter1DEXT');
    if not Assigned(glCopyConvolutionFilter1DEXT) then Exit;
    glCopyConvolutionFilter2DEXT := wglGetProcAddress('glCopyConvolutionFilter2DEXT');
    if not Assigned(glCopyConvolutionFilter2DEXT) then Exit;
    glGetConvolutionFilterEXT := wglGetProcAddress('glGetConvolutionFilterEXT');
    if not Assigned(glGetConvolutionFilterEXT) then Exit;
    glSeparableFilter2DEXT := wglGetProcAddress('glSeparableFilter2DEXT');
    if not Assigned(glSeparableFilter2DEXT) then Exit;
    glGetSeparableFilterEXT := wglGetProcAddress('glGetSeparableFilterEXT');
    if not Assigned(glGetSeparableFilterEXT) then Exit;
    glConvolutionParameteriEXT := wglGetProcAddress('glConvolutionParameteriEXT');
    if not Assigned(glConvolutionParameteriEXT) then Exit;
    glConvolutionParameterivEXT := wglGetProcAddress('glConvolutionParameterivEXT');
    if not Assigned(glConvolutionParameterivEXT) then Exit;
    glConvolutionParameterfEXT := wglGetProcAddress('glConvolutionParameterfEXT');
    if not Assigned(glConvolutionParameterfEXT) then Exit;
    glConvolutionParameterfvEXT := wglGetProcAddress('glConvolutionParameterfvEXT');
    if not Assigned(glConvolutionParameterfvEXT) then Exit;
    glGetConvolutionParameterivEXT := wglGetProcAddress('glGetConvolutionParameterivEXT');
    if not Assigned(glGetConvolutionParameterivEXT) then Exit;
    glGetConvolutionParameterfvEXT := wglGetProcAddress('glGetConvolutionParameterfvEXT');
    if not Assigned(glGetConvolutionParameterfvEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_fog_coord: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_fog_coord', extstring) then
  begin
    glFogCoordfEXfloat := wglGetProcAddress('glFogCoordfEXfloat');
    if not Assigned(glFogCoordfEXfloat) then Exit;
    glFogCoorddEXdouble := wglGetProcAddress('glFogCoorddEXdouble');
    if not Assigned(glFogCoorddEXdouble) then Exit;
    glFogCoordfvEXfloat := wglGetProcAddress('glFogCoordfvEXfloat');
    if not Assigned(glFogCoordfvEXfloat) then Exit;
    glFogCoorddvEXdouble := wglGetProcAddress('glFogCoorddvEXdouble');
    if not Assigned(glFogCoorddvEXdouble) then Exit;
    glFogCoordPointerEXT := wglGetProcAddress('glFogCoordPointerEXT');
    if not Assigned(glFogCoordPointerEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_histogram: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_histogram', extstring) then
  begin
    glHistogramEXT := wglGetProcAddress('glHistogramEXT');
    if not Assigned(glHistogramEXT) then Exit;
    glResetHistogramEXT := wglGetProcAddress('glResetHistogramEXT');
    if not Assigned(glResetHistogramEXT) then Exit;
    glGetHistogramEXT := wglGetProcAddress('glGetHistogramEXT');
    if not Assigned(glGetHistogramEXT) then Exit;
    glGetHistogramParameterivEXT := wglGetProcAddress('glGetHistogramParameterivEXT');
    if not Assigned(glGetHistogramParameterivEXT) then Exit;
    glGetHistogramParameterfvEXT := wglGetProcAddress('glGetHistogramParameterfvEXT');
    if not Assigned(glGetHistogramParameterfvEXT) then Exit;
    glMinmaxEXT := wglGetProcAddress('glMinmaxEXT');
    if not Assigned(glMinmaxEXT) then Exit;
    glResetMinmaxEXT := wglGetProcAddress('glResetMinmaxEXT');
    if not Assigned(glResetMinmaxEXT) then Exit;
    glGetMinmaxEXT := wglGetProcAddress('glGetMinmaxEXT');
    if not Assigned(glGetMinmaxEXT) then Exit;
    glGetMinmaxParameterivEXT := wglGetProcAddress('glGetMinmaxParameterivEXT');
    if not Assigned(glGetMinmaxParameterivEXT) then Exit;
    glGetMinmaxParameterfvEXT := wglGetProcAddress('glGetMinmaxParameterfvEXT');
    if not Assigned(glGetMinmaxParameterfvEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_multi_draw_arrays: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_multi_draw_arrays', extstring) then
  begin
    glMultiDrawArraysEXT := wglGetProcAddress('glMultiDrawArraysEXT');
    if not Assigned(glMultiDrawArraysEXT) then Exit;
    glMultiDrawElementsEXT := wglGetProcAddress('glMultiDrawElementsEXT');
    if not Assigned(glMultiDrawElementsEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_packed_pixels: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_packed_pixels', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_EXT_paletted_texture: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_paletted_texture', extstring) then
  begin
    glColorTableEXT := wglGetProcAddress('glColorTableEXT');
    if not Assigned(glColorTableEXT) then Exit;
    glColorSubTableEXT := wglGetProcAddress('glColorSubTableEXT');
    if not Assigned(glColorSubTableEXT) then Exit;
    glGetColorTableEXT := wglGetProcAddress('glGetColorTableEXT');
    if not Assigned(glGetColorTableEXT) then Exit;
    glGetColorTableParameterivEXT := wglGetProcAddress('glGetColorTableParameterivEXT');
    if not Assigned(glGetColorTableParameterivEXT) then Exit;
    glGetColorTableParameterfvEXT := wglGetProcAddress('glGetColorTableParameterfvEXT');
    if not Assigned(glGetColorTableParameterfvEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_point_parameters: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_point_parameters', extstring) then
  begin
    glPointParameterfEXT := wglGetProcAddress('glPointParameterfEXT');
    if not Assigned(glPointParameterfEXT) then Exit;
    glPointParameterfvEXT := wglGetProcAddress('glPointParameterfvEXT');
    if not Assigned(glPointParameterfvEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_polygon_offset: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_polygon_offset', extstring) then
  begin
    glPolygonOffsetEXT := wglGetProcAddress('glPolygonOffsetEXT');
    if not Assigned(glPolygonOffsetEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_secondary_color: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_secondary_color', extstring) then
  begin
    glSecondaryColor3bEXT := wglGetProcAddress('glSecondaryColor3bEXT');
    if not Assigned(glSecondaryColor3bEXT) then Exit;
    glSecondaryColor3sEXT := wglGetProcAddress('glSecondaryColor3sEXT');
    if not Assigned(glSecondaryColor3sEXT) then Exit;
    glSecondaryColor3iEXT := wglGetProcAddress('glSecondaryColor3iEXT');
    if not Assigned(glSecondaryColor3iEXT) then Exit;
    glSecondaryColor3fEXT := wglGetProcAddress('glSecondaryColor3fEXT');
    if not Assigned(glSecondaryColor3fEXT) then Exit;
    glSecondaryColor3dEXT := wglGetProcAddress('glSecondaryColor3dEXT');
    if not Assigned(glSecondaryColor3dEXT) then Exit;
    glSecondaryColor3ubEXT := wglGetProcAddress('glSecondaryColor3ubEXT');
    if not Assigned(glSecondaryColor3ubEXT) then Exit;
    glSecondaryColor3usEXT := wglGetProcAddress('glSecondaryColor3usEXT');
    if not Assigned(glSecondaryColor3usEXT) then Exit;
    glSecondaryColor3uiEXT := wglGetProcAddress('glSecondaryColor3uiEXT');
    if not Assigned(glSecondaryColor3uiEXT) then Exit;
    glSecondaryColor3bvEXT := wglGetProcAddress('glSecondaryColor3bvEXT');
    if not Assigned(glSecondaryColor3bvEXT) then Exit;
    glSecondaryColor3svEXT := wglGetProcAddress('glSecondaryColor3svEXT');
    if not Assigned(glSecondaryColor3svEXT) then Exit;
    glSecondaryColor3ivEXT := wglGetProcAddress('glSecondaryColor3ivEXT');
    if not Assigned(glSecondaryColor3ivEXT) then Exit;
    glSecondaryColor3fvEXT := wglGetProcAddress('glSecondaryColor3fvEXT');
    if not Assigned(glSecondaryColor3fvEXT) then Exit;
    glSecondaryColor3dvEXT := wglGetProcAddress('glSecondaryColor3dvEXT');
    if not Assigned(glSecondaryColor3dvEXT) then Exit;
    glSecondaryColor3ubvEXT := wglGetProcAddress('glSecondaryColor3ubvEXT');
    if not Assigned(glSecondaryColor3ubvEXT) then Exit;
    glSecondaryColor3usvEXT := wglGetProcAddress('glSecondaryColor3usvEXT');
    if not Assigned(glSecondaryColor3usvEXT) then Exit;
    glSecondaryColor3uivEXT := wglGetProcAddress('glSecondaryColor3uivEXT');
    if not Assigned(glSecondaryColor3uivEXT) then Exit;
    glSecondaryColorPointerEXT := wglGetProcAddress('glSecondaryColorPointerEXT');
    if not Assigned(glSecondaryColorPointerEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_separate_specular_color: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_separate_specular_color', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_EXT_shadow_funcs: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_shadow_funcs', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_EXT_shared_texture_palette: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_shared_texture_palette', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_EXT_stencil_two_side: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_stencil_two_side', extstring) then
  begin
    glActiveStencilFaceEXT := wglGetProcAddress('glActiveStencilFaceEXT');
    if not Assigned(glActiveStencilFaceEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_stencil_wrap: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_stencil_wrap', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_EXT_subtexture: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_subtexture', extstring) then
  begin
    glTexSubImage1DEXT := wglGetProcAddress('glTexSubImage1DEXT');
    if not Assigned(glTexSubImage1DEXT) then Exit;
    glTexSubImage2DEXT := wglGetProcAddress('glTexSubImage2DEXT');
    if not Assigned(glTexSubImage2DEXT) then Exit;
    glTexSubImage3DEXT := wglGetProcAddress('glTexSubImage3DEXT');
    if not Assigned(glTexSubImage3DEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_texture3D: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_texture3D', extstring) then
  begin
    glTexImage3DEXT := wglGetProcAddress('glTexImage3DEXT');
    if not Assigned(glTexImage3DEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_texture_compression_s3tc: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_texture_compression_s3tc', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_EXT_texture_env_add: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_texture_env_add', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_EXT_texture_env_combine: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_texture_env_combine', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_EXT_texture_env_dot3: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_texture_env_dot3', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_EXT_texture_filter_anisotropic: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_texture_filter_anisotropic', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_EXT_texture_lod_bias: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_texture_lod_bias', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_EXT_texture_object: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_texture_object', extstring) then
  begin
    glGenTexturesEXT := wglGetProcAddress('glGenTexturesEXT');
    if not Assigned(glGenTexturesEXT) then Exit;
    glDeleteTexturesEXT := wglGetProcAddress('glDeleteTexturesEXT');
    if not Assigned(glDeleteTexturesEXT) then Exit;
    glBindTextureEXT := wglGetProcAddress('glBindTextureEXT');
    if not Assigned(glBindTextureEXT) then Exit;
    glPrioritizeTexturesEXT := wglGetProcAddress('glPrioritizeTexturesEXT');
    if not Assigned(glPrioritizeTexturesEXT) then Exit;
    glAreTexturesResidentEXT := wglGetProcAddress('glAreTexturesResidentEXT');
    if not Assigned(glAreTexturesResidentEXT) then Exit;
    glIsTextureEXT := wglGetProcAddress('glIsTextureEXT');
    if not Assigned(glIsTextureEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_vertex_array: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_vertex_array', extstring) then
  begin
    glArrayElementEXT := wglGetProcAddress('glArrayElementEXT');
    if not Assigned(glArrayElementEXT) then Exit;
    glDrawArraysEXT := wglGetProcAddress('glDrawArraysEXT');
    if not Assigned(glDrawArraysEXT) then Exit;
    glVertexPointerEXT := wglGetProcAddress('glVertexPointerEXT');
    if not Assigned(glVertexPointerEXT) then Exit;
    glNormalPointerEXT := wglGetProcAddress('glNormalPointerEXT');
    if not Assigned(glNormalPointerEXT) then Exit;
    glColorPointerEXT := wglGetProcAddress('glColorPointerEXT');
    if not Assigned(glColorPointerEXT) then Exit;
    glIndexPointerEXT := wglGetProcAddress('glIndexPointerEXT');
    if not Assigned(glIndexPointerEXT) then Exit;
    glTexCoordPointerEXT := wglGetProcAddress('glTexCoordPointerEXT');
    if not Assigned(glTexCoordPointerEXT) then Exit;
    glEdgeFlagPointerEXT := wglGetProcAddress('glEdgeFlagPointerEXT');
    if not Assigned(glEdgeFlagPointerEXT) then Exit;
    glGetPointervEXT := wglGetProcAddress('glGetPointervEXT');
    if not Assigned(glGetPointervEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_vertex_shader: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_vertex_shader', extstring) then
  begin
    glBeginVertexShaderEXT := wglGetProcAddress('glBeginVertexShaderEXT');
    if not Assigned(glBeginVertexShaderEXT) then Exit;
    glEndVertexShaderEXT := wglGetProcAddress('glEndVertexShaderEXT');
    if not Assigned(glEndVertexShaderEXT) then Exit;
    glBindVertexShaderEXT := wglGetProcAddress('glBindVertexShaderEXT');
    if not Assigned(glBindVertexShaderEXT) then Exit;
    glGenVertexShadersEXT := wglGetProcAddress('glGenVertexShadersEXT');
    if not Assigned(glGenVertexShadersEXT) then Exit;
    glDeleteVertexShaderEXT := wglGetProcAddress('glDeleteVertexShaderEXT');
    if not Assigned(glDeleteVertexShaderEXT) then Exit;
    glShaderOp1EXT := wglGetProcAddress('glShaderOp1EXT');
    if not Assigned(glShaderOp1EXT) then Exit;
    glShaderOp2EXT := wglGetProcAddress('glShaderOp2EXT');
    if not Assigned(glShaderOp2EXT) then Exit;
    glShaderOp3EXT := wglGetProcAddress('glShaderOp3EXT');
    if not Assigned(glShaderOp3EXT) then Exit;
    glSwizzleEXT := wglGetProcAddress('glSwizzleEXT');
    if not Assigned(glSwizzleEXT) then Exit;
    glWriteMaskEXT := wglGetProcAddress('glWriteMaskEXT');
    if not Assigned(glWriteMaskEXT) then Exit;
    glInsertComponentEXT := wglGetProcAddress('glInsertComponentEXT');
    if not Assigned(glInsertComponentEXT) then Exit;
    glExtractComponentEXT := wglGetProcAddress('glExtractComponentEXT');
    if not Assigned(glExtractComponentEXT) then Exit;
    glGenSymbolsEXT := wglGetProcAddress('glGenSymbolsEXT');
    if not Assigned(glGenSymbolsEXT) then Exit;
    glSetInvariantEXT := wglGetProcAddress('glSetInvariantEXT');
    if not Assigned(glSetInvariantEXT) then Exit;
    glSetLocalConstantEXT := wglGetProcAddress('glSetLocalConstantEXT');
    if not Assigned(glSetLocalConstantEXT) then Exit;
    glVariantbvEXT := wglGetProcAddress('glVariantbvEXT');
    if not Assigned(glVariantbvEXT) then Exit;
    glVariantsvEXT := wglGetProcAddress('glVariantsvEXT');
    if not Assigned(glVariantsvEXT) then Exit;
    glVariantivEXT := wglGetProcAddress('glVariantivEXT');
    if not Assigned(glVariantivEXT) then Exit;
    glVariantfvEXT := wglGetProcAddress('glVariantfvEXT');
    if not Assigned(glVariantfvEXT) then Exit;
    glVariantdvEXT := wglGetProcAddress('glVariantdvEXT');
    if not Assigned(glVariantdvEXT) then Exit;
    glVariantubvEXT := wglGetProcAddress('glVariantubvEXT');
    if not Assigned(glVariantubvEXT) then Exit;
    glVariantusvEXT := wglGetProcAddress('glVariantusvEXT');
    if not Assigned(glVariantusvEXT) then Exit;
    glVariantuivEXT := wglGetProcAddress('glVariantuivEXT');
    if not Assigned(glVariantuivEXT) then Exit;
    glVariantPointerEXT := wglGetProcAddress('glVariantPointerEXT');
    if not Assigned(glVariantPointerEXT) then Exit;
    glEnableVariantClientStateEXT := wglGetProcAddress('glEnableVariantClientStateEXT');
    if not Assigned(glEnableVariantClientStateEXT) then Exit;
    glDisableVariantClientStateEXT := wglGetProcAddress('glDisableVariantClientStateEXT');
    if not Assigned(glDisableVariantClientStateEXT) then Exit;
    glBindLightParameterEXT := wglGetProcAddress('glBindLightParameterEXT');
    if not Assigned(glBindLightParameterEXT) then Exit;
    glBindMaterialParameterEXT := wglGetProcAddress('glBindMaterialParameterEXT');
    if not Assigned(glBindMaterialParameterEXT) then Exit;
    glBindTexGenParameterEXT := wglGetProcAddress('glBindTexGenParameterEXT');
    if not Assigned(glBindTexGenParameterEXT) then Exit;
    glBindTextureUnitParameterEXT := wglGetProcAddress('glBindTextureUnitParameterEXT');
    if not Assigned(glBindTextureUnitParameterEXT) then Exit;
    glBindParameterEXT := wglGetProcAddress('glBindParameterEXT');
    if not Assigned(glBindParameterEXT) then Exit;
    glIsVariantEnabledEXT := wglGetProcAddress('glIsVariantEnabledEXT');
    if not Assigned(glIsVariantEnabledEXT) then Exit;
    glGetVariantBooleanvEXT := wglGetProcAddress('glGetVariantBooleanvEXT');
    if not Assigned(glGetVariantBooleanvEXT) then Exit;
    glGetVariantIntegervEXT := wglGetProcAddress('glGetVariantIntegervEXT');
    if not Assigned(glGetVariantIntegervEXT) then Exit;
    glGetVariantFloatvEXT := wglGetProcAddress('glGetVariantFloatvEXT');
    if not Assigned(glGetVariantFloatvEXT) then Exit;
    glGetVariantPointervEXT := wglGetProcAddress('glGetVariantPointervEXT');
    if not Assigned(glGetVariantPointervEXT) then Exit;
    glGetInvariantBooleanvEXT := wglGetProcAddress('glGetInvariantBooleanvEXT');
    if not Assigned(glGetInvariantBooleanvEXT) then Exit;
    glGetInvariantIntegervEXT := wglGetProcAddress('glGetInvariantIntegervEXT');
    if not Assigned(glGetInvariantIntegervEXT) then Exit;
    glGetInvariantFloatvEXT := wglGetProcAddress('glGetInvariantFloatvEXT');
    if not Assigned(glGetInvariantFloatvEXT) then Exit;
    glGetLocalConstantBooleanvEXT := wglGetProcAddress('glGetLocalConstantBooleanvEXT');
    if not Assigned(glGetLocalConstantBooleanvEXT) then Exit;
    glGetLocalConstantIntegervEXT := wglGetProcAddress('glGetLocalConstantIntegervEXT');
    if not Assigned(glGetLocalConstantIntegervEXT) then Exit;
    glGetLocalConstantFloatvEXT := wglGetProcAddress('glGetLocalConstantFloatvEXT');
    if not Assigned(glGetLocalConstantFloatvEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_EXT_vertex_weighting: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_EXT_vertex_weighting', extstring) then
  begin
    glVertexWeightfEXT := wglGetProcAddress('glVertexWeightfEXT');
    if not Assigned(glVertexWeightfEXT) then Exit;
    glVertexWeightfvEXT := wglGetProcAddress('glVertexWeightfvEXT');
    if not Assigned(glVertexWeightfvEXT) then Exit;
    glVertexWeightPointerEXT := wglGetProcAddress('glVertexWeightPointerEXT');
    if not Assigned(glVertexWeightPointerEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_HP_occlusion_test: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_HP_occlusion_test', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_NV_blend_square: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_blend_square', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_NV_copy_depth_to_color: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_copy_depth_to_color', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_NV_depth_clamp: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_depth_clamp', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_NV_evaluators: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_evaluators', extstring) then
  begin
    glMapControlPointsNV := wglGetProcAddress('glMapControlPointsNV');
    if not Assigned(glMapControlPointsNV) then Exit;
    glMapParameterivNV := wglGetProcAddress('glMapParameterivNV');
    if not Assigned(glMapParameterivNV) then Exit;
    glMapParameterfvNV := wglGetProcAddress('glMapParameterfvNV');
    if not Assigned(glMapParameterfvNV) then Exit;
    glGetMapControlPointsNV := wglGetProcAddress('glGetMapControlPointsNV');
    if not Assigned(glGetMapControlPointsNV) then Exit;
    glGetMapParameterivNV := wglGetProcAddress('glGetMapParameterivNV');
    if not Assigned(glGetMapParameterivNV) then Exit;
    glGetMapParameterfvNV := wglGetProcAddress('glGetMapParameterfvNV');
    if not Assigned(glGetMapParameterfvNV) then Exit;
    glGetMapAttribParameterivNV := wglGetProcAddress('glGetMapAttribParameterivNV');
    if not Assigned(glGetMapAttribParameterivNV) then Exit;
    glGetMapAttribParameterfvNV := wglGetProcAddress('glGetMapAttribParameterfvNV');
    if not Assigned(glGetMapAttribParameterfvNV) then Exit;
    glEvalMapsNV := wglGetProcAddress('glEvalMapsNV');
    if not Assigned(glEvalMapsNV) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_NV_fence: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_fence', extstring) then
  begin
    glGenFencesNV := wglGetProcAddress('glGenFencesNV');
    if not Assigned(glGenFencesNV) then Exit;
    glDeleteFencesNV := wglGetProcAddress('glDeleteFencesNV');
    if not Assigned(glDeleteFencesNV) then Exit;
    glSetFenceNV := wglGetProcAddress('glSetFenceNV');
    if not Assigned(glSetFenceNV) then Exit;
    glTestFenceNV := wglGetProcAddress('glTestFenceNV');
    if not Assigned(glTestFenceNV) then Exit;
    glFinishFenceNV := wglGetProcAddress('glFinishFenceNV');
    if not Assigned(glFinishFenceNV) then Exit;
    glIsFenceNV := wglGetProcAddress('glIsFenceNV');
    if not Assigned(glIsFenceNV) then Exit;
    glGetFenceivNV := wglGetProcAddress('glGetFenceivNV');
    if not Assigned(glGetFenceivNV) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_NV_fog_distance: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_fog_distance', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_NV_light_max_exponent: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_light_max_exponent', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_NV_multisample_filter_hint: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_multisample_filter_hint', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_NV_occlusion_query: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_occlusion_query', extstring) then
  begin
    glGenOcclusionQueriesNV := wglGetProcAddress('glGenOcclusionQueriesNV');
    if not Assigned(glGenOcclusionQueriesNV) then Exit;
    glDeleteOcclusionQueriesNV := wglGetProcAddress('glDeleteOcclusionQueriesNV');
    if not Assigned(glDeleteOcclusionQueriesNV) then Exit;
    glIsOcclusionQueryNV := wglGetProcAddress('glIsOcclusionQueryNV');
    if not Assigned(glIsOcclusionQueryNV) then Exit;
    glBeginOcclusionQueryNV := wglGetProcAddress('glBeginOcclusionQueryNV');
    if not Assigned(glBeginOcclusionQueryNV) then Exit;
    glEndOcclusionQueryNV := wglGetProcAddress('glEndOcclusionQueryNV');
    if not Assigned(glEndOcclusionQueryNV) then Exit;
    glGetOcclusionQueryivNV := wglGetProcAddress('glGetOcclusionQueryivNV');
    if not Assigned(glGetOcclusionQueryivNV) then Exit;
    glGetOcclusionQueryuivNV := wglGetProcAddress('glGetOcclusionQueryuivNV');
    if not Assigned(glGetOcclusionQueryuivNV) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_NV_packed_depth_stencil: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_packed_depth_stencil', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_NV_point_sprite: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_point_sprite', extstring) then
  begin
    glPointParameteriNV := wglGetProcAddress('glPointParameteriNV');
    if not Assigned(glPointParameteriNV) then Exit;
    glPointParameterivNV := wglGetProcAddress('glPointParameterivNV');
    if not Assigned(glPointParameterivNV) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_NV_register_combiners: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_register_combiners', extstring) then
  begin
    glCombinerParameterfvNV := wglGetProcAddress('glCombinerParameterfvNV');
    if not Assigned(glCombinerParameterfvNV) then Exit;
    glCombinerParameterivNV := wglGetProcAddress('glCombinerParameterivNV');
    if not Assigned(glCombinerParameterivNV) then Exit;
    glCombinerParameterfNV := wglGetProcAddress('glCombinerParameterfNV');
    if not Assigned(glCombinerParameterfNV) then Exit;
    glCombinerParameteriNV := wglGetProcAddress('glCombinerParameteriNV');
    if not Assigned(glCombinerParameteriNV) then Exit;
    glCombinerInputNV := wglGetProcAddress('glCombinerInputNV');
    if not Assigned(glCombinerInputNV) then Exit;
    glCombinerOutputNV := wglGetProcAddress('glCombinerOutputNV');
    if not Assigned(glCombinerOutputNV) then Exit;
    glFinalCombinerInputNV := wglGetProcAddress('glFinalCombinerInputNV');
    if not Assigned(glFinalCombinerInputNV) then Exit;
    glGetCombinerInputParameterfvNV := wglGetProcAddress('glGetCombinerInputParameterfvNV');
    if not Assigned(glGetCombinerInputParameterfvNV) then Exit;
    glGetCombinerInputParameterivNV := wglGetProcAddress('glGetCombinerInputParameterivNV');
    if not Assigned(glGetCombinerInputParameterivNV) then Exit;
    glGetCombinerOutputParameterfvNV := wglGetProcAddress('glGetCombinerOutputParameterfvNV');
    if not Assigned(glGetCombinerOutputParameterfvNV) then Exit;
    glGetCombinerOutputParameterivNV := wglGetProcAddress('glGetCombinerOutputParameterivNV');
    if not Assigned(glGetCombinerOutputParameterivNV) then Exit;
    glGetFinalCombinerInputParameterfvNV := wglGetProcAddress('glGetFinalCombinerInputParameterfvNV');
    if not Assigned(glGetFinalCombinerInputParameterfvNV) then Exit;
    glGetFinalCombinerInputParameterivNV := wglGetProcAddress('glGetFinalCombinerInputParameterivNV');
    if not Assigned(glGetFinalCombinerInputParameterivNV) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_NV_register_combiners2: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_register_combiners2', extstring) then
  begin
    glCombinerStageParameterfvNV := wglGetProcAddress('glCombinerStageParameterfvNV');
    if not Assigned(glCombinerStageParameterfvNV) then Exit;
    glGetCombinerStageParameterfvNV := wglGetProcAddress('glGetCombinerStageParameterfvNV');
    if not Assigned(glGetCombinerStageParameterfvNV) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_NV_texgen_emboss: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_texgen_emboss', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_NV_texgen_reflection: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_texgen_reflection', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_NV_texture_compression_vtc: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_texture_compression_vtc', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_NV_texture_env_combine4: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_texture_env_combine4', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_NV_texture_rectangle: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_texture_rectangle', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_NV_texture_shader: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_texture_shader', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_NV_texture_shader2: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_texture_shader2', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_NV_texture_shader3: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_texture_shader3', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_NV_vertex_array_range: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_vertex_array_range', extstring) then
  begin
    glVertexArrayRangeNV := wglGetProcAddress('glVertexArrayRangeNV');
    if not Assigned(glVertexArrayRangeNV) then Exit;
    glFlushVertexArrayRangeNV := wglGetProcAddress('glFlushVertexArrayRangeNV');
    if not Assigned(glFlushVertexArrayRangeNV) then Exit;
{$IFDEF Win32}
    wglAllocateMemoryNV := wglGetProcAddress('wglAllocateMemoryNV');
    if not Assigned(wglAllocateMemoryNV) then Exit;
    wglFreeMemoryNV := wglGetProcAddress('wglFreeMemoryNV');
    if not Assigned(wglFreeMemoryNV) then Exit;
{$ENDIF}
    Result := TRUE;
  end;

end;

function Load_GL_NV_vertex_array_range2: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_vertex_array_range2', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_NV_vertex_program: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_vertex_program', extstring) then
  begin
    glBindProgramNV := wglGetProcAddress('glBindProgramNV');
    if not Assigned(glBindProgramNV) then Exit;
    glDeleteProgramsNV := wglGetProcAddress('glDeleteProgramsNV');
    if not Assigned(glDeleteProgramsNV) then Exit;
    glExecuteProgramNV := wglGetProcAddress('glExecuteProgramNV');
    if not Assigned(glExecuteProgramNV) then Exit;
    glGenProgramsNV := wglGetProcAddress('glGenProgramsNV');
    if not Assigned(glGenProgramsNV) then Exit;
    glAreProgramsResidentNV := wglGetProcAddress('glAreProgramsResidentNV');
    if not Assigned(glAreProgramsResidentNV) then Exit;
    glRequestResidentProgramsNV := wglGetProcAddress('glRequestResidentProgramsNV');
    if not Assigned(glRequestResidentProgramsNV) then Exit;
    glGetProgramParameterfvNV := wglGetProcAddress('glGetProgramParameterfvNV');
    if not Assigned(glGetProgramParameterfvNV) then Exit;
    glGetProgramParameterdvNV := wglGetProcAddress('glGetProgramParameterdvNV');
    if not Assigned(glGetProgramParameterdvNV) then Exit;
    glGetProgramivNV := wglGetProcAddress('glGetProgramivNV');
    if not Assigned(glGetProgramivNV) then Exit;
    glGetProgramStringNV := wglGetProcAddress('glGetProgramStringNV');
    if not Assigned(glGetProgramStringNV) then Exit;
    glGetTrackMatrixivNV := wglGetProcAddress('glGetTrackMatrixivNV');
    if not Assigned(glGetTrackMatrixivNV) then Exit;
    glGetVertexAttribdvNV := wglGetProcAddress('glGetVertexAttribdvNV');
    if not Assigned(glGetVertexAttribdvNV) then Exit;
    glGetVertexAttribfvNV := wglGetProcAddress('glGetVertexAttribfvNV');
    if not Assigned(glGetVertexAttribfvNV) then Exit;
    glGetVertexAttribivNV := wglGetProcAddress('glGetVertexAttribivNV');
    if not Assigned(glGetVertexAttribivNV) then Exit;
    glGetVertexAttribPointervNV := wglGetProcAddress('glGetVertexAttribPointervNV');
    if not Assigned(glGetVertexAttribPointervNV) then Exit;
    glIsProgramNV := wglGetProcAddress('glIsProgramNV');
    if not Assigned(glIsProgramNV) then Exit;
    glLoadProgramNV := wglGetProcAddress('glLoadProgramNV');
    if not Assigned(glLoadProgramNV) then Exit;
    glProgramParameter4fNV := wglGetProcAddress('glProgramParameter4fNV');
    if not Assigned(glProgramParameter4fNV) then Exit;
    glProgramParameter4fvNV := wglGetProcAddress('glProgramParameter4fvNV');
    if not Assigned(glProgramParameter4fvNV) then Exit;
    glProgramParameters4dvNV := wglGetProcAddress('glProgramParameters4dvNV');
    if not Assigned(glProgramParameters4dvNV) then Exit;
    glProgramParameters4fvNV := wglGetProcAddress('glProgramParameters4fvNV');
    if not Assigned(glProgramParameters4fvNV) then Exit;
    glTrackMatrixNV := wglGetProcAddress('glTrackMatrixNV');
    if not Assigned(glTrackMatrixNV) then Exit;
    glVertexAttribPointerNV := wglGetProcAddress('glVertexAttribPointerNV');
    if not Assigned(glVertexAttribPointerNV) then Exit;
    glVertexAttrib1sNV := wglGetProcAddress('glVertexAttrib1sNV');
    if not Assigned(glVertexAttrib1sNV) then Exit;
    glVertexAttrib1fNV := wglGetProcAddress('glVertexAttrib1fNV');
    if not Assigned(glVertexAttrib1fNV) then Exit;
    glVertexAttrib1dNV := wglGetProcAddress('glVertexAttrib1dNV');
    if not Assigned(glVertexAttrib1dNV) then Exit;
    glVertexAttrib2sNV := wglGetProcAddress('glVertexAttrib2sNV');
    if not Assigned(glVertexAttrib2sNV) then Exit;
    glVertexAttrib2fNV := wglGetProcAddress('glVertexAttrib2fNV');
    if not Assigned(glVertexAttrib2fNV) then Exit;
    glVertexAttrib2dNV := wglGetProcAddress('glVertexAttrib2dNV');
    if not Assigned(glVertexAttrib2dNV) then Exit;
    glVertexAttrib3sNV := wglGetProcAddress('glVertexAttrib3sNV');
    if not Assigned(glVertexAttrib3sNV) then Exit;
    glVertexAttrib3fNV := wglGetProcAddress('glVertexAttrib3fNV');
    if not Assigned(glVertexAttrib3fNV) then Exit;
    glVertexAttrib3dNV := wglGetProcAddress('glVertexAttrib3dNV');
    if not Assigned(glVertexAttrib3dNV) then Exit;
    glVertexAttrib4sNV := wglGetProcAddress('glVertexAttrib4sNV');
    if not Assigned(glVertexAttrib4sNV) then Exit;
    glVertexAttrib4fNV := wglGetProcAddress('glVertexAttrib4fNV');
    if not Assigned(glVertexAttrib4fNV) then Exit;
    glVertexAttrib4dNV := wglGetProcAddress('glVertexAttrib4dNV');
    if not Assigned(glVertexAttrib4dNV) then Exit;
    glVertexAttrib4ubNV := wglGetProcAddress('glVertexAttrib4ubNV');
    if not Assigned(glVertexAttrib4ubNV) then Exit;
    glVertexAttrib1svNV := wglGetProcAddress('glVertexAttrib1svNV');
    if not Assigned(glVertexAttrib1svNV) then Exit;
    glVertexAttrib1fvNV := wglGetProcAddress('glVertexAttrib1fvNV');
    if not Assigned(glVertexAttrib1fvNV) then Exit;
    glVertexAttrib1dvNV := wglGetProcAddress('glVertexAttrib1dvNV');
    if not Assigned(glVertexAttrib1dvNV) then Exit;
    glVertexAttrib2svNV := wglGetProcAddress('glVertexAttrib2svNV');
    if not Assigned(glVertexAttrib2svNV) then Exit;
    glVertexAttrib2fvNV := wglGetProcAddress('glVertexAttrib2fvNV');
    if not Assigned(glVertexAttrib2fvNV) then Exit;
    glVertexAttrib2dvNV := wglGetProcAddress('glVertexAttrib2dvNV');
    if not Assigned(glVertexAttrib2dvNV) then Exit;
    glVertexAttrib3svNV := wglGetProcAddress('glVertexAttrib3svNV');
    if not Assigned(glVertexAttrib3svNV) then Exit;
    glVertexAttrib3fvNV := wglGetProcAddress('glVertexAttrib3fvNV');
    if not Assigned(glVertexAttrib3fvNV) then Exit;
    glVertexAttrib3dvNV := wglGetProcAddress('glVertexAttrib3dvNV');
    if not Assigned(glVertexAttrib3dvNV) then Exit;
    glVertexAttrib4svNV := wglGetProcAddress('glVertexAttrib4svNV');
    if not Assigned(glVertexAttrib4svNV) then Exit;
    glVertexAttrib4fvNV := wglGetProcAddress('glVertexAttrib4fvNV');
    if not Assigned(glVertexAttrib4fvNV) then Exit;
    glVertexAttrib4dvNV := wglGetProcAddress('glVertexAttrib4dvNV');
    if not Assigned(glVertexAttrib4dvNV) then Exit;
    glVertexAttrib4ubvNV := wglGetProcAddress('glVertexAttrib4ubvNV');
    if not Assigned(glVertexAttrib4ubvNV) then Exit;
    glVertexAttribs1svNV := wglGetProcAddress('glVertexAttribs1svNV');
    if not Assigned(glVertexAttribs1svNV) then Exit;
    glVertexAttribs1fvNV := wglGetProcAddress('glVertexAttribs1fvNV');
    if not Assigned(glVertexAttribs1fvNV) then Exit;
    glVertexAttribs1dvNV := wglGetProcAddress('glVertexAttribs1dvNV');
    if not Assigned(glVertexAttribs1dvNV) then Exit;
    glVertexAttribs2svNV := wglGetProcAddress('glVertexAttribs2svNV');
    if not Assigned(glVertexAttribs2svNV) then Exit;
    glVertexAttribs2fvNV := wglGetProcAddress('glVertexAttribs2fvNV');
    if not Assigned(glVertexAttribs2fvNV) then Exit;
    glVertexAttribs2dvNV := wglGetProcAddress('glVertexAttribs2dvNV');
    if not Assigned(glVertexAttribs2dvNV) then Exit;
    glVertexAttribs3svNV := wglGetProcAddress('glVertexAttribs3svNV');
    if not Assigned(glVertexAttribs3svNV) then Exit;
    glVertexAttribs3fvNV := wglGetProcAddress('glVertexAttribs3fvNV');
    if not Assigned(glVertexAttribs3fvNV) then Exit;
    glVertexAttribs3dvNV := wglGetProcAddress('glVertexAttribs3dvNV');
    if not Assigned(glVertexAttribs3dvNV) then Exit;
    glVertexAttribs4svNV := wglGetProcAddress('glVertexAttribs4svNV');
    if not Assigned(glVertexAttribs4svNV) then Exit;
    glVertexAttribs4fvNV := wglGetProcAddress('glVertexAttribs4fvNV');
    if not Assigned(glVertexAttribs4fvNV) then Exit;
    glVertexAttribs4dvNV := wglGetProcAddress('glVertexAttribs4dvNV');
    if not Assigned(glVertexAttribs4dvNV) then Exit;
    glVertexAttribs4ubvNV := wglGetProcAddress('glVertexAttribs4ubvNV');
    if not Assigned(glVertexAttribs4ubvNV) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_NV_vertex_program1_1: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_vertex_program1_1', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_ATI_element_array: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ATI_element_array', extstring) then
  begin
    glElementPointerATI := wglGetProcAddress('glElementPointerATI');
    if not Assigned(glElementPointerATI) then Exit;
    glDrawElementArrayATI := wglGetProcAddress('glDrawElementArrayATI');
    if not Assigned(glDrawElementArrayATI) then Exit;
    glDrawRangeElementArrayATI := wglGetProcAddress('glDrawRangeElementArrayATI');
    if not Assigned(glDrawRangeElementArrayATI) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_ATI_envmap_bumpmap: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ATI_envmap_bumpmap', extstring) then
  begin
    glTexBumpParameterivATI := wglGetProcAddress('glTexBumpParameterivATI');
    if not Assigned(glTexBumpParameterivATI) then Exit;
    glTexBumpParameterfvATI := wglGetProcAddress('glTexBumpParameterfvATI');
    if not Assigned(glTexBumpParameterfvATI) then Exit;
    glGetTexBumpParameterivATI := wglGetProcAddress('glGetTexBumpParameterivATI');
    if not Assigned(glGetTexBumpParameterivATI) then Exit;
    glGetTexBumpParameterfvATI := wglGetProcAddress('glGetTexBumpParameterfvATI');
    if not Assigned(glGetTexBumpParameterfvATI) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_ATI_fragment_shader: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ATI_fragment_shader', extstring) then
  begin
    glGenFragmentShadersATI := wglGetProcAddress('glGenFragmentShadersATI');
    if not Assigned(glGenFragmentShadersATI) then Exit;
    glBindFragmentShaderATI := wglGetProcAddress('glBindFragmentShaderATI');
    if not Assigned(glBindFragmentShaderATI) then Exit;
    glDeleteFragmentShaderATI := wglGetProcAddress('glDeleteFragmentShaderATI');
    if not Assigned(glDeleteFragmentShaderATI) then Exit;
    glBeginFragmentShaderATI := wglGetProcAddress('glBeginFragmentShaderATI');
    if not Assigned(glBeginFragmentShaderATI) then Exit;
    glEndFragmentShaderATI := wglGetProcAddress('glEndFragmentShaderATI');
    if not Assigned(glEndFragmentShaderATI) then Exit;
    glPassTexCoordATI := wglGetProcAddress('glPassTexCoordATI');
    if not Assigned(glPassTexCoordATI) then Exit;
    glSampleMapATI := wglGetProcAddress('glSampleMapATI');
    if not Assigned(glSampleMapATI) then Exit;
    glColorFragmentOp1ATI := wglGetProcAddress('glColorFragmentOp1ATI');
    if not Assigned(glColorFragmentOp1ATI) then Exit;
    glColorFragmentOp2ATI := wglGetProcAddress('glColorFragmentOp2ATI');
    if not Assigned(glColorFragmentOp2ATI) then Exit;
    glColorFragmentOp3ATI := wglGetProcAddress('glColorFragmentOp3ATI');
    if not Assigned(glColorFragmentOp3ATI) then Exit;
    glAlphaFragmentOp1ATI := wglGetProcAddress('glAlphaFragmentOp1ATI');
    if not Assigned(glAlphaFragmentOp1ATI) then Exit;
    glAlphaFragmentOp2ATI := wglGetProcAddress('glAlphaFragmentOp2ATI');
    if not Assigned(glAlphaFragmentOp2ATI) then Exit;
    glAlphaFragmentOp3ATI := wglGetProcAddress('glAlphaFragmentOp3ATI');
    if not Assigned(glAlphaFragmentOp3ATI) then Exit;
    glSetFragmentShaderConstantATI := wglGetProcAddress('glSetFragmentShaderConstantATI');
    if not Assigned(glSetFragmentShaderConstantATI) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_ATI_pn_triangles: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ATI_pn_triangles', extstring) then
  begin
    glPNTrianglesiATI := wglGetProcAddress('glPNTrianglesiATI');
    if not Assigned(glPNTrianglesiATI) then Exit;
    glPNTrianglesfATI := wglGetProcAddress('glPNTrianglesfATI');
    if not Assigned(glPNTrianglesfATI) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_ATI_texture_mirror_once: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ATI_texture_mirror_once', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_ATI_vertex_array_object: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ATI_vertex_array_object', extstring) then
  begin
    glNewObjectBufferATI := wglGetProcAddress('glNewObjectBufferATI');
    if not Assigned(glNewObjectBufferATI) then Exit;
    glIsObjectBufferATI := wglGetProcAddress('glIsObjectBufferATI');
    if not Assigned(glIsObjectBufferATI) then Exit;
    glUpdateObjectBufferATI := wglGetProcAddress('glUpdateObjectBufferATI');
    if not Assigned(glUpdateObjectBufferATI) then Exit;
    glGetObjectBufferfvATI := wglGetProcAddress('glGetObjectBufferfvATI');
    if not Assigned(glGetObjectBufferfvATI) then Exit;
    glGetObjectBufferivATI := wglGetProcAddress('glGetObjectBufferivATI');
    if not Assigned(glGetObjectBufferivATI) then Exit;
    glDeleteObjectBufferATI := wglGetProcAddress('glDeleteObjectBufferATI');
    if not Assigned(glDeleteObjectBufferATI) then Exit;
    glArrayObjectATI := wglGetProcAddress('glArrayObjectATI');
    if not Assigned(glArrayObjectATI) then Exit;
    glGetArrayObjectfvATI := wglGetProcAddress('glGetArrayObjectfvATI');
    if not Assigned(glGetArrayObjectfvATI) then Exit;
    glGetArrayObjectivATI := wglGetProcAddress('glGetArrayObjectivATI');
    if not Assigned(glGetArrayObjectivATI) then Exit;
    glVariantArrayObjectATI := wglGetProcAddress('glVariantArrayObjectATI');
    if not Assigned(glVariantArrayObjectATI) then Exit;
    glGetVariantArrayObjectfvATI := wglGetProcAddress('glGetVariantArrayObjectfvATI');
    if not Assigned(glGetVariantArrayObjectfvATI) then Exit;
    glGetVariantArrayObjectivATI := wglGetProcAddress('glGetVariantArrayObjectivATI');
    if not Assigned(glGetVariantArrayObjectivATI) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_ATI_vertex_streams: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ATI_vertex_streams', extstring) then
  begin
    glVertexStream1s := wglGetProcAddress('glVertexStream1s');
    if not Assigned(glVertexStream1s) then Exit;
    glVertexStream1i := wglGetProcAddress('glVertexStream1i');
    if not Assigned(glVertexStream1i) then Exit;
    glVertexStream1f := wglGetProcAddress('glVertexStream1f');
    if not Assigned(glVertexStream1f) then Exit;
    glVertexStream1d := wglGetProcAddress('glVertexStream1d');
    if not Assigned(glVertexStream1d) then Exit;
    glVertexStream1sv := wglGetProcAddress('glVertexStream1sv');
    if not Assigned(glVertexStream1sv) then Exit;
    glVertexStream1iv := wglGetProcAddress('glVertexStream1iv');
    if not Assigned(glVertexStream1iv) then Exit;
    glVertexStream1fv := wglGetProcAddress('glVertexStream1fv');
    if not Assigned(glVertexStream1fv) then Exit;
    glVertexStream1dv := wglGetProcAddress('glVertexStream1dv');
    if not Assigned(glVertexStream1dv) then Exit;
    glVertexStream2s := wglGetProcAddress('glVertexStream2s');
    if not Assigned(glVertexStream2s) then Exit;
    glVertexStream2i := wglGetProcAddress('glVertexStream2i');
    if not Assigned(glVertexStream2i) then Exit;
    glVertexStream2f := wglGetProcAddress('glVertexStream2f');
    if not Assigned(glVertexStream2f) then Exit;
    glVertexStream2d := wglGetProcAddress('glVertexStream2d');
    if not Assigned(glVertexStream2d) then Exit;
    glVertexStream2sv := wglGetProcAddress('glVertexStream2sv');
    if not Assigned(glVertexStream2sv) then Exit;
    glVertexStream2iv := wglGetProcAddress('glVertexStream2iv');
    if not Assigned(glVertexStream2iv) then Exit;
    glVertexStream2fv := wglGetProcAddress('glVertexStream2fv');
    if not Assigned(glVertexStream2fv) then Exit;
    glVertexStream2dv := wglGetProcAddress('glVertexStream2dv');
    if not Assigned(glVertexStream2dv) then Exit;
    glVertexStream3s := wglGetProcAddress('glVertexStream3s');
    if not Assigned(glVertexStream3s) then Exit;
    glVertexStream3i := wglGetProcAddress('glVertexStream3i');
    if not Assigned(glVertexStream3i) then Exit;
    glVertexStream3f := wglGetProcAddress('glVertexStream3f');
    if not Assigned(glVertexStream3f) then Exit;
    glVertexStream3d := wglGetProcAddress('glVertexStream3d');
    if not Assigned(glVertexStream3d) then Exit;
    glVertexStream3sv := wglGetProcAddress('glVertexStream3sv');
    if not Assigned(glVertexStream3sv) then Exit;
    glVertexStream3iv := wglGetProcAddress('glVertexStream3iv');
    if not Assigned(glVertexStream3iv) then Exit;
    glVertexStream3fv := wglGetProcAddress('glVertexStream3fv');
    if not Assigned(glVertexStream3fv) then Exit;
    glVertexStream3dv := wglGetProcAddress('glVertexStream3dv');
    if not Assigned(glVertexStream3dv) then Exit;
    glVertexStream4s := wglGetProcAddress('glVertexStream4s');
    if not Assigned(glVertexStream4s) then Exit;
    glVertexStream4i := wglGetProcAddress('glVertexStream4i');
    if not Assigned(glVertexStream4i) then Exit;
    glVertexStream4f := wglGetProcAddress('glVertexStream4f');
    if not Assigned(glVertexStream4f) then Exit;
    glVertexStream4d := wglGetProcAddress('glVertexStream4d');
    if not Assigned(glVertexStream4d) then Exit;
    glVertexStream4sv := wglGetProcAddress('glVertexStream4sv');
    if not Assigned(glVertexStream4sv) then Exit;
    glVertexStream4iv := wglGetProcAddress('glVertexStream4iv');
    if not Assigned(glVertexStream4iv) then Exit;
    glVertexStream4fv := wglGetProcAddress('glVertexStream4fv');
    if not Assigned(glVertexStream4fv) then Exit;
    glVertexStream4dv := wglGetProcAddress('glVertexStream4dv');
    if not Assigned(glVertexStream4dv) then Exit;
    glNormalStream3b := wglGetProcAddress('glNormalStream3b');
    if not Assigned(glNormalStream3b) then Exit;
    glNormalStream3s := wglGetProcAddress('glNormalStream3s');
    if not Assigned(glNormalStream3s) then Exit;
    glNormalStream3i := wglGetProcAddress('glNormalStream3i');
    if not Assigned(glNormalStream3i) then Exit;
    glNormalStream3f := wglGetProcAddress('glNormalStream3f');
    if not Assigned(glNormalStream3f) then Exit;
    glNormalStream3d := wglGetProcAddress('glNormalStream3d');
    if not Assigned(glNormalStream3d) then Exit;
    glNormalStream3bv := wglGetProcAddress('glNormalStream3bv');
    if not Assigned(glNormalStream3bv) then Exit;
    glNormalStream3sv := wglGetProcAddress('glNormalStream3sv');
    if not Assigned(glNormalStream3sv) then Exit;
    glNormalStream3iv := wglGetProcAddress('glNormalStream3iv');
    if not Assigned(glNormalStream3iv) then Exit;
    glNormalStream3fv := wglGetProcAddress('glNormalStream3fv');
    if not Assigned(glNormalStream3fv) then Exit;
    glNormalStream3dv := wglGetProcAddress('glNormalStream3dv');
    if not Assigned(glNormalStream3dv) then Exit;
    glClientActiveVertexStream := wglGetProcAddress('glClientActiveVertexStream');
    if not Assigned(glClientActiveVertexStream) then Exit;
    glVertexBlendEnvi := wglGetProcAddress('glVertexBlendEnvi');
    if not Assigned(glVertexBlendEnvi) then Exit;
    glVertexBlendEnvf := wglGetProcAddress('glVertexBlendEnvf');
    if not Assigned(glVertexBlendEnvf) then Exit;
    Result := TRUE;
  end;

end;

{$IFDEF Win32}
function Load_WGL_I3D_image_buffer: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
  if not Assigned(wglGetExtensionsStringARB) then Exit;
  extstring := String(PChar(wglGetExtensionsStringARB(wglGetCurrentDC)));

  if glext_ExtensionSupported('WGL_I3D_image_buffer', extstring) then
  begin
    wglCreateImageBufferI3D := wglGetProcAddress('wglCreateImageBufferI3D');
    if not Assigned(wglCreateImageBufferI3D) then Exit;
    wglDestroyImageBufferI3D := wglGetProcAddress('wglDestroyImageBufferI3D');
    if not Assigned(wglDestroyImageBufferI3D) then Exit;
    wglAssociateImageBufferEventsI3D := wglGetProcAddress('wglAssociateImageBufferEventsI3D');
    if not Assigned(wglAssociateImageBufferEventsI3D) then Exit;
    wglReleaseImageBufferEventsI3D := wglGetProcAddress('wglReleaseImageBufferEventsI3D');
    if not Assigned(wglReleaseImageBufferEventsI3D) then Exit;
    Result := TRUE;
  end;

end;

function Load_WGL_I3D_swap_frame_lock: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
  if not Assigned(wglGetExtensionsStringARB) then Exit;
  extstring := String(PChar(wglGetExtensionsStringARB(wglGetCurrentDC)));

  if glext_ExtensionSupported('WGL_I3D_swap_frame_lock', extstring) then
  begin
    wglEnableFrameLockI3D := wglGetProcAddress('wglEnableFrameLockI3D');
    if not Assigned(wglEnableFrameLockI3D) then Exit;
    wglDisableFrameLockI3D := wglGetProcAddress('wglDisableFrameLockI3D');
    if not Assigned(wglDisableFrameLockI3D) then Exit;
    wglIsEnabledFrameLockI3D := wglGetProcAddress('wglIsEnabledFrameLockI3D');
    if not Assigned(wglIsEnabledFrameLockI3D) then Exit;
    wglQueryFrameLockMasterI3D := wglGetProcAddress('wglQueryFrameLockMasterI3D');
    if not Assigned(wglQueryFrameLockMasterI3D) then Exit;
    Result := TRUE;
  end;

end;

function Load_WGL_I3D_swap_frame_usage: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
  if not Assigned(wglGetExtensionsStringARB) then Exit;
  extstring := String(PChar(wglGetExtensionsStringARB(wglGetCurrentDC)));

  if glext_ExtensionSupported('WGL_I3D_swap_frame_usage', extstring) then
  begin
    wglGetFrameUsageI3D := wglGetProcAddress('wglGetFrameUsageI3D');
    if not Assigned(wglGetFrameUsageI3D) then Exit;
    wglBeginFrameTrackingI3D := wglGetProcAddress('wglBeginFrameTrackingI3D');
    if not Assigned(wglBeginFrameTrackingI3D) then Exit;
    wglEndFrameTrackingI3D := wglGetProcAddress('wglEndFrameTrackingI3D');
    if not Assigned(wglEndFrameTrackingI3D) then Exit;
    wglQueryFrameTrackingI3D := wglGetProcAddress('wglQueryFrameTrackingI3D');
    if not Assigned(wglQueryFrameTrackingI3D) then Exit;
    Result := TRUE;
  end;

end;
{$ENDIF}

function Load_GL_3DFX_texture_compression_FXT1: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_3DFX_texture_compression_FXT1', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_IBM_cull_vertex: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_IBM_cull_vertex', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_IBM_multimode_draw_arrays: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_IBM_multimode_draw_arrays', extstring) then
  begin
    glMultiModeDrawArraysIBM := wglGetProcAddress('glMultiModeDrawArraysIBM');
    if not Assigned(glMultiModeDrawArraysIBM) then Exit;
    glMultiModeDrawElementsIBM := wglGetProcAddress('glMultiModeDrawElementsIBM');
    if not Assigned(glMultiModeDrawElementsIBM) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_IBM_raster_pos_clip: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_IBM_raster_pos_clip', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_IBM_texture_mirrored_repeat: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_IBM_texture_mirrored_repeat', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_IBM_vertex_array_lists: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_IBM_vertex_array_lists', extstring) then
  begin
    glColorPointerListIBM := wglGetProcAddress('glColorPointerListIBM');
    if not Assigned(glColorPointerListIBM) then Exit;
    glSecondaryColorPointerListIBM := wglGetProcAddress('glSecondaryColorPointerListIBM');
    if not Assigned(glSecondaryColorPointerListIBM) then Exit;
    glEdgeFlagPointerListIBM := wglGetProcAddress('glEdgeFlagPointerListIBM');
    if not Assigned(glEdgeFlagPointerListIBM) then Exit;
    glFogCoordPointerListIBM := wglGetProcAddress('glFogCoordPointerListIBM');
    if not Assigned(glFogCoordPointerListIBM) then Exit;
    glNormalPointerListIBM := wglGetProcAddress('glNormalPointerListIBM');
    if not Assigned(glNormalPointerListIBM) then Exit;
    glTexCoordPointerListIBM := wglGetProcAddress('glTexCoordPointerListIBM');
    if not Assigned(glTexCoordPointerListIBM) then Exit;
    glVertexPointerListIBM := wglGetProcAddress('glVertexPointerListIBM');
    if not Assigned(glVertexPointerListIBM) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_MESA_resize_buffers: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_MESA_resize_buffers', extstring) then
  begin
    glResizeBuffersMESA := wglGetProcAddress('glResizeBuffersMESA');
    if not Assigned(glResizeBuffersMESA) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_MESA_window_pos: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_MESA_window_pos', extstring) then
  begin
    glWindowPos2dMESA := wglGetProcAddress('glWindowPos2dMESA');
    if not Assigned(glWindowPos2dMESA) then Exit;
    glWindowPos2fMESA := wglGetProcAddress('glWindowPos2fMESA');
    if not Assigned(glWindowPos2fMESA) then Exit;
    glWindowPos2iMESA := wglGetProcAddress('glWindowPos2iMESA');
    if not Assigned(glWindowPos2iMESA) then Exit;
    glWindowPos2sMESA := wglGetProcAddress('glWindowPos2sMESA');
    if not Assigned(glWindowPos2sMESA) then Exit;
    glWindowPos2ivMESA := wglGetProcAddress('glWindowPos2ivMESA');
    if not Assigned(glWindowPos2ivMESA) then Exit;
    glWindowPos2svMESA := wglGetProcAddress('glWindowPos2svMESA');
    if not Assigned(glWindowPos2svMESA) then Exit;
    glWindowPos2fvMESA := wglGetProcAddress('glWindowPos2fvMESA');
    if not Assigned(glWindowPos2fvMESA) then Exit;
    glWindowPos2dvMESA := wglGetProcAddress('glWindowPos2dvMESA');
    if not Assigned(glWindowPos2dvMESA) then Exit;
    glWindowPos3iMESA := wglGetProcAddress('glWindowPos3iMESA');
    if not Assigned(glWindowPos3iMESA) then Exit;
    glWindowPos3sMESA := wglGetProcAddress('glWindowPos3sMESA');
    if not Assigned(glWindowPos3sMESA) then Exit;
    glWindowPos3fMESA := wglGetProcAddress('glWindowPos3fMESA');
    if not Assigned(glWindowPos3fMESA) then Exit;
    glWindowPos3dMESA := wglGetProcAddress('glWindowPos3dMESA');
    if not Assigned(glWindowPos3dMESA) then Exit;
    glWindowPos3ivMESA := wglGetProcAddress('glWindowPos3ivMESA');
    if not Assigned(glWindowPos3ivMESA) then Exit;
    glWindowPos3svMESA := wglGetProcAddress('glWindowPos3svMESA');
    if not Assigned(glWindowPos3svMESA) then Exit;
    glWindowPos3fvMESA := wglGetProcAddress('glWindowPos3fvMESA');
    if not Assigned(glWindowPos3fvMESA) then Exit;
    glWindowPos3dvMESA := wglGetProcAddress('glWindowPos3dvMESA');
    if not Assigned(glWindowPos3dvMESA) then Exit;
    glWindowPos4iMESA := wglGetProcAddress('glWindowPos4iMESA');
    if not Assigned(glWindowPos4iMESA) then Exit;
    glWindowPos4sMESA := wglGetProcAddress('glWindowPos4sMESA');
    if not Assigned(glWindowPos4sMESA) then Exit;
    glWindowPos4fMESA := wglGetProcAddress('glWindowPos4fMESA');
    if not Assigned(glWindowPos4fMESA) then Exit;
    glWindowPos4dMESA := wglGetProcAddress('glWindowPos4dMESA');
    if not Assigned(glWindowPos4dMESA) then Exit;
    glWindowPos4ivMESA := wglGetProcAddress('glWindowPos4ivMESA');
    if not Assigned(glWindowPos4ivMESA) then Exit;
    glWindowPos4svMESA := wglGetProcAddress('glWindowPos4svMESA');
    if not Assigned(glWindowPos4svMESA) then Exit;
    glWindowPos4fvMESA := wglGetProcAddress('glWindowPos4fvMESA');
    if not Assigned(glWindowPos4fvMESA) then Exit;
    glWindowPos4dvMESA := wglGetProcAddress('glWindowPos4dvMESA');
    if not Assigned(glWindowPos4dvMESA) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_OML_interlace: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_OML_interlace', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_OML_resample: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_OML_resample', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_OML_subsample: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_OML_subsample', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_SGIS_generate_mipmap: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_SGIS_generate_mipmap', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_SGIS_multisample: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_SGIS_multisample', extstring) then
  begin
    glSampleMaskSGIS := wglGetProcAddress('glSampleMaskSGIS');
    if not Assigned(glSampleMaskSGIS) then Exit;
    glSamplePatternSGIS := wglGetProcAddress('glSamplePatternSGIS');
    if not Assigned(glSamplePatternSGIS) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_SGIS_pixel_texture: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_SGIS_pixel_texture', extstring) then
  begin
    glPixelTexGenParameteriSGIS := wglGetProcAddress('glPixelTexGenParameteriSGIS');
    if not Assigned(glPixelTexGenParameteriSGIS) then Exit;
    glPixelTexGenParameterfSGIS := wglGetProcAddress('glPixelTexGenParameterfSGIS');
    if not Assigned(glPixelTexGenParameterfSGIS) then Exit;
    glGetPixelTexGenParameterivSGIS := wglGetProcAddress('glGetPixelTexGenParameterivSGIS');
    if not Assigned(glGetPixelTexGenParameterivSGIS) then Exit;
    glGetPixelTexGenParameterfvSGIS := wglGetProcAddress('glGetPixelTexGenParameterfvSGIS');
    if not Assigned(glGetPixelTexGenParameterfvSGIS) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_SGIS_texture_border_clamp: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_SGIS_texture_border_clamp', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_SGIS_texture_color_mask: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_SGIS_texture_color_mask', extstring) then
  begin
    glTextureColorMaskSGIS := wglGetProcAddress('glTextureColorMaskSGIS');
    if not Assigned(glTextureColorMaskSGIS) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_SGIS_texture_edge_clamp: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_SGIS_texture_edge_clamp', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_SGIS_texture_lod: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_SGIS_texture_lod', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_SGIS_depth_texture: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_SGIS_depth_texture', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_SGIX_fog_offset: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_SGIX_fog_offset', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_SGIX_interlace: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_SGIX_interlace', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_SGIX_shadow_ambient: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_SGIX_shadow_ambient', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_SGI_color_matrix: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_SGI_color_matrix', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_SGI_color_table: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_SGI_color_table', extstring) then
  begin
    glColorTableSGI := wglGetProcAddress('glColorTableSGI');
    if not Assigned(glColorTableSGI) then Exit;
    glCopyColorTableSGI := wglGetProcAddress('glCopyColorTableSGI');
    if not Assigned(glCopyColorTableSGI) then Exit;
    glColorTableParameterivSGI := wglGetProcAddress('glColorTableParameterivSGI');
    if not Assigned(glColorTableParameterivSGI) then Exit;
    glColorTableParameterfvSGI := wglGetProcAddress('glColorTableParameterfvSGI');
    if not Assigned(glColorTableParameterfvSGI) then Exit;
    glGetColorTableSGI := wglGetProcAddress('glGetColorTableSGI');
    if not Assigned(glGetColorTableSGI) then Exit;
    glGetColorTableParameterivSGI := wglGetProcAddress('glGetColorTableParameterivSGI');
    if not Assigned(glGetColorTableParameterivSGI) then Exit;
    glGetColorTableParameterfvSGI := wglGetProcAddress('glGetColorTableParameterfvSGI');
    if not Assigned(glGetColorTableParameterfvSGI) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_SGI_texture_color_table: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_SGI_texture_color_table', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_SUN_vertex: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_SUN_vertex', extstring) then
  begin
    glColor4ubVertex2fSUN := wglGetProcAddress('glColor4ubVertex2fSUN');
    if not Assigned(glColor4ubVertex2fSUN) then Exit;
    glColor4ubVertex2fvSUN := wglGetProcAddress('glColor4ubVertex2fvSUN');
    if not Assigned(glColor4ubVertex2fvSUN) then Exit;
    glColor4ubVertex3fSUN := wglGetProcAddress('glColor4ubVertex3fSUN');
    if not Assigned(glColor4ubVertex3fSUN) then Exit;
    glColor4ubVertex3fvSUN := wglGetProcAddress('glColor4ubVertex3fvSUN');
    if not Assigned(glColor4ubVertex3fvSUN) then Exit;
    glColor3fVertex3fSUN := wglGetProcAddress('glColor3fVertex3fSUN');
    if not Assigned(glColor3fVertex3fSUN) then Exit;
    glColor3fVertex3fvSUN := wglGetProcAddress('glColor3fVertex3fvSUN');
    if not Assigned(glColor3fVertex3fvSUN) then Exit;
    glNormal3fVertex3fSUN := wglGetProcAddress('glNormal3fVertex3fSUN');
    if not Assigned(glNormal3fVertex3fSUN) then Exit;
    glNormal3fVertex3fvSUN := wglGetProcAddress('glNormal3fVertex3fvSUN');
    if not Assigned(glNormal3fVertex3fvSUN) then Exit;
    glColor4fNormal3fVertex3fSUN := wglGetProcAddress('glColor4fNormal3fVertex3fSUN');
    if not Assigned(glColor4fNormal3fVertex3fSUN) then Exit;
    glColor4fNormal3fVertex3fvSUN := wglGetProcAddress('glColor4fNormal3fVertex3fvSUN');
    if not Assigned(glColor4fNormal3fVertex3fvSUN) then Exit;
    glTexCoord2fVertex3fSUN := wglGetProcAddress('glTexCoord2fVertex3fSUN');
    if not Assigned(glTexCoord2fVertex3fSUN) then Exit;
    glTexCoord2fVertex3fvSUN := wglGetProcAddress('glTexCoord2fVertex3fvSUN');
    if not Assigned(glTexCoord2fVertex3fvSUN) then Exit;
    glTexCoord4fVertex4fSUN := wglGetProcAddress('glTexCoord4fVertex4fSUN');
    if not Assigned(glTexCoord4fVertex4fSUN) then Exit;
    glTexCoord4fVertex4fvSUN := wglGetProcAddress('glTexCoord4fVertex4fvSUN');
    if not Assigned(glTexCoord4fVertex4fvSUN) then Exit;
    glTexCoord2fColor4ubVertex3fSUN := wglGetProcAddress('glTexCoord2fColor4ubVertex3fSUN');
    if not Assigned(glTexCoord2fColor4ubVertex3fSUN) then Exit;
    glTexCoord2fColor4ubVertex3fvSUN := wglGetProcAddress('glTexCoord2fColor4ubVertex3fvSUN');
    if not Assigned(glTexCoord2fColor4ubVertex3fvSUN) then Exit;
    glTexCoord2fColor3fVertex3fSUN := wglGetProcAddress('glTexCoord2fColor3fVertex3fSUN');
    if not Assigned(glTexCoord2fColor3fVertex3fSUN) then Exit;
    glTexCoord2fColor3fVertex3fvSUN := wglGetProcAddress('glTexCoord2fColor3fVertex3fvSUN');
    if not Assigned(glTexCoord2fColor3fVertex3fvSUN) then Exit;
    glTexCoord2fNormal3fVertex3fSUN := wglGetProcAddress('glTexCoord2fNormal3fVertex3fSUN');
    if not Assigned(glTexCoord2fNormal3fVertex3fSUN) then Exit;
    glTexCoord2fNormal3fVertex3fvSUN := wglGetProcAddress('glTexCoord2fNormal3fVertex3fvSUN');
    if not Assigned(glTexCoord2fNormal3fVertex3fvSUN) then Exit;
    glTexCoord2fColor4fNormal3fVertex3fSUN := wglGetProcAddress('glTexCoord2fColor4fNormal3fVertex3fSUN');
    if not Assigned(glTexCoord2fColor4fNormal3fVertex3fSUN) then Exit;
    glTexCoord2fColor4fNormal3fVertex3fvSUN := wglGetProcAddress('glTexCoord2fColor4fNormal3fVertex3fvSUN');
    if not Assigned(glTexCoord2fColor4fNormal3fVertex3fvSUN) then Exit;
    glTexCoord4fColor4fNormal3fVertex4fSUN := wglGetProcAddress('glTexCoord4fColor4fNormal3fVertex4fSUN');
    if not Assigned(glTexCoord4fColor4fNormal3fVertex4fSUN) then Exit;
    glTexCoord4fColor4fNormal3fVertex4fvSUN := wglGetProcAddress('glTexCoord4fColor4fNormal3fVertex4fvSUN');
    if not Assigned(glTexCoord4fColor4fNormal3fVertex4fvSUN) then Exit;
    glReplacementCodeuiVertex3fSUN := wglGetProcAddress('glReplacementCodeuiVertex3fSUN');
    if not Assigned(glReplacementCodeuiVertex3fSUN) then Exit;
    glReplacementCodeuiVertex3fvSUN := wglGetProcAddress('glReplacementCodeuiVertex3fvSUN');
    if not Assigned(glReplacementCodeuiVertex3fvSUN) then Exit;
    glReplacementCodeuiColor4ubVertex3fSUN := wglGetProcAddress('glReplacementCodeuiColor4ubVertex3fSUN');
    if not Assigned(glReplacementCodeuiColor4ubVertex3fSUN) then Exit;
    glReplacementCodeuiColor4ubVertex3fvSUN := wglGetProcAddress('glReplacementCodeuiColor4ubVertex3fvSUN');
    if not Assigned(glReplacementCodeuiColor4ubVertex3fvSUN) then Exit;
    glReplacementCodeuiColor3fVertex3fSUN := wglGetProcAddress('glReplacementCodeuiColor3fVertex3fSUN');
    if not Assigned(glReplacementCodeuiColor3fVertex3fSUN) then Exit;
    glReplacementCodeuiColor3fVertex3fvSUN := wglGetProcAddress('glReplacementCodeuiColor3fVertex3fvSUN');
    if not Assigned(glReplacementCodeuiColor3fVertex3fvSUN) then Exit;
    glReplacementCodeuiNormal3fVertex3fSUN := wglGetProcAddress('glReplacementCodeuiNormal3fVertex3fSUN');
    if not Assigned(glReplacementCodeuiNormal3fVertex3fSUN) then Exit;
    glReplacementCodeuiNormal3fVertex3fvSUN := wglGetProcAddress('glReplacementCodeuiNormal3fVertex3fvSUN');
    if not Assigned(glReplacementCodeuiNormal3fVertex3fvSUN) then Exit;
    glReplacementCodeuiColor4fNormal3fVertex3fSUN := wglGetProcAddress('glReplacementCodeuiColor4fNormal3fVertex3fSUN');
    if not Assigned(glReplacementCodeuiColor4fNormal3fVertex3fSUN) then Exit;
    glReplacementCodeuiColor4fNormal3fVertex3fvSUN := wglGetProcAddress('glReplacementCodeuiColor4fNormal3fVertex3fvSUN');
    if not Assigned(glReplacementCodeuiColor4fNormal3fVertex3fvSUN) then Exit;
    glReplacementCodeuiTexCoord2fVertex3fSUN := wglGetProcAddress('glReplacementCodeuiTexCoord2fVertex3fSUN');
    if not Assigned(glReplacementCodeuiTexCoord2fVertex3fSUN) then Exit;
    glReplacementCodeuiTexCoord2fVertex3fvSUN := wglGetProcAddress('glReplacementCodeuiTexCoord2fVertex3fvSUN');
    if not Assigned(glReplacementCodeuiTexCoord2fVertex3fvSUN) then Exit;
    glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN := wglGetProcAddress('glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN');
    if not Assigned(glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN) then Exit;
    glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN := wglGetProcAddress('glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN');
    if not Assigned(glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN) then Exit;
    glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN := wglGetProcAddress('glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN');
    if not Assigned(glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN) then Exit;
    glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN := wglGetProcAddress('glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN');
    if not Assigned(glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_ARB_fragment_program: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_fragment_program', extstring) then
  begin
    glProgramStringARB := wglGetProcAddress('glProgramStringARB');
    if not Assigned(glProgramStringARB) then Exit;
    glBindProgramARB := wglGetProcAddress('glBindProgramARB');
    if not Assigned(glBindProgramARB) then Exit;
    glDeleteProgramsARB := wglGetProcAddress('glDeleteProgramsARB');
    if not Assigned(glDeleteProgramsARB) then Exit;
    glGenProgramsARB := wglGetProcAddress('glGenProgramsARB');
    if not Assigned(glGenProgramsARB) then Exit;
    glProgramEnvParameter4dARB := wglGetProcAddress('glProgramEnvParameter4dARB');
    if not Assigned(glProgramEnvParameter4dARB) then Exit;
    glProgramEnvParameter4dvARB := wglGetProcAddress('glProgramEnvParameter4dvARB');
    if not Assigned(glProgramEnvParameter4dvARB) then Exit;
    glProgramEnvParameter4fARB := wglGetProcAddress('glProgramEnvParameter4fARB');
    if not Assigned(glProgramEnvParameter4fARB) then Exit;
    glProgramEnvParameter4fvARB := wglGetProcAddress('glProgramEnvParameter4fvARB');
    if not Assigned(glProgramEnvParameter4fvARB) then Exit;
    glProgramLocalParameter4dARB := wglGetProcAddress('glProgramLocalParameter4dARB');
    if not Assigned(glProgramLocalParameter4dARB) then Exit;
    glProgramLocalParameter4dvARB := wglGetProcAddress('glProgramLocalParameter4dvARB');
    if not Assigned(glProgramLocalParameter4dvARB) then Exit;
    glProgramLocalParameter4fARB := wglGetProcAddress('glProgramLocalParameter4fARB');
    if not Assigned(glProgramLocalParameter4fARB) then Exit;
    glProgramLocalParameter4fvARB := wglGetProcAddress('glProgramLocalParameter4fvARB');
    if not Assigned(glProgramLocalParameter4fvARB) then Exit;
    glGetProgramEnvParameterdvARB := wglGetProcAddress('glGetProgramEnvParameterdvARB');
    if not Assigned(glGetProgramEnvParameterdvARB) then Exit;
    glGetProgramEnvParameterfvARB := wglGetProcAddress('glGetProgramEnvParameterfvARB');
    if not Assigned(glGetProgramEnvParameterfvARB) then Exit;
    glGetProgramLocalParameterdvARB := wglGetProcAddress('glGetProgramLocalParameterdvARB');
    if not Assigned(glGetProgramLocalParameterdvARB) then Exit;
    glGetProgramLocalParameterfvARB := wglGetProcAddress('glGetProgramLocalParameterfvARB');
    if not Assigned(glGetProgramLocalParameterfvARB) then Exit;
    glGetProgramivARB := wglGetProcAddress('glGetProgramivARB');
    if not Assigned(glGetProgramivARB) then Exit;
    glGetProgramStringARB := wglGetProcAddress('glGetProgramStringARB');
    if not Assigned(glGetProgramStringARB) then Exit;
    glIsProgramARB := wglGetProcAddress('glIsProgramARB');
    if not Assigned(glIsProgramARB) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_ATI_text_fragment_shader: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ATI_text_fragment_shader', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_APPLE_client_storage: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_APPLE_client_storage', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_APPLE_element_array: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_APPLE_element_array', extstring) then
  begin
    glElementPointerAPPLE := wglGetProcAddress('glElementPointerAPPLE');
    if not Assigned(glElementPointerAPPLE) then Exit;
    glDrawElementArrayAPPLE := wglGetProcAddress('glDrawElementArrayAPPLE');
    if not Assigned(glDrawElementArrayAPPLE) then Exit;
    glDrawRangeElementArrayAPPLE := wglGetProcAddress('glDrawRangeElementArrayAPPLE');
    if not Assigned(glDrawRangeElementArrayAPPLE) then Exit;
    glMultiDrawElementArrayAPPLE := wglGetProcAddress('glMultiDrawElementArrayAPPLE');
    if not Assigned(glMultiDrawElementArrayAPPLE) then Exit;
    glMultiDrawRangeElementArrayAPPLE := wglGetProcAddress('glMultiDrawRangeElementArrayAPPLE');
    if not Assigned(glMultiDrawRangeElementArrayAPPLE) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_APPLE_fence: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_APPLE_fence', extstring) then
  begin
    glGenFencesAPPLE := wglGetProcAddress('glGenFencesAPPLE');
    if not Assigned(glGenFencesAPPLE) then Exit;
    glDeleteFencesAPPLE := wglGetProcAddress('glDeleteFencesAPPLE');
    if not Assigned(glDeleteFencesAPPLE) then Exit;
    glSetFenceAPPLE := wglGetProcAddress('glSetFenceAPPLE');
    if not Assigned(glSetFenceAPPLE) then Exit;
    glIsFenceAPPLE := wglGetProcAddress('glIsFenceAPPLE');
    if not Assigned(glIsFenceAPPLE) then Exit;
    glTestFenceAPPLE := wglGetProcAddress('glTestFenceAPPLE');
    if not Assigned(glTestFenceAPPLE) then Exit;
    glFinishFenceAPPLE := wglGetProcAddress('glFinishFenceAPPLE');
    if not Assigned(glFinishFenceAPPLE) then Exit;
    glTestObjectAPPLE := wglGetProcAddress('glTestObjectAPPLE');
    if not Assigned(glTestObjectAPPLE) then Exit;
    glFinishObjectAPPLE := wglGetProcAddress('glFinishObjectAPPLE');
    if not Assigned(glFinishObjectAPPLE) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_APPLE_vertex_array_object: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_APPLE_vertex_array_object', extstring) then
  begin
    glBindVertexArrayAPPLE := wglGetProcAddress('glBindVertexArrayAPPLE');
    if not Assigned(glBindVertexArrayAPPLE) then Exit;
    glDeleteVertexArraysAPPLE := wglGetProcAddress('glDeleteVertexArraysAPPLE');
    if not Assigned(glDeleteVertexArraysAPPLE) then Exit;
    glGenVertexArraysAPPLE := wglGetProcAddress('glGenVertexArraysAPPLE');
    if not Assigned(glGenVertexArraysAPPLE) then Exit;
    glIsVertexArrayAPPLE := wglGetProcAddress('glIsVertexArrayAPPLE');
    if not Assigned(glIsVertexArrayAPPLE) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_APPLE_vertex_array_range: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_APPLE_vertex_array_range', extstring) then
  begin
    glVertexArrayRangeAPPLE := wglGetProcAddress('glVertexArrayRangeAPPLE');
    if not Assigned(glVertexArrayRangeAPPLE) then Exit;
    glFlushVertexArrayRangeAPPLE := wglGetProcAddress('glFlushVertexArrayRangeAPPLE');
    if not Assigned(glFlushVertexArrayRangeAPPLE) then Exit;
    glVertexArrayParameteriAPPLE := wglGetProcAddress('glVertexArrayParameteriAPPLE');
    if not Assigned(glVertexArrayParameteriAPPLE) then Exit;
    Result := TRUE;
  end;

end;


function load_GL_ARB_vertex_buffer_object : boolean;

var extstring:string;

begin
  load_GL_ARB_vertex_buffer_object:=false;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));
  if glext_ExtensionSupported('GL_ARB_vertex_buffer_object',extstring) then
    begin
      glBindBufferARB := wglGetProcAddress('glBindBufferARB');
      if not Assigned(glBindBufferARB) then Exit;
      glDeleteBuffersARB := wglGetProcAddress('glDeleteBuffersARB');
      if not Assigned(glDeleteBuffersARB) then Exit;
      glGenBuffersARB := wglGetProcAddress('glGenBuffersARB');
      if not Assigned(glGenBuffersARB) then Exit;
      glIsBufferARB := wglGetProcAddress('glIsBufferARB');
      if not Assigned(glIsBufferARB) then Exit;
      glBufferDataARB := wglGetProcAddress('glBufferDataARB');
      if not Assigned(glBufferDataARB) then Exit;
      glGetBufferSubDataARB := wglGetProcAddress('glGetBufferSubDataARB');
      if not Assigned(glGetBufferSubDataARB) then Exit;
      glMapBufferARB := wglGetProcAddress('glMapBufferARB');
      if not Assigned(glMapBufferARB) then Exit;
      glUnmapBufferARB := wglGetProcAddress('glUnmapBufferARB');
      if not Assigned(glMapBufferARB) then Exit;
      glGetBufferParameterivARB := wglGetProcAddress('glGetBufferParameterivARB');
      if not Assigned(glGetBufferParameterivARB) then Exit;
      glGetBufferPointervARB := wglGetProcAddress('glGetBufferPointervARB');
      if not Assigned(glGetBufferPointervARB) then Exit;
    end;
  load_GL_ARB_vertex_buffer_object:=true;
end;

{$IFDEF Win32}
function Load_WGL_ARB_pixel_format: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
  if not Assigned(wglGetExtensionsStringARB) then Exit;
  extstring := String(PChar(wglGetExtensionsStringARB(wglGetCurrentDC)));

  if glext_ExtensionSupported('WGL_ARB_pixel_format', extstring) then
  begin
    wglGetPixelFormatAttribivARB := wglGetProcAddress('wglGetPixelFormatAttribivARB');
    if not Assigned(wglGetPixelFormatAttribivARB) then Exit;
    wglGetPixelFormatAttribfvARB := wglGetProcAddress('wglGetPixelFormatAttribfvARB');
    if not Assigned(wglGetPixelFormatAttribfvARB) then Exit;
    wglChoosePixelFormatARB := wglGetProcAddress('wglChoosePixelFormatARB');
    if not Assigned(wglChoosePixelFormatARB) then Exit;
    Result := TRUE;
  end;

end;

function Load_WGL_ARB_make_current_read: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
  if not Assigned(wglGetExtensionsStringARB) then Exit;
  extstring := String(PChar(wglGetExtensionsStringARB(wglGetCurrentDC)));

  if glext_ExtensionSupported('WGL_ARB_make_current_read', extstring) then
  begin
    wglMakeContextCurrentARB := wglGetProcAddress('wglMakeContextCurrentARB');
    if not Assigned(wglMakeContextCurrentARB) then Exit;
    wglGetCurrentReadDCARB := wglGetProcAddress('wglGetCurrentReadDCARB');
    if not Assigned(wglGetCurrentReadDCARB) then Exit;
    Result := TRUE;
  end;

end;

function Load_WGL_ARB_pbuffer: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
  if not Assigned(wglGetExtensionsStringARB) then Exit;
  extstring := String(PChar(wglGetExtensionsStringARB(wglGetCurrentDC)));

  if glext_ExtensionSupported('WGL_ARB_pbuffer', extstring) then
  begin
    wglCreatePbufferARB := wglGetProcAddress('wglCreatePbufferARB');
    if not Assigned(wglCreatePbufferARB) then Exit;
    wglGetPbufferDCARB := wglGetProcAddress('wglGetPbufferDCARB');
    if not Assigned(wglGetPbufferDCARB) then Exit;
    wglReleasePbufferDCARB := wglGetProcAddress('wglReleasePbufferDCARB');
    if not Assigned(wglReleasePbufferDCARB) then Exit;
    wglDestroyPbufferARB := wglGetProcAddress('wglDestroyPbufferARB');
    if not Assigned(wglDestroyPbufferARB) then Exit;
    wglQueryPbufferARB := wglGetProcAddress('wglQueryPbufferARB');
    if not Assigned(wglQueryPbufferARB) then Exit;
    Result := TRUE;
  end;

end;

function Load_WGL_EXT_swap_control: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
  if not Assigned(wglGetExtensionsStringARB) then Exit;
  extstring := String(PChar(wglGetExtensionsStringARB(wglGetCurrentDC)));

  if glext_ExtensionSupported('WGL_EXT_swap_control', extstring) then
  begin
    wglSwapIntervalEXT := wglGetProcAddress('wglSwapIntervalEXT');
    if not Assigned(wglSwapIntervalEXT) then Exit;
    wglGetSwapIntervalEXT := wglGetProcAddress('wglGetSwapIntervalEXT');
    if not Assigned(wglGetSwapIntervalEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_WGL_ARB_render_texture: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
  if not Assigned(wglGetExtensionsStringARB) then Exit;
  extstring := String(PChar(wglGetExtensionsStringARB(wglGetCurrentDC)));

  if glext_ExtensionSupported('WGL_ARB_render_texture', extstring) then
  begin
    wglBindTexImageARB := wglGetProcAddress('wglBindTexImageARB');
    if not Assigned(wglBindTexImageARB) then Exit;
    wglReleaseTexImageARB := wglGetProcAddress('wglReleaseTexImageARB');
    if not Assigned(wglReleaseTexImageARB) then Exit;
    wglSetPbufferAttribARB := wglGetProcAddress('wglSetPbufferAttribARB');
    if not Assigned(wglSetPbufferAttribARB) then Exit;
    Result := TRUE;
  end;

end;

function Load_WGL_EXT_extensions_string: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
  if not Assigned(wglGetExtensionsStringARB) then Exit;
  extstring := String(PChar(wglGetExtensionsStringARB(wglGetCurrentDC)));

  if glext_ExtensionSupported('WGL_EXT_extensions_string', extstring) then
  begin
    wglGetExtensionsStringEXT := wglGetProcAddress('wglGetExtensionsStringEXT');
    if not Assigned(wglGetExtensionsStringEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_WGL_EXT_make_current_read: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
  if not Assigned(wglGetExtensionsStringARB) then Exit;
  extstring := String(PChar(wglGetExtensionsStringARB(wglGetCurrentDC)));

  if glext_ExtensionSupported('WGL_EXT_make_current_read', extstring) then
  begin
    wglMakeContextCurrentEXT := wglGetProcAddress('wglMakeContextCurrentEXT');
    if not Assigned(wglMakeContextCurrentEXT) then Exit;
    wglGetCurrentReadDCEXT := wglGetProcAddress('wglGetCurrentReadDCEXT');
    if not Assigned(wglGetCurrentReadDCEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_WGL_EXT_pbuffer: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
  if not Assigned(wglGetExtensionsStringARB) then Exit;
  extstring := String(PChar(wglGetExtensionsStringARB(wglGetCurrentDC)));

  if glext_ExtensionSupported('WGL_EXT_pbuffer', extstring) then
  begin
    wglCreatePbufferEXT := wglGetProcAddress('wglCreatePbufferEXT');
    if not Assigned(wglCreatePbufferEXT) then Exit;
    wglGetPbufferDCEXT := wglGetProcAddress('wglGetPbufferDCEXT');
    if not Assigned(wglGetPbufferDCEXT) then Exit;
    wglReleasePbufferDCEXT := wglGetProcAddress('wglReleasePbufferDCEXT');
    if not Assigned(wglReleasePbufferDCEXT) then Exit;
    wglDestroyPbufferEXT := wglGetProcAddress('wglDestroyPbufferEXT');
    if not Assigned(wglDestroyPbufferEXT) then Exit;
    wglQueryPbufferEXT := wglGetProcAddress('wglQueryPbufferEXT');
    if not Assigned(wglQueryPbufferEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_WGL_EXT_pixel_format: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
  if not Assigned(wglGetExtensionsStringARB) then Exit;
  extstring := String(PChar(wglGetExtensionsStringARB(wglGetCurrentDC)));

  if glext_ExtensionSupported('WGL_EXT_pixel_format', extstring) then
  begin
    wglGetPixelFormatAttribivEXT := wglGetProcAddress('wglGetPixelFormatAttribivEXT');
    if not Assigned(wglGetPixelFormatAttribivEXT) then Exit;
    wglGetPixelFormatAttribfvEXT := wglGetProcAddress('wglGetPixelFormatAttribfvEXT');
    if not Assigned(wglGetPixelFormatAttribfvEXT) then Exit;
    wglChoosePixelFormatEXT := wglGetProcAddress('wglChoosePixelFormatEXT');
    if not Assigned(wglChoosePixelFormatEXT) then Exit;
    Result := TRUE;
  end;

end;

function Load_WGL_I3D_digital_video_control: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
  if not Assigned(wglGetExtensionsStringARB) then Exit;
  extstring := String(PChar(wglGetExtensionsStringARB(wglGetCurrentDC)));

  if glext_ExtensionSupported('WGL_I3D_digital_video_control', extstring) then
  begin
    wglGetDigitalVideoParametersI3D := wglGetProcAddress('wglGetDigitalVideoParametersI3D');
    if not Assigned(wglGetDigitalVideoParametersI3D) then Exit;
    wglSetDigitalVideoParametersI3D := wglGetProcAddress('wglSetDigitalVideoParametersI3D');
    if not Assigned(wglSetDigitalVideoParametersI3D) then Exit;
    Result := TRUE;
  end;

end;

function Load_WGL_I3D_gamma: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
  if not Assigned(wglGetExtensionsStringARB) then Exit;
  extstring := String(PChar(wglGetExtensionsStringARB(wglGetCurrentDC)));

  if glext_ExtensionSupported('WGL_I3D_gamma', extstring) then
  begin
    wglGetGammaTableParametersI3D := wglGetProcAddress('wglGetGammaTableParametersI3D');
    if not Assigned(wglGetGammaTableParametersI3D) then Exit;
    wglSetGammaTableParametersI3D := wglGetProcAddress('wglSetGammaTableParametersI3D');
    if not Assigned(wglSetGammaTableParametersI3D) then Exit;
    wglGetGammaTableI3D := wglGetProcAddress('wglGetGammaTableI3D');
    if not Assigned(wglGetGammaTableI3D) then Exit;
    wglSetGammaTableI3D := wglGetProcAddress('wglSetGammaTableI3D');
    if not Assigned(wglSetGammaTableI3D) then Exit;
    Result := TRUE;
  end;

end;

function Load_WGL_I3D_genlock: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  wglGetExtensionsStringARB := wglGetProcAddress('wglGetExtensionsStringARB');
  if not Assigned(wglGetExtensionsStringARB) then Exit;
  extstring := String(PChar(wglGetExtensionsStringARB(wglGetCurrentDC)));

  if glext_ExtensionSupported('WGL_I3D_genlock', extstring) then
  begin
    wglEnableGenlockI3D := wglGetProcAddress('wglEnableGenlockI3D');
    if not Assigned(wglEnableGenlockI3D) then Exit;
    wglDisableGenlockI3D := wglGetProcAddress('wglDisableGenlockI3D');
    if not Assigned(wglDisableGenlockI3D) then Exit;
    wglIsEnabledGenlockI3D := wglGetProcAddress('wglIsEnabledGenlockI3D');
    if not Assigned(wglIsEnabledGenlockI3D) then Exit;
    wglGenlockSourceI3D := wglGetProcAddress('wglGenlockSourceI3D');
    if not Assigned(wglGenlockSourceI3D) then Exit;
    wglGetGenlockSourceI3D := wglGetProcAddress('wglGetGenlockSourceI3D');
    if not Assigned(wglGetGenlockSourceI3D) then Exit;
    wglGenlockSourceEdgeI3D := wglGetProcAddress('wglGenlockSourceEdgeI3D');
    if not Assigned(wglGenlockSourceEdgeI3D) then Exit;
    wglGetGenlockSourceEdgeI3D := wglGetProcAddress('wglGetGenlockSourceEdgeI3D');
    if not Assigned(wglGetGenlockSourceEdgeI3D) then Exit;
    wglGenlockSampleRateI3D := wglGetProcAddress('wglGenlockSampleRateI3D');
    if not Assigned(wglGenlockSampleRateI3D) then Exit;
    wglGetGenlockSampleRateI3D := wglGetProcAddress('wglGetGenlockSampleRateI3D');
    if not Assigned(wglGetGenlockSampleRateI3D) then Exit;
    wglGenlockSourceDelayI3D := wglGetProcAddress('wglGenlockSourceDelayI3D');
    if not Assigned(wglGenlockSourceDelayI3D) then Exit;
    wglGetGenlockSourceDelayI3D := wglGetProcAddress('wglGetGenlockSourceDelayI3D');
    if not Assigned(wglGetGenlockSourceDelayI3D) then Exit;
    wglQueryGenlockMaxSourceDelayI3D := wglGetProcAddress('wglQueryGenlockMaxSourceDelayI3D');
    if not Assigned(wglQueryGenlockMaxSourceDelayI3D) then Exit;
    Result := TRUE;
  end;

end;
{$ENDIF}

function Load_GL_ARB_matrix_palette: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_ARB_matrix_palette', extstring) then
  begin
    glCurrentPaletteMatrixARB := wglGetProcAddress('glCurrentPaletteMatrixARB');
    if not Assigned(glCurrentPaletteMatrixARB) then Exit;
    glMatrixIndexubvARB := wglGetProcAddress('glMatrixIndexubvARB');
    if not Assigned(glMatrixIndexubvARB) then Exit;
    glMatrixIndexusvARB := wglGetProcAddress('glMatrixIndexusvARB');
    if not Assigned(glMatrixIndexusvARB) then Exit;
    glMatrixIndexuivARB := wglGetProcAddress('glMatrixIndexuivARB');
    if not Assigned(glMatrixIndexuivARB) then Exit;
    glMatrixIndexPointerARB := wglGetProcAddress('glMatrixIndexPointerARB');
    if not Assigned(glMatrixIndexPointerARB) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_NV_element_array: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_element_array', extstring) then
  begin
    glElementPointerNV := wglGetProcAddress('glElementPointerNV');
    if not Assigned(glElementPointerNV) then Exit;
    glDrawElementArrayNV := wglGetProcAddress('glDrawElementArrayNV');
    if not Assigned(glDrawElementArrayNV) then Exit;
    glDrawRangeElementArrayNV := wglGetProcAddress('glDrawRangeElementArrayNV');
    if not Assigned(glDrawRangeElementArrayNV) then Exit;
    glMultiDrawElementArrayNV := wglGetProcAddress('glMultiDrawElementArrayNV');
    if not Assigned(glMultiDrawElementArrayNV) then Exit;
    glMultiDrawRangeElementArrayNV := wglGetProcAddress('glMultiDrawRangeElementArrayNV');
    if not Assigned(glMultiDrawRangeElementArrayNV) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_NV_float_buffer: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_float_buffer', extstring) then
  begin
    Result := TRUE;
  end;

end;

function Load_GL_NV_fragment_program: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_fragment_program', extstring) then
  begin
    glProgramNamedParameter4fNV := wglGetProcAddress('glProgramNamedParameter4fNV');
    if not Assigned(glProgramNamedParameter4fNV) then Exit;
    glProgramNamedParameter4dNV := wglGetProcAddress('glProgramNamedParameter4dNV');
    if not Assigned(glProgramNamedParameter4dNV) then Exit;
    glGetProgramNamedParameterfvNV := wglGetProcAddress('glGetProgramNamedParameterfvNV');
    if not Assigned(glGetProgramNamedParameterfvNV) then Exit;
    glGetProgramNamedParameterdvNV := wglGetProcAddress('glGetProgramNamedParameterdvNV');
    if not Assigned(glGetProgramNamedParameterdvNV) then Exit;
    glProgramLocalParameter4dARB := wglGetProcAddress('glProgramLocalParameter4dARB');
    if not Assigned(glProgramLocalParameter4dARB) then Exit;
    glProgramLocalParameter4dvARB := wglGetProcAddress('glProgramLocalParameter4dvARB');
    if not Assigned(glProgramLocalParameter4dvARB) then Exit;
    glProgramLocalParameter4fARB := wglGetProcAddress('glProgramLocalParameter4fARB');
    if not Assigned(glProgramLocalParameter4fARB) then Exit;
    glProgramLocalParameter4fvARB := wglGetProcAddress('glProgramLocalParameter4fvARB');
    if not Assigned(glProgramLocalParameter4fvARB) then Exit;
    glGetProgramLocalParameterdvARB := wglGetProcAddress('glGetProgramLocalParameterdvARB');
    if not Assigned(glGetProgramLocalParameterdvARB) then Exit;
    glGetProgramLocalParameterfvARB := wglGetProcAddress('glGetProgramLocalParameterfvARB');
    if not Assigned(glGetProgramLocalParameterfvARB) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_NV_primitive_restart: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_primitive_restart', extstring) then
  begin
    glPrimitiveRestartNV := wglGetProcAddress('glPrimitiveRestartNV');
    if not Assigned(glPrimitiveRestartNV) then Exit;
    glPrimitiveRestartIndexNV := wglGetProcAddress('glPrimitiveRestartIndexNV');
    if not Assigned(glPrimitiveRestartIndexNV) then Exit;
    Result := TRUE;
  end;

end;

function Load_GL_NV_vertex_program2: Boolean;
var
  extstring: String;
begin

  Result := FALSE;
  extstring := String(PChar(glGetString(GL_EXTENSIONS)));

  if glext_ExtensionSupported('GL_NV_vertex_program2', extstring) then
  begin
    Result := TRUE;
  end;

end;

function glext_LoadExtension(ext: String): Boolean;
begin

  Result := FALSE;

  if ext = 'GL_version_1_2' then Result := Load_GL_version_1_2
  else if ext = 'GL_ARB_imaging' then Result := Load_GL_ARB_imaging
  else if ext = 'GL_version_1_3' then Result := Load_GL_version_1_3
  else if ext = 'GL_ARB_multitexture' then Result := Load_GL_ARB_multitexture
  else if ext = 'GL_ARB_transpose_matrix' then Result := Load_GL_ARB_transpose_matrix
  else if ext = 'GL_ARB_multisample' then Result := Load_GL_ARB_multisample
  else if ext = 'GL_ARB_texture_env_add' then Result := Load_GL_ARB_texture_env_add
{$IFDEF Win32}
  else if ext = 'WGL_ARB_extensions_string' then Result := Load_WGL_ARB_extensions_string
  else if ext = 'WGL_ARB_buffer_region' then Result := Load_WGL_ARB_buffer_region
{$ENDIF}
  else if ext = 'GL_ARB_texture_cube_map' then Result := Load_GL_ARB_texture_cube_map
  else if ext = 'GL_ARB_depth_texture' then Result := Load_GL_ARB_depth_texture
  else if ext = 'GL_ARB_point_parameters' then Result := Load_GL_ARB_point_parameters
  else if ext = 'GL_ARB_shadow' then Result := Load_GL_ARB_shadow
  else if ext = 'GL_ARB_shadow_ambient' then Result := Load_GL_ARB_shadow_ambient
  else if ext = 'GL_ARB_texture_border_clamp' then Result := Load_GL_ARB_texture_border_clamp
  else if ext = 'GL_ARB_texture_compression' then Result := Load_GL_ARB_texture_compression
  else if ext = 'GL_ARB_texture_env_combine' then Result := Load_GL_ARB_texture_env_combine
  else if ext = 'GL_ARB_texture_env_crossbar' then Result := Load_GL_ARB_texture_env_crossbar
  else if ext = 'GL_ARB_texture_env_dot3' then Result := Load_GL_ARB_texture_env_dot3
  else if ext = 'GL_ARB_texture_mirrored_repeat' then Result := Load_GL_ARB_texture_mirrored_repeat
  else if ext = 'GL_ARB_vertex_blend' then Result := Load_GL_ARB_vertex_blend
  else if ext = 'GL_ARB_vertex_program' then Result := Load_GL_ARB_vertex_program
  else if ext = 'GL_ARB_window_pos' then Result := Load_GL_ARB_window_pos
  else if ext = 'GL_EXT_422_pixels' then Result := Load_GL_EXT_422_pixels
  else if ext = 'GL_EXT_abgr' then Result := Load_GL_EXT_abgr
  else if ext = 'GL_EXT_bgra' then Result := Load_GL_EXT_bgra
  else if ext = 'GL_EXT_blend_color' then Result := Load_GL_EXT_blend_color
  else if ext = 'GL_EXT_blend_func_separate' then Result := Load_GL_EXT_blend_func_separate
  else if ext = 'GL_EXT_blend_logic_op' then Result := Load_GL_EXT_blend_logic_op
  else if ext = 'GL_EXT_blend_minmax' then Result := Load_GL_EXT_blend_minmax
  else if ext = 'GL_EXT_blend_subtract' then Result := Load_GL_EXT_blend_subtract
  else if ext = 'GL_EXT_clip_volume_hint' then Result := Load_GL_EXT_clip_volume_hint
  else if ext = 'GL_EXT_color_subtable' then Result := Load_GL_EXT_color_subtable
  else if ext = 'GL_EXT_compiled_vertex_array' then Result := Load_GL_EXT_compiled_vertex_array
  else if ext = 'GL_EXT_convolution' then Result := Load_GL_EXT_convolution
  else if ext = 'GL_EXT_fog_coord' then Result := Load_GL_EXT_fog_coord
  else if ext = 'GL_EXT_histogram' then Result := Load_GL_EXT_histogram
  else if ext = 'GL_EXT_multi_draw_arrays' then Result := Load_GL_EXT_multi_draw_arrays
  else if ext = 'GL_EXT_packed_pixels' then Result := Load_GL_EXT_packed_pixels
  else if ext = 'GL_EXT_paletted_texture' then Result := Load_GL_EXT_paletted_texture
  else if ext = 'GL_EXT_point_parameters' then Result := Load_GL_EXT_point_parameters
  else if ext = 'GL_EXT_polygon_offset' then Result := Load_GL_EXT_polygon_offset
  else if ext = 'GL_EXT_secondary_color' then Result := Load_GL_EXT_secondary_color
  else if ext = 'GL_EXT_separate_specular_color' then Result := Load_GL_EXT_separate_specular_color
  else if ext = 'GL_EXT_shadow_funcs' then Result := Load_GL_EXT_shadow_funcs
  else if ext = 'GL_EXT_shared_texture_palette' then Result := Load_GL_EXT_shared_texture_palette
  else if ext = 'GL_EXT_stencil_two_side' then Result := Load_GL_EXT_stencil_two_side
  else if ext = 'GL_EXT_stencil_wrap' then Result := Load_GL_EXT_stencil_wrap
  else if ext = 'GL_EXT_subtexture' then Result := Load_GL_EXT_subtexture
  else if ext = 'GL_EXT_texture3D' then Result := Load_GL_EXT_texture3D
  else if ext = 'GL_EXT_texture_compression_s3tc' then Result := Load_GL_EXT_texture_compression_s3tc
  else if ext = 'GL_EXT_texture_env_add' then Result := Load_GL_EXT_texture_env_add
  else if ext = 'GL_EXT_texture_env_combine' then Result := Load_GL_EXT_texture_env_combine
  else if ext = 'GL_EXT_texture_env_dot3' then Result := Load_GL_EXT_texture_env_dot3
  else if ext = 'GL_EXT_texture_filter_anisotropic' then Result := Load_GL_EXT_texture_filter_anisotropic
  else if ext = 'GL_EXT_texture_lod_bias' then Result := Load_GL_EXT_texture_lod_bias
  else if ext = 'GL_EXT_texture_object' then Result := Load_GL_EXT_texture_object
  else if ext = 'GL_EXT_vertex_array' then Result := Load_GL_EXT_vertex_array
  else if ext = 'GL_EXT_vertex_shader' then Result := Load_GL_EXT_vertex_shader
  else if ext = 'GL_EXT_vertex_weighting' then Result := Load_GL_EXT_vertex_weighting
  else if ext = 'GL_HP_occlusion_test' then Result := Load_GL_HP_occlusion_test
  else if ext = 'GL_NV_blend_square' then Result := Load_GL_NV_blend_square
  else if ext = 'GL_NV_copy_depth_to_color' then Result := Load_GL_NV_copy_depth_to_color
  else if ext = 'GL_NV_depth_clamp' then Result := Load_GL_NV_depth_clamp
  else if ext = 'GL_NV_evaluators' then Result := Load_GL_NV_evaluators
  else if ext = 'GL_NV_fence' then Result := Load_GL_NV_fence
  else if ext = 'GL_NV_fog_distance' then Result := Load_GL_NV_fog_distance
  else if ext = 'GL_NV_light_max_exponent' then Result := Load_GL_NV_light_max_exponent
  else if ext = 'GL_NV_multisample_filter_hint' then Result := Load_GL_NV_multisample_filter_hint
  else if ext = 'GL_NV_occlusion_query' then Result := Load_GL_NV_occlusion_query
  else if ext = 'GL_NV_packed_depth_stencil' then Result := Load_GL_NV_packed_depth_stencil
  else if ext = 'GL_NV_point_sprite' then Result := Load_GL_NV_point_sprite
  else if ext = 'GL_NV_register_combiners' then Result := Load_GL_NV_register_combiners
  else if ext = 'GL_NV_register_combiners2' then Result := Load_GL_NV_register_combiners2
  else if ext = 'GL_NV_texgen_emboss' then Result := Load_GL_NV_texgen_emboss
  else if ext = 'GL_NV_texgen_reflection' then Result := Load_GL_NV_texgen_reflection
  else if ext = 'GL_NV_texture_compression_vtc' then Result := Load_GL_NV_texture_compression_vtc
  else if ext = 'GL_NV_texture_env_combine4' then Result := Load_GL_NV_texture_env_combine4
  else if ext = 'GL_NV_texture_rectangle' then Result := Load_GL_NV_texture_rectangle
  else if ext = 'GL_NV_texture_shader' then Result := Load_GL_NV_texture_shader
  else if ext = 'GL_NV_texture_shader2' then Result := Load_GL_NV_texture_shader2
  else if ext = 'GL_NV_texture_shader3' then Result := Load_GL_NV_texture_shader3
  else if ext = 'GL_NV_vertex_array_range' then Result := Load_GL_NV_vertex_array_range
  else if ext = 'GL_NV_vertex_array_range2' then Result := Load_GL_NV_vertex_array_range2
  else if ext = 'GL_NV_vertex_program' then Result := Load_GL_NV_vertex_program
  else if ext = 'GL_NV_vertex_program1_1' then Result := Load_GL_NV_vertex_program1_1
  else if ext = 'GL_ATI_element_array' then Result := Load_GL_ATI_element_array
  else if ext = 'GL_ATI_envmap_bumpmap' then Result := Load_GL_ATI_envmap_bumpmap
  else if ext = 'GL_ATI_fragment_shader' then Result := Load_GL_ATI_fragment_shader
  else if ext = 'GL_ATI_pn_triangles' then Result := Load_GL_ATI_pn_triangles
  else if ext = 'GL_ATI_texture_mirror_once' then Result := Load_GL_ATI_texture_mirror_once
  else if ext = 'GL_ATI_vertex_array_object' then Result := Load_GL_ATI_vertex_array_object
  else if ext = 'GL_ATI_vertex_streams' then Result := Load_GL_ATI_vertex_streams
{$IFDEF Win32}
  else if ext = 'WGL_I3D_image_buffer' then Result := Load_WGL_I3D_image_buffer
  else if ext = 'WGL_I3D_swap_frame_lock' then Result := Load_WGL_I3D_swap_frame_lock
  else if ext = 'WGL_I3D_swap_frame_usage' then Result := Load_WGL_I3D_swap_frame_usage
{$ENDIF}
  else if ext = 'GL_3DFX_texture_compression_FXT1' then Result := Load_GL_3DFX_texture_compression_FXT1
  else if ext = 'GL_IBM_cull_vertex' then Result := Load_GL_IBM_cull_vertex
  else if ext = 'GL_IBM_multimode_draw_arrays' then Result := Load_GL_IBM_multimode_draw_arrays
  else if ext = 'GL_IBM_raster_pos_clip' then Result := Load_GL_IBM_raster_pos_clip
  else if ext = 'GL_IBM_texture_mirrored_repeat' then Result := Load_GL_IBM_texture_mirrored_repeat
  else if ext = 'GL_IBM_vertex_array_lists' then Result := Load_GL_IBM_vertex_array_lists
  else if ext = 'GL_MESA_resize_buffers' then Result := Load_GL_MESA_resize_buffers
  else if ext = 'GL_MESA_window_pos' then Result := Load_GL_MESA_window_pos
  else if ext = 'GL_OML_interlace' then Result := Load_GL_OML_interlace
  else if ext = 'GL_OML_resample' then Result := Load_GL_OML_resample
  else if ext = 'GL_OML_subsample' then Result := Load_GL_OML_subsample
  else if ext = 'GL_SGIS_generate_mipmap' then Result := Load_GL_SGIS_generate_mipmap
  else if ext = 'GL_SGIS_multisample' then Result := Load_GL_SGIS_multisample
  else if ext = 'GL_SGIS_pixel_texture' then Result := Load_GL_SGIS_pixel_texture
  else if ext = 'GL_SGIS_texture_border_clamp' then Result := Load_GL_SGIS_texture_border_clamp
  else if ext = 'GL_SGIS_texture_color_mask' then Result := Load_GL_SGIS_texture_color_mask
  else if ext = 'GL_SGIS_texture_edge_clamp' then Result := Load_GL_SGIS_texture_edge_clamp
  else if ext = 'GL_SGIS_texture_lod' then Result := Load_GL_SGIS_texture_lod
  else if ext = 'GL_SGIS_depth_texture' then Result := Load_GL_SGIS_depth_texture
  else if ext = 'GL_SGIX_fog_offset' then Result := Load_GL_SGIX_fog_offset
  else if ext = 'GL_SGIX_interlace' then Result := Load_GL_SGIX_interlace
  else if ext = 'GL_SGIX_shadow_ambient' then Result := Load_GL_SGIX_shadow_ambient
  else if ext = 'GL_SGI_color_matrix' then Result := Load_GL_SGI_color_matrix
  else if ext = 'GL_SGI_color_table' then Result := Load_GL_SGI_color_table
  else if ext = 'GL_SGI_texture_color_table' then Result := Load_GL_SGI_texture_color_table
  else if ext = 'GL_SUN_vertex' then Result := Load_GL_SUN_vertex
  else if ext = 'GL_ARB_fragment_program' then Result := Load_GL_ARB_fragment_program
  else if ext = 'GL_ATI_text_fragment_shader' then Result := Load_GL_ATI_text_fragment_shader
  else if ext = 'GL_APPLE_client_storage' then Result := Load_GL_APPLE_client_storage
  else if ext = 'GL_APPLE_element_array' then Result := Load_GL_APPLE_element_array
  else if ext = 'GL_APPLE_fence' then Result := Load_GL_APPLE_fence
  else if ext = 'GL_APPLE_vertex_array_object' then Result := Load_GL_APPLE_vertex_array_object
  else if ext = 'GL_APPLE_vertex_array_range' then Result := Load_GL_APPLE_vertex_array_range
{$IFDEF Win32}
  else if ext = 'WGL_ARB_pixel_format' then Result := Load_WGL_ARB_pixel_format
  else if ext = 'WGL_ARB_make_current_read' then Result := Load_WGL_ARB_make_current_read
  else if ext = 'WGL_ARB_pbuffer' then Result := Load_WGL_ARB_pbuffer
  else if ext = 'WGL_EXT_swap_control' then Result := Load_WGL_EXT_swap_control
  else if ext = 'WGL_ARB_render_texture' then Result := Load_WGL_ARB_render_texture
  else if ext = 'WGL_EXT_extensions_string' then Result := Load_WGL_EXT_extensions_string
  else if ext = 'WGL_EXT_make_current_read' then Result := Load_WGL_EXT_make_current_read
  else if ext = 'WGL_EXT_pbuffer' then Result := Load_WGL_EXT_pbuffer
  else if ext = 'WGL_EXT_pixel_format' then Result := Load_WGL_EXT_pixel_format
  else if ext = 'WGL_I3D_digital_video_control' then Result := Load_WGL_I3D_digital_video_control
  else if ext = 'WGL_I3D_gamma' then Result := Load_WGL_I3D_gamma
  else if ext = 'WGL_I3D_genlock' then Result := Load_WGL_I3D_genlock
{$ENDIF}
  else if ext = 'GL_ARB_matrix_palette' then Result := Load_GL_ARB_matrix_palette
  else if ext = 'GL_NV_element_array' then Result := Load_GL_NV_element_array
  else if ext = 'GL_NV_float_buffer' then Result := Load_GL_NV_float_buffer
  else if ext = 'GL_NV_fragment_program' then Result := Load_GL_NV_fragment_program
  else if ext = 'GL_NV_primitive_restart' then Result := Load_GL_NV_primitive_restart
  else if ext = 'GL_NV_vertex_program2' then Result := Load_GL_NV_vertex_program2

end;

end.
