;   coroutine (process) handling for Modula-2

; (C) Copyright 1987 Fitted Software Tools. All rights reserved.


IFNDEF M2O
data            segment public 'data'
                public  DATA_M2PROCS
DATA_M2PROCS    equ     $
data            ends
ENDIF


code            segment 'code'
                assume  cs:code

IFNDEF M2O
                public  M2PROCS_INIT
                public  M2PROCS_NEWPROCESS
                public  M2PROCS_TRANSFER
                public  M2PROCS_IOTRANSFER
                public  M2PROCS_SETPRIO
                public  M2PROCS_RESETPRIO
ENDIF

IFDEF M2O
                dw      5               ; number of procedures
                dw      M2PROCS_INIT
                dw      M2PROCS_NEWPROCESS
                dw      M2PROCS_TRANSFER
                dw      M2PROCS_IOTRANSFER
                dw      M2PROCS_SETPRIO
                dw      M2PROCS_RESETPRIO
ENDIF


RTS             equ     0C0h            ; rts interrupt

;       These 8259 interrupt masks prevent interrupts at any priority
;       at or below the level of the active module.
;       Priority 0 is the highest, 7 is the lowest supported.

IntMask         db      0FFh, 0FEh, 0FCh, 0F8h, 0F0h, 0E0h, 0C0h, 80h


;   SETPRIO
;       AX = new priority
;       WORD [BP-4] is the save area for the current priority mask

M2PROCS_SETPRIO         proc    far
                mov     bx, ax
                in      al, 21h
                mov     [bp-4], al
                cmp     bx, 7
                ja      outOfRange
                or      al, IntMask[bx]
                out     21h, al
outOfRange:
                ret
M2PROCS_SETPRIO         endp


;   RESETPRIO
;       WORD [BP-4] is where the previous priority mask was saved

M2PROCS_RESETPRIO       proc    far
                mov     al, [bp-4]
                out     21h, al
                ret
M2PROCS_RESETPRIO       endp



;   NEWPROCESS( P :PROC; A :ADDRESS; n :CARDINAL; VAR newp :ADDRESS )
;
;       a process is the value of the saved stack pointer.
;       the stack of a new process looks like this:
;               PRIORITY mask
;               DS
;               BP
;               RET IP
;               RET CS
;               4 words pseudo args
;               STOP Return sequence: BP, IP, CS

M2PROCS_NEWPROCESS      proc    far
P               equ     word ptr [bp+16]
A               equ     word ptr [bp+12]
n               equ     word ptr [bp+10]
newp            equ     dword ptr [bp+6]

                push    bp
                mov     bp, sp

                ; A rounded up 1 para in ES
                mov     ax, A
                mov     dx, A+2
                mov     cl, 4
                shr     ax, cl
                add     dx, ax
                inc     dx
                mov     es, dx

                ; take 1 para from n in DI
                mov     di, n
                sub     di, 16

                ; if return from coroutine, stop
                sub     di, 4
                mov     ax, offset STOP
                mov     es:[di], ax
                mov     es:[di+2], cs

                ; save starting BP
                mov     n, di

                ; pseudo args for TRANSFER
                sub     di, 8

                ; start at P
                sub     di, 4
                mov     ax, P
                mov     es:[di], ax
                mov     ax, P+2
                mov     es:[di+2], ax

                ; with BP of...
                sub     di, 2
                mov     ax, n
                mov     es:[di], ax

                ; current DS
                sub     di, 2
                mov     es:[di], ds

                ; and current priority mask
                sub     di, 2
                in      al, 21h
                mov     es:[di], al

                ; now, ES:DI is starting SS:SP,
                push    ds                  ; required for LARGE model
                lds     si, newp
                mov     [si], di
                mov     [si+2], es
                pop     ds

                mov     sp, bp
                pop     bp
                ret     14

M2PROCS_NEWPROCESS      endp


;   TRANSFER( VAR p1, p2 :ADDRESS )

;       suspended process' stack:
;               PRIORITY mask
;               DS
;               BP
;               RET IP
;               RET CS
;               Args (8 bytes)

M2PROCS_TRANSFER        proc    far
tp1             equ     dword ptr [bp+10]
tp2             equ     dword ptr [bp+6]

                push    bp
                mov     bp, sp

                ; save DS
                push    DS

                ; save priority mask
                in      al, 21h
                push    ax

                ; point to args
                les     si, tp1
                lds     di, tp2

                ; get destination SS:SP
                mov     ax, [di]
                mov     dx, [di+2]

                ; save our stuff
                mov     es:[si], sp
                mov     es:[si+2], ss

                ; set stack to go to
                cli                     ; old 8088s around?
                mov     ss, dx
                mov     sp, ax
                sti

                ; and go...
                pop     ax
                out     21h, al
                pop     ds
                pop     bp
                ret     8

M2PROCS_TRANSFER        endp


IOHandlers:     ; Interrupt handlers
                rept    256
                call    near ptr IOINTERRUPT
                nop
                endm

IOProcs:        ; Pointers to processes waiting on interrupt
                dd      256 dup (0)


;   IOTRANSFER( VAR p1, p2 :ADDRESS; v :CARDINAL )

;       suspended process' stack:
;               saved VectorIP
;               saved VectorCS
;               PRIORITY mask
;               DS
;               BP
;               RET IP
;               RET CS
;               Args (10 bytes)

M2PROCS_IOTRANSFER      proc    far
iotp1           equ     dword ptr [bp+12]
iotp2           equ     dword ptr [bp+8]
v               equ     word ptr [bp+6]

                push    bp
                mov     bp, sp

                ; save DS
                push    ds

                ; save priority mask
                in      al, 21h
                push    ax

                ; get vector address
                mov     bx, v
                add     bx, bx  ; *2
                add     bx, bx  ; *4
                mov     ax, 0
                mov     es, ax
                ; and save its contents
                push    word ptr es:[bx+2]
                push    word ptr es:[bx]

                ; now load vector
                cli                     ; no interrupts, please
                mov     ax, offset IOHandlers
                add     ax, bx
                mov     word ptr es:[bx], ax
                mov     es:[bx+2], cs

                ; now do TRANSFER --- do not use BX in the process !
                ; point to args
                les     si, iotp1
                lds     di, iotp2

                ; get destination SS:SP
                mov     ax, [di]
                mov     dx, [di+2]

                ; save our stuff in p1
                mov     es:[si], sp
                mov     es:[si+2], ss
                ; in IOProcs too
                mov     word ptr IOProcs[bx], sp
                mov     word ptr IOProcs[bx+2], ss

                ; set stack to go to
                mov     ss, dx
                mov     sp, ax
                sti

                ; and go...
                pop     ax
                out     21h, al
                pop     ds
                pop     bp
                ret     8

M2PROCS_IOTRANSFER      endp


;   On Interrupt, come here

;       stack of interrupted process will look like this:
;               PRIORITY mask
;               DS
;               IOINTERRUPT BP
;               IORESUME IP
;               IORESUME CS
;               junk (8 bytes for TRANSFER args)
;               saved ES
;               ...
;               saved AX
;               BP
;               IOHandler RET
;               RET IP
;               RET CS
;               FLAGS

IOINTERRUPT     proc    far
                push    bp
                mov     bp, sp
                ; save all registers
                push    ax
                push    bx
                push    cx
                push    dx
                push    si
                push    di
                push    ds
                push    es

                mov     bx, [bp+2]      ; get int offset
                sub     bx, 3
                sub     bx, offset IOHandlers

                ; set up restore of interrupted
                sub     sp, 8           ; consumed by transfer
                push    cs
                mov     ax, offset IORESUME
                push    ax
                push    bp
                push    ds
                in      al, 21h
                push    ax

                mov     dx, sp          ; save our state
                mov     cx, ss

                mov     ss, word ptr IOProcs[bx+2]  ; get IO process
                mov     sp, word ptr IOProcs[bx]

                xor     ax, ax                  ; restore IO vector
                mov     es, ax
                pop     word ptr es:[bx]
                pop     word ptr es:[bx+2]

                pop     ax
                out     21h, al                 ; reset priority mask

                pop     ds                      ; restore DS

                mov     bp, sp                  ; restore BP

                ; finish transfer...
                les     si, iotp2

                ; save our stuff in p2
                mov     es:[si], dx
                mov     es:[si+2], cx

                sti
                pop     bp
                ret     10

IOINTERRUPT     endp


;   Resuming interrupted process

junk            dw      0

IORESUME        proc    near
                ; restore registers
                pop     es
                pop     ds
                pop     di
                pop     si
                pop     dx
                pop     cx
                pop     bx
                pop     ax

                pop     bp
                pop     cs:junk         ; return to IOHANDLERS

                iret

IORESUME        endp


;   If we return from a coroutine ...

STOP            proc    far
                mov     al, 0FFh
                mov     cx, 0       ; line number
                int     RTS
STOP            endp


M2PROCS_INIT    proc    far
                ret
M2PROCS_INIT    endp


code            ends


end
