MODULE UsePeople;

FROM InOut   IMPORT WriteString, WriteLn;
FROM People  IMPORT Person, Programmer, Gender;
FROM Objects IMPORT ALLOCATEOBJECT, DEALLOCATEOBJECT,
                    MEMBEROBJECT;

VAR
 someone         :Person;
 smartProgrammer :Programmer;

PROCEDURE DisplaySkills ( VAR Student :Person );
VAR
  P  :Programmer;
BEGIN
  IF Student.isMale()
    THEN WriteString( "He " )
    ELSE WriteString( "She " )
  END;
  IF MEMBER( Student, Programmer )
    THEN
      WriteString( "is a programmer " );
      P := Programmer( Student );
      IF P.isSmart()
        THEN WriteString( "and has learned a fine language" )
        ELSE WriteString( "but never learned Modula-2" )
      END
    ELSE WriteString( "has managed to avoid programming ")
  END;
  WriteLn;
END DisplaySkills;

BEGIN
 NEW( smartProgrammer );
 smartProgrammer.sex := female;
 DisplaySkills( smartProgrammer );

 NEW( someone );
 someone.sex := male;
 DisplaySkills( someone );

 smartProgrammer.favoriteLanguage := "Modula-2";
 DisplaySkills( smartProgrammer );

 someone := smartProgrammer;
 IF MEMBER( someone, Programmer ) & smartProgrammer.isSmart()
   THEN
     WriteString( "What a smart programmer to use Modula-2!" );
     WriteLn;
 END;
END UsePeople.
