#include <stdio.h>
#include <string.h>
#include <stdlib.h>

unsigned short blockSize;

void writeOBJHeader(FILE *f,char *name)
{
	unsigned int i,j;

	fputc(0x80,f);
	i=name?strlen(name):0;
	if(i>255)
	{
		printf("Name too long %s\n",name);
		exit(1);
	}
	fputc((i+2)&0xff,f); /* low byte of record length */
	fputc((i+2)>>8,f); /* high byte of record length */
	fputc(i,f); /* length of name */
	for(j=0;j<i;j++) fputc(name[j],f); /* name */
	fputc(0,f); /* null checksum */
}

void writeOBJClose(FILE *f)
{
	unsigned long j;

	j=ftell(f)+5; /* position of end of record by default */
	j%=blockSize;
	if(j) j=blockSize-j; /* j=size of padding required */

	fputc(0x8a,f);
	fputc((j+2)&0xff,f);/* two bytes for the mod end, plus padding*/
	fputc(((j+2)>>8)&0xff,f);

	fputc(0,f); /* null mod attribute byte */
	fputc(0,f); /* null checksum */

	while(j)
	{
		fputc(0,f);
		j--;
	}
}

void writeIMPDEF(FILE *f,char *libname,char *intname,char *name,unsigned int ordinal)
{
	unsigned int i;

	fputc(0x88,f); /* COMENT record */
	if(!libname || !intname)
	{
		printf("Must have library name and internal name for import\n");
		exit(1);
	}
	i=8+strlen(libname)+strlen(intname);
	/* 1 byte for flags */
	/* 1 byte for class, 1 byte for type, 1 byte for checksum */
	/* 1 byte for ordinal flag, 1 byte for length of libname */
	/* 1 byte for length of intname */
	/* 1 byte for length of name/first byte of ordinal */
	if(name)
	{
		i+=strlen(name);
	}
	else
	{
		i+=1;
	}
	/* i is now length of record */
	fputc(i&0xff,f); /* low byte */
	fputc((i>>8)&0xff,f); /* high byte */
	fputc(0x80,f); /* no purge */
	fputc(0xa0,f); /* extended type coment */
	fputc(1,f); /* IMPDEF record */
	if(name)
	{
		fputc(0,f); /* ordinal flag=0 =>not ordinal */
	}
	else
	{
		fputc(1,f);
	}
	fputc(strlen(intname),f); /* length of internal name */
	for(i=0;i<strlen(intname);i++) fputc(intname[i],f); /* name */
	fputc(strlen(libname),f); /* length of module name */
	for(i=0;i<strlen(libname);i++) fputc(libname[i],f); /* name */
	if(name)
	{
		fputc(strlen(name),f); /* length of imported name */
		for(i=0;i<strlen(name);i++) fputc(name[i],f); /* name */
	}
	else
	{
		fputc(ordinal &0xff,f); /* low byte of ordinal */
		fputc((ordinal>>8)&0xff,f); /* high byte of ordinal */
	}
	fputc(0,f); /* null checksum */
}

void writeLNAMES(FILE *f,char **names,int num)
{
	unsigned int i,j;

	for(i=0,j=1;i<num;i++)
	{
		if(strlen(names[i])>255)
		{
			printf("Name too long %s\n",names[i]);
			exit(1);
		}
		j+=1+strlen(names[i]);
	}

	fputc(0x96,f); /* LNAMES record */
	fputc(j&0xff,f); /* low byte of record length */
	fputc((j>>8)&0xff,f); /* high byte of record length */
	for(i=0;i<num;i++)
	{
		fputc(strlen(names[i]),f);
		for(j=0;j<strlen(names[i]);j++) fputc(names[i][j],f);
	}
	fputc(0,f);
}

void writeSEGDEF(FILE *f,int name,int class,unsigned int attr,unsigned long length)
{
	unsigned int i;

	i=9;
	if(name>0x7f) i++;
	if(class>0x7f) i++;

	fputc(0x99,f); /* SEGDEF record */
	fputc(i&0xff,f);
	fputc((i>>8)&0xff,f);
	fputc(attr,f);
	fputc(length&0xff,f);
	fputc((length>>8)&0xff,f);
	fputc((length>>16)&0xff,f);
	fputc((length>>24)&0xff,f);
	if(name>0x7f)
	{
		fputc(((name>>8)&0x7f) | 0x80,f); /* high order byte */
		fputc(name&0xff,f); /* low order byte */
	}
	else
	{
		fputc(name,f);
	}
	if(class>0x7f)
	{
		fputc(((class>>8)&0x7f) | 0x80,f); /* high order byte */
		fputc(class&0xff,f); /* low order byte */
	}
	else
	{
		fputc(class,f);
	}
	fputc(0,f); /* no overlay index */
	fputc(0,f); /* null checksum */
}

void writeLEDATA(FILE *f,int segnum,unsigned int offset,char *data,unsigned int length)
{
	unsigned int i;

	i=4+length;
	if(segnum>0x7f) i++;

	fputc(0xa0,f); /* LEDATA */
	fputc(i&0xff,f);
	fputc((i>>8)&0xff,f);
	if(segnum>0x7f)
	{
		fputc(((segnum>>8)&0x7f) | 0x80,f); /* high order byte */
		fputc(segnum&0xff,f); /* low order byte */
	}
	else
	{
		fputc(segnum,f);
	}
	fputc(offset&0xff,f);
	fputc((offset>>8)&0xff,f);
	for(i=0;i<length;i++) fputc(data[i],f);
	fputc(0,f);
}

void writePUBDEF(FILE *f,char *name,int segnum,unsigned int offset)
{
	unsigned int i;

	i=7+strlen(name);
	if(segnum>0x7f) i++;

	fputc(0x90,f); /* PUBDEF */
	fputc(i&0xff,f);
	fputc((i>>8)&0xff,f);
	fputc(0,f); /* no group */
	if(segnum>0x7f)
	{
		fputc(((segnum>>8)&0x7f) | 0x80,f); /* high order byte */
		fputc(segnum&0xff,f); /* low order byte */
	}
	else
	{
		fputc(segnum,f);
	}
	fputc(strlen(name),f);
	for(i=0;i<strlen(name);i++) fputc(name[i],f);
	fputc(offset&0xff,f);
	fputc((offset>>8)&0xff,f);
	fputc(0,f); /* no type */
	fputc(0,f); /* null checksum */
}

void writeEXTDEF(FILE *f,char *name)
{
	unsigned int i;

	i=3+strlen(name);
	fputc(0x8c,f); /* EXTDEF */
	fputc(i&0xff,f);
	fputc((i>>8)&0xff,f);
	fputc(strlen(name),f);
	for(i=0;i<strlen(name);i++) fputc(name[i],f);
	fputc(0,f); /* no type */
	fputc(0,f);
}

void writeFIXUP(FILE *f)
{
	fputc(0x9c,f); /* FIXUPP */
	fputc(5,f); /* 6 byte record */
	fputc(0,f);
	fputc(0xe4,f); /* FIXUP, 32 bit offset, seg relative */
	fputc(2,f); /* 2 bytes into LEDATA */
	fputc(0x46,f); /* LEDATA frame, external TARGET, no displacement */
	fputc(1,f); /* external index 1 */
	fputc(0,f); /* null checksum */
}

void createImpMod(FILE *f,char *name,char *libname)
{
	char *names[2]={"IMPORTS","CODE"};
	char data[6]={0xff,0x25,0,0,0,0};
	char s[256];

	strcpy(s,"__imp_");
	strcat(s,name);
	writeOBJHeader(f,name);
	writeIMPDEF(f,libname,s,name,0);
	writeLNAMES(f,names,2);
	writeSEGDEF(f,1,2,0x29,6); /* 6 byte segment called IMPORTS, class CODE */
		/* USE32, align on byte boundaries, and public */
	writeEXTDEF(f,s);
	writeLEDATA(f,1,0,data,6);
	writeFIXUP(f);
	writePUBDEF(f,name,1,0);
	writeOBJClose(f);
}

int main(int argc, char **argv)
{
	FILE *f,*s;
	char name[256];
	int i,k;
	unsigned char buf[300];
	unsigned char *section;
	char modname[256];
	unsigned long headeroffset;
	unsigned long exportaddr,objectaddr,objectseek;
	unsigned long exportsize,objectsize,nametable;
	unsigned int numobjects,numnames;
	char **nameList;
	unsigned long curPos,curHash;
	unsigned short *nameBlock;
	unsigned long j,dictStart;

    printf("ALIB v1.1 (C) Copyright 1998/9 Anthony A.J. Williams.\n");
    printf("All Rights Reserved.\n\n");

	if(argc<2 || argc>3)
	{
		printf("\nUsage: ALIB dll-name [lib-name]\n");
        printf("\nBy default, output library file has same name as dll,\n");
        printf("but with .LIB extension, and is output in current directory.\n");
        printf("If a lib filename is specified, but with no extension, .LIB is added.\n");
		exit(0);
	}
	for(i=strlen(argv[1])-1;(i>=0) &&(argv[1][i]!='\\');i--);
	i++;
	strcpy(modname,argv[1]+i);
    if(argc==3)
    {
        strcpy(name,argv[2]);
    	for(i=strlen(name)-1;(i>=0) && (name[i]!='.') && (name[i]!='\\');i--);
        if(i && name[i]!='.')
        {
            strcat(name,".lib");
        }
    }
    else
    {
        strcpy(name,argv[1]+i);
    	for(i=strlen(name)-1;(i>=0) && (name[i]!='.');i--);
	    if(i) name[i]=0;
    	strcat(name,".lib");
    }



	s=fopen(argv[1],"rb");
	if(!s)
	{
		printf("unable to open source file\n");
		exit(1);
	}

	i=fread(buf,1,0x40,s);
	if(i!=0x40)
	{
		printf("error reading MSDOS header\n");
		exit(1);
	}

	if((buf[0]!=0x4d) || (buf[1]!=0x5a))
	{
		printf("bad MSDOS header\n");
		exit(1);
	}
	headeroffset=buf[0x3c]+(buf[0x3d]<<8)+(buf[0x3e]<<16)+(buf[0x3f]<<24);
	fseek(s,headeroffset,SEEK_SET);
	i=fread(buf,1,0xf8,s);
	if(i!=0xf8)
	{
		printf("error reading PE header\n");
		exit(1);
	}

	if((buf[0]!=0x50) || (buf[1]!=0x45) || (buf[2] | buf[3]))
	{
		printf("Bad PE header\n");
		exit(1);
	}

	exportaddr=buf[0x78]+(buf[0x79]<<8)+(buf[0x7a]<<16)+(buf[0x7b]<<24);
	exportsize=buf[0x7c]+(buf[0x7d]<<8)+(buf[0x7e]<<16)+(buf[0x7f]<<24);

	if(!exportaddr || !exportsize)
	{
		printf("no exports\n");
		exit(1);
	}

	numobjects=buf[6]+(buf[7]<<8);

	if(!numobjects)
	{
		printf("no sections\n");
		exit(1);
	}

	for(i=0;i<numobjects;i++)
	{
		j=fread(buf,1,0x28,s);
		if(j!=0x28)
		{
			printf("error reading section %i\n",i);
			exit(1);
		}
		objectaddr=buf[0xc]+(buf[0xd]<<8)+(buf[0xe]<<16)+(buf[0xf]<<24);
		objectsize=buf[0x10]+(buf[0x11]<<8)+(buf[0x12]<<16)+(buf[0x13]<<24);
		if((objectaddr<=exportaddr) && ((objectaddr+objectsize)>exportaddr))
			break;
	}
	if(i==numobjects)
	{
		printf("export section not found\n");
		exit(1);
	}

	objectseek=buf[0x14]+(buf[0x15]<<8)+(buf[0x16]<<16)+(buf[0x17]<<24);

	objectseek+=(exportaddr-objectaddr); /* update seek to start of export data */
	objectsize-=(exportaddr-objectaddr); /* reduce size of data */
	if(objectsize<exportsize)
	{
		printf("export section not big enough\n");
		exit(1); /* exit if table size less than expected */
	}

	section=(unsigned char *)malloc(objectsize);
	if(!section)
	{
		printf("unable to allocate memory\n");
		exit(1);
	}

	fseek(s,objectseek,SEEK_SET);
	i=fread(section,1,objectsize,s);
	if(i!=objectsize)
	{
		printf("unable to read export section from offset %i\n",objectseek);
		exit(1);
	}
	fclose(s);

	numnames=section[0x18]+(section[0x19]<<8)+(section[0x1a]<<16)+(section[0x1b]<<24);
	nametable=section[0x20]+(section[0x21]<<8)+(section[0x22]<<16)+(section[0x23]<<24);
	nametable-=exportaddr; /* get offset into export section */
	if(nametable>objectsize)
	{
		printf("name table out of section, at %i\n",nametable);
		exit(1); /* exit if out of range */
	}

	printf("%i exports in %s\n",numnames,argv[1]);

	nameList=(char**)malloc(sizeof(char*)*2*numnames);
	if(!nameList)
	{
		printf("out of memory\n");
		exit(1);
	}

	nameBlock=(unsigned short *)malloc(sizeof(unsigned short)*2*numnames);
	if(!nameBlock)
	{
		printf("out of memory\n");
		exit(1);
	}

	f=fopen(name,"wb");
	if(!f)
	{
		printf("Unable to open output file %s\n",name);
		exit(1);
	}

    /* max blocks=65535 */
    blockSize=(1024*numnames)/65535; /* 1024 ~= max module size */
    if((1024*numnames)%65535) blockSize++;
    if(blockSize<16) blockSize=16;

    i=0x4000; /* bit 14 set */
    while(i)
    {
	if(blockSize&i) /* found a bit set */
	{
	    blockSize+=i-1; /* round up */
	    blockSize&=(0xffff-(i-1)); /* do rounding */
	    break;
	}
	i>>=1;
    }

    fputc(0xf0,f); /* MSLIB */
	fputc((blockSize-3)&0xff,f);
	fputc(((blockSize-3)>>8)&0xff,f);

	for(i=0;i<(blockSize-3);i++) fputc(0,f);

	for(i=0;i<numnames;i++,nametable+=4)
	{
		curPos=ftell(f);
		j=section[nametable]+(section[nametable+1]<<8)+
			(section[nametable+2]<<16)+(section[nametable+3]<<24);
		j-=exportaddr;
		if(!f)
		{
			printf("unable to open file %s for output\n",name);
			exit(1);
		}
		createImpMod(f,section+j,modname);
		nameList[i*2]=strdup(section+j);
		if(!nameList[i*2])
		{
			printf("out of memory\n");
			exit(1);
		}
		nameList[i*2+1]=(char*)malloc(strlen(section+j)+1+6);
		if(!nameList[i*2+1])
		{
			printf("out of memory\n");
			exit(1);
		}
		strcpy(nameList[i*2+1],"__imp_");
		strcat(nameList[i*2+1],section+j);
		nameBlock[2*i]=nameBlock[2*i+1]=curPos/blockSize;
	}
	j=ftell(f); /* get current position */
	j+=3; /* move passed LIBEND record */
	j%=512;
	if(j) j=512-j; /* j= number of bytes left until 512 byte boundary */
	fputc(0xf1,f); /* MSLIBEND */
	fputc(j&0xff,f);
	fputc((j>>8)&0xff,f);
	while(j)
	{
		fputc(0,f);
		j--;
	}
	j=ftell(f); /* get dictionary offset */
	fseek(f,3,SEEK_SET);
	fputc(j&0xff,f);
	fputc((j>>8)&0xff,f);
	fputc((j>>16)&0xff,f);
	fputc((j>>24)&0xff,f);
	fseek(f,j,SEEK_SET);
	dictStart=j;
	curPos=38;
	curHash=0;
	for(i=0;i<(numnames*2);i++)
	{
		if(curHash==37)
		{
			curPos=512-curPos;
			while(curPos)
			{
				fputc(0,f);
				curPos--;
			}
			curHash=0;
			curPos=38;
			j=ftell(f);
		}
		if((512-curPos)<(strlen(nameList[i])+3))
		{
			fseek(f,j+37,SEEK_SET);
			fputc(0xff,f);
			fseek(f,j+curPos,SEEK_SET);
			curPos=512-curPos;
			while(curPos)
			{
				fputc(0,f);
				curPos--;
			}
			curHash=0;
			curPos=38;
			j=ftell(f);
		}
		fseek(f,j+curHash,SEEK_SET);
		fputc(curPos/2,f);
		fseek(f,j+curPos,SEEK_SET);
		fputc(strlen(nameList[i]),f);
		curPos++;
		for(k=0;nameList[i][k];k++,curPos++)
		{
			fputc(nameList[i][k],f);
		}
		fputc(nameBlock[i]&0xff,f);
		fputc((nameBlock[i]>>8)&0xff,f);
		curPos+=2;
		if(curPos&1)
		{
			curPos++;
			fputc(0,f);
		}
		fseek(f,j+37,SEEK_SET);
		fputc(curPos/2,f);
		fseek(f,j+curPos,SEEK_SET);
		curHash++;
	}
	curPos=512-curPos;
	while(curPos)
	{
		fputc(0,f);
		curPos--;
	}
	j=ftell(f)-dictStart;
	j/=512;
	fseek(f,7,SEEK_SET);
	fputc(j&0xff,f);
	fputc((j>>8)&0xff,f);
	fputc(1,f);
	fclose(f);
    return 0;
}
