// ͻ
//    TEST-PROGRAM FOR THE VESA GRAPHICS LIBRARY 1.4 FOR PACIFIC-C    
// Ķ
//           (C) Detlef Reimers, JUNE 1999, dreimers@aol.com          
// ͼ
#include <vesa.h>

// Ŀ
//  Global strings.                                                   
// 
char * info[4] =
{
  "STEPWISE REFINEMENT OF BEZIER CURVES",
  "MODE %d: %dx%d",
  "BEZIER(%d, LGREEN)",
  "2^%d = %d SEGMENTS"
};

// Ŀ
//  SCREEN: Set up a screen frame and a title.                        
// 
void screen(void)
{
  int k;

  k = hor - 141 - 8*(hor/1000) - 8*(ver/1000);

  setcol(blue, 0, 23, 35);
  rect (0    , 0, hor - 1, ver - 1, lwhite);
  hline(20   , 1, hor - 1, lwhite);
  frect(1    , 1, hor - 2, 19, blue);
  print(5    , 7, lwhite, 16, info[0]);
  print(k    , 7, lwhite, 16, info[1], mode, hor, ver);
}

// Ŀ
//  SETPOINTS: This sets the bezier points.                           
// 
void setpoints(int n)
{
  if (n == 1)
  {
    bez[0][0] =     hor/8;  bez[0][1] =     ver/4;
    bez[1][0] =   1*hor/8;  bez[1][1] =   6*ver/8;
    bez[2][0] =   7*hor/8;  bez[2][1] =   2*ver/8;
    bez[3][0] =   3*hor/4;  bez[3][1] =   7*ver/8;
  }

  if (n == 2)
  {
    bez[0][0] =  6*hor/16;  bez[0][1] = 14*ver/16;
    bez[1][0] = 14*hor/16;  bez[1][1] =  3*ver/16;
    bez[2][0] =  1*hor/16;  bez[2][1] =  2*ver/16;
    bez[3][0] =  9*hor/16;  bez[3][1] = 14*ver/16;
  }
  
  if (n == 3)
  {
    bez[0][0] =  6*hor/16;  bez[0][1] = 14*ver/16;
    bez[1][0] =  1*hor/16;  bez[1][1] = 11*ver/16;
    bez[2][0] = 15*hor/16;  bez[2][1] =  2*ver/16;
    bez[3][0] = 12*hor/16;  bez[3][1] = 14*ver/16;
  }
}

// Ŀ
//  POINTS: This draws circles around the bezier points.              
// 
void points(void)
{
  fcircle(bez[0][0], bez[0][1], 2, 40);
  circle (bez[0][0], bez[0][1], 3, yellow);
  fcircle(bez[1][0], bez[1][1], 3, lblue);
  fcircle(bez[2][0], bez[2][1], 3, lblue);
  fcircle(bez[3][0], bez[3][1], 2, 40);
  circle (bez[3][0], bez[3][1], 3, yellow);
}

// Ŀ
//  HANDLES: This draws the bezier handles.                           
// 
void handles(void)
{
  line(bez[0][0], bez[0][1], bez[1][0], bez[1][1], 4);
  line(bez[2][0], bez[2][1], bez[3][0], bez[3][1], 4);
}

// Ŀ
//  DEMO: This function draws the bezier curve. It uses a very fast   
//        algorithm whithout any multiplications.                     
// 
void demo(int mode)
{
  int i, n;

  gmode(mode);
  setcol(blue, 0, 23, 35);
  
  for (n = 1; n < 4; n++)
  {
    clear(black);
    screen();
    setpoints(n);

    for (i = 0; i < 8; i++)
    {
      if (i > 0)
      {
        if (i > 1)
          bezier(i-2, black);
        bezier(i-1, black);
        bezier(i-1, 32);
      }
      handles();
      bezier(i, 47);
      points();
      frect(hor/2 - 76, 64, hor/2 + 76, 82, black);
      print(hor/2 - 70, 70, yellow, 0, info[2], i);
      frect(hor/2 - 76, 84, hor/2 + 76, 102, black);
      print(hor/2 - 70, 90, lwhite, 0, info[3], i, 1 << i);
      
      waitkey();
    }
  }
}

// Ŀ
//  Main: It runs the demo function at several resolutions.           
// 
void main(void)
{
  demo(257);
  demo(259);
  demo(261);

  tmode();
}

